/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.graph.pfj.CategoryIF;
import oracle.dss.graph.pfj.Perspective;

public class DataChunk
implements Serializable {
    static final CategoryIF LOG = Perspective.getInstance("DATA.DataChunk");
    public static final int ROWS_PER_CHUNK = 16;
    public static final int COLS_PER_CHUNK = 16;
    private int m_page;
    private int m_rowStart;
    private int m_colStart;
    private Object[][] m_cells;

    public DataChunk(int n, int n2, int n3) {
        int n4 = n2 / 16 * 16;
        int n5 = n3 / 16 * 16;
        this.m_page = n;
        this.m_rowStart = n4;
        this.m_colStart = n5;
        this.m_cells = new Object[16][16];
    }

    public DataChunk(DataChunk dataChunk) {
        this.m_page = dataChunk.m_page;
        this.m_rowStart = dataChunk.m_rowStart;
        this.m_colStart = dataChunk.m_colStart;
        this.m_cells = new Object[16][16];
        int n = 0;
        while (n < 16) {
            int n2 = 0;
            while (n2 < 16) {
                Object object = dataChunk.m_cells[n][n2];
                if (object != null) {
                    if (object instanceof Number) {
                        this.m_cells[n][n2] = new Double(((Number)object).doubleValue());
                    } else if (object instanceof String) {
                        this.m_cells[n][n2] = (String)object;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    public boolean contains(int n, int n2, int n3) {
        boolean bl = n == this.m_page && n2 >= this.m_rowStart && n2 < this.m_rowStart + 16 && n3 >= this.m_colStart && n3 < this.m_colStart + 16;
        return bl;
    }

    public void dumpChunk() {
        int n = 0;
        while (n < 16) {
            int n2 = 0;
            while (n2 < 16) {
                if (this.m_cells[n][n2] != null) {
                    LOG.info(String.valueOf(String.valueOf("(")) + this.m_page + "," + (n + this.m_rowStart) + "," + (n2 + this.m_colStart) + "): " + this.m_cells[n][n2].toString());
                }
                ++n2;
            }
            ++n;
        }
    }

    public Object getData(int n, int n2) {
        return this.m_cells[n - this.m_rowStart][n2 - this.m_colStart];
    }

    public boolean isOnPage(int n) {
        return n == this.m_page;
    }

    public void setData(int n, int n2, Object object) {
        this.m_cells[n - this.m_rowStart][n2 - this.m_colStart] = object;
    }

    public String toString() {
        return String.valueOf(String.valueOf("Chunk(")) + this.m_page + "," + this.m_rowStart + "," + this.m_colStart + ")";
    }
}

