/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.NYDescriptor;
import oracle.dss.graph.pfj.Perspective;

public class AxisSplits {
    protected static final int Y1 = 0;
    protected static final int Y2 = 1;
    protected static final int Y3 = 2;
    protected static final int Y4 = 3;
    protected static final int Y5 = 4;
    protected static final int NUM_Y_AXES = 5;
    Perspective m_Perspective;
    protected int[] m_offsetArray;
    protected int[] m_sizeArray;

    public AxisSplits(Perspective perspective) {
        this.m_Perspective = perspective;
    }

    public int[] getAxisOffsets() {
        return this.m_offsetArray;
    }

    public int[] getAxisSizes() {
        return this.m_sizeArray;
    }

    public void calc() {
        int n = this.m_Perspective.getAxisSize(this.m_Perspective.getY1Axis());
        int n2 = this.m_Perspective.getAxisSize(this.m_Perspective.getY2Axis());
        int n3 = this.m_Perspective.getAxisSize(this.m_Perspective.getY3Axis());
        int n4 = this.m_Perspective.getAxisSize(this.m_Perspective.getY4Axis());
        int n5 = this.m_Perspective.getAxisSize(this.m_Perspective.getY5Axis());
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        if (jGraphType.isThreeY()) {
            boolean[] blArray = NYDescriptor.usageValuesThreeY;
            if (n == 0 && n2 == 0 && n3 == 0) {
                this.setMultiYDefaultSplits(blArray);
            } else {
                this.setThreeYSplits(blArray);
            }
        } else if (jGraphType.isFourY()) {
            boolean[] blArray = NYDescriptor.usageValuesFourY;
            if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
                this.setMultiYDefaultSplits(blArray);
            } else {
                this.setFourYSplits(blArray);
            }
        } else if (jGraphType.isFiveY()) {
            boolean[] blArray = NYDescriptor.usageValuesFiveY;
            if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0) {
                this.setMultiYDefaultSplits(blArray);
            } else {
                this.setFourYSplits(blArray);
                this.m_sizeArray[4] = this.m_Perspective.getAxisSize(this.m_Perspective.getY5Axis());
                this.m_offsetArray[4] = this.m_Perspective.getAxisOffset(this.m_Perspective.getY5Axis());
            }
        } else {
            boolean[] blArray = NYDescriptor.usageValuesTwoY;
            NYDescriptor nYDescriptor = new NYDescriptor(blArray);
            if (jGraphType.isBipolar()) {
                this.setBipolarSplits(blArray);
            } else {
                this.setShareSpaceSplits(blArray);
            }
        }
    }

    protected void setThreeYSplits(boolean[] blArray) {
        this.m_offsetArray = new int[blArray.length];
        this.m_offsetArray[0] = this.m_Perspective.getAxisOffset(this.m_Perspective.getY1Axis());
        this.m_offsetArray[1] = this.m_Perspective.getAxisOffset(this.m_Perspective.getY2Axis());
        this.m_offsetArray[2] = this.m_Perspective.getAxisOffset(this.m_Perspective.getY3Axis());
        this.m_sizeArray = new int[blArray.length];
        this.m_sizeArray[0] = this.m_Perspective.getAxisSize(this.m_Perspective.getY1Axis());
        this.m_sizeArray[1] = this.m_Perspective.getAxisSize(this.m_Perspective.getY2Axis());
        this.m_sizeArray[2] = this.m_Perspective.getAxisSize(this.m_Perspective.getY3Axis());
    }

    protected void setFourYSplits(boolean[] blArray) {
        this.setThreeYSplits(blArray);
        this.m_sizeArray[3] = this.m_Perspective.getAxisSize(this.m_Perspective.getY4Axis());
        this.m_offsetArray[3] = this.m_Perspective.getAxisOffset(this.m_Perspective.getY4Axis());
    }

    protected void setBipolarSplits(boolean[] blArray) {
        int n;
        this.m_offsetArray = new int[blArray.length];
        this.m_sizeArray = new int[blArray.length];
        this.m_offsetArray[0] = n = this.m_Perspective.getDualAxisSplitPosition();
        this.m_sizeArray[0] = 100 - this.m_offsetArray[0];
        this.m_offsetArray[1] = 0;
        this.m_sizeArray[1] = 100 - this.m_sizeArray[0];
    }

    protected void setShareSpaceSplits(boolean[] blArray) {
        this.m_offsetArray = new int[blArray.length];
        this.m_sizeArray = new int[blArray.length];
        int n = 0;
        while (n < this.m_offsetArray.length) {
            this.m_offsetArray[n] = 0;
            this.m_sizeArray[n] = 100;
            ++n;
        }
    }

    protected void setMultiYDefaultSplits(boolean[] blArray) {
        NYDescriptor nYDescriptor = new NYDescriptor(blArray);
        this.m_offsetArray = new int[blArray.length];
        this.m_sizeArray = new int[blArray.length];
        int n = 0;
        while (n < blArray.length) {
            this.m_sizeArray[n] = (int)((float)100 * nYDescriptor.getSize(n));
            this.m_offsetArray[n] = (int)((float)100 * nYDescriptor.getOffset(n));
            ++n;
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

