/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.CategoryIF;
import oracle.dss.graph.pfj.CircularAxisObj;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SmartAxisBase;
import oracle.dss.graph.pfj.TDGNestedLabel;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.event.TDGEventManager;

public abstract class AxisObj
implements Serializable {
    static final CategoryIF LOG = Perspective.getInstance("AXIS.AxisObj");
    protected static final int kNOSKIP = 0;
    protected static final int kAUTOSKIP = 1;
    protected static final int kMANUALSKIP = 2;
    protected static final int GRID_TICK_NORMAL = 0;
    protected static final int GRID_TICK_NORMAL_WITH_TICK = 1;
    protected static final int GRID_TICK_INSIDE = 2;
    protected static final int GRID_TICK_OUTSIDE = 3;
    protected static final int GRID_TICK_SPANNING = 4;
    protected static final int MAX_TITLE_HEIGHT = 2300;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_TOPLEFT = 2;
    public static final int ALIGN_TOP = 3;
    public static final int ALIGN_TOPRIGHT = 4;
    public static final int ALIGN_RIGHT = 5;
    public static final int ALIGN_BOTTOMRIGHT = 6;
    public static final int ALIGN_BOTTOM = 7;
    public static final int ALIGN_BOTTOMLEFT = 8;
    protected static final int AXISSIDE_LEFT = 0;
    protected static final int AXISSIDE_RIGHT = 1;
    protected static final int AXISSIDE_BOTH = 2;
    protected static final int CENTER_LINE_MISC_OFFSET = 1000;
    protected static final int NEXTLEVEL_LINE_MISC_OFFSET = 2000;
    protected static final int LEVEL_MISC_OFFSET = 1000;
    protected Perspective m_Perspective;
    protected Access m_Access;
    protected AxisTemplate m_template;
    protected boolean m_bAscending;
    protected int m_numSeries;
    protected int m_numGroups;
    protected int m_numTotalSeries;
    protected int m_numTotalGroups;
    protected boolean m_bReverseGroups;
    protected boolean m_bReverseSeries;
    protected int m_nAxisObjectID;
    protected boolean m_bDelayGridCalc;
    protected boolean m_bDrawGrids;
    protected double m_fAxisLengthRel;
    protected double m_fAxisPositionRel;
    protected boolean m_bDelayCalcLabels;
    protected int m_nAutoSkip;
    protected int m_nLabelBegin;
    protected int m_nSkipFactor;
    protected boolean m_bSkippedLabels;
    protected int m_axisLabelTextSizeVC;
    protected int m_nOrdinalAxisType;
    protected int m_nNestingLevel;
    protected int m_nTopNestingLevel;
    protected boolean m_bNestedLabelBrackets;
    protected TDGNestedLabel m_cbO1Labels;
    protected SmartAxisBase m_SmartAxis;
    JGraphType m_gt;

    public AxisObj(Perspective perspective, Access access, AxisTemplate axisTemplate, boolean bl, int n, int n2) {
        this.m_Perspective = perspective;
        this.m_gt = this.m_Perspective.getJGraphType();
        this.m_Access = access;
        this.m_template = axisTemplate;
        this.m_bAscending = bl;
        this.m_numSeries = access.getNumNonIgnoredSeries();
        this.m_numGroups = access.getNumGroups();
        this.m_numTotalSeries = access.getNumTotalSeries();
        this.m_numTotalGroups = access.getNumTotalGroups();
        this.m_bReverseGroups = this.m_Perspective.getReverseGroups();
        this.m_bReverseSeries = this.m_Perspective.getReverseSeries();
        this.m_nAxisObjectID = this.m_template.getAxis().getObjectID();
        this.m_fAxisLengthRel = (double)n2 / 100.0;
        this.m_fAxisPositionRel = (double)n / 100.0;
        this.m_bDelayCalcLabels = false;
        this.m_bDrawGrids = true;
        this.m_axisLabelTextSizeVC = this.m_Perspective.getAxisTextAutofitMin();
        if (this.m_axisLabelTextSizeVC <= 10) {
            this.m_axisLabelTextSizeVC = 10;
        }
        this.m_nNestingLevel = 0;
        this.m_cbO1Labels = this.m_Perspective.getO1LabelCallBack();
        this.m_nTopNestingLevel = this.isO1WithNestedLabels() ? this.m_cbO1Labels.getNumLevels() - 1 : 0;
        this.m_bNestedLabelBrackets = this.m_Perspective.getDisplay(this.m_Perspective.getNestedO1LabelLine());
        this.m_SmartAxis = new SmartAxisBase();
    }

    public void calc() {
        boolean bl;
        this.m_SmartAxis.preCalc(this, this.m_Perspective);
        if (!this.m_bDelayCalcLabels) {
            try {
                this.calcLabels();
            }
            catch (Throwable throwable) {
                LOG.warn(String.valueOf(String.valueOf("Exception during label draw, id = ")) + this.m_template.getLabel());
            }
        }
        if (this.m_bDrawGrids && !(bl = this.m_SmartAxis.calcGrids())) {
            this.calcGrids();
        }
    }

    protected void calcGrids() {
        int n;
        int n2;
        SimpleBlackBoxObj simpleBlackBoxObj;
        int n3 = this.getNumMajorGrids();
        if (!this.m_bDrawGrids) {
            return;
        }
        if (this.getMinorGridDisplay(this.m_template)) {
            simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, this.m_template.getMinor(), true);
            int n4 = -3;
            double d = 0.0;
            n2 = this.getNumMinorGrids();
            IdentObj identObj = new IdentObj(this.m_template.getMinor());
            n = -1;
            while (n <= n3) {
                int n5 = 0;
                while (n5 < n2) {
                    IdentObj identObj2 = new IdentObj(identObj);
                    identObj2.setMiscID(n4++);
                    d = this.getMinorGridPos(n, n5);
                    if (d > 0.0 && d < 1.0) {
                        this.calcMinorGridLine(identObj2, d, simpleBlackBoxObj);
                    }
                    ++n5;
                }
                ++n;
            }
        }
        if (this.getMajorGridDisplay(this.m_template)) {
            simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, this.m_template.getMajor(), true);
            IdentObj identObj = new IdentObj(this.m_template.getMajor());
            boolean bl = false;
            boolean bl2 = false;
            int n6 = 0;
            while (n6 < n3) {
                n2 = 1;
                if ((this.m_nAutoSkip == 1 || this.m_nAutoSkip == 2) && this.m_bSkippedLabels) {
                    n2 = n6 >= this.m_nLabelBegin && (n6 - this.m_nLabelBegin) % (this.m_nSkipFactor + 1) == 0 ? 1 : 0;
                }
                int n7 = n = this.m_Perspective.getIgnoreGridSkip() || this.m_template.isNumeric() ? 1 : 0;
                if (n != 0) {
                    n2 = 1;
                }
                if (this.isO1WithNestedLabels()) {
                    Vector vector;
                    n2 = 0;
                    if (this.m_cbO1Labels.getNumLevels() > 1 && (vector = this.m_cbO1Labels.getAllLabels(1)).size() > 1) {
                        int n8 = 1;
                        while (n8 < vector.size()) {
                            if (this.m_cbO1Labels.getParentIndex(n8, 1) == n6) {
                                n2 = 1;
                            }
                            ++n8;
                        }
                    }
                }
                if (n2 != 0) {
                    IdentObj identObj3 = new IdentObj(identObj);
                    identObj3.setMiscID(n6 - 3);
                    this.calcMajorGridLine(identObj3, this.getMajorGridPos(n6), simpleBlackBoxObj);
                }
                ++n6;
            }
        }
    }

    protected void calcLabels() {
        if (!this.m_Perspective.getDisplay(this.m_template.getLabel())) {
            return;
        }
        int n = this.getNumLabels();
        if (n <= 0) {
            return;
        }
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        int n2 = this.getAxisSide();
        IdentObj identObj = this.m_template.getLabel();
        boolean bl = this.m_Perspective.getAutofit(identObj);
        int n3 = this.m_Perspective.getAutoSkip(identObj);
        if (this.isO1WithNestedLabels()) {
            this.drawNestedO1Labels(graphics, n2);
            return;
        }
        Vector vector = new Vector(n);
        Vector vector2 = this.getLabels();
        PfjAssert.pfjAssert(vector2.size() == n);
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = this.m_Perspective.getFontSizeAbsolute(identObj);
        int n6 = bl2 ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
        int n7 = this.m_Perspective.getTextRotation(identObj);
        int n8 = 0;
        if (!this.isVertical() && n7 != 0 || this.isVertical() && n7 == 0) {
            n8 = 1;
        } else if (this.isVertical() && n7 == 1) {
            n8 = 2;
        }
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl2, this.m_Perspective.getFontSize(identObj), n6, n7, this.m_Perspective.getTextJustHoriz(identObj), n8, false, false, this.m_Perspective.getTextWrap(identObj));
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        Vector vector3 = this.getRelLabelPos(n);
        int n9 = this.m_Perspective.getO1LabelAutoAngle();
        if (n9 != 0 && !this.isVertical()) {
            n3 = this.O1LabelAutoRotate(graphics, 0, n, vector, vector3, blackBoxObj, bl, n3, n4, n5, n6, textStyleObj, vector2);
        }
        switch (n3) {
            case 2: {
                this.m_bSkippedLabels = true;
                this.calcLabelsManualSkip(n2, n, vector3, n6, textStyleObj, graphics, bl, n3, blackBoxObj);
                break;
            }
            case 1: {
                this.m_bSkippedLabels = this.calcLabelsAutoSkip(n2, n, vector3, n6, textStyleObj, graphics, bl, n3, blackBoxObj);
                break;
            }
            default: {
                this.m_bSkippedLabels = false;
                this.calcLabelsNoSkip(n2, n, vector3, n6, textStyleObj, graphics, bl, n3, blackBoxObj, vector, vector2);
            }
        }
    }

    private void calcLabelsNoSkip(int n, int n2, Vector vector, int n3, TextStyleObj textStyleObj, Graphics graphics, boolean bl, int n4, BlackBoxObj blackBoxObj, Vector vector2, Vector vector3) {
        int n5 = 0;
        int n6 = 0;
        Vector vector4 = this.getLabelIdents();
        if ((n == 0 || n == 2) && this.isAxisLabelVisible(0)) {
            this.calcLabelsOneSide(graphics, 0, n2, vector2, vector, blackBoxObj, bl, n4, n5, n6, n3, textStyleObj, vector3, vector4);
        }
        if (this.m_SmartAxis.isInQALabelMode()) {
            n2 = vector3.size();
        }
        if ((n == 1 || n == 2) && this.isAxisLabelVisible(1)) {
            this.calcLabelsOneSide(graphics, 1, n2, vector2, vector, blackBoxObj, bl, n4, n5, n6, n3, textStyleObj, vector3, vector4);
        }
    }

    private boolean calcLabelsAutoSkip(int n, int n2, Vector vector, int n3, TextStyleObj textStyleObj, Graphics graphics, boolean bl, int n4, BlackBoxObj blackBoxObj) {
        boolean bl2 = false;
        if (this.m_template.isNumeric() || !(this instanceof Axis2DObj) || !this.isO1Axis()) {
            bl2 = this.calcLabelsAutoSkip3D(n, n2, vector, n3, textStyleObj, graphics, bl, n4, blackBoxObj);
        } else {
            if ((n == 0 || n == 2) && this.isAxisLabelVisible(0)) {
                bl2 = this.isVertical() ? this.calcLabelsAutoSkipFrameHeight(n, n2, vector, n3, textStyleObj, graphics, bl, n4, blackBoxObj) : this.calcLabelsAutoSkipFrameWidth(n, n2, vector, n3, textStyleObj, graphics, bl, n4, blackBoxObj);
            }
            if ((n == 1 || n == 2) && this.isAxisLabelVisible(1)) {
                bl2 = this.isVertical() ? this.calcLabelsAutoSkipFrameHeight(n, n2, vector, n3, textStyleObj, graphics, bl, n4, blackBoxObj) : this.calcLabelsAutoSkipFrameWidth(n, n2, vector, n3, textStyleObj, graphics, bl, n4, blackBoxObj);
            }
        }
        return bl2;
    }

    private boolean calcLabelsAutoSkip3D(int n, int n2, Vector vector, int n3, TextStyleObj textStyleObj, Graphics graphics, boolean bl, int n4, BlackBoxObj blackBoxObj) {
        boolean bl2 = false;
        Vector vector2 = new Vector(n2);
        Vector vector3 = this.getLabels();
        Vector vector4 = this.getLabelIdents();
        Vector vector5 = new Vector(n2);
        Vector vector6 = null;
        if (!this.m_template.isNumeric()) {
            vector6 = new Vector(n2);
        }
        Vector vector7 = new Vector(n2);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 25;
        boolean bl3 = this.m_Perspective.getTestLabelCalc();
        this.m_Perspective.setTestLabelCalc(true);
        int n10 = 0;
        while (n10 < n9) {
            ++n10;
            vector5.removeAllElements();
            if (vector6 != null) {
                vector6.removeAllElements();
            }
            vector7.removeAllElements();
            n7 = 0;
            int n11 = 0;
            while (n11 < n2) {
                vector5.addElement(vector3.elementAt(n11));
                if (vector6 != null) {
                    vector6.addElement(vector4.elementAt(n11));
                }
                vector7.addElement(vector.elementAt(n11));
                ++n7;
                ++n11;
            }
            n8 = this.calcLabelsOneSide(graphics, n, n7, vector2, vector7, blackBoxObj, bl, n4, n5, n6, n3, textStyleObj, vector5, vector6);
            if (n8 != 0) {
                n5 = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > n2 - 1) {
                    n5 = n2 - 1;
                }
                if (n6 == 0) {
                    n5 = 0;
                }
                if (n5 > n6) {
                    n5 = 0;
                }
                bl2 = true;
                vector5.removeAllElements();
                if (vector6 != null) {
                    vector6.removeAllElements();
                }
                vector7.removeAllElements();
                n7 = 0;
                n11 = 0;
                while (n11 < n2) {
                    if (n11 >= n5 && (n11 - n5) % (n6 + 1) == 0) {
                        vector5.addElement(vector3.elementAt(n11));
                        if (vector6 != null) {
                            vector6.addElement(vector4.elementAt(n11));
                        }
                        vector7.addElement(vector.elementAt(n11));
                        ++n7;
                    }
                    ++n11;
                }
                n8 = this.calcLabelsOneSide(graphics, n, n7, vector2, vector7, blackBoxObj, bl, n4, n5, n6, n3, textStyleObj, vector5, vector6);
            }
            int n12 = n11 = textStyleObj.getRotationAngle() != 0 ? 1 : 0;
            if (this.isVertical() ? (n11 != 0 ? n8 != 2 && n8 != 3 : n8 != 1 && n8 != 3) : (n11 != 0 ? n8 != 1 && n8 != 3 : n8 != 2 && n8 != 3)) break;
            ++n6;
        }
        this.m_Perspective.setTestLabelCalc(bl3);
        this.calcLabelsOneSide(graphics, n, n7, vector2, vector7, blackBoxObj, bl, n4, n5, n6, n3, textStyleObj, vector5, vector6);
        return bl2;
    }

    private int O1LabelAutoRotate(Graphics graphics, int n, int n2, Vector vector, Vector vector2, BlackBoxObj blackBoxObj, boolean bl, int n3, int n4, int n5, int n6, TextStyleObj textStyleObj, Vector vector3) {
        if ((this.m_gt.isBLAType() || this.m_gt.isStockType()) && !this.m_gt.isOrientHorz() && this.isO1Axis()) {
            int n7 = this.labelsOverlap(graphics, 0, n2, vector, vector2, blackBoxObj, bl, n3, n4, n5, n6, textStyleObj, vector3);
            Dimension dimension = textStyleObj.getDimLargeTextVC(this.m_Perspective.m_VC);
            TDGEventManager tDGEventManager = this.m_Perspective.getEventManager();
            switch (n7) {
                case 0: {
                    if (n3 != 1) break;
                    n3 = 0;
                    break;
                }
                case 1: {
                    dimension.width = 0;
                    tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3982, dimension);
                    break;
                }
                case 2: 
                case 3: {
                    tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3982, dimension);
                    int n8 = this.m_Perspective.getO1LabelAutoAngle();
                    textStyleObj.setRotationAngle(n8);
                }
            }
            vector = new Vector(n2);
        }
        return n3;
    }

    private int labelsOverlap(Graphics graphics, int n, int n2, Vector vector, Vector vector2, BlackBoxObj blackBoxObj, boolean bl, int n3, int n4, int n5, int n6, TextStyleObj textStyleObj, Vector vector3) {
        Rectangle rectangle = null;
        Vector vector4 = new Vector(n2);
        IdentObj identObj = this.getTitle();
        boolean bl2 = false;
        boolean bl3 = this.m_Perspective.getMoveAxisTitles();
        Rectangle rectangle2 = null;
        if (this.m_Perspective.getDisplay(identObj)) {
            if (bl3) {
                rectangle2 = this.m_Perspective.getRect(identObj);
                if (rectangle2 == null) {
                    bl2 = false;
                    rectangle = new Rectangle(0, 0, 0, 0);
                } else if (rectangle2.width == 0 && rectangle2.height == 0) {
                    bl2 = false;
                    rectangle = new Rectangle(0, 0, 0, 0);
                } else {
                    bl2 = true;
                }
            } else {
                rectangle = new Rectangle(0, 0, 0, 0);
            }
        }
        boolean bl4 = textStyleObj.getRotationAngle() != 0;
        this.getLabelAndTitlePos(n, n2, vector, vector2, vector4, rectangle, bl4, n3, n4, n5, textStyleObj);
        if (bl3 && bl2) {
            rectangle2 = this.m_Perspective.getRect(identObj);
            rectangle = new Rectangle(rectangle2);
        }
        Dimension dimension = this.getSmallestLabel(vector, n2);
        int n7 = this.getAutofitMinConstrained(bl);
        int n8 = this.getAutofitMaxConstrained(bl);
        int n9 = textStyleObj.formatAndAutofit(graphics, this.m_Perspective, bl, n7, n8, n6, vector3, dimension, this.m_Perspective.m_VC);
        return n9;
    }

    private boolean calcLabelsAutoSkipFrameWidth(int n, int n2, Vector vector, int n3, TextStyleObj textStyleObj, Graphics graphics, boolean bl, int n4, BlackBoxObj blackBoxObj) {
        boolean bl2 = false;
        Rectangle rectangle = ((Axis2DObj)this).getFrameRect();
        boolean bl3 = textStyleObj.getRotationAngle() != 0;
        Dimension dimension = new Dimension(rectangle.width / n2, rectangle.height);
        Dimension dimension2 = this.m_Perspective.m_VC.virtToDest(dimension);
        Vector vector2 = this.getLabels();
        Dimension dimension3 = this.findLargestLabelFastest(graphics, n2, dimension2, vector2, n3, textStyleObj, bl3);
        int n5 = bl3 ? dimension3.height : dimension3.width;
        int n6 = n5 * n2;
        int n7 = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        int n8 = this.m_Perspective.m_VC.virtToDestWidth(rectangle.width);
        int n9 = this.calcSkipFactor(n5, n2, n7, n6, n8);
        this.skipAndDrawLabels(n, n2, vector, n3, textStyleObj, graphics, bl, n4, blackBoxObj, vector2, n7, n9);
        if (n9 > 0) {
            bl2 = true;
        }
        return bl2;
    }

    private boolean calcLabelsAutoSkipFrameHeight(int n, int n2, Vector vector, int n3, TextStyleObj textStyleObj, Graphics graphics, boolean bl, int n4, BlackBoxObj blackBoxObj) {
        boolean bl2 = false;
        Rectangle rectangle = ((Axis2DObj)this).getFrameRect();
        boolean bl3 = textStyleObj.getRotationAngle() != 0;
        Dimension dimension = new Dimension(rectangle.height / n2, rectangle.width);
        dimension = this.m_Perspective.m_VC.virtToDest(dimension);
        Vector vector2 = this.getLabels();
        Dimension dimension2 = this.findLargestLabelFastest(graphics, n2, dimension, vector2, n3, textStyleObj, bl3);
        int n5 = bl3 ? dimension2.width : dimension2.height;
        int n6 = n5 * n2;
        int n7 = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        int n8 = this.m_Perspective.m_VC.virtToDestWidth(rectangle.height);
        int n9 = this.calcSkipFactor(n5, n2, n7, n6, n8);
        this.skipAndDrawLabels(n, n2, vector, n3, textStyleObj, graphics, bl, n4, blackBoxObj, vector2, n7, n9);
        if (n9 > 0) {
            bl2 = true;
        }
        return bl2;
    }

    private int calcSkipFactor(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        if (n4 > n5) {
            if (n >= n5) {
                n6 = n2 - n3;
            } else {
                int n7;
                n6 = 0;
                do {
                    n4 = 0;
                    n7 = (n2 + ++n6) / (n6 + 1);
                    int n8 = 0;
                    while (n8 < n2) {
                        int n9 = n8 >= n3 && (n8 - n3) % (n6 + 1) == 0 ? n : 0;
                        n4 += n9;
                        ++n8;
                    }
                } while (n4 > n5 && n7 >= 2);
            }
        }
        return n6;
    }

    private void skipAndDrawLabels(int n, int n2, Vector vector, int n3, TextStyleObj textStyleObj, Graphics graphics, boolean bl, int n4, BlackBoxObj blackBoxObj, Vector vector2, int n5, int n6) {
        int n7 = 0;
        Vector vector3 = this.getLabelIdents();
        Vector vector4 = new Vector(n2);
        Vector vector5 = new Vector(n2);
        Vector vector6 = new Vector(n2);
        Vector vector7 = new Vector(n2);
        int n8 = 0;
        while (n8 < n2) {
            if (n8 >= n5 && (n8 - n5) % (n6 + 1) == 0) {
                vector6.addElement(vector2.elementAt(n8));
                vector7.addElement(vector3.elementAt(n8));
                vector5.addElement(vector.elementAt(n8));
                ++n7;
            }
            ++n8;
        }
        this.calcLabelsOneSide(graphics, n, n7, vector4, vector5, blackBoxObj, bl, n4, n5, n6, n3, textStyleObj, vector6, vector7);
    }

    private void calcLabelsManualSkip(int n, int n2, Vector vector, int n3, TextStyleObj textStyleObj, Graphics graphics, boolean bl, int n4, BlackBoxObj blackBoxObj) {
        Vector vector2 = new Vector(n2);
        Vector vector3 = this.getLabels();
        Vector vector4 = this.getLabelIdents();
        Vector vector5 = new Vector(n2);
        Vector vector6 = null;
        Vector vector7 = new Vector(n2);
        if (!this.m_template.isNumeric()) {
            vector6 = new Vector(n2);
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n7 = this.m_Perspective.getSkipCount(this.m_template.getLabel());
        n6 = this.m_Perspective.getSkipBegin(this.m_template.getLabel());
        if (n6 < 0) {
            n6 = 0;
        }
        if (n6 > n2 - 1) {
            n6 = n2 - 1;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n7 == 0) {
            n6 = 0;
        }
        if (n6 > n7) {
            n6 = 0;
        }
        int n8 = n7 + 1;
        int n9 = 0;
        while (n9 < n2) {
            if (n9 >= n6 && (n9 - n6) % n8 == 0) {
                vector5.addElement(vector3.elementAt(n9));
                vector7.addElement(vector.elementAt(n9));
                ++n5;
                if (!this.m_template.isNumeric()) {
                    vector6.addElement(vector4.elementAt(n9));
                }
            }
            ++n9;
        }
        if ((n == 0 || n == 2) && this.isAxisLabelVisible(0)) {
            this.calcLabelsOneSide(graphics, 0, n5, vector2, vector7, blackBoxObj, bl, n4, n6, n7, n3, textStyleObj, vector5, vector6);
        }
        if ((n == 1 || n == 2) && this.isAxisLabelVisible(1)) {
            this.calcLabelsOneSide(graphics, 1, n5, vector2, vector7, blackBoxObj, bl, n4, n6, n7, n3, textStyleObj, vector5, vector6);
        }
    }

    private void drawNestedO1Labels(Graphics graphics, int n) {
        IdentObj identObj = this.m_template.getLabel();
        boolean bl = this.m_Perspective.getAutofit(identObj);
        if (this.m_cbO1Labels == null) {
            return;
        }
        boolean bl2 = this.m_Perspective.getFontSizeAbsolute(identObj);
        int n2 = bl2 ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl2, this.m_Perspective.getFontSize(identObj), n2, this.m_Perspective.getTextRotation(identObj), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        int n3 = this.m_cbO1Labels.getNumLevels();
        int n4 = 0;
        while (n4 < n3) {
            this.m_nNestingLevel = n4;
            int n5 = ObjClassID.getObjectFromLevel(n4);
            this.calcOrdinalScale();
            int n6 = this.m_cbO1Labels.getNumLabelsOnLevel(this.m_nNestingLevel);
            Vector vector = new Vector(n6);
            Vector vector2 = this.getLabels();
            Vector vector3 = this.getRelLabelPos(n6);
            int n7 = this.m_Perspective.getNestedSkipCount(this.m_nNestingLevel);
            Vector vector4 = this.getLabelIdents();
            Vector vector5 = null;
            Vector vector6 = null;
            Vector vector7 = null;
            if (n7 > 0) {
                vector5 = new Vector(n6);
                vector7 = new Vector(n6);
                int n8 = 0;
                vector6 = new Vector(n6);
                int n9 = 0;
                int n10 = n7;
                int n11 = n10 + 1;
                boolean bl3 = this.m_Perspective.isTimeAxis() && this.isO1WithNestedLabels() && this.m_Perspective.isIrregularO1Skipping() && this.m_nNestingLevel == 0;
                int n12 = -1;
                int n13 = 0;
                while (n13 < n6) {
                    boolean bl4 = n13 >= n8 && (n13 - n8) % n11 == 0;
                    Object e = vector2.elementAt(n13);
                    if (bl3) {
                        if (e == null || ((String)e).length() < 1) {
                            bl4 = false;
                        } else {
                            boolean bl5 = bl4 = n13 >= n8 && ++n12 % n11 == 0;
                        }
                    }
                    if (bl4) {
                        vector5.addElement(vector2.elementAt(n13));
                        vector7.addElement(vector3.elementAt(n13));
                        ++n9;
                        vector6.addElement(vector4.elementAt(n13));
                    }
                    ++n13;
                }
                vector4 = vector6;
                vector2 = vector5;
                vector3 = vector7;
                n6 = n9;
            }
            if ((n == 0 || n == 2) && this.isAxisLabelVisible(0)) {
                this.calcLabelsOneSide(graphics, 0, n6, vector, vector3, blackBoxObj, bl, 0, 0, n7, n2, textStyleObj, vector2, vector4);
            }
            if ((n == 1 || n == 2) && this.isAxisLabelVisible(1)) {
                this.calcLabelsOneSide(graphics, 1, n6, vector, vector3, blackBoxObj, bl, 0, 0, n7, n2, textStyleObj, vector2, vector4);
            }
            ++n4;
        }
        this.m_nNestingLevel = 0;
        this.calcOrdinalScale();
    }

    private int getAutofitMinConstrained(boolean bl) {
        int n = this.m_Perspective.getAxisTextAutofitMin();
        if (bl) {
            switch (this.m_Perspective.getAxisTextAutofitMode()) {
                case 1: {
                    n = this.m_Perspective.getMinimumAxisTextSizeVC();
                    break;
                }
                case 2: {
                    double d = this.m_Perspective.getMinimumAxisTextSizeVC();
                    n = (int)(d - d * ((double)this.m_Perspective.getAxisTextAutofitPercent() / (double)100));
                }
            }
            if (n < this.m_Perspective.getAxisTextAutofitMin()) {
                n = this.m_Perspective.getAxisTextAutofitMin();
            }
        }
        return n;
    }

    private int getAutofitMaxConstrained(boolean bl) {
        int n = this.m_Perspective.getAxisTextAutofitMax();
        if (bl) {
            switch (this.m_Perspective.getAxisTextAutofitMode()) {
                case 1: {
                    n = this.m_Perspective.getMinimumAxisTextSizeVC();
                    break;
                }
                case 2: {
                    double d = this.m_Perspective.getMinimumAxisTextSizeVC();
                    n = (int)(d + d * ((double)this.m_Perspective.getAxisTextAutofitPercent() / (double)100));
                }
            }
            if (n > this.m_Perspective.getAxisTextAutofitMax()) {
                n = this.m_Perspective.getAxisTextAutofitMax();
            }
        }
        return n;
    }

    private Dimension getSmallestLabel(Vector vector, int n) {
        Dimension dimension = new Dimension(1000000, 1000000);
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle = (Rectangle)vector.elementAt(n2);
            dimension.width = Math.min(dimension.width, rectangle.width);
            dimension.height = Math.min(dimension.height, rectangle.height);
            ++n2;
        }
        return dimension;
    }

    private int calcLabelsOneSide(Graphics graphics, int n, int n2, Vector vector, Vector vector2, BlackBoxObj blackBoxObj, boolean bl, int n3, int n4, int n5, int n6, TextStyleObj textStyleObj, Vector vector3, Vector vector4) {
        Object object;
        boolean bl2 = textStyleObj.getRotationAngle() != 0;
        boolean bl3 = textStyleObj.getWordWrap();
        Rectangle rectangle = null;
        Vector vector5 = new Vector(n2);
        IdentObj identObj = this.getTitle();
        boolean bl4 = false;
        boolean bl5 = this.m_Perspective.getMoveAxisTitles();
        Rectangle rectangle2 = null;
        if (this.m_Perspective.getDisplay(identObj)) {
            if (bl5) {
                rectangle2 = this.m_Perspective.getRect(identObj);
                if (rectangle2 == null) {
                    bl4 = false;
                    rectangle = new Rectangle(0, 0, 0, 0);
                } else if (rectangle2.width == 0 && rectangle2.height == 0) {
                    bl4 = false;
                    rectangle = new Rectangle(0, 0, 0, 0);
                } else {
                    bl4 = true;
                }
            } else {
                rectangle = new Rectangle(0, 0, 0, 0);
            }
        }
        this.getLabelAndTitlePos(n, n2, vector, vector2, vector5, rectangle, bl2, n3, n4, n5, textStyleObj);
        if (bl5 && bl4) {
            rectangle2 = this.m_Perspective.getRect(identObj);
            rectangle = new Rectangle(rectangle2);
        }
        Dimension dimension = this.getSmallestLabel(vector, n2);
        int n7 = this.getAutofitMinConstrained(bl);
        int n8 = this.getAutofitMaxConstrained(bl);
        int n9 = 0;
        if (bl || this.m_gt.is3DType() || this.m_template.isNumeric()) {
            n9 = textStyleObj.formatAndAutofit(graphics, this.m_Perspective, bl, n7, n8, n6, vector3, dimension, this.m_Perspective.m_VC);
        }
        if (n3 == 1 || n3 == 2) {
            this.m_nAutoSkip = n3;
            this.m_nLabelBegin = n4;
            if (n5 > this.m_nSkipFactor) {
                this.m_nSkipFactor = n5;
            }
        }
        if (this.m_SmartAxis.isInQALabelMode() && n2 > 2) {
            object = vector.elementAt(0);
            Object e = vector.elementAt(n2 - 1);
            vector.removeAllElements();
            vector.addElement(object);
            vector.addElement(e);
            Object e2 = vector3.elementAt(0);
            Object e3 = vector3.elementAt(n2 - 1);
            vector3.removeAllElements();
            vector3.addElement(e2);
            vector3.addElement(e3);
            Object e4 = vector5.elementAt(0);
            Object e5 = vector5.elementAt(n2 - 1);
            vector5.removeAllElements();
            vector5.addElement(e4);
            vector5.addElement(e5);
            vector4 = null;
            n2 = 2;
        }
        if (this instanceof CircularAxisObj && textStyleObj.getWordWrap() && textStyleObj.getRotationAngle() == 0) {
            dimension.height *= 2;
        }
        object = this.alignLabelsOneSide(n, n2, dimension, vector, vector3, vector5, vector4, n6, textStyleObj, graphics, bl2, bl, blackBoxObj);
        if (rectangle != null && !rectangle.isEmpty() && this.m_nNestingLevel == this.m_nTopNestingLevel) {
            this.drawAxisTitle(n, bl4, rectangle, vector, graphics);
        }
        this.drawAxisLabels(n2, vector, vector3, vector4, textStyleObj, blackBoxObj, graphics);
        if (this.isO1WithNestedLabels() && !this.m_Perspective.getTestLabelCalc() && this.m_bNestedLabelBrackets && this.m_nNestingLevel < this.m_nTopNestingLevel) {
            this.drawNestedLabelBrackets(n2, vector);
        }
        return n9;
    }

    protected TextStyleObj getTitleTextStyle(int n) {
        IdentObj identObj = this.getTitle();
        boolean bl = this.m_Perspective.getAutofit(identObj);
        int n2 = this.getTitleFontSizeVC();
        boolean bl2 = this.m_Perspective.getFontSizeAbsolute(identObj);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl2, this.m_Perspective.getFontSize(identObj), n2, this.getTitleRotation(this.m_template, n), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), bl, false, this.m_Perspective.getTextWrap(identObj));
        if (identObj.getObjectID() == 232 || identObj.getObjectID() == 233) {
            int n3 = this.m_Perspective.m_VC.virtToDestHeight(n2);
            if (n3 < 18 && TextStyleObj.SMALL_DRILL_IMAGE == null) {
                TextStyleObj.SMALL_DRILL_IMAGE = TextStyleObj.getImageResource(Class.forName("oracle.dss.graph.pfj.draw.TextStyleObj"), "images/graph_drill_up.gif");
            } else if (n3 >= 18 && TextStyleObj.LARGE_DRILL_IMAGE == null) {
                TextStyleObj.LARGE_DRILL_IMAGE = TextStyleObj.getImageResource(Class.forName("oracle.dss.graph.pfj.draw.TextStyleObj"), "images/large_drill_up.gif");
            }
            textStyleObj.setDisplayDrillIcon(true);
        }
        return textStyleObj;
    }

    protected int getTitleFontSizeVC() {
        IdentObj identObj = this.getTitle();
        boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
        int n = bl ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
        return n;
    }

    private void drawAxisTitle(int n, boolean bl, Rectangle rectangle, Vector vector, Graphics graphics) {
        IdentObj identObj = this.getTitle();
        boolean bl2 = this.m_Perspective.getAutofit(identObj);
        if (!bl) {
            this.adjustTitlePosPass1(n, vector, rectangle);
        }
        TextStyleObj textStyleObj = this.getTitleTextStyle(n);
        int n2 = this.getTitleFontSizeVC();
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement(this.m_Perspective.getTextString(identObj));
        if (bl2 || this.m_gt.is3DType() || this.m_gt.isPolar() || this.m_gt.isRadarType()) {
            textStyleObj.formatAndAutofit(graphics, this.m_Perspective, bl2, this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), n2, vector2, dimension, this.m_Perspective.m_VC);
        }
        if (!bl) {
            this.adjustTitlePosPass2(identObj, n, rectangle, dimension);
        }
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        if (!this.m_Perspective.getTestLabelCalc() && this.doDisplayOnCalc()) {
            IdentObj identObj2 = this.getTitleBox();
            BlackBoxObj blackBoxObj2 = new BlackBoxObj(this.m_Perspective, identObj2);
            if (this.m_Perspective.getDisplay(identObj2)) {
                new DetRect(this.m_Perspective.getDetectiv(), identObj2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, blackBoxObj2, null, false, true, true);
            }
            String string = this.m_Perspective.getTextString(identObj);
            int n3 = !this.m_Perspective.getFontSizeAbsolute(identObj) ? (this.isVertical() ? this.m_Perspective.getVC().virtToDestWidth(this.m_Perspective.getFontSizeVC(identObj)) : this.m_Perspective.getVC().virtToDestHeight(this.m_Perspective.getFontSizeVC(identObj))) : this.m_Perspective.getFontSize(identObj);
            int n4 = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle(identObj));
            String string2 = this.m_Perspective.getFontName(identObj);
            Graphics graphics2 = this.m_Perspective.getGraphicsContext();
            Font font = new Font(string2, n4, n3);
            FontMetrics fontMetrics = graphics2.getFontMetrics(font);
            int n5 = this.isVertical() ? this.m_Perspective.getVC().virtToDestHeight(rectangle.height) : this.m_Perspective.getVC().virtToDestWidth(rectangle.width);
            if (!this.m_Perspective.getTextWrap(identObj) && n5 < fontMetrics.stringWidth(string)) {
                string = TextStyleObj.truncateText(string, fontMetrics, 2, n5);
                this.m_Perspective.setAxisTitleTruncated(true, this.m_template.getAxisObjID(), identObj);
            }
            new DetLabel(this.m_Perspective.getDetectiv(), identObj, string, rectangle, textStyleObj, blackBoxObj, this.m_Perspective.getMoveAxisTitles());
        }
    }

    private void drawNestedLabelBrackets(int n, Vector vector) {
        int n2 = 0;
        int n3 = 0;
        IdentObj identObj = this.m_Perspective.getNestedO1LabelLine();
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        int n4 = this.m_Perspective.getLineWidth(this.m_Perspective.getNestedO1LabelLine());
        boolean bl = this.isVertical();
        int n5 = this.m_Perspective.getEffectiveGroupOffset();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            int n8 = this.m_cbO1Labels.getLabelGrouping(n7 + n5, this.m_nNestingLevel);
            Rectangle rectangle = (Rectangle)vector.elementAt(n7);
            if (rectangle != null && !rectangle.isEmpty()) {
                int n9;
                int n10;
                int n11;
                int n12;
                if (bl) {
                    n12 = rectangle.x;
                    n11 = rectangle.x - rectangle.width / 4;
                    n9 = n10 = rectangle.y + rectangle.height / 2;
                } else {
                    n11 = n12 = rectangle.x + rectangle.width / 2;
                    n10 = rectangle.y;
                    n9 = rectangle.y - rectangle.height / 4;
                }
                IdentObj identObj2 = new IdentObj(identObj);
                identObj2.setMiscID(n7);
                new DetLine(this.m_Perspective.getDetectiv(), identObj2, n12, n10, n11, n9, blackBoxObj, null, n4);
                if (n6 == 0) {
                    n2 = n11;
                    n3 = n9;
                }
                if (n6 == n8 - 1) {
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    int n17 = n11;
                    int n18 = n9;
                    identObj2 = new IdentObj(identObj);
                    identObj2.setMiscID(n7 + 1000);
                    new DetLine(this.m_Perspective.getDetectiv(), identObj2, n2, n3, n17, n18, blackBoxObj, null, n4);
                    if (bl) {
                        n16 = n2;
                        n15 = n2 - rectangle.width / 4;
                        n13 = n14 = (n3 + n18) / 2;
                    } else {
                        n15 = n16 = (n2 + n17) / 2;
                        n14 = (n3 + n18) / 2;
                        n13 = n14 - rectangle.height / 4;
                    }
                    identObj2 = new IdentObj(identObj);
                    identObj2.setMiscID(n7 + 2000);
                    new DetLine(this.m_Perspective.getDetectiv(), identObj2, n16, n14, n15, n13, blackBoxObj, null, n4);
                    n6 = 0;
                } else {
                    ++n6;
                }
            }
            ++n7;
        }
    }

    protected void alignTop(Rectangle rectangle, Dimension dimension) {
        rectangle.y = rectangle.y + rectangle.height - dimension.height;
    }

    protected void alignBottom(Rectangle rectangle, Dimension dimension) {
    }

    private Dimension alignLabelsOneSide(int n, int n2, Dimension dimension, Vector vector, Vector vector2, Vector vector3, Vector vector4, int n3, TextStyleObj textStyleObj, Graphics graphics, boolean bl, boolean bl2, BlackBoxObj blackBoxObj) {
        Dimension dimension2 = new Dimension(0, 0);
        Dimension dimension3 = this.findLargestLabelFastest(graphics, n2, dimension, vector2, n3, textStyleObj, bl);
        if (bl) {
            int n4 = dimension3.height;
            dimension3.height = dimension3.width;
            dimension3.width = n4;
        }
        Dimension dimension4 = this.m_Perspective.m_VC.destToVirt(dimension3);
        int n5 = 0;
        while (n5 < n2) {
            boolean bl3 = this.skipFirstOrLastLabel(n5, n2);
            if (!bl3) {
                Rectangle rectangle = (Rectangle)vector.elementAt(n5);
                switch ((Integer)vector3.elementAt(n5)) {
                    case 1: {
                        rectangle.y += (rectangle.height - dimension4.height) / 2;
                        break;
                    }
                    case 2: {
                        this.alignTop(rectangle, dimension4);
                        break;
                    }
                    case 3: {
                        if (this.m_nNestingLevel != 1) {
                            rectangle.x += (rectangle.width - dimension4.width) / 2;
                        }
                        this.alignTop(rectangle, dimension4);
                        break;
                    }
                    case 4: {
                        rectangle.x = rectangle.x + rectangle.width - dimension4.width;
                        this.alignTop(rectangle, dimension4);
                        break;
                    }
                    case 5: {
                        rectangle.x = rectangle.x + rectangle.width - dimension4.width;
                        rectangle.y += (rectangle.height - dimension4.height) / 2;
                        break;
                    }
                    case 6: {
                        rectangle.x = rectangle.x + rectangle.width - dimension4.width;
                        this.alignBottom(rectangle, dimension4);
                        break;
                    }
                    case 7: {
                        rectangle.x += (rectangle.width - dimension4.width) / 2;
                        this.alignBottom(rectangle, dimension4);
                        break;
                    }
                    case 8: {
                        this.alignBottom(rectangle, dimension4);
                    }
                }
                rectangle.width = dimension4.width;
                rectangle.height = dimension4.height;
                this.adjustLabelPos(n, n2, vector);
                this.m_axisLabelTextSizeVC = textStyleObj.getFontSizeVC(this.m_Perspective.m_VC);
                dimension2.width = Math.max(dimension2.width, rectangle.width);
                dimension2.height = Math.max(dimension2.height, rectangle.height);
            }
            ++n5;
        }
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        if (this.isO1Axis() && jGraphType.isOrientHorz()) {
            TDGEventManager tDGEventManager = this.m_Perspective.getEventManager();
            tDGEventManager.notifyPerspectiveListener((Object)this.m_Perspective, 3982, dimension2);
        }
        return dimension4;
    }

    private void drawAxisLabels(int n, Vector vector, Vector vector2, Vector vector3, TextStyleObj textStyleObj, BlackBoxObj blackBoxObj, Graphics graphics) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            boolean bl2 = this.skipFirstOrLastLabel(n2, n);
            if (!bl2) {
                Object e = vector2.elementAt(n2);
                if (!this.m_Perspective.isTimeAxis() || !this.isO1WithNestedLabels() || !this.m_Perspective.isIrregularO1Skipping() || e != null && ((String)e).length() >= 1) {
                    Rectangle rectangle;
                    IdentObj identObj;
                    Serializable serializable;
                    Rectangle rectangle2 = (Rectangle)vector.elementAt(n2);
                    if (!this.m_template.isNumeric() || n2 != 0 && n2 != n - 1 || ((Rectangle)(serializable = this.m_Perspective.getVC().getVirtCoords())).contains(rectangle2) && (!this.m_Perspective.getDisplay(identObj = this.m_Perspective.getLegendArea()) || !rectangle2.intersects(rectangle = this.m_Perspective.getRect(identObj)))) {
                        int n3;
                        if (vector3 != null && vector3.elementAt(n2) != null) {
                            identObj = (IdentObj)vector3.elementAt(n2);
                            int n4 = identObj.getSeriesID();
                            int n5 = identObj.getGroupID();
                            if (this.m_nNestingLevel > 0) {
                                n5 = this.m_cbO1Labels.getParentIndex(n5, this.m_nNestingLevel);
                            }
                            serializable = new IdentObj(this.m_template.getLabel().getObjectID(), n4, n5);
                            if (n4 == -3 && n5 == -3) {
                                ((IdentObj)serializable).setMiscID(n2 + 1000 * this.m_nNestingLevel);
                            }
                            if (this.m_Perspective.getDrillCallback().isDrillingEnabled()) {
                                n3 = this.m_Perspective.getFontStyle((IdentObj)serializable) & 4;
                                textStyleObj.setFontStyle(textStyleObj.getFontStyle() & 0xFFFFFFFB | n3);
                            }
                            if (this.isO1WithNestedLabels()) {
                                ((IdentObj)serializable).setMiscID(this.m_nTopNestingLevel - this.m_nNestingLevel);
                            }
                        } else {
                            serializable = new IdentObj(this.m_template.getLabel());
                            ((IdentObj)serializable).setMiscID(n2 + 1000 * this.m_nNestingLevel);
                        }
                        if (this.m_nNestingLevel == 1) {
                            textStyleObj.setHorizAlign(0);
                            if (this.m_Perspective.getDrillCallback().isDrillingEnabled()) {
                                int n6 = textStyleObj.getFontStyle();
                                textStyleObj.setFontStyle(n6 &= 0xFFFFFFFB);
                            }
                        }
                        if (!this.m_Perspective.getTestLabelCalc() && this.doDisplayOnCalc()) {
                            String string = (String)vector2.elementAt(n2);
                            if (this instanceof CircularAxisObj && textStyleObj.getRotationAngle() == 0 && this.m_nAxisObjectID == 2001) {
                                Rectangle rectangle3 = this.m_Perspective.getRect(this.m_Perspective.getLegendArea());
                                Rectangle rectangle4 = this.m_Perspective.getRect(this.m_Perspective.getFrame());
                                n3 = 0;
                                boolean bl3 = false;
                                if (this.m_Perspective.getDisplay(this.m_Perspective.getLegendArea())) {
                                    if (rectangle3.x < rectangle4.x && rectangle3.y + rectangle3.height > rectangle4.y) {
                                        n3 = 1;
                                    } else if (rectangle3.x + rectangle3.width > rectangle4.x + rectangle4.width && rectangle3.y + rectangle3.height > rectangle4.y) {
                                        bl3 = true;
                                    }
                                }
                                int n7 = -16000;
                                int n8 = 16000;
                                if (n3 == 1) {
                                    n7 = rectangle3.x + rectangle3.width;
                                }
                                if (bl3) {
                                    n8 = rectangle3.x;
                                }
                                boolean bl4 = textStyleObj.getWordWrap();
                                boolean bl5 = true;
                                if (!this.m_Perspective.getFontSizeAbsolute((IdentObj)serializable) && this.m_Perspective.getLegendTextAutofit()) {
                                    bl5 = false;
                                }
                                int n9 = !this.m_Perspective.getFontSizeAbsolute((IdentObj)serializable) ? this.m_Perspective.getVC().virtToDestHeight(this.m_Perspective.getFontSizeVC((IdentObj)serializable)) : this.m_Perspective.getFontSize((IdentObj)serializable);
                                int n10 = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle((IdentObj)serializable));
                                String string2 = this.m_Perspective.getFontName((IdentObj)serializable);
                                Font font = new Font(string2, n10, n9);
                                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                                int n11 = TextStyleObj.getFontHeight(fontMetrics);
                                int n12 = this.m_Perspective.getVC().destToVirtHeight(n11);
                                int n13 = 0;
                                int n14 = 0;
                                int n15 = 0;
                                if (rectangle2.x < rectangle4.x) {
                                    rectangle2.width -= n7 - rectangle2.x;
                                    rectangle2.x = n7;
                                }
                                if (rectangle2.x > rectangle4.x) {
                                    rectangle2.width -= rectangle2.x + rectangle2.width - n8;
                                }
                                if (rectangle2.y + rectangle2.height <= rectangle4.y || rectangle2.y >= rectangle4.y + rectangle4.height) {
                                    textStyleObj.setHorizAlign(1);
                                } else if (rectangle2.x < rectangle4.x) {
                                    textStyleObj.setHorizAlign(2);
                                } else if (rectangle2.x > rectangle4.x) {
                                    textStyleObj.setHorizAlign(0);
                                }
                                if (rectangle2.y > rectangle4.y + rectangle4.height / 2) {
                                    textStyleObj.setVertAlign(2);
                                } else {
                                    textStyleObj.setVertAlign(0);
                                }
                                n13 = this.m_Perspective.getVC().virtToDestWidth(rectangle2.width);
                                n14 = rectangle2.width;
                                if (bl5 && !bl4) {
                                    n15 = this.m_Perspective.getVC().destToVirtWidth(fontMetrics.stringWidth(string));
                                    if (fontMetrics != null && string != null && n14 < n15) {
                                        string = TextStyleObj.truncateText(string, fontMetrics, 2, n13);
                                        bl = true;
                                    }
                                }
                                if (bl5 && bl4) {
                                    int n16 = 2;
                                    Vector vector4 = new Vector();
                                    int n17 = textStyleObj.extractLinesWordWrap(string, vector4, this.m_Perspective.getVC().virtToDestWidth(rectangle2.width), fontMetrics);
                                    if (textStyleObj.isTextTruncated()) {
                                        bl = true;
                                    }
                                    if (n16 < n17) {
                                        textStyleObj.setTextTruncate(true, n16, 2);
                                        bl = true;
                                    }
                                }
                                this.m_Perspective.setO1LabelsTruncated(bl);
                            }
                            new DetLabel(this.m_Perspective.getDetectiv(), (IdentObj)serializable, string, rectangle2, textStyleObj, blackBoxObj, false);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private boolean skipFirstOrLastLabel(int n, int n2) {
        boolean bl = false;
        boolean bl2 = this.m_Perspective.getExcludeMinLabel(this.m_template.getLabel());
        boolean bl3 = this.m_Perspective.getExcludeMaxLabel(this.m_template.getLabel());
        if (!(this.m_Perspective.getGraphType() != 65 && this.m_Perspective.getGraphType() != 66 || this.getAxisIdentObj().getObjectID() != 2003 || bl2 || bl3)) {
            bl3 = true;
        }
        if (n == 0 && bl2) {
            bl = true;
        }
        if (n == n2 - 1 && bl3) {
            bl = true;
        }
        return bl;
    }

    private Vector getRelLabelPos(int n) {
        Vector<Double> vector = new Vector<Double>(n);
        int n2 = this.m_nAxisObjectID;
        int n3 = 2001;
        int n4 = 2002;
        boolean bl = false;
        if (this.m_gt.is3DType() && !this.m_gt.is3DSurface()) {
            if (n2 == n3 && !this.m_bReverseGroups) {
                bl = true;
            }
            if (n2 == n4 && this.m_bReverseSeries) {
                bl = true;
            }
        } else {
            if (n2 == n3 && this.m_bReverseGroups) {
                bl = true;
            }
            if (n2 == n4 && this.m_bReverseSeries) {
                bl = true;
            }
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = bl ? n - n5 - 1 : n5;
            vector.addElement(new Double(this.getLabelRelPos(n6)));
            ++n5;
        }
        return vector;
    }

    public int getAxisTextLabelSizeVC() {
        return this.m_axisLabelTextSizeVC;
    }

    public int getAxisObjID() {
        return this.m_template.getAxisObjID();
    }

    public AxisTemplate getAxisTemplate() {
        return this.m_template;
    }

    public IdentObj getAxisIdentObj() {
        return this.m_template.getAxis();
    }

    public double getAutoLowerSplitValue() {
        return this.m_SmartAxis.getAutoLowerSplitValue();
    }

    public double getAutoHigherSplitValue() {
        return this.m_SmartAxis.getAutoHigherSplitValue();
    }

    public boolean isAscending() {
        return this.m_bAscending;
    }

    public boolean isDescending() {
        return !this.m_bAscending;
    }

    public boolean isO1WithNestedLabels() {
        if (this.m_cbO1Labels == null) {
            return false;
        }
        if (!this.m_Perspective.getNestedLabels()) {
            return false;
        }
        boolean bl = this.isO1Axis();
        return bl;
    }

    public boolean isO1Axis() {
        boolean bl = this.m_nAxisObjectID == 2001;
        return bl;
    }

    public boolean isY2Axis() {
        boolean bl = this.m_nAxisObjectID == 2005;
        return bl;
    }

    public boolean isY3Axis() {
        boolean bl = this.m_nAxisObjectID == 2012;
        return bl;
    }

    public boolean isY4Axis() {
        boolean bl = this.m_nAxisObjectID == 2013;
        return bl;
    }

    public boolean isY5Axis() {
        boolean bl = this.m_nAxisObjectID == 2014;
        return bl;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public void setDrawGrids(boolean bl) {
        this.m_bDrawGrids = bl;
    }

    protected IdentObj getTitle() {
        if ((this.m_template.getAxisObjID() == 5 || this.m_template.getAxisObjID() == 6) && this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_template.getDrillLabel()) != null && this.m_Perspective.getDisplay(this.m_template.getDrillLabel())) {
            return this.m_template.getDrillLabel();
        }
        return this.m_template.getTitle();
    }

    protected IdentObj getTitleBox() {
        if ((this.m_template.getAxisObjID() == 5 || this.m_template.getAxisObjID() == 6) && this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_template.getDrillLabel()) != null && this.m_Perspective.getDisplay(this.m_template.getDrillLabel())) {
            return this.m_template.getDrillLabelBox();
        }
        return this.m_template.getTitleBox();
    }

    private Dimension findLargestLabelFastest(Graphics graphics, int n, Dimension dimension, Vector vector, int n2, TextStyleObj textStyleObj, boolean bl) {
        int n3;
        Dimension dimension2 = new Dimension(0, 0);
        int n4 = this.m_Perspective.m_VC.virtToDestHeight(n2);
        Dimension dimension3 = this.m_Perspective.m_VC.virtToDest(dimension);
        if (bl) {
            n3 = dimension3.width;
            dimension3.width = dimension3.height;
            dimension3.height = n3;
        }
        n3 = 0;
        while (n3 < n) {
            boolean bl2 = this.skipFirstOrLastLabel(n3, n);
            if (!bl2) {
                String string = (String)vector.elementAt(n3);
                Dimension dimension4 = textStyleObj.getTextSizeDC(graphics, string, n4, this.m_Perspective.m_VC, dimension3, null);
                if (dimension4.width > dimension2.width) {
                    dimension2.width = dimension4.width;
                }
                if (dimension4.height > dimension2.height) {
                    dimension2.height = dimension4.height;
                }
            }
            ++n3;
        }
        return dimension2;
    }

    protected abstract boolean isVertical();

    protected abstract void adjustTitlePosPass1(int var1, Vector var2, Rectangle var3);

    protected abstract void adjustTitlePosPass2(IdentObj var1, int var2, Rectangle var3, Dimension var4);

    protected abstract void adjustLabelPos(int var1, int var2, Vector var3);

    protected abstract boolean isAxisLabelVisible(int var1);

    protected abstract boolean doDisplayOnCalc();

    protected abstract void calcMajorGridLine(IdentObj var1, double var2, BlackBoxIF var4);

    protected abstract void calcMinorGridLine(IdentObj var1, double var2, BlackBoxIF var4);

    protected abstract int getAxisSide();

    protected abstract void getLabelAndTitlePos(int var1, int var2, Vector var3, Vector var4, Vector var5, Rectangle var6, boolean var7, int var8, int var9, int var10, TextStyleObj var11);

    protected abstract double getLabelRelPos(int var1);

    protected abstract Vector getLabels();

    protected abstract Vector getLabelIdents();

    protected abstract boolean getMajorGridDisplay(AxisTemplate var1);

    protected abstract double getMajorGridPos(int var1);

    protected abstract boolean getMinorGridDisplay(AxisTemplate var1);

    protected abstract double getMinorGridPos(int var1, int var2);

    public abstract double getMaxValue();

    public abstract double getMinValue();

    protected abstract void calcOrdinalScale();

    protected abstract int getNumLabels();

    protected abstract int getNumMajorGrids();

    protected abstract int getNumMinorGrids();

    protected abstract int getTitleRotation(AxisTemplate var1, int var2);

    protected abstract boolean isLogScale();

    protected abstract boolean isPolarAxis();

    protected abstract int getTitleJustVert(IdentObj var1, int var2);

    protected abstract int getTitleJustHoriz(IdentObj var1, int var2);

    public abstract String getNonZeroBaselineLabel();

    protected abstract double getValueCoord(double var1);
}

