/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.math.FP;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Axis3DObj
extends RelativeAxisObj {
    private static final int ANGLE_HORZ = 1;
    private static final int ANGLE_VERT = 2;
    private static final int ANGLE_QUAD_1_A = 3;
    private static final int ANGLE_QUAD_1_B = 4;
    private static final int ANGLE_QUAD_2_A = 5;
    private static final int ANGLE_QUAD_2_B = 6;
    private static final int LABEL_DISTANCE = 300;
    private JChart_3D m_chart;
    protected boolean m_bVertScale;
    protected int m_axisLengthVC;
    protected int m_axisOrgVC;
    private Vector m_majorGridPos;
    private Vector m_minorGridPos;
    private BlackBoxIF m_minorGridBB;
    private BlackBoxIF m_majorGridBB;
    private IdentObj m_majorGridId;
    private IdentObj m_minorGridId;
    private Rectangle m_rTitleFrame;

    public Axis3DObj(JChart_3D jChart_3D, Perspective perspective, Access access, AxisTemplate axisTemplate, int n, int n2, boolean bl, int n3, int n4) {
        this(jChart_3D, perspective, access, axisTemplate, n, n2, bl, 0, 100, n3, n4);
    }

    public Axis3DObj(JChart_3D jChart_3D, Perspective perspective, Access access, AxisTemplate axisTemplate, int n, int n2, boolean bl, int n3, int n4, int n5, int n6) {
        super(perspective, access, axisTemplate, n, bl, n3, n4);
        this.m_axisLengthVC = n6;
        this.m_axisOrgVC = n5;
        this.m_chart = jChart_3D;
        this.m_rTitleFrame = null;
        this.m_bVertScale = false;
        this.m_bDelayCalcLabels = true;
    }

    public Axis3DObj(JChart_3D jChart_3D, Perspective perspective, Access access, AxisTemplate axisTemplate, MinMaxObj minMaxObj, int n, boolean bl, int n2, int n3, int n4, int n5) {
        super(perspective, access, axisTemplate, minMaxObj, bl, n2, n3);
        this.m_axisLengthVC = n5;
        this.m_axisOrgVC = n4;
        this.m_chart = jChart_3D;
        this.m_rTitleFrame = null;
        this.m_bDelayCalcLabels = true;
    }

    protected void adjustTitlePosPass1(int n, Vector vector, Rectangle rectangle) {
    }

    protected void adjustTitlePosPass2(IdentObj identObj, int n, Rectangle rectangle, Dimension dimension) {
        switch (identObj.getObjectID()) {
            case 8: 
            case 232: {
                rectangle.x += rectangle.width - dimension.width;
                rectangle.width = dimension.width;
                rectangle.height = dimension.height;
                break;
            }
            case 9: 
            case 233: {
                rectangle.width = dimension.width;
                rectangle.height = dimension.height;
                break;
            }
            case 6: {
                if (n == 0) {
                    rectangle.width = dimension.width;
                    rectangle.y += rectangle.height - dimension.height;
                    rectangle.height = dimension.height;
                    break;
                }
                rectangle.x += rectangle.width - dimension.width;
                rectangle.width = dimension.width;
                rectangle.y += rectangle.height - dimension.height;
                rectangle.height = dimension.height;
            }
        }
    }

    public void calc() {
        this.m_majorGridPos = new Vector(1);
        this.m_minorGridPos = new Vector(1);
        super.calc();
    }

    public void calcLabels() {
        if (!this.m_bDelayCalcLabels) {
            throw new AssertionException("call calcLabels only is the calclabel has been delayed (3D charts)");
        }
        super.calcLabels();
    }

    protected void calcMajorGridLine(IdentObj identObj, double d, BlackBoxIF blackBoxIF) {
        this.m_majorGridPos.addElement(new Double((double)this.m_axisOrgVC + d * (double)this.m_axisLengthVC));
        this.m_majorGridBB = blackBoxIF;
        this.m_majorGridId = identObj;
    }

    protected void calcMinorGridLine(IdentObj identObj, double d, BlackBoxIF blackBoxIF) {
        if (FP.between(d, 0.0, 1.0)) {
            this.m_minorGridPos.addElement(new Double((double)this.m_axisOrgVC + d * (double)this.m_axisLengthVC));
            this.m_minorGridBB = blackBoxIF;
            this.m_minorGridId = identObj;
        }
    }

    protected boolean doDisplayOnCalc() {
        return true;
    }

    protected boolean isVertical() {
        return this.m_bVertScale;
    }

    private int getAxis() {
        int n = 0;
        switch (this.m_template.getAxisObjID()) {
            case 5: {
                n = 2;
                break;
            }
            case 6: {
                n = 0;
                break;
            }
            case 0: {
                n = 1;
            }
        }
        return n;
    }

    private int getAxisAngle(int n, int n2) {
        Point point = this.getPointPosition(n, n2, 0.0);
        Point point2 = this.getPointPosition(n, n2, 1.0);
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        int n3 = FP.round(Math.atan2(d2, d) * 57.29577951308232);
        while (n3 < 180) {
            n3 += 180;
        }
        while (n3 > 180) {
            n3 -= 180;
        }
        return n3;
    }

    private int getAxisPseudoQuadrant(int n, boolean bl) {
        int n2 = n < 10 || n > 170 ? 1 : (n > 80 && n < 100 ? 2 : (n < (bl ? 80 : 20) ? 3 : (n < 90 ? 4 : (n < (bl ? 99 : 170) ? 5 : 6))));
        return n2;
    }

    protected int getAxisSide() {
        switch (this.getAxis()) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.m_Perspective.getAxisSide(this.m_template.getAxis());
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    protected boolean isAxisLabelVisible(int n) {
        return this.m_chart.isAxisVisible(this.getAxis(), n);
    }

    private int getAxisToWallAngle(int n, int n2, Point point) {
        Point point2 = this.getPointPosition(n, n2, 0.0);
        Point point3 = this.getPointPosition(n, n2, 1.0);
        Point point4 = new Point(Math.min(point3.x, point2.x) + Math.abs(point3.x - point2.x) / 2, Math.min(point3.y, point2.y) + Math.abs(point3.y - point2.y) / 2);
        int n3 = point.x - point4.x;
        int n4 = point.y - point4.y;
        int n5 = FP.round(Math.atan(n4 / n3) * 57.29577951308232);
        if (n3 < 0 && n4 > 0) {
            n5 += 180;
        } else if (n3 < 0 && n4 < 0) {
            n5 += 180;
        } else if (n3 > 0 && n4 < 0) {
            n5 += 360;
        }
        return n5;
    }

    public double getBaseCoord() {
        if (this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getBaseRelCoord() * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getCenterCoord(int n) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getCenterRelCoord(n) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public int getGroupAboveCoord(int n) {
        if (!this.m_bNumericAxis) {
            return this.getGroupAboveRelCoord(((double)n - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    public int getGroupBelowCoord(int n) {
        if (!this.m_bNumericAxis) {
            return this.getGroupBelowRelCoord(((double)n - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    public double getHighCoord(int n, int n2) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getHighRelCoord(n, n2) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    protected void getLabelAndTitlePos(int n, int n2, Vector vector, Vector vector2, Vector vector3, Rectangle rectangle, boolean bl, int n3, int n4, int n5, TextStyleObj textStyleObj) {
        Cloneable cloneable;
        int n6;
        int n7;
        int n8 = this.getAxis();
        Point[] pointArray = this.getLabelPosition2d(n, n8, n2, vector2);
        int n9 = this.getAxisAngle(n, n8);
        Point point = this.getWallCenter(n8, this.m_chart.getCubeSize());
        int n10 = this.getAxisToWallAngle(n, n8, point);
        int n11 = this.getAxisPseudoQuadrant(n9, bl);
        int n12 = 0;
        switch (n11) {
            case 1: {
                if (n10 > n9 && n9 > 90 || n10 < n9 && n9 < 90) {
                    n12 = 7;
                    break;
                }
                n12 = 3;
                break;
            }
            case 2: {
                if (n10 < n9 || n10 > n9 + 180) {
                    n12 = 5;
                    break;
                }
                n12 = 1;
                break;
            }
            case 3: 
            case 4: {
                if (n10 < n9 || n10 > n9 + 180) {
                    n12 = 6;
                    break;
                }
                n12 = 2;
                break;
            }
            case 5: 
            case 6: {
                n12 = n10 < n9 || n10 > n9 + 180 ? 4 : 8;
            }
        }
        Dimension dimension = this.m_Perspective.m_VC.getVirtDimension();
        int n13 = -dimension.width / 2;
        int n14 = dimension.width / 2;
        int n15 = dimension.height / 2;
        int n16 = -dimension.height / 2;
        if (n2 > 1) {
            n7 = Math.abs((pointArray[n2 - 1].y - pointArray[0].y) / (n2 - 1));
            n6 = Math.abs((pointArray[n2 - 1].x - pointArray[0].x) / (n2 - 1));
        } else {
            cloneable = this.getPointPosition(n, n8, 0.0);
            Point point2 = this.getPointPosition(n, n8, 1.0);
            n7 = Math.abs(point2.y - cloneable.y);
            n6 = Math.abs(point2.x - cloneable.x);
        }
        cloneable = null;
        int n17 = 0;
        while (n17 < n2) {
            switch (n11) {
                case 1: {
                    if (n12 == 3) {
                        cloneable = new Rectangle(pointArray[n17].x - n6 / 2, n16, n6, pointArray[n17].y - n16 - 300);
                        break;
                    }
                    cloneable = new Rectangle(pointArray[n17].x - n6 / 2, pointArray[n17].y + 300, n6, n15 - pointArray[n17].y - 300);
                    break;
                }
                case 2: {
                    if (n12 == 1) {
                        cloneable = new Rectangle(pointArray[n17].x + 300, pointArray[n17].y - n7 / 2, n14 - pointArray[n17].x - 300, n7);
                        break;
                    }
                    cloneable = new Rectangle(n13, pointArray[n17].y - n7 / 2, pointArray[n17].x - n13 - 300, n7);
                    break;
                }
                case 3: {
                    if (n12 == 2) {
                        cloneable = new Rectangle(pointArray[n17].x, n16, n6, pointArray[n17].y - n16);
                        break;
                    }
                    cloneable = new Rectangle(pointArray[n17].x - n6, pointArray[n17].y, n6, n15 - pointArray[n17].y);
                    break;
                }
                case 4: {
                    if (n12 == 2) {
                        cloneable = new Rectangle(pointArray[n17].x, pointArray[n17].y - n7, n14 - pointArray[n17].x, n7);
                        break;
                    }
                    cloneable = new Rectangle(n13, pointArray[n17].y, pointArray[n17].x - n13, n7);
                    break;
                }
                case 5: {
                    if (n12 == 4) {
                        cloneable = new Rectangle(n13, pointArray[n17].y - n7, pointArray[n17].x - n13, n7);
                        break;
                    }
                    cloneable = new Rectangle(pointArray[n17].x, pointArray[n17].y, n14 - pointArray[n17].x, n7);
                    break;
                }
                case 6: {
                    cloneable = n12 == 4 ? new Rectangle(pointArray[n17].x - n6, n16, n6, pointArray[n17].y - n16) : new Rectangle(pointArray[n17].x, pointArray[n17].y, n6, n15 - pointArray[n17].y);
                }
            }
            if (cloneable == null) {
                throw new AssertionException("Internal error: rLabel null");
            }
            vector.insertElementAt(cloneable, n17);
            vector3.insertElementAt(new Integer(n12), n17);
            ++n17;
        }
        if (rectangle != null && this.m_rTitleFrame != null) {
            rectangle.x = this.m_rTitleFrame.x;
            rectangle.y = this.m_rTitleFrame.y;
            rectangle.width = this.m_rTitleFrame.width;
            rectangle.height = this.m_rTitleFrame.height;
        }
    }

    private Point[] getLabelPosition2d(int n, int n2, int n3, Vector vector) {
        Object var5_5 = null;
        Point[] pointArray = new Point[n3];
        int n4 = 0;
        while (n4 < n3) {
            pointArray[n4] = this.getPointPosition(n, n2, (Double)vector.elementAt(n4));
            ++n4;
        }
        return pointArray;
    }

    protected Vector getLabels() {
        if (this.m_bNumericAxis) {
            return this.getNumericLabels();
        }
        int n = this.getNumLabels();
        Vector vector = new Vector(n);
        if (this.m_template.getAxisObjID() == 5) {
            if (this.isO1WithNestedLabels()) {
                vector = this.m_cbO1Labels.getAllLabels(this.m_nNestingLevel);
            } else {
                GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
                while (groupsEnumerator.hasMoreElements()) {
                    int n2 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_Access.getNumTotalGroups());
                    vector.addElement(this.m_Perspective.getGroupLabel(n2));
                }
            }
        } else {
            SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
            while (seriesEnumerator.hasMoreElements()) {
                int n3 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_Access.getNumTotalSeries());
                vector.addElement(this.m_Perspective.getSeriesLabel(n3));
            }
        }
        return vector;
    }

    protected Vector getLabelIdents() {
        Vector<IdentObj> vector;
        block2: {
            block3: {
                vector = null;
                if (this.m_bNumericAxis) break block2;
                int n = this.getNumLabels();
                vector = new Vector<IdentObj>(n);
                if (this.m_template.getAxisObjID() != 5) break block3;
                if (this.isO1WithNestedLabels()) break block2;
                GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
                while (groupsEnumerator.hasMoreElements()) {
                    int n2 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_Access.getNumTotalGroups());
                    vector.addElement(new IdentObj(-3, -3, n2));
                }
                break block2;
            }
            SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
            while (seriesEnumerator.hasMoreElements()) {
                int n = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_Access.getNumTotalSeries());
                vector.addElement(new IdentObj(-3, n));
            }
        }
        return vector;
    }

    public double getLowCoord(int n, int n2) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getLowRelCoord(n, n2) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public BlackBoxIF getMajorGridBlackBox() {
        return this.m_majorGridBB;
    }

    public boolean getMajorGridDisplay(AxisTemplate axisTemplate) {
        switch (axisTemplate.getAxisObjID()) {
            case 0: {
                return this.m_Perspective.getGrid3DLeftWallDisplayY() || this.m_Perspective.getGrid3DRightWallDisplayY() || this.m_Perspective.getGrid3DRiserDisplayY();
            }
            case 5: {
                return this.m_Perspective.getGrid3DFloorDisplayZ() || this.m_Perspective.getGrid3DLeftWallDisplayZ() || this.m_Perspective.getGrid3DRiserDisplayZ();
            }
            case 6: {
                return this.m_Perspective.getGrid3DFloorDisplayX() || this.m_Perspective.getGrid3DRightWallDisplayX() || this.m_Perspective.getGrid3DRiserDisplayX();
            }
        }
        throw new AssertionException("Axis3D::getMajorGridDisplay not implemented for this axis");
    }

    public IdentObj getMajorGridId() {
        return this.m_majorGridId;
    }

    public Vector getMajorGridPositions() {
        return this.m_majorGridPos;
    }

    public BlackBoxIF getMinorGridBlackBox() {
        return this.m_minorGridBB;
    }

    protected boolean getMinorGridDisplay(AxisTemplate axisTemplate) {
        return false;
    }

    public IdentObj getMinorGridId() {
        return this.m_minorGridId;
    }

    public Vector getMinorGridPositions() {
        return this.m_minorGridPos;
    }

    private Point getPointPosition(int n, int n2, double d) {
        Point3d point3d = this.m_chart.getCubeSize();
        Point3d point3d2 = null;
        switch (n2) {
            case 0: {
                point3d2 = new Point3d((int)((double)this.m_axisOrgVC + d * (double)this.m_axisLengthVC), 0.0, point3d.z);
                break;
            }
            case 1: {
                if (n == 0) {
                    point3d2 = new Point3d(0.0, (int)((double)this.m_axisOrgVC + d * (double)this.m_axisLengthVC), point3d.z);
                    break;
                }
                point3d2 = new Point3d(point3d.x, (int)((double)this.m_axisOrgVC + d * (double)this.m_axisLengthVC), 0.0);
                break;
            }
            case 2: {
                point3d2 = new Point3d(point3d.x, 0.0, (int)((double)this.m_axisOrgVC + d * (double)this.m_axisLengthVC));
            }
        }
        this.m_chart.transformPoint3d(point3d2);
        return this.m_chart.projectPoint3d(point3d2);
    }

    protected int getTitleRotation(AxisTemplate axisTemplate, int n) {
        int n2 = this.m_Perspective.getMoveAxisTitles() ? this.m_Perspective.getTextRotation(axisTemplate.getTitle()) : 0;
        return n2;
    }

    public double getValueCoord(double d) {
        if (this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getValueRelCoord(d) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getValueFromCoord(int n) {
        if (this.m_bNumericAxis) {
            return this.getValueFromRelCoord(((double)n - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    private Point getWallCenter(int n, Point3d point3d) {
        Point3d point3d2 = null;
        switch (n) {
            case 0: {
                point3d2 = new Point3d(point3d.x / (double)2, 0.0, 0.0);
                break;
            }
            case 1: {
                point3d2 = new Point3d(0.0, point3d.y / (double)2, 0.0);
                break;
            }
            case 2: {
                point3d2 = new Point3d(0.0, 0.0, point3d.z / (double)2);
            }
        }
        this.m_chart.transformPoint3d(point3d2);
        return this.m_chart.projectPoint3d(point3d2);
    }

    protected boolean isPolarAxis() {
        return false;
    }

    public void calcAxisBody() {
    }

    protected void adjustLabelPos(int n, int n2, Vector vector) {
    }

    protected int getTitleJustVert(IdentObj identObj, int n) {
        if (identObj.getObjectID() == 6) {
            return 0;
        }
        return 2;
    }

    protected int getTitleJustHoriz(IdentObj identObj, int n) {
        if (identObj.getObjectID() == 6 && n == 0 || identObj.getObjectID() == 8) {
            return 0;
        }
        return 2;
    }

    void setTitleRect(Rectangle rectangle) {
        this.m_rTitleFrame = rectangle;
    }

    protected boolean pinCoordToMinScale() {
        return !this.m_chart.m_gt.is3DRibbonType();
    }
}

