/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.CategoryIF;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.DataStorage;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.ZoomState;

public class Access
implements Serializable {
    static final CategoryIF LOG = Perspective.getInstance("ENGINE.Access");
    public static final boolean DEBUG_ACCESS = false;
    Perspective m_Perspective;
    DataStorage m_DataStorage;
    DataRange m_DataRange;
    DataRange m_ViewableDataRange;
    DataFormat m_DataFormat;
    boolean m_bSeriesAreRows;
    boolean m_bItemsAlongSeries;
    boolean m_bItemsAlongRows;
    boolean m_bReverseSeries;
    boolean m_bReverseGroups;
    boolean m_bZoomingArmed;
    ZoomState m_zoomState;
    int m_nonIgnoredSeries;

    public Access(Perspective perspective, DataStorage dataStorage, DataRange dataRange, DataFormat dataFormat) {
        this.m_Perspective = perspective;
        this.m_DataStorage = dataStorage;
        this.m_DataRange = dataRange;
        this.m_DataFormat = dataFormat;
        this.m_bSeriesAreRows = perspective.getSeriesAreRows();
        this.m_bItemsAlongSeries = perspective.getDataItemsAlongSeries();
        this.m_bItemsAlongRows = this.m_bSeriesAreRows == this.m_bItemsAlongSeries;
        this.m_bReverseSeries = perspective.getReverseSeries();
        this.m_bReverseGroups = perspective.getReverseGroups();
        this.m_bZoomingArmed = perspective.isZoomingArmed();
        this.m_zoomState = this.m_bZoomingArmed ? perspective.getZoomList().getZoomState() : null;
        this.setViewableDataRange(perspective);
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(perspective, this, true);
        this.m_nonIgnoredSeries = seriesEnumerator.getNumSeries();
    }

    protected int getCol(int n, int n2) {
        return this.getCol(n, n2, false);
    }

    public double getDataAsDouble(int n, int n2, DataItem dataItem, boolean bl) {
        int n3 = this.getRow(n, n2, bl);
        int n4 = this.getCol(n, n2, bl);
        double d = this.m_DataStorage.getDataAsDouble(n3 += dataItem.getRowOffset(this.m_bItemsAlongRows), n4 += dataItem.getColOffset(this.m_bItemsAlongRows));
        return d;
    }

    public double getDataAsDouble(int n, int n2, DataItem dataItem) {
        return this.getDataAsDouble(n, n2, dataItem, false);
    }

    public String getDataAsString(int n, int n2, DataItem dataItem, boolean bl) {
        String string;
        int n3 = this.getRow(n, n2, bl);
        int n4 = this.getCol(n, n2, bl);
        n3 += dataItem.getRowOffset(this.m_bItemsAlongRows);
        n4 += dataItem.getColOffset(this.m_bItemsAlongRows);
        try {
            string = this.m_DataStorage.getDataAsString(n3, n4);
        }
        catch (AssertionException assertionException) {
            if (dataItem.isRequired()) {
                throw assertionException;
            }
            string = "";
        }
        return string;
    }

    public String getDataAsString(int n, int n2, DataItem dataItem) {
        return this.getDataAsString(n, n2, dataItem, false);
    }

    public DataFormat getDataFormat() {
        return this.m_DataFormat;
    }

    public int getNumGroups() {
        int n;
        int n2;
        int n3 = n2 = this.m_bItemsAlongSeries ? this.m_DataFormat.getColsPerNode() : this.m_DataFormat.getRowsPerNode();
        if (this.m_bSeriesAreRows) {
            int n4 = this.m_ViewableDataRange.getNumCols();
            n = n4 / n2;
        } else {
            int n5 = this.m_ViewableDataRange.getNumRows();
            n = n5 / n2;
        }
        return n;
    }

    public int getNumNonIgnoredSeries() {
        return this.m_nonIgnoredSeries;
    }

    public int getNumSeries() {
        int n;
        int n2;
        int n3 = n2 = this.m_bItemsAlongSeries ? this.m_DataFormat.getRowsPerNode() : this.m_DataFormat.getColsPerNode();
        if (this.m_bSeriesAreRows) {
            int n4 = this.m_ViewableDataRange.getNumRows();
            n = n4 / n2;
        } else {
            int n5 = this.m_ViewableDataRange.getNumCols();
            n = n5 / n2;
        }
        return n;
    }

    public int getNumTotalGroups() {
        int n;
        int n2;
        int n3 = n2 = this.m_bItemsAlongSeries ? this.m_DataFormat.getColsPerNode() : this.m_DataFormat.getRowsPerNode();
        if (this.m_bSeriesAreRows) {
            int n4 = this.m_DataRange.getNumCols();
            n = n4 / n2;
        } else {
            int n5 = this.m_DataRange.getNumRows();
            n = n5 / n2;
        }
        return n;
    }

    public int getNumTotalSeries() {
        int n;
        int n2;
        int n3 = n2 = this.m_bItemsAlongSeries ? this.m_DataFormat.getRowsPerNode() : this.m_DataFormat.getColsPerNode();
        if (this.m_bSeriesAreRows) {
            int n4 = this.m_DataRange.getNumRows();
            n = n4 / n2;
        } else {
            int n5 = this.m_DataRange.getNumCols();
            n = n5 / n2;
        }
        return n;
    }

    protected int getRow(int n, int n2) {
        return this.getRow(n, n2, false);
    }

    public boolean isCellNumeric(int n, int n2) {
        return this.isCellNumeric(n, n2, DataItem.DI_GENERAL);
    }

    public boolean isCellNumeric(int n, int n2, DataItem dataItem) {
        int n3 = this.getRow(n, n2) + dataItem.getRowOffset(this.m_bItemsAlongRows);
        int n4 = this.getCol(n, n2) + dataItem.getColOffset(this.m_bItemsAlongRows);
        return this.m_DataStorage.isCellNumeric(n3, n4);
    }

    public DataRange getViewableDataRange() {
        return this.m_ViewableDataRange;
    }

    public DataRange getViewableDataRangeSG(Perspective perspective) {
        int n = this.getNumTotalSeries();
        int n2 = this.getNumTotalGroups();
        int n3 = 0;
        int n4 = 0;
        int n5 = n - 1;
        int n6 = n2 - 1;
        int n7 = perspective.getEffectiveViewableSeries(n);
        int n8 = perspective.getEffectiveViewableGroups(n2);
        if (n7 != 0 && n > n7) {
            n3 = perspective.getEffectiveSeriesOffset();
            if (n3 + n7 > n) {
                n3 = n - n7;
            }
            if ((n5 = n3 + n7 - 1) >= n) {
                PfjAssert.pfjAssert(n5 < n, String.valueOf(String.valueOf("nViewSeriesStop = ")) + n5);
            }
        }
        if (n8 != 0 && n2 > n8) {
            n4 = perspective.getEffectiveGroupOffset();
            if (n4 + n8 > n2) {
                n4 = n2 - n8;
            }
            if ((n6 = n4 + n8 - 1) >= n2) {
                PfjAssert.pfjAssert(n6 < n2, String.valueOf(String.valueOf("nViewGroupStop = ")) + n6 + " nGroups = " + n2);
            }
        }
        return new DataRange(n3, n4, n5, n6);
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public void setDataAsDouble(int n, int n2, DataItem dataItem, double d, boolean bl) {
        int n3 = this.getRow(n, n2, bl);
        int n4 = this.getCol(n, n2, bl);
        this.m_DataStorage.setData(n3 += dataItem.getRowOffset(this.m_bItemsAlongRows), n4 += dataItem.getColOffset(this.m_bItemsAlongRows), d);
    }

    public void setDataAsDouble(int n, int n2, DataItem dataItem, double d) {
        this.setDataAsDouble(n, n2, dataItem, d, false);
    }

    public void setDataAsString(int n, int n2, DataItem dataItem, String string, boolean bl) {
        int n3 = this.getRow(n, n2, bl);
        int n4 = this.getCol(n, n2, bl);
        this.m_DataStorage.setData(n3 += dataItem.getRowOffset(this.m_bItemsAlongRows), n4 += dataItem.getColOffset(this.m_bItemsAlongRows), string);
    }

    public void setDataAsString(int n, int n2, DataItem dataItem, String string) {
        this.setDataAsString(n, n2, dataItem, string, false);
    }

    protected int getCol(int n, int n2, boolean bl) {
        int n3 = 0;
        if (!bl) {
            n3 = this.m_DataRange.getColStart();
        }
        if (this.m_bSeriesAreRows) {
            if (this.m_bReverseGroups) {
                n2 = this.getNumTotalGroups() - 1 - n2;
            }
            n3 = this.m_bItemsAlongSeries ? (n3 += this.m_DataFormat.getColsPerNode() * n2) : (n3 += this.m_DataFormat.getRowsPerNode() * n2);
        } else {
            if (this.m_bReverseSeries) {
                n = this.getNumTotalSeries() - 1 - n;
            }
            n3 = this.m_bItemsAlongSeries ? (n3 += this.m_DataFormat.getRowsPerNode() * n) : (n3 += this.m_DataFormat.getColsPerNode() * n);
        }
        return n3;
    }

    protected int getRow(int n, int n2, boolean bl) {
        int n3 = 0;
        if (!bl) {
            n3 = this.m_DataRange.getRowStart();
        }
        if (this.m_bSeriesAreRows) {
            if (this.m_bReverseSeries) {
                n = this.getNumTotalSeries() - 1 - n;
            }
            n3 = this.m_bItemsAlongSeries ? (n3 += this.m_DataFormat.getRowsPerNode() * n) : (n3 += this.m_DataFormat.getColsPerNode() * n);
        } else {
            if (this.m_bReverseGroups) {
                n2 = this.getNumTotalGroups() - 1 - n2;
            }
            n3 = this.m_bItemsAlongSeries ? (n3 += this.m_DataFormat.getColsPerNode() * n2) : (n3 += this.m_DataFormat.getRowsPerNode() * n2);
        }
        return n3;
    }

    public void deleteSeries(int n) {
        if (this.m_bSeriesAreRows) {
            int n2;
            int n3 = n2 = this.getRow(n, 0, true);
            if (!this.m_bItemsAlongSeries) {
                n3 += this.m_DataFormat.getNumDataItems() - 1;
            }
            int n4 = n2;
            while (n4 <= n3) {
                this.m_DataStorage.deleteRow(n4);
                ++n4;
            }
            n4 = 1;
            if (!this.m_bItemsAlongSeries) {
                n4 = this.m_DataFormat.getNumDataItems();
            }
            this.m_DataRange.shrinkTo(this.m_DataRange.getRowStart(), this.m_DataRange.getColStart(), this.m_DataRange.getRowStop() - n4, this.m_DataRange.getColStop());
        } else {
            int n5;
            int n6 = n5 = this.getCol(n, 0, true);
            if (!this.m_bItemsAlongSeries) {
                n6 += this.m_DataFormat.getNumDataItems() - 1;
            }
            int n7 = n5;
            while (n7 <= n6) {
                this.m_DataStorage.deleteCol(n7);
                ++n7;
            }
            n7 = 1;
            if (!this.m_bItemsAlongSeries) {
                n7 = this.m_DataFormat.getNumDataItems();
            }
            this.m_DataRange.shrinkTo(this.m_DataRange.getRowStart(), this.m_DataRange.getColStart(), this.m_DataRange.getRowStop(), this.m_DataRange.getColStop() - n7);
        }
    }

    public void deleteGroup(int n) {
        if (this.m_bSeriesAreRows) {
            int n2;
            int n3 = n2 = this.getCol(0, n, true);
            if (this.m_bItemsAlongSeries) {
                n3 += this.m_DataFormat.getNumDataItems() - 1;
            }
            int n4 = n2;
            while (n4 <= n3) {
                this.m_DataStorage.deleteCol(n4);
                ++n4;
            }
            n4 = 1;
            if (this.m_bItemsAlongSeries) {
                n4 = this.m_DataFormat.getNumDataItems();
            }
            this.m_DataRange.shrinkTo(this.m_DataRange.getRowStart(), this.m_DataRange.getColStart(), this.m_DataRange.getRowStop(), this.m_DataRange.getColStop() - n4);
        } else {
            int n5;
            int n6 = n5 = this.getRow(0, n, true);
            if (this.m_bItemsAlongSeries) {
                n6 += this.m_DataFormat.getNumDataItems() - 1;
            }
            int n7 = n5;
            while (n7 <= n6) {
                this.m_DataStorage.deleteRow(n7);
                ++n7;
            }
            n7 = 1;
            if (this.m_bItemsAlongSeries) {
                n7 = this.m_DataFormat.getNumDataItems();
            }
            this.m_DataRange.shrinkTo(this.m_DataRange.getRowStart(), this.m_DataRange.getColStart(), this.m_DataRange.getRowStop() - n7, this.m_DataRange.getColStop());
        }
    }

    protected void setViewableDataRange(Perspective perspective) {
        int n;
        int n2;
        DataRange dataRange = this.getViewableDataRangeSG(perspective);
        int n3 = dataRange.getNumRows();
        int n4 = dataRange.getNumCols();
        int n5 = dataRange.getRowStart();
        int n6 = dataRange.getColStart();
        int n7 = dataRange.getRowStop();
        int n8 = dataRange.getColStop();
        boolean bl = this.m_bReverseSeries;
        boolean bl2 = this.m_bReverseGroups;
        this.m_bReverseGroups = false;
        this.m_bReverseSeries = false;
        if (this.m_bItemsAlongRows) {
            n2 = this.m_DataFormat.getRowsPerNode();
            n = this.m_DataFormat.getColsPerNode();
        } else {
            n2 = this.m_DataFormat.getColsPerNode();
            n = this.m_DataFormat.getRowsPerNode();
        }
        int n9 = this.getRow(n5, n6);
        int n10 = this.getCol(n5, n6);
        int n11 = this.getRow(n7, n8) + n2 - 1;
        int n12 = this.getCol(n7, n8) + n - 1;
        this.m_bReverseSeries = bl;
        this.m_bReverseGroups = bl2;
        if (n11 > this.m_DataRange.getRowStop()) {
            n11 = this.m_DataRange.getRowStop();
        }
        if (n12 > this.m_DataRange.getColStop()) {
            n12 = this.m_DataRange.getColStop();
        }
        this.m_ViewableDataRange = new DataRange(n9, n10, n11, n12);
    }
}

