/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.gui.InsertButton;
import oracle.dss.util.gui.LimitedTextDocument;
import oracle.dss.util.gui.ViewTextField;
import oracle.dss.util.help.HelpContext;

public class Title
extends BasePanel
implements ActionListener,
ItemListener,
PropertyChangeListener,
CaretListener,
HelpContext {
    public static final String PROPERTY_TITLE_VISIBLE = "Title Visible";
    public static final String PROPERTY_SUBTITLE_VISIBLE = "Subtitle Visible";
    public static final String PROPERTY_FOOTNOTE_VISIBLE = "Footnote Visible";
    public static final String PROPERTY_TITLE_TEXT = "Title Text";
    public static final String PROPERTY_SUBTITLE_TEXT = "Subtitle Text";
    public static final String PROPERTY_FOOTNOTE_TEXT = "Footnote Text";
    protected boolean m_showTitle;
    protected boolean m_showSubtitle;
    protected boolean m_showFootnote;
    protected JCheckBox m_shTitleCBox;
    protected JCheckBox m_shSubtitleCBox;
    protected JCheckBox m_shFootnoteCBox;
    protected ViewTextField m_TitleTxt;
    protected ViewTextField m_SubtitleTxt;
    protected ViewTextField m_FootnoteTxt;
    protected ViewTextField m_TextArea;
    protected Font m_TitleFont;
    protected Font m_SubtitleFont;
    protected Font m_FootnoteFont;
    protected Font m_Font;
    protected int m_textRotation;
    protected int m_TitleTextRotation;
    protected int m_SubtitleTextRotation;
    protected int m_FootnoteTextRotation;
    protected FontButton m_TitleFontButton;
    protected FontButton m_SubtitleFontButton;
    protected FontButton m_FootnoteFontButton;
    protected InsertButton m_InsertTitle;
    protected InsertButton m_InsertSubtitle;
    protected InsertButton m_InsertFootnote;
    protected InsertButton m_Insert;
    protected TokenSubstitution m_token;
    protected boolean m_bFontNameChange;
    protected boolean m_bFontStyleChange;
    protected boolean m_bFontSizeChange;
    protected boolean m_bHorizontalAlignmentChange;
    protected boolean m_bFontColorChange;
    protected boolean m_bTextRotationChange;
    protected boolean m_bHelpEnabled;
    protected boolean m_bTitleFontNameChanged;
    protected boolean m_bTitleFontBoldChanged;
    protected boolean m_bTitleFontItalicChanged;
    protected boolean m_bTitleFontUnderlineChanged;
    protected boolean m_bTitleFontSizeChanged;
    protected boolean m_bTitleAlignmentChanged;
    protected boolean m_bTitleFontColorChanged;
    protected boolean m_bTitleVisibleChanged;
    protected boolean m_bTitleRotationChanged;
    protected boolean m_bSubtitleFontNameChanged;
    protected boolean m_bSubtitleFontBoldChanged;
    protected boolean m_bSubtitleFontItalicChanged;
    protected boolean m_bSubtitleFontUnderlineChanged;
    protected boolean m_bSubtitleFontSizeChanged;
    protected boolean m_bSubtitleAlignmentChanged;
    protected boolean m_bSubtitleFontColorChanged;
    protected boolean m_bSubtitleVisibleChanged;
    protected boolean m_bSubtitleRotationChanged;
    protected boolean m_bFootnoteFontNameChanged;
    protected boolean m_bFootnoteFontBoldChanged;
    protected boolean m_bFootnoteFontItalicChanged;
    protected boolean m_bFootnoteFontUnderlineChanged;
    protected boolean m_bFootnoteFontSizeChanged;
    protected boolean m_bFootnoteAlignmentChanged;
    protected boolean m_bFootnoteFontColorChanged;
    protected boolean m_bFootnoteVisibleChanged;
    protected boolean m_bFootnoteRotationChanged;
    protected boolean m_bTitleTextChanged;
    protected boolean m_bSubtitleTextChanged;
    protected boolean m_bFootnoteTextChanged;
    protected String m_oldFontName;
    protected String m_newFontName;
    protected int m_oldFontStyle;
    protected int m_newFontStyle;
    protected int m_oldFontSize;
    protected int m_newFontSize;
    protected int m_oldHAlignment;
    protected int m_newHAlignment;
    protected int m_oldRotation;
    protected int m_newRotation;
    protected Color m_oldFontColor;
    protected Color m_newFontColor;
    protected Color m_oldFontBackgroundColor;
    protected Color m_newFontBackgroundColor;
    protected String m_oldTitle;
    protected String m_oldSubtitle;
    protected String m_oldFootnote;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected Dimension prefSize;
    protected boolean insertButtonVisible = true;
    private ResourceBundle rBundle;
    private boolean m_bSuperCalled = true;
    private JPanel titlePanel;
    private JPanel subtitlePanel;
    private JPanel footnotePanel;
    private String[] tokenArray;

    public Title(Graph graph) {
        super(graph);
        this.m_graph = graph;
        this.updateResourceBundle(this.m_graph.getLocale());
        this.init();
        this.constructPanel();
    }

    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.initFromGraph();
        this.resetValues();
    }

    public void setColorPalette(Color[][] colorArray) {
        this.m_TitleFontButton.setColorPalette(colorArray);
        this.m_SubtitleFontButton.setColorPalette(colorArray);
        this.m_FootnoteFontButton.setColorPalette(colorArray);
    }

    public Color[][] getColorPalette() {
        return this.m_TitleFontButton.getColorPalette();
    }

    public void cleanUp() {
    }

    private void init() {
        this.m_showTitle = this.m_graph.getUITitle().isVisible();
        this.m_showSubtitle = this.m_graph.getUISubtitle().isVisible();
        this.m_showFootnote = this.m_graph.getUIFootnote().isVisible();
        this.m_token = this.m_graph.getTokenSubstitution();
        if (this.m_token != null) {
            this.tokenArray = this.m_token.getListItems();
            int n = 0;
            while (n < this.tokenArray.length) {
                this.tokenArray[n] = this.m_token.getToken(this.tokenArray[n]);
                ++n;
            }
        }
        this.initTitle();
        this.initSubtitle();
        this.initFootnote();
    }

    private void initFromGraph() {
        this.m_showTitle = this.m_graph.getUITitle().isVisible();
        this.m_showSubtitle = this.m_graph.getUISubtitle().isVisible();
        this.m_showFootnote = this.m_graph.getUIFootnote().isVisible();
        this.m_token = this.m_graph.getTokenSubstitution();
        this.m_TitleFont = this.m_graph.getUITitle().getFont();
        this.m_SubtitleFont = this.m_graph.getUISubtitle().getFont();
        this.m_FootnoteFont = this.m_graph.getUIFootnote().getFont();
        this.m_InsertTitle.removeActionListener(this);
        this.m_InsertSubtitle.removeActionListener(this);
        this.m_InsertFootnote.removeActionListener(this);
        this.m_InsertTitle.setModel(new DefaultComboBoxModel<String>(this.m_token.getListItems()));
        this.m_shTitleCBox.setSelected(this.m_showTitle);
        this.m_TitleTxt.setText(this.m_token.getTokenString(this.m_graph.getUITitle().getUnParseText()));
        this.m_TitleTxt.setFont(new Font(this.m_TitleFont.getName(), this.m_TitleFont.getStyle(), this.m_TitleTxt.getFont().getSize()));
        this.m_TitleTxt.setHorizontalAlignment(this.m_graph.getUITitle().getHorizontalAlignment());
        this.m_TitleTxt.setForeground(this.m_graph.getUITitle().getUIGraphFont().getGraphFontColor());
        if (this.m_TitleTxt.getText() != null) {
            this.m_TitleTxt.setCaretPosition(this.m_TitleTxt.getText().length());
        }
        this.m_TitleFontButton.setComponentFont(this.m_TitleFont);
        if (this.m_graph.getUITitle().getUIGraphFont().getGraphFontStyle() >= 4) {
            this.m_TitleFontButton.setUnderlineStyle(true);
            this.m_TitleTxt.setUnderline(true);
        } else {
            this.m_TitleFontButton.setUnderlineStyle(false);
            this.m_TitleTxt.setUnderline(false);
        }
        this.m_TitleFontButton.setPaneHorizontalAlignment(this.m_TitleTxt.getHorizontalAlignment());
        this.m_TitleFontButton.setComponentForeground(this.m_graph.getUITitle().getUIGraphFont().getGraphFontColor());
        this.m_TitleFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_InsertSubtitle.setModel(new DefaultComboBoxModel<String>(this.m_token.getListItems()));
        this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
        this.m_SubtitleTxt.setText(this.m_token.getTokenString(this.m_graph.getUISubtitle().getUnParseText()));
        this.m_SubtitleTxt.setFont(new Font(this.m_SubtitleFont.getName(), this.m_SubtitleFont.getStyle(), this.m_SubtitleTxt.getFont().getSize()));
        this.m_SubtitleTxt.setHorizontalAlignment(this.m_graph.getUISubtitle().getHorizontalAlignment());
        this.m_SubtitleTxt.setForeground(this.m_graph.getUISubtitle().getUIGraphFont().getGraphFontColor());
        if (this.m_SubtitleTxt.getText() != null) {
            this.m_SubtitleTxt.setCaretPosition(this.m_SubtitleTxt.getText().length());
        }
        this.m_SubtitleFontButton.setComponentFont(this.m_SubtitleFont);
        if (this.m_graph.getUISubtitle().getUIGraphFont().getGraphFontStyle() >= 4) {
            this.m_SubtitleFontButton.setUnderlineStyle(true);
            this.m_SubtitleTxt.setUnderline(true);
        } else {
            this.m_SubtitleFontButton.setUnderlineStyle(false);
            this.m_SubtitleTxt.setUnderline(false);
        }
        this.m_SubtitleFontButton.setPaneHorizontalAlignment(this.m_SubtitleTxt.getHorizontalAlignment());
        this.m_SubtitleFontButton.setComponentForeground(this.m_graph.getUISubtitle().getUIGraphFont().getGraphFontColor());
        this.m_SubtitleFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_InsertFootnote.setModel(new DefaultComboBoxModel<String>(this.m_token.getListItems()));
        this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
        this.m_FootnoteTxt.setText(this.m_token.getTokenString(this.m_graph.getUIFootnote().getUnParseText()));
        this.m_FootnoteTxt.setFont(new Font(this.m_FootnoteFont.getName(), this.m_FootnoteFont.getStyle(), this.m_FootnoteTxt.getFont().getSize()));
        this.m_FootnoteTxt.setHorizontalAlignment(this.m_graph.getUIFootnote().getHorizontalAlignment());
        this.m_FootnoteTxt.setForeground(this.m_graph.getUIFootnote().getUIGraphFont().getGraphFontColor());
        if (this.m_FootnoteTxt.getText() != null) {
            this.m_FootnoteTxt.setCaretPosition(this.m_FootnoteTxt.getText().length());
        }
        this.m_FootnoteFontButton.setComponentFont(this.m_FootnoteFont);
        if (this.m_graph.getUIFootnote().getUIGraphFont().getGraphFontStyle() >= 4) {
            this.m_FootnoteFontButton.setUnderlineStyle(true);
            this.m_FootnoteTxt.setUnderline(true);
        } else {
            this.m_FootnoteFontButton.setUnderlineStyle(false);
            this.m_FootnoteTxt.setUnderline(false);
        }
        this.m_FootnoteFontButton.setPaneHorizontalAlignment(this.m_FootnoteTxt.getHorizontalAlignment());
        this.m_FootnoteFontButton.setComponentForeground(this.m_graph.getUIFootnote().getUIGraphFont().getGraphFontColor());
        this.m_FootnoteFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_TitleFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUITitle().getTextRotation()));
        this.m_SubtitleFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUISubtitle().getTextRotation()));
        this.m_FootnoteFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUIFootnote().getTextRotation()));
        this.m_InsertTitle.addActionListener(this);
        this.m_InsertSubtitle.addActionListener(this);
        this.m_InsertFootnote.addActionListener(this);
    }

    private void constructPanel() {
        int n = 7;
        int n2 = 30;
        int n3 = 14;
        if (this.m_graph.getAutoLayout() != 0) {
            n3 = 0;
        }
        String string = this.rBundle.getString("titles text");
        this.setTitleText(string);
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        String string2 = this.rBundle.getString("Show Title");
        this.m_shTitleCBox = new JCheckBox(StringUtils.stripMnemonic((String)string2));
        this.m_shTitleCBox.setAlignmentY(1.0f);
        this.m_shTitleCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        this.m_shTitleCBox.setSelected(this.m_showTitle);
        this.titlePanel.add(this.m_shTitleCBox);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(1.0f);
        this.m_InsertTitle = new InsertButton(this.m_token.getListItems());
        this.m_InsertTitle.setAlignmentY(1.0f);
        this.m_InsertTitle.setLocale(this.m_graph.getLocale());
        this.m_InsertTitle.setType(0);
        string2 = this.rBundle.getString("Title Font");
        this.m_TitleFontButton = new FontButton(StringUtils.stripMnemonic((String)string2));
        this.m_TitleFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_TitleFontButton.setAlignmentY(1.0f);
        this.m_TitleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        string2 = this.rBundle.getString("Title Font For FontButton");
        this.m_TitleFontButton.setDialogTitle(string2);
        this.m_TitleFontButton.setPaneLocale(this.m_graph.getLocale());
        this.m_TitleFontButton.setComponentFont(this.m_TitleFont);
        if (this.m_graph.getUITitle().getUIGraphFont().getGraphFontStyle() >= 4) {
            this.m_TitleFontButton.setUnderlineStyle(true);
            this.m_TitleTxt.setUnderline(true);
        }
        int n4 = this.m_TitleTxt.getHorizontalAlignment();
        this.m_TitleFontButton.setPaneHorizontalAlignment(n4);
        this.m_TitleFontButton.setStyleButtonMask(n);
        this.m_TitleFontButton.setAlignmentButtonMask(n2);
        this.m_TitleFontButton.setRotationButtonMask(n3);
        this.m_TitleFontButton.setColorComponentMask(1);
        this.m_TitleFontButton.setComponentForeground(this.m_graph.getUITitle().getUIGraphFont().getGraphFontColor());
        jPanel.add((Component)((Object)this.m_InsertTitle));
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.m_TitleFontButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.setAlignmentY(1.0f);
        jPanel2.add(jPanel);
        this.titlePanel.add(jPanel2);
        int n5 = this.m_shTitleCBox.getPreferredSize().width + jPanel.getPreferredSize().width;
        int n6 = Math.max(jPanel.getPreferredSize().height, this.m_shTitleCBox.getPreferredSize().height);
        this.titlePanel.setPreferredSize(new Dimension(n5, n6));
        this.titlePanel.setMinimumSize(this.titlePanel.getPreferredSize());
        this.titlePanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, n6));
        this.subtitlePanel = new JPanel();
        this.subtitlePanel.setLayout(new BoxLayout(this.subtitlePanel, 0));
        string2 = this.rBundle.getString("Show Subtitle");
        this.m_shSubtitleCBox = new JCheckBox(StringUtils.stripMnemonic((String)string2));
        this.m_shSubtitleCBox.setAlignmentY(1.0f);
        this.m_shSubtitleCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
        this.subtitlePanel.add(this.m_shSubtitleCBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentY(1.0f);
        this.m_InsertSubtitle = new InsertButton(this.m_token.getListItems());
        this.m_InsertSubtitle.setAlignmentY(1.0f);
        this.m_InsertSubtitle.setLocale(this.m_graph.getLocale());
        this.m_InsertSubtitle.setType(1);
        string2 = this.rBundle.getString("Subtitle Font");
        this.m_SubtitleFontButton = new FontButton(StringUtils.stripMnemonic((String)string2));
        this.m_SubtitleFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_SubtitleFontButton.setAlignmentY(1.0f);
        this.m_SubtitleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        string2 = this.rBundle.getString("Subtitle Font For FontButton");
        this.m_SubtitleFontButton.setDialogTitle(string2);
        this.m_SubtitleFontButton.setPaneLocale(this.m_graph.getLocale());
        this.m_SubtitleFontButton.setComponentFont(this.m_SubtitleFont);
        if (this.m_graph.getUISubtitle().getUIGraphFont().getGraphFontStyle() >= 4) {
            this.m_SubtitleFontButton.setUnderlineStyle(true);
            this.m_SubtitleTxt.setUnderline(true);
        }
        n4 = this.m_SubtitleTxt.getHorizontalAlignment();
        this.m_SubtitleFontButton.setPaneHorizontalAlignment(n4);
        this.m_SubtitleFontButton.setStyleButtonMask(n);
        this.m_SubtitleFontButton.setAlignmentButtonMask(n2);
        this.m_SubtitleFontButton.setRotationButtonMask(n3);
        this.m_SubtitleFontButton.setColorComponentMask(1);
        this.m_SubtitleFontButton.setComponentForeground(this.m_graph.getUISubtitle().getUIGraphFont().getGraphFontColor());
        jPanel3.add((Component)((Object)this.m_InsertSubtitle));
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel3.add(this.m_SubtitleFontButton);
        JPanel jPanel4 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel4.setAlignmentY(1.0f);
        jPanel4.add(jPanel3);
        this.subtitlePanel.add(jPanel4);
        n5 = this.m_shSubtitleCBox.getPreferredSize().width + jPanel3.getPreferredSize().width;
        n6 = Math.max(jPanel3.getPreferredSize().height, this.m_shSubtitleCBox.getPreferredSize().height);
        this.subtitlePanel.setPreferredSize(new Dimension(n5, n6));
        this.subtitlePanel.setMinimumSize(this.subtitlePanel.getPreferredSize());
        this.subtitlePanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, n6));
        this.footnotePanel = new JPanel();
        this.footnotePanel.setLayout(new BoxLayout(this.footnotePanel, 0));
        string2 = this.rBundle.getString("Show Footnote");
        this.m_shFootnoteCBox = new JCheckBox(StringUtils.stripMnemonic((String)string2));
        this.m_shFootnoteCBox.setAlignmentY(1.0f);
        this.m_shFootnoteCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
        this.footnotePanel.add(this.m_shFootnoteCBox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.setAlignmentY(1.0f);
        this.m_InsertFootnote = new InsertButton(this.m_token.getListItems());
        this.m_InsertFootnote.setAlignmentY(1.0f);
        this.m_InsertFootnote.setLocale(this.m_graph.getLocale());
        this.m_InsertFootnote.setType(2);
        string2 = this.rBundle.getString("Footnote Font");
        this.m_FootnoteFontButton = new FontButton(StringUtils.stripMnemonic((String)string2));
        this.m_FootnoteFontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_FootnoteFontButton.setAlignmentY(1.0f);
        this.m_FootnoteFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        string2 = this.rBundle.getString("Footnote Font For FontButton");
        this.m_FootnoteFontButton.setDialogTitle(string2);
        this.m_FootnoteFontButton.setPaneLocale(this.m_graph.getLocale());
        this.m_FootnoteFontButton.setComponentFont(this.m_FootnoteFont);
        if (this.m_graph.getUIFootnote().getUIGraphFont().getGraphFontStyle() >= 4) {
            this.m_FootnoteFontButton.setUnderlineStyle(true);
            this.m_FootnoteTxt.setUnderline(true);
        }
        n4 = this.m_FootnoteTxt.getHorizontalAlignment();
        this.m_FootnoteFontButton.setPaneHorizontalAlignment(n4);
        this.m_FootnoteFontButton.setStyleButtonMask(n);
        this.m_FootnoteFontButton.setAlignmentButtonMask(n2);
        this.m_FootnoteFontButton.setRotationButtonMask(n3);
        this.m_FootnoteFontButton.setColorComponentMask(1);
        this.m_FootnoteFontButton.setComponentForeground(this.m_graph.getUIFootnote().getUIGraphFont().getGraphFontColor());
        this.m_TitleFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUITitle().getTextRotation()));
        this.m_SubtitleFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUISubtitle().getTextRotation()));
        this.m_FootnoteFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUIFootnote().getTextRotation()));
        this.m_TitleTextRotation = this.m_TitleFontButton.getTextRotation();
        this.m_SubtitleTextRotation = this.m_SubtitleFontButton.getTextRotation();
        this.m_FootnoteTextRotation = this.m_FootnoteFontButton.getTextRotation();
        jPanel5.add((Component)((Object)this.m_InsertFootnote));
        jPanel5.add(Box.createHorizontalStrut(10));
        jPanel5.add(this.m_FootnoteFontButton);
        JPanel jPanel6 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel6.setAlignmentY(1.0f);
        jPanel6.add(jPanel5);
        this.footnotePanel.add(jPanel6);
        n5 = this.m_shFootnoteCBox.getPreferredSize().width + jPanel5.getPreferredSize().width;
        n6 = Math.max(jPanel5.getPreferredSize().height, this.m_shFootnoteCBox.getPreferredSize().height);
        this.footnotePanel.setPreferredSize(new Dimension(n5, n6));
        this.footnotePanel.setMinimumSize(this.footnotePanel.getPreferredSize());
        this.footnotePanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, n6));
        int n7 = this.m_TitleFontButton.getPreferredSize().width;
        int n8 = this.m_SubtitleFontButton.getPreferredSize().width;
        int n9 = this.m_FootnoteFontButton.getPreferredSize().width;
        int n10 = n7;
        if (n8 > n10) {
            n10 = n8;
        }
        if (n9 > n10) {
            n10 = n9;
        }
        this.m_TitleFontButton.setPreferredSize(new Dimension(n10, this.m_TitleFontButton.getPreferredSize().height));
        this.m_TitleFontButton.setMinimumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_TitleFontButton.setMaximumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_SubtitleFontButton.setPreferredSize(this.m_TitleFontButton.getPreferredSize());
        this.m_SubtitleFontButton.setMinimumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_SubtitleFontButton.setMaximumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_FootnoteFontButton.setPreferredSize(this.m_TitleFontButton.getPreferredSize());
        this.m_FootnoteFontButton.setMinimumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_FootnoteFontButton.setMaximumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_mainPanel.add(this.titlePanel);
        this.m_mainPanel.add(Box.createVerticalStrut(5));
        this.m_mainPanel.add(this.m_TitleTxt);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.subtitlePanel);
        this.m_mainPanel.add(Box.createVerticalStrut(5));
        this.m_mainPanel.add(this.m_SubtitleTxt);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.footnotePanel);
        this.m_mainPanel.add(Box.createVerticalStrut(5));
        this.m_mainPanel.add(this.m_FootnoteTxt);
        this.calculatePreferredSize();
        this.m_shTitleCBox.addItemListener(this);
        this.m_shSubtitleCBox.addItemListener(this);
        this.m_shFootnoteCBox.addItemListener(this);
        this.m_InsertTitle.addActionListener(this);
        this.m_InsertSubtitle.addActionListener(this);
        this.m_InsertFootnote.addActionListener(this);
        this.m_TitleFontButton.addPropertyChangeListener(this);
        this.m_SubtitleFontButton.addPropertyChangeListener(this);
        this.m_FootnoteFontButton.addPropertyChangeListener(this);
        this.resetValues();
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void initTitle() {
        LimitedTextDocument limitedTextDocument = new LimitedTextDocument(1024, this.tokenArray);
        String string = this.m_token.getTokenString(this.m_graph.getUITitle().getUnParseText());
        this.m_TitleTxt = new ViewTextField(limitedTextDocument, string, 0);
        this.m_TitleTxt.setComponentOrientation(this.getOrientation());
        this.m_TitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Title TextField"));
        this.m_TitleTxt.setPreferredSize(new Dimension(400, 25));
        this.m_TitleTxt.setMinimumSize(this.m_TitleTxt.getPreferredSize());
        this.m_TitleTxt.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_TitleTxt.getPreferredSize().height));
        this.m_TitleFont = this.m_graph.getUITitle().getFont();
        this.m_TitleTxt.setFont(new Font(this.m_TitleFont.getName(), this.m_TitleFont.getStyle(), this.m_TitleTxt.getFont().getSize()));
        this.m_TitleTxt.setHorizontalAlignment(this.m_graph.getUITitle().getHorizontalAlignment());
        this.m_TitleTxt.setForeground(this.m_graph.getUITitle().getUIGraphFont().getGraphFontColor());
        this.m_TitleTxt.addCaretListener(this);
    }

    public void initSubtitle() {
        LimitedTextDocument limitedTextDocument = new LimitedTextDocument(1024, this.tokenArray);
        String string = this.m_token.getTokenString(this.m_graph.getUISubtitle().getUnParseText());
        this.m_SubtitleTxt = new ViewTextField(limitedTextDocument, string, 0);
        this.m_SubtitleTxt.setComponentOrientation(this.getOrientation());
        this.m_SubtitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Subtitle TextField"));
        this.m_SubtitleTxt.setPreferredSize(new Dimension(400, 25));
        this.m_SubtitleTxt.setMinimumSize(this.m_SubtitleTxt.getPreferredSize());
        this.m_SubtitleTxt.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_SubtitleTxt.getPreferredSize().height));
        this.m_SubtitleFont = this.m_graph.getUISubtitle().getFont();
        this.m_SubtitleTxt.setFont(new Font(this.m_SubtitleFont.getName(), this.m_SubtitleFont.getStyle(), this.m_SubtitleTxt.getFont().getSize()));
        this.m_SubtitleTxt.setHorizontalAlignment(this.m_graph.getUISubtitle().getHorizontalAlignment());
        this.m_SubtitleTxt.setForeground(this.m_graph.getUISubtitle().getUIGraphFont().getGraphFontColor());
        this.m_SubtitleTxt.addCaretListener(this);
    }

    public void initFootnote() {
        LimitedTextDocument limitedTextDocument = new LimitedTextDocument(1024, this.tokenArray);
        String string = this.m_token.getTokenString(this.m_graph.getUIFootnote().getUnParseText());
        this.m_FootnoteTxt = new ViewTextField(limitedTextDocument, string, 0);
        this.m_FootnoteTxt.setComponentOrientation(this.getOrientation());
        this.m_FootnoteTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Footnote TextField"));
        this.m_FootnoteTxt.setPreferredSize(new Dimension(400, 25));
        this.m_FootnoteTxt.setMinimumSize(this.m_FootnoteTxt.getPreferredSize());
        this.m_FootnoteTxt.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_FootnoteTxt.getPreferredSize().height));
        this.m_FootnoteFont = this.m_graph.getUIFootnote().getFont();
        this.m_FootnoteTxt.setFont(new Font(this.m_FootnoteFont.getName(), this.m_FootnoteFont.getStyle(), this.m_FootnoteTxt.getFont().getSize()));
        this.m_FootnoteTxt.setHorizontalAlignment(this.m_graph.getUIFootnote().getHorizontalAlignment());
        this.m_FootnoteTxt.setForeground(this.m_graph.getUIFootnote().getUIGraphFont().getGraphFontColor());
        this.m_FootnoteTxt.addCaretListener(this);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.m_TitleTxt) {
            String string = this.m_TitleTxt.getText();
            if (string.length() > 0) {
                this.m_oldTitle = string;
                if (!this.m_showTitle) {
                    this.m_showTitle = true;
                    this.m_shTitleCBox.setSelected(this.m_showTitle);
                    this.firePropertyChange(PROPERTY_TITLE_TEXT, this.m_oldTitle, string);
                }
                this.m_bTitleTextChanged = true;
            } else {
                this.m_showTitle = false;
                this.m_shTitleCBox.setSelected(this.m_showTitle);
                this.firePropertyChange(PROPERTY_TITLE_TEXT, this.m_oldTitle, string);
                this.m_bTitleTextChanged = true;
            }
        } else if (caretEvent.getSource() == this.m_SubtitleTxt) {
            String string = this.m_SubtitleTxt.getText();
            if (string.length() > 0) {
                this.m_oldSubtitle = string;
                if (!this.m_showSubtitle) {
                    this.m_showSubtitle = true;
                    this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
                    this.firePropertyChange(PROPERTY_SUBTITLE_TEXT, this.m_oldSubtitle, string);
                }
                this.m_bSubtitleTextChanged = true;
            } else {
                this.m_showSubtitle = false;
                this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
                this.firePropertyChange(PROPERTY_SUBTITLE_TEXT, this.m_oldSubtitle, string);
                this.m_bSubtitleTextChanged = true;
            }
        } else if (caretEvent.getSource() == this.m_FootnoteTxt) {
            String string = this.m_FootnoteTxt.getText();
            if (string.length() > 0) {
                this.m_oldFootnote = string;
                if (!this.m_showFootnote) {
                    this.m_showFootnote = true;
                    this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
                    this.firePropertyChange(PROPERTY_FOOTNOTE_TEXT, this.m_oldFootnote, string);
                }
                this.m_bFootnoteTextChanged = true;
            } else {
                this.m_showFootnote = false;
                this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
                this.firePropertyChange(PROPERTY_FOOTNOTE_TEXT, this.m_oldFootnote, string);
                this.m_bFootnoteTextChanged = true;
            }
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this.m_InsertTitle.setLocale(locale);
        this.m_InsertSubtitle.setLocale(locale);
        this.m_InsertFootnote.setLocale(locale);
        this.m_TitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Title TextField"));
        this.m_SubtitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Subtitle TextField"));
        this.m_FootnoteTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Footnote TextField"));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        boolean bl;
        if (propertyChangeEvent.getSource() == this.m_TitleFontButton) {
            this.m_TextArea = this.m_TitleTxt;
            this.m_Font = this.m_TitleFont;
            this.m_textRotation = this.m_TitleTextRotation;
        } else if (propertyChangeEvent.getSource() == this.m_SubtitleFontButton) {
            this.m_TextArea = this.m_SubtitleTxt;
            this.m_Font = this.m_SubtitleFont;
            this.m_textRotation = this.m_SubtitleTextRotation;
        } else if (propertyChangeEvent.getSource() == this.m_FootnoteFontButton) {
            this.m_TextArea = this.m_FootnoteTxt;
            this.m_Font = this.m_FootnoteFont;
            this.m_textRotation = this.m_FootnoteTextRotation;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == "fontDialogCancelled" && !(bl = ((Boolean)(object = (Boolean)propertyChangeEvent.getNewValue())).booleanValue())) {
            if (this.m_bFontNameChange) {
                this.firePropertyChange("fontName", this.m_oldFontName, this.m_newFontName);
                if (this.m_TextArea == this.m_TitleTxt) {
                    this.m_bTitleFontNameChanged = true;
                } else if (this.m_TextArea == this.m_SubtitleTxt) {
                    this.m_bSubtitleFontNameChanged = true;
                } else {
                    this.m_bFootnoteFontNameChanged = true;
                }
                this.m_Font = new Font(this.m_newFontName, this.m_Font.getStyle(), this.m_Font.getSize());
                this.m_TextArea.setFont(new Font(this.m_newFontName, this.m_Font.getStyle(), this.m_TextArea.getFont().getSize()));
                this.m_bFontNameChange = false;
            }
            if (this.m_bFontStyleChange) {
                this.firePropertyChange("fontStyle", this.m_oldFontStyle, this.m_newFontStyle);
                if (this.m_newFontStyle >= 4) {
                    this.m_TextArea.setUnderline(true);
                } else {
                    this.m_TextArea.setUnderline(false);
                }
                boolean bl2 = false;
                boolean bl3 = false;
                if ((this.m_newFontStyle & 1) != 0) {
                    bl2 = true;
                }
                if ((this.m_newFontStyle & 2) != 0) {
                    bl3 = true;
                }
                this.m_Font = new Font(this.m_Font.getName(), this.m_newFontStyle, this.m_Font.getSize());
                this.m_TextArea.setFont(new Font(this.m_Font.getName(), ViewStyle.fontStyle(bl2, bl3), this.m_TextArea.getFont().getSize()));
                int n = this.m_oldFontStyle ^ this.m_newFontStyle;
                if ((n & 1) != 0) {
                    if (this.m_TextArea == this.m_TitleTxt) {
                        this.m_bTitleFontBoldChanged = true;
                    } else if (this.m_TextArea == this.m_SubtitleTxt) {
                        this.m_bSubtitleFontBoldChanged = true;
                    } else {
                        this.m_bFootnoteFontBoldChanged = true;
                    }
                }
                if ((n & 2) != 0) {
                    if (this.m_TextArea == this.m_TitleTxt) {
                        this.m_bTitleFontItalicChanged = true;
                    } else if (this.m_TextArea == this.m_SubtitleTxt) {
                        this.m_bSubtitleFontItalicChanged = true;
                    } else {
                        this.m_bFootnoteFontItalicChanged = true;
                    }
                }
                if ((n & 4) != 0) {
                    if (this.m_TextArea == this.m_TitleTxt) {
                        this.m_bTitleFontUnderlineChanged = true;
                    } else if (this.m_TextArea == this.m_SubtitleTxt) {
                        this.m_bSubtitleFontUnderlineChanged = true;
                    } else {
                        this.m_bFootnoteFontUnderlineChanged = true;
                    }
                }
                this.m_bFontStyleChange = false;
            }
            if (this.m_bFontSizeChange) {
                this.firePropertyChange("fontSize", this.m_oldFontSize, this.m_newFontSize);
                if (this.m_TextArea == this.m_TitleTxt) {
                    this.m_bTitleFontSizeChanged = true;
                } else if (this.m_TextArea == this.m_SubtitleTxt) {
                    this.m_bSubtitleFontSizeChanged = true;
                } else {
                    this.m_bFootnoteFontSizeChanged = true;
                }
                this.m_Font = new Font(this.m_Font.getName(), this.m_Font.getStyle(), this.m_newFontSize);
                this.m_bFontSizeChange = false;
            }
            if (this.m_bHorizontalAlignmentChange) {
                this.firePropertyChange("fontHorizontalAlignment", this.m_oldHAlignment, this.m_newHAlignment);
                this.m_TextArea.setHorizontalAlignment(this.m_newHAlignment);
                this.m_bHorizontalAlignmentChange = false;
                if (this.m_TextArea == this.m_TitleTxt) {
                    this.m_bTitleAlignmentChanged = true;
                } else if (this.m_TextArea == this.m_SubtitleTxt) {
                    this.m_bSubtitleAlignmentChanged = true;
                } else {
                    this.m_bFootnoteAlignmentChanged = true;
                }
            }
            if (this.m_bFontColorChange) {
                this.firePropertyChange("fontColor", this.m_oldFontColor, this.m_newFontColor);
                this.m_TextArea.setForeground(this.m_newFontColor);
                this.m_bFontColorChange = false;
                if (this.m_TextArea == this.m_TitleTxt) {
                    this.m_bTitleFontColorChanged = true;
                } else if (this.m_TextArea == this.m_SubtitleTxt) {
                    this.m_bSubtitleFontColorChanged = true;
                } else {
                    this.m_bFootnoteFontColorChanged = true;
                }
            }
            if (this.m_bTextRotationChange) {
                this.firePropertyChange("textRotation", this.m_oldRotation, this.m_newRotation);
                this.m_textRotation = this.m_newRotation;
                this.m_bTextRotationChange = false;
                if (this.m_TextArea == this.m_TitleTxt) {
                    this.m_bTitleRotationChanged = true;
                } else if (this.m_TextArea == this.m_SubtitleTxt) {
                    this.m_bSubtitleRotationChanged = true;
                } else {
                    this.m_bFootnoteRotationChanged = true;
                }
            }
            this.m_TextArea.repaint();
        }
        if (string == "fontHorizontalAlignment") {
            object = (Integer)propertyChangeEvent.getOldValue();
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            if (!this.m_bHorizontalAlignmentChange) {
                this.m_oldHAlignment = (Integer)object;
            }
            this.m_newHAlignment = n;
            if ((Integer)object != this.m_newHAlignment) {
                this.m_bHorizontalAlignmentChange = true;
            }
        }
        if (string == "textRotation") {
            object = (Integer)propertyChangeEvent.getOldValue();
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            if (!this.m_bTextRotationChange) {
                this.m_oldRotation = (Integer)object;
            }
            this.m_newRotation = n;
            if ((Integer)object != this.m_newRotation) {
                this.m_bTextRotationChange = true;
            }
        }
        if (string == "fontColor") {
            object = (Color)propertyChangeEvent.getOldValue();
            if (!this.m_bFontColorChange) {
                this.m_oldFontColor = object;
            }
            this.m_newFontColor = (Color)propertyChangeEvent.getNewValue();
            if (object != this.m_newFontColor) {
                this.m_bFontColorChange = true;
            }
        }
        if (string == "fontName") {
            object = (String)propertyChangeEvent.getOldValue();
            if (!this.m_bFontNameChange) {
                this.m_oldFontName = object;
            }
            this.m_newFontName = (String)propertyChangeEvent.getNewValue();
            if (object != this.m_newFontName) {
                this.m_bFontNameChange = true;
            }
        }
        if (string == "fontStyle") {
            object = (Integer)propertyChangeEvent.getOldValue();
            if (!this.m_bFontStyleChange) {
                this.m_oldFontStyle = (Integer)object;
            }
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            this.m_newFontStyle = n;
            if ((Integer)object != this.m_newFontStyle) {
                this.m_bFontStyleChange = true;
            }
        }
        if (string == "fontSize") {
            object = (Integer)propertyChangeEvent.getOldValue();
            if (!this.m_bFontSizeChange) {
                this.m_oldFontSize = (Integer)object;
            }
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            this.m_newFontSize = n;
            if ((Integer)object != this.m_newFontSize) {
                this.m_bFontSizeChange = true;
            }
        }
        if (propertyChangeEvent.getSource() == this.m_TitleFontButton) {
            this.m_TitleFont = this.m_Font;
            this.m_TitleTextRotation = this.m_textRotation;
        } else if (propertyChangeEvent.getSource() == this.m_SubtitleFontButton) {
            this.m_SubtitleFont = this.m_Font;
            this.m_SubtitleTextRotation = this.m_textRotation;
        } else if (propertyChangeEvent.getSource() == this.m_FootnoteFontButton) {
            this.m_FootnoteFont = this.m_Font;
            this.m_FootnoteTextRotation = this.m_textRotation;
        }
    }

    public void apply() {
        boolean bl = false;
        int n = -1;
        if (this.m_bTitleTextChanged) {
            this.m_graph.getUITitle().setText(this.m_token.getKeyString(this.m_TitleTxt.getText()));
        }
        if (this.m_bTitleVisibleChanged) {
            this.m_graph.getUITitle().setVisible(this.m_showTitle);
        }
        if (this.m_bTitleFontNameChanged) {
            this.m_graph.getUITitle().getUIGraphFont().setGraphFontTypeface(this.m_TitleFont.getFamily());
        }
        if (this.m_bTitleFontBoldChanged) {
            this.m_graph.getUITitle().getUIGraphFont().setFontBold(this.m_TitleFont.isBold());
        }
        if (this.m_bTitleFontItalicChanged) {
            this.m_graph.getUITitle().getUIGraphFont().setFontItalic(this.m_TitleFont.isItalic());
        }
        if (this.m_bTitleFontUnderlineChanged) {
            this.m_graph.getUITitle().getUIGraphFont().setUnderline(this.m_TitleTxt.isUnderline());
        }
        if (this.m_bTitleFontSizeChanged) {
            this.m_graph.getUITitle().getUIGraphFont().setGraphFontSize(this.m_TitleFont.getSize());
        }
        if (this.m_bTitleAlignmentChanged) {
            this.m_graph.getUITitle().setHorizontalAlignment(this.m_TitleTxt.getHorizontalAlignment());
        }
        if (this.m_bTitleFontColorChanged) {
            this.m_graph.getUITitle().getUIGraphFont().setGraphFontColor(this.m_TitleTxt.getForeground());
        }
        if (this.m_bTitleRotationChanged && (n = this.convertFromFontButtonConstants(this.m_TitleTextRotation)) != -1) {
            this.m_graph.getUITitle().setTextRotation(n);
        }
        if (this.m_bSubtitleTextChanged) {
            this.m_graph.getUISubtitle().setText(this.m_token.getKeyString(this.m_SubtitleTxt.getText()));
        }
        if (this.m_bSubtitleVisibleChanged) {
            this.m_graph.getUISubtitle().setVisible(this.m_showSubtitle);
        }
        if (this.m_bSubtitleFontNameChanged) {
            this.m_graph.getUISubtitle().getUIGraphFont().setGraphFontTypeface(this.m_SubtitleFont.getFamily());
        }
        if (this.m_bSubtitleFontBoldChanged) {
            this.m_graph.getUISubtitle().getUIGraphFont().setFontBold(this.m_SubtitleFont.isBold());
        }
        if (this.m_bSubtitleFontItalicChanged) {
            this.m_graph.getUISubtitle().getUIGraphFont().setFontItalic(this.m_SubtitleFont.isItalic());
        }
        if (this.m_bSubtitleFontUnderlineChanged) {
            this.m_graph.getUISubtitle().getUIGraphFont().setUnderline(this.m_SubtitleTxt.isUnderline());
        }
        if (this.m_bSubtitleFontSizeChanged) {
            this.m_graph.getUISubtitle().getUIGraphFont().setGraphFontSize(this.m_SubtitleFont.getSize());
        }
        if (this.m_bSubtitleAlignmentChanged) {
            this.m_graph.getUISubtitle().setHorizontalAlignment(this.m_SubtitleTxt.getHorizontalAlignment());
        }
        if (this.m_bSubtitleFontColorChanged) {
            this.m_graph.getUISubtitle().getUIGraphFont().setGraphFontColor(this.m_SubtitleTxt.getForeground());
        }
        if (this.m_bSubtitleRotationChanged && (n = this.convertFromFontButtonConstants(this.m_SubtitleTextRotation)) != -1) {
            this.m_graph.getUISubtitle().setTextRotation(n);
        }
        if (this.m_bFootnoteTextChanged) {
            this.m_graph.getUIFootnote().setText(this.m_token.getKeyString(this.m_FootnoteTxt.getText()));
        }
        if (this.m_bFootnoteVisibleChanged) {
            this.m_graph.getUIFootnote().setVisible(this.m_showFootnote);
        }
        if (this.m_bFootnoteFontNameChanged) {
            this.m_graph.getUIFootnote().getUIGraphFont().setGraphFontTypeface(this.m_FootnoteFont.getFamily());
        }
        if (this.m_bFootnoteFontBoldChanged) {
            this.m_graph.getUIFootnote().getUIGraphFont().setFontBold(this.m_FootnoteFont.isBold());
        }
        if (this.m_bFootnoteFontItalicChanged) {
            this.m_graph.getUIFootnote().getUIGraphFont().setFontItalic(this.m_FootnoteFont.isItalic());
        }
        if (this.m_bFootnoteFontUnderlineChanged) {
            this.m_graph.getUIFootnote().getUIGraphFont().setUnderline(this.m_FootnoteTxt.isUnderline());
        }
        if (this.m_bFootnoteFontSizeChanged) {
            this.m_graph.getUIFootnote().getUIGraphFont().setGraphFontSize(this.m_FootnoteFont.getSize());
        }
        if (this.m_bFootnoteAlignmentChanged) {
            this.m_graph.getUIFootnote().setHorizontalAlignment(this.m_FootnoteTxt.getHorizontalAlignment());
        }
        if (this.m_bFootnoteFontColorChanged) {
            this.m_graph.getUIFootnote().getUIGraphFont().setGraphFontColor(this.m_FootnoteTxt.getForeground());
        }
        if (this.m_bFootnoteRotationChanged && (n = this.convertFromFontButtonConstants(this.m_FootnoteTextRotation)) != -1) {
            this.m_graph.getUIFootnote().setTextRotation(n);
        }
    }

    private int getUnderlineStyle(Font font) {
        int n = 0;
        switch (font.getStyle()) {
            case 0: {
                n = 4;
                break;
            }
            case 1: {
                n = 6;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 7;
            }
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_InsertTitle) {
            this.m_TextArea = this.m_TitleTxt;
            this.m_Insert = this.m_InsertTitle;
        } else if (actionEvent.getSource() == this.m_InsertSubtitle) {
            this.m_TextArea = this.m_SubtitleTxt;
            this.m_Insert = this.m_InsertSubtitle;
        } else if (actionEvent.getSource() == this.m_InsertFootnote) {
            this.m_TextArea = this.m_FootnoteTxt;
            this.m_Insert = this.m_InsertFootnote;
        }
        String string = this.m_Insert.getSelectedItem();
        if (string != null) {
            String string2 = this.m_TextArea.getText();
            String string3 = String.valueOf(string2.substring(0, this.m_TextArea.getCaretPosition())) + this.m_token.getToken(string) + string2.substring(this.m_TextArea.getCaretPosition(), string2.length());
            this.firePropertyChange(PROPERTY_TITLE_TEXT, string2, string3);
            if (actionEvent.getSource() == this.m_InsertTitle) {
                this.m_showTitle = true;
                this.m_shTitleCBox.setSelected(this.m_showTitle);
            } else if (actionEvent.getSource() == this.m_InsertSubtitle) {
                this.m_showSubtitle = true;
                this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
            } else if (actionEvent.getSource() == this.m_InsertFootnote) {
                this.m_showFootnote = true;
                this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
            }
            String string4 = String.valueOf(string2.substring(0, this.m_TextArea.getCaretPosition())) + this.m_token.getToken(string);
            this.m_TextArea.setText(string3);
            this.m_TextArea.requestFocus();
            if (string4.length() > 1024) {
                this.m_TextArea.setCaretPosition(this.m_TextArea.getText().length());
            } else {
                this.m_TextArea.setCaretPosition(string4.length());
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_shTitleCBox) {
            if (itemEvent.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_TITLE_VISIBLE, false, true);
                this.m_showTitle = true;
            } else {
                this.firePropertyChange(PROPERTY_TITLE_VISIBLE, true, false);
                this.m_showTitle = false;
            }
            this.m_bTitleVisibleChanged = true;
        }
        if (itemEvent.getSource() == this.m_shSubtitleCBox) {
            if (itemEvent.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_SUBTITLE_VISIBLE, false, true);
                this.m_showSubtitle = true;
            } else {
                this.firePropertyChange(PROPERTY_SUBTITLE_VISIBLE, true, false);
                this.m_showSubtitle = false;
            }
            this.m_bSubtitleVisibleChanged = true;
        }
        if (itemEvent.getSource() == this.m_shFootnoteCBox) {
            if (itemEvent.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_FOOTNOTE_VISIBLE, false, true);
                this.m_showFootnote = true;
            } else {
                this.firePropertyChange(PROPERTY_FOOTNOTE_VISIBLE, true, false);
                this.m_showFootnote = false;
            }
            this.m_bFootnoteVisibleChanged = true;
        }
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    private void calculatePreferredSize() {
        int n = 0;
        int n2 = this.titlePanel.getPreferredSize().width;
        if (n < n2) {
            n = n2;
        }
        if (n < (n2 = this.m_TitleTxt.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.subtitlePanel.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.m_SubtitleTxt.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.footnotePanel.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.m_FootnoteTxt.getPreferredSize().width)) {
            n = n2;
        }
        n2 = n + 10 + 10;
        int n3 = this.m_mainPanel.getPreferredSize().height + this.m_label.getPreferredSize().height + 10 + 10 + 15;
        this.prefSize = new Dimension(n2, n3);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        this.m_TitleFontButton.setHelpProvider(helpProvider);
        this.m_SubtitleFontButton.setHelpProvider(helpProvider);
        this.m_FootnoteFontButton.setHelpProvider(helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setInsertButtonVisible(boolean bl) {
        this.m_InsertTitle.setVisible(bl);
        this.m_InsertSubtitle.setVisible(bl);
        this.m_InsertFootnote.setVisible(bl);
        this.insertButtonVisible = bl;
    }

    public boolean isInsertButtonVisible() {
        return this.insertButtonVisible;
    }

    protected int convertToFontButtonConstants(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    protected int convertFromFontButtonConstants(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    private void resetValues() {
        this.m_bTitleFontNameChanged = false;
        this.m_bTitleFontBoldChanged = false;
        this.m_bTitleFontItalicChanged = false;
        this.m_bTitleFontUnderlineChanged = false;
        this.m_bTitleFontSizeChanged = false;
        this.m_bTitleAlignmentChanged = false;
        this.m_bTitleFontColorChanged = false;
        this.m_bTitleVisibleChanged = false;
        this.m_bSubtitleFontNameChanged = false;
        this.m_bSubtitleFontBoldChanged = false;
        this.m_bSubtitleFontItalicChanged = false;
        this.m_bSubtitleFontUnderlineChanged = false;
        this.m_bSubtitleFontSizeChanged = false;
        this.m_bSubtitleAlignmentChanged = false;
        this.m_bSubtitleFontColorChanged = false;
        this.m_bSubtitleVisibleChanged = false;
        this.m_bFootnoteFontNameChanged = false;
        this.m_bFootnoteFontBoldChanged = false;
        this.m_bFootnoteFontItalicChanged = false;
        this.m_bFootnoteFontUnderlineChanged = false;
        this.m_bFootnoteFontSizeChanged = false;
        this.m_bFootnoteAlignmentChanged = false;
        this.m_bFootnoteFontColorChanged = false;
        this.m_bFootnoteVisibleChanged = false;
        this.m_bTitleTextChanged = false;
        this.m_bSubtitleTextChanged = false;
        this.m_bFootnoteTextChanged = false;
        this.m_bTitleRotationChanged = false;
        this.m_bSubtitleRotationChanged = false;
        this.m_bFootnoteRotationChanged = false;
    }
}

