/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.util.help.HelpContext;

public class TimeAxis
extends JPanel
implements HelpContext,
ItemListener {
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected Graph m_graph;
    protected JComboBox m_yearComboBox;
    protected JComboBox m_monthComboBox;
    protected JComboBox m_dayComboBox;
    protected JComboBox m_timeComboBox;
    private ResourceBundle rBundle;
    private boolean m_bYearFormatChanged;
    private boolean m_bMonthFormatChanged;
    private boolean m_bDayFormatChanged;
    private boolean m_bTimeFormatChanged;

    public TimeAxis(Graph graph) {
        this.m_graph = graph;
        this.constructPanel();
        this._init();
    }

    public void setGraph(Graph graph) {
        this.m_graph = graph;
        this._init();
    }

    public String getHelpContextID() {
        if (this.m_strHelpContextID == null) {
            return this.getClass().getName();
        }
        return this.m_strHelpContextID;
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_yearComboBox) {
            this.m_bYearFormatChanged = true;
        } else if (itemEvent.getSource() == this.m_monthComboBox) {
            this.m_bMonthFormatChanged = true;
        } else if (itemEvent.getSource() == this.m_dayComboBox) {
            this.m_bDayFormatChanged = true;
        } else if (itemEvent.getSource() == this.m_timeComboBox) {
            this.m_bTimeFormatChanged = true;
        }
    }

    public void apply() {
        int n;
        if (this.m_bYearFormatChanged) {
            n = this.m_yearComboBox.getSelectedIndex();
            switch (n) {
                case 0: {
                    this.m_graph.setTimeAxisDateFormat(0, "AUTO");
                    break;
                }
                case 1: {
                    this.m_graph.setTimeAxisDateFormat(0, "NONE");
                    break;
                }
                case 2: {
                    this.m_graph.setTimeAxisDateFormat(0, "YYYY");
                    break;
                }
                case 3: {
                    this.m_graph.setTimeAxisDateFormat(0, "Y,YYY");
                    break;
                }
                case 4: {
                    this.m_graph.setTimeAxisDateFormat(0, "YY");
                    break;
                }
                case 5: {
                    this.m_graph.setTimeAxisDateFormat(0, "'YY");
                }
            }
        }
        if (this.m_bMonthFormatChanged) {
            n = this.m_monthComboBox.getSelectedIndex();
            switch (n) {
                case 0: {
                    this.m_graph.setTimeAxisDateFormat(1, "AUTO");
                    break;
                }
                case 1: {
                    this.m_graph.setTimeAxisDateFormat(1, "NONE");
                    break;
                }
                case 2: {
                    this.m_graph.setTimeAxisDateFormat(1, "Month");
                    break;
                }
                case 3: {
                    this.m_graph.setTimeAxisDateFormat(1, "Mon");
                    break;
                }
                case 4: {
                    this.m_graph.setTimeAxisDateFormat(1, "M");
                    break;
                }
                case 5: {
                    this.m_graph.setTimeAxisDateFormat(1, "MM");
                }
            }
        }
        if (this.m_bDayFormatChanged) {
            n = this.m_dayComboBox.getSelectedIndex();
            switch (n) {
                case 0: {
                    this.m_graph.setTimeAxisDateFormat(2, "AUTO");
                    break;
                }
                case 1: {
                    this.m_graph.setTimeAxisDateFormat(2, "NONE");
                    break;
                }
                case 2: {
                    this.m_graph.setTimeAxisDateFormat(2, "DD");
                    break;
                }
                case 3: {
                    this.m_graph.setTimeAxisDateFormat(2, "Day");
                    break;
                }
                case 4: {
                    this.m_graph.setTimeAxisDateFormat(2, "Dy");
                    break;
                }
                case 5: {
                    this.m_graph.setTimeAxisDateFormat(2, "DS");
                    break;
                }
                case 6: {
                    this.m_graph.setTimeAxisDateFormat(2, "D");
                }
            }
        }
        if (this.m_bTimeFormatChanged) {
            n = this.m_timeComboBox.getSelectedIndex();
            switch (n) {
                case 0: {
                    this.m_graph.setTimeAxisDateFormat(3, "AUTO");
                    break;
                }
                case 1: {
                    this.m_graph.setTimeAxisDateFormat(3, "NONE");
                    break;
                }
                case 2: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH");
                    break;
                }
                case 3: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH24");
                    break;
                }
                case 4: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH:MI");
                    break;
                }
                case 5: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH24:MI");
                    break;
                }
                case 6: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH:MI:SS");
                    break;
                }
                case 7: {
                    this.m_graph.setTimeAxisDateFormat(3, "HH24:MI:SS");
                }
            }
        }
    }

    public void cleanUp() {
    }

    private void constructPanel() {
        this.removeAll();
        this.updateResourceBundle(this.m_graph.getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String string = this.rBundle.getString("TimeAxisLabel");
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(StringUtils.stripMnemonic((String)string));
        multiLineLabel.setAlignmentX(0.0f);
        this.add((Component)multiLineLabel);
        this.add(Box.createVerticalStrut(10));
        string = this.rBundle.getString("TimeAxisYear");
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel.setAlignmentX(0.0f);
        int n = jLabel.getPreferredSize().width;
        string = this.rBundle.getString("TimeAxisMonth");
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel2.setAlignmentX(0.0f);
        if (jLabel2.getPreferredSize().width > n) {
            n = jLabel2.getPreferredSize().width;
        }
        string = this.rBundle.getString("TimeAxisDay");
        JLabel jLabel3 = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel3.setAlignmentX(0.0f);
        if (jLabel3.getPreferredSize().width > n) {
            n = jLabel3.getPreferredSize().width;
        }
        string = this.rBundle.getString("TimeAxisHour");
        JLabel jLabel4 = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel4.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel4.setAlignmentX(0.0f);
        if (jLabel4.getPreferredSize().width > n) {
            n = jLabel4.getPreferredSize().width;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jLabel.setPreferredSize(new Dimension(n, jLabel.getPreferredSize().height));
        jLabel.setMaximumSize(jLabel.getPreferredSize());
        jLabel.setMinimumSize(jLabel.getPreferredSize());
        jPanel.add(Box.createHorizontalStrut(6));
        jPanel.add(jLabel);
        jPanel.setAlignmentX(0.0f);
        String[] stringArray = new String[]{this.rBundle.getString("TimeAxisAutomatic"), this.rBundle.getString("TimeAxisNone"), this.rBundle.getString("YearLong"), this.rBundle.getString("YearLongComma"), this.rBundle.getString("YearShort"), this.rBundle.getString("YearShortApostrophe")};
        this.m_yearComboBox = new JComboBox<String>(stringArray);
        jLabel.setLabelFor(this.m_yearComboBox);
        jPanel.add(Box.createHorizontalStrut(6));
        jPanel.add(this.m_yearComboBox);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jLabel2.setPreferredSize(new Dimension(n, jLabel2.getPreferredSize().height));
        jLabel2.setMaximumSize(jLabel2.getPreferredSize());
        jLabel2.setMinimumSize(jLabel2.getPreferredSize());
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(jLabel2);
        jPanel2.setAlignmentX(0.0f);
        String[] stringArray2 = new String[]{this.rBundle.getString("TimeAxisAutomatic"), this.rBundle.getString("TimeAxisNone"), this.rBundle.getString("MonthLong"), this.rBundle.getString("MonthShort"), this.rBundle.getString("MonthSingleLetter"), this.rBundle.getString("MonthNumber")};
        this.m_monthComboBox = new JComboBox<String>(stringArray2);
        jLabel2.setLabelFor(this.m_monthComboBox);
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(this.m_monthComboBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jLabel3.setPreferredSize(new Dimension(n, jLabel3.getPreferredSize().height));
        jLabel3.setMaximumSize(jLabel3.getPreferredSize());
        jLabel3.setMinimumSize(jLabel3.getPreferredSize());
        jPanel3.add(Box.createHorizontalStrut(6));
        jPanel3.add(jLabel3);
        jPanel3.setAlignmentX(0.0f);
        String[] stringArray3 = new String[]{this.rBundle.getString("TimeAxisAutomatic"), this.rBundle.getString("TimeAxisNone"), this.rBundle.getString("DayMonth"), this.rBundle.getString("DayWeek"), this.rBundle.getString("DayWeekAbbr"), this.rBundle.getString("DaySingleLetter"), this.rBundle.getString("DayWeekNumber")};
        this.m_dayComboBox = new JComboBox<String>(stringArray3);
        jLabel3.setLabelFor(this.m_dayComboBox);
        jPanel3.add(Box.createHorizontalStrut(6));
        jPanel3.add(this.m_dayComboBox);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jLabel4.setPreferredSize(new Dimension(n, jLabel4.getPreferredSize().height));
        jLabel4.setMaximumSize(jLabel4.getPreferredSize());
        jLabel4.setMinimumSize(jLabel4.getPreferredSize());
        jPanel4.add(Box.createHorizontalStrut(6));
        jPanel4.add(jLabel4);
        jPanel4.setAlignmentX(0.0f);
        String[] stringArray4 = new String[]{this.rBundle.getString("TimeAxisAutomatic"), this.rBundle.getString("TimeAxisNone"), this.rBundle.getString("Hour"), this.rBundle.getString("Hour24"), this.rBundle.getString("HourMinute"), this.rBundle.getString("Hour24Minute"), this.rBundle.getString("HourMinuteSec"), this.rBundle.getString("Hour24MinuteSec")};
        this.m_timeComboBox = new JComboBox<String>(stringArray4);
        jLabel4.setLabelFor(this.m_timeComboBox);
        jPanel4.add(Box.createHorizontalStrut(6));
        jPanel4.add(this.m_timeComboBox);
        this.add(jPanel);
        n = jPanel.getPreferredSize().width;
        this.add(Box.createVerticalStrut(6));
        this.add(jPanel2);
        n = Math.max(n, jPanel2.getPreferredSize().width);
        this.add(Box.createVerticalStrut(6));
        this.add(jPanel3);
        n = Math.max(n, jPanel3.getPreferredSize().width);
        this.add(Box.createVerticalStrut(6));
        n = Math.max(n, jPanel4.getPreferredSize().width);
        this.add(jPanel4);
        jPanel.setPreferredSize(new Dimension(n, jPanel.getPreferredSize().height));
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel2.setPreferredSize(new Dimension(n, jPanel2.getPreferredSize().height));
        jPanel2.setMaximumSize(jPanel2.getPreferredSize());
        jPanel2.setMinimumSize(jPanel2.getPreferredSize());
        jPanel3.setPreferredSize(new Dimension(n, jPanel3.getPreferredSize().height));
        jPanel3.setMaximumSize(jPanel3.getPreferredSize());
        jPanel3.setMinimumSize(jPanel3.getPreferredSize());
        jPanel4.setPreferredSize(new Dimension(n, jPanel4.getPreferredSize().height));
        jPanel4.setMaximumSize(jPanel4.getPreferredSize());
        jPanel4.setMinimumSize(jPanel4.getPreferredSize());
        double d = this.getToolkit().getFontMetrics(multiLineLabel.getFont()).stringWidth(multiLineLabel.getText());
        int n2 = (int)Math.ceil(d / (double)(n + 10));
        multiLineLabel.setPreferredRows(n2);
        multiLineLabel.setMinimumRows(n2);
        multiLineLabel.setMaximumRows(n2);
        int n3 = 20 + multiLineLabel.getPreferredSize().height + 10 + (jPanel.getPreferredSize().height + 6) * 4 - 6;
        this.setPreferredSize(new Dimension(n + 30, n3));
        this.m_yearComboBox.addItemListener(this);
        this.m_monthComboBox.addItemListener(this);
        this.m_dayComboBox.addItemListener(this);
        this.m_timeComboBox.addItemListener(this);
    }

    private void _init() {
        String string = this.m_graph.getTimeAxisDateFormat(0);
        if (string.equals("AUTO")) {
            this.m_yearComboBox.setSelectedIndex(0);
        } else if (string.equals("NONE")) {
            this.m_yearComboBox.setSelectedIndex(1);
        } else if (string.equals("YYYY")) {
            this.m_yearComboBox.setSelectedIndex(2);
        } else if (string.equals("Y,YYY")) {
            this.m_yearComboBox.setSelectedIndex(3);
        } else if (string.equals("YY")) {
            this.m_yearComboBox.setSelectedIndex(4);
        } else if (string.equals("'YY")) {
            this.m_yearComboBox.setSelectedIndex(5);
        }
        String string2 = this.m_graph.getTimeAxisDateFormat(1);
        if (string2.equals("AUTO")) {
            this.m_monthComboBox.setSelectedIndex(0);
        } else if (string2.equals("NONE")) {
            this.m_monthComboBox.setSelectedIndex(1);
        } else if (string2.equals("Month")) {
            this.m_monthComboBox.setSelectedIndex(2);
        } else if (string2.equals("Mon")) {
            this.m_monthComboBox.setSelectedIndex(3);
        } else if (string2.equals("M")) {
            this.m_monthComboBox.setSelectedIndex(4);
        } else if (string2.equals("MM")) {
            this.m_monthComboBox.setSelectedIndex(5);
        }
        String string3 = this.m_graph.getTimeAxisDateFormat(2);
        if (string3.equals("AUTO")) {
            this.m_dayComboBox.setSelectedIndex(0);
        } else if (string3.equals("NONE")) {
            this.m_dayComboBox.setSelectedIndex(1);
        } else if (string3.equals("DD")) {
            this.m_dayComboBox.setSelectedIndex(2);
        } else if (string3.equals("Day")) {
            this.m_dayComboBox.setSelectedIndex(3);
        } else if (string3.equals("Dy")) {
            this.m_dayComboBox.setSelectedIndex(4);
        } else if (string3.equals("DS")) {
            this.m_dayComboBox.setSelectedIndex(5);
        } else if (string3.equals("D")) {
            this.m_dayComboBox.setSelectedIndex(6);
        }
        String string4 = this.m_graph.getTimeAxisDateFormat(3);
        if (string4.equals("AUTO")) {
            this.m_timeComboBox.setSelectedIndex(0);
        } else if (string4.equals("NONE")) {
            this.m_timeComboBox.setSelectedIndex(1);
        } else if (string4.equals("HH")) {
            this.m_timeComboBox.setSelectedIndex(2);
        } else if (string4.equals("HH24")) {
            this.m_timeComboBox.setSelectedIndex(3);
        } else if (string4.equals("HH:MI")) {
            this.m_timeComboBox.setSelectedIndex(4);
        } else if (string4.equals("HH24:MI")) {
            this.m_timeComboBox.setSelectedIndex(5);
        } else if (string4.equals("HH:MI:SS")) {
            this.m_timeComboBox.setSelectedIndex(6);
        } else if (string4.equals("HH24:MI:SS")) {
            this.m_timeComboBox.setSelectedIndex(7);
        }
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }
}

