/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraph;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;

public class ThreeDEffectTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_THREED_EFFECT = "ThreeDEffect";
    protected Object m_currentDataView;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    protected boolean m_enable = true;
    private MouseListener m_mouseListener;
    protected boolean m_bRolloverIconEnabled;

    public ThreeDEffectTool() {
        this.setMargin(insets0);
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/s_threeD_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.addActionListener(this);
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("ShowThreeD"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!ThreeDEffectTool.this.isRolloverIconEnabled()) {
                        ThreeDEffectTool.this.setBorderPainted(true);
                    }
                    if (!ThreeDEffectTool.this.isEnabled()) {
                        ThreeDEffectTool.this.setBorderPainted(ThreeDEffectTool.this.isSelected());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (!ThreeDEffectTool.this.isRolloverIconEnabled()) {
                        ThreeDEffectTool.this.setBorderPainted(ThreeDEffectTool.this.isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.setToolTipText(this.rBundle.getString("ShowThreeD"));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        this.m_enable = false;
        if (uIDataview instanceof UIGraph) {
            this.setSelected(((UIGraph)uIDataview).is3DEffect());
            this.setBorderPainted(this.isSelected());
            this.m_currentDataView = uIDataview;
            int n = ((UIGraph)this.m_currentDataView).getGraphTypeConverter().getTypeAndSubtype((UIGraph)((UIGraph)this.m_currentDataView)).type;
            Type type = ((GraphTypeConverterAdapter)((UIGraph)this.m_currentDataView).getGraphTypeConverter()).getType(n);
            if (type.supports3D && type.supportsNon3D && ((UIGraph)this.m_currentDataView).getGraphType() != 67 && ((UIGraph)this.m_currentDataView).getGraphType() != 69) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.m_currentDataView = null;
            this.setEnabled(false);
        }
        this.m_enable = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null || !this.m_enable) {
            return;
        }
        if (actionEvent.getSource() == this) {
            ((UIGraph)this.m_currentDataView).set3DEffect(this.isSelected());
            this.setBorderPainted(this.isSelected());
            this.firePropertyChange(PROPERTY_THREED_EFFECT, !this.isSelected(), this.isSelected());
        }
    }

    public void update() {
        if (this.m_currentDataView == null) {
            return;
        }
        int n = ((UIGraph)this.m_currentDataView).getGraphTypeConverter().getTypeAndSubtype((UIGraph)((UIGraph)this.m_currentDataView)).type;
        Type type = ((GraphTypeConverterAdapter)((UIGraph)this.m_currentDataView).getGraphTypeConverter()).getType(n);
        if (type.supports3D && type.supportsNon3D && ((UIGraph)this.m_currentDataView).getGraphType() != 67 && ((UIGraph)this.m_currentDataView).getGraphType() != 69) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.LegendTool"), (String)string));
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }
}

