/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;
import oracle.dss.graph.gui.LineWidth;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;

public class Series
extends JPanel {
    protected Graph m_graph;
    protected int m_graphType;
    protected String[] m_seriesList;
    protected int m_seriesCount;
    protected TableColumn m_seriesline;
    protected TableColumn m_color;
    protected TableColumn m_marker;
    protected TableColumn m_yAxis;
    protected TableColumn m_type;
    protected TableColumn m_fitline;
    protected boolean m_isLine;
    protected boolean m_isMarker;
    protected boolean m_isDualY;
    protected boolean m_isCombination;
    protected boolean m_isFitline;
    protected int[] m_assignToY2;
    protected Integer[] m_lineWidth;
    protected Integer[] m_markerType;
    protected Integer[] m_markerShape;
    protected Integer[] m_fitlineType;
    protected Color[] m_seriesColor;
    protected Object m_defaultMarkerShape;
    protected Object m_defaultColor;
    protected Object m_defaultLineWidth;
    protected Object m_defaultYAxis;
    protected Object m_defaultMarkerType;
    protected Object m_defaultFitline;
    protected Object[][] m_data;
    protected boolean[][] m_dataChanged;
    protected boolean m_noneMissingInMarkerRows;
    protected boolean m_lineNone;
    protected Object[] m_previousData;
    protected String[] m_names;
    protected SeriesJTable m_table;
    protected ImageIcon[] m_icons;
    protected String m_y1;
    protected String m_y2;
    protected String m_auto;
    protected boolean m_colorColumn = true;
    protected boolean m_lineColumn = true;
    protected boolean m_markerShapeColumn = true;
    protected boolean m_yAxisColumn = true;
    protected boolean m_markerTypeColumn = true;
    protected boolean m_fitlineColumn = true;
    protected int m_markerShapeCol = -1;
    protected int m_colorCol = -1;
    protected int m_lineCol = -1;
    protected int m_yAxisCol = -1;
    protected int m_markerTypeCol = -1;
    protected int m_fitlineCol = -1;
    protected LineWidthWithBlank lineWidth;
    protected LightCombo fitline;
    protected LightCombo type;
    protected LightCombo defaultType;
    protected LightCombo markers;
    protected LightCombo defaultmarkers;
    protected ComboBoxCellEditor defaultLineCellEditor;
    protected ComboBoxCellEditor defaultMarkerCellEditor;
    protected ComboBoxCellEditor defaultMarkerTypeEditor;
    protected ComboBoxCellEditor defaultYAxisEditor;
    protected LightCombo defaultYAxis;
    protected LightCombo yAxis;
    protected ColorEditor colorEditor;
    protected ColorEditor defaultColorEditor;
    protected BIColorChoice autoColor;
    protected ColorRenderer colorRenderer;
    protected TableColumn item;
    protected LabelRenderer itemLabelRenderer;
    protected LabelRenderer fitlineLabelRenderer;
    protected LabelRenderer typeLabelRenderer;
    protected LabelRenderer yAxisLabelRenderer;
    protected BIColorChoice button;
    protected Color[][] m_colors;
    protected ArrayTwoDModel m_colorPalette;
    protected boolean m_bColorPaletteSet;
    protected boolean m_isMSNone;
    protected NumberFormat m_numFormat;
    protected boolean m_isPareto;
    protected boolean m_showDataMarker = true;
    protected int m_numUsedCols;
    protected JScrollPane m_scrollPane;
    protected ActionListener editAction;
    protected ComponentListener m_componentListener;
    protected FocusListener m_focusListener;
    private static final int[] markerTypes = new int[]{1, 2, 3};
    private static final int AUTOMATIC = -1;
    private static final int BLANK = 0;
    private static final int SAME = 1;
    private ResourceBundle rBundle;
    private Filter _filter = null.new Filter();
    private final int MAX_COL = 7;
    private boolean _flag = true;
    private boolean _flag2 = true;
    private boolean editorFocus;

    public Series(Graph graph, int n) {
        this.m_graph = graph;
        this.setLayout(new BorderLayout());
        this._excludeColumns(n);
        this.initAll();
    }

    public Series(Graph graph, int n, String string) {
        this(graph, n);
        this.m_table.getAccessibleContext().setAccessibleName(string);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
    }

    public void setSelectedSeries(int n) {
        int n2 = this.m_table.getRowCount();
        if (n >= n2) {
            return;
        }
        this.m_table.setCellSelectionEnabled(true);
        if (this._isAllSeriesSupported()) {
            ++n;
        }
        this.m_table.getSelectionModel().setSelectionInterval(n, n);
        this.m_table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        Rectangle rectangle = this.m_table.getCellRect(n, 0, false);
        this.m_table.scrollRectToVisible(rectangle);
    }

    public int getSelectedSeries() {
        if (this.m_table != null) {
            return this.m_table.getSelectedRow();
        }
        return -1;
    }

    private void initAll() {
        block21: {
            Object object;
            this.updateResourceBundle(this.m_graph.getLocale());
            this.setLayout(new BoxLayout(this, 0));
            if (this.m_graph.getGraphTypeConverter() == null) {
                object = new GraphTypeConverterAdapter();
                this.m_graph.setGraphTypeConverter((GraphTypeConverter)object);
                ((GraphTypeConverterAdapter)object).setLocale(this.m_graph.getLocale());
            }
            this.m_graphType = this.m_graph.getGraphType();
            this._initialize();
            this.m_table = new SeriesJTable(this.m_data, this.m_names);
            this.m_table.setRowHeight(24);
            this.m_table.setAutoResizeMode(0);
            this.editAction = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ListSelectionModel listSelectionModel = Series.this.m_table.getSelectionModel();
                    int n = listSelectionModel.getAnchorSelectionIndex();
                    ListSelectionModel listSelectionModel2 = Series.this.m_table.getColumnModel().getSelectionModel();
                    int n2 = listSelectionModel2.getAnchorSelectionIndex();
                    Series.this.m_table.editCellAt(n, n2);
                    Component component = Series.this.m_table.getEditorComponent();
                    if (component != null) {
                        component.requestFocus();
                    } else {
                        Series.this.m_table.requestFocus();
                    }
                }
            };
            this.m_table.registerKeyboardAction(this.editAction, KeyStroke.getKeyStroke(32, 0), 1);
            this.m_table.registerKeyboardAction(this.editAction, KeyStroke.getKeyStroke(113, 0), 1);
            object = new Object();
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Series.this.getRootPane().getDefaultButton() != null) {
                        Series.this.getRootPane().getDefaultButton().requestFocus();
                        Series.this.m_table.getParent().dispatchEvent(new KeyEvent(Series.this.m_table, 401, System.currentTimeMillis(), 0, 10, '\uffff'));
                    }
                }
            };
            this.m_table.getInputMap().put(KeyStroke.getKeyStroke(10, 0), object);
            this.m_table.getActionMap().put(object, abstractAction);
            this._setupItemColumn();
            int n = 0;
            if (this.m_colorColumn) {
                this.m_color = this.m_table.getColumnModel().getColumn(++n);
                this._setupColorColumn(n);
            }
            if (this.m_isCombination) {
                this.m_type = this.m_table.getColumnModel().getColumn(++n);
                this._setupMarkerTypeColumn(n);
            }
            if (this.m_isLine) {
                this.m_seriesline = this.m_table.getColumnModel().getColumn(++n);
                this._setupLineWidthColumn(n);
            }
            if (this.m_isMarker) {
                this.m_marker = this.m_table.getColumnModel().getColumn(++n);
                this._setupMarkerShapeColumn(n);
            }
            if (this.m_isDualY) {
                this.m_yAxis = this.m_table.getColumnModel().getColumn(++n);
                this._setupAssignToY2Column(n);
            }
            if (this.m_isFitline) {
                this.m_fitline = this.m_table.getColumnModel().getColumn(++n);
                this._setupFitlineColumn(n);
            }
            this.m_scrollPane = new JScrollPane(this.m_table);
            this.add(this.m_scrollPane);
            this.m_scrollPane.setPreferredSize(new Dimension(this.m_table.getPreferredSize().width + 5, this.m_table.getPreferredSize().height + this.m_table.getTableHeader().getPreferredSize().height + 5));
            this.setPreferredSize(this.m_scrollPane.getPreferredSize());
            this.m_componentListener = new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    int n = Series.this.m_scrollPane.getPreferredSize().width;
                    int n2 = Series.this.m_scrollPane.getPreferredSize().height;
                    int n3 = Series.this.getHeight() < n2 ? n + Series.this.m_scrollPane.getVerticalScrollBar().getPreferredSize().width : n;
                    int n4 = Series.this.getWidth() < n ? n2 + Series.this.m_scrollPane.getHorizontalScrollBar().getPreferredSize().height : n2;
                    Series.this.setMaximumSize(new Dimension(n3, n4));
                    Series.this.setPreferredSize(Series.this.getMaximumSize());
                    Series.this.revalidate();
                }
            };
            this.addComponentListener(this.m_componentListener);
            this.m_focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    Series.this.m_table.requestFocus();
                }

                public void focusLost(FocusEvent focusEvent) {
                }
            };
            this.addFocusListener(this.m_focusListener);
            this.setSelectedSeries(-1);
            if (!this._isAllSeriesSupported()) break block21;
            this.m_defaultColor = this.m_table.getValueAt(0, this.m_colorCol);
            if (this.m_isCombination) {
                this.m_defaultMarkerType = this.m_table.getValueAt(0, this.m_markerTypeCol);
            }
            if (this.m_isMarker) {
                this.m_defaultMarkerShape = this.m_table.getValueAt(0, this.m_markerShapeCol);
            }
            if (this.m_isLine) {
                this.m_defaultLineWidth = this.m_table.getValueAt(0, this.m_lineCol);
            }
            if (this.m_isDualY) {
                this.m_defaultYAxis = this.m_table.getValueAt(0, this.m_yAxisCol);
            }
            if (this.m_isFitline) {
                this.m_defaultFitline = this.m_table.getValueAt(0, this.m_fitlineCol);
            }
            int n2 = 1;
            while (n2 < this.m_table.getColumnCount()) {
                block24: {
                    int n3;
                    block23: {
                        block25: {
                            block22: {
                                n3 = this._areSeriesSameValueOrAuto(n2);
                                if (n2 != this.m_colorCol) break block22;
                                if (n3 == -1) {
                                    this.autoColor.setAutomaticSelected(true);
                                }
                                if (this.m_table.getValueAt(0, this.m_colorCol) != null || n3 != -1) break block23;
                                break block24;
                            }
                            if (n2 != this.m_yAxisCol) break block25;
                            if (n3 == -1 && this.m_table.getValueAt(0, this.m_yAxisCol).equals(this.m_auto)) break block24;
                            if (n3 == 1 && this.m_table.getValueAt(0, this.m_yAxisCol).equals(this.m_auto)) {
                                this.m_table.setValueAt("", 0, n2);
                            }
                            break block23;
                        }
                        if (n2 != this.m_markerTypeCol ? n2 == this.m_markerShapeCol && n3 == -1 && Integer.parseInt(this.m_table.getValueAt(0, this.m_markerShapeCol).toString()) == -1 : n3 == -1 && this.m_table.getValueAt(0, this.m_markerTypeCol).equals(this.m_auto)) break block24;
                    }
                    if (n3 == 0) {
                        this.m_table.setValueAt("", 0, n2);
                    }
                }
                ++n2;
            }
        }
        if (this._isMarkerSupported()) {
            this.m_dataChanged[0][this.m_markerShapeCol] = false;
        }
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    public void setGraph(Graph graph) {
        this.m_graph = graph;
        this.removeAll();
        this.m_table = null;
        this.removeComponentListener(this.m_componentListener);
        this.m_colorCol = -1;
        this.m_lineCol = -1;
        this.m_markerTypeCol = -1;
        this.m_markerShapeCol = -1;
        this.m_fitlineCol = -1;
        this.m_yAxisCol = -1;
        this.initAll();
    }

    public void setDataMarkerEnabled(boolean bl) {
        this.m_showDataMarker = this.m_graphType >= 61 && this.m_graphType <= 64 || this.m_graphType >= 65 && this.m_graphType <= 66 ? true : bl;
        if (this.m_isMarker) {
            this.repaint();
        }
    }

    public boolean isDataMarkerEnabled() {
        return this.m_showDataMarker;
    }

    public void cleanUp() {
        this.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
        this.removeFocusListener(this.m_focusListener);
        this.m_focusListener = null;
        this.m_table.getInputMap().clear();
        this.m_table.getActionMap().clear();
        this.m_table.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, 0));
        this.m_table.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        this.editAction = null;
        if (this.markers != null) {
            this.m_marker.setCellEditor(null);
            this.markers.cleanUp();
            this.markers = null;
        }
        if (this.yAxis != null) {
            this.m_yAxis.setCellEditor(null);
            this.yAxis.cleanUp();
            this.yAxis = null;
            this.m_yAxis.setCellRenderer(null);
            this.yAxisLabelRenderer = null;
        }
        if (this.fitline != null) {
            this.m_fitline.setCellEditor(null);
            this.fitline.cleanUp();
            this.fitline = null;
            this.m_fitline.setCellRenderer(null);
            this.fitlineLabelRenderer = null;
        }
        if (this.type != null) {
            this.m_type.setCellEditor(null);
            this.type.cleanUp();
            this.type = null;
            this.m_type.setCellRenderer(null);
            this.typeLabelRenderer = null;
        }
        this.m_color.setCellEditor(null);
        this.colorEditor = null;
        this.m_color.setCellRenderer(null);
        this.colorRenderer.cleanUp();
        this.colorRenderer = null;
        if (this.item != null) {
            this.item.setCellRenderer(null);
            this.itemLabelRenderer = null;
        }
        this.m_scrollPane.setViewportView(null);
        this.m_table = null;
    }

    public void setColorPalette(Color[][] colorArray) {
        this.m_colors = colorArray;
        if (this.m_colors != null) {
            this.m_colorPalette = FontButton.getArrayTwoDModel(colorArray);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            this.m_colorPalette = null;
        }
        if (this.button != null) {
            this.button.setSelectedColor((Color)this.button.getColorPalette().getData(0, 0));
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
    }

    public Color[][] getColorPalette() {
        if (this.m_colors != null) {
            return this.m_colors;
        }
        if (this.button != null) {
            return FontButton.getColorArray(this.button.getColorPalette());
        }
        return FontButton.getDefaultColorArray();
    }

    public void setColorPalette(ArrayTwoDModel arrayTwoDModel) {
        this.m_bColorPaletteSet = arrayTwoDModel != null;
        this.m_colorPalette = arrayTwoDModel;
        if (this.button != null) {
            this.button.setSelectedColor((Color)this.button.getColorPalette().getData(0, 0));
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
    }

    private String _truncateText(String string) {
        if (string == null) {
            return string;
        }
        String string2 = new String(string);
        if (string2.length() > 30) {
            string2 = String.valueOf(string2.substring(0, 26)) + "...)";
        }
        return string2;
    }

    String _getMarkerShape(int n) {
        String string = this.rBundle.getString("None");
        switch (n) {
            case 1: {
                string = this.rBundle.getString("Square");
                break;
            }
            case 2: {
                string = this.rBundle.getString("Circle");
                break;
            }
            case 3: {
                string = this.rBundle.getString("Diamond");
                break;
            }
            case 4: {
                string = this.rBundle.getString("Plus");
                break;
            }
            case 5: {
                string = this.rBundle.getString("Triangle Down");
                break;
            }
            case 6: {
                string = this.rBundle.getString("Triangle Up");
            }
        }
        return string;
    }

    int _getMarkerType(String string) {
        int n = 0;
        if (string.equals(this.rBundle.getString("Default"))) {
            n = 0;
        } else if (string.equals(this.rBundle.getString("SeriesBar"))) {
            n = 1;
        } else if (string.equals(this.rBundle.getString("SeriesLine"))) {
            n = 2;
        } else if (string.equals(this.rBundle.getString("SeriesArea"))) {
            n = 3;
        }
        return n;
    }

    String _getMarkerTypeString(int n) {
        switch (n) {
            case 0: {
                return this.rBundle.getString("Default");
            }
            case 1: {
                return this.rBundle.getString("SeriesBar");
            }
            case 2: {
                return this.rBundle.getString("SeriesLine");
            }
            case 3: {
                return this.rBundle.getString("SeriesArea");
            }
        }
        return this.rBundle.getString("Default");
    }

    int _getFitlineType(String string) {
        int n = 0;
        if (string.equals(this.rBundle.getString("None"))) {
            n = 0;
        } else if (string.equals(this.rBundle.getString("Linear"))) {
            n = 1;
        } else if (string.equals(this.rBundle.getString("Logarithmic"))) {
            n = 5;
        } else if (string.equals(this.rBundle.getString("Exponential"))) {
            n = 8;
        }
        return n;
    }

    private void _excludeColumns(int n) {
        if ((n & 1) == 1) {
            this.m_colorColumn = false;
        }
        if ((n & 2) == 2) {
            this.m_lineColumn = false;
        }
        if ((n & 4) == 4) {
            this.m_markerShapeColumn = false;
        }
        if ((n & 0x10) == 16) {
            this.m_yAxisColumn = false;
        }
        if ((n & 0x20) == 32) {
            this.m_markerTypeColumn = false;
        }
        if ((n & 0x40) == 64) {
            this.m_fitlineColumn = false;
        }
    }

    private void _setupItemColumn() {
        this.item = this.m_table.getColumnModel().getColumn(0);
        int n = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[0]);
        int n2 = 0;
        while (n2 < this.m_seriesList.length) {
            int n3 = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_seriesList[n2]);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        this.item.setPreferredWidth(n += 10);
        this.item.setMinWidth(this.item.getPreferredWidth());
        this.item.setMaxWidth(this.item.getPreferredWidth());
        this.item.setResizable(false);
        this.itemLabelRenderer = null.new LabelRenderer();
        this.item.setCellRenderer(this.itemLabelRenderer);
    }

    private void updateResourceBundle(Locale locale) {
        if (locale != null) {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale);
            this.m_numFormat = NumberFormat.getNumberInstance(locale);
        } else {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
            this.m_numFormat = NumberFormat.getNumberInstance(locale);
        }
        this.m_numFormat.setMinimumFractionDigits(2);
        this.m_numFormat.setMaximumFractionDigits(2);
    }

    private void _setupLineWidthColumn(int n) {
        this.m_lineCol = n;
        this.lineWidth = null.new LineWidthWithBlank();
        this.lineWidth.setCellColor(Color.black);
        final LineWidthWithBlankAndNone lineWidthWithBlankAndNone = new LineWidthWithBlankAndNone();
        lineWidthWithBlankAndNone.setCellColor(Color.black);
        if (!this.m_graph.isLineDataLineDisplayed()) {
            this.m_table.setValueAt(new Integer(0).toString(), 0, this.m_lineCol);
            this.m_lineNone = true;
        } else {
            this.m_lineNone = false;
        }
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && lineWidthWithBlankAndNone.isPopupVisible()) {
                    if (lineWidthWithBlankAndNone.getSelectedIndex() == 0) {
                        if (!m_noneMissingInMarkerRows) {
                            markers.removeItemAt(0);
                            m_noneMissingInMarkerRows = true;
                        }
                        m_lineNone = true;
                        String string = m_table.getValueAt(0, m_markerShapeCol).toString();
                        if (string.equals("0")) {
                            m_table.setValueAt(new Integer(-1).toString(), 0, m_markerShapeCol);
                        } else if (string.equals("")) {
                            int n = 1;
                            while (n < m_table.getRowCount()) {
                                int n2 = new Integer(m_table.getValueAt(n, m_markerShapeCol).toString());
                                if (n2 == 0) {
                                    m_table.setValueAt(new Integer((n - 1) % 6 + 1).toString(), n, m_markerShapeCol);
                                    m_dataChanged[n][m_markerShapeCol] = false;
                                }
                                m_defaultMarkerShape = new Integer(-1);
                                m_dataChanged[0][m_markerShapeCol] = true;
                                ++n;
                            }
                        }
                        this.repaint();
                    } else {
                        if (m_noneMissingInMarkerRows) {
                            markers.insertItemAt(new Integer(0).toString(), 0);
                            m_noneMissingInMarkerRows = false;
                        }
                        m_lineNone = false;
                    }
                }
            }
        };
        lineWidthWithBlankAndNone.addItemListener(itemListener);
        LineWidthCellRenderer lineWidthCellRenderer = new LineWidthCellRenderer(true);
        this.lineWidth.setRenderer(lineWidthCellRenderer);
        this.defaultLineCellEditor = new ComboBoxCellEditor(lineWidthWithBlankAndNone);
        this.m_seriesline.setCellEditor(new ComboBoxCellEditor(this.lineWidth));
        LineWidthRenderer lineWidthRenderer = new LineWidthRenderer(true);
        this.m_seriesline.setCellRenderer(lineWidthRenderer);
        this.m_seriesline.setPreferredWidth(80);
        this.m_seriesline.setMinWidth(this.m_seriesline.getPreferredWidth());
        this.m_seriesline.setMaxWidth(this.m_seriesline.getPreferredWidth());
        this.m_seriesline.setResizable(false);
    }

    private boolean isAnyMarkerRowNone() {
        boolean bl = false;
        if (this.m_markerShapeCol > -1) {
            int n = 1;
            while (n < this.m_table.getRowCount()) {
                int n2 = new Integer(this.m_table.getValueAt(n, this.m_markerShapeCol).toString());
                if (n2 == 0) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean isAnyLineRowNone() {
        boolean bl = false;
        if (this.m_lineCol > -1) {
            int n = 1;
            while (n < this.m_table.getRowCount()) {
                int n2 = new Integer(this.m_table.getValueAt(n, this.m_lineCol).toString());
                if (n2 == 0) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    private void _setupColorColumn(int n) {
        this.m_colorCol = n;
        this.button = new BIColorChoice();
        this.button.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        if (this.m_bColorPaletteSet) {
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        this.colorEditor = new ColorEditor(this.button);
        this.m_color.setCellEditor(this.colorEditor);
        this.autoColor = new BIColorChoice();
        this.autoColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.autoColor.setAutomaticAllowed(true);
        this.autoColor.setAutomaticSelected(false);
        this.autoColor.setSelectedColor(Color.red);
        this.autoColor.setLocale(this.m_graph.getLocale());
        this.defaultColorEditor = new ColorEditor(this.autoColor);
        this.colorRenderer = new ColorRenderer(true);
        this.m_color.setCellRenderer(this.colorRenderer);
        int n2 = Math.max(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[n]), this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_auto));
        this.m_color.setPreferredWidth(n2 + 10);
        this.m_color.setMinWidth(this.m_color.getPreferredWidth());
        this.m_color.setMaxWidth(this.m_color.getPreferredWidth());
        this.m_color.setResizable(false);
    }

    private void _setupMarkerShapeColumn(int n) {
        this.m_markerShapeCol = n;
        if (!this.m_graph.isMarkerDisplayed() && this._isLineSupported()) {
            if (!this.m_isPareto) {
                this.m_table.setValueAt(new Integer(0).toString(), 0, n);
            } else {
                this.m_table.setValueAt(new Integer(0).toString(), 1, n);
            }
        }
        this.markers = null.new LightCombo();
        this.defaultmarkers = null.new LightCombo();
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n;
                Object object;
                if (itemEvent.getStateChange() == 1 && Series.this.defaultmarkers.isPopupVisible() && (object = Series.this.defaultmarkers.getSelectedItem()) != null && !object.equals("") && (n = new Integer(object.toString()).intValue()) == 0 && Series.this.isAnyLineRowNone()) {
                    Series.this.m_table.setValueAt(new Integer(3).toString(), 0, Series.this.m_lineCol);
                    Series.this.m_lineNone = false;
                    Series.this.repaint();
                }
            }
        };
        this.defaultmarkers.addItemListener(itemListener);
        this.defaultmarkers.addItem(new Integer(-1).toString());
        int n2 = 0;
        while (n2 < 7) {
            if (n2 != 0 || this.m_isMSNone || !this._isDotType()) {
                if (n2 == 0) {
                    if (this.m_graph.isLineDataLineDisplayed()) {
                        this.m_noneMissingInMarkerRows = false;
                        this.markers.addItem(new Integer(n2).toString());
                    } else {
                        this.m_noneMissingInMarkerRows = true;
                    }
                } else {
                    this.markers.addItem(new Integer(n2).toString());
                }
                this.defaultmarkers.addItem(new Integer(n2).toString());
            }
            ++n2;
        }
        this.m_isMSNone = false;
        MarkerShapeEditor markerShapeEditor = new MarkerShapeEditor();
        MarkerShapeEditor markerShapeEditor2 = new MarkerShapeEditor();
        this.markers.setRenderer(markerShapeEditor);
        this.defaultmarkers.setRenderer(markerShapeEditor2);
        this.defaultMarkerCellEditor = new ComboBoxCellEditor(this.defaultmarkers);
        this.m_marker.setCellEditor(new ComboBoxCellEditor(this.markers));
        MarkerShapeRenderer markerShapeRenderer = new MarkerShapeRenderer(true);
        this.m_marker.setCellRenderer(markerShapeRenderer);
        int n3 = Math.max(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[n]), this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_auto));
        this.m_marker.setPreferredWidth(n3 + 10);
        this.m_marker.setMinWidth(this.m_marker.getPreferredWidth());
        this.m_marker.setMaxWidth(this.m_marker.getPreferredWidth());
        this.m_marker.setResizable(false);
    }

    private void _setupMarkerTypeColumn(int n) {
        this.m_markerTypeCol = n;
        String[] stringArray = new String[]{this.rBundle.getString("SeriesBar"), this.rBundle.getString("SeriesLine"), this.rBundle.getString("SeriesArea")};
        int n2 = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[n]);
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(stringArray[n3]);
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        n2 += 10;
        this.type = null.new LightCombo(stringArray);
        this.defaultType = null.new LightCombo(stringArray);
        this.defaultType.insertItemAt(this.m_auto, 0);
        this.defaultMarkerTypeEditor = new ComboBoxCellEditor(this.defaultType);
        this.m_type.setCellEditor(new ComboBoxCellEditor(this.type));
        this.typeLabelRenderer = null.new LabelRenderer();
        this.m_type.setCellRenderer(this.typeLabelRenderer);
        this.m_type.setPreferredWidth(n2);
        this.m_type.setMinWidth(this.m_type.getPreferredWidth());
        this.m_type.setMaxWidth(this.m_type.getPreferredWidth());
        this.m_type.setResizable(false);
    }

    private void _setupAssignToY2Column(int n) {
        this.m_yAxisCol = n;
        String[] stringArray = new String[]{this.m_y1, this.m_y2};
        int n2 = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[n]);
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this._truncateText(stringArray[n3]));
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        n2 += 10;
        this.yAxis = null.new LightCombo(stringArray);
        this.defaultYAxis = null.new LightCombo(stringArray);
        this.defaultYAxis.insertItemAt(this.m_auto, 0);
        this.defaultYAxisEditor = new ComboBoxCellEditor(this.defaultYAxis);
        this.m_yAxis.setCellEditor(new ComboBoxCellEditor(this.yAxis));
        this.yAxisLabelRenderer = new YAxisLabelRenderer();
        this.m_yAxis.setCellRenderer(this.yAxisLabelRenderer);
        this.m_yAxis.setPreferredWidth(n2);
        this.m_yAxis.setMinWidth(this.m_yAxis.getPreferredWidth());
        this.m_yAxis.setMaxWidth(this.m_yAxis.getPreferredWidth());
        this.m_yAxis.setResizable(false);
    }

    private void _setupFitlineColumn(int n) {
        this.m_fitlineCol = n;
        String[] stringArray = new String[]{this.rBundle.getString("None"), this.rBundle.getString("Linear"), this.rBundle.getString("Logarithmic"), this.rBundle.getString("Exponential")};
        int n2 = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[n]);
        int n3 = 0;
        while (n3 < stringArray.length) {
            int n4 = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(stringArray[n3]);
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        this.fitline = null.new LightCombo(stringArray);
        this.m_fitline.setCellEditor(new ComboBoxCellEditor(this.fitline));
        this.fitlineLabelRenderer = null.new LabelRenderer();
        this.m_fitline.setCellRenderer(this.fitlineLabelRenderer);
        this.m_fitline.setPreferredWidth(n2 += 10);
        this.m_fitline.setMinWidth(this.m_fitline.getPreferredWidth());
        this.m_fitline.setMaxWidth(this.m_fitline.getPreferredWidth());
        this.m_fitline.setResizable(false);
    }

    private ImageIcon _getImageIcon(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.Series"), (String)string));
    }

    private boolean _isPie() {
        return this.m_graphType >= 55 && this.m_graphType <= 60 || this.m_graphType >= 93 && this.m_graphType <= 94;
    }

    private boolean _isAllSeriesSupported() {
        return this.m_graphType != 12 && this.m_graphType != 102 && !this.isCandleOrVolume();
    }

    private boolean isCandleOrVolume() {
        switch (this.m_graphType) {
            case 70: 
            case 71: 
            case 72: 
            case 83: 
            case 84: 
            case 88: {
                return true;
            }
        }
        return false;
    }

    private boolean _isMarkerSupported() {
        return this.m_graphType >= 41 && this.m_graphType <= 47 || this.m_graphType >= 61 && this.m_graphType <= 64 || this.m_graphType >= 67 && this.m_graphType <= 69 || this.m_graphType >= 65 && this.m_graphType <= 66 || this.m_graphType == 102 || this.m_graph.getGraphTypeConverter().isCombinationType(this.m_graph);
    }

    private boolean _isLineSupported() {
        return this.m_graphType >= 41 && this.m_graphType <= 47 && !this.m_graph.getGraphTypeConverter().isPointType() || this.m_graph.getGraphTypeConverter().isCombinationType(this.m_graph) || this.m_graphType >= 67 && this.m_graphType <= 69 || this.m_graphType == 102 && !this.m_graph.is3DEffect();
    }

    private boolean _isDualY() {
        boolean bl = false;
        switch (this.m_graphType) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 91: 
            case 92: 
            case 102: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private boolean _isFitlineSupported() {
        boolean bl = true;
        switch (this.m_graphType) {
            case 0: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 88: 
            case 93: 
            case 94: 
            case 102: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private void _initialize() {
        int n;
        this.m_auto = this.rBundle.getString("Auto");
        this.m_icons = new ImageIcon[]{this._getImageIcon("images/Square.gif"), this._getImageIcon("images/Circle.gif"), this._getImageIcon("images/Diamond.gif"), this._getImageIcon("images/Plus.gif"), this._getImageIcon("images/TriangleDown.gif"), this._getImageIcon("images/TriangleUp.gif")};
        try {
            if (this.isCandleOrVolume()) {
                this.m_seriesCount = 1;
            } else if (this.m_graph.getGraphType() != 102) {
                this.m_seriesCount = this.m_graph.isDataRowShownAsASeries() ? this.m_graph.getRowCount() : this.m_graph.getColumnCount();
                if (this.m_seriesCount > this.m_graph.getSeriesObjectCount()) {
                    this.m_seriesCount = this.m_graph.getSeriesObjectCount();
                }
            } else {
                this.m_seriesCount = 2;
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        int n2 = this._isAllSeriesSupported() ? 1 : 0;
        this.m_seriesList = new String[this.m_seriesCount + n2];
        if (this.m_graph.getGraphType() != 102) {
            this.m_seriesList[0] = new String(this.rBundle.getString("All Series"));
            try {
                int n3;
                if (this.m_graph.isDataRowShownAsASeries()) {
                    n3 = 0;
                    while (n3 < this.m_seriesCount) {
                        this.m_seriesList[n3 + n2] = (String)this.m_graph.getDataAccessSliceLabel(1, n3, "longName");
                        ++n3;
                    }
                } else {
                    n3 = 0;
                    while (n3 < this.m_seriesCount) {
                        this.m_seriesList[n3 + n2] = (String)this.m_graph.getDataAccessSliceLabel(0, n3, "longName");
                        ++n3;
                    }
                }
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            }
            catch (SliceOutOfRangeException sliceOutOfRangeException) {}
        } else {
            this.m_seriesList[0] = this.rBundle.getString("Bar");
            this.m_seriesList[1] = this.rBundle.getString("Line");
        }
        this.m_assignToY2 = new int[this.m_seriesCount + n2];
        this.m_lineWidth = new Integer[this.m_seriesCount + n2];
        this.m_markerType = new Integer[this.m_seriesCount + n2];
        this.m_markerShape = new Integer[this.m_seriesCount + n2];
        this.m_seriesColor = new Color[this.m_seriesCount + n2];
        this.m_fitlineType = new Integer[this.m_seriesCount + n2];
        try {
            if (this.m_graph.getGraphType() != 102) {
                if (this._isAllSeriesSupported()) {
                    this.m_markerType[0] = new Integer(this.m_graph.getUISeries().getDefaultMarkerType());
                    this.m_lineWidth[0] = !this.m_graph.isLineDataLineDisplayed() ? new Integer(0) : new Integer(this.m_graph.getUISeries().getDefaultLineWidth());
                    this.m_assignToY2[0] = this.m_graph.getUISeries().getDefaultAssignedToY2();
                    this.m_markerShape[0] = !this.m_graph.isMarkerDisplayed() && this._isLineSupported() ? new Integer(0) : new Integer(this.m_graph.getUISeries().getDefaultMarkerShape());
                    this.m_seriesColor[0] = this.m_graph.getUISeries().getDefaultColor();
                    this.m_fitlineType[0] = new Integer(this.m_graph.getUISeries().getDefaultFitlineType());
                }
                int n4 = 0;
                while (n4 < this.m_seriesCount) {
                    if (this.m_markerTypeColumn) {
                        n = this.m_graph.getUISeries().getMarkerType(n4);
                        if (n == 0) {
                            n = 1;
                        }
                        this.m_markerType[n4 + n2] = new Integer(n);
                    }
                    if (this.m_lineColumn) {
                        this.m_lineWidth[n4 + n2] = !this.m_graph.isLineDataLineDisplayed() ? new Integer(0) : new Integer(this.m_graph.getUISeries().getLineWidth(n4));
                    }
                    if (this.m_yAxisColumn) {
                        this.m_assignToY2[n4 + n2] = this.m_graph.getUISeries().isAssignedToY2(n4) ? 1 : 0;
                    }
                    if (this.m_markerShapeColumn) {
                        n = this.m_graph.getUISeries().getMarkerShape(n4);
                        if (n == 0) {
                            this.m_isMSNone = true;
                        }
                        this.m_markerShape[n4 + n2] = new Integer(n);
                    }
                    if (this.m_colorColumn) {
                        this.m_seriesColor[n4 + n2] = this.m_graph.getUISeries().getColor(n4);
                    }
                    if (this.m_fitlineColumn) {
                        this.m_fitlineType[n4 + n2] = new Integer(this.m_graph.getUISeries().getFitlineType(n4));
                    }
                    ++n4;
                }
                this.m_isPareto = false;
            } else {
                this.m_markerShape[0] = new Integer(0);
                this.m_markerShape[1] = new Integer(this.m_graph.getParetoLine().getMarkerShape());
                this.m_seriesColor[0] = this.m_graph.getUISeries().getColor(0);
                this.m_seriesColor[1] = this.m_graph.getParetoLine().getColor();
                this.m_lineWidth[0] = new Integer(0);
                this.m_lineWidth[1] = new Integer(this.m_graph.getParetoLine().getWidth());
                this.m_assignToY2[0] = 0;
                this.m_assignToY2[1] = 1;
                this.m_isPareto = true;
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        this.m_isLine = this.m_lineColumn ? this._isLineSupported() && !this.m_graph.is3DEffect() : false;
        this.m_isMarker = this.m_markerShapeColumn ? this._isMarkerSupported() : false;
        this.m_isDualY = this.m_yAxisColumn ? this._isDualY() : false;
        this.m_isCombination = this.m_markerTypeColumn ? this.m_graph.getGraphTypeConverter().isCombinationType(this.m_graph) : false;
        this.m_isFitline = this.m_fitlineColumn ? this._isFitlineSupported() : false;
        int n5 = 1;
        n = 0;
        if (this.m_colorColumn) {
            ++n5;
        }
        if (this.m_isLine) {
            ++n5;
        }
        if (this.m_isMarker) {
            ++n5;
        }
        if (this.m_isDualY) {
            ++n5;
        }
        if (this.m_isCombination) {
            ++n5;
        }
        if (this.m_isFitline) {
            ++n5;
        }
        this.m_numUsedCols = n5;
        this.m_names = new String[n5];
        this.m_names[0] = this.rBundle.getString("Item");
        this.m_data = new Object[this.m_seriesList.length][n5];
        this.m_dataChanged = new boolean[this.m_seriesList.length][n5];
        this.m_previousData = new Object[n5];
        int n6 = 0;
        while (n6 < this.m_seriesList.length) {
            this.m_data[n6][n] = this.m_seriesList[n6];
            ++n6;
        }
        ++n;
        if (this.m_colorColumn) {
            this.m_names[n] = this.rBundle.getString("Color");
            n6 = 0;
            while (n6 < this.m_seriesColor.length) {
                this.m_data[n6][n] = this.m_seriesColor[n6];
                ++n6;
            }
            ++n;
        }
        if (this.m_isCombination) {
            this.m_names[n] = this.rBundle.getString("Graph As");
            n6 = 0;
            while (n6 < this.m_markerType.length) {
                switch (this.m_markerType[n6]) {
                    case 0: {
                        this.m_data[n6][n] = this.m_auto;
                        break;
                    }
                    case 1: {
                        this.m_data[n6][n] = this.rBundle.getString("SeriesBar");
                        break;
                    }
                    case 2: {
                        this.m_data[n6][n] = this.rBundle.getString("SeriesLine");
                        break;
                    }
                    case 3: {
                        this.m_data[n6][n] = this.rBundle.getString("SeriesArea");
                    }
                }
                ++n6;
            }
            ++n;
        }
        if (this.m_isLine) {
            this.m_names[n] = this.rBundle.getString("SeriesLine");
            n6 = 0;
            while (n6 < this.m_lineWidth.length) {
                this.m_data[n6][n] = this.m_lineWidth[n6];
                ++n6;
            }
            ++n;
        }
        if (this.m_isMarker) {
            this.m_names[n] = this.rBundle.getString("Marker");
            n6 = 0;
            while (n6 < this.m_markerShape.length) {
                this.m_data[n6][n] = this.m_markerShape[n6];
                ++n6;
            }
            ++n;
        }
        if (this.m_isDualY) {
            this.m_names[n] = this.rBundle.getString("Y-Axis");
            n6 = ((DecimalFormat)this.m_numFormat).getDecimalFormatSymbols().getDecimalSeparator() == ',' ? 59 : 44;
            this.m_y1 = this.m_graph.getUIY1Title().getText().equals("") || !this.m_graph.getUIY1Title().isVisible() ? this.rBundle.getString("Y1") : String.valueOf(this.rBundle.getString("Y1")) + "(" + this.m_graph.getUIY1Title().getText() + ")";
            this.m_y2 = this.m_graph.getUIY2Title().getText().equals("") || !this.m_graph.getUIY2Title().isVisible() ? this.rBundle.getString("Y2") : String.valueOf(this.rBundle.getString("Y2")) + "(" + this.m_graph.getUIY2Title().getText() + ")";
            int n7 = 0;
            while (n7 < this.m_assignToY2.length) {
                this.m_data[n7][n] = this.m_assignToY2[n7] == 1 ? this.m_y2 : (this.m_assignToY2[n7] == 0 ? this.m_y1 : this.m_auto);
                ++n7;
            }
            ++n;
        }
        if (this.m_isFitline) {
            this.m_names[n] = this.rBundle.getString("Fitline");
            n6 = 0;
            while (n6 < this.m_fitlineType.length) {
                switch (this.m_fitlineType[n6]) {
                    case 0: {
                        this.m_data[n6][n] = this.rBundle.getString("None");
                        break;
                    }
                    case 1: {
                        this.m_data[n6][n] = this.rBundle.getString("Linear");
                        break;
                    }
                    case 5: {
                        this.m_data[n6][n] = this.rBundle.getString("Logarithmic");
                        break;
                    }
                    case 8: {
                        this.m_data[n6][n] = this.rBundle.getString("Exponential");
                    }
                }
                ++n6;
            }
        }
    }

    private boolean _isDotType() {
        return this.m_graphType > 88 && this.m_graphType < 93 || this.m_graphType > 60 && this.m_graphType < 65 || this.m_graphType > 64 && this.m_graphType < 67;
    }

    private Icon _getColorIcon(Image image) {
        this._filter.setColor();
        Image image2 = Series._createFilteredImage(image, this._filter);
        return new ImageIcon(image2);
    }

    private static Image _createFilteredImage(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    private int _areSeriesSameValueOrAuto(int n) {
        int n2;
        block32: {
            n2 = 1;
            if (this.m_seriesCount == 0) {
                return n2;
            }
            int n3 = this.m_dataChanged[0][n] ? this.m_seriesCount : this.m_graph.getSeriesObjectCount();
            try {
                if (n == this.m_colorCol) {
                    Color color = (Color)this.m_table.getValueAt(1, this.m_colorCol);
                    int n4 = 0;
                    while (n4 < n3 - 1) {
                        Color color2 = n4 + 1 < this.m_seriesCount ? (Color)this.m_table.getValueAt(n4 + 2, this.m_colorCol) : this.m_graph.getUISeries().getColor(n4 + 1);
                        if (color != color2) {
                            n2 = 0;
                            break;
                        }
                        color = color2;
                        ++n4;
                    }
                    if (n2 == 0) {
                        n4 = 0;
                        n4 = 0;
                        while (n4 < n3) {
                            Color color3 = n4 < this.m_seriesCount ? (Color)this.m_table.getValueAt(n4 + 1, this.m_colorCol) : this.m_graph.getUISeries().getColor(n4);
                            if (color3.getRGB() != GraphDefaultValues.getDefaultSeriesColor()[n4 % 30]) break;
                            ++n4;
                        }
                        if (n4 == n3) {
                            n2 = -1;
                        }
                    }
                    break block32;
                }
                if (n == this.m_lineCol) {
                    int n5 = new Integer(this.m_table.getValueAt(1, this.m_lineCol).toString());
                    int n6 = 0;
                    while (n6 < n3 - 1) {
                        int n7 = n6 + 1 < this.m_seriesCount ? new Integer(this.m_table.getValueAt(n6 + 2, this.m_lineCol).toString()).intValue() : this.m_graph.getUISeries().getLineWidth(n6 + 1);
                        if (n5 != n7) {
                            n2 = 0;
                            break block32;
                        }
                        n5 = n7;
                        ++n6;
                    }
                    break block32;
                }
                if (n == this.m_markerTypeCol) {
                    int n8 = this._getMarkerType(this.m_table.getValueAt(1, this.m_markerTypeCol).toString());
                    int n9 = 0;
                    while (n9 < n3 - 1) {
                        int n10 = n9 + 1 < this.m_seriesCount ? this._getMarkerType(this.m_table.getValueAt(n9 + 2, this.m_markerTypeCol).toString()) : this.m_graph.getUISeries().getMarkerType(n9 + 1);
                        if (n8 != n10) {
                            n2 = 0;
                            break;
                        }
                        n8 = n10;
                        ++n9;
                    }
                    if (n2 == 0) {
                        n9 = 0;
                        n9 = 0;
                        while (n9 < n3) {
                            int n11 = n9 < this.m_seriesCount ? this._getMarkerType(this.m_table.getValueAt(n9 + 1, this.m_markerTypeCol).toString()) : this.m_graph.getUISeries().getMarkerType(n9);
                            if (n11 != markerTypes[n9 % 3]) break;
                            ++n9;
                        }
                        if (n9 == n3) {
                            n2 = -1;
                        }
                    }
                    break block32;
                }
                if (n == this.m_markerShapeCol) {
                    int n12 = new Integer(this.m_table.getValueAt(1, this.m_markerShapeCol).toString());
                    int n13 = 0;
                    while (n13 < n3 - 1) {
                        int n14 = n13 + 1 < this.m_seriesCount ? new Integer(this.m_table.getValueAt(n13 + 2, this.m_markerShapeCol).toString()).intValue() : this.m_graph.getUISeries().getMarkerShape(n13 + 1);
                        if (n12 != n14) {
                            n2 = 0;
                            break;
                        }
                        n12 = n14;
                        ++n13;
                    }
                    n13 = 0;
                    n13 = 0;
                    while (n13 < n3) {
                        int n15 = n13 < this.m_seriesCount ? new Integer(this.m_table.getValueAt(n13 + 1, this.m_markerShapeCol).toString()).intValue() : this.m_graph.getUISeries().getMarkerShape(n13);
                        if (n15 != this.m_graph.getPFJ().getLoopedMarkerShape(n13)) break;
                        ++n13;
                    }
                    if (n13 == n3) {
                        n2 = -1;
                    }
                    break block32;
                }
                if (n == this.m_fitlineCol) {
                    int n16 = this._getFitlineType(this.m_table.getValueAt(1, this.m_fitlineCol).toString());
                    int n17 = 0;
                    while (n17 < n3 - 1) {
                        int n18 = n17 + 1 < this.m_seriesCount ? this._getFitlineType(this.m_table.getValueAt(n17 + 2, this.m_fitlineCol).toString()) : this.m_graph.getUISeries().getFitlineType(n17 + 1);
                        if (n16 != n18) {
                            n2 = 0;
                            break block32;
                        }
                        n16 = n18;
                        ++n17;
                    }
                    break block32;
                }
                if (n == this.m_yAxisCol) {
                    boolean bl = this.m_table.getValueAt(1, this.m_yAxisCol).toString().equals(this.m_y2);
                    int n19 = 0;
                    while (n19 < n3 - 1) {
                        boolean bl2 = n19 + 1 < this.m_seriesCount ? this.m_table.getValueAt(n19 + 2, this.m_yAxisCol).toString().equals(this.m_y2) : this.m_graph.getUISeries().isAssignedToY2(n19 + 1);
                        if (bl != bl2) {
                            n2 = 0;
                            break;
                        }
                        bl = bl2;
                        ++n19;
                    }
                    if (n2 == 0) {
                        n19 = 0;
                        n19 = 0;
                        while (n19 < n3) {
                            boolean bl3 = n19 < this.m_seriesCount ? this.m_table.getValueAt(n19 + 1, this.m_yAxisCol).toString().equals(this.m_y2) : this.m_graph.getUISeries().isAssignedToY2(n19);
                            if (n19 == 1 && !bl3 || n19 != 1 && bl3) break;
                            ++n19;
                        }
                        if (n19 == n3) {
                            n2 = -1;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public void apply() {
        Object var1_1 = null;
        try {
            if (!this.m_isPareto) {
                int n;
                int n2;
                boolean bl = this._isAllSeriesSupported();
                int n3 = n2 = bl ? 1 : 0;
                if (bl && this.m_dataChanged[0][this.m_colorCol]) {
                    this.m_graph.getUISeries().setDefaultColor((Color)this.m_defaultColor);
                }
                if (!bl || this.m_table.getValueAt(0, this.m_colorCol) != null && this.m_table.getValueAt(0, this.m_colorCol).toString() == "") {
                    n = 0;
                    while (n < this.m_seriesCount) {
                        if (this.m_dataChanged[n + n2][this.m_colorCol]) {
                            this.m_graph.getUISeries().setColor((Color)this.m_table.getValueAt(n + n2, this.m_colorCol), n);
                        }
                        ++n;
                    }
                }
                if (this.m_isLine) {
                    if (bl && this.m_dataChanged[0][this.m_lineCol]) {
                        if (new Integer(this.m_defaultLineWidth.toString()) == 0) {
                            this.m_graph.setLineDataLineDisplayed(false);
                        } else {
                            this.m_graph.setLineDataLineDisplayed(true);
                            this.m_graph.getUISeries().setDefaultLineWidth(new Integer(this.m_defaultLineWidth.toString()));
                        }
                    }
                    if (!bl || this.m_table.getValueAt(0, this.m_lineCol).toString() == "") {
                        n = 0;
                        while (n < this.m_seriesCount) {
                            if (this.m_dataChanged[n + n2][this.m_lineCol]) {
                                this.m_graph.getUISeries().setLineWidth(new Integer(this.m_table.getValueAt(n + n2, this.m_lineCol).toString()), n);
                            }
                            ++n;
                        }
                    }
                }
                if (this.m_isMarker) {
                    if (bl && this.m_dataChanged[0][this.m_markerShapeCol]) {
                        if (this.m_table.getValueAt(0, this.m_markerShapeCol).toString().equals("0") && (this.m_graphType >= 41 && this.m_graphType <= 54 || this.m_graphType == 67 || this.m_isCombination)) {
                            this.m_graph.setMarkerDisplayed(false);
                        } else {
                            this.m_graph.setMarkerDisplayed(true);
                        }
                        this.m_graph.getUISeries().setDefaultMarkerShape(Integer.parseInt(this.m_defaultMarkerShape.toString()));
                    }
                    if (!bl || this.m_table.getValueAt(0, this.m_markerShapeCol).toString() == "") {
                        if (!this.m_graph.isMarkerDisplayed() && (this.m_graphType >= 41 && this.m_graphType <= 54 || this.m_graphType == 67 || this.m_isCombination)) {
                            this.m_graph.setMarkerDisplayed(true);
                        }
                        n = 0;
                        while (n < this.m_seriesCount) {
                            if (this.m_dataChanged[n + n2][this.m_markerShapeCol]) {
                                this.m_graph.getUISeries().setMarkerShape(Integer.parseInt(this.m_table.getValueAt(n + n2, this.m_markerShapeCol).toString()), n);
                            }
                            ++n;
                        }
                    }
                }
                if (this.m_isDualY) {
                    if (bl && this.m_dataChanged[0][this.m_yAxisCol]) {
                        if (this.m_defaultYAxis.toString().equals(this.m_auto)) {
                            this.m_graph.getUISeries().setDefaultAssignedToY2(2);
                        } else if (this.m_defaultYAxis.toString().equals(this.m_y1)) {
                            this.m_graph.getUISeries().setDefaultAssignedToY2(0);
                        } else {
                            this.m_graph.getUISeries().setDefaultAssignedToY2(1);
                        }
                    }
                    if (!bl || this.m_table.getValueAt(0, this.m_yAxisCol).toString() == "") {
                        n = 0;
                        while (n < this.m_seriesCount) {
                            if (this.m_dataChanged[n + n2][this.m_yAxisCol]) {
                                if (this.m_table.getValueAt(n + n2, this.m_yAxisCol).toString().equals(this.m_y1)) {
                                    this.m_graph.getUISeries().setAssignedToY2(false, n);
                                } else {
                                    this.m_graph.getUISeries().setAssignedToY2(true, n);
                                }
                            }
                            ++n;
                        }
                    }
                }
                if (this.m_isCombination) {
                    int n4;
                    String string = this.m_table.getValueAt(0, this.m_markerTypeCol).toString();
                    if (bl && this.m_dataChanged[0][this.m_markerTypeCol]) {
                        if (this.m_defaultMarkerType.toString() == this.m_auto) {
                            this.m_graph.getUISeries().setDefaultMarkerType(0);
                            n4 = 0;
                            while (n4 < this.m_graph.getSeriesObjectCount()) {
                                this.m_graph.getUISeries().setMarkerType(markerTypes[n4 % 3], n4);
                                ++n4;
                            }
                        } else {
                            this.m_graph.getUISeries().setDefaultMarkerType(this._getMarkerType(this.m_defaultMarkerType.toString()));
                        }
                    }
                    if (!bl || string == "") {
                        n4 = 0;
                        while (n4 < this.m_seriesCount) {
                            if (this.m_dataChanged[n4 + n2][this.m_markerTypeCol]) {
                                String string2 = this.m_table.getValueAt(n4 + n2, this.m_markerTypeCol).toString();
                                this.m_graph.getUISeries().setMarkerType(this._getMarkerType(string2), n4);
                            }
                            ++n4;
                        }
                    }
                }
                if (this.m_isFitline) {
                    if (bl && this.m_dataChanged[0][this.m_fitlineCol]) {
                        this.m_graph.getUISeries().setDefaultFitlineType(this._getFitlineType(this.m_defaultFitline.toString()));
                    }
                    if (!bl || this.m_table.getValueAt(0, this.m_fitlineCol).toString() == "") {
                        int n5 = 0;
                        while (n5 < this.m_seriesCount) {
                            if (this.m_dataChanged[n5 + n2][this.m_fitlineCol]) {
                                String string = this.m_table.getValueAt(n5 + n2, this.m_fitlineCol).toString();
                                this.m_graph.getUISeries().setFitlineType(this._getFitlineType(string), n5);
                            }
                            ++n5;
                        }
                    }
                }
            } else {
                this.m_graph.getUISeries().setColor((Color)this.m_table.getValueAt(0, 1), 0);
                this.m_graph.getParetoLine().setColor((Color)this.m_table.getValueAt(1, 1));
                if (this.m_lineCol != -1) {
                    this.m_graph.getParetoLine().setWidth(new Integer(this.m_table.getValueAt(1, this.m_lineCol).toString()));
                }
                if (this.m_markerShapeCol != -1 && this.m_dataChanged[1][this.m_markerShapeCol]) {
                    if (this.m_table.getValueAt(1, this.m_markerShapeCol).toString().equals("0")) {
                        this.m_graph.setMarkerDisplayed(false);
                    } else {
                        this.m_graph.setMarkerDisplayed(true);
                        this.m_graph.getParetoLine().setMarkerShape(new Integer(this.m_table.getValueAt(1, this.m_markerShapeCol).toString()));
                    }
                }
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
    }

    protected class SeriesJTable
    extends JTable
    implements TableModelListener {
        public SeriesJTable(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
            this.getTableHeader().setReorderingAllowed(false);
        }

        public boolean editCellAt(int n, int n2) {
            if (!Series.this.editorFocus) {
                return false;
            }
            return super.editCellAt(n, n2);
        }

        public boolean isCellEditable(int n, int n2) {
            int n3;
            if (n2 == 0 || n2 > Series.this.m_numUsedCols - 1) {
                return false;
            }
            if (!Series.this.m_showDataMarker && n2 == Series.this.m_markerShapeCol) {
                return false;
            }
            if (n2 == Series.this.m_lineCol && n > 0 && Series.this.m_lineNone) {
                return false;
            }
            if (Series.this.m_graph.getGraphType() == 102 && (n2 == 0 || n2 == Series.this.m_yAxisCol || n == 0 && (n2 == Series.this.m_lineCol || n2 == Series.this.m_markerShapeCol))) {
                return false;
            }
            return Series.this.m_markerTypeCol == -1 || n2 != Series.this.m_markerShapeCol && n2 != Series.this.m_lineCol || (n3 = Series.this._getMarkerType(Series.this.m_table.getValueAt(n, Series.this.m_markerTypeCol).toString())) != 1 && n3 != 3;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (!Series.this._isAllSeriesSupported()) {
                return super.getCellEditor(n, n2);
            }
            if (n2 == Series.this.m_markerShapeCol && n == 0) {
                return Series.this.defaultMarkerCellEditor;
            }
            if (n2 == Series.this.m_lineCol && n == 0) {
                return Series.this.defaultLineCellEditor;
            }
            if (n2 == Series.this.m_markerTypeCol && n == 0) {
                return Series.this.defaultMarkerTypeEditor;
            }
            if (n2 == Series.this.m_colorCol && n == 0) {
                return Series.this.defaultColorEditor;
            }
            if (n2 == Series.this.m_yAxisCol && n == 0) {
                return Series.this.defaultYAxisEditor;
            }
            return super.getCellEditor(n, n2);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            super.tableChanged(tableModelEvent);
            if (tableModelEvent.getFirstRow() == tableModelEvent.getLastRow() && tableModelEvent.getColumn() >= 0) {
                if (!Series.this._isAllSeriesSupported()) {
                    Series.this.m_dataChanged[tableModelEvent.getFirstRow()][tableModelEvent.getColumn()] = true;
                    return;
                }
                if (tableModelEvent.getFirstRow() == 0) {
                    if (!Series.this._flag2) {
                        return;
                    }
                    if (this.getValueAt(0, tableModelEvent.getColumn()) == "") {
                        return;
                    }
                    Series.this.m_dataChanged[tableModelEvent.getFirstRow()][tableModelEvent.getColumn()] = true;
                    Series.this._flag = false;
                    if (tableModelEvent.getColumn() == Series.this.m_markerShapeCol) {
                        Series.this.m_defaultMarkerShape = this.getValueAt(0, Series.this.m_markerShapeCol);
                        if (Integer.parseInt((String)this.getValueAt(0, Series.this.m_markerShapeCol)) != -1) {
                            int n = 1;
                            while (n < this.getRowCount()) {
                                this.setValueAt(this.getValueAt(0, Series.this.m_markerShapeCol), n, Series.this.m_markerShapeCol);
                                Series.this.m_dataChanged[n][Series.this.m_markerShapeCol] = false;
                                ++n;
                            }
                        } else {
                            int n = 1;
                            while (n < this.getRowCount()) {
                                this.setValueAt(new Integer(Series.this.m_graph.getPFJ().getLoopedMarkerShape(n - 1)), n, Series.this.m_markerShapeCol);
                                Series.this.m_dataChanged[n][Series.this.m_markerShapeCol] = false;
                                ++n;
                            }
                        }
                    } else if (tableModelEvent.getColumn() == Series.this.m_colorCol) {
                        Series.this.m_defaultColor = this.getValueAt(0, Series.this.m_colorCol);
                        if (this.getValueAt(0, Series.this.m_colorCol) instanceof Color) {
                            int n = 1;
                            while (n < this.getRowCount()) {
                                this.setValueAt((Color)this.getValueAt(0, Series.this.m_colorCol), n, Series.this.m_colorCol);
                                Series.this.m_dataChanged[n][Series.this.m_colorCol] = false;
                                ++n;
                            }
                        } else if (Series.this.autoColor.isAutomaticSelected()) {
                            int n = 1;
                            while (n < this.getRowCount()) {
                                this.setValueAt(new Color(GraphDefaultValues.getDefaultSeriesColor()[(n - 1) % 30]), n, Series.this.m_colorCol);
                                Series.this.m_dataChanged[n][Series.this.m_colorCol] = false;
                                ++n;
                            }
                        } else {
                            this.setValueAt("", 0, Series.this.m_colorCol);
                        }
                    } else if (tableModelEvent.getColumn() == Series.this.m_markerTypeCol) {
                        Series.this.m_defaultMarkerType = this.getValueAt(0, Series.this.m_markerTypeCol);
                        if (this.getValueAt(0, Series.this.m_markerTypeCol) != Series.this.m_auto) {
                            int n = 1;
                            while (n < this.getRowCount()) {
                                this.setValueAt(this.getValueAt(0, Series.this.m_markerTypeCol), n, Series.this.m_markerTypeCol);
                                Series.this.m_dataChanged[n][Series.this.m_markerTypeCol] = false;
                                ++n;
                            }
                        } else {
                            int n = 1;
                            while (n < this.getRowCount()) {
                                this.setValueAt(Series.this._getMarkerTypeString(markerTypes[(n - 1) % 3]), n, Series.this.m_markerTypeCol);
                                Series.this.m_dataChanged[n][Series.this.m_markerTypeCol] = false;
                                ++n;
                            }
                        }
                        this.repaint();
                    } else if (tableModelEvent.getColumn() == Series.this.m_yAxisCol) {
                        Series.this.m_defaultYAxis = this.getValueAt(0, Series.this.m_yAxisCol);
                        if (this.getValueAt(0, Series.this.m_yAxisCol) == Series.this.m_auto) {
                            int n = 1;
                            while (n < this.getRowCount()) {
                                if (n == 2) {
                                    this.setValueAt(Series.this.m_y2, n, Series.this.m_yAxisCol);
                                } else {
                                    this.setValueAt(Series.this.m_y1, n, Series.this.m_yAxisCol);
                                }
                                Series.this.m_dataChanged[n][Series.this.m_yAxisCol] = false;
                                ++n;
                            }
                        } else {
                            int n = 1;
                            while (n < this.getRowCount()) {
                                this.setValueAt(this.getValueAt(0, Series.this.m_yAxisCol), n, Series.this.m_yAxisCol);
                                Series.this.m_dataChanged[n][Series.this.m_yAxisCol] = false;
                                ++n;
                            }
                        }
                    } else if (tableModelEvent.getColumn() == Series.this.m_lineCol) {
                        int n = 1;
                        while (n < this.getRowCount()) {
                            this.setValueAt(this.getValueAt(0, Series.this.m_lineCol), n, Series.this.m_lineCol);
                            Series.this.m_dataChanged[n][Series.this.m_lineCol] = false;
                            ++n;
                        }
                        Series.this.m_defaultLineWidth = this.getValueAt(0, Series.this.m_lineCol);
                    } else if (tableModelEvent.getColumn() == Series.this.m_fitlineCol) {
                        int n = 1;
                        while (n < this.getRowCount()) {
                            this.setValueAt(this.getValueAt(0, Series.this.m_fitlineCol), n, Series.this.m_fitlineCol);
                            Series.this.m_dataChanged[n][Series.this.m_fitlineCol] = false;
                            ++n;
                        }
                        Series.this.m_defaultFitline = this.getValueAt(0, Series.this.m_fitlineCol);
                    }
                    Series.this._flag = true;
                } else {
                    if (!Series.this._isAllSeriesSupported()) {
                        return;
                    }
                    Series.this.m_dataChanged[tableModelEvent.getFirstRow()][tableModelEvent.getColumn()] = true;
                    if (!Series.this._flag) {
                        return;
                    }
                    Series.this._flag2 = false;
                    int n = Series.this._areSeriesSameValueOrAuto(tableModelEvent.getColumn());
                    if (n == 0) {
                        this.setValueAt("", 0, tableModelEvent.getColumn());
                        if (tableModelEvent.getColumn() == Series.this.m_colorCol && Series.this.autoColor.isAutomaticSelected()) {
                            Series.this.autoColor.setAutomaticSelected(false);
                        }
                    } else if (n == -1) {
                        if (Series.this.m_previousData[tableModelEvent.getColumn()] == null || !this.getValueAt(tableModelEvent.getFirstRow(), tableModelEvent.getColumn()).toString().equals(Series.this.m_previousData[tableModelEvent.getColumn()].toString())) {
                            this.setValueAt("", 0, tableModelEvent.getColumn());
                            if (tableModelEvent.getColumn() == Series.this.m_colorCol) {
                                Series.this.autoColor.setAutomaticSelected(false);
                            }
                        }
                    } else if (tableModelEvent.getColumn() == Series.this.m_colorCol) {
                        if (this.getValueAt(1, Series.this.m_colorCol) == Series.this.m_defaultColor || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultColor = this.getValueAt(1, Series.this.m_colorCol);
                            this.setValueAt(Series.this.m_defaultColor, 0, Series.this.m_colorCol);
                            Series.this.m_dataChanged[0][Series.this.m_colorCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_colorCol);
                        }
                    } else if (tableModelEvent.getColumn() == Series.this.m_markerTypeCol) {
                        if (this.getValueAt(1, Series.this.m_markerTypeCol).toString().equals(Series.this.m_defaultMarkerType.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultMarkerType = this.getValueAt(1, Series.this.m_markerTypeCol);
                            this.setValueAt(Series.this.m_defaultMarkerType, 0, Series.this.m_markerTypeCol);
                            Series.this.m_dataChanged[0][Series.this.m_markerTypeCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_markerTypeCol);
                        }
                    } else if (tableModelEvent.getColumn() == Series.this.m_markerShapeCol) {
                        if (this.getValueAt(1, Series.this.m_markerShapeCol).toString().equals(Series.this.m_defaultMarkerShape.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultMarkerShape = this.getValueAt(1, Series.this.m_markerShapeCol);
                            this.setValueAt(Series.this.m_defaultMarkerShape, 0, Series.this.m_markerShapeCol);
                            Series.this.m_dataChanged[0][Series.this.m_markerShapeCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_markerShapeCol);
                        }
                    } else if (tableModelEvent.getColumn() == Series.this.m_lineCol) {
                        if (this.getValueAt(1, Series.this.m_lineCol).toString().equals(Series.this.m_defaultLineWidth.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultLineWidth = this.getValueAt(1, Series.this.m_lineCol);
                            this.setValueAt(Series.this.m_defaultLineWidth, 0, Series.this.m_lineCol);
                            Series.this.m_dataChanged[0][Series.this.m_lineCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_lineCol);
                        }
                    } else if (tableModelEvent.getColumn() == Series.this.m_fitlineCol) {
                        if (this.getValueAt(1, Series.this.m_fitlineCol).toString().equals(Series.this.m_defaultFitline.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultFitline = this.getValueAt(1, Series.this.m_fitlineCol);
                            this.setValueAt(Series.this.m_defaultFitline, 0, Series.this.m_fitlineCol);
                            Series.this.m_dataChanged[0][Series.this.m_fitlineCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_fitlineCol);
                        }
                    } else if (tableModelEvent.getColumn() == Series.this.m_yAxisCol) {
                        if (this.getValueAt(1, Series.this.m_yAxisCol).toString().equals(Series.this.m_defaultYAxis.toString()) || Series.this.m_graph.getSeriesObjectCount() <= Series.this.m_seriesCount) {
                            Series.this.m_defaultYAxis = this.getValueAt(1, Series.this.m_yAxisCol);
                            this.setValueAt(Series.this.m_defaultYAxis, 0, Series.this.m_yAxisCol);
                            Series.this.m_dataChanged[0][Series.this.m_yAxisCol] = true;
                        } else {
                            this.setValueAt("", 0, Series.this.m_yAxisCol);
                        }
                    }
                    if (tableModelEvent.getColumn() == Series.this.m_markerTypeCol) {
                        this.repaint();
                    }
                    Series.this._flag2 = true;
                }
            }
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            int n = this.getSelectionModel().getAnchorSelectionIndex();
            int n2 = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39) {
                if (keyEvent.getKeyCode() == 9) {
                    if (n2 == this.getColumnCount() - 1 && n == this.getRowCount() - 1 && !keyEvent.isShiftDown() && keyEvent.getID() != 402) {
                        this.getCellEditor(n, n2).stopCellEditing();
                        this.requestFocus();
                        if (FocusManager.isFocusManagerEnabled()) {
                            FocusManager.getCurrentManager().focusNextComponent(this);
                            keyEvent.consume();
                        }
                        return;
                    }
                    if (n2 == 0 && n == 0 && keyEvent.isShiftDown() && keyEvent.getID() != 402) {
                        if (FocusManager.isFocusManagerEnabled()) {
                            FocusManager.getCurrentManager().focusPreviousComponent(this);
                            keyEvent.consume();
                        }
                        return;
                    }
                }
            } else if (keyEvent.getKeyCode() == 32 && n2 != 0 && this.isCellEditable(n, n2)) {
                Series.this.editorFocus = true;
                this.editCellAt(n, n2);
                this.getEditorComponent().requestFocus();
                if (this.getEditorComponent() instanceof JComboBox) {
                    this.getEditorComponent().setVisible(true);
                    ((JComboBox)this.getEditorComponent()).showPopup();
                }
            }
            super.processKeyEvent(keyEvent);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            if (focusEvent.getID() == 1005 && !focusEvent.isTemporary() && Series.this.editorFocus) {
                Series.this.editorFocus = false;
            }
            super.processFocusEvent(focusEvent);
        }
    }

    class ColorEditor
    extends DefaultCellEditor
    implements PropertyChangeListener,
    FocusListener {
        BIColorChoice colorChoice;
        Color currentColor;
        boolean lookForSelectionEvent;

        public ColorEditor(BIColorChoice bIColorChoice) {
            super(new JCheckBox());
            this.editorComponent = bIColorChoice;
            this.colorChoice = bIColorChoice;
            this.setClickCountToStart(1);
            bIColorChoice.addPropertyChangeListener(this);
            bIColorChoice.addFocusListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("popupVisible") && propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                this.lookForSelectionEvent = true;
            }
            if (this.lookForSelectionEvent && (propertyChangeEvent.getPropertyName().equals("selectedColor") || propertyChangeEvent.getPropertyName().equals("selectedColor"))) {
                this.currentColor = this.colorChoice.getSelectedColor();
                this._stopCellEditing();
            }
        }

        private void _stopCellEditing() {
            SwingUtilities.invokeLater(new Runnable(this){
                final /* synthetic */ ColorEditor this$0;

                public void run() {
                    if (!this.this$0.colorChoice.isPopupVisible()) {
                        Component component = SwingUtilities.findFocusOwner(WindowUtils.getWindow((Component)((Object)this.this$0.colorChoice)));
                        this.this$0.stopCellEditing();
                        if (component != null && component.isShowing()) {
                            component.requestFocus();
                        }
                    }
                }
                {
                    this.this$0 = colorEditor;
                }
            });
        }

        public Object getCellEditorValue() {
            return this.currentColor;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (this.colorChoice == null) {
                return null;
            }
            if (object != null && object.toString() == "") {
                object = null;
            }
            if (Series.this._isAllSeriesSupported() && n != 0) {
                Series.this.m_previousData[n2] = object;
            }
            this.currentColor = object instanceof Color ? (Color)object : null;
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.colorChoice.getColorPalette(), (Color)this.currentColor)) {
                this.colorChoice.setColorPalette(FontButton.getNewColorPalette(this.colorChoice.getColorPalette(), this.currentColor, Series.this.m_bColorPaletteSet));
            }
            this.colorChoice.setSelectedColor(this.currentColor);
            return this.colorChoice;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getID() != 506;
        }

        public boolean stopCellEditing() {
            boolean bl = super.stopCellEditing();
            if (bl) {
                this.lookForSelectionEvent = false;
            }
            return bl;
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                Series.this.editorFocus = true;
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && Series.this.editorFocus) {
                Series.this.editorFocus = false;
                this._stopCellEditing();
            }
        }
    }

    private class YAxisLabelRenderer
    extends LabelRenderer {
        YAxisLabelRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                jLabel.setText(Series.this._truncateText(object.toString()));
            }
            return jLabel;
        }
    }

    private class LabelRenderer
    extends DefaultTableCellRenderer {
        LabelRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setBackground(Color.white);
            component.setForeground(Color.black);
            if (bl) {
                this.setBorder(new LineBorder(Color.black, 2));
            }
            return component;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder;
        Border selectedBorder;
        boolean isBordered = true;

        public ColorRenderer(boolean bl) {
            this.isBordered = bl;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = Series.this.rBundle.getString("Color Rendered");
            MessageFormat messageFormat = new MessageFormat(string);
            if (object == null) {
                if (Series.this.autoColor.isAutomaticSelected()) {
                    this.setText(Series.this.m_auto);
                    this.getAccessibleContext().setAccessibleName(this.getText());
                } else {
                    this.setText("");
                    Object[] objectArray = new Object[]{IntegerUtils.getInteger((int)255), IntegerUtils.getInteger((int)255), IntegerUtils.getInteger((int)255)};
                    this.getAccessibleContext().setAccessibleName(messageFormat.format(objectArray));
                }
                this.setBackground(Color.white);
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, jTable.getBackground()));
            } else {
                this.setText("");
                CompoundBorder compoundBorder = new CompoundBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, jTable.getBackground()), BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
                if (object instanceof Color) {
                    Color color = (Color)object;
                    this.setBackground(color);
                    Object[] objectArray = new Object[]{IntegerUtils.getInteger((int)color.getRed()), IntegerUtils.getInteger((int)color.getGreen()), IntegerUtils.getInteger((int)color.getBlue())};
                    this.getAccessibleContext().setAccessibleName(messageFormat.format(objectArray));
                    this.setBorder(compoundBorder);
                } else {
                    this.setBackground(Color.white);
                    Object[] objectArray = new Object[]{IntegerUtils.getInteger((int)255), IntegerUtils.getInteger((int)255), IntegerUtils.getInteger((int)255)};
                    this.getAccessibleContext().setAccessibleName(messageFormat.format(objectArray));
                    this.setBorder(null);
                }
            }
            if (this.isBordered && bl) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                }
                this.setBorder(this.selectedBorder);
            }
            return this;
        }

        public void cleanUp() {
            this.setBorder(null);
            this.unselectedBorder = null;
            this.selectedBorder = null;
        }
    }

    class LineWidthCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Border unselectedBorder;
        Border selectedBorder;
        boolean isBordered = true;

        public LineWidthCellRenderer(boolean bl) {
            this.isBordered = bl;
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2 = new Integer(object.toString());
            if (bl) {
                this.setBackground(Color.blue);
            } else {
                this.setBackground(jList.getBackground());
            }
            if (object == "") {
                this.setText("");
                this.setIcon(null);
            } else if (n2 == 0) {
                this.setText(Series.this.rBundle.getString("None"));
                this.setIcon(null);
                this.getAccessibleContext().setAccessibleName(Series.this.rBundle.getString("None"));
            } else {
                this.setIcon(Series.this._getColorIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.Series$LineWidthRenderer"), (String)(String.valueOf(String.valueOf("images/Line")) + n2 + ".gif"))));
                if (n2 == 1) {
                    this.getAccessibleContext().setAccessibleName(Series.this.rBundle.getString("Single pixel"));
                } else {
                    this.getAccessibleContext().setAccessibleName(MessageFormat.format(Series.this.rBundle.getString("pixels"), new Integer(n2)));
                }
            }
            if (this.isBordered) {
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (!bl2) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.getBackground()));
            }
            return this;
        }
    }

    class LineWidthRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder;
        Border selectedBorder;
        boolean isBordered = true;

        public LineWidthRenderer(boolean bl) {
            this.isBordered = bl;
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3;
            if (this.isBordered) {
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, jTable.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (jTable.getValueAt(n, n2) != null && jTable.getValueAt(n, n2).toString() == "") {
                this.setText("");
                this.setIcon(null);
                this.setBackground(Color.white);
                return this;
            }
            int n4 = new Integer(jTable.getValueAt(n, n2).toString());
            if (n4 == 0) {
                this.setText(Series.this.rBundle.getString("None"));
                this.setIcon(null);
                this.getAccessibleContext().setAccessibleName(Series.this.rBundle.getString("None"));
            } else {
                this.setIcon(Series.this._getColorIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.Series$LineWidthRenderer"), (String)(String.valueOf(String.valueOf("images/Line")) + n4 + ".gif"))));
                if (n4 == 1) {
                    this.getAccessibleContext().setAccessibleName(Series.this.rBundle.getString("Single pixel"));
                } else {
                    this.getAccessibleContext().setAccessibleName(MessageFormat.format(Series.this.rBundle.getString("pixels"), new Integer(n4)));
                }
            }
            if (n > 0) {
                if (Series.this.m_lineNone) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(true);
            }
            if (Series.this.m_markerTypeCol != -1 && ((n3 = Series.this._getMarkerType(Series.this.m_table.getValueAt(n, Series.this.m_markerTypeCol).toString())) == 1 || n3 == 3)) {
                this.setEnabled(false);
            }
            if (this.isEnabled()) {
                this.setBackground(Color.white);
            } else {
                this.setBackground(Series.this.m_table.getTableHeader().getBackground());
            }
            if (!bl2) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.getBackground()));
            }
            return this;
        }
    }

    class MarkerShapeEditor
    extends JLabel
    implements ListCellRenderer {
        public MarkerShapeEditor() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(Color.blue);
            } else {
                this.setBackground(jList.getBackground());
            }
            if (object == "") {
                this.setText("");
                this.setIcon(null);
            } else if (object.equals("-1")) {
                this.setText(Series.this.m_auto);
                this.setIcon(null);
                this.getAccessibleContext().setAccessibleName(Series.this.m_auto);
            } else if (object.equals("0")) {
                this.setText(Series.this.rBundle.getString("None"));
                this.setIcon(null);
                this.getAccessibleContext().setAccessibleName(Series.this.rBundle.getString("None"));
            } else {
                String string = "";
                int n2 = new Integer((String)object);
                this.setText("");
                this.setIcon(Series.this.m_icons[n2 - 1]);
                this.getAccessibleContext().setAccessibleName(Series.this._getMarkerShape(n2));
            }
            this.setMinimumSize(new Dimension(50, this.getMinimumSize().height));
            this.setPreferredSize(new Dimension(50, this.getPreferredSize().height));
            this.setMaximumSize(new Dimension(50, this.getMaximumSize().height));
            return this;
        }
    }

    class MarkerShapeRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder;
        Border selectedBorder;
        boolean isBordered = true;

        public MarkerShapeRenderer(boolean bl) {
            this.isBordered = bl;
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(Series.this.m_showDataMarker);
            if (this.isBordered) {
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, jTable.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (object == null || object == "") {
                this.setText("");
                this.setIcon(null);
                this.setBackground(Color.white);
                return this;
            }
            int n3 = new Integer(object.toString());
            if (n3 == -1) {
                this.setText(Series.this.m_auto);
                this.setIcon(null);
            } else if (n3 == 0) {
                this.setText(Series.this.rBundle.getString("None"));
                this.setIcon(null);
            } else {
                this.setText("");
                this.setIcon(Series.this.m_icons[n3 - 1]);
                this.getAccessibleContext().setAccessibleName(Series.this._getMarkerShape(n3));
            }
            if (Series.this.m_markerTypeCol != -1) {
                int n4 = Series.this._getMarkerType(Series.this.m_table.getValueAt(n, Series.this.m_markerTypeCol).toString());
                if (n4 == 1 || n4 == 3) {
                    this.setEnabled(false);
                    this.setBackground(Series.this.m_table.getTableHeader().getBackground());
                } else {
                    this.setEnabled(true);
                    this.setBackground(Color.white);
                }
            }
            if (!bl2) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.getBackground()));
            }
            return this;
        }
    }

    private class Filter
    extends RGBImageFilter {
        private int _color;
        private final int _sCOLOR = new Color(255, 0, 255).getRGB();

        public Filter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor() {
            Color color = Color.black;
            this._color = color == null ? 0 : color.getRGB();
        }

        public int filterRGB(int n, int n2, int n3) {
            if (n3 == this._sCOLOR) {
                return this._color;
            }
            return n3;
        }
    }

    private class ComboBoxCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        public ComboBoxCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            jComboBox.addFocusListener(this);
            jComboBox.removeActionListener(this.delegate);
            this.delegate = new DefaultCellEditor.EditorDelegate(jComboBox, this){
                final /* synthetic */ JComboBox al$comboBox;
                final /* synthetic */ ComboBoxCellEditor this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.Series.this.m_table.editCellAt(0, 0);
                    ComboBoxCellEditor.access$5000171(this.this$0);
                }

                public void setValue(Object object) {
                    if (object instanceof Integer) {
                        object = object.toString();
                    }
                    if (object == "") {
                        this.al$comboBox.setSelectedIndex(-1);
                    } else {
                        this.al$comboBox.setSelectedItem(object);
                    }
                }

                public Object getCellEditorValue() {
                    return this.al$comboBox.getSelectedItem();
                }
                {
                    this.al$comboBox = jComboBox;
                    this.this$0 = comboBoxCellEditor;
                }
            };
            jComboBox.addActionListener(this.delegate);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (Series.this._isAllSeriesSupported() && n != 0) {
                Series.this.m_previousData[n2] = object;
            }
            this.delegate.setValue(object);
            return this.editorComponent;
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                Series.this.editorFocus = true;
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() && Series.this.editorFocus) {
                Series.this.editorFocus = false;
                this.stopCellEditing();
            }
        }

        static /* synthetic */ void access$5000171(ComboBoxCellEditor comboBoxCellEditor) {
            comboBoxCellEditor.fireEditingStopped();
        }
    }

    private class LightCombo
    extends JComboBox {
        private ActionListener enterAction;

        public LightCombo() {
            this._init();
        }

        public LightCombo(String[] stringArray) {
            super(stringArray);
            this._init();
        }

        public Object getSelectedItem() {
            if (this.getSelectedIndex() == -1) {
                return "";
            }
            return super.getSelectedItem();
        }

        private void _init() {
            this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
            this.enterAction = new ActionListener(null){
                final /* synthetic */ LightCombo this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                }
                {
                    this.this$0 = lightCombo;
                }
            };
            this.registerKeyboardAction(this.enterAction, KeyStroke.getKeyStroke(10, 0), 1);
        }

        public void cleanUp() {
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            this.enterAction = null;
        }
    }

    private class LineWidthWithBlank
    extends LineWidth {
        LineWidthWithBlank() {
        }

        public Object getSelectedItem() {
            if (this.getSelectedIndex() == -1) {
                return "";
            }
            return super.getSelectedItem();
        }
    }

    private class LineWidthWithBlankAndNone
    extends LineWidthWithBlank {
        public LineWidthWithBlankAndNone() {
            super.insertItemAt(new Integer(0).toString(), 0);
        }
    }
}

