/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.BrowserLookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.graph.gui.LineWidth;
import oracle.dss.graph.gui.Series;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.help.HelpContext;

public class PlotArea
extends BasePanel
implements ActionListener,
ItemListener,
PropertyChangeListener,
HelpContext {
    private ResourceBundle rBundle;
    private Component m_tmpPanel;
    protected HelpProvider m_helpProvider;
    protected int m_currentType;
    protected JLabel m_backgroundLabel;
    protected JLabel m_borderLabel;
    protected JLabel m_seriesLabel;
    protected JLabel m_horzLabel;
    protected JLabel m_vertLabel;
    protected BIColorChoice m_backgroundColor;
    protected BIColorChoice m_borderColor;
    protected JCheckBox m_horzBox;
    protected JCheckBox m_vertBox;
    protected JCheckBox m_dataLabelBox;
    protected JCheckBox m_dataTipsBox;
    protected LineWidth m_horzLineWidth;
    protected LineWidth m_vertLineWidth;
    protected BIColorChoice m_horzColor;
    protected BIColorChoice m_vertColor;
    protected JButton m_dataLabelOption;
    protected FontButton m_fontButton;
    protected JButton m_dataTipsOption;
    protected Series m_series;
    protected Color m_oldBackgroundColor;
    protected Color m_bColor;
    protected Color m_bgColor;
    protected Color m_yColor;
    protected Color m_oColor;
    protected Color m_bdColor;
    protected Color m_oldHorzColor;
    protected int m_oldHorzLineWidth;
    protected Color m_oldVertColor;
    protected int m_oldVertLineWidth;
    protected int m_tooltipType;
    protected int m_labelPosition;
    protected DataTip m_dataTip;
    protected DataLabel m_dataLabel;
    protected ComponentAdapter m_componentListener;
    protected ArrayTwoDModel m_colorPalette;
    protected boolean m_bColorPaletteSet;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh;
    protected String m_strHelpContextID;
    protected JPanel m_backgroundColorPanel;
    protected JPanel m_borderColorPanel;
    protected JPanel m_horzGridLinesPanel;
    protected JPanel m_vertGridLinesPanel;
    protected JPanel m_dataLabelsPanel;
    protected JPanel m_dataTipsPanel;
    protected boolean m_bBackgroundChanged;
    protected boolean m_bBorderColorChanged;
    protected boolean m_bHorzVisibleChanged;
    protected boolean m_bHorzColorChanged;
    protected boolean m_bHorzWidthChanged;
    protected boolean m_bVertVisibleChanged;
    protected boolean m_bVertColorChanged;
    protected boolean m_bVertWidthChanged;
    protected boolean m_bDataLabelVisibleChanged;
    protected boolean m_bDataTipVisibleChanged;
    protected boolean m_bDataLabelPositionChanged;
    protected boolean m_bDataLabelTextTypeChanged;
    protected boolean m_bDataTipTypeChanged;
    protected boolean m_bDataLabelFontColorChanged;
    protected boolean m_bDataLabelFontNameChanged;
    protected boolean m_bDataLabelFontSizeChanged;
    protected boolean m_bDataLabelFontBoldChanged;
    protected boolean m_bDataLabelFontItalicChanged;
    protected boolean m_bDataLabelFontUnderlineChanged;
    protected boolean m_bDataMarkerVisibleChanged;
    protected boolean m_bMainFontNameChange;
    protected String m_mainOldFontName;
    protected String m_mainNewFontName;
    protected boolean m_bMainFontStyleChange;
    protected int m_mainOldFontStyle;
    protected int m_mainNewFontStyle;
    protected boolean m_bMainFontSizeChange;
    protected int m_mainOldFontSize;
    protected int m_mainNewFontSize;
    protected boolean m_bMainFontColorChange;
    protected Color m_mainOldFontColor;
    protected Color m_mainNewFontColor;
    private static Color c_Transparent;
    private int m_initialWidth = -1;
    private int m_initialHeight = -1;
    public static final String PROPERTY_BACKGROUND_COLOR = "BackgroundColor";
    public static final String PROPERTY_BORDER_COLOR = "BorderColor";
    public static final String PROPERTY_HORIZONTAL_GRID_VISIBLE = "HorizontalGridVisible";
    public static final String PROPERTY_HORIZONTAL_GRID_COLOR = "HorizontalGridColor";
    public static final String PROPERTY_HORIZONTAL_GRID_LINE_WIDTH = "HorizontalGridLineWidth";
    public static final String PROPERTY_VERTICAL_GRID_VISIBLE = "VerticalGridVisible";
    public static final String PROPERTY_VERTICAL_GRID_COLOR = "VerticalGridColor";
    public static final String PROPERTY_VERTICAL_GRID_LINE_WIDTH = "VerticalGridLineWidth";
    public static final String PROPERTY_DATA_LABEL_POSITION = "DataLabelPosition";
    public static final String PROPERTY_DATA_LABEL_VISIBLE = "DataLabelVisible";
    public static final String PROPERTY_DATA_LABEL_TEXT = "DataLabelText";
    public static final String PROPERTY_DATA_TIPS_VISIBLE = "DataTipsVisible";
    public static final String PROPERTY_DATA_MARKER_VISIBLE = "DataMarkerVisible";
    public static final String PROPERTY_DATA_TIPS_TEXT = "DataTipsText";
    public static final int COLOR_COLUMN = 1;
    public static final int LINE_COLUMN = 2;
    public static final int MARKER_SHAPE_COLUMN = 4;
    public static final int YAXIS_COLUMN = 16;
    public static final int MARKER_TYPE_COLUMN = 32;
    public static final int FITLINE_COLUMN = 64;

    public PlotArea(Graph graph) {
        super(graph);
        this._initialize(graph, 0);
    }

    public PlotArea(Graph graph, int n) {
        super(graph);
        this._initialize(graph, n);
    }

    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.m_currentType = this.m_graph.getGraphType();
        this.m_tooltipType = this.m_graph.getMarkerTooltipType();
        this.m_backgroundLabel.setEnabled(true);
        this.m_backgroundColor.setEnabled(true);
        this.m_backgroundColor.setLocale(graph.getLocale());
        this.m_backgroundColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_borderLabel.setEnabled(true);
        this.m_borderColor.setEnabled(true);
        this.m_borderColor.setLocale(graph.getLocale());
        this.m_borderColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_horzBox.setSelected(true);
        this.m_horzBox.setEnabled(true);
        this.m_horzLineWidth.setEnabled(true);
        this.m_horzColor.setEnabled(true);
        this.m_horzColor.setLocale(graph.getLocale());
        this.m_horzColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_vertBox.setSelected(true);
        this.m_vertBox.setEnabled(true);
        this.m_vertLineWidth.setEnabled(true);
        this.m_vertColor.setEnabled(true);
        this.m_vertColor.setLocale(graph.getLocale());
        this.m_vertColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_vertLabel.setEnabled(true);
        this.m_horzLabel.setEnabled(true);
        this.m_horzGridLinesPanel.setVisible(true);
        this.m_vertGridLinesPanel.setVisible(true);
        this.m_dataLabelsPanel.setVisible(true);
        this.m_vertLineWidth.setVisible(true);
        this.m_horzLineWidth.setVisible(true);
        this.m_tmpPanel.setVisible(true);
        this.m_dataLabelBox.setSelected(true);
        this.m_dataLabelBox.setEnabled(true);
        String string = !this._isDataLabelInTheCenterSupported() ? MessageFormat.format(this.rBundle.getString("PlotArea Show uneditable labels"), this._getDataLabelString()) : MessageFormat.format(this.rBundle.getString("PlotArea Show labels"), this._getDataLabelString());
        this.m_dataLabelBox.setText(StringUtils.stripMnemonic((String)string));
        this.m_dataLabelBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.setDataLabelOptions();
        string = MessageFormat.format(this.rBundle.getString("Show tips"), this._getDataLabelString());
        this.m_dataTipsBox.setText(StringUtils.stripMnemonic((String)string));
        this.m_dataTipsBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = this.m_currentType == 65 || this.m_currentType == 67 ? this.rBundle.getString("Show Cg lines") : this.rBundle.getString("Show Hg lines");
        this.m_horzBox.setText(StringUtils.stripMnemonic((String)string));
        this.m_horzBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = this.m_currentType == 65 || this.m_currentType == 67 ? this.rBundle.getString("Show Rg lines") : this.rBundle.getString("Show Vg lines");
        this.m_vertBox.setText(StringUtils.stripMnemonic((String)string));
        this.m_vertBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.sizeComponents();
        this._init();
        if (graph.getGraphType() == 12 || graph.getGraphType() == 70 || graph.getGraphType() == 71 || graph.getGraphType() == 72 || graph.getGraphType() == 84) {
            this.m_seriesLabel.setVisible(false);
            this.m_series.setVisible(false);
        } else {
            this.m_seriesLabel.setVisible(true);
            this.m_series.setVisible(false);
            this.m_series.setGraph(graph);
            this.m_series.setMaximumSize(this.m_series.getPreferredSize());
            this.m_series.setVisible(true);
        }
        this.m_dataLabel = null;
        this.m_dataTip = null;
        this.m_bBackgroundChanged = false;
        this.m_bBorderColorChanged = false;
        this.m_bHorzVisibleChanged = false;
        this.m_bHorzColorChanged = false;
        this.m_bHorzWidthChanged = false;
        this.m_bVertVisibleChanged = false;
        this.m_bVertColorChanged = false;
        this.m_bVertWidthChanged = false;
        this.m_bDataLabelVisibleChanged = false;
        this.m_bDataTipVisibleChanged = false;
        this.m_bDataLabelPositionChanged = false;
        this.m_bDataLabelTextTypeChanged = false;
        this.m_bDataTipTypeChanged = false;
        this.m_bDataLabelFontColorChanged = false;
        this.m_bDataLabelFontNameChanged = false;
        this.m_bDataLabelFontSizeChanged = false;
        this.m_bDataLabelFontBoldChanged = false;
        this.m_bDataLabelFontItalicChanged = false;
        this.m_bDataLabelFontUnderlineChanged = false;
        this.m_bDataMarkerVisibleChanged = false;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_eh = errorHandler;
    }

    public void setSelectedSeries(int n) {
        if (this.m_series != null) {
            this.m_series.setSelectedSeries(n);
        }
    }

    public int getSelectedSeries() {
        if (this.m_series != null) {
            return this.m_series.getSelectedSeries();
        }
        return -1;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void setColorPalette(Color[][] colorArray) {
        BIColorChoice bIColorChoice;
        BIColorChoice bIColorChoice2;
        if (colorArray != null) {
            this.m_colorPalette = FontButton.getArrayTwoDModel(colorArray);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            this.m_colorPalette = null;
        }
        if (this.m_bgColor != null) {
            this.m_backgroundColor.setSelectedColor((Color)this.m_backgroundColor.getColorPalette().getData(0, 0));
            this.m_backgroundColor.setColorPalette((TwoDModel)this.m_colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)this.m_bgColor)) {
                    this.m_backgroundColor.setColorPalette(FontButton.getNewColorPalette(this.m_backgroundColor.getColorPalette(), this.m_bgColor, this.m_bColorPaletteSet));
                }
                this.m_backgroundColor.setSelectedColor(this.m_bgColor);
            } else {
                this.m_backgroundColor.setSelectedColor(this.m_backgroundColor.getClosestColor(this.m_bgColor));
            }
        } else {
            this.m_backgroundColor.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        if (this.m_bdColor != null) {
            this.m_borderColor.setSelectedColor((Color)this.m_borderColor.getColorPalette().getData(0, 0));
            this.m_borderColor.setColorPalette((TwoDModel)this.m_colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bdColor)) {
                    this.m_borderColor.setColorPalette(FontButton.getNewColorPalette(this.m_borderColor.getColorPalette(), this.m_bdColor, this.m_bColorPaletteSet));
                }
                this.m_borderColor.setSelectedColor(this.m_bdColor);
            } else {
                this.m_borderColor.setSelectedColor(this.m_borderColor.getClosestColor(this.m_bdColor));
            }
        } else {
            this.m_borderColor.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        if (!this.m_graph.isHorizontal()) {
            bIColorChoice2 = this.m_horzColor;
            bIColorChoice = this.m_vertColor;
        } else {
            bIColorChoice2 = this.m_vertColor;
            bIColorChoice = this.m_horzColor;
        }
        if (this.m_yColor != null) {
            bIColorChoice2.setSelectedColor((Color)bIColorChoice2.getColorPalette().getData(0, 0));
            bIColorChoice2.setColorPalette((TwoDModel)this.m_colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)bIColorChoice2.getColorPalette(), (Color)this.m_yColor)) {
                    bIColorChoice2.setColorPalette(FontButton.getNewColorPalette(bIColorChoice2.getColorPalette(), this.m_yColor, this.m_bColorPaletteSet));
                }
                bIColorChoice2.setSelectedColor(this.m_yColor);
            } else {
                bIColorChoice2.setSelectedColor(bIColorChoice2.getClosestColor(this.m_yColor));
            }
        } else {
            bIColorChoice2.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        if (this.m_oColor != null) {
            bIColorChoice.setSelectedColor((Color)bIColorChoice.getColorPalette().getData(0, 0));
            bIColorChoice.setColorPalette((TwoDModel)this.m_colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)bIColorChoice.getColorPalette(), (Color)this.m_oColor)) {
                    bIColorChoice.setColorPalette(FontButton.getNewColorPalette(bIColorChoice.getColorPalette(), this.m_oColor, this.m_bColorPaletteSet));
                }
                bIColorChoice.setSelectedColor(this.m_oColor);
            } else {
                bIColorChoice.setSelectedColor(bIColorChoice.getClosestColor(this.m_oColor));
            }
        } else {
            bIColorChoice.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        this.m_series.setColorPalette(this.m_colorPalette);
        if (this.m_dataLabel != null) {
            this.m_dataLabel.getFontButton().setColorPalette(this.m_colorPalette);
        }
        if (this.m_fontButton != null) {
            this.m_fontButton.setColorPalette(this.m_colorPalette);
        }
    }

    public Color[][] getColorPalette() {
        return FontButton.getColorArray(this.m_backgroundColor.getColorPalette());
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_mainPanel.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
        this.m_mainPanel.remove(this.m_series);
        this.m_series.cleanUp();
        this.m_series = null;
        this.m_dataTip = null;
        this.m_dataLabel = null;
        this.m_horzGridLinesPanel.remove(this.m_horzLineWidth);
        this.m_horzLineWidth.cleanUp();
        this.m_horzLineWidth = null;
        this.m_vertGridLinesPanel.remove(this.m_vertLineWidth);
        this.m_vertLineWidth.cleanUp();
        this.m_vertLineWidth = null;
    }

    private void _initialize(Graph graph, int n) {
        this.updateResourceBundle(graph.getLocale());
        this.setTitleText(this.rBundle.getString("plot area options"));
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_currentType = this.m_graph.getGraphType();
        this.m_tooltipType = this.m_graph.getMarkerTooltipType();
        this.m_labelPosition = 1;
        this.m_backgroundColorPanel = new JPanel();
        this.m_backgroundColorPanel.setLayout(new BoxLayout(this.m_backgroundColorPanel, 0));
        String string = this.rBundle.getString("PlotArea Bg color");
        this.m_backgroundLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_backgroundLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_backgroundColor = new BIColorChoice();
        this.m_backgroundColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_backgroundColor.setLocale(graph.getLocale());
        this.m_backgroundColor.setTransparentAllowed(true);
        this.m_backgroundLabel.setLabelFor((Component)((Object)this.m_backgroundColor));
        this.m_backgroundColorPanel.add(this.m_backgroundLabel);
        this.m_backgroundColorPanel.add((Component)((Object)this.m_backgroundColor));
        this.m_borderColorPanel = new JPanel();
        this.m_borderColorPanel.setLayout(new BoxLayout(this.m_borderColorPanel, 0));
        string = this.rBundle.getString("PlotArea Br color");
        this.m_borderLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_borderLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_borderColor = new BIColorChoice();
        this.m_borderColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_borderColor.setLocale(graph.getLocale());
        this.m_borderColor.setTransparentAllowed(true);
        this.m_borderLabel.setLabelFor((Component)((Object)this.m_borderColor));
        this.m_borderColorPanel.add(this.m_borderLabel);
        this.m_borderColorPanel.add((Component)((Object)this.m_borderColor));
        this.m_horzGridLinesPanel = new JPanel();
        this.m_horzGridLinesPanel.setLayout(new BoxLayout(this.m_horzGridLinesPanel, 0));
        string = this.m_currentType == 65 || this.m_currentType == 67 ? this.rBundle.getString("Show Cg lines") : this.rBundle.getString("Show Hg lines");
        this.m_horzBox = new JCheckBox(StringUtils.stripMnemonic((String)string));
        this.m_horzBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_horzLineWidth = new LineWidth();
        this.m_horzColor = new BIColorChoice();
        this.m_horzColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_horzColor.setLocale(graph.getLocale());
        string = this.rBundle.getString("Color I");
        this.m_horzLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_horzLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_horzLabel.setLabelFor((Component)((Object)this.m_horzColor));
        this.m_horzGridLinesPanel.add(this.m_horzBox);
        this.m_horzGridLinesPanel.add(this.m_horzLineWidth);
        this.m_horzGridLinesPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        this.m_horzGridLinesPanel.add(this.m_horzLabel);
        this.m_horzGridLinesPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.m_horzGridLinesPanel.add((Component)((Object)this.m_horzColor));
        this.m_vertGridLinesPanel = new JPanel();
        this.m_vertGridLinesPanel.setLayout(new BoxLayout(this.m_vertGridLinesPanel, 0));
        string = this.m_currentType == 65 || this.m_currentType == 67 ? this.rBundle.getString("Show Rg lines") : this.rBundle.getString("Show Vg lines");
        this.m_vertBox = new JCheckBox(StringUtils.stripMnemonic((String)string));
        this.m_vertBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_vertLineWidth = new LineWidth();
        this.m_vertColor = new BIColorChoice();
        this.m_vertColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_vertColor.setLocale(graph.getLocale());
        string = this.rBundle.getString("Color II");
        this.m_vertLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_vertLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_vertLabel.setLabelFor((Component)((Object)this.m_vertColor));
        this.m_vertGridLinesPanel.add(this.m_vertBox);
        this.m_vertGridLinesPanel.add(this.m_vertLineWidth);
        this.m_vertGridLinesPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        this.m_vertGridLinesPanel.add(this.m_vertLabel);
        this.m_vertGridLinesPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.m_vertGridLinesPanel.add((Component)((Object)this.m_vertColor));
        this.m_dataLabelsPanel = new JPanel();
        this.m_dataLabelsPanel.setLayout(new BoxLayout(this.m_dataLabelsPanel, 0));
        string = !this._isDataLabelInTheCenterSupported() ? MessageFormat.format(this.rBundle.getString("PlotArea Show uneditable labels"), this._getDataLabelString()) : MessageFormat.format(this.rBundle.getString("PlotArea Show labels"), this._getDataLabelString());
        this.m_dataLabelBox = new JCheckBox(StringUtils.stripMnemonic((String)string));
        this.m_dataLabelBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.setDataLabelOptions();
        this.m_dataTipsPanel = new JPanel();
        this.m_dataTipsPanel.setLayout(new BoxLayout(this.m_dataTipsPanel, 0));
        string = MessageFormat.format(this.rBundle.getString("Show tips"), this._getDataLabelString());
        this.m_dataTipsBox = new JCheckBox(StringUtils.stripMnemonic((String)string));
        this.m_dataTipsBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = this.rBundle.getString("Options II");
        this.m_dataTipsOption = new JButton(StringUtils.stripMnemonic((String)string));
        this.m_dataTipsOption.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_dataTipsPanel.add(this.m_dataTipsBox);
        this.m_dataTipsPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        this.m_dataTipsPanel.add(this.m_dataTipsOption);
        string = this.rBundle.getString("Show data marker");
        string = this.rBundle.getString("items options");
        this.m_seriesLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_seriesLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_series = new Series(graph, n, StringUtils.stripMnemonic((String)string));
        this.m_seriesLabel.setLabelFor(this.m_series);
        this.m_horzBox.setForeground(this.m_label.getForeground());
        this.m_vertBox.setForeground(this.m_label.getForeground());
        this.m_dataLabelBox.setForeground(this.m_label.getForeground());
        this.m_dataTipsBox.setForeground(this.m_label.getForeground());
        this.m_dataTipsOption.setForeground(this.m_label.getForeground());
        this.m_series.setForeground(this.m_label.getForeground());
        this.m_mainPanel.add(this.m_backgroundColorPanel);
        this.m_mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.m_mainPanel.add(this.m_borderColorPanel);
        this.m_mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.m_mainPanel.add(this.m_horzGridLinesPanel);
        this.m_mainPanel.add(this.m_vertGridLinesPanel);
        this.m_tmpPanel = Box.createRigidArea(new Dimension(0, 10));
        this.m_mainPanel.add(this.m_tmpPanel);
        this.m_mainPanel.add(this.m_dataLabelsPanel);
        this.m_mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.m_mainPanel.add(this.m_dataTipsPanel);
        this.m_mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.m_mainPanel.add(this.m_seriesLabel);
        this.m_mainPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        if (this.m_series != null) {
            this.m_mainPanel.add(this.m_series);
        }
        this.m_mainPanel.add(Box.createVerticalGlue());
        if (graph.getGraphType() == 12 || graph.getGraphType() == 70 || graph.getGraphType() == 71 || graph.getGraphType() == 72 || graph.getGraphType() == 84) {
            this.m_seriesLabel.setVisible(false);
            this.m_series.setVisible(false);
        }
        this.m_backgroundColorPanel.setAlignmentX(0.0f);
        this.m_borderColorPanel.setAlignmentX(0.0f);
        this.m_horzGridLinesPanel.setAlignmentX(0.0f);
        this.m_vertGridLinesPanel.setAlignmentX(0.0f);
        this.m_dataLabelsPanel.setAlignmentX(0.0f);
        this.m_dataTipsPanel.setAlignmentX(0.0f);
        this.m_seriesLabel.setAlignmentX(0.0f);
        this.m_series.setAlignmentX(0.0f);
        this.sizeComponents();
        this.m_dataTipsOption.addActionListener(this);
        this.m_backgroundColor.addPropertyChangeListener(this);
        this.m_borderColor.addPropertyChangeListener(this);
        this.m_vertColor.addPropertyChangeListener(this);
        this.m_horzColor.addPropertyChangeListener(this);
        this.m_horzBox.addItemListener(this);
        this.m_horzLineWidth.addItemListener(this);
        this.m_vertBox.addItemListener(this);
        this.m_vertLineWidth.addItemListener(this);
        this.m_dataLabelBox.addItemListener(this);
        this.m_dataTipsBox.addItemListener(this);
        this._init();
        this.m_dataTip = null;
        this.m_dataLabel = null;
        this.m_bBackgroundChanged = false;
        this.m_bBorderColorChanged = false;
        this.m_bHorzVisibleChanged = false;
        this.m_bHorzColorChanged = false;
        this.m_bHorzWidthChanged = false;
        this.m_bVertVisibleChanged = false;
        this.m_bVertColorChanged = false;
        this.m_bVertWidthChanged = false;
        this.m_bDataLabelVisibleChanged = false;
        this.m_bDataTipVisibleChanged = false;
        this.m_bDataLabelPositionChanged = false;
        this.m_bDataLabelTextTypeChanged = false;
        this.m_bDataTipTypeChanged = false;
        this.m_bDataLabelFontColorChanged = false;
        this.m_bDataLabelFontNameChanged = false;
        this.m_bDataLabelFontSizeChanged = false;
        this.m_bDataLabelFontBoldChanged = false;
        this.m_bDataLabelFontItalicChanged = false;
        this.m_bDataLabelFontUnderlineChanged = false;
        this.m_bDataMarkerVisibleChanged = false;
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private String _getDataLabelString() {
        String string = "";
        switch (this.m_currentType) {
            case 17: 
            case 19: {
                if (this._isCombinationType()) {
                    string = String.valueOf(string) + this.rBundle.getString("markers");
                    break;
                }
                string = String.valueOf(string) + this.rBundle.getString("bars");
                break;
            }
            case 0: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 102: {
                string = String.valueOf(string) + this.rBundle.getString("bars");
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                if (this.m_graph.isLineDataLineDisplayed()) {
                    string = String.valueOf(string) + this.rBundle.getString("lines");
                    break;
                }
                string = String.valueOf(string) + this.rBundle.getString("points");
                break;
            }
            case 6: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = String.valueOf(string) + this.rBundle.getString("areas");
                break;
            }
            case 55: 
            case 57: 
            case 93: {
                string = String.valueOf(string) + this.rBundle.getString("pie slices");
                break;
            }
            case 56: 
            case 58: 
            case 94: {
                string = String.valueOf(string) + this.rBundle.getString("ring slices");
                break;
            }
            case 61: 
            case 62: 
            case 65: {
                string = String.valueOf(string) + this.rBundle.getString("markers");
                break;
            }
            case 67: {
                string = String.valueOf(string) + this.rBundle.getString("lines");
                break;
            }
            case 89: 
            case 91: {
                string = String.valueOf(string) + this.rBundle.getString("bubbles");
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 79: 
            case 83: 
            case 84: 
            case 88: {
                string = String.valueOf(string) + this.rBundle.getString("stock markers");
                break;
            }
            case 4: {
                string = String.valueOf(string) + this.rBundle.getString("cubes");
                break;
            }
            case 7: {
                string = String.valueOf(string) + this.rBundle.getString("ribbons");
                break;
            }
            case 12: {
                string = String.valueOf(string) + this.rBundle.getString("surface");
            }
        }
        return string;
    }

    private boolean _isDataLabelInTheCenterSupported() {
        boolean bl = false;
        switch (this.m_currentType) {
            case 17: 
            case 19: {
                if (this._isCombinationType()) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 88: 
            case 93: 
            case 94: 
            case 102: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private boolean _isCombinationType() {
        try {
            int n = 0;
            while (n < this.m_graph.getSeriesObjectCount()) {
                if (this.m_graph.getUISeries().getMarkerType(n) != 0) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        return false;
    }

    private boolean _isPie() {
        return this.m_currentType >= 55 && this.m_currentType <= 60 || this.m_currentType >= 93 && this.m_currentType <= 94;
    }

    private boolean _isPercentGraph() {
        return this._isPie() || this.m_currentType == 35 || this.m_currentType == 23 || this.m_currentType == 47 || this.m_currentType == 40 || this.m_currentType == 30 || this.m_currentType == 54;
    }

    private boolean _isThreeD() {
        return this.m_currentType >= 0 && this.m_currentType <= 14;
    }

    private void _init() {
        if (this._isThreeD()) {
            if (!this.m_graph.getUI3DFloor().isFillTransparent()) {
                Color color;
                this.m_bgColor = color = this.m_graph.getUI3DFloor().getFillColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)color)) {
                        this.m_backgroundColor.setColorPalette(FontButton.getNewColorPalette(this.m_backgroundColor.getColorPalette(), color, this.m_bColorPaletteSet));
                    }
                    this.m_backgroundColor.setSelectedColor(color);
                } else {
                    this.m_backgroundColor.setSelectedColor(this.m_backgroundColor.getClosestColor(color));
                }
            } else {
                this.m_bgColor = c_Transparent;
            }
            if (!this.m_graph.getUI3DFloor().isBorderTransparent()) {
                this.m_bColor = this.m_graph.getUI3DFloor().getBorderColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor)) {
                        this.m_borderColor.setColorPalette(FontButton.getNewColorPalette(this.m_borderColor.getColorPalette(), this.m_bColor, this.m_bColorPaletteSet));
                    }
                    this.m_borderColor.setSelectedColor(this.m_bColor);
                } else {
                    this.m_borderColor.setSelectedColor(this.m_borderColor.getClosestColor(this.m_bColor));
                }
            } else {
                this.m_bColor = c_Transparent;
            }
            this.m_bdColor = this.m_bColor;
            this.m_horzGridLinesPanel.setVisible(false);
            this.m_vertGridLinesPanel.setVisible(false);
            this.m_tmpPanel.setVisible(false);
            this.m_dataLabelsPanel.setVisible(false);
        } else if (this._isPie()) {
            if (this.m_fontButton != null) {
                this.m_fontButton.setComponentFont(this.m_graph.getUISliceLabel().getFont());
                if (this.m_graph.getUISliceLabel().getUIGraphFont().getGraphFontStyle() >= 4) {
                    this.m_fontButton.setUnderlineStyle(true);
                }
                this.m_fontButton.setComponentForeground(this.m_graph.getUISliceLabel().getUIGraphFont().getGraphFontColor());
            }
            if (!this.m_graph.getUIPieFrame().isFillTransparent()) {
                Color color;
                this.m_bgColor = color = this.m_graph.getUIPieFrame().getFillColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)color)) {
                        this.m_backgroundColor.setColorPalette(FontButton.getNewColorPalette(this.m_backgroundColor.getColorPalette(), color, this.m_bColorPaletteSet));
                    }
                    this.m_backgroundColor.setSelectedColor(color);
                } else {
                    this.m_backgroundColor.setSelectedColor(this.m_backgroundColor.getClosestColor(color));
                }
            } else {
                this.m_bgColor = null;
            }
            if (!this.m_graph.getUIPieFrame().isBorderTransparent()) {
                this.m_bColor = this.m_graph.getUIPieFrame().getBorderColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor)) {
                        this.m_borderColor.setColorPalette(FontButton.getNewColorPalette(this.m_borderColor.getColorPalette(), this.m_bColor, this.m_bColorPaletteSet));
                    }
                    this.m_borderColor.setSelectedColor(this.m_bColor);
                } else {
                    this.m_borderColor.setSelectedColor(this.m_borderColor.getClosestColor(this.m_bColor));
                }
            } else {
                this.m_bColor = c_Transparent;
            }
            this.m_bdColor = this.m_bColor;
            this.m_horzGridLinesPanel.setVisible(false);
            this.m_vertGridLinesPanel.setVisible(false);
            this.m_tmpPanel.setVisible(false);
            int n = this.m_graph.getUISlice().getLabelPosition();
            if (n > 0) {
                this.m_dataLabelBox.setSelected(true);
            } else {
                this.m_dataLabelBox.setSelected(false);
            }
            this.m_labelPosition = this.m_graph.getUISlice().getLabelPosition();
            if (this.m_labelPosition == 0) {
                ++this.m_labelPosition;
            }
        } else {
            LineWidth lineWidth;
            LineWidth lineWidth2;
            BIColorChoice bIColorChoice;
            BIColorChoice bIColorChoice2;
            JCheckBox jCheckBox;
            Serializable serializable;
            if (this.m_fontButton != null) {
                this.m_fontButton.setComponentFont(this.m_graph.getUIMarkerText().getFont());
                if (this.m_graph.getUIMarkerText().getUIGraphFont().getGraphFontStyle() >= 4) {
                    this.m_fontButton.setUnderlineStyle(true);
                }
                this.m_fontButton.setComponentForeground(this.m_graph.getUIMarkerText().getUIGraphFont().getGraphFontColor());
            }
            if (!this.m_graph.getUIPlotArea().isFillTransparent()) {
                serializable = this.m_graph.getUIPlotArea().getFillColor();
                this.m_bgColor = serializable;
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)serializable)) {
                        this.m_backgroundColor.setColorPalette(FontButton.getNewColorPalette(this.m_backgroundColor.getColorPalette(), (Color)serializable, this.m_bColorPaletteSet));
                    }
                    this.m_backgroundColor.setSelectedColor((Color)serializable);
                } else {
                    this.m_backgroundColor.setSelectedColor(this.m_backgroundColor.getClosestColor((Color)serializable));
                }
            } else {
                this.m_bgColor = c_Transparent;
            }
            if (!this.m_graph.getUIPlotArea().isBorderTransparent()) {
                this.m_bColor = this.m_graph.getUIPlotArea().getBorderColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor)) {
                        this.m_borderColor.setColorPalette(FontButton.getNewColorPalette(this.m_borderColor.getColorPalette(), this.m_bColor, this.m_bColorPaletteSet));
                    }
                    this.m_borderColor.setSelectedColor(this.m_bColor);
                } else {
                    this.m_borderColor.setSelectedColor(this.m_borderColor.getClosestColor(this.m_bColor));
                }
            } else {
                this.m_bColor = c_Transparent;
            }
            this.m_bdColor = this.m_bColor;
            if (!this.m_graph.isHorizontal()) {
                serializable = this.m_horzBox;
                jCheckBox = this.m_vertBox;
                bIColorChoice2 = this.m_horzColor;
                bIColorChoice = this.m_vertColor;
                lineWidth2 = this.m_horzLineWidth;
                lineWidth = this.m_vertLineWidth;
            } else {
                serializable = this.m_vertBox;
                jCheckBox = this.m_horzBox;
                bIColorChoice2 = this.m_vertColor;
                bIColorChoice = this.m_horzColor;
                lineWidth2 = this.m_vertLineWidth;
                lineWidth = this.m_horzLineWidth;
            }
            ((AbstractButton)serializable).setSelected(this.m_graph.getUIY1MajorTick().isVisible());
            Color color = this.m_graph.getUIY1MajorTick().getLineColor();
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)bIColorChoice2.getColorPalette(), (Color)color)) {
                    bIColorChoice2.setColorPalette(FontButton.getNewColorPalette(bIColorChoice2.getColorPalette(), color, this.m_bColorPaletteSet));
                }
                bIColorChoice2.setSelectedColor(color);
            } else {
                bIColorChoice2.setSelectedColor(bIColorChoice2.getClosestColor(color));
            }
            this.m_yColor = color;
            lineWidth2.setCellColor(bIColorChoice2.getSelectedColor());
            lineWidth2.setLineWidth(this.m_graph.getUIY1MajorTick().getLineWidth());
            if (this.m_currentType >= 61 && this.m_currentType <= 64 || this.m_currentType >= 89 && this.m_currentType <= 92 || this.m_currentType >= 65 && this.m_currentType <= 66) {
                jCheckBox.setSelected(this.m_graph.getUIX1MajorTick().isVisible());
                color = this.m_graph.getUIX1MajorTick().getLineColor();
                lineWidth.setLineWidth(this.m_graph.getUIX1MajorTick().getLineWidth());
            } else {
                jCheckBox.setSelected(this.m_graph.getUIO1MajorTick().isVisible());
                color = this.m_graph.getUIO1MajorTick().getLineColor();
                lineWidth.setLineWidth(this.m_graph.getUIO1MajorTick().getLineWidth());
            }
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)bIColorChoice.getColorPalette(), (Color)color)) {
                    bIColorChoice.setColorPalette(FontButton.getNewColorPalette(bIColorChoice.getColorPalette(), color, this.m_bColorPaletteSet));
                }
                bIColorChoice.setSelectedColor(color);
            } else {
                bIColorChoice.setSelectedColor(bIColorChoice.getClosestColor(color));
            }
            this.m_oColor = color;
            lineWidth.setCellColor(bIColorChoice.getSelectedColor());
            this.m_dataLabelBox.setSelected(this.m_graph.getUIMarkerText().isVisible());
            if (this.m_currentType >= 67 && this.m_currentType <= 69 || this.m_currentType == 65 || this.m_currentType == 66) {
                lineWidth2.setVisible(false);
                lineWidth.setEnabled(jCheckBox.isSelected());
            } else {
                lineWidth2.setEnabled(((AbstractButton)serializable).isSelected());
                lineWidth.setEnabled(jCheckBox.isSelected());
            }
            if (this.m_graph.getGraphType() == 40 || this.m_graph.getGraphType() == 35) {
                this.m_backgroundLabel.setEnabled(false);
                this.m_backgroundColor.setEnabled(false);
                this.m_borderLabel.setEnabled(false);
                this.m_borderColor.setEnabled(false);
                this.m_horzBox.setEnabled(false);
                this.m_horzLineWidth.setEnabled(false);
                this.m_horzColor.setEnabled(false);
                this.m_vertBox.setEnabled(false);
                this.m_vertLineWidth.setEnabled(false);
                this.m_vertColor.setEnabled(false);
                this.m_vertLabel.setEnabled(false);
                this.m_horzLabel.setEnabled(false);
            }
        }
        if (this.m_tooltipType > 0) {
            this.m_dataTipsBox.setSelected(true);
        } else {
            this.m_dataTipsBox.setSelected(false);
        }
        this.m_oldBackgroundColor = this.m_backgroundColor.getSelectedColor();
        this.m_oldHorzColor = this.m_horzColor.getSelectedColor();
        this.m_oldHorzLineWidth = this.m_horzLineWidth.getLineWidth();
        this.m_oldVertColor = this.m_vertColor.getSelectedColor();
        this.m_oldVertLineWidth = this.m_vertLineWidth.getLineWidth();
        this.m_bBorderColorChanged = false;
        this.m_bBackgroundChanged = false;
        this.m_bHorzColorChanged = false;
        this.m_bVertColorChanged = false;
        this.m_bHorzWidthChanged = false;
        this.m_bVertWidthChanged = false;
        this.m_bHorzVisibleChanged = false;
        this.m_bVertVisibleChanged = false;
        if (!this.m_dataLabelBox.isSelected()) {
            if (this.m_dataLabelOption != null) {
                this.m_dataLabelOption.setEnabled(false);
            } else {
                this.m_fontButton.setEnabled(false);
            }
        }
        if (!this.m_dataTipsBox.isSelected()) {
            this.m_dataTipsOption.setEnabled(false);
        }
        if (!this.m_vertBox.isSelected()) {
            this.m_vertLineWidth.setEnabled(false);
            this.m_vertLabel.setEnabled(false);
            this.m_vertColor.setEnabled(false);
        }
        if (!this.m_horzBox.isSelected()) {
            this.m_horzLineWidth.setEnabled(false);
            this.m_horzLabel.setEnabled(false);
            this.m_horzColor.setEnabled(false);
        }
    }

    private void setDataLabelOptions() {
        this.m_dataLabelsPanel.removeAll();
        this.m_dataLabelOption = null;
        this.m_fontButton = null;
        if (!this._isDataLabelInTheCenterSupported()) {
            String string = this.rBundle.getString("Label Font");
            this.m_fontButton = new FontButton(StringUtils.stripMnemonic((String)string));
            this.m_fontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
            if (this.m_bColorPaletteSet) {
                this.m_fontButton.setColorPalette(this.m_colorPalette);
            }
            this.m_fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = this.rBundle.getString("Data Label Font For FontButton");
            this.m_fontButton.setDialogTitle(string);
            this.m_fontButton.setPaneLocale(this.m_graph.getLocale());
            int n = 7;
            int n2 = 1;
            this.m_fontButton.setStyleButtonMask(n);
            this.m_fontButton.setAlignmentButtonMask(0);
            this.m_fontButton.setColorComponentMask(n2);
            this.m_dataLabelsPanel.add(this.m_dataLabelBox);
            this.m_dataLabelsPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            this.m_dataLabelsPanel.add(this.m_fontButton);
        } else {
            String string = this.rBundle.getString("Options I");
            this.m_dataLabelOption = new JButton(StringUtils.stripMnemonic((String)string));
            this.m_dataLabelOption.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_dataLabelsPanel.add(this.m_dataLabelBox);
            this.m_dataLabelsPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            this.m_dataLabelsPanel.add(this.m_dataLabelOption);
        }
        if (this.m_dataLabelOption != null) {
            this.m_dataLabelOption.addActionListener(this);
            this.m_dataLabelOption.setForeground(this.m_label.getForeground());
        } else {
            this.m_fontButton.addPropertyChangeListener(this);
            this.m_fontButton.setForeground(this.m_label.getForeground());
        }
    }

    protected void sizeComponents() {
        int n;
        JCheckBox jCheckBox = new JCheckBox();
        int n2 = jCheckBox.getPreferredSize().width;
        this.m_backgroundColorPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 35));
        this.m_backgroundColorPanel.setMinimumSize(this.m_backgroundColorPanel.getPreferredSize());
        this.m_backgroundColorPanel.setMaximumSize(this.m_backgroundColorPanel.getPreferredSize());
        this.m_borderColorPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 35));
        this.m_borderColorPanel.setMinimumSize(this.m_borderColorPanel.getPreferredSize());
        this.m_borderColorPanel.setMaximumSize(this.m_borderColorPanel.getPreferredSize());
        this.m_horzGridLinesPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 32));
        this.m_horzGridLinesPanel.setMinimumSize(this.m_horzGridLinesPanel.getPreferredSize());
        this.m_horzGridLinesPanel.setMaximumSize(this.m_horzGridLinesPanel.getPreferredSize());
        this.m_vertGridLinesPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 32));
        this.m_vertGridLinesPanel.setMinimumSize(this.m_vertGridLinesPanel.getPreferredSize());
        this.m_vertGridLinesPanel.setMaximumSize(this.m_vertGridLinesPanel.getPreferredSize());
        int n3 = this.getToolkit().getFontMetrics(this.m_horzBox.getFont()).stringWidth(this.m_horzBox.getText());
        int n4 = this.getToolkit().getFontMetrics(this.m_vertBox.getFont()).stringWidth(this.m_vertBox.getText());
        int n5 = this.getToolkit().getFontMetrics(this.m_backgroundLabel.getFont()).stringWidth(this.m_backgroundLabel.getText());
        int n6 = n3;
        if (n4 > n6) {
            n6 = n4;
        }
        if (n5 > n6) {
            n6 = n5;
        }
        this.m_vertBox.setPreferredSize(new Dimension(n6 + n2 + 4, this.m_vertBox.getPreferredSize().height));
        this.m_vertBox.setMinimumSize(this.m_vertBox.getPreferredSize());
        this.m_vertBox.setMaximumSize(this.m_vertBox.getPreferredSize());
        this.m_horzBox.setPreferredSize(this.m_vertBox.getPreferredSize());
        this.m_horzBox.setMinimumSize(this.m_vertBox.getPreferredSize());
        this.m_horzBox.setMaximumSize(this.m_vertBox.getPreferredSize());
        this.m_backgroundLabel.setPreferredSize(this.m_vertBox.getPreferredSize());
        this.m_backgroundLabel.setMinimumSize(this.m_vertBox.getPreferredSize());
        this.m_backgroundLabel.setMaximumSize(this.m_vertBox.getPreferredSize());
        this.m_borderLabel.setPreferredSize(this.m_vertBox.getPreferredSize());
        this.m_borderLabel.setMinimumSize(this.m_vertBox.getPreferredSize());
        this.m_borderLabel.setMaximumSize(this.m_vertBox.getPreferredSize());
        int n7 = this.getToolkit().getFontMetrics(this.m_dataLabelBox.getFont()).stringWidth(this.m_dataLabelBox.getText());
        int n8 = this.getToolkit().getFontMetrics(this.m_dataTipsBox.getFont()).stringWidth(this.m_dataTipsBox.getText());
        int n9 = this.getToolkit().getFontMetrics(this.m_horzLabel.getFont()).stringWidth(this.m_horzLabel.getText());
        int n10 = this.m_horzLineWidth.getPreferredSize().width + n6;
        int n11 = n7;
        if (n8 > n11) {
            n11 = n8;
        }
        if (n11 < n10) {
            n11 = n10;
        }
        int n12 = n11 + n2 + 4;
        if (!this._isDataLabelInTheCenterSupported()) {
            FontButton fontButton = new FontButton(this.rBundle.getString("Label Font"));
            fontButton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
            JButton jButton = new JButton(this.rBundle.getString("Options I"));
            n = n12 - (fontButton.getPreferredSize().width - jButton.getPreferredSize().width);
        } else {
            n = n12;
        }
        this.m_dataLabelBox.setPreferredSize(new Dimension(n, this.m_dataLabelBox.getPreferredSize().height));
        this.m_dataLabelBox.setMinimumSize(this.m_dataLabelBox.getPreferredSize());
        this.m_dataLabelBox.setMaximumSize(this.m_dataLabelBox.getPreferredSize());
        this.m_dataTipsBox.setPreferredSize(new Dimension(n12, this.m_dataLabelBox.getPreferredSize().height));
        this.m_dataTipsBox.setMinimumSize(this.m_dataTipsBox.getPreferredSize());
        this.m_dataTipsBox.setMaximumSize(this.m_dataTipsBox.getPreferredSize());
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
    }

    public void apply() {
        if (this.m_dataLabel != null) {
            this.m_dataLabel.apply();
        }
        if (this._isThreeD()) {
            boolean bl = this.m_graph.getUI3DFloor().isSharePanelProperties();
            this.m_graph.getUI3DFloor().setSharePanelProperties(true);
            if (this.m_bBackgroundChanged) {
                if (this.m_bgColor != c_Transparent) {
                    this.m_graph.getUI3DFloor().setFillColor(this.m_backgroundColor.getSelectedColor());
                    this.m_graph.getUI3DFloor().setFillTransparent(false);
                } else {
                    this.m_graph.getUI3DFloor().setFillTransparent(true);
                }
            }
            if (this.m_bBorderColorChanged) {
                if (this.m_bColor != c_Transparent) {
                    if (!this.m_graph.getUI3DFloor().getBorderColor().equals(this.m_bColor)) {
                        this.m_graph.getUI3DFloor().setBorderColor(this.m_bColor);
                    }
                    this.m_graph.getUI3DFloor().setBorderTransparent(false);
                } else {
                    this.m_graph.getUI3DFloor().setBorderTransparent(true);
                }
            }
            this.m_graph.getUI3DFloor().setSharePanelProperties(bl);
        } else if (this._isPie()) {
            if (this.m_fontButton != null) {
                if (this.m_bDataLabelFontNameChanged) {
                    this.m_graph.getUISliceLabel().getUIGraphFont().setGraphFontTypeface(this.m_fontButton.getComponentFont().getFontName());
                }
                if (this.m_bDataLabelFontSizeChanged) {
                    this.m_graph.getUISliceLabel().getUIGraphFont().setGraphFontSize(this.m_fontButton.getComponentFont().getSize());
                }
                if (this.m_bDataLabelFontBoldChanged) {
                    this.m_graph.getUISliceLabel().getUIGraphFont().setFontBold(this.m_fontButton.getComponentFont().isBold());
                }
                if (this.m_bDataLabelFontItalicChanged) {
                    this.m_graph.getUISliceLabel().getUIGraphFont().setFontItalic(this.m_fontButton.getComponentFont().isItalic());
                }
                if (this.m_bDataLabelFontUnderlineChanged) {
                    this.m_graph.getUISliceLabel().getUIGraphFont().setUnderline(this.m_fontButton.isUnderlineStyle());
                }
                if (this.m_bDataLabelFontColorChanged) {
                    this.m_graph.getUISliceLabel().getUIGraphFont().setGraphFontColor(this.m_fontButton.getComponentForeground());
                }
            }
            if (this.m_bBackgroundChanged) {
                if (this.m_bgColor != c_Transparent) {
                    this.m_graph.getUIPieFrame().setFillColor(this.m_backgroundColor.getSelectedColor());
                    this.m_graph.getUIPieFrame().setFillTransparent(false);
                } else {
                    this.m_graph.getUIPieFrame().setFillTransparent(true);
                }
            }
            if (this.m_bBorderColorChanged) {
                if (this.m_bColor != c_Transparent) {
                    if (!this.m_graph.getUIPieFrame().getBorderColor().equals(this.m_bColor)) {
                        this.m_graph.getUIPieFrame().setBorderColor(this.m_bColor);
                    }
                    this.m_graph.getUIPieFrame().setBorderTransparent(false);
                } else {
                    this.m_graph.getUIPieFrame().setBorderTransparent(true);
                }
            }
            if (this.m_dataLabelBox.isSelected()) {
                this.m_graph.getUISlice().setLabelPosition(this.m_labelPosition);
            } else {
                this.m_graph.getUISlice().setLabelPosition(0);
            }
        } else {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            LineWidth lineWidth;
            LineWidth lineWidth2;
            BIColorChoice bIColorChoice;
            BIColorChoice bIColorChoice2;
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            if (this.m_fontButton != null) {
                if (this.m_bDataLabelFontNameChanged) {
                    this.m_graph.getUIMarkerText().getUIGraphFont().setGraphFontTypeface(this.m_fontButton.getComponentFont().getFontName());
                }
                if (this.m_bDataLabelFontSizeChanged) {
                    this.m_graph.getUIMarkerText().getUIGraphFont().setGraphFontSize(this.m_fontButton.getComponentFont().getSize());
                }
                if (this.m_bDataLabelFontBoldChanged) {
                    this.m_graph.getUIMarkerText().getUIGraphFont().setFontBold(this.m_fontButton.getComponentFont().isBold());
                }
                if (this.m_bDataLabelFontItalicChanged) {
                    this.m_graph.getUIMarkerText().getUIGraphFont().setFontItalic(this.m_fontButton.getComponentFont().isItalic());
                }
                if (this.m_bDataLabelFontUnderlineChanged) {
                    this.m_graph.getUIMarkerText().getUIGraphFont().setUnderline(this.m_fontButton.isUnderlineStyle());
                }
                if (this.m_bDataLabelFontColorChanged) {
                    this.m_graph.getUIMarkerText().getUIGraphFont().setGraphFontColor(this.m_fontButton.getComponentForeground());
                }
            }
            if (this.m_bBackgroundChanged) {
                if (this.m_bgColor != c_Transparent) {
                    this.m_graph.getUIPlotArea().setFillColor(this.m_backgroundColor.getSelectedColor());
                    this.m_graph.getUIPlotArea().setFillTransparent(false);
                } else {
                    this.m_graph.getUIPlotArea().setFillTransparent(true);
                }
            }
            if (this.m_bBorderColorChanged) {
                if (this.m_bColor != c_Transparent) {
                    if (!this.m_graph.getUIPlotArea().getBorderColor().equals(this.m_bColor)) {
                        this.m_graph.getUIPlotArea().setBorderColor(this.m_bColor);
                    }
                    this.m_graph.getUIPlotArea().setBorderTransparent(false);
                } else {
                    this.m_graph.getUIPlotArea().setBorderTransparent(true);
                }
            }
            if (!this.m_graph.isHorizontal()) {
                jCheckBox2 = this.m_horzBox;
                jCheckBox = this.m_vertBox;
                bIColorChoice2 = this.m_horzColor;
                bIColorChoice = this.m_vertColor;
                lineWidth2 = this.m_horzLineWidth;
                lineWidth = this.m_vertLineWidth;
                bl6 = this.m_bVertVisibleChanged;
                bl5 = this.m_bHorzVisibleChanged;
                bl4 = this.m_bVertColorChanged;
                bl3 = this.m_bHorzColorChanged;
                bl2 = this.m_bVertWidthChanged;
                bl = this.m_bHorzWidthChanged;
            } else {
                jCheckBox2 = this.m_vertBox;
                jCheckBox = this.m_horzBox;
                bIColorChoice2 = this.m_vertColor;
                bIColorChoice = this.m_horzColor;
                lineWidth2 = this.m_vertLineWidth;
                lineWidth = this.m_horzLineWidth;
                bl6 = this.m_bHorzVisibleChanged;
                bl5 = this.m_bVertVisibleChanged;
                bl4 = this.m_bHorzColorChanged;
                bl3 = this.m_bVertColorChanged;
                bl2 = this.m_bHorzWidthChanged;
                bl = this.m_bVertWidthChanged;
            }
            if (bl5) {
                this.m_graph.getUIY1MajorTick().setVisible(jCheckBox2.isSelected());
            }
            if (bl) {
                this.m_graph.getUIY1MajorTick().setLineWidth(lineWidth2.getLineWidth());
            }
            if (bl3) {
                this.m_graph.getUIY1MajorTick().setLineColor(bIColorChoice2.getSelectedColor());
            }
            if (bl5) {
                this.m_graph.getUIY2MajorTick().setVisible(jCheckBox2.isSelected());
            }
            if (bl) {
                this.m_graph.getUIY2MajorTick().setLineWidth(lineWidth2.getLineWidth());
            }
            if (bl3) {
                this.m_graph.getUIY2MajorTick().setLineColor(bIColorChoice2.getSelectedColor());
            }
            if (bl6) {
                this.m_graph.getUIX1MajorTick().setVisible(jCheckBox.isSelected());
            }
            if (bl2) {
                this.m_graph.getUIX1MajorTick().setLineWidth(lineWidth.getLineWidth());
            }
            if (bl4) {
                this.m_graph.getUIX1MajorTick().setLineColor(bIColorChoice.getSelectedColor());
            }
            if (bl6) {
                this.m_graph.getUIO1MajorTick().setVisible(jCheckBox.isSelected());
            }
            if (bl2) {
                this.m_graph.getUIO1MajorTick().setLineWidth(lineWidth.getLineWidth());
            }
            if (bl4) {
                this.m_graph.getUIO1MajorTick().setLineColor(bIColorChoice.getSelectedColor());
            }
            if (this.m_bDataLabelVisibleChanged) {
                this.m_graph.getUIMarkerText().setVisible(this.m_dataLabelBox.isSelected());
            }
        }
        if (this.m_bDataTipVisibleChanged || this.m_bDataTipTypeChanged) {
            if (this.m_dataTipsBox.isSelected()) {
                if (this.m_dataTip != null) {
                    this.m_dataTip.apply();
                } else if (this.m_tooltipType == 0) {
                    this.m_tooltipType |= 1;
                }
                this.m_graph.setMarkerTooltipType(this.m_tooltipType);
            } else {
                this.m_graph.setMarkerTooltipType(0);
            }
        }
        this.m_series.apply();
        if (this._isDataMarkerSupported()) {
            this.m_graph.setMarkerDisplayed(this.m_graph.isMarkerDisplayed());
        }
    }

    public Dimension getPreferredSize() {
        int n = Integer.parseInt(this.rBundle.getString("PlotAreaPanelWidth"));
        int n2 = Integer.parseInt(this.rBundle.getString("PlotAreaPanelHeight"));
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        if (this.m_fontButton != null) {
            this.m_fontButton.setHelpProvider(helpProvider);
        }
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_dataLabelOption) {
            if (this.m_dataLabel == null) {
                this.m_dataLabel = new DataLabel();
            }
            this.m_dataLabel.setHelpProvider(this.getHelpProvider());
            PanelDialog panelDialog = this.createPanelDialog(this.rBundle.getString("Data Label Options"), true, this.m_dataLabel, this.m_bHelpEnabled);
            panelDialog.show();
            panelDialog.dispose();
            panelDialog = null;
        } else if (actionEvent.getSource() == this.m_dataTipsOption) {
            if (this.m_dataTip == null) {
                this.m_dataTip = new DataTip();
            }
            this.m_dataTip.setHelpProvider(this.getHelpProvider());
            PanelDialog panelDialog = this.createPanelDialog(this.rBundle.getString("Data Tip Options"), true, this.m_dataTip, this.m_bHelpEnabled);
            if (this.m_tooltipType == 0) {
                this.m_dataTip.value.setSelected(true);
                this.m_tooltipType |= 1;
            }
            panelDialog.show();
            panelDialog.dispose();
            panelDialog = null;
        } else if (actionEvent.getSource() == this.m_fontButton) {
            this.m_fontButton.setHelpProvider(this.getHelpProvider());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.m_horzBox) {
                this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_VISIBLE, false, true);
                if (this.m_currentType == 65 || this.m_currentType == 66 || !this.m_graph.isHorizontal() && this.m_currentType >= 67 && this.m_currentType <= 69) {
                    this.m_horzLineWidth.setEnabled(false);
                } else {
                    this.m_horzLineWidth.setEnabled(true);
                }
                this.m_horzLabel.setEnabled(true);
                this.m_horzColor.setEnabled(true);
                this.m_bHorzVisibleChanged = true;
            } else if (itemEvent.getSource() == this.m_vertBox) {
                this.firePropertyChange(PROPERTY_VERTICAL_GRID_VISIBLE, false, true);
                this.m_vertLineWidth.setEnabled(true);
                this.m_vertLabel.setEnabled(true);
                this.m_vertColor.setEnabled(true);
                this.m_bVertVisibleChanged = true;
            } else if (itemEvent.getSource() == this.m_horzLineWidth) {
                int n = this.m_horzLineWidth.getLineWidth();
                this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_LINE_WIDTH, this.m_oldHorzLineWidth, n);
                this.m_oldHorzLineWidth = n;
                this.m_bHorzWidthChanged = true;
            } else if (itemEvent.getSource() == this.m_vertLineWidth) {
                int n = this.m_vertLineWidth.getLineWidth();
                this.firePropertyChange(PROPERTY_VERTICAL_GRID_LINE_WIDTH, this.m_oldVertLineWidth, n);
                this.m_oldVertLineWidth = n;
                this.m_bVertWidthChanged = true;
            } else if (itemEvent.getSource() == this.m_dataLabelBox) {
                this.firePropertyChange(PROPERTY_DATA_LABEL_VISIBLE, false, true);
                if (this.m_dataLabelOption != null) {
                    this.m_dataLabelOption.setEnabled(true);
                    this.m_bDataLabelVisibleChanged = true;
                } else {
                    this.m_fontButton.setEnabled(true);
                    this.m_bDataLabelVisibleChanged = true;
                }
            } else if (itemEvent.getSource() == this.m_dataTipsBox) {
                this.firePropertyChange(PROPERTY_DATA_TIPS_VISIBLE, false, true);
                this.m_dataTipsOption.setEnabled(true);
                this.m_bDataTipVisibleChanged = true;
            }
        } else if (itemEvent.getStateChange() == 2) {
            if (itemEvent.getSource() == this.m_horzBox) {
                this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_VISIBLE, true, false);
                this.m_horzLineWidth.setEnabled(false);
                this.m_horzLabel.setEnabled(false);
                this.m_horzColor.setEnabled(false);
                this.m_bHorzVisibleChanged = true;
            } else if (itemEvent.getSource() == this.m_vertBox) {
                this.firePropertyChange(PROPERTY_VERTICAL_GRID_VISIBLE, true, false);
                this.m_vertLineWidth.setEnabled(false);
                this.m_vertLabel.setEnabled(false);
                this.m_vertColor.setEnabled(false);
                this.m_bVertVisibleChanged = true;
            } else if (itemEvent.getSource() == this.m_dataLabelBox) {
                this.firePropertyChange(PROPERTY_DATA_LABEL_VISIBLE, true, false);
                if (this.m_dataLabelOption != null) {
                    this.m_dataLabelOption.setEnabled(false);
                    this.m_bDataLabelVisibleChanged = true;
                } else {
                    this.m_fontButton.setEnabled(false);
                    this.m_bDataLabelVisibleChanged = true;
                }
            } else if (itemEvent.getSource() == this.m_dataTipsBox) {
                this.firePropertyChange(PROPERTY_DATA_TIPS_VISIBLE, true, false);
                this.m_dataTipsOption.setEnabled(false);
                this.m_bDataTipVisibleChanged = true;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if (propertyChangeEvent.getPropertyName().equals("selectedColor")) {
            if (propertyChangeEvent.getSource() == this.m_backgroundColor) {
                object = this.m_backgroundColor.getSelectedColor();
                this.firePropertyChange(PROPERTY_BACKGROUND_COLOR, this.m_oldBackgroundColor, object);
                this.m_oldBackgroundColor = object;
                this.m_bgColor = object;
                this.m_bBackgroundChanged = true;
            }
            if (propertyChangeEvent.getSource() == this.m_borderColor) {
                object = this.m_borderColor.getSelectedColor();
                this.firePropertyChange(PROPERTY_BORDER_COLOR, this.m_bColor, object);
                this.m_bColor = object;
                this.m_bBorderColorChanged = true;
            } else if (propertyChangeEvent.getSource() == this.m_horzColor) {
                object = this.m_horzColor.getSelectedColor();
                this.m_horzLineWidth.setCellColor((Color)object);
                this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_COLOR, this.m_oldHorzColor, object);
                this.m_oldHorzColor = object;
                this.m_bHorzColorChanged = true;
            } else if (propertyChangeEvent.getSource() == this.m_vertColor) {
                object = this.m_vertColor.getSelectedColor();
                this.m_vertLineWidth.setCellColor((Color)object);
                this.firePropertyChange(PROPERTY_VERTICAL_GRID_COLOR, this.m_oldVertColor, object);
                this.m_oldVertColor = object;
                this.m_bVertColorChanged = true;
            }
        }
        if (this.m_fontButton != null) {
            Object object2;
            boolean bl;
            object = propertyChangeEvent.getPropertyName();
            if (object == "fontDialogCancelled" && !(bl = ((Boolean)(object2 = (Boolean)propertyChangeEvent.getNewValue())).booleanValue())) {
                if (this.m_bMainFontNameChange) {
                    this.firePropertyChange("fontName", this.m_mainOldFontName, this.m_mainNewFontName);
                    this.m_bMainFontNameChange = false;
                    this.m_bDataLabelFontNameChanged = true;
                }
                if (this.m_bMainFontStyleChange) {
                    this.firePropertyChange("fontStyle", this.m_mainOldFontStyle, this.m_mainNewFontStyle);
                    this.m_bMainFontStyleChange = false;
                    int n = this.m_mainOldFontStyle ^ this.m_mainNewFontStyle;
                    if ((n & 1) != 0) {
                        this.m_bDataLabelFontBoldChanged = true;
                    }
                    if ((n & 2) != 0) {
                        this.m_bDataLabelFontItalicChanged = true;
                    }
                    if ((n & 4) != 0) {
                        this.m_bDataLabelFontUnderlineChanged = true;
                    }
                }
                if (this.m_bMainFontSizeChange) {
                    this.firePropertyChange("fontSize", this.m_mainOldFontSize, this.m_mainNewFontSize);
                    this.m_bMainFontSizeChange = false;
                    this.m_bDataLabelFontSizeChanged = true;
                }
                if (this.m_bMainFontColorChange) {
                    this.firePropertyChange("fontColor", this.m_mainOldFontColor, this.m_mainNewFontColor);
                    this.m_bMainFontColorChange = false;
                    this.m_bDataLabelFontColorChanged = true;
                }
            }
            if (object == "fontColor") {
                object2 = (Color)propertyChangeEvent.getOldValue();
                if (!this.m_bMainFontColorChange) {
                    this.m_mainOldFontColor = object2;
                }
                this.m_mainNewFontColor = (Color)propertyChangeEvent.getNewValue();
                if (object2 != this.m_mainNewFontColor) {
                    this.m_bMainFontColorChange = true;
                }
            }
            if (object == "fontName") {
                object2 = (String)propertyChangeEvent.getOldValue();
                if (!this.m_bMainFontNameChange) {
                    this.m_mainOldFontName = object2;
                }
                this.m_mainNewFontName = (String)propertyChangeEvent.getNewValue();
                if (object2 != this.m_mainNewFontName) {
                    this.m_bMainFontNameChange = true;
                }
            }
            if (object == "fontStyle") {
                object2 = (Integer)propertyChangeEvent.getOldValue();
                if (!this.m_bMainFontStyleChange) {
                    this.m_mainOldFontStyle = (Integer)object2;
                }
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                this.m_mainNewFontStyle = n;
                if ((Integer)object2 != this.m_mainNewFontStyle) {
                    this.m_bMainFontStyleChange = true;
                }
            }
            if (object == "fontSize") {
                object2 = (Integer)propertyChangeEvent.getOldValue();
                if (!this.m_bMainFontSizeChange) {
                    this.m_mainOldFontSize = (Integer)object2;
                }
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                this.m_mainNewFontSize = n;
                if ((Integer)object2 != this.m_mainNewFontSize) {
                    this.m_bMainFontSizeChange = true;
                }
            }
        }
    }

    public String getHelpContextID() {
        String string;
        switch (this.m_currentType) {
            case 43: 
            case 45: {
                if (this.m_graph.isLineDataLineDisplayed()) {
                    string = "F";
                    break;
                }
                string = "C";
                break;
            }
            case 61: 
            case 65: 
            case 67: 
            case 89: {
                string = "B";
                break;
            }
            case 62: 
            case 91: {
                string = "C";
                break;
            }
            case 41: 
            case 42: 
            case 47: {
                string = "D";
                break;
            }
            case 17: {
                string = "E";
                break;
            }
            case 44: {
                string = "F";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: {
                string = "G";
                break;
            }
            case 102: {
                string = "H";
            }
            default: {
                string = "A";
            }
        }
        return String.valueOf(this.getClass().getName()) + "_" + string;
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    private boolean _isDataMarkerSupported() {
        return this._isCombinationType() || this.m_graph.getGraphType() == 102 || this.m_graph.getGraphType() >= 41 && this.m_graph.getGraphType() <= 54 && !this.m_graph.getGraphTypeConverter().isPointType() || this.m_graph.getGraphType() >= 67 && this.m_graph.getGraphType() <= 69;
    }

    private PanelDialog createPanelDialog(String string, boolean bl, JPanel jPanel, boolean bl2) {
        PanelDialog panelDialog = null;
        Container container = this;
        while (container != null) {
            if (container instanceof Dialog) {
                panelDialog = new PanelDialog((Dialog)container, string, bl, jPanel, bl2);
                break;
            }
            if (container instanceof Frame) {
                panelDialog = new PanelDialog((Frame)container, string, bl, jPanel, bl2);
                break;
            }
            container = SwingUtilities.getWindowAncestor(container);
        }
        if (container == null) {
            panelDialog = new PanelDialog(null, string, bl, jPanel, bl2);
        }
        return panelDialog;
    }

    static /* synthetic */ int access$6000671(PlotArea plotArea) {
        return plotArea.m_initialHeight;
    }

    static /* synthetic */ int access$6000571(PlotArea plotArea) {
        return plotArea.m_initialWidth;
    }

    class PanelDialog
    extends JDialog
    implements ActionListener,
    HelpContext {
        private boolean m_bHelpEnabled = true;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        protected JPanel m_panel;
        protected String m_strHelpContextID;
        private final Border _sBorder = new EmptyBorder(6, 6, 8, 5);
        private final Border _sBorderButtons = new EmptyBorder(8, 10, 0, 10);
        private boolean value;
        private boolean percent;
        private boolean series;
        private boolean group;
        private int dataLabelPosition;
        private Color dataLabelcolor;
        private boolean dataLabelUnderLine;
        private Font dataLabelFont;
        private int dataLabelTextType;
        private boolean dataLabelPositionChanged;
        private boolean dataLabelTextTypeChanged;
        private boolean dataLabelColorChanged;
        private boolean dataLabelFontNameChanged;
        private boolean dataLabelFontSizeChanged;
        private boolean dataLabelFontBoldChanged;
        private boolean dataLabelFontItalicChanged;
        private boolean dataLabelFontUnderlineChanged;
        private boolean dataTipTypeChanged;

        public PanelDialog(Frame frame, String string, boolean bl, JPanel jPanel, boolean bl2) {
            super(frame);
            this._initDialog(string, bl, jPanel, bl2);
        }

        public PanelDialog(Dialog dialog, String string, boolean bl, JPanel jPanel, boolean bl2) {
            super(dialog);
            this._initDialog(string, bl, jPanel, bl2);
        }

        private void _initDialog(String string, boolean bl, JPanel jPanel, boolean bl2) {
            this.m_bHelpEnabled = bl2;
            this.setTitle(string);
            this.setModal(bl);
            try {
                this.m_panel = jPanel;
                if (jPanel instanceof DataTip) {
                    this.value = ((DataTip)jPanel).value.isSelected();
                    this.percent = ((DataTip)jPanel).percent.isSelected();
                    this.series = ((DataTip)jPanel).item.isSelected();
                    this.group = ((DataTip)jPanel).group.isSelected();
                    this.dataTipTypeChanged = PlotArea.this.m_bDataTipTypeChanged;
                }
                if (jPanel instanceof DataLabel) {
                    this.dataLabelPosition = ((DataLabel)jPanel).position.getSelectedIndex();
                    this.dataLabelcolor = ((DataLabel)jPanel).fontButton.getComponentForeground();
                    this.dataLabelUnderLine = ((DataLabel)jPanel).fontButton.isUnderlineStyle();
                    this.dataLabelFont = new Font(((DataLabel)jPanel).fontButton.getComponentFont().getName(), ((DataLabel)jPanel).fontButton.getComponentFont().getStyle(), ((DataLabel)jPanel).fontButton.getComponentFont().getSize());
                    this.dataLabelTextType = ((DataLabel)jPanel).textType;
                    this.dataLabelFontNameChanged = PlotArea.this.m_bDataLabelFontNameChanged;
                    this.dataLabelFontBoldChanged = PlotArea.this.m_bDataLabelFontBoldChanged;
                    this.dataLabelFontItalicChanged = PlotArea.this.m_bDataLabelFontItalicChanged;
                    this.dataLabelFontUnderlineChanged = PlotArea.this.m_bDataLabelFontUnderlineChanged;
                    this.dataLabelFontSizeChanged = PlotArea.this.m_bDataLabelFontSizeChanged;
                    this.dataLabelColorChanged = PlotArea.this.m_bDataLabelFontColorChanged;
                    this.dataLabelPositionChanged = PlotArea.this.m_bDataLabelPositionChanged;
                    this.dataLabelTextTypeChanged = PlotArea.this.m_bDataLabelTextTypeChanged;
                }
                this.init();
                this.pack();
                PlotArea.this.m_initialWidth = this.getWidth();
                PlotArea.this.m_initialHeight = this.getHeight();
                if (jPanel instanceof DataTip) {
                    if (PlotArea.this.m_dataLabelOption != null) {
                        this.setLocationRelativeTo(PlotArea.this.m_dataLabelOption);
                    } else {
                        this.setLocationRelativeTo(PlotArea.this.m_fontButton);
                    }
                } else {
                    this.setLocationRelativeTo(PlotArea.this.m_dataTipsOption);
                }
                this.addWindowListener(new WindowAdapter(this){
                    final /* synthetic */ PanelDialog this$0;

                    public void windowClosing(WindowEvent windowEvent) {
                        this.this$0.resetValues();
                    }
                    {
                        this.this$0 = panelDialog;
                    }
                });
                jPanel = null;
            }
            catch (Exception exception) {
                if (PlotArea.this.m_eh != null) {
                    PlotArea.this.m_eh.log("Error initiating panel dialog", this.getClass().getName(), "PanelDialog");
                }
                exception.printStackTrace();
            }
        }

        public String getHelpContextID() {
            if (this.m_panel instanceof DataLabel) {
                if (PlotArea.this._isPie()) {
                    return "oracle.dss.graph.gui.PlotArea.DataLabelOptionDialog_A";
                }
                return "oracle.dss.graph.gui.PlotArea.DataLabelOptionDialog_B";
            }
            if (this.m_panel instanceof DataTip) {
                return "oracle.dss.graph.gui.PlotArea.DataTipOptionDialog";
            }
            return this.getClass().getName();
        }

        public void setHelpContextID(String string) {
            this.m_strHelpContextID = string;
        }

        public void setHelpEnabled(boolean bl) {
            this.m_bHelpEnabled = bl;
        }

        public boolean isHelpEnabled() {
            return this.m_bHelpEnabled;
        }

        private void init() throws Exception {
            Object object;
            PlotArea.this.m_initialWidth = -1;
            PlotArea.this.m_initialHeight = -1;
            JComponent jComponent = (JComponent)this.getContentPane();
            jComponent.setLayout(new BoxLayout(jComponent, 1));
            jComponent.setBorder(this._sBorder);
            if (UIManager.getLookAndFeel() instanceof BrowserLookAndFeel) {
                jComponent.setBackground(UIManager.getColor("MenuBar.background"));
            } else if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                jComponent.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            GrayPane grayPane = new GrayPane((Component)this.m_panel);
            jComponent.add((Component)grayPane);
            DialogButtonBar dialogButtonBar = new DialogButtonBar();
            dialogButtonBar.setBorder(this._sBorderButtons);
            if (this.m_bHelpEnabled) {
                object = PlotArea.this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)object));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)object));
                dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            object = new JPanel();
            this.okButton = new JButton(PlotArea.this.rBundle.getString("OK"));
            dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            this.cancelButton = new JButton(PlotArea.this.rBundle.getString("Cancel"));
            dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.addActionListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            this.getContentPane().add((Component)dialogButtonBar);
            this.setResizable(true);
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ PanelDialog this$0;

                public void componentResized(ComponentEvent componentEvent) {
                    int n;
                    int n2;
                    int n3 = n2 = this.this$0.getWidth();
                    int n4 = n = this.this$0.getHeight();
                    if (PlotArea.access$6000571(this.this$0.PlotArea.this) != -1) {
                        n3 = Math.max(PlotArea.access$6000571(this.this$0.PlotArea.this), n3);
                    }
                    if (PlotArea.access$6000671(this.this$0.PlotArea.this) != -1) {
                        n4 = Math.max(PlotArea.access$6000671(this.this$0.PlotArea.this), n4);
                    }
                    if (n2 != n3 || n != n4) {
                        this.this$0.setSize(n3, n4);
                    }
                    this.this$0.validate();
                }
                {
                    this.this$0 = panelDialog;
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.getParent().repaint();
                this.resetValues();
            } else if (actionEvent.getSource() == this.okButton) {
                this.setVisible(false);
                if (this.m_panel instanceof DataTip) {
                    PlotArea.this.m_dataTip.apply();
                }
            } else if (actionEvent.getSource() == this.helpButton) {
                try {
                    if (PlotArea.this.getHelpProvider() != null) {
                        PlotArea.this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        public void resetValues() {
            if (this.m_panel instanceof DataTip) {
                ((DataTip)this.m_panel).value.setSelected(this.value);
                ((DataTip)this.m_panel).percent.setSelected(this.percent);
                ((DataTip)this.m_panel).item.setSelected(this.series);
                ((DataTip)this.m_panel).group.setSelected(this.group);
            }
            if (this.m_panel instanceof DataLabel) {
                ((DataLabel)this.m_panel).position.setSelectedIndex(this.dataLabelPosition);
                ((DataLabel)this.m_panel).fontButton.setComponentForeground(this.dataLabelcolor);
                ((DataLabel)this.m_panel).fontButton.setUnderlineStyle(this.dataLabelUnderLine);
                ((DataLabel)this.m_panel).fontButton.setComponentFont(this.dataLabelFont);
                if (this.dataLabelTextType == 0) {
                    ((DataLabel)this.m_panel).value.setSelected(true);
                } else if (this.dataLabelTextType == 1) {
                    ((DataLabel)this.m_panel).percent.setSelected(true);
                } else if (this.dataLabelTextType == 2) {
                    ((DataLabel)this.m_panel).item.setSelected(true);
                } else if (this.dataLabelTextType == 3) {
                    ((DataLabel)this.m_panel).itemPercent.setSelected(true);
                }
            }
            PlotArea.this.m_bDataLabelFontNameChanged = this.dataLabelFontNameChanged;
            PlotArea.this.m_bDataLabelFontBoldChanged = this.dataLabelFontBoldChanged;
            PlotArea.this.m_bDataLabelFontItalicChanged = this.dataLabelFontItalicChanged;
            PlotArea.this.m_bDataLabelFontUnderlineChanged = this.dataLabelFontUnderlineChanged;
            PlotArea.this.m_bDataLabelFontSizeChanged = this.dataLabelFontSizeChanged;
            PlotArea.this.m_bDataLabelFontColorChanged = this.dataLabelColorChanged;
            PlotArea.this.m_bDataLabelPositionChanged = this.dataLabelPositionChanged;
            PlotArea.this.m_bDataLabelTextTypeChanged = this.dataLabelTextTypeChanged;
            PlotArea.this.m_bDataTipTypeChanged = this.dataTipTypeChanged;
        }
    }

    class DataTip
    extends JPanel
    implements ItemListener {
        MultiLineLabel label;
        JCheckBox value;
        JCheckBox percent;
        JCheckBox item;
        JCheckBox group;
        protected HelpProvider m_helpProvider;

        public DataTip() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.label = new MultiLineLabel();
            this.label.setTextWrapper(WordWrapper.getTextWrapper());
            this.label.setText(MessageFormat.format(PlotArea.this.rBundle.getString("displayed information"), PlotArea.this._getDataLabelString()));
            double d = this.getToolkit().getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
            int n = (int)Math.ceil(d / (double)(Integer.parseInt(PlotArea.this.rBundle.getString("DataTipPanelWidth")) - 20));
            this.label.setPreferredRows(n);
            this.label.setMinimumRows(n);
            this.label.setMaximumRows(n);
            JLabel jLabel = new JLabel(PlotArea.this.rBundle.getString("Show"));
            int n2 = this.getToolkit().getFontMetrics(jLabel.getFont()).stringWidth(jLabel.getText());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, n2 + 12, 0, 0));
            String string = PlotArea.this.rBundle.getString("Value");
            this.value = new JCheckBox(StringUtils.stripMnemonic((String)string));
            this.value.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = PlotArea.this.rBundle.getString("Percent");
            this.percent = new JCheckBox(StringUtils.stripMnemonic((String)string));
            this.percent.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = PlotArea.this.rBundle.getString("Item Label");
            this.item = new JCheckBox(StringUtils.stripMnemonic((String)string));
            this.item.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = PlotArea.this.rBundle.getString("Group Label");
            this.group = new JCheckBox(StringUtils.stripMnemonic((String)string));
            this.group.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(jLabel);
            jPanel2.add(Box.createHorizontalStrut(12));
            boolean bl = PlotArea.this.m_graph.isDataRowShownAsASeries();
            if (PlotArea.this.m_graph.isGroupSeriesTooltipSupported(bl ? 1 : 0)) {
                jPanel2.add(this.group);
                jPanel.add(this.value);
                if (PlotArea.this._isPercentGraph()) {
                    jPanel.add(this.percent);
                }
            } else if (PlotArea.this.m_graph.isGroupSeriesTooltipSupported(bl ? 0 : 1)) {
                jPanel2.add(this.item);
                jPanel.add(this.value);
                if (PlotArea.this._isPercentGraph()) {
                    jPanel.add(this.percent);
                }
            } else {
                jPanel2.add(this.item);
                jPanel.add(this.group);
                jPanel.add(this.value);
                if (PlotArea.this._isPercentGraph()) {
                    jPanel.add(this.percent);
                }
            }
            this.add((Component)this.label);
            this.add(Box.createVerticalStrut(15));
            this.add(jPanel2);
            this.add(jPanel);
            this.add(Box.createVerticalGlue());
            this.label.setAlignmentX(0.0f);
            jPanel2.setAlignmentX(0.0f);
            jPanel.setAlignmentX(0.0f);
            this.value.addItemListener(this);
            this.percent.addItemListener(this);
            this.item.addItemListener(this);
            this.group.addItemListener(this);
            boolean bl2 = PlotArea.this.m_bDataTipTypeChanged;
            this._init();
            PlotArea.this.m_bDataTipTypeChanged = bl2;
            this.setPreferredSize(new Dimension(Integer.parseInt(PlotArea.this.rBundle.getString("DataTipPanelWidth")), this.getPreferredSize().height));
        }

        public void _init() {
            if (PlotArea.this._isPercentGraph() && (4 & PlotArea.this.m_tooltipType) == 4) {
                this.percent.setSelected(true);
            }
            if ((1 & PlotArea.this.m_tooltipType) == 1) {
                this.value.setSelected(true);
            }
            if ((8 & PlotArea.this.m_tooltipType) == 8) {
                if (PlotArea.this.m_graph.getSeriesTooltipLabelType() != 0) {
                    this.item.setSelected(true);
                }
                if (PlotArea.this.m_graph.getGroupTooltipLabelType() != 0) {
                    this.group.setSelected(true);
                }
            }
        }

        public void setHelpProvider(HelpProvider helpProvider) {
            this.m_helpProvider = helpProvider;
        }

        public HelpProvider getHelpProvider() {
            return this.m_helpProvider;
        }

        public void apply() {
            if (PlotArea.this.m_bDataTipTypeChanged) {
                int n = 0;
                if (this.value.isSelected()) {
                    n |= 1;
                }
                if (this.percent.isEnabled() && this.percent.isSelected()) {
                    n |= 4;
                }
                if (this.item.isEnabled() && this.item.isSelected()) {
                    n |= 8;
                    PlotArea.this.m_graph.setSeriesTooltipLabelType(1);
                } else {
                    PlotArea.this.m_graph.setSeriesTooltipLabelType(0);
                }
                if (this.group.isEnabled() && this.group.isSelected()) {
                    n |= 8;
                    PlotArea.this.m_graph.setGroupTooltipLabelType(1);
                } else {
                    PlotArea.this.m_graph.setGroupTooltipLabelType(0);
                }
                PlotArea.this.m_tooltipType = n;
                if (PlotArea.this.m_tooltipType == 0) {
                    PlotArea.this.m_dataTipsBox.setSelected(false);
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n;
            if (itemEvent.getStateChange() == 1) {
                PlotArea.this.m_bDataTipTypeChanged = true;
                if (itemEvent.getSource() == this.value) {
                    n = PlotArea.this.m_tooltipType | 1;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, n);
                } else if (itemEvent.getSource() == this.percent) {
                    n = PlotArea.this.m_tooltipType | 4;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, n);
                } else if (itemEvent.getSource() == this.item) {
                    n = PlotArea.this.m_tooltipType | 8;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, n);
                } else if (itemEvent.getSource() == this.group) {
                    n = PlotArea.this.m_tooltipType | 8;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, n);
                }
            }
            if (itemEvent.getStateChange() == 2) {
                PlotArea.this.m_bDataTipTypeChanged = true;
                if (itemEvent.getSource() == this.value) {
                    n = PlotArea.this.m_tooltipType & 0xFFFFFFFE;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, n);
                } else if (itemEvent.getSource() == this.percent) {
                    n = PlotArea.this.m_tooltipType & 0xFFFFFFFB;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, n);
                } else if (itemEvent.getSource() == this.item) {
                    n = PlotArea.this.m_tooltipType & 0xFFFFFFF7;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, n);
                } else if (itemEvent.getSource() == this.group) {
                    n = PlotArea.this.m_tooltipType & 0xFFFFFFF7;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, n);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class DataLabel
    extends JPanel
    implements ItemListener,
    PropertyChangeListener {
        MultiLineLabel label;
        JRadioButton value;
        JRadioButton percent;
        JRadioButton item;
        JRadioButton itemPercent;
        JComboBox position;
        FontButton fontButton;
        int oldPosition;
        int textType;
        int height;
        protected HelpProvider m_helpProvider;
        protected boolean m_bFontNameChange;
        protected boolean m_bFontStyleChange;
        protected boolean m_bFontSizeChange;
        protected boolean m_bFontColorChange;
        protected String m_oldFontName;
        protected String m_newFontName;
        protected int m_oldFontStyle;
        protected int m_newFontStyle;
        protected int m_oldFontSize;
        protected int m_newFontSize;
        protected Color m_oldFontColor;
        protected Color m_newFontColor;
        protected int m_oldTextType;

        public DataLabel() {
            Serializable serializable;
            String[] stringArray;
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.label = new MultiLineLabel();
            this.label.setTextWrapper(WordWrapper.getTextWrapper());
            String string = PlotArea.this.rBundle.getString("Value");
            this.value = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.value.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = PlotArea.this.rBundle.getString("Per_Value");
            this.percent = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.percent.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = PlotArea.this.rBundle.getString("Item Label");
            this.item = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.item.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = PlotArea.this.rBundle.getString("Item Label and % Value");
            this.itemPercent = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.itemPercent.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            if (PlotArea.this._isPie()) {
                this.label.setText(MessageFormat.format(PlotArea.this.rBundle.getString("data labels infomation"), PlotArea.this._getDataLabelString()));
                stringArray = new String[]{PlotArea.this.rBundle.getString("Outside with line"), PlotArea.this.rBundle.getString("Outside Pie Slice"), PlotArea.this.rBundle.getString("Inside Pie Slice")};
            } else {
                this.label.setText(MessageFormat.format(PlotArea.this.rBundle.getString("Display data values"), PlotArea.this._getDataLabelString()));
                stringArray = new String[]{MessageFormat.format(PlotArea.this.rBundle.getString("Above"), PlotArea.this._getDataLabelString()), MessageFormat.format(PlotArea.this.rBundle.getString("Centered"), PlotArea.this._getDataLabelString())};
            }
            double d = this.getToolkit().getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
            int n = (int)Math.ceil(d / (double)(Integer.parseInt(PlotArea.this.rBundle.getString("DataLabelPanelWidth")) - 20));
            this.label.setPreferredRows(n);
            this.label.setMinimumRows(n);
            this.label.setMaximumRows(n);
            this.position = new JComboBox<String>(stringArray);
            string = PlotArea.this.rBundle.getString("Data Label Font");
            this.fontButton = new FontButton(StringUtils.stripMnemonic((String)string));
            this.fontButton.setCustomColorsEnabled(PlotArea.this.m_graph.isCustomColorsEnabled());
            if (PlotArea.this.m_bColorPaletteSet) {
                this.fontButton.setColorPalette(PlotArea.this.m_colorPalette);
            }
            this.fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            string = PlotArea.this.rBundle.getString("Data Label Font For FontButton");
            this.fontButton.setDialogTitle(string);
            this.fontButton.setPaneLocale(PlotArea.this.m_graph.getLocale());
            int n2 = 7;
            int n3 = 1;
            this.fontButton.setStyleButtonMask(n2);
            this.fontButton.setAlignmentButtonMask(0);
            this.fontButton.setColorComponentMask(n3);
            JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
            jPanel.add(this.fontButton);
            this.add((Component)this.label);
            this.add(Box.createVerticalStrut(15));
            if (PlotArea.this._isPie()) {
                this.add(new JLabel(PlotArea.this.rBundle.getString("Show")));
                this.add(this.value);
                this.add(this.percent);
                this.add(this.item);
                this.add(this.itemPercent);
                this.add(Box.createRigidArea(new Dimension(0, 6)));
                serializable = new ButtonGroup();
                ((ButtonGroup)serializable).add(this.value);
                ((ButtonGroup)serializable).add(this.percent);
                ((ButtonGroup)serializable).add(this.item);
                ((ButtonGroup)serializable).add(this.itemPercent);
            }
            string = PlotArea.this.rBundle.getString("labels location");
            serializable = new JLabel(StringUtils.stripMnemonic((String)string));
            ((JLabel)serializable).setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            ((JLabel)serializable).setLabelFor(this.position);
            this.add((Component)serializable);
            this.add(Box.createRigidArea(new Dimension(0, 3)));
            this.add(this.position);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(jPanel);
            this.add(Box.createVerticalGlue());
            this.setPreferredSize(new Dimension(Integer.parseInt(PlotArea.this.rBundle.getString("DataLabelPanelWidth")), this.getPreferredSize().height));
            if (!PlotArea.this._isDataLabelInTheCenterSupported()) {
                ((JComponent)serializable).setEnabled(false);
                this.position.setEnabled(false);
            }
            this.label.setAlignmentX(0.0f);
            this.value.setAlignmentX(0.0f);
            this.percent.setAlignmentX(0.0f);
            this.item.setAlignmentX(0.0f);
            this.itemPercent.setAlignmentX(0.0f);
            this.position.setAlignmentX(0.0f);
            jPanel.setAlignmentX(0.0f);
            this.position.addItemListener(this);
            this.fontButton.addPropertyChangeListener(this);
            this.value.addItemListener(this);
            this.percent.addItemListener(this);
            this.item.addItemListener(this);
            this.itemPercent.addItemListener(this);
            boolean bl = PlotArea.this.m_bDataLabelFontColorChanged;
            boolean bl2 = PlotArea.this.m_bDataLabelFontNameChanged;
            boolean bl3 = PlotArea.this.m_bDataLabelFontSizeChanged;
            boolean bl4 = PlotArea.this.m_bDataLabelFontBoldChanged;
            boolean bl5 = PlotArea.this.m_bDataLabelFontItalicChanged;
            boolean bl6 = PlotArea.this.m_bDataLabelFontUnderlineChanged;
            boolean bl7 = PlotArea.this.m_bDataLabelPositionChanged;
            boolean bl8 = PlotArea.this.m_bDataLabelTextTypeChanged;
            this._init();
            PlotArea.this.m_bDataLabelFontColorChanged = bl;
            PlotArea.this.m_bDataLabelFontNameChanged = bl2;
            PlotArea.this.m_bDataLabelFontSizeChanged = bl3;
            PlotArea.this.m_bDataLabelFontBoldChanged = bl4;
            PlotArea.this.m_bDataLabelFontItalicChanged = bl5;
            PlotArea.this.m_bDataLabelFontUnderlineChanged = bl6;
            PlotArea.this.m_bDataLabelPositionChanged = bl7;
            PlotArea.this.m_bDataLabelTextTypeChanged = bl8;
        }

        private void _init() {
            if (PlotArea.this._isPie()) {
                this.oldPosition = PlotArea.this.m_labelPosition;
                this.position.setSelectedIndex(this.oldPosition - 1);
                this.m_oldTextType = this.textType = PlotArea.this.m_graph.getUISliceLabel().getTextType();
                switch (this.textType) {
                    case 0: {
                        this.value.setSelected(true);
                        break;
                    }
                    case 1: {
                        this.percent.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.item.setSelected(true);
                        break;
                    }
                    case 3: {
                        this.itemPercent.setSelected(true);
                    }
                }
                this.fontButton.setComponentFont(PlotArea.this.m_graph.getUISliceLabel().getFont());
                if (PlotArea.this.m_graph.getUISliceLabel().getUIGraphFont().getGraphFontStyle() >= 4) {
                    this.fontButton.setUnderlineStyle(true);
                }
                this.fontButton.setComponentForeground(PlotArea.this.m_graph.getUISliceLabel().getUIGraphFont().getGraphFontColor());
            } else {
                this.oldPosition = PlotArea.this.m_graph.getUIMarkerText().getMarkerTextPlace() - 1;
                if (!PlotArea.this._isDataLabelInTheCenterSupported()) {
                    this.position.setSelectedIndex(0);
                } else if (this.oldPosition == 0) {
                    this.position.setSelectedIndex(this.oldPosition);
                } else {
                    this.position.setSelectedIndex(1);
                }
                this.fontButton.setComponentFont(PlotArea.this.m_graph.getUIMarkerText().getFont());
                if (PlotArea.this.m_graph.getUIMarkerText().getUIGraphFont().getGraphFontStyle() >= 4) {
                    this.fontButton.setUnderlineStyle(true);
                }
                this.fontButton.setComponentForeground(PlotArea.this.m_graph.getUIMarkerText().getUIGraphFont().getGraphFontColor());
            }
        }

        public void apply() {
            if (PlotArea.this._isPie()) {
                PlotArea.this.m_labelPosition = this.position.getSelectedIndex() + 1;
                if (PlotArea.this.m_bDataLabelTextTypeChanged) {
                    PlotArea.this.m_graph.getUISliceLabel().setTextType(this.textType);
                }
                if (PlotArea.this.m_bDataLabelFontNameChanged) {
                    PlotArea.this.m_graph.getUISliceLabel().getUIGraphFont().setGraphFontTypeface(this.fontButton.getComponentFont().getFontName());
                }
                if (PlotArea.this.m_bDataLabelFontSizeChanged) {
                    PlotArea.this.m_graph.getUISliceLabel().getUIGraphFont().setGraphFontSize(this.fontButton.getComponentFont().getSize());
                }
                if (PlotArea.this.m_bDataLabelFontBoldChanged) {
                    PlotArea.this.m_graph.getUISliceLabel().getUIGraphFont().setFontBold(this.fontButton.getComponentFont().isBold());
                }
                if (PlotArea.this.m_bDataLabelFontItalicChanged) {
                    PlotArea.this.m_graph.getUISliceLabel().getUIGraphFont().setFontItalic(this.fontButton.getComponentFont().isItalic());
                }
                if (PlotArea.this.m_bDataLabelFontUnderlineChanged) {
                    PlotArea.this.m_graph.getUISliceLabel().getUIGraphFont().setUnderline(this.fontButton.isUnderlineStyle());
                }
                if (PlotArea.this.m_bDataLabelFontColorChanged) {
                    PlotArea.this.m_graph.getUISliceLabel().getUIGraphFont().setGraphFontColor(this.fontButton.getComponentForeground());
                }
            } else {
                if (PlotArea.this._isDataLabelInTheCenterSupported() && PlotArea.this.m_bDataLabelPositionChanged) {
                    int n = this.position.getSelectedIndex();
                    if (n == 0) {
                        PlotArea.this.m_graph.getUIMarkerText().setMarkerTextPlace(1);
                    } else {
                        PlotArea.this.m_graph.getUIMarkerText().setMarkerTextPlace(4);
                    }
                }
                if (PlotArea.this.m_bDataLabelFontNameChanged) {
                    PlotArea.this.m_graph.getUIMarkerText().getUIGraphFont().setGraphFontTypeface(this.fontButton.getComponentFont().getFontName());
                }
                if (PlotArea.this.m_bDataLabelFontSizeChanged) {
                    PlotArea.this.m_graph.getUIMarkerText().getUIGraphFont().setGraphFontSize(this.fontButton.getComponentFont().getSize());
                }
                if (PlotArea.this.m_bDataLabelFontBoldChanged) {
                    PlotArea.this.m_graph.getUIMarkerText().getUIGraphFont().setFontBold(this.fontButton.getComponentFont().isBold());
                }
                if (PlotArea.this.m_bDataLabelFontItalicChanged) {
                    PlotArea.this.m_graph.getUIMarkerText().getUIGraphFont().setFontItalic(this.fontButton.getComponentFont().isItalic());
                }
                if (PlotArea.this.m_bDataLabelFontUnderlineChanged) {
                    PlotArea.this.m_graph.getUIMarkerText().getUIGraphFont().setUnderline(this.fontButton.isUnderlineStyle());
                }
                if (PlotArea.this.m_bDataLabelFontColorChanged) {
                    PlotArea.this.m_graph.getUIMarkerText().getUIGraphFont().setGraphFontColor(this.fontButton.getComponentForeground());
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getSource() == this.position) {
                    int n = this.position.getSelectedIndex();
                    n = PlotArea.this._isPie() ? ++n : (n += 2);
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_LABEL_POSITION, this.oldPosition, n);
                    this.oldPosition = n;
                    PlotArea.this.m_bDataLabelPositionChanged = true;
                } else if (itemEvent.getSource() == this.value) {
                    this.textType = 0;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_LABEL_TEXT, this.m_oldTextType, this.textType);
                    this.m_oldTextType = this.textType;
                    PlotArea.this.m_bDataLabelTextTypeChanged = true;
                } else if (itemEvent.getSource() == this.percent) {
                    this.textType = 1;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_LABEL_TEXT, this.m_oldTextType, this.textType);
                    this.m_oldTextType = this.textType;
                    PlotArea.this.m_bDataLabelTextTypeChanged = true;
                } else if (itemEvent.getSource() == this.item) {
                    this.textType = 2;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_LABEL_TEXT, this.m_oldTextType, this.textType);
                    this.m_oldTextType = this.textType;
                    PlotArea.this.m_bDataLabelTextTypeChanged = true;
                } else if (itemEvent.getSource() == this.itemPercent) {
                    this.textType = 3;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_LABEL_TEXT, this.m_oldTextType, this.textType);
                    this.m_oldTextType = this.textType;
                    PlotArea.this.m_bDataLabelTextTypeChanged = true;
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            boolean bl;
            String string = propertyChangeEvent.getPropertyName();
            if (string == "fontDialogCancelled" && !(bl = ((Boolean)(object = (Boolean)propertyChangeEvent.getNewValue())).booleanValue())) {
                if (this.m_bFontNameChange) {
                    this.firePropertyChange("fontName", this.m_oldFontName, this.m_newFontName);
                    this.m_bFontNameChange = false;
                    PlotArea.this.m_bDataLabelFontNameChanged = true;
                }
                if (this.m_bFontStyleChange) {
                    this.firePropertyChange("fontStyle", this.m_oldFontStyle, this.m_newFontStyle);
                    this.m_bFontStyleChange = false;
                    int n = this.m_oldFontStyle ^ this.m_newFontStyle;
                    if ((n & 1) != 0) {
                        PlotArea.this.m_bDataLabelFontBoldChanged = true;
                    }
                    if ((n & 2) != 0) {
                        PlotArea.this.m_bDataLabelFontItalicChanged = true;
                    }
                    if ((n & 4) != 0) {
                        PlotArea.this.m_bDataLabelFontUnderlineChanged = true;
                    }
                }
                if (this.m_bFontSizeChange) {
                    this.firePropertyChange("fontSize", this.m_oldFontSize, this.m_newFontSize);
                    this.m_bFontSizeChange = false;
                    PlotArea.this.m_bDataLabelFontSizeChanged = true;
                }
                if (this.m_bFontColorChange) {
                    this.firePropertyChange("fontColor", this.m_oldFontColor, this.m_newFontColor);
                    this.m_bFontColorChange = false;
                    PlotArea.this.m_bDataLabelFontColorChanged = true;
                }
            }
            if (string == "fontColor") {
                object = (Color)propertyChangeEvent.getOldValue();
                if (!this.m_bFontColorChange) {
                    this.m_oldFontColor = object;
                }
                this.m_newFontColor = (Color)propertyChangeEvent.getNewValue();
                if (object != this.m_newFontColor) {
                    this.m_bFontColorChange = true;
                }
            }
            if (string == "fontName") {
                object = (String)propertyChangeEvent.getOldValue();
                if (!this.m_bFontNameChange) {
                    this.m_oldFontName = object;
                }
                this.m_newFontName = (String)propertyChangeEvent.getNewValue();
                if (object != this.m_newFontName) {
                    this.m_bFontNameChange = true;
                }
            }
            if (string == "fontStyle") {
                object = (Integer)propertyChangeEvent.getOldValue();
                if (!this.m_bFontStyleChange) {
                    this.m_oldFontStyle = (Integer)object;
                }
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                this.m_newFontStyle = n;
                if ((Integer)object != this.m_newFontStyle) {
                    this.m_bFontStyleChange = true;
                }
            }
            if (string == "fontSize") {
                object = (Integer)propertyChangeEvent.getOldValue();
                if (!this.m_bFontSizeChange) {
                    this.m_oldFontSize = (Integer)object;
                }
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                this.m_newFontSize = n;
                if ((Integer)object != this.m_newFontSize) {
                    this.m_bFontSizeChange = true;
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public FontButton getFontButton() {
            return this.fontButton;
        }

        public void setHelpProvider(HelpProvider helpProvider) {
            this.m_helpProvider = helpProvider;
            this.fontButton.setHelpProvider(helpProvider);
        }

        public HelpProvider getHelpProvider() {
            return this.m_helpProvider;
        }
    }
}

