/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.help.HelpContext;

public class Legend
extends BasePanel
implements ActionListener,
ItemListener,
PropertyChangeListener,
HelpContext {
    public static final String PROPERTY_LEGEND_VISIBLE = "Legend Visible";
    public static final String PROPERTY_LEGEND_LOCATION = "Legend Location";
    public static final String PROPERTY_LEGEND_BORDER_COLOR = "Legend Border Color";
    public static final String PROPERTY_LEGEND_BACKGROUND_COLOR = "Legend background color";
    protected boolean m_showLegend;
    protected int m_legendLocation;
    protected JLabel m_locationLabel;
    protected JLabel m_borderColorLabel;
    protected JLabel m_bgroundColorLabel;
    protected Color m_borderColor;
    protected Color m_backgroundColor;
    protected Font m_font;
    protected Color m_fontColor;
    protected String[] m_locationRes;
    protected JCheckBox m_shLegendCBox;
    protected JComboBox m_locationComboBox;
    protected BIColorChoice m_bcbutton;
    protected BIColorChoice m_bgcbutton;
    protected FontButton m_fontbutton;
    protected JPanel m_propertiesPanel;
    protected int m_hAlignment;
    protected boolean m_bUnderline;
    protected boolean m_bColorPaletteSet;
    protected boolean m_bFontColorChange;
    protected boolean m_bFontNameChange;
    protected boolean m_bFontStyleChange;
    protected boolean m_bFontSizeChange;
    protected boolean m_bHorizontalAlignmentChange;
    protected boolean m_bFontColorChanged;
    protected boolean m_bFontNameChanged;
    protected boolean m_bFontBoldChanged;
    protected boolean m_bFontItalicChanged;
    protected boolean m_bFontUnderlineChanged;
    protected boolean m_bFontSizeChanged;
    protected boolean m_bHorizontalAlignmentChanged;
    protected boolean m_bShowLegendChanged;
    protected boolean m_bLegendLocationChanged;
    protected boolean m_bBorderColorChanged;
    protected boolean m_bBackgroundColorChanged;
    protected boolean m_bHelpEnabled = true;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected Color m_bgColor;
    protected Color m_bdColor;
    protected Color m_oldFontColor;
    protected Color m_newFontColor;
    protected String m_oldFontName;
    protected String m_newFontName;
    protected int m_oldFontStyle;
    protected int m_newFontStyle;
    protected int m_oldFontSize;
    protected int m_newFontSize;
    protected int m_oldHAlignment;
    protected int m_newHAlignment;
    protected static final int LAP_AUTOMATIC = 4;
    protected boolean m_automaticInList;
    private ResourceBundle rBundle;
    private static Color c_Transparent;

    public Legend(Graph graph) {
        super(graph);
        this.m_graph = graph;
        this.init();
        this.constructPanel();
    }

    public void setColorPalette(Color[][] colorArray) {
        ArrayTwoDModel arrayTwoDModel;
        if (colorArray != null) {
            arrayTwoDModel = FontButton.getArrayTwoDModel(colorArray);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            arrayTwoDModel = null;
        }
        this.m_fontbutton.setColorPalette(arrayTwoDModel);
        if (this.m_bgColor != null) {
            this.m_bgcbutton.setSelectedColor((Color)this.m_bgcbutton.getColorPalette().getData(0, 0));
            this.m_bgcbutton.setColorPalette((TwoDModel)arrayTwoDModel);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bgcbutton.getColorPalette(), (Color)this.m_bgColor)) {
                    this.m_bgcbutton.setColorPalette(FontButton.getNewColorPalette(this.m_bgcbutton.getColorPalette(), this.m_bgColor, this.m_bColorPaletteSet));
                }
                this.m_bgcbutton.setSelectedColor(this.m_bgColor);
            } else {
                this.m_bgcbutton.setSelectedColor(this.m_bgcbutton.getClosestColor(this.m_bgColor));
            }
        } else {
            this.m_bgcbutton.setColorPalette((TwoDModel)arrayTwoDModel);
        }
        if (this.m_bdColor != null) {
            this.m_bcbutton.setSelectedColor((Color)this.m_bcbutton.getColorPalette().getData(0, 0));
            this.m_bcbutton.setColorPalette((TwoDModel)arrayTwoDModel);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bcbutton.getColorPalette(), (Color)this.m_bdColor)) {
                    this.m_bcbutton.setColorPalette(FontButton.getNewColorPalette(this.m_bcbutton.getColorPalette(), this.m_bdColor, this.m_bColorPaletteSet));
                }
                this.m_bcbutton.setSelectedColor(this.m_bdColor);
            } else {
                this.m_bcbutton.setSelectedColor(this.m_bcbutton.getClosestColor(this.m_bdColor));
            }
        } else {
            this.m_bcbutton.setColorPalette((TwoDModel)arrayTwoDModel);
        }
    }

    public Color[][] getColorPalette() {
        return FontButton.getColorArray(this.m_bcbutton.getColorPalette());
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
    }

    private void init() {
        this.updateResourceBundle(this.m_graph.getLocale());
        this.m_automaticInList = this.m_graph.getAutoLayout() == 2 || this.m_graph.getAutoLayout() == 1;
        if (this.m_automaticInList) {
            this.m_locationRes = new String[5];
            this.m_locationRes[0] = this.rBundle.getString("Automatic");
            this.m_locationRes[1] = this.rBundle.getString("Top");
            this.m_locationRes[2] = this.rBundle.getString("Bottom");
            this.m_locationRes[3] = this.rBundle.getString("Right");
            this.m_locationRes[4] = this.rBundle.getString("Left");
        } else {
            this.m_locationRes = new String[4];
            this.m_locationRes[0] = this.rBundle.getString("Top");
            this.m_locationRes[1] = this.rBundle.getString("Bottom");
            this.m_locationRes[2] = this.rBundle.getString("Right");
            this.m_locationRes[3] = this.rBundle.getString("Left");
        }
        if (this.m_locationComboBox != null) {
            this.m_locationComboBox.setModel(new DefaultComboBoxModel<String>(this.m_locationRes));
        }
        this.m_showLegend = this.m_graph.getGraphType() != 102 ? this.m_graph.getUILegendArea().isVisible() : false;
        this.m_legendLocation = this.m_automaticInList && this.m_graph.getUILegendArea().getAutomaticPlacement() == 1 ? 4 : this.m_graph.getUILegendArea().getPosition();
        this.m_legendLocation = this.convertLegendLocationToComboOffset(this.m_legendLocation);
        this.m_borderColor = !this.m_graph.getUILegendArea().isBorderTransparent() ? this.m_graph.getUILegendArea().getBorderColor() : c_Transparent;
        this.m_bdColor = this.m_borderColor;
        this.m_backgroundColor = !this.m_graph.getUILegendArea().isFillTransparent() ? this.m_graph.getUILegendArea().getFillColor() : c_Transparent;
        this.m_bgColor = this.m_backgroundColor;
        this.m_fontColor = this.m_graph.getUILegendText().getUIGraphFont().getGraphFontColor();
        int n = this.m_graph.getUILegendText().getUIGraphFont().getGraphFontStyle();
        this.m_bUnderline = n == 7 || n == 6 || n == 5 || n == 4;
        this.m_hAlignment = this.m_graph.getUILegendText().getHorizontalAlignment();
        this.m_font = this.m_graph.getUILegendText().getFont();
    }

    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.init();
        if (this.m_graph.getGraphType() != 102) {
            this.m_shLegendCBox.setSelected(this.m_showLegend);
            this.m_shLegendCBox.setEnabled(true);
        } else {
            this.m_shLegendCBox.setSelected(false);
            this.m_shLegendCBox.setEnabled(false);
        }
        if (this.m_backgroundColor != c_Transparent) {
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bgcbutton.getColorPalette(), (Color)this.m_backgroundColor)) {
                    this.m_bgcbutton.setColorPalette(FontButton.getNewColorPalette(this.m_bgcbutton.getColorPalette(), this.m_backgroundColor, this.m_bColorPaletteSet));
                }
                this.m_bgcbutton.setSelectedColor(this.m_backgroundColor);
            } else {
                this.m_bgcbutton.setSelectedColor(this.m_bgcbutton.getClosestColor(this.m_backgroundColor));
            }
        }
        this.m_bgcbutton.setEnabled(this.m_showLegend);
        this.m_bgcbutton.setLocale(graph.getLocale());
        this.m_bgcbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        if (this.m_borderColor != c_Transparent) {
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bcbutton.getColorPalette(), (Color)this.m_borderColor)) {
                    this.m_bcbutton.setColorPalette(FontButton.getNewColorPalette(this.m_bcbutton.getColorPalette(), this.m_borderColor, this.m_bColorPaletteSet));
                }
                this.m_bcbutton.setSelectedColor(this.m_borderColor);
            } else {
                this.m_bcbutton.setSelectedColor(this.m_bcbutton.getClosestColor(this.m_borderColor));
            }
        }
        this.m_bcbutton.setEnabled(this.m_showLegend);
        this.m_bcbutton.setLocale(graph.getLocale());
        this.m_bcbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_locationComboBox.setEnabled(this.m_showLegend);
        this.m_locationComboBox.setSelectedIndex(this.m_legendLocation);
        this.m_fontbutton.setComponentFont(this.m_font);
        this.m_fontbutton.setEnabled(this.m_showLegend);
        this.m_fontbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        int n = this.m_graph.getUILegendText().getUIGraphFont().getGraphFontStyle();
        if ((n & 4) == 4) {
            this.m_fontbutton.setUnderlineStyle(true);
        } else {
            this.m_fontbutton.setUnderlineStyle(false);
        }
        this.m_hAlignment = this.m_graph.getUILegendText().getHorizontalAlignment();
        this.m_fontbutton.setPaneHorizontalAlignment(this.m_graph.getUILegendText().getHorizontalAlignment());
        this.m_fontbutton.setComponentForeground(this.m_fontColor);
        this.m_bShowLegendChanged = false;
        this.m_bLegendLocationChanged = false;
        this.m_bBorderColorChanged = false;
        this.m_bBackgroundColorChanged = false;
        this.m_bFontNameChanged = false;
        this.m_bFontBoldChanged = false;
        this.m_bFontItalicChanged = false;
        this.m_bFontUnderlineChanged = false;
        this.m_bFontSizeChanged = false;
        this.m_bFontColorChanged = false;
    }

    private void constructPanel() {
        String string = this.rBundle.getString("legend options");
        this.setTitleText(string);
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 0));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 6));
        String string2 = this.rBundle.getString("Show legend");
        this.m_shLegendCBox = new JCheckBox(StringUtils.stripMnemonic((String)string2), this.m_showLegend);
        this.m_shLegendCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        if (this.m_graph.getGraphType() == 102) {
            this.m_shLegendCBox.setEnabled(false);
        } else {
            this.m_shLegendCBox.setEnabled(true);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.m_shLegendCBox);
        this.m_shLegendCBox.setAlignmentX(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentX(0.0f);
        string2 = this.rBundle.getString("Location");
        this.m_locationLabel = new JLabel(StringUtils.stripMnemonic((String)string2));
        this.m_locationLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        this.m_locationLabel.setAlignmentX(0.0f);
        this.m_locationComboBox = new JComboBox<String>(this.m_locationRes);
        this.m_locationComboBox.setAlignmentX(0.0f);
        this.m_locationComboBox.setSelectedIndex(this.m_legendLocation);
        this.m_locationComboBox.setEnabled(this.m_showLegend);
        this.m_locationLabel.setLabelFor(this.m_locationComboBox);
        jPanel3.add(this.m_locationLabel);
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add(this.m_locationComboBox);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setAlignmentX(0.0f);
        string2 = this.rBundle.getString("Border color");
        this.m_borderColorLabel = new JLabel(StringUtils.stripMnemonic((String)string2));
        this.m_borderColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        this.m_borderColorLabel.setAlignmentX(0.0f);
        jPanel4.add(this.m_borderColorLabel);
        this.m_bcbutton = new BIColorChoice();
        this.m_bcbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_borderColorLabel.setLabelFor((Component)((Object)this.m_bcbutton));
        if (this.m_borderColor != c_Transparent) {
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bcbutton.getColorPalette(), (Color)this.m_borderColor)) {
                    this.m_bcbutton.setColorPalette(FontButton.getNewColorPalette(this.m_bcbutton.getColorPalette(), this.m_borderColor, this.m_bColorPaletteSet));
                }
                this.m_bcbutton.setSelectedColor(this.m_borderColor);
            } else {
                this.m_bcbutton.setSelectedColor(this.m_bcbutton.getClosestColor(this.m_borderColor));
            }
        }
        this.m_bcbutton.setEnabled(this.m_showLegend);
        this.m_bcbutton.setTransparentAllowed(true);
        this.m_bcbutton.setLocale(this.m_graph.getLocale());
        this.m_bBorderColorChanged = false;
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add((Component)((Object)this.m_bcbutton));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        string2 = this.rBundle.getString("Legend Bg color");
        this.m_bgroundColorLabel = new JLabel(StringUtils.stripMnemonic((String)string2));
        this.m_bgroundColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        this.m_bgroundColorLabel.setAlignmentX(0.0f);
        this.setPerferLen();
        jPanel5.add(this.m_bgroundColorLabel);
        this.m_bgcbutton = new BIColorChoice();
        this.m_bgcbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_bgroundColorLabel.setLabelFor((Component)((Object)this.m_bgcbutton));
        if (this.m_backgroundColor != c_Transparent) {
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bgcbutton.getColorPalette(), (Color)this.m_backgroundColor)) {
                    this.m_bgcbutton.setColorPalette(FontButton.getNewColorPalette(this.m_bgcbutton.getColorPalette(), this.m_backgroundColor, this.m_bColorPaletteSet));
                }
                this.m_bgcbutton.setSelectedColor(this.m_backgroundColor);
            } else {
                this.m_bgcbutton.setSelectedColor(this.m_bgcbutton.getClosestColor(this.m_backgroundColor));
            }
        }
        this.m_bgcbutton.setEnabled(this.m_showLegend);
        this.m_bgcbutton.setTransparentAllowed(true);
        this.m_bgcbutton.setLocale(this.m_graph.getLocale());
        this.m_bBackgroundColorChanged = false;
        jPanel5.add(Box.createHorizontalStrut(5));
        jPanel5.add((Component)((Object)this.m_bgcbutton));
        jPanel5.setAlignmentX(0.0f);
        Dimension dimension = jPanel5.getPreferredSize();
        Dimension dimension2 = jPanel4.getPreferredSize();
        Dimension dimension3 = jPanel3.getPreferredSize();
        int n = dimension3.width >= dimension2.width ? (dimension3.width >= dimension.width ? dimension3.width : dimension.width) : (dimension2.width >= dimension.width ? dimension2.width : dimension.width);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setAlignmentX(0.0f);
        jPanel6.add(Box.createVerticalStrut(5));
        jPanel6.add(jPanel2);
        jPanel6.add(Box.createVerticalStrut(10));
        jPanel6.add(jPanel3);
        jPanel6.add(Box.createVerticalStrut(10));
        jPanel6.add(jPanel5);
        jPanel6.add(Box.createVerticalStrut(10));
        jPanel6.add(jPanel4);
        jPanel6.add(Box.createVerticalStrut(10));
        if (n < jPanel2.getPreferredSize().width) {
            n = jPanel2.getPreferredSize().width;
        }
        jPanel2.setPreferredSize(new Dimension(n, jPanel2.getPreferredSize().height));
        jPanel2.setMaximumSize(jPanel2.getPreferredSize());
        jPanel2.setMinimumSize(jPanel2.getPreferredSize());
        jPanel5.setPreferredSize(new Dimension(n, jPanel5.getPreferredSize().height));
        jPanel5.setMaximumSize(jPanel5.getPreferredSize());
        jPanel5.setMinimumSize(jPanel5.getPreferredSize());
        jPanel4.setPreferredSize(new Dimension(n, jPanel4.getPreferredSize().height));
        jPanel4.setMaximumSize(jPanel4.getPreferredSize());
        jPanel4.setMinimumSize(jPanel4.getPreferredSize());
        jPanel3.setPreferredSize(new Dimension(n, jPanel3.getPreferredSize().height));
        jPanel3.setMaximumSize(jPanel3.getPreferredSize());
        jPanel3.setMinimumSize(jPanel3.getPreferredSize());
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel7.setAlignmentX(0.0f);
        string2 = this.rBundle.getString("Legend Font");
        this.m_fontbutton = new FontButton(StringUtils.stripMnemonic((String)string2));
        this.m_fontbutton.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_fontbutton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        string2 = this.rBundle.getString("Legend Font For FontButton");
        this.m_fontbutton.setDialogTitle(string2);
        this.m_fontbutton.setPaneLocale(this.m_graph.getLocale());
        this.m_fontbutton.setAlignmentX(0.0f);
        this.m_font = this.m_graph.getUILegendText().getFont();
        this.m_fontbutton.setComponentFont(this.m_font);
        this.m_fontbutton.setEnabled(this.m_showLegend);
        int n2 = this.m_graph.getUILegendText().getUIGraphFont().getGraphFontStyle();
        if ((n2 & 4) == 4) {
            this.m_fontbutton.setUnderlineStyle(true);
        }
        Dimension dimension4 = this.m_fontbutton.getPreferredSize();
        if (dimension4.width > n) {
            n = dimension4.width;
        }
        this.m_fontbutton.setMaximumSize(this.m_fontbutton.getPreferredSize());
        this.m_fontbutton.setMinimumSize(this.m_fontbutton.getPreferredSize());
        jPanel7.add(Box.createHorizontalStrut(this.m_locationLabel.getPreferredSize().width + 5));
        jPanel7.add(this.m_fontbutton);
        jPanel7.setPreferredSize(new Dimension(this.m_locationLabel.getPreferredSize().width + 5 + this.m_fontbutton.getPreferredSize().width, jPanel7.getPreferredSize().height));
        jPanel7.setMaximumSize(jPanel7.getPreferredSize());
        jPanel7.setMinimumSize(jPanel7.getPreferredSize());
        if (jPanel7.getPreferredSize().width > n) {
            n = jPanel7.getPreferredSize().width;
        }
        String string3 = this.rBundle.getString("legend options");
        JLabel jLabel = new JLabel(string3);
        int n3 = jLabel.getPreferredSize().width;
        if (n3 > n) {
            n = n3;
        }
        int n4 = 0;
        n4 = jLabel.getPreferredSize().height + 5 + jPanel2.getPreferredSize().height + 10 + jPanel3.getPreferredSize().height + 10 + jPanel4.getPreferredSize().height + 10 + jPanel5.getPreferredSize().height + 10 + jPanel7.getPreferredSize().height;
        jPanel.setPreferredSize(new Dimension(n + 20, n4 + 25));
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        boolean bl = this.m_graph.isDrillingEnabled();
        int n5 = 3;
        if (!bl) {
            n5 |= 4;
        }
        int n6 = 30;
        this.m_fontbutton.setStyleButtonMask(n5);
        this.m_fontbutton.setAlignmentButtonMask(n6);
        this.m_fontbutton.setColorComponentMask(1);
        this.m_fontbutton.setComponentForeground(this.m_fontColor);
        this.m_hAlignment = this.m_graph.getUILegendText().getHorizontalAlignment();
        this.m_fontbutton.setPaneHorizontalAlignment(this.m_hAlignment);
        jPanel6.add(jPanel7);
        jPanel.add(jPanel6);
        this.m_propertiesPanel = jPanel;
        this.m_mainPanel.add(jPanel);
        this.m_shLegendCBox.addItemListener(this);
        this.m_locationComboBox.addActionListener(this);
        this.m_fontbutton.addPropertyChangeListener(this);
        this.m_bcbutton.addPropertyChangeListener(this);
        this.m_bgcbutton.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.m_bcbutton) {
            if (propertyChangeEvent.getPropertyName().equals("selectedColor")) {
                this.m_bBorderColorChanged = true;
                this.firePropertyChange(PROPERTY_LEGEND_BORDER_COLOR, this.m_borderColor, this.m_bcbutton.getSelectedColor());
                this.m_borderColor = this.m_bcbutton.getSelectedColor();
            }
        } else if (propertyChangeEvent.getSource() == this.m_bgcbutton) {
            if (propertyChangeEvent.getPropertyName().equals("selectedColor")) {
                this.m_bBackgroundColorChanged = true;
                this.firePropertyChange(PROPERTY_LEGEND_BACKGROUND_COLOR, this.m_backgroundColor, this.m_bgcbutton.getSelectedColor());
                this.m_backgroundColor = this.m_bgcbutton.getSelectedColor();
            }
        } else if (propertyChangeEvent.getSource() == this.m_fontbutton) {
            Comparable<Boolean> comparable;
            String string = propertyChangeEvent.getPropertyName();
            if (string == "fontDialogCancelled") {
                comparable = (Boolean)propertyChangeEvent.getNewValue();
                boolean bl = (Boolean)comparable;
                if (!bl) {
                    this.m_font = this.m_fontbutton.getComponentFont();
                    if (this.m_bFontNameChange) {
                        this.firePropertyChange("fontName", this.m_oldFontName, this.m_newFontName);
                        this.m_bFontNameChange = false;
                        this.m_bFontNameChanged = true;
                    }
                    if (this.m_bFontStyleChange) {
                        this.firePropertyChange("fontStyle", this.m_oldFontStyle, this.m_newFontStyle);
                        this.m_bUnderline = this.m_newFontStyle >= 4;
                        int n = this.m_oldFontStyle ^ this.m_newFontStyle;
                        if ((n & 1) != 0) {
                            this.m_bFontBoldChanged = true;
                        }
                        if ((n & 2) != 0) {
                            this.m_bFontItalicChanged = true;
                        }
                        if ((n & 4) != 0) {
                            this.m_bFontUnderlineChanged = true;
                        }
                        this.m_bFontStyleChange = false;
                    }
                    if (this.m_bFontSizeChange) {
                        this.firePropertyChange("fontSize", this.m_oldFontSize, this.m_newFontSize);
                        this.m_bFontSizeChange = false;
                        this.m_bFontSizeChanged = true;
                    }
                    if (this.m_bFontColorChange) {
                        this.firePropertyChange("fontColor", this.m_oldFontColor, this.m_newFontColor);
                        this.m_fontColor = this.m_newFontColor;
                        this.m_bFontColorChange = false;
                        this.m_bFontColorChanged = true;
                    }
                    if (this.m_bHorizontalAlignmentChange) {
                        this.firePropertyChange("fontHorizontalAlignment", this.m_oldHAlignment, this.m_newHAlignment);
                        this.m_hAlignment = this.m_newHAlignment;
                        this.m_bHorizontalAlignmentChange = false;
                        this.m_bHorizontalAlignmentChanged = true;
                    }
                } else {
                    this.m_bFontColorChange = false;
                    this.m_bFontNameChange = false;
                    this.m_bFontStyleChange = false;
                    this.m_bFontSizeChange = false;
                    this.m_bHorizontalAlignmentChange = false;
                }
            }
            if (string == "fontColor") {
                if (!this.m_bFontColorChange) {
                    this.m_oldFontColor = (Color)propertyChangeEvent.getOldValue();
                }
                this.m_newFontColor = (Color)propertyChangeEvent.getNewValue();
                if ((Color)propertyChangeEvent.getOldValue() != this.m_newFontColor) {
                    this.m_bFontColorChange = true;
                }
            }
            if (string == "fontName") {
                if (!this.m_bFontNameChange) {
                    this.m_oldFontName = (String)propertyChangeEvent.getOldValue();
                }
                this.m_newFontName = (String)propertyChangeEvent.getNewValue();
                if ((String)propertyChangeEvent.getOldValue() != this.m_newFontName) {
                    this.m_bFontNameChange = true;
                }
            }
            if (string == "fontStyle") {
                comparable = (Integer)propertyChangeEvent.getOldValue();
                if (!this.m_bFontStyleChange) {
                    this.m_oldFontStyle = (Integer)comparable;
                }
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                this.m_newFontStyle = n;
                if ((Integer)comparable != this.m_newFontStyle) {
                    this.m_bFontStyleChange = true;
                }
            }
            if (string == "fontSize") {
                comparable = (Integer)propertyChangeEvent.getOldValue();
                if (!this.m_bFontSizeChange) {
                    this.m_oldFontSize = (Integer)comparable;
                }
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                this.m_newFontSize = n;
                if ((Integer)comparable != this.m_newFontSize) {
                    this.m_bFontSizeChange = true;
                }
            }
            if (string == "fontHorizontalAlignment") {
                comparable = (Integer)propertyChangeEvent.getOldValue();
                if (!this.m_bHorizontalAlignmentChange) {
                    this.m_oldHAlignment = (Integer)comparable;
                }
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                this.m_newHAlignment = n;
                if ((Integer)comparable != this.m_newHAlignment) {
                    this.m_bHorizontalAlignmentChange = true;
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_shLegendCBox) {
            this.m_bShowLegendChanged = true;
            if (itemEvent.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_LEGEND_VISIBLE, false, true);
                this.m_showLegend = true;
                this.m_locationComboBox.setRequestFocusEnabled(true);
                this.m_bcbutton.setRequestFocusEnabled(true);
                this.m_bgcbutton.setRequestFocusEnabled(true);
                this.m_fontbutton.setRequestFocusEnabled(true);
            } else {
                this.firePropertyChange(PROPERTY_LEGEND_VISIBLE, true, false);
                this.m_showLegend = false;
                this.m_locationComboBox.setRequestFocusEnabled(false);
                this.m_bcbutton.setRequestFocusEnabled(false);
                this.m_bgcbutton.setRequestFocusEnabled(false);
                this.m_fontbutton.setRequestFocusEnabled(false);
            }
            this.m_locationComboBox.setEnabled(this.m_showLegend);
            this.m_bcbutton.setEnabled(this.m_showLegend);
            this.m_bgcbutton.setEnabled(this.m_showLegend);
            this.m_fontbutton.setEnabled(this.m_showLegend);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_locationComboBox) {
            this.m_bLegendLocationChanged = true;
            this.firePropertyChange(PROPERTY_LEGEND_LOCATION, this.convertComboOffsetToLegendLocation(this.m_legendLocation), this.convertComboOffsetToLegendLocation(this.m_locationComboBox.getSelectedIndex()));
            this.m_legendLocation = this.m_locationComboBox.getSelectedIndex();
        }
    }

    public void apply() {
        if (this.m_graph.getGraphType() == 102) {
            return;
        }
        if (this.m_bShowLegendChanged) {
            this.m_graph.getUILegendArea().setVisible(this.m_showLegend);
        }
        if (this.m_bLegendLocationChanged) {
            int n = this.convertComboOffsetToLegendLocation(this.m_locationComboBox.getSelectedIndex());
            if (!this.m_automaticInList) {
                if (n != this.m_graph.getUILegendArea().getPosition()) {
                    this.m_graph.getUILegendArea().setPosition(n);
                }
            } else if (n == 4) {
                this.m_graph.getUILegendArea().setAutomaticPlacement(1);
            } else {
                this.m_graph.getUILegendArea().setAutomaticPlacement(0);
                this.m_graph.getUILegendArea().setPosition(n);
            }
        }
        if (this.m_bBorderColorChanged) {
            if (this.m_borderColor != c_Transparent) {
                if (!this.m_graph.getUILegendArea().getBorderColor().equals(this.m_borderColor)) {
                    this.m_graph.getUILegendArea().setBorderColor(this.m_borderColor);
                }
                this.m_graph.getUILegendArea().setBorderTransparent(false);
            } else {
                this.m_graph.getUILegendArea().setBorderTransparent(true);
            }
        }
        if (this.m_bBackgroundColorChanged) {
            if (this.m_backgroundColor != c_Transparent) {
                if (!this.m_graph.getUILegendArea().getFillColor().equals(this.m_backgroundColor)) {
                    this.m_graph.getUILegendArea().setFillColor(this.m_backgroundColor);
                }
                this.m_graph.getUILegendArea().setFillTransparent(false);
            } else {
                this.m_graph.getUILegendArea().setFillTransparent(true);
            }
        }
        if (this.m_bFontNameChanged) {
            this.m_graph.getUILegendText().getUIGraphFont().setGraphFontTypeface(this.m_font.getFontName());
        }
        if (this.m_bFontSizeChanged) {
            this.m_graph.getUILegendText().getUIGraphFont().setGraphFontSize(this.m_font.getSize());
        }
        if (this.m_bFontColorChanged) {
            this.m_graph.getUILegendText().getUIGraphFont().setGraphFontColor(this.m_fontColor);
        }
        if (this.m_bHorizontalAlignmentChanged) {
            this.m_graph.getUILegendText().setHorizontalAlignment(this.m_hAlignment);
        }
        if (this.m_bFontBoldChanged) {
            this.m_graph.getUILegendText().getUIGraphFont().setFontBold(this.m_font.isBold());
        }
        if (this.m_bFontItalicChanged) {
            this.m_graph.getUILegendText().getUIGraphFont().setFontItalic(this.m_font.isItalic());
        }
        if (this.m_bFontUnderlineChanged) {
            this.m_graph.getUILegendText().getUIGraphFont().setUnderline(this.m_bUnderline);
        }
    }

    private int convertComboOffsetToLegendLocation(int n) {
        if (!this.m_automaticInList) {
            return n;
        }
        n = n == 0 ? 4 : --n;
        return n;
    }

    private int convertLegendLocationToComboOffset(int n) {
        if (!this.m_automaticInList) {
            return n;
        }
        n = n == 4 ? 0 : ++n;
        return n;
    }

    private int getUnderlineStyle(Font font) {
        int n = 0;
        switch (font.getStyle()) {
            case 0: {
                n = 4;
                break;
            }
            case 1: {
                n = 6;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 7;
            }
        }
        return n;
    }

    private void setPerferLen() {
        int n = this.getToolkit().getFontMetrics(this.m_locationLabel.getFont()).stringWidth(this.m_locationLabel.getText());
        int n2 = this.getToolkit().getFontMetrics(this.m_borderColorLabel.getFont()).stringWidth(this.m_borderColorLabel.getText());
        int n3 = this.getToolkit().getFontMetrics(this.m_bgroundColorLabel.getFont()).stringWidth(this.m_bgroundColorLabel.getText());
        int n4 = n;
        if (n2 > n4) {
            n4 = n2;
        }
        if (n4 < n3) {
            n4 = n3;
        }
        this.m_locationLabel.setPreferredSize(new Dimension(n4, this.m_locationLabel.getPreferredSize().height));
        this.m_locationLabel.setMinimumSize(this.m_locationLabel.getPreferredSize());
        this.m_locationLabel.setMaximumSize(this.m_locationLabel.getPreferredSize());
        this.m_borderColorLabel.setPreferredSize(new Dimension(n4, this.m_borderColorLabel.getPreferredSize().height));
        this.m_borderColorLabel.setMinimumSize(this.m_borderColorLabel.getPreferredSize());
        this.m_borderColorLabel.setMaximumSize(this.m_borderColorLabel.getPreferredSize());
        this.m_bgroundColorLabel.setPreferredSize(new Dimension(n4, this.m_bgroundColorLabel.getPreferredSize().height));
        this.m_bgroundColorLabel.setMinimumSize(this.m_bgroundColorLabel.getPreferredSize());
        this.m_bgroundColorLabel.setMaximumSize(this.m_bgroundColorLabel.getPreferredSize());
    }

    public Dimension getPreferredSize() {
        int n = this.m_mainPanel.getPreferredSize().height;
        int n2 = this.m_mainPanel.getPreferredSize().width;
        return new Dimension(n2, n);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        this.m_fontbutton.setHelpProvider(helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_fontbutton.removePropertyChangeListener(this);
        this.m_bcbutton.removePropertyChangeListener(this);
        this.m_bgcbutton.removePropertyChangeListener(this);
        this.m_mainPanel.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
    }
}

