/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.BrowserLookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.BaseAxis;
import oracle.dss.graph.gui.TimeAxis;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.help.HelpContext;

public class GroupAxis
extends BaseAxis
implements ChangeListener,
HelpContext,
ActionListener {
    protected JPanel m_subPanel0;
    protected JPanel m_subPanel1;
    protected JPanel m_subPanel2;
    protected JPanel m_showFewSeparatorPanel;
    protected JPanel m_subPanel0SeparatorPanel;
    protected JPanel m_subPanel1SeparatorPanel;
    protected JPanel m_subPanel2SeparatorPanel;
    protected JRadioButton m_showAll;
    protected JRadioButton m_showAutomatic;
    protected JRadioButton m_showFew;
    protected NumericSpinBox m_startItem;
    protected NumericSpinBox m_interval;
    protected JRadioButton m_startItemLabel;
    protected JLabel m_intervalLabel;
    protected FontButton m_labelFontButton;
    protected JButton m_timeAxisButton;
    protected int m_oldStartItem;
    protected int m_oldInterval;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected int m_oldSkipMode;
    protected int m_newSkipMode;
    protected boolean m_bTickLabelSkipModeChanged;
    protected TimeAxis m_timeAxis;
    public static final String PROPERTY_TICKLABEL_SKIPMODE = "TickLabelSkipMode";
    public static final String PROPERTY_TICKLABEL_SKIPFIRST = "TickLabelSkipFirst";
    public static final String PROPERTY_TICKLABEL_SKIPCOUNT = "TickLabelSkipCount";
    private JPanel showAllPanel;
    private JPanel showFewPanel;
    private JPanel labelFontPanel;

    public GroupAxis(Graph graph) {
        super(graph);
        this.updateResourceBundle(graph.getLocale());
        this.setTitleText(this.rBundle.getString("X-Axis options"));
        this.m_showAxis.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Show X-Axis Title")));
        this.m_showAxis.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Show X-Axis Title")));
        this.m_lineLabel.setText(this.rBundle.getString("X-Axis line options"));
        this.m_optionsLabel.setText(this.rBundle.getString("X-Axis labels"));
        this.m_fontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("X-Title Font")));
        this.m_fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("X-Title Font")));
        this.m_fontButton.setDialogTitle(this.rBundle.getString("X-Title Font For FontButton"));
        this.m_showAutomatic = new JRadioButton(StringUtils.stripMnemonic((String)this.rBundle.getString("Auto axis labels")));
        this.m_showAutomatic.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Auto axis labels")));
        this.m_showAll = new JRadioButton(StringUtils.stripMnemonic((String)this.rBundle.getString("Show axis labels")));
        this.m_showAll.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Show axis labels")));
        this.m_showFew = new JRadioButton(StringUtils.stripMnemonic((String)this.rBundle.getString("Axis Show labels")));
        this.m_showFew.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Axis Show labels")));
        this.showAllPanel = new JPanel();
        this.showAllPanel.setLayout(new BoxLayout(this.showAllPanel, 0));
        this.showAllPanel.add(this.m_showAll);
        this.showFewPanel = new JPanel();
        this.showFewPanel.setLayout(new BoxLayout(this.showFewPanel, 0));
        this.m_showFewSeparatorPanel = new JPanel();
        this.m_showFewSeparatorPanel.setLayout(new BoxLayout(this.m_showFewSeparatorPanel, 1));
        this.m_showFewSeparatorPanel.add(Box.createVerticalStrut(5));
        this.showFewPanel.add(this.m_showFew);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_showAll);
        buttonGroup.add(this.m_showFew);
        this.m_subPanel0 = new JPanel();
        this.m_subPanel0.setLayout(new BoxLayout(this.m_subPanel0, 0));
        this.m_subPanel0SeparatorPanel = new JPanel();
        this.m_subPanel0SeparatorPanel.setLayout(new BoxLayout(this.m_subPanel0SeparatorPanel, 1));
        this.m_subPanel0SeparatorPanel.add(Box.createVerticalStrut(5));
        this.m_subPanel0.add(Box.createHorizontalStrut(24));
        this.m_subPanel0.add(this.m_showAutomatic);
        this.m_subPanel1 = new JPanel();
        this.m_subPanel1.setLayout(new BoxLayout(this.m_subPanel1, 0));
        this.m_subPanel1SeparatorPanel = new JPanel();
        this.m_subPanel1SeparatorPanel.setLayout(new BoxLayout(this.m_subPanel1SeparatorPanel, 1));
        this.m_subPanel1SeparatorPanel.add(Box.createVerticalStrut(5));
        this.m_subPanel1.add(Box.createHorizontalStrut(24));
        int n = 0;
        try {
            n = this.m_graph.isDataRowShownAsASeries() ? this.m_graph.getColumnCount() : this.m_graph.getRowCount();
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        if (n == 0) {
            n = 1;
        }
        this.m_startItemLabel = new JRadioButton(StringUtils.stripMnemonic((String)this.rBundle.getString("Starting with")));
        this.m_startItemLabel.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Starting with")));
        this.m_subPanel1.add(this.m_startItemLabel);
        this.m_startItem = new NumericSpinBox(1, n);
        this.m_subPanel1.add(Box.createHorizontalStrut(12));
        this.m_subPanel1.add((Component)this.m_startItem);
        this.m_labelFontButton = new FontButton(StringUtils.stripMnemonic((String)this.rBundle.getString("X-Axis Label")));
        this.m_labelFontButton.setCustomColorsEnabled(graph.isCustomColorsEnabled());
        this.m_labelFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("X-Axis Label")));
        this.m_labelFontButton.setDialogTitle(this.rBundle.getString("X-Axis Label For FontButton"));
        this.m_labelFontButton.setPaneLocale(graph.getLocale());
        this.labelFontPanel = new JPanel(new FlowLayout(2, 0, 0));
        if (this.isTimeAxis()) {
            this.m_timeAxisButton = new JButton(StringUtils.stripMnemonic((String)this.rBundle.getString("TimeAxisButton")));
            this.m_timeAxisButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("TimeAxisButton")));
            this.m_timeAxisButton.addActionListener(this);
            this.labelFontPanel.add(this.m_timeAxisButton);
            this.labelFontPanel.add(Box.createHorizontalStrut(10));
        }
        this.labelFontPanel.add(this.m_labelFontButton);
        this.initFontButton(this.m_labelFontButton);
        this.m_subPanel2 = new JPanel();
        this.m_subPanel2.setLayout(new BoxLayout(this.m_subPanel2, 0));
        this.m_intervalLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Ticks to skip")));
        this.m_intervalLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Ticks to skip")));
        this.m_subPanel2SeparatorPanel = new JPanel();
        this.m_subPanel2SeparatorPanel.setLayout(new BoxLayout(this.m_subPanel2SeparatorPanel, 1));
        this.m_subPanel2SeparatorPanel.add(Box.createVerticalStrut(5));
        this.m_subPanel2.add(Box.createHorizontalStrut(41));
        this.m_subPanel2.add(this.m_intervalLabel);
        this.m_interval = new NumericSpinBox(0, n - 1);
        this.m_intervalLabel.setLabelFor((Component)this.m_interval);
        this.m_subPanel2.add(Box.createHorizontalStrut(12));
        this.m_subPanel2.add((Component)this.m_interval);
        this.m_showAutomatic.setForeground(this.m_label.getForeground());
        this.m_showAll.setForeground(this.m_label.getForeground());
        this.m_showFew.setForeground(this.m_label.getForeground());
        this.m_labelFontButton.setForeground(this.m_label.getForeground());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_showAutomatic);
        buttonGroup2.add(this.m_startItemLabel);
        this.m_mainPanel.add(this.showAllPanel);
        this.m_mainPanel.add(this.m_showFewSeparatorPanel);
        this.m_mainPanel.add(this.showFewPanel);
        this.m_mainPanel.add(this.m_subPanel0SeparatorPanel);
        this.m_mainPanel.add(this.m_subPanel0);
        this.m_mainPanel.add(this.m_subPanel1SeparatorPanel);
        this.m_mainPanel.add(this.m_subPanel1);
        this.m_mainPanel.add(this.m_subPanel2SeparatorPanel);
        this.m_mainPanel.add(this.m_subPanel2);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.labelFontPanel);
        this.calculatePanelSizes();
        this.calculatePreferredSize();
        this.m_mainPanel.add(Box.createGlue());
        this.m_subPanel0.setAlignmentX(0.0f);
        this.m_showAll.setAlignmentX(0.0f);
        this.showAllPanel.setAlignmentX(0.0f);
        this.m_showFew.setAlignmentX(0.0f);
        this.showFewPanel.setAlignmentX(0.0f);
        this.m_subPanel1.setAlignmentX(0.0f);
        this.m_subPanel2.setAlignmentX(0.0f);
        this.labelFontPanel.setAlignmentX(0.0f);
        this.m_showAutomatic.addItemListener(this);
        this.m_showAll.addItemListener(this);
        this.m_showFew.addItemListener(this);
        this.m_showAutomatic.addItemListener(this);
        this.m_startItemLabel.addItemListener(this);
        this._init();
        this.m_labelFontButton.addPropertyChangeListener(this);
        this.m_interval.addChangeListener((ChangeListener)this);
        this.m_startItem.addChangeListener((ChangeListener)this);
    }

    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.initFontButton(this.m_labelFontButton);
        this._init();
    }

    public void cleanUp() {
        super.cleanUp();
    }

    public void setColorPalette(Color[][] colorArray) {
        super.setColorPalette(colorArray);
        this.m_labelFontButton.setColorPalette(this.m_colorPalette);
    }

    private void _init() {
        int n;
        this.m_font = this.m_graph.getUIO1Title().getFont();
        this.m_oldAxisColor = this.m_graph.getUIO1Axis().getLineColor();
        this.m_oldAxisTitle = this.m_token.getTokenString(this.m_graph.getUIO1Title().getUnParseText());
        this.m_oldLineWidth = this.m_graph.getUIO1Axis().getLineWidth();
        this.m_oldStartItem = this.m_graph.getUIO1TickLabel().getTickLabelSkipFirst();
        this.m_oldInterval = this.m_graph.getUIO1TickLabel().getTickLabelSkipCount();
        this.m_newSkipMode = this.m_graph.getUIO1TickLabel().getTickLabelSkipMode();
        this.m_axisTitle.setText(this.m_token.getTokenString(this.m_graph.getUIO1Title().getUnParseText()));
        if (this.m_axisTitle.getText() != null) {
            this.m_axisTitle.setCaretPosition(this.m_axisTitle.getText().length());
        }
        this.m_showAxis.setSelected(this.m_graph.getUIO1Title().isVisible());
        this.m_axisTitle.setHorizontalAlignment(this.m_graph.getUIO1Title().getHorizontalAlignment());
        this.m_fontButton.setComponentFont(this.m_graph.getUIO1Title().getFont());
        if (this.m_graph.getUIO1Title().getUIGraphFont().getGraphFontStyle() >= 4) {
            this.m_fontButton.setUnderlineStyle(true);
            this.m_axisTitle.setUnderline(true);
        } else {
            this.m_fontButton.setUnderlineStyle(false);
            this.m_axisTitle.setUnderline(false);
        }
        this.m_fontButton.setPaneHorizontalAlignment(this.m_graph.getUIO1Title().getHorizontalAlignment());
        this.m_fontButton.setComponentForeground(this.m_graph.getUIO1Title().getUIGraphFont().getGraphFontColor());
        int n2 = this.convertToFontButtonConstants(this.m_graph.getUIO1Title().getTextRotation());
        if (n2 == 1 && this.m_graph.isHorizontal()) {
            n2 = 2;
        }
        this.m_fontButton.setTextRotation(n2);
        this.m_axisTitle.setForeground(this.m_fontButton.getComponentForeground());
        Font font = this.m_fontButton.getComponentFont();
        this.m_axisTitle.setFont(new Font(font.getName(), font.getStyle(), this.m_axisTitle.getFont().getSize()));
        Color color = this.m_graph.getUIO1Axis().getLineColor();
        if (!this.m_bColorPaletteSet) {
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color)) {
                this.m_colorButton.setColorPalette(FontButton.getNewColorPalette(this.m_colorButton.getColorPalette(), color, this.m_bColorPaletteSet));
            }
            this.m_colorButton.setSelectedColor(color);
        } else {
            this.m_colorButton.setSelectedColor(this.m_colorButton.getClosestColor(color));
        }
        this.m_lColor = color;
        this.m_lineWidth.setCellColor(this.m_colorButton.getSelectedColor());
        this.m_lineWidth.setLineWidth(this.m_graph.getUIO1Axis().getLineWidth());
        boolean bl = this.isTimeAxis();
        if (bl) {
            this.showAllPanel.setVisible(false);
            this.showFewPanel.setVisible(false);
            this.m_subPanel0.setVisible(false);
            this.m_subPanel1.setVisible(false);
            this.m_subPanel2.setVisible(false);
            this.m_optionsLabelPanel.setVisible(false);
            this.m_showFewSeparatorPanel.setVisible(false);
            this.m_subPanel0SeparatorPanel.setVisible(false);
            this.m_subPanel1SeparatorPanel.setVisible(false);
            this.m_subPanel2SeparatorPanel.setVisible(false);
            this.m_optionSeparatorPanel.setVisible(false);
            this.m_timeAxis = new TimeAxis(this.m_graph);
        }
        if (!bl) {
            if (this.m_graph.getUIO1TickLabel().getTickLabelSkipMode() == 1) {
                this.m_showFew.setSelected(true);
                this.m_showAutomatic.setSelected(true);
            } else if (this.m_graph.getUIO1TickLabel().getTickLabelSkipMode() == 0) {
                this.m_showAll.setSelected(true);
                this.m_showFew.setSelected(false);
            } else {
                this.m_showFew.setSelected(true);
                this.m_startItemLabel.setSelected(true);
            }
            n = 0;
            try {
                n = this.m_graph.isDataRowShownAsASeries() ? this.m_graph.getColumnCount() : this.m_graph.getRowCount();
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                // empty catch block
            }
            if (n == 0) {
                n = 1;
            }
            this.m_interval.setMaximum(n);
            this.m_startItem.setMaximum(n);
            int n3 = this.m_graph.getUIO1TickLabel().getTickLabelSkipFirst() + 1;
            if (n3 > n) {
                n3 = n;
            }
            this.m_startItem.setIntValue(n3);
            int n4 = this.m_graph.getUIO1TickLabel().getTickLabelSkipCount();
            if (n4 > n) {
                n4 = n;
            }
            this.m_interval.setIntValue(n4);
        }
        this.m_labelFontButton.setComponentFont(this.m_graph.getUIO1TickLabel().getFont());
        if (this.m_graph.getUIO1TickLabel().getUIGraphFont().getGraphFontStyle() >= 4) {
            this.m_labelFontButton.setUnderlineStyle(true);
        } else {
            this.m_labelFontButton.setUnderlineStyle(false);
        }
        this.m_labelFontButton.setComponentForeground(this.m_graph.getUIO1TickLabel().getUIGraphFont().getGraphFontColor());
        n = this.m_graph.getUIO1TickLabel().getAutomaticRotation();
        if (!(this.isGraphHorizontal() || n != 1 && n != 2)) {
            this.m_labelFontButton.setTextRotation(0);
        } else {
            this.m_labelFontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getUIO1TickLabel().getTextRotation()));
        }
        if (this.m_graph.getGraphType() >= 67 && this.m_graph.getGraphType() <= 69) {
            this.m_axisLineSeparatorPanel.setVisible(false);
            this.m_axisTitlePanel.setVisible(false);
            this.m_lineWidthPanel.setVisible(false);
        } else if (this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14) {
            this.m_axisLinePanel.setVisible(false);
            this.m_axisLineSeparatorPanel.setVisible(false);
        } else {
            this.m_axisTitlePanel.setVisible(true);
            this.m_lineWidthPanel.setVisible(true);
            this.m_axisLineSeparatorPanel.setVisible(true);
            this.m_axisLinePanel.setVisible(true);
        }
        this.m_bLineWidthChanged = false;
        this.m_bLineColorChanged = false;
        this.m_bTickLabelSkipModeChanged = false;
        this.m_bTitleTextChanged = false;
        this.m_bTitleVisibleChanged = false;
    }

    private void calculatePanelSizes() {
        int n = Math.max(this.m_lineLabel.getPreferredSize().width, this.axisLinePanel.getPreferredSize().width);
        int n2 = this.m_lineLabel.getPreferredSize().height + 5 + this.axisLinePanel.getPreferredSize().height;
        this.m_axisLinePanel.setPreferredSize(new Dimension(n, n2));
        this.m_axisLinePanel.setMinimumSize(this.m_axisLinePanel.getPreferredSize());
        this.m_axisLinePanel.setMaximumSize(this.m_axisLinePanel.getPreferredSize());
        n = this.m_optionsLabel.getPreferredSize().width;
        n2 = this.m_optionsLabel.getPreferredSize().height + 5;
        this.m_optionsLabelPanel.setPreferredSize(new Dimension(n, n2));
        this.m_optionsLabelPanel.setMinimumSize(this.m_optionsLabelPanel.getPreferredSize());
        this.m_optionsLabelPanel.setMaximumSize(this.m_optionsLabelPanel.getPreferredSize());
        int n3 = this.m_showAutomatic.getFontMetrics(this.m_showAutomatic.getFont()).stringWidth(this.m_showAutomatic.getText());
        int n4 = this.m_startItemLabel.getFontMetrics(this.m_startItemLabel.getFont()).stringWidth(this.m_startItemLabel.getText());
        int n5 = this.m_intervalLabel.getFontMetrics(this.m_intervalLabel.getFont()).stringWidth(this.m_intervalLabel.getText());
        int n6 = Math.max(n3, Math.max(n4, n5));
        this.m_startItemLabel.setPreferredSize(new Dimension(n6 + 17, this.m_startItemLabel.getPreferredSize().height));
        this.m_startItemLabel.setMinimumSize(this.m_startItemLabel.getPreferredSize());
        this.m_startItemLabel.setMaximumSize(this.m_startItemLabel.getPreferredSize());
        this.m_intervalLabel.setPreferredSize(new Dimension(n6, this.m_startItemLabel.getPreferredSize().height));
        this.m_intervalLabel.setMinimumSize(this.m_intervalLabel.getPreferredSize());
        this.m_intervalLabel.setMaximumSize(this.m_intervalLabel.getPreferredSize());
        n = this.m_showAll.getPreferredSize().width;
        n2 = this.m_showAll.getPreferredSize().height;
        this.showAllPanel.setPreferredSize(new Dimension(n, n2));
        this.showAllPanel.setMinimumSize(this.showAllPanel.getPreferredSize());
        this.showAllPanel.setMaximumSize(this.showAllPanel.getPreferredSize());
        n = this.m_showFew.getPreferredSize().width;
        n2 = this.m_showFew.getPreferredSize().height;
        this.showFewPanel.setPreferredSize(new Dimension(n, n2));
        this.showFewPanel.setMinimumSize(this.showFewPanel.getPreferredSize());
        this.showFewPanel.setMaximumSize(this.showFewPanel.getPreferredSize());
        n = 24 + this.m_showAutomatic.getPreferredSize().width;
        n2 = this.m_showAutomatic.getPreferredSize().height;
        this.m_subPanel0.setPreferredSize(new Dimension(n, n2));
        this.m_subPanel0.setMinimumSize(this.m_subPanel0.getPreferredSize());
        this.m_subPanel0.setMaximumSize(this.m_subPanel0.getPreferredSize());
        n = 24 + this.m_startItemLabel.getPreferredSize().width + 12 + this.m_startItem.getPreferredSize().width;
        n2 = Math.max(this.m_startItemLabel.getPreferredSize().height, this.m_startItem.getPreferredSize().height);
        this.m_subPanel1.setPreferredSize(new Dimension(n, n2));
        this.m_subPanel1.setMinimumSize(this.m_subPanel1.getPreferredSize());
        this.m_subPanel1.setMaximumSize(this.m_subPanel1.getPreferredSize());
        n = 41 + this.m_intervalLabel.getPreferredSize().width + 12 + this.m_interval.getPreferredSize().width;
        n2 = Math.max(this.m_intervalLabel.getPreferredSize().height, this.m_interval.getPreferredSize().height);
        this.m_subPanel2.setPreferredSize(new Dimension(n, n2));
        this.m_subPanel2.setMinimumSize(this.m_subPanel2.getPreferredSize());
        this.m_subPanel2.setMaximumSize(this.m_subPanel2.getPreferredSize());
    }

    private void calculatePreferredSize() {
        int n = 0;
        int n2 = this.m_axisTitlePanel.getPreferredSize().width;
        if (n < n2) {
            n = n2;
        }
        if (n < (n2 = this.m_axisLinePanel.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.m_optionsLabelPanel.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.showAllPanel.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.showFewPanel.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.m_subPanel0.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.m_subPanel1.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.m_subPanel2.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.labelFontPanel.getPreferredSize().width)) {
            n = n2;
        }
        n2 = n + 10 + 10;
        int n3 = 10 + this.m_label.getPreferredSize().height + 15 + this.m_axisTitlePanel.getPreferredSize().height + 15 + this.m_axisLinePanel.getPreferredSize().height + 15 + this.m_optionsLabelPanel.getPreferredSize().height + this.showAllPanel.getPreferredSize().height + 5 + this.showFewPanel.getPreferredSize().height + 5 + this.m_subPanel0.getPreferredSize().height + 5 + this.m_subPanel1.getPreferredSize().height + 5 + this.m_subPanel2.getPreferredSize().height + 15 + this.labelFontPanel.getPreferredSize().height + 10;
        if (this.isTimeAxis()) {
            n3 -= 15 + this.m_optionsLabelPanel.getPreferredSize().height + this.showAllPanel.getPreferredSize().height + 5 + this.showFewPanel.getPreferredSize().height + 5 + this.m_subPanel0.getPreferredSize().height + 5 + this.m_subPanel1.getPreferredSize().height + 5 + this.m_subPanel2.getPreferredSize().height;
        }
        if (this.m_graph.getGraphType() >= 67 && this.m_graph.getGraphType() <= 69) {
            n3 -= this.m_axisTitlePanel.getPreferredSize().height + 15;
        } else if (this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14) {
            n3 -= 15 + this.m_axisLinePanel.getPreferredSize().height;
        }
        this.prefSize = new Dimension(n2, n3);
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.m_startItem) {
            int n = this.m_startItem.getIntValue() - 1;
            this.firePropertyChange(PROPERTY_TICKLABEL_SKIPFIRST, this.m_oldStartItem, n);
            this.m_oldStartItem = n;
        } else if (changeEvent.getSource() == this.m_interval) {
            int n = this.m_interval.getIntValue();
            this.firePropertyChange(PROPERTY_TICKLABEL_SKIPCOUNT, this.m_oldInterval, n);
            this.m_oldInterval = n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.m_timeAxisButton) {
            TimeAxisDialog timeAxisDialog = this.createTimeAxisDialog(this.rBundle.getString("TimeAxisTitle"), true, this.m_timeAxis, this.isHelpEnabled());
            timeAxisDialog.show();
            timeAxisDialog.dispose();
            timeAxisDialog = null;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        if (itemEvent.getSource() == this.m_showAll || itemEvent.getSource() == this.m_showFew || itemEvent.getSource() == this.m_showAutomatic) {
            this.m_bTickLabelSkipModeChanged = true;
        }
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.m_showAll) {
                this.m_showAutomatic.setEnabled(false);
                this.m_startItem.setEnabled(false);
                this.m_startItemLabel.setEnabled(false);
                this.m_interval.setEnabled(false);
                this.m_intervalLabel.setEnabled(false);
                this.m_oldSkipMode = this.m_newSkipMode;
                this.m_newSkipMode = 0;
                this.firePropertyChange(PROPERTY_TICKLABEL_SKIPMODE, this.m_oldSkipMode, this.m_newSkipMode);
            } else if (itemEvent.getSource() == this.m_showFew) {
                this.m_showAutomatic.setEnabled(true);
                this.m_startItem.setEnabled(true);
                this.m_startItemLabel.setEnabled(true);
                this.m_interval.setEnabled(true);
                this.m_intervalLabel.setEnabled(true);
                this.m_showAutomatic.setSelected(true);
                this.m_oldSkipMode = this.m_newSkipMode;
                this.m_newSkipMode = 1;
                this.firePropertyChange(PROPERTY_TICKLABEL_SKIPMODE, this.m_oldSkipMode, this.m_newSkipMode);
            }
            if (itemEvent.getSource() == this.m_showAutomatic) {
                this.m_startItem.setEnabled(false);
                this.m_interval.setEnabled(false);
                this.m_oldSkipMode = this.m_newSkipMode;
                this.m_newSkipMode = 1;
                this.firePropertyChange(PROPERTY_TICKLABEL_SKIPMODE, this.m_oldSkipMode, this.m_newSkipMode);
            }
            if (itemEvent.getSource() == this.m_startItemLabel) {
                this.m_startItem.setEnabled(true);
                this.m_interval.setEnabled(true);
                this.m_oldSkipMode = this.m_newSkipMode;
                this.m_newSkipMode = 2;
                this.firePropertyChange(PROPERTY_TICKLABEL_SKIPMODE, this.m_oldSkipMode, this.m_newSkipMode);
            }
        }
    }

    public void apply() {
        this.applyAfterCheck();
    }

    public boolean applyAfterCheck() {
        int n;
        if (!this.checkForBadInput()) {
            return false;
        }
        if (this.m_graph.getGraphType() < 67 || this.m_graph.getGraphType() > 69) {
            if (this.m_bTitleTextChanged) {
                this.m_graph.getUIO1Title().setText(this.m_token.getKeyString(this.m_axisTitle.getText()));
            }
            if (this.m_bTitleVisibleChanged) {
                this.m_graph.getUIO1Title().setVisible(this.m_showAxis.isSelected());
            }
            if (this.m_bTitleFontNameChanged) {
                this.m_graph.getUIO1Title().getUIGraphFont().setGraphFontTypeface(this.m_fontButton.getComponentFont().getName());
            }
            if (this.m_bTitleFontSizeChanged) {
                this.m_graph.getUIO1Title().getUIGraphFont().setGraphFontSize(this.m_fontButton.getComponentFont().getSize());
            }
            if (this.m_bTitleFontBoldChanged) {
                this.m_graph.getUIO1Title().getUIGraphFont().setFontBold(this.m_fontButton.getComponentFont().isBold());
            }
            if (this.m_bTitleFontItalicChanged) {
                this.m_graph.getUIO1Title().getUIGraphFont().setFontItalic(this.m_fontButton.getComponentFont().isItalic());
            }
            if (this.m_bTitleFontUnderlineChanged) {
                this.m_graph.getUIO1Title().getUIGraphFont().setUnderline(this.m_fontButton.isUnderlineStyle());
            }
            if (this.m_bTitleAlignmentChanged) {
                this.m_graph.getUIO1Title().setHorizontalAlignment(this.m_fontButton.getPaneHorizontalAlignment());
            }
            if (this.m_bTitleFontColorChanged) {
                this.m_graph.getUIO1Title().getUIGraphFont().setGraphFontColor(this.m_fontButton.getComponentForeground());
            }
            if (this.m_bTitleRotationChanged && (n = this.convertFromFontButtonConstants(this.m_fontButton.getTextRotation())) != -1) {
                this.m_graph.getUIO1Title().setTextRotation(n);
            }
            if (this.m_bLineWidthChanged) {
                this.m_graph.getUIO1Axis().setLineWidth(this.m_lineWidth.getLineWidth());
            }
        }
        if (this.m_bLineColorChanged) {
            this.m_graph.getUIO1Axis().setLineColor(this.m_colorButton.getSelectedColor());
        }
        if (this.m_startItemLabel.isSelected()) {
            this.m_graph.getUIO1TickLabel().setTickLabelSkipCount(this.m_interval.getIntValue());
            this.m_graph.getUIO1TickLabel().setTickLabelSkipFirst(this.m_startItem.getIntValue() - 1);
        }
        if (this.m_bTickLabelSkipModeChanged) {
            if (this.m_showAll.isSelected()) {
                this.m_graph.getUIO1TickLabel().setTickLabelSkipMode(0);
            } else if (this.m_showAutomatic.isSelected()) {
                this.m_graph.getUIO1TickLabel().setTickLabelSkipMode(1);
            } else {
                this.m_graph.getUIO1TickLabel().setTickLabelSkipMode(2);
            }
        }
        if (this.m_bLabelFontNameChanged) {
            this.m_graph.getUIO1TickLabel().getUIGraphFont().setGraphFontTypeface(this.m_labelFontButton.getComponentFont().getName());
        }
        if (this.m_bLabelFontSizeChanged) {
            this.m_graph.getUIO1TickLabel().getUIGraphFont().setGraphFontSize(this.m_labelFontButton.getComponentFont().getSize());
        }
        if (this.m_bLabelFontBoldChanged) {
            this.m_graph.getUIO1TickLabel().getUIGraphFont().setFontBold(this.m_labelFontButton.getComponentFont().isBold());
        }
        if (this.m_bLabelFontItalicChanged) {
            this.m_graph.getUIO1TickLabel().getUIGraphFont().setFontItalic(this.m_labelFontButton.getComponentFont().isItalic());
        }
        if (this.m_bLabelFontUnderlineChanged) {
            this.m_graph.getUIO1TickLabel().getUIGraphFont().setUnderline(this.m_labelFontButton.isUnderlineStyle());
        }
        if (this.m_bLabelFontColorChanged) {
            this.m_graph.getUIO1TickLabel().getUIGraphFont().setGraphFontColor(this.m_labelFontButton.getComponentForeground());
        }
        if (this.m_bLabelRotationChanged) {
            n = this.convertFromFontButtonConstants(this.m_labelFontButton.getTextRotation());
            if (n == -1) {
                this.m_graph.getUIO1TickLabel().setTextRotation(0);
                this.m_graph.getUIO1TickLabel().setAutomaticRotation(2);
            } else {
                this.m_graph.getUIO1TickLabel().setAutomaticRotation(0);
                this.m_graph.getUIO1TickLabel().setTextRotation(n);
            }
        }
        if (this.m_timeAxis != null) {
            this.m_timeAxis.apply();
        }
        return true;
    }

    public String getHelpContextID() {
        if (this.isTimeAxis()) {
            return String.valueOf(this.getClass().getName()) + "_Time";
        }
        return String.valueOf(this.getClass().getName()) + "_Ordinal";
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        this.m_labelFontButton.setHelpProvider(helpProvider);
        this.m_fontButton.setHelpProvider(helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    protected void initTitleFontButton(FontButton fontButton) {
        super.initTitleFontButton(fontButton);
        if (this.isGraphHorizontal()) {
            int n = 12;
            fontButton.setRotationButtonMask(n);
        } else {
            fontButton.setRotationButtonMask(0);
        }
    }

    protected void initFontButton(FontButton fontButton) {
        boolean bl = this.m_graph.isDrillingEnabled();
        int n = 3;
        if (!bl) {
            n |= 4;
        }
        int n2 = 1;
        int n3 = 14;
        fontButton.setStyleButtonMask(n);
        fontButton.setAlignmentButtonMask(0);
        fontButton.setColorComponentMask(n2);
        if (!this.isGraphHorizontal()) {
            n3 = 15;
        }
        if (this.isTimeAxis()) {
            n3 = 0;
        }
        fontButton.setRotationButtonMask(n3);
    }

    protected boolean checkForBadInput() {
        if (this.isTimeAxis()) {
            return true;
        }
        if (this.m_showFew.isSelected() && this.m_startItemLabel.isSelected() && this.m_startItem.getIntValue() > this.m_interval.getIntValue() + 1) {
            if (this.m_errorTypes == 65535) {
                Object[] objectArray = new String[]{Integer.toString(this.m_interval.getIntValue()), Integer.toString(this.m_interval.getIntValue() + 1)};
                String string = MessageFormat.format(this.rBundle.getString("Large starting tick mark"), objectArray);
                JOptionPane jOptionPane = new JOptionPane(string, 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.GroupAxis"), (String)"images/stop.gif")));
                jOptionPane.getAccessibleContext().setAccessibleName(string);
                JDialog jDialog = jOptionPane.createDialog(this, this.m_applicationName);
                jDialog.show();
                return false;
            }
            if (this.m_eh != null) {
                this.m_eh.log("Starting tick mark is greater than the number of tick marks to skip + 1", this.getClass().getName(), "checkForBadInput");
            }
        }
        return true;
    }

    private boolean isTimeAxis() {
        if (this.m_graph instanceof Graph) {
            return this.m_graph.getPFJ().isTimeAxis();
        }
        return false;
    }

    private TimeAxisDialog createTimeAxisDialog(String string, boolean bl, JPanel jPanel, boolean bl2) {
        TimeAxisDialog timeAxisDialog = null;
        Container container = this;
        while (container != null) {
            if (container instanceof Dialog) {
                timeAxisDialog = new TimeAxisDialog((Dialog)container, string, bl, jPanel, bl2);
                break;
            }
            if (container instanceof Frame) {
                timeAxisDialog = new TimeAxisDialog((Frame)container, string, bl, jPanel, bl2);
                break;
            }
            container = SwingUtilities.getWindowAncestor(container);
        }
        if (container == null) {
            timeAxisDialog = new TimeAxisDialog(null, string, bl, jPanel, bl2);
        }
        return timeAxisDialog;
    }

    class TimeAxisDialog
    extends JDialog
    implements ActionListener,
    HelpContext {
        protected JPanel m_panel;
        protected String m_strHelpContextID;
        private boolean m_bHelpEnabled = true;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        private int[] m_index = new int[4];
        private int m_initialWidth;
        private int m_initialHeight;
        private final Border _sBorder = new EmptyBorder(6, 6, 8, 5);
        private final Border _sBorderButtons = new EmptyBorder(8, 10, 0, 10);

        public TimeAxisDialog(Frame frame, String string, boolean bl, JPanel jPanel, boolean bl2) {
            super(frame);
            this._initDialog(string, bl, jPanel, bl2);
        }

        public TimeAxisDialog(Dialog dialog, String string, boolean bl, JPanel jPanel, boolean bl2) {
            super(dialog);
            this._initDialog(string, bl, jPanel, bl2);
        }

        private void _initDialog(String string, boolean bl, JPanel jPanel, boolean bl2) {
            this.m_bHelpEnabled = bl2;
            this.setTitle(string);
            this.setModal(bl);
            this.m_panel = jPanel;
            this.m_index[0] = GroupAxis.this.m_timeAxis.m_yearComboBox.getSelectedIndex();
            this.m_index[1] = GroupAxis.this.m_timeAxis.m_monthComboBox.getSelectedIndex();
            this.m_index[2] = GroupAxis.this.m_timeAxis.m_dayComboBox.getSelectedIndex();
            this.m_index[3] = GroupAxis.this.m_timeAxis.m_timeComboBox.getSelectedIndex();
            this.init();
            this.pack();
            Dimension dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            this.m_initialWidth = this.getWidth();
            this.m_initialHeight = this.getHeight();
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.addWindowListener(new WindowAdapter(this){
                final /* synthetic */ TimeAxisDialog this$0;

                public void windowClosing(WindowEvent windowEvent) {
                    this.this$0.resetValues();
                }
                {
                    this.this$0 = timeAxisDialog;
                }
            });
            jPanel = null;
        }

        public String getHelpContextID() {
            return this.getClass().getName();
        }

        public void setHelpContextID(String string) {
            this.m_strHelpContextID = string;
        }

        public void setHelpEnabled(boolean bl) {
            this.m_bHelpEnabled = bl;
        }

        public boolean isHelpEnabled() {
            return this.m_bHelpEnabled;
        }

        private void init() {
            Object object;
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            JComponent jComponent = (JComponent)this.getContentPane();
            jComponent.setLayout(new BoxLayout(jComponent, 1));
            jComponent.setBorder(this._sBorder);
            if (UIManager.getLookAndFeel() instanceof BrowserLookAndFeel) {
                jComponent.setBackground(UIManager.getColor("MenuBar.background"));
            } else if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                jComponent.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            GrayPane grayPane = new GrayPane((Component)this.m_panel);
            jComponent.add((Component)grayPane);
            DialogButtonBar dialogButtonBar = new DialogButtonBar();
            dialogButtonBar.setBorder(this._sBorderButtons);
            if (this.m_bHelpEnabled) {
                object = GroupAxis.this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)object));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)object));
                dialogButtonBar.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            object = new JPanel();
            this.okButton = new JButton(GroupAxis.this.rBundle.getString("OK"));
            dialogButtonBar.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            this.cancelButton = new JButton(GroupAxis.this.rBundle.getString("Cancel"));
            dialogButtonBar.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.addActionListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            this.getContentPane().add((Component)dialogButtonBar);
            this.setResizable(true);
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ TimeAxisDialog this$0;

                public void componentResized(ComponentEvent componentEvent) {
                    int n;
                    int n2;
                    int n3 = n2 = this.this$0.getWidth();
                    int n4 = n = this.this$0.getHeight();
                    if (TimeAxisDialog.access$7000071(this.this$0) != -1) {
                        n3 = Math.max(TimeAxisDialog.access$7000071(this.this$0), n3);
                    }
                    if (TimeAxisDialog.access$7000171(this.this$0) != -1) {
                        n4 = Math.max(TimeAxisDialog.access$7000171(this.this$0), n4);
                    }
                    if (n2 != n3 || n != n4) {
                        this.this$0.setSize(n3, n4);
                    }
                    this.this$0.validate();
                }
                {
                    this.this$0 = timeAxisDialog;
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.resetValues();
            } else if (actionEvent.getSource() == this.okButton) {
                this.setVisible(false);
            } else if (actionEvent.getSource() == this.helpButton) {
                try {
                    if (GroupAxis.this.getHelpProvider() != null) {
                        GroupAxis.this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        public void resetValues() {
            GroupAxis.this.m_timeAxis.m_yearComboBox.setSelectedIndex(this.m_index[0]);
            GroupAxis.this.m_timeAxis.m_monthComboBox.setSelectedIndex(this.m_index[1]);
            GroupAxis.this.m_timeAxis.m_dayComboBox.setSelectedIndex(this.m_index[2]);
            GroupAxis.this.m_timeAxis.m_timeComboBox.setSelectedIndex(this.m_index[3]);
        }

        static /* synthetic */ int access$7000171(TimeAxisDialog timeAxisDialog) {
            return timeAxisDialog.m_initialHeight;
        }

        static /* synthetic */ int access$7000071(TimeAxisDialog timeAxisDialog) {
            return timeAxisDialog.m_initialWidth;
        }
    }
}

