/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.GraphTypeAndSubtype;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.Subtype;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraph;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.dss.util.gui.ShortcutIcon;

public class GraphTypeTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_GRAPH_TYPE = "GraphType";
    Object m_selectedObject;
    protected UIDataview m_currentDataView;
    protected ToolBar m_toolBar;
    protected boolean m_enable = true;
    protected boolean m_bRolloverIconEnabled;
    private Vector m_types;
    private GraphTypeConverter m_graphTypeConverter;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    private boolean updateEnabled = true;
    private JToggleButton[] typeButtons;
    private GraphTypePopup popup;
    private ButtonGroup buttonGroup;
    private int oldType;
    private boolean m_bTypeChangedByTool;
    private MouseListener m_mouseListener;
    private ImageIcon[] graphTypeIcons;
    private int typeNumber;
    private String[] tooltips = new String[]{"BarGraph", "HorizontalBarGraph", "PieGraph", "LineGraph", "AreaGraph", "CombinationGraph", "ScatterBubbleGraph", "StockGraph", "CircularGraph", "ParetoGraph", "ThreeDGraph"};

    public GraphTypeTool() {
        ImageIcon imageIcon = this.makeImage("images/es_bar_vert_clust18t.gif");
        this.setIcon(this.getArrowIcon(imageIcon));
        this.setDisabledIcon(new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
        this.addActionListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (GraphTypeTool.this.isEnabled()) {
                    GraphTypeTool.this.setBorderPainted(!GraphTypeTool.this.isBorderPainted());
                    GraphTypeTool.this.setDropDownVisible(!GraphTypeTool.this.isDropDownVisible());
                    GraphTypeTool.this.requestFocus();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (GraphTypeTool.this.isDropDownVisible()) {
                    GraphTypeTool.this.setSelected(true);
                } else {
                    GraphTypeTool.this.setSelected(false);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                GraphTypeTool.this.internalKeyPressed(keyEvent);
            }
        });
        this.setModel(new Model());
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString(PROPERTY_GRAPH_TYPE));
        this.setEnabled(false);
        this.setBorderPainted(false);
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!GraphTypeTool.this.isRolloverIconEnabled()) {
                        ((JToggleButton)mouseEvent.getSource()).setBorderPainted(true);
                    }
                    if (!GraphTypeTool.this.isEnabled()) {
                        ((JToggleButton)mouseEvent.getSource()).setBorderPainted(GraphTypeTool.this.isSelected());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (!GraphTypeTool.this.isRolloverIconEnabled()) {
                        ((JToggleButton)mouseEvent.getSource()).setBorderPainted(((JToggleButton)mouseEvent.getSource()).isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            if (this.isDropDownVisible()) {
                keyEvent.consume();
            } else {
                super.processKeyEvent(keyEvent);
            }
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    private int findGraphType(Vector vector, int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < vector.size()) {
            if (vector.elementAt(n3) != null && ((Type)vector.elementAt((int)n3)).id == n) {
                n2 = n3;
                return n2;
            }
            ++n3;
        }
        return n2;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.setToolTipText(this.rBundle.getString(PROPERTY_GRAPH_TYPE));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        if (this.m_bTypeChangedByTool) {
            this.m_bTypeChangedByTool = false;
            return;
        }
        if (uIDataview instanceof UIGraph) {
            int n;
            GraphTypeConverter graphTypeConverter = ((UIGraph)uIDataview).getGraphTypeConverter();
            if (graphTypeConverter == null) {
                graphTypeConverter = new GraphTypeConverterAdapter();
            }
            graphTypeConverter.setLocale(((UIGraph)uIDataview).getLocale());
            ((UIGraph)uIDataview).setGraphTypeConverter(graphTypeConverter);
            if (graphTypeConverter.getTypes() == null) {
                return;
            }
            this.m_types = graphTypeConverter.getTypes();
            this.typeNumber = graphTypeConverter.getTypes().size();
            if (this.typeNumber < 1) {
                return;
            }
            this.m_graphTypeConverter = graphTypeConverter;
            this.m_enable = false;
            if (this.m_currentDataView != uIDataview) {
                this.graphTypeIcons = new ImageIcon[this.typeNumber * 3];
                n = 0;
                while (n < this.typeNumber) {
                    StringBuffer stringBuffer = new StringBuffer(((Type)this.m_types.elementAt((int)n)).sFileName);
                    stringBuffer.insert(((Type)this.m_types.elementAt((int)n)).sFileName.indexOf(".gif"), "18t");
                    this.graphTypeIcons[n] = this.makeImage(stringBuffer.toString());
                    this.graphTypeIcons[n].setDescription(((Type)this.m_types.elementAt((int)n)).name);
                    this.graphTypeIcons[this.typeNumber + n] = this.makeImage(((Type)this.m_types.elementAt((int)n)).fileName);
                    this.graphTypeIcons[this.typeNumber + n].setDescription(((Type)this.m_types.elementAt((int)n)).name);
                    this.graphTypeIcons[this.typeNumber * 2 + n] = this.makeImage(((Type)this.m_types.elementAt((int)n)).fileName);
                    this.graphTypeIcons[this.typeNumber * 2 + n].setDescription(((Type)this.m_types.elementAt((int)n)).name);
                    ++n;
                }
                if (this.typeButtons != null) {
                    n = 0;
                    while (n < this.typeButtons.length) {
                        this.typeButtons[n].removeActionListener(this);
                        this.typeButtons[n].removeMouseListener(this.m_mouseListener);
                        ++n;
                    }
                }
                this.typeButtons = new JToggleButton[this.typeNumber];
                this.buttonGroup = new ButtonGroup();
                n = 0;
                while (n < this.typeNumber) {
                    this.typeButtons[n] = new JToggleButton();
                    this.typeButtons[n].setIcon(this.graphTypeIcons[n]);
                    this.typeButtons[n].addActionListener(this);
                    this.typeButtons[n].addMouseListener(this.m_mouseListener);
                    this.typeButtons[n].setBorderPainted(false);
                    this.typeButtons[n].setSelected(false);
                    this.typeButtons[n].setToolTipText(this.rBundle.getString(this.tooltips[n]));
                    if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
                        this.typeButtons[n].setPreferredSize(new Dimension(24, 24));
                        this.typeButtons[n].setMinimumSize(this.typeButtons[n].getPreferredSize());
                        this.typeButtons[n].setMaximumSize(this.typeButtons[n].getPreferredSize());
                    }
                    this.buttonGroup.add(this.typeButtons[n]);
                    ++n;
                }
            }
            this.popup = new GraphTypePopup();
            this.setEnabled(true);
            this.m_currentDataView = uIDataview;
            if (toolBar != null) {
                this.m_toolBar = toolBar;
            }
            n = -1;
            int n2 = 0;
            while (n2 < this.m_graphTypeConverter.getTypes().size()) {
                if (((Type)this.m_graphTypeConverter.getTypes().elementAt((int)n2)).id == this.m_graphTypeConverter.getTypeAndSubtype((UIGraph)((UIGraph)this.m_currentDataView)).type) {
                    n = n2;
                }
                ++n2;
            }
            if (n != -1) {
                this.typeButtons[n].setSelected(true);
                this.typeButtons[n].setBorderPainted(true);
                this.oldType = n;
                this.setIcon(this.getArrowIcon(this.typeButtons[n].getIcon()));
                this.setDisabledIcon(new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
            }
            this.setRolloverIconEnabled(this.isRolloverIconEnabled());
        } else {
            this.m_currentDataView = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_currentDataView == null) {
            return;
        }
        if (this.m_graphTypeConverter == null) {
            return;
        }
        int n = 0;
        while (n < this.typeButtons.length) {
            if (actionEvent.getSource() == this.typeButtons[n]) {
                if (this.typeButtons[n].isSelected()) {
                    this.typeButtons[n].setBorderPainted(true);
                    if (this.oldType != n) {
                        this.m_bTypeChangedByTool = true;
                    }
                } else {
                    this.typeButtons[n].setBorderPainted(false);
                }
                Type type = (Type)this.m_graphTypeConverter.getTypes().elementAt(n);
                Subtype subtype = (Subtype)type.subtypes.elementAt(0);
                this.m_graphTypeConverter.setTypeAndSubtype((UIGraph)this.m_currentDataView, new GraphTypeAndSubtype(type.id, subtype.id));
                if (this.m_graphTypeConverter.isCombinationType((UIGraph)this.m_currentDataView)) {
                    this._setCombinationType(true);
                } else {
                    this._setCombinationType(false);
                }
                this.setDropDownVisible(false);
                this.setIcon(this.getArrowIcon(this.typeButtons[n].getIcon()));
                this.setDisabledIcon(new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
                if (this.isRolloverIconEnabled()) {
                    this.setRolloverIcon(this.getArrowIcon(this.graphTypeIcons[n + this.typeNumber]));
                    this.setRolloverSelectedIcon(this.getArrowIcon(this.graphTypeIcons[n + this.typeNumber]));
                } else {
                    this.setRolloverIcon(null);
                    this.setRolloverSelectedIcon(null);
                }
                this.setBorderPainted(false);
                this.firePropertyChange(PROPERTY_GRAPH_TYPE, this.oldType, n);
                this.oldType = n;
                this.requestFocus();
                this.setSelected(false);
                return;
            }
            ++n;
        }
    }

    public void update() {
        if (!this.updateEnabled) {
            return;
        }
        this.selectedAction(null, this.m_currentDataView, null);
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.GraphTypeTool"), (String)string));
    }

    private ImageIcon getArrowIcon(Icon icon) {
        if (icon != null) {
            return new ShortcutIcon((ImageIcon)icon, this.makeImage("images/arrow.gif"));
        }
        return null;
    }

    public boolean isPointType() {
        if (this.m_currentDataView == null) {
            return false;
        }
        return !((UIGraph)this.m_currentDataView).isLineDataLineDisplayed();
    }

    public boolean isCombinationType() {
        if (this.m_currentDataView == null) {
            return false;
        }
        try {
            int n = 0;
            while (n < ((UIGraph)this.m_currentDataView).getRowCount()) {
                if (((UIGraph)this.m_currentDataView).getUISeries().getMarkerType(n) != 0) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        return false;
    }

    private void _setCombinationType(boolean bl) {
        if (bl) {
            if (this.isCombinationType()) {
                return;
            }
            try {
                int n = 0;
                while (n < ((UIGraph)this.m_currentDataView).getRowCount()) {
                    ((UIGraph)this.m_currentDataView).getUISeries().setMarkerType(1, n);
                    ((UIGraph)this.m_currentDataView).getUISeries().setMarkerType(2, n + 1);
                    ((UIGraph)this.m_currentDataView).getUISeries().setMarkerType(3, n + 2);
                    n += 3;
                }
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {}
        } else {
            try {
                int n = 0;
                while (n < ((UIGraph)this.m_currentDataView).getRowCount()) {
                    if (((UIGraph)this.m_currentDataView).getUISeries().getMarkerType(n) != 0) {
                        ((UIGraph)this.m_currentDataView).getUISeries().setMarkerType(0, n);
                    }
                    ++n;
                }
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                // empty catch block
            }
        }
    }

    private boolean isDropDownVisible() {
        return this.popup == null ? false : this.popup.isVisible();
    }

    private void setDropDownVisible(boolean bl) {
        if (this.popup == null) {
            this.popup = new GraphTypePopup();
            this.popup.setBackground(this.getBackground());
        }
        if (bl) {
            this.popup.show(this, 0, this.getHeight());
        } else {
            this.popup.setVisible(false);
            this.popup = null;
            this.requestFocus();
        }
        this.repaint();
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
        if (this.popup != null) {
            this.popup.cleanUp();
        }
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
        if (bl) {
            if (this.typeButtons != null) {
                int n = 0;
                while (n < this.typeButtons.length) {
                    this.typeButtons[n].setIcon(this.graphTypeIcons[n + this.typeNumber * 2]);
                    this.typeButtons[n].setRolloverIcon(this.graphTypeIcons[n + this.typeNumber]);
                    this.typeButtons[n].setRolloverSelectedIcon(this.graphTypeIcons[n + this.typeNumber]);
                    if (this.typeButtons[n].isSelected()) {
                        this.setIcon(this.getArrowIcon(this.typeButtons[n].getIcon()));
                        this.setRolloverIcon(this.getArrowIcon(this.typeButtons[n].getRolloverIcon()));
                        this.setRolloverSelectedIcon(this.getArrowIcon(this.typeButtons[n].getRolloverSelectedIcon()));
                    }
                    ++n;
                }
            }
        } else {
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
            if (this.typeButtons != null) {
                int n = 0;
                while (n < this.typeButtons.length) {
                    this.typeButtons[n].setIcon(this.graphTypeIcons[n]);
                    this.typeButtons[n].setRolloverIcon(null);
                    this.typeButtons[n].setRolloverSelectedIcon(null);
                    if (this.typeButtons[n].isSelected()) {
                        this.setIcon(this.getArrowIcon(this.typeButtons[n].getIcon()));
                        this.setRolloverIcon(this.getArrowIcon(this.typeButtons[n].getRolloverIcon()));
                        this.setRolloverSelectedIcon(this.getArrowIcon(this.typeButtons[n].getRolloverSelectedIcon()));
                    }
                    ++n;
                }
            }
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isAnySelected() {
        boolean bl = false;
        int n = 0;
        while (n < this.typeButtons.length) {
            if (this.typeButtons[n].isSelected()) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private void internalKeyPressed(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = false;
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 37: 
            case 38: {
                if (!this.isDropDownVisible()) break;
                if (!this.isAnySelected()) {
                    this.typeButtons[this.typeButtons.length - 1].setBorderPainted(true);
                    this.typeButtons[this.typeButtons.length - 1].setSelected(true);
                } else {
                    int n2 = 0;
                    while (n2 < this.typeButtons.length) {
                        if (this.typeButtons[n2].isSelected()) {
                            this.typeButtons[n2].setBorderPainted(false);
                            this.typeButtons[n2].setSelected(false);
                            if (--n2 < 0) {
                                n2 = this.typeButtons.length - 1;
                            }
                            this.typeButtons[n2].setBorderPainted(true);
                            this.typeButtons[n2].setSelected(true);
                            this.popup.sendAccessibleEvent(((ImageIcon)this.typeButtons[n2].getIcon()).getDescription());
                            break;
                        }
                        ++n2;
                    }
                }
                bl = true;
                break;
            }
            case 39: 
            case 40: {
                if (!this.isDropDownVisible()) break;
                if (!this.isAnySelected()) {
                    this.typeButtons[0].setBorderPainted(true);
                    this.typeButtons[0].setSelected(true);
                } else {
                    int n3 = 0;
                    while (n3 < this.typeButtons.length) {
                        if (this.typeButtons[n3].isSelected()) {
                            this.typeButtons[n3].setBorderPainted(false);
                            this.typeButtons[n3].setSelected(false);
                            if (++n3 == this.typeButtons.length) {
                                n3 = 0;
                            }
                            this.typeButtons[n3].setBorderPainted(true);
                            this.typeButtons[n3].setSelected(true);
                            this.popup.sendAccessibleEvent(((ImageIcon)this.typeButtons[n3].getIcon()).getDescription());
                            break;
                        }
                        ++n3;
                    }
                }
                bl = true;
                break;
            }
            case 10: {
                if (!this.isDropDownVisible()) break;
                this.doEnter();
                this.setDropDownVisible(false);
                this.repaint();
                bl = true;
                break;
            }
            case 27: {
                if (!this.isDropDownVisible()) break;
                this.setDropDownVisible(false);
                this.repaint();
                break;
            }
            case 32: {
                if (!this.isDropDownVisible()) {
                    this.setDropDownVisible(true);
                    this.setBorderPainted(true);
                    break;
                }
                this.setDropDownVisible(false);
                this.repaint();
                break;
            }
        }
        if (bl) {
            keyEvent.consume();
        }
    }

    private void doEnter() {
        if (this.m_currentDataView == null) {
            return;
        }
        if (this.m_graphTypeConverter == null) {
            return;
        }
        int n = 0;
        while (n < this.typeButtons.length) {
            if (this.typeButtons[n].isSelected()) {
                Type type = (Type)this.m_graphTypeConverter.getTypes().elementAt(n);
                Subtype subtype = (Subtype)type.subtypes.elementAt(0);
                this.m_graphTypeConverter.setTypeAndSubtype((UIGraph)this.m_currentDataView, new GraphTypeAndSubtype(type.id, subtype.id));
                if (this.m_graphTypeConverter.isCombinationType((UIGraph)this.m_currentDataView)) {
                    this._setCombinationType(true);
                } else {
                    this._setCombinationType(false);
                }
                this.setIcon(this.typeButtons[n].getIcon());
                this.setDropDownVisible(false);
                this.setBorderPainted(false);
                this.requestFocus();
                return;
            }
            ++n;
        }
    }

    private class Model
    extends JToggleButton.ToggleButtonModel {
        Model() {
        }

        public boolean isPressed() {
            return GraphTypeTool.this.isDropDownVisible();
        }
    }

    class GraphTypePopup
    extends JPopupMenu {
        private JToolBar toolbar;
        private JLabel _statusBarLabel;
        private StatusBar _statusBar;

        public GraphTypePopup() {
            this.setLayout(new BoxLayout(this, 1));
            this.toolbar = new JToolBar();
            int n = 0;
            while (n < GraphTypeTool.this.typeButtons.length) {
                this.toolbar.add(GraphTypeTool.this.typeButtons[n]);
                if (!GraphTypeTool.this.typeButtons[n].isSelected()) {
                    GraphTypeTool.this.typeButtons[n].setBorderPainted(false);
                } else {
                    GraphTypeTool.this.typeButtons[n].setBorderPainted(true);
                }
                ++n;
            }
            this._statusBar = new StatusBar();
            this._statusBarLabel = new JLabel(this){
                final /* synthetic */ GraphTypePopup this$0;

                public void setText(String string) {
                    String string2 = this.getText();
                    super.setText(string);
                    if (this.accessibleContext != null) {
                        this.accessibleContext.firePropertyChange("AccessibleName", string2, string);
                    }
                }
                {
                    this.this$0 = graphTypePopup;
                }
            };
            this._statusBar.add((Component)this._statusBarLabel);
            this._statusBar.setVisible(false);
            this.add((Component)this._statusBar);
            this.toolbar.setOrientation(1);
            this.toolbar.setBorderPainted(false);
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                this.toolbar.setBorder(null);
            }
            this.add(this.toolbar);
        }

        public void sendAccessibleEvent(String string) {
            if (this._statusBarLabel != null) {
                this._statusBarLabel.setText(string);
            }
        }

        public void cleanUp() {
            this._statusBar.remove((Component)this._statusBarLabel);
            this._statusBarLabel = null;
        }

        protected void firePopupMenuWillBecomeInvisible() {
            super.firePopupMenuWillBecomeInvisible();
            GraphTypeTool.this.repaint();
        }

        protected void firePopupMenuCanceled() {
            super.firePopupMenuCanceled();
            GraphTypeTool.this.repaint();
        }
    }
}

