/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.graph.GraphTypeAndSubtype;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.Subtype;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraph;
import oracle.dss.util.SeriesOutOfRangeException;

public class GraphTypeConverterAdapter
implements GraphTypeConverter {
    public static final int TYPE_BAR = 0;
    public static final int TYPE_HORIZONTAL_BAR = 1;
    public static final int TYPE_LINE = 2;
    public static final int TYPE_HORIZONTAL_LINE = 3;
    public static final int TYPE_POINT = 4;
    public static final int TYPE_AREA = 5;
    public static final int TYPE_HORIZONTAL_AREA = 6;
    public static final int TYPE_COMBINATION = 7;
    public static final int TYPE_PARETO = 8;
    public static final int TYPE_PIE = 9;
    public static final int TYPE_POLAR = 10;
    public static final int TYPE_RADAR = 11;
    public static final int TYPE_SCATTER = 12;
    public static final int TYPE_BUBBLE = 13;
    public static final int TYPE_STOCK = 14;
    public static final int TYPE_THREED = 15;
    public static final int TYPE_HISTOGRAM = 16;
    public static final int TYPE_SPECTRAL = 17;
    public static final int TYPE_CIRCULAR = 18;
    public static final int TYPE_SCATTER_BUBBLE = 19;
    protected static final int MAX_TYPE = 19;
    public static final int BAR_VERT_CLUST = 0;
    public static final int BAR_VERT_CLUST2Y = 1;
    public static final int BAR_VERT_CLUST_SPLIT2Y = 2;
    public static final int BAR_VERT_PERCENT = 3;
    public static final int BAR_VERT_STACK = 4;
    public static final int BAR_VERT_STACK2Y = 5;
    public static final int BAR_VERT_STACK_SPLIT2Y = 6;
    public static final int BAR_HORIZ_CLUST = 7;
    public static final int BAR_HORIZ_CLUST_2Y = 8;
    public static final int BAR_HORIZ_CLUST_SPLIT2Y = 9;
    public static final int BAR_HORIZ_PERCENT = 10;
    public static final int BAR_HORIZ_STACK = 11;
    public static final int BAR_HORIZ_STACK_2Y = 12;
    public static final int BAR_HORIZ_STACK_SPLIT2Y = 13;
    public static final int LINE_VERT_ABS = 14;
    public static final int LINE_VERT_ABS_2Y = 15;
    public static final int LINE_VERT_ABS_SPLIT2Y = 16;
    public static final int LINE_VERT_PERCENT = 17;
    public static final int LINE_VERT_STACK = 18;
    public static final int LINE_VERT_STACK_2Y = 19;
    public static final int LINE_VERT_STACK_SPLIT2Y = 20;
    public static final int LINE_HORIZ_ABS = 21;
    public static final int LINE_HORIZ_ABS_2Y = 22;
    public static final int LINE_HORIZ_ABS_SPLIT2Y = 23;
    public static final int LINE_HORIZ_PERCENT = 24;
    public static final int LINE_HORIZ_STACK = 25;
    public static final int LINE_HORIZ_STACK_2Y = 26;
    public static final int LINE_HORIZ_STACK_SPLIT2Y = 27;
    public static final int POINT_VERT_ABS = 28;
    public static final int POINT_VERT_ABS_2Y = 29;
    public static final int POINT_VERT_ABS_SPLIT2Y = 30;
    public static final int AREA_VERT_ABS = 31;
    public static final int AREA_VERT_ABS_SPLIT2Y = 32;
    public static final int AREA_VERT_PERCENT = 33;
    public static final int AREA_VERT_STACK = 34;
    public static final int AREA_VERT_STACK_SPLIT2Y = 35;
    public static final int AREA_HORIZ_ABS = 36;
    public static final int AREA_HORIZ_ABS_SPLIT2Y = 37;
    public static final int AREA_HORIZ_PERCENT = 38;
    public static final int AREA_HORIZ_STACK = 39;
    public static final int AREA_HORIZ_STACK_SPLIT2Y = 40;
    public static final int COMBO_GRAPH = 41;
    public static final int COMBO_GRAPH_2Y = 42;
    public static final int PARETO = 43;
    public static final int PIE = 44;
    public static final int PIE_MULTI = 45;
    public static final int PIE_BAR = 46;
    public static final int RING = 47;
    public static final int RING_MULTI = 48;
    public static final int RING_BAR = 49;
    public static final int PIE_MULTI_PROP = 50;
    public static final int RING_MULTI_PROP = 51;
    public static final int POLAR = 52;
    public static final int POLAR_2Y = 53;
    public static final int RADAR_LINE = 54;
    public static final int RADAR_AREA = 55;
    public static final int RADAR_LINE_2Y = 56;
    public static final int SCATTER = 57;
    public static final int SCATTER_2Y = 58;
    public static final int SCATTER_LABELS = 59;
    public static final int SCATTER_LABELS_2Y = 60;
    public static final int BUBBLE = 61;
    public static final int BUBBLE_2Y = 62;
    public static final int BUBBLE_LABELS = 63;
    public static final int BUBBLE_LABELS_2Y = 64;
    public static final int STOCK_HILO_CLOSE = 65;
    public static final int STOCK_HILO_CLOSE_VOLUME = 66;
    public static final int STOCK_OHLC_CANDLE = 67;
    public static final int STOCK_OHLC_CANDLE_VOLUME = 68;
    public static final int STOCK_OPEN_HILO_CLOSE = 69;
    public static final int STOCK_2Y = 70;
    public static final int STOCK_CANDLE = 71;
    public static final int STOCK_CANDLE_VOLUME = 72;
    public static final int STOCK_HILO = 73;
    public static final int STOCK_HILO_2Y = 74;
    public static final int STOCK_HILO_CLOSE2Y = 75;
    public static final int STOCK_HILO_CLOSE_SPLIT2Y = 76;
    public static final int STOCK_HILO_SPLIT2Y = 77;
    public static final int STOCK_HILO_VOLUME = 78;
    public static final int STOCK_SPLIT_2Y = 79;
    public static final int STOCK_VOLUME = 80;
    public static final int THREED_BAR = 81;
    public static final int THREED_CUBE = 82;
    public static final int THREED_AREA_SERIES = 83;
    public static final int THREED_RIBBON_SERIES = 84;
    public static final int THREED_SURFACE = 85;
    public static final int THREED_SURFACE_SIDES = 86;
    public static final int THREED_AREA_GROUP = 87;
    public static final int THREED_DIAMOND = 88;
    public static final int THREED_OCTAGON = 89;
    public static final int THREED_PYRAMID = 90;
    public static final int THREED_RIBBON_GROUP = 91;
    public static final int THREED_SURFACE_HONEYCOMB = 92;
    public static final int HIST_HORIZ = 93;
    public static final int HIST_VERT = 94;
    public static final int SPECTRAL = 95;
    protected static final int MAX_SUBTYPE = 95;
    protected static int RESOURCE_TYPE_NAME;
    protected static int RESOURCE_SUBTYPE_NAME;
    protected static int RESOURCE_SUBTYPE_DESC;
    protected UIGraph m_graph;
    protected int m_type = 0;
    protected int m_subtype = 0;
    protected int m_graphType = 17;
    protected Vector m_types;
    private boolean m_isThin;
    private ResourceBundle rBundle;

    public GraphTypeConverterAdapter(UIGraph uIGraph) {
        this.m_graph = uIGraph;
        this.updateResourceBundle(this.m_graph.getLocale());
        this.m_graphType = this.m_graph.getGraphType();
        GraphTypeAndSubtype graphTypeAndSubtype = this.initialize(this.m_graph);
        this.m_type = graphTypeAndSubtype.type;
        this.m_subtype = graphTypeAndSubtype.subtype;
    }

    public GraphTypeConverterAdapter() {
        this.updateResourceBundle(null);
    }

    public GraphTypeAndSubtype getTypeAndSubtype() {
        if (this.m_graph != null) {
            this.m_graphType = this.m_graph.getGraphType();
            GraphTypeAndSubtype graphTypeAndSubtype = this.getTypeAndSubtype(this.m_graph);
            this.m_type = graphTypeAndSubtype.type;
            this.m_subtype = graphTypeAndSubtype.subtype;
            return graphTypeAndSubtype;
        }
        GraphTypeAndSubtype graphTypeAndSubtype = new GraphTypeAndSubtype(this.m_type, this.m_subtype);
        return graphTypeAndSubtype;
    }

    public GraphTypeAndSubtype getTypeAndSubtype(UIGraph uIGraph) {
        GraphTypeAndSubtype graphTypeAndSubtype = this.initialize(uIGraph);
        return graphTypeAndSubtype;
    }

    public void setTypeAndSubtype(GraphTypeAndSubtype graphTypeAndSubtype) {
        if (this.m_graph != null) {
            this.m_type = graphTypeAndSubtype.type;
            this.m_subtype = graphTypeAndSubtype.subtype;
            this.setTypeAndSubtype(this.m_graph, graphTypeAndSubtype);
        }
    }

    public void setTypeAndSubtype(UIGraph uIGraph, GraphTypeAndSubtype graphTypeAndSubtype) {
        int n = 0;
        int n2 = 0;
        n = graphTypeAndSubtype.type;
        n2 = graphTypeAndSubtype.subtype;
        this.apply(uIGraph, n, n2);
    }

    public boolean isPointType() {
        return false;
    }

    public boolean isCombinationType() {
        if (this.m_graph != null) {
            return this.isCombinationType(this.m_graph);
        }
        return false;
    }

    public boolean isCombinationType(UIGraph uIGraph) {
        try {
            int n = 0;
            while (n < uIGraph.getSeriesObjectCount()) {
                if (uIGraph.getUISeries().getMarkerType(n) != 0) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        return false;
    }

    public void addType(Type type) {
        this.getTypes().addElement(type);
    }

    public void addType(Type type, int n) {
        int n2 = 0;
        if (n > -1) {
            n2 = this.getTypeIndex(n) + 1;
        }
        if (n2 == -1) {
            this.getTypes().addElement(type);
        } else {
            this.getTypes().insertElementAt(type, n2);
        }
    }

    public void removeType(int n) {
        int n2 = this.getTypeIndex(n);
        if (n2 > -1) {
            this.getTypes().removeElementAt(n2);
        }
    }

    public Type getType(int n) {
        int n2 = this.getTypeIndex(n);
        return (Type)this.getTypes().elementAt(n2);
    }

    public int getNumberOfTypes() {
        return this.getTypes().size();
    }

    public Vector getTypes() {
        if (this.m_types == null) {
            this.initializeTypeList();
            this.loadStringResources();
        }
        return this.m_types;
    }

    public void setLocale(Locale locale) {
        this.updateResourceBundle(locale);
        if (this.m_types != null) {
            this.loadStringResources();
        }
    }

    protected void initializeTypeList() {
        Vector<Subtype> vector = new Vector<Subtype>();
        vector.addElement(new Subtype(0, null, null, "images/BAR_VERT_CLUST_3D.gif", "images/BAR_VERT_CLUST.gif"));
        vector.addElement(new Subtype(1, null, null, "images/BAR_VERT_CLUST2Y_3D.gif", "images/BAR_VERT_CLUST2Y.gif"));
        vector.addElement(new Subtype(2, null, null, "images/BAR_VERT_CLUST_SPLIT2Y_3D.gif", "images/BAR_VERT_CLUST_SPLIT2Y.gif"));
        vector.addElement(new Subtype(3, null, null, "images/BAR_VERT_PERCENT_3D.gif", "images/BAR_VERT_PERCENT.gif"));
        vector.addElement(new Subtype(4, null, null, "images/BAR_VERT_STACK_3D.gif", "images/BAR_VERT_STACK.gif"));
        vector.addElement(new Subtype(5, null, null, "images/BAR_VERT_STACK2Y_3D.gif", "images/BAR_VERT_STACK2Y.gif"));
        vector.addElement(new Subtype(6, null, null, "images/BAR_VERT_STACK_SPLIT2Y_3D.gif", "images/BAR_VERT_STACK_SPLIT2Y.gif"));
        Vector<Subtype> vector2 = new Vector<Subtype>();
        vector2.addElement(new Subtype(7, null, null, "images/BAR_HORIZ_CLUST_3D.gif", "images/BAR_HORIZ_CLUST.gif"));
        vector2.addElement(new Subtype(8, null, null, "images/BAR_HORIZ_CLUST2Y_3D.gif", "images/BAR_HORIZ_CLUST2Y.gif"));
        vector2.addElement(new Subtype(9, null, null, "images/BAR_HORIZ_CLUST_SPLIT2Y_3D.gif", "images/BAR_HORIZ_SPLIT2Y.gif"));
        vector2.addElement(new Subtype(10, null, null, "images/BAR_HORIZ_PERCENT_3D.gif", "images/BAR_HORIZ_PERCENT.gif"));
        vector2.addElement(new Subtype(11, null, null, "images/BAR_HORIZ_STACK_3D.gif", "images/BAR_HORIZ_STACK.gif"));
        vector2.addElement(new Subtype(12, null, null, "images/BAR_HORIZ_STACK2Y_3D.gif", "images/BAR_HORIZ_STACK2Y.gif"));
        vector2.addElement(new Subtype(13, null, null, "images/BAR_HORIZ_STACK_SPLIT2Y_3D.gif", "images/BAR_HORIZ_STACK_SPLIT2Y.gif"));
        Vector<Subtype> vector3 = new Vector<Subtype>();
        vector3.addElement(new Subtype(14, null, null, "images/LINE_VERT_ABS_3D.gif", "images/LINE_VERT_ABS.gif"));
        vector3.addElement(new Subtype(15, null, null, "images/LINE_VERT_ABS_2Y_3D.gif", "images/LINE_VERT_ABS_2Y.gif"));
        vector3.addElement(new Subtype(16, null, null, "images/LINE_VERT_ABS_SPLIT2Y_3D.gif", "images/LINE_VERT_ABS_SPLIT2Y.gif"));
        vector3.addElement(new Subtype(17, null, null, "images/LINE_VERT_PERCENT_3D.gif", "images/LINE_VERT_PERCENT.gif"));
        vector3.addElement(new Subtype(18, null, null, "images/LINE_VERT_STACK_3D.gif", "images/LINE_VERT_STACK.gif"));
        vector3.addElement(new Subtype(19, null, null, "images/LINE_VERT_STACK_2Y_3D.gif", "images/LINE_VERT_STACK_2Y.gif"));
        vector3.addElement(new Subtype(20, null, null, "images/LINE_VERT_STACK_SPLIT2Y_3D.gif", "images/LINE_VERT_STACK_SPLIT2Y.gif"));
        Vector<Subtype> vector4 = new Vector<Subtype>();
        vector4.addElement(new Subtype(28, null, null, "images/POINT_VERT_ABS_3D.gif", "images/POINT_VERT_ABS.gif"));
        vector4.addElement(new Subtype(29, null, null, "images/POINT_VERT_ABS_2Y_3D.gif", "images/POINT_VERT_ABS_2Y.gif"));
        vector4.addElement(new Subtype(30, null, null, "images/POINT_VERT_ABS_SPLIT2Y_3D.gif", "images/POINT_VERT_ABS_SPLIT2Y.gif"));
        Vector<Subtype> vector5 = new Vector<Subtype>();
        vector5.addElement(new Subtype(31, null, null, "images/AREA_VERT_ABS_3D.gif", "images/AREA_VERT_ABS.gif"));
        vector5.addElement(new Subtype(32, null, null, "images/AREA_VERT_ABS_SPLIT2Y_3D.gif", "images/AREA_VERT_ABS_SPLIT2Y.gif"));
        vector5.addElement(new Subtype(33, null, null, "images/AREA_VERT_PERCENT_3D.gif", "images/AREA_VERT_PERCENT.gif"));
        vector5.addElement(new Subtype(34, null, null, "images/AREA_VERT_STACK_3D.gif", "images/AREA_VERT_STACK.gif"));
        vector5.addElement(new Subtype(35, null, null, "images/AREA_VERT_STACK_SPLIT2Y_3D.gif", "images/AREA_VERT_STACK_SPLIT2Y.gif"));
        Vector<Subtype> vector6 = new Vector<Subtype>();
        vector6.addElement(new Subtype(41, null, null, "images/COMBO_GRAPH_3D.gif", "images/COMBO_GRAPH.gif"));
        vector6.addElement(new Subtype(42, null, null, "images/COMBO_GRAPH_2Y_3D.gif", "images/COMBO_GRAPH_2Y.gif"));
        Vector<Subtype> vector7 = new Vector<Subtype>();
        vector7.addElement(new Subtype(43, null, null, "images/THREED_PARETO.gif", "images/2D_PARETO.gif"));
        Vector<Subtype> vector8 = new Vector<Subtype>();
        vector8.addElement(new Subtype(44, null, null, "images/PIE_3D.gif", "images/PIE.gif"));
        vector8.addElement(new Subtype(45, null, null, "images/PIE_MULTI_3D.gif", "images/PIE_MULTI.gif"));
        vector8.addElement(new Subtype(46, null, null, "images/PIE_BAR_3D.gif", "images/PIE_BAR.gif"));
        vector8.addElement(new Subtype(47, null, null, "images/RING_3D.gif", "images/RING.gif"));
        vector8.addElement(new Subtype(48, null, null, "images/RING_MULTI_3D.gif", "images/RING_MULTI.gif"));
        vector8.addElement(new Subtype(49, null, null, "images/RING_BAR_3D.gif", "images/RING_BAR.gif"));
        Vector<Subtype> vector9 = new Vector<Subtype>();
        vector9.addElement(new Subtype(52, null, null, "images/POLAR_3D.gif", "images/POLAR.gif"));
        vector9.addElement(new Subtype(54, null, null, "images/RADAR_LINE.gif", "images/RADAR_LINE.gif"));
        Vector vector10 = new Vector();
        Vector<Subtype> vector11 = new Vector<Subtype>();
        vector11.addElement(new Subtype(57, null, null, "images/SCATTER_3D.gif", "images/SCATTER.gif"));
        vector11.addElement(new Subtype(58, null, null, "images/SCATTER_2Y_3D.gif", "images/SCATTER_2Y.gif"));
        vector11.addElement(new Subtype(61, null, null, "images/BUBBLE_3D.gif", "images/BUBBLE.gif"));
        vector11.addElement(new Subtype(62, null, null, "images/BUBBLE_2Y_3D.gif", "images/BUBBLE_2Y.gif"));
        Vector<Subtype> vector12 = new Vector<Subtype>();
        vector12.addElement(new Subtype(65, null, null, "images/STOCK_HILO_CLOSE.gif", "images/STOCK_HILO_CLOSE.gif"));
        vector12.addElement(new Subtype(66, null, null, "images/STOCK_HILO_CLOSE_VOLUME.gif", "images/STOCK_HILO_CLOSE_VOLUME.gif"));
        vector12.addElement(new Subtype(69, null, null, "images/STOCK_OPEN_HILO_CLOSE.gif", "images/STOCK_OPEN_HILO_CLOSE.gif"));
        vector12.addElement(new Subtype(80, null, null, "images/STOCK_VOLUME.gif", "images/STOCK_VOLUME.gif"));
        vector12.addElement(new Subtype(71, null, null, "images/STOCK_CANDLE.gif", "images/STOCK_CANDLE.gif"));
        vector12.addElement(new Subtype(72, null, null, "images/STOCK_CANDLE_VOLUME.gif", "images/STOCK_CANDLE_VOLUME.gif"));
        vector12.addElement(new Subtype(67, null, null, "images/STOCK_OHLC_CANDLE.gif", "images/STOCK_OHLC_CANDLE.gif"));
        vector12.addElement(new Subtype(68, null, null, "images/STOCK_OHLC_CANDLE_VOLUME.gif", "images/STOCK_OHLC_CANDLE_VOLUME.gif"));
        Vector<Subtype> vector13 = new Vector<Subtype>();
        vector13.addElement(new Subtype(81, null, null, "images/THREED_BAR.gif", "images/THREED_BAR.gif"));
        vector13.addElement(new Subtype(82, null, null, "images/THREED_CUBE.gif", "images/THREED_CUBE.gif"));
        vector13.addElement(new Subtype(83, null, null, "images/THREED_AREA_SERIES.gif", "images/THREED_AREA_SERIES.gif"));
        vector13.addElement(new Subtype(84, null, null, "images/THREED_RIBBON_SERIES.gif", "images/THREED_RIBBON_SERIES.gif"));
        vector13.addElement(new Subtype(85, null, null, "images/THREED_SURFACE.gif", "images/THREED_SURFACE.gif"));
        this.m_types = new Vector();
        this.m_types.addElement(new Type(0, null, "images/S_BAR_VERT_CLUST.gif", new String("images/es_bar_vert_clust.gif"), vector, true, true));
        this.m_types.addElement(new Type(1, null, "images/S_BAR_HORIZ_CLUST.gif", "images/es_bar_horiz_clust.gif", vector2, true, true));
        this.m_types.addElement(new Type(9, null, "images/S_PIE.gif", "images/es_pie.gif", vector8, true, true));
        this.m_types.addElement(new Type(2, null, "images/S_LINE_VERT_ABS.gif", "images/es_line_vert_abs.gif", vector3, true, true));
        this.m_types.addElement(new Type(5, null, "images/S_AREA_VERT_ABS.gif", "images/es_area_vert_abs.gif", vector5, true, true));
        this.m_types.addElement(new Type(7, null, "images/S_COMBO_GRAPH.gif", "images/es_combo_graph.gif", vector6, true, true));
        this.m_types.addElement(new Type(19, null, "images/S_SCATTER_BUBBLE.gif", "images/es_scatter_bubble.gif", vector11, true, true));
        this.m_types.addElement(new Type(14, null, "images/S_STOCK_HILO_CLOSE.gif", "images/es_stock_hilo_close.gif", vector12, false, true));
        this.m_types.addElement(new Type(18, null, "images/S_CIRCULAR.gif", "images/es_circular.gif", vector9, true, true));
        this.m_types.addElement(new Type(8, null, "images/S_PARETO.gif", "images/es_pareto.gif", vector7, true, true));
        this.m_types.addElement(new Type(15, null, "images/S_THREED_BAR.gif", "images/es_threed_bar.gif", vector13, true, false));
    }

    protected void loadStringResources() {
        Vector vector = this.getTypes();
        int n = 0;
        while (n < vector.size()) {
            Type type = (Type)vector.elementAt(n);
            String string = this.getTypeResource(type.id, RESOURCE_TYPE_NAME);
            if (string != null) {
                type.name = string;
            }
            int n2 = 0;
            while (n2 < type.subtypes.size()) {
                String string2;
                Subtype subtype = (Subtype)type.subtypes.elementAt(n2);
                String string3 = this.getSubtypeResource(subtype.id, RESOURCE_SUBTYPE_NAME);
                if (string3 != null) {
                    subtype.name = string3;
                }
                if ((string2 = this.getSubtypeResource(subtype.id, RESOURCE_SUBTYPE_DESC)) != null) {
                    subtype.description = string2;
                }
                ++n2;
            }
            ++n;
        }
    }

    protected String getTypeResource(int n, int n2) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.rBundle.getString("GraphTypeBar");
                break;
            }
            case 1: {
                string = this.rBundle.getString("Horizontal Bar");
                break;
            }
            case 2: {
                string = this.rBundle.getString("GraphTypeLine");
                break;
            }
            case 4: {
                string = this.rBundle.getString("Point");
                break;
            }
            case 5: {
                string = this.rBundle.getString("GraphTypeArea");
                break;
            }
            case 7: {
                string = this.rBundle.getString("Combination");
                break;
            }
            case 8: {
                string = this.rBundle.getString("Pareto");
                break;
            }
            case 9: {
                string = this.rBundle.getString("Pie");
                break;
            }
            case 10: {
                string = this.rBundle.getString("Polar");
                break;
            }
            case 11: {
                string = this.rBundle.getString("Radar");
                break;
            }
            case 12: {
                string = this.rBundle.getString("Scatter");
                break;
            }
            case 13: {
                string = this.rBundle.getString("Bubble");
                break;
            }
            case 14: {
                string = this.rBundle.getString("Stock Market");
                break;
            }
            case 15: {
                string = this.rBundle.getString("ThreeD");
                break;
            }
            case 18: {
                if (this.m_isThin) {
                    string = this.rBundle.getString("ThinCircular");
                    break;
                }
                string = this.rBundle.getString("Circular");
                break;
            }
            case 19: {
                string = this.m_isThin ? this.rBundle.getString("ThinScatterBubble") : this.rBundle.getString("ScatterBubble");
            }
        }
        return string;
    }

    protected String getSubtypeResource(int n, int n2) {
        String string = null;
        switch (n) {
            case 0: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_CLUST_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_CLUST_desc");
                break;
            }
            case 1: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_CLUST2Y_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_CLUST2Y_desc");
                break;
            }
            case 2: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_CLUST_SPLIT2Y_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_CLUST_SPLIT2Y_desc");
                break;
            }
            case 3: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_PERCENT_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_PERCENT_desc");
                break;
            }
            case 4: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_STACK_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_STACK_desc");
                break;
            }
            case 5: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_STACK2Y_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_STACK2Y_desc");
                break;
            }
            case 6: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_STACK_SPLIT2Y_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_STACK_SPLIT2Y_desc");
                break;
            }
            case 7: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_CLUST_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_CLUST_desc");
                break;
            }
            case 8: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_CLUST2Y_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_CLUST2Y_desc");
                break;
            }
            case 9: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_CLUST_SPLIT2Y_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_CLUST_SPLIT2Y_desc");
                break;
            }
            case 10: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_PERCENT_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_PERCENT_desc");
                break;
            }
            case 11: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_STACK_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_STACK_desc");
                break;
            }
            case 12: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_STACK2Y_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_STACK2Y_desc");
                break;
            }
            case 13: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BAR_VERT_STACK_SPLIT2Y_name");
                    break;
                }
                string = this.rBundle.getString("BAR_VERT_STACK_SPLIT2Y_desc");
                break;
            }
            case 14: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("LINE_VERT_ABS_name");
                    break;
                }
                string = this.rBundle.getString("LINE_VERT_ABS_desc");
                break;
            }
            case 15: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("LINE_VERT_ABS_2Y_name");
                    break;
                }
                string = this.rBundle.getString("LINE_VERT_ABS_2Y_desc");
                break;
            }
            case 16: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("LINE_VERT_ABS_SPLIT2Y_name");
                    break;
                }
                string = this.rBundle.getString("LINE_VERT_ABS_SPLIT2Y_desc");
                break;
            }
            case 17: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("LINE_VERT_PERCENT_name");
                    break;
                }
                string = this.rBundle.getString("LINE_VERT_PERCENT_desc");
                break;
            }
            case 18: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("LINE_VERT_STACK_name");
                    break;
                }
                string = this.rBundle.getString("LINE_VERT_STACK_desc");
                break;
            }
            case 19: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("LINE_VERT_STACK_2Y_name");
                    break;
                }
                string = this.rBundle.getString("LINE_VERT_STACK_2Y_desc");
                break;
            }
            case 20: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("LINE_VERT_STACK_SPLIT2Y_name");
                    break;
                }
                string = this.rBundle.getString("LINE_VERT_STACK_SPLIT2Y_desc");
                break;
            }
            case 28: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("POINT_VERT_ABS_name");
                    break;
                }
                string = this.rBundle.getString("POINT_VERT_ABS_desc");
                break;
            }
            case 29: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("POINT_VERT_ABS_2Y_name");
                    break;
                }
                string = this.rBundle.getString("POINT_VERT_ABS_2Y_desc");
                break;
            }
            case 30: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("POINT_VERT_ABS_SPLIT2Y_name");
                    break;
                }
                string = this.rBundle.getString("POINT_VERT_ABS_SPLIT2Y_desc");
                break;
            }
            case 31: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("AREA_VERT_ABS_name");
                    break;
                }
                string = this.rBundle.getString("AREA_VERT_ABS_desc");
                break;
            }
            case 32: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("AREA_VERT_ABS_SPLIT2Y_name");
                    break;
                }
                string = this.rBundle.getString("AREA_VERT_ABS_SPLIT2Y_desc");
                break;
            }
            case 33: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("AREA_VERT_PERCENT_name");
                    break;
                }
                string = this.rBundle.getString("AREA_VERT_PERCENT_desc");
                break;
            }
            case 34: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("AREA_VERT_STACK_name");
                    break;
                }
                string = this.rBundle.getString("AREA_VERT_STACK_desc");
                break;
            }
            case 35: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("AREA_VERT_STACK_SPLIT2Y_name");
                    break;
                }
                string = this.rBundle.getString("AREA_VERT_STACK_SPLIT2Y_desc");
                break;
            }
            case 41: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("COMBO_GRAPH_name");
                    break;
                }
                string = this.rBundle.getString("COMBO_GRAPG_desc");
                break;
            }
            case 42: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("COMBO_GRAPH_2Y_name");
                    break;
                }
                string = this.rBundle.getString("COMBO_GRAPG_2Y_desc");
                break;
            }
            case 43: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("PARETO_GRAPH_name");
                    break;
                }
                string = this.rBundle.getString("PARETO_GRAPH_desc");
                break;
            }
            case 44: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("PIE_name");
                    break;
                }
                string = this.rBundle.getString("PIE_desc");
                break;
            }
            case 45: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("PIE_MULTI_name");
                    break;
                }
                string = this.rBundle.getString("PIE_MULTI_desc");
                break;
            }
            case 46: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("PIE_BAR_name");
                    break;
                }
                string = this.rBundle.getString("PIE_BAR_desc");
                break;
            }
            case 47: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("RING_name");
                    break;
                }
                string = this.rBundle.getString("RING_desc");
                break;
            }
            case 48: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("RING_MULTI_name");
                    break;
                }
                string = this.rBundle.getString("RING_MULTI_desc");
                break;
            }
            case 49: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("RING_BAR_name");
                    break;
                }
                string = this.rBundle.getString("RING_BAR_desc");
                break;
            }
            case 52: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("POLAR_name");
                    break;
                }
                string = this.rBundle.getString("POLAR_desc");
                break;
            }
            case 54: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("RADAR_LINE_name");
                    break;
                }
                string = this.rBundle.getString("RADAR_LINE_desc");
                break;
            }
            case 57: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("SCATTER_name");
                    break;
                }
                string = this.rBundle.getString("SCATTER_desc");
                break;
            }
            case 58: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("SCATTER_2Y_name");
                    break;
                }
                string = this.rBundle.getString("SCATTER_2Y_desc");
                break;
            }
            case 61: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BUBBLE_name");
                    break;
                }
                string = this.rBundle.getString("BUBBLE_desc");
                break;
            }
            case 62: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("BUBBLE_2Y_name");
                    break;
                }
                string = this.rBundle.getString("BUBBLE_2Y_desc");
                break;
            }
            case 65: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("STOCK_HILO_CLOSE_name");
                    break;
                }
                string = this.rBundle.getString("STOCK_HILO_CLOSE_desc");
                break;
            }
            case 66: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("STOCK_HILO_CLOSE_VOLUME_name");
                    break;
                }
                string = this.rBundle.getString("STOCK_HILO_CLOSE_VOLUME_desc");
                break;
            }
            case 67: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("STOCK_OHLC_CANDLE_name");
                    break;
                }
                string = this.rBundle.getString("STOCK_OHLC_CANDLE_desc");
                break;
            }
            case 68: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("STOCK_OHLC_CANDLE_VOLUME_name");
                    break;
                }
                string = this.rBundle.getString("STOCK_OHLC_CANDLE_VOLUME_desc");
                break;
            }
            case 71: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("STOCK_CANDLE_name");
                    break;
                }
                string = this.rBundle.getString("STOCK_CANDLE_desc");
                break;
            }
            case 72: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("STOCK_CANDLE_VOLUME_name");
                    break;
                }
                string = this.rBundle.getString("STOCK_CANDLE_VOLUME_desc");
                break;
            }
            case 69: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("STOCK_OPEN_HILO_CLOSE_name");
                    break;
                }
                string = this.rBundle.getString("STOCK_OPEN_HILO_CLOSE_desc");
                break;
            }
            case 80: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("STOCK_VOLUME_name");
                    break;
                }
                string = this.rBundle.getString("STOCK_VOLUME_desc");
                break;
            }
            case 81: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("THREED_BAR_name");
                    break;
                }
                string = this.rBundle.getString("THREED_BAR_desc");
                break;
            }
            case 82: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("THREED_CUBE_name");
                    break;
                }
                string = this.rBundle.getString("THREED_CUBE_desc");
                break;
            }
            case 83: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("THREED_AREA_SERIES_name");
                    break;
                }
                string = this.rBundle.getString("THREED_AREA_SERIES_desc");
                break;
            }
            case 84: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("THREED_RIBBON_SERIES_name");
                    break;
                }
                string = this.rBundle.getString("THREED_RIBBON_SERIES_desc");
                break;
            }
            case 85: {
                if (n2 == RESOURCE_SUBTYPE_NAME) {
                    string = this.rBundle.getString("THREED_SURFACE_name");
                    break;
                }
                string = this.rBundle.getString("THREED_SURFACE_desc");
                break;
            }
        }
        return string;
    }

    protected void setPointType(UIGraph uIGraph, boolean bl) {
        uIGraph.setLineDataLineDisplayed(!bl);
    }

    protected void setCombinationType(UIGraph uIGraph, int n, boolean bl) {
        if (uIGraph.getGraphType() == n && n != 17 && n != 19) {
            return;
        }
        if (bl) {
            if ((n == 17 || n == 19) && this.isCombinationType(uIGraph)) {
                return;
            }
            try {
                int n2 = 0;
                while (n2 < uIGraph.getSeriesObjectCount()) {
                    uIGraph.getUISeries().setMarkerType(1, n2);
                    uIGraph.getUISeries().setMarkerType(2, n2 + 1);
                    uIGraph.getUISeries().setMarkerType(3, n2 + 2);
                    n2 += 3;
                }
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {}
        } else {
            try {
                int n3 = 0;
                while (n3 < uIGraph.getSeriesObjectCount()) {
                    if (uIGraph.getUISeries().getMarkerType(n3) != 0) {
                        uIGraph.getUISeries().setMarkerType(0, n3);
                    }
                    ++n3;
                }
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                // empty catch block
            }
        }
    }

    protected GraphTypeAndSubtype initialize(UIGraph uIGraph) {
        int n = 0;
        int n2 = 0;
        switch (uIGraph.getGraphType()) {
            case 17: {
                if (this.isCombinationType(uIGraph)) {
                    n = 7;
                    n2 = 41;
                    break;
                }
                n = 0;
                n2 = 0;
                break;
            }
            case 19: {
                if (this.isCombinationType(uIGraph)) {
                    n = 7;
                    n2 = 42;
                    break;
                }
                n = 0;
                n2 = 1;
                break;
            }
            case 21: {
                n = 0;
                n2 = 2;
                break;
            }
            case 23: {
                n = 0;
                n2 = 3;
                break;
            }
            case 18: {
                n = 0;
                n2 = 4;
                break;
            }
            case 20: {
                n = 0;
                n2 = 5;
                break;
            }
            case 22: {
                n = 0;
                n2 = 6;
                break;
            }
            case 24: {
                n = 1;
                n2 = 7;
                break;
            }
            case 26: {
                n = 1;
                n2 = 8;
                break;
            }
            case 28: {
                n = 1;
                n2 = 9;
                break;
            }
            case 30: {
                n = 1;
                n2 = 10;
                break;
            }
            case 25: {
                n = 1;
                n2 = 11;
                break;
            }
            case 27: {
                n = 1;
                n2 = 12;
                break;
            }
            case 29: {
                n = 1;
                n2 = 13;
                break;
            }
            case 41: {
                if (this.isPointType()) {
                    n = 4;
                    n2 = 28;
                    break;
                }
                n = 2;
                n2 = 14;
                break;
            }
            case 43: {
                if (this.isPointType()) {
                    n = 4;
                    n2 = 29;
                    break;
                }
                n = 2;
                n2 = 15;
                break;
            }
            case 45: {
                if (this.isPointType()) {
                    n = 4;
                    n2 = 30;
                    break;
                }
                n = 2;
                n2 = 16;
                break;
            }
            case 47: {
                n = 2;
                n2 = 17;
                break;
            }
            case 42: {
                n = 2;
                n2 = 18;
                break;
            }
            case 44: {
                n = 2;
                n2 = 19;
                break;
            }
            case 46: {
                n = 2;
                n2 = 20;
                break;
            }
            case 48: {
                n = 3;
                n2 = 21;
                break;
            }
            case 50: {
                n = 3;
                n2 = 22;
                break;
            }
            case 52: {
                n = 3;
                n2 = 23;
                break;
            }
            case 54: {
                n = 3;
                n2 = 24;
                break;
            }
            case 49: {
                n = 3;
                n2 = 25;
                break;
            }
            case 51: {
                n = 3;
                n2 = 26;
                break;
            }
            case 53: {
                n = 3;
                n2 = 27;
                break;
            }
            case 31: {
                n = 5;
                n2 = 31;
                break;
            }
            case 33: {
                n = 5;
                n2 = 32;
                break;
            }
            case 35: {
                n = 5;
                n2 = 33;
                break;
            }
            case 32: {
                n = 5;
                n2 = 34;
                break;
            }
            case 34: {
                n = 5;
                n2 = 35;
                break;
            }
            case 36: {
                n = 6;
                n2 = 36;
                break;
            }
            case 38: {
                n = 6;
                n2 = 37;
                break;
            }
            case 40: {
                n = 6;
                n2 = 38;
                break;
            }
            case 37: {
                n = 6;
                n2 = 39;
                break;
            }
            case 39: {
                n = 6;
                n2 = 40;
                break;
            }
            case 102: {
                n = 8;
                n2 = 43;
                break;
            }
            case 55: {
                n = 9;
                n2 = 44;
                break;
            }
            case 57: {
                n = 9;
                n2 = 45;
                break;
            }
            case 93: {
                n = 9;
                n2 = 46;
                break;
            }
            case 56: {
                n = 9;
                n2 = 47;
                break;
            }
            case 58: {
                n = 9;
                n2 = 48;
                break;
            }
            case 94: {
                n = 9;
                n2 = 49;
                break;
            }
            case 59: {
                n = 9;
                n2 = 50;
                break;
            }
            case 60: {
                n = 9;
                n2 = 51;
                break;
            }
            case 65: {
                n = 18;
                n2 = 52;
                break;
            }
            case 66: {
                n = 18;
                n2 = 53;
                break;
            }
            case 67: {
                n = 18;
                n2 = 54;
                break;
            }
            case 68: {
                n = 18;
                n2 = 55;
                break;
            }
            case 69: {
                n = 18;
                n2 = 56;
                break;
            }
            case 61: {
                n = 19;
                n2 = 57;
                break;
            }
            case 62: {
                n = 19;
                n2 = 58;
                break;
            }
            case 63: {
                n = 19;
                n2 = 59;
                break;
            }
            case 64: {
                n = 19;
                n2 = 60;
                break;
            }
            case 89: {
                n = 19;
                n2 = 61;
                break;
            }
            case 91: {
                n = 19;
                n2 = 62;
                break;
            }
            case 90: {
                n = 19;
                n2 = 63;
                break;
            }
            case 92: {
                n = 19;
                n2 = 64;
                break;
            }
            case 76: {
                n = 14;
                n2 = 65;
                break;
            }
            case 88: {
                n = 14;
                n2 = 66;
                break;
            }
            case 70: {
                n = 14;
                n2 = 67;
                break;
            }
            case 71: {
                n = 14;
                n2 = 68;
                break;
            }
            case 79: {
                n = 14;
                n2 = 69;
                break;
            }
            case 80: {
                n = 14;
                n2 = 70;
                break;
            }
            case 72: {
                n = 14;
                n2 = 71;
                break;
            }
            case 84: {
                n = 14;
                n2 = 72;
                break;
            }
            case 73: {
                n = 14;
                n2 = 73;
                break;
            }
            case 74: {
                n = 14;
                n2 = 74;
                break;
            }
            case 77: {
                n = 14;
                n2 = 75;
                break;
            }
            case 78: {
                n = 14;
                n2 = 76;
                break;
            }
            case 75: {
                n = 14;
                n2 = 77;
                break;
            }
            case 82: {
                n = 14;
                n2 = 78;
                break;
            }
            case 81: {
                n = 14;
                n2 = 79;
                break;
            }
            case 83: {
                n = 14;
                n2 = 80;
                break;
            }
            case 0: {
                n = 15;
                n2 = 81;
                break;
            }
            case 4: {
                n = 15;
                n2 = 82;
                break;
            }
            case 6: {
                n = 15;
                n2 = 83;
                break;
            }
            case 7: {
                n = 15;
                n2 = 84;
                break;
            }
            case 12: {
                n = 15;
                n2 = 85;
                break;
            }
            case 13: {
                n = 15;
                n2 = 86;
                break;
            }
            case 9: {
                n = 15;
                n2 = 87;
                break;
            }
            case 5: {
                n = 15;
                n2 = 88;
                break;
            }
            case 2: {
                n = 15;
                n2 = 89;
                break;
            }
            case 1: {
                n = 15;
                n2 = 90;
                break;
            }
            case 10: {
                n = 15;
                n2 = 91;
                break;
            }
            case 14: {
                n = 15;
                n2 = 92;
                break;
            }
            case 86: {
                n = 16;
                n2 = 93;
                break;
            }
            case 85: {
                n = 16;
                n2 = 94;
                break;
            }
            case 87: {
                n = 17;
                n2 = 95;
            }
        }
        return new GraphTypeAndSubtype(n, n2);
    }

    protected void apply(UIGraph uIGraph, int n, int n2) {
        int n3 = this.prepareToApply(uIGraph, n, n2);
        if (uIGraph.getGraphType() != n3) {
            uIGraph.setGraphType(n3);
        }
    }

    protected int prepareToApply(UIGraph uIGraph, int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        n3 = 17;
                        break;
                    }
                    case 1: {
                        n3 = 19;
                        break;
                    }
                    case 2: {
                        n3 = 21;
                        break;
                    }
                    case 3: {
                        n3 = 23;
                        break;
                    }
                    case 4: {
                        n3 = 18;
                        break;
                    }
                    case 5: {
                        n3 = 20;
                        break;
                    }
                    case 6: {
                        n3 = 22;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 1: {
                switch (n2) {
                    case 7: {
                        n3 = 24;
                        break;
                    }
                    case 8: {
                        n3 = 26;
                        break;
                    }
                    case 9: {
                        n3 = 28;
                        break;
                    }
                    case 10: {
                        n3 = 30;
                        break;
                    }
                    case 11: {
                        n3 = 25;
                        break;
                    }
                    case 12: {
                        n3 = 27;
                        break;
                    }
                    case 13: {
                        n3 = 29;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 2: {
                switch (n2) {
                    case 14: {
                        n3 = 41;
                        break;
                    }
                    case 15: {
                        n3 = 43;
                        break;
                    }
                    case 16: {
                        n3 = 45;
                        break;
                    }
                    case 17: {
                        n3 = 47;
                        break;
                    }
                    case 18: {
                        n3 = 42;
                        break;
                    }
                    case 19: {
                        n3 = 44;
                        break;
                    }
                    case 20: {
                        n3 = 46;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 3: {
                switch (n2) {
                    case 21: {
                        n3 = 48;
                        break;
                    }
                    case 22: {
                        n3 = 50;
                        break;
                    }
                    case 23: {
                        n3 = 52;
                        break;
                    }
                    case 24: {
                        n3 = 54;
                        break;
                    }
                    case 25: {
                        n3 = 49;
                        break;
                    }
                    case 26: {
                        n3 = 51;
                        break;
                    }
                    case 27: {
                        n3 = 53;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 4: {
                switch (n2) {
                    case 28: {
                        n3 = 41;
                        break;
                    }
                    case 29: {
                        n3 = 43;
                        break;
                    }
                    case 30: {
                        n3 = 45;
                    }
                }
                this.setPointType(uIGraph, true);
                this.setCombinationType(uIGraph, n3, false);
                uIGraph.setMarkerDisplayed(true);
                break;
            }
            case 5: {
                switch (n2) {
                    case 31: {
                        n3 = 31;
                        break;
                    }
                    case 32: {
                        n3 = 33;
                        break;
                    }
                    case 33: {
                        n3 = 35;
                        break;
                    }
                    case 34: {
                        n3 = 32;
                        break;
                    }
                    case 35: {
                        n3 = 34;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 6: {
                switch (n2) {
                    case 36: {
                        n3 = 36;
                        break;
                    }
                    case 37: {
                        n3 = 38;
                        break;
                    }
                    case 38: {
                        n3 = 40;
                        break;
                    }
                    case 39: {
                        n3 = 37;
                        break;
                    }
                    case 40: {
                        n3 = 39;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 7: {
                switch (n2) {
                    case 41: {
                        n3 = 17;
                        break;
                    }
                    case 42: {
                        n3 = 19;
                    }
                }
                this.setCombinationType(uIGraph, n3, true);
                break;
            }
            case 8: {
                switch (n2) {
                    case 43: {
                        n3 = 102;
                    }
                }
                this.setPointType(uIGraph, false);
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 9: {
                switch (n2) {
                    case 44: {
                        n3 = 55;
                        break;
                    }
                    case 45: {
                        n3 = 57;
                        break;
                    }
                    case 46: {
                        n3 = 93;
                        break;
                    }
                    case 47: {
                        n3 = 56;
                        break;
                    }
                    case 48: {
                        n3 = 58;
                        break;
                    }
                    case 49: {
                        n3 = 94;
                        break;
                    }
                    case 50: {
                        n3 = 59;
                        break;
                    }
                    case 51: {
                        n3 = 60;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 18: {
                switch (n2) {
                    case 52: {
                        n3 = 65;
                        break;
                    }
                    case 53: {
                        n3 = 66;
                        break;
                    }
                    case 54: {
                        n3 = 67;
                        break;
                    }
                    case 55: {
                        n3 = 68;
                        break;
                    }
                    case 56: {
                        n3 = 69;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 10: {
                switch (n2) {
                    case 52: {
                        n3 = 65;
                        break;
                    }
                    case 53: {
                        n3 = 66;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 11: {
                switch (n2) {
                    case 54: {
                        n3 = 67;
                        break;
                    }
                    case 55: {
                        n3 = 68;
                        break;
                    }
                    case 56: {
                        n3 = 69;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 19: {
                switch (n2) {
                    case 57: {
                        n3 = 61;
                        break;
                    }
                    case 58: {
                        n3 = 62;
                        break;
                    }
                    case 59: {
                        n3 = 63;
                        break;
                    }
                    case 60: {
                        n3 = 64;
                        break;
                    }
                    case 61: {
                        n3 = 89;
                        break;
                    }
                    case 62: {
                        n3 = 91;
                        break;
                    }
                    case 63: {
                        n3 = 90;
                        break;
                    }
                    case 64: {
                        n3 = 92;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 12: {
                switch (n2) {
                    case 57: {
                        n3 = 61;
                        break;
                    }
                    case 58: {
                        n3 = 62;
                        break;
                    }
                    case 59: {
                        n3 = 63;
                        break;
                    }
                    case 60: {
                        n3 = 64;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 13: {
                switch (n2) {
                    case 61: {
                        n3 = 89;
                        break;
                    }
                    case 62: {
                        n3 = 91;
                        break;
                    }
                    case 63: {
                        n3 = 90;
                        break;
                    }
                    case 64: {
                        n3 = 92;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 14: {
                switch (n2) {
                    case 65: {
                        n3 = 76;
                        break;
                    }
                    case 66: {
                        n3 = 88;
                        break;
                    }
                    case 67: {
                        n3 = 70;
                        break;
                    }
                    case 68: {
                        n3 = 71;
                        break;
                    }
                    case 69: {
                        n3 = 79;
                        break;
                    }
                    case 70: {
                        n3 = 80;
                        break;
                    }
                    case 71: {
                        n3 = 72;
                        break;
                    }
                    case 72: {
                        n3 = 84;
                        break;
                    }
                    case 73: {
                        n3 = 73;
                        break;
                    }
                    case 74: {
                        n3 = 74;
                        break;
                    }
                    case 75: {
                        n3 = 77;
                        break;
                    }
                    case 76: {
                        n3 = 78;
                        break;
                    }
                    case 77: {
                        n3 = 75;
                        break;
                    }
                    case 78: {
                        n3 = 82;
                        break;
                    }
                    case 79: {
                        n3 = 81;
                        break;
                    }
                    case 80: {
                        n3 = 83;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 15: {
                switch (n2) {
                    case 81: {
                        n3 = 0;
                        break;
                    }
                    case 82: {
                        n3 = 4;
                        break;
                    }
                    case 83: {
                        n3 = 6;
                        break;
                    }
                    case 84: {
                        n3 = 7;
                        break;
                    }
                    case 85: {
                        n3 = 12;
                        break;
                    }
                    case 86: {
                        n3 = 13;
                        break;
                    }
                    case 87: {
                        n3 = 9;
                        break;
                    }
                    case 88: {
                        n3 = 5;
                        break;
                    }
                    case 89: {
                        n3 = 2;
                        break;
                    }
                    case 90: {
                        n3 = 1;
                        break;
                    }
                    case 91: {
                        n3 = 10;
                        break;
                    }
                    case 92: {
                        n3 = 14;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 16: {
                switch (n2) {
                    case 93: {
                        n3 = 86;
                        break;
                    }
                    case 94: {
                        n3 = 85;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
                break;
            }
            case 17: {
                switch (n2) {
                    case 95: {
                        n3 = 87;
                    }
                }
                this.setCombinationType(uIGraph, n3, false);
            }
        }
        return n3;
    }

    protected void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    protected int getTypeIndex(int n) {
        int n2 = this.getTypes().size();
        int n3 = 0;
        while (n3 < n2) {
            Type type = (Type)this.getTypes().elementAt(n3);
            if (n == type.id) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected void cleanUp() {
        this.m_graph = null;
        this.rBundle = null;
        if (this.m_types != null) {
            int n = 0;
            while (n < this.m_types.size()) {
                Type type = (Type)this.m_types.elementAt(n);
                if (type != null) {
                    if (type.subtypes != null) {
                        type.subtypes.clear();
                    }
                    type.subtypes = null;
                }
                ++n;
            }
            this.m_types.clear();
        }
        this.m_types = null;
    }

    public void setThin(boolean bl) {
        this.m_isThin = bl;
    }

    static {
        RESOURCE_SUBTYPE_DESC = 1;
    }
}

