/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.gui.BoldFontTool;
import oracle.dss.dataView.gui.FillColorTool;
import oracle.dss.dataView.gui.FontColorTool;
import oracle.dss.dataView.gui.FontNameTool;
import oracle.dss.dataView.gui.FontSizeTool;
import oracle.dss.dataView.gui.FontUnderLineTool;
import oracle.dss.dataView.gui.HorizontalAlignmentTool;
import oracle.dss.dataView.gui.ItalicFontTool;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.AreaMarker;
import oracle.dss.graph.Base3DPanel;
import oracle.dss.graph.BaseAxisTitle;
import oracle.dss.graph.BaseTickLabel;
import oracle.dss.graph.DataLine;
import oracle.dss.graph.DataMarker;
import oracle.dss.graph.Graph;
import oracle.dss.graph.LegendArea;
import oracle.dss.graph.LegendText;
import oracle.dss.graph.O1Axis;
import oracle.dss.graph.O1TickLabel;
import oracle.dss.graph.PieFrame;
import oracle.dss.graph.PlotArea;
import oracle.dss.graph.Slice;
import oracle.dss.graph.ThreeDMarker;
import oracle.dss.graph.TwoDMarker;
import oracle.dss.graph.UIGraph;
import oracle.dss.graph.Y1Axis;
import oracle.dss.graph.ZTickLabel;
import oracle.dss.graph.gui.GradientTool;
import oracle.dss.graph.gui.GraphTypeTool;
import oracle.dss.graph.gui.GridLineTool;
import oracle.dss.graph.gui.LegendTool;
import oracle.dss.graph.gui.ThreeDEffectTool;
import oracle.dss.util.gui.FontButton;

public class GraphToolBar
extends ToolBar {
    private FontColorTool m_fontColorTool;
    private FillColorTool m_fillColorTool;
    private LegendTool m_legendTool;
    private GraphTypeTool m_graphTypeTool;
    private GridLineTool m_gridLineTool;
    private ThreeDEffectTool m_3DEffectTool;
    private GradientTool m_gradientTool;
    private HorizontalAlignmentTool m_horizontalAlignmentTool;
    private FontNameTool fontNameTool;
    private FontSizeTool fontSizeTool;
    private BoldFontTool boldFontTool;
    private ItalicFontTool italicFontTool;
    private FontUnderLineTool fontUnderLineTool;
    private MouseListener m_mouseListener;

    public GraphToolBar(UIGraph uIGraph) {
        super(uIGraph);
        this.initialize();
        this.setSelectedObject(new ControllerEvent(uIGraph, uIGraph.getSelectedObject()));
    }

    public GraphToolBar() {
        this.initialize();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getPropertyName().equals("GraphType")) {
            this.m_legendTool.update();
            this.m_gridLineTool.update();
            this.m_3DEffectTool.update();
            if ((Integer)propertyChangeEvent.getNewValue() == 9 || (Integer)propertyChangeEvent.getNewValue() == 10) {
                if (((UIGraph)this.m_dataView).getSelectedObject() == null || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof LegendArea || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof LegendText) {
                    this.m_fillColorTool.setEnabled(false);
                    this.m_fontColorTool.setEnabled(false);
                } else {
                    this.m_fillColorTool.setEnabled(true);
                    this.m_fontColorTool.setEnabled(true);
                }
            } else {
                this.m_fillColorTool.setEnabled(true);
                this.m_fontColorTool.setEnabled(true);
            }
            this.m_fillColorTool.update();
            this.m_fontColorTool.update();
            if (this.m_dataView.getSelectedObject() == null || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() == null || ((UIGraph)this.m_dataView).getSelectedObject() instanceof NonDataComponentHandle || ((UIGraph)this.m_dataView).getAutoLayout() == 2 && ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof BaseTickLabel || ((UIGraph)this.m_dataView).getGraphType() == 0 && ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof BaseAxisTitle) {
                this.m_horizontalAlignmentTool.setEnabled(false);
            } else {
                this.m_horizontalAlignmentTool.setEnabled(true);
            }
            this.m_horizontalAlignmentTool.update();
        }
    }

    public void setColorPalette(Color[][] colorArray) {
        ArrayTwoDModel arrayTwoDModel = colorArray != null ? FontButton.getArrayTwoDModel(colorArray) : null;
        this.m_fontColorTool.setColorPalette((TwoDModel)arrayTwoDModel);
        this.m_fillColorTool.setColorPalette((TwoDModel)arrayTwoDModel);
    }

    public Color[][] getColorPalette() {
        return FontButton.getColorArray(this.m_fontColorTool.getColorPalette());
    }

    private boolean isAlignmentEnabled() {
        return !(this.m_dataView.getSelectedObject() == null || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() == null || ((UIGraph)this.m_dataView).getAutoLayout() == 2 && ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof BaseTickLabel || ((UIGraph)this.m_dataView).getGraphType() == 0 && ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof BaseAxisTitle || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof TwoDMarker || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof PlotArea || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof PieFrame || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof Base3DPanel || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof ThreeDMarker || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof Slice || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof AreaMarker || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof DataMarker || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof DataLine || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof Y1Axis || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof O1Axis || ((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof ZTickLabel) && !(((UIGraph)this.m_dataView).getSelectedObject().getComponent() instanceof TwoDMarker);
    }

    public void setSelectedObject(ControllerEvent controllerEvent) {
        if (this.m_dataView instanceof UIGraph) {
            if (this.m_horizontalAlignmentTool != null) {
                if (this.isAlignmentEnabled()) {
                    this.m_horizontalAlignmentTool.setEnabled(true);
                } else {
                    this.m_horizontalAlignmentTool.setEnabled(false);
                }
            }
            if (this.m_fillColorTool != null) {
                if (this.m_dataView.getSelectedObject() == null || (((UIGraph)this.m_dataView).getGraphType() == 93 || ((UIGraph)this.m_dataView).getGraphType() == 94) && this.m_dataView.getSelectedObject().getComponent() instanceof TwoDMarker) {
                    this.m_fillColorTool.setEnabled(false);
                } else {
                    this.m_fillColorTool.setEnabled(true);
                }
            }
            if (this.fontUnderLineTool != null) {
                if (this.m_dataView.getSelectedObject() != null) {
                    boolean bl = ((Graph)this.m_dataView).isDrillingEnabled();
                    Object object = ((UIGraph)this.m_dataView).getSelectedObject().getComponent();
                    if (object instanceof O1TickLabel || object instanceof LegendText) {
                        if (bl) {
                            this.fontUnderLineTool.setEnabled(false);
                        } else {
                            this.fontUnderLineTool.setEnabled(true);
                        }
                    } else {
                        this.fontUnderLineTool.setEnabled(true);
                    }
                } else {
                    this.fontUnderLineTool.setEnabled(false);
                }
            }
        } else {
            if (this.m_graphTypeTool != null) {
                this.m_graphTypeTool.setEnabled(false);
            }
            if (this.m_legendTool != null) {
                this.m_legendTool.setEnabled(false);
            }
            if (this.m_gridLineTool != null) {
                this.m_gridLineTool.setEnabled(false);
            }
        }
        super.setSelectedObject(controllerEvent);
    }

    private void initialize() {
        this.fontNameTool = new FontNameTool();
        this.fontNameTool.addPropertyChangeListener(this);
        this.add(this.fontNameTool);
        this.fontSizeTool = new FontSizeTool();
        this.fontSizeTool.addPropertyChangeListener(this);
        this.add(this.fontSizeTool);
        this.addToolBarSeparator();
        this.boldFontTool = new BoldFontTool();
        this.boldFontTool.addPropertyChangeListener(this);
        this.add(this.boldFontTool);
        this.italicFontTool = new ItalicFontTool();
        this.italicFontTool.addPropertyChangeListener(this);
        this.add(this.italicFontTool);
        this.fontUnderLineTool = new FontUnderLineTool();
        this.fontUnderLineTool.addPropertyChangeListener(this);
        this.add(this.fontUnderLineTool);
        this.addToolBarSeparator();
        this.m_horizontalAlignmentTool = new HorizontalAlignmentTool();
        this.m_horizontalAlignmentTool.addPropertyChangeListener(this);
        this.add(this.m_horizontalAlignmentTool);
        this.addToolBarSeparator();
        this.m_fillColorTool = new FillColorTool();
        this.m_fillColorTool.addPropertyChangeListener(this);
        this.add(this.m_fillColorTool);
        this.m_fontColorTool = new FontColorTool();
        this.m_fontColorTool.addPropertyChangeListener(this);
        this.add(this.m_fontColorTool);
        this.addToolBarSeparator();
        this.m_graphTypeTool = new GraphTypeTool();
        this.m_graphTypeTool.addPropertyChangeListener(this);
        this.add(this.m_graphTypeTool);
        this.m_legendTool = new LegendTool();
        this.m_legendTool.addPropertyChangeListener(this);
        this.add(this.m_legendTool);
        this.m_gridLineTool = new GridLineTool();
        this.m_gridLineTool.addPropertyChangeListener(this);
        this.add(this.m_gridLineTool);
        this.addToolBarSeparator();
        this.m_gradientTool = new GradientTool();
        this.m_gradientTool.addPropertyChangeListener(this);
        this.add(this.m_gradientTool);
        this.m_3DEffectTool = new ThreeDEffectTool();
        this.m_3DEffectTool.addPropertyChangeListener(this);
        this.add(this.m_3DEffectTool);
        this.m_mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GraphToolBar.this.requestFocus();
            }
        };
        this.fontNameTool.addMouseListener(this.m_mouseListener);
        this.fontSizeTool.addMouseListener(this.m_mouseListener);
        this.boldFontTool.addMouseListener(this.m_mouseListener);
        this.italicFontTool.addMouseListener(this.m_mouseListener);
        this.fontUnderLineTool.addMouseListener(this.m_mouseListener);
        this.m_fontColorTool.addMouseListener(this.m_mouseListener);
        this.m_fillColorTool.addMouseListener(this.m_mouseListener);
        this.m_graphTypeTool.addMouseListener(this.m_mouseListener);
        this.m_legendTool.addMouseListener(this.m_mouseListener);
        this.m_gridLineTool.addMouseListener(this.m_mouseListener);
    }

    public void cleanUp() {
        super.cleanUp();
        if (this.m_mouseListener != null) {
            this.fontNameTool.removeMouseListener(this.m_mouseListener);
            this.fontSizeTool.removeMouseListener(this.m_mouseListener);
            this.boldFontTool.removeMouseListener(this.m_mouseListener);
            this.italicFontTool.removeMouseListener(this.m_mouseListener);
            this.fontUnderLineTool.removeMouseListener(this.m_mouseListener);
            this.m_fontColorTool.removeMouseListener(this.m_mouseListener);
            this.m_fillColorTool.removeMouseListener(this.m_mouseListener);
            this.m_graphTypeTool.removeMouseListener(this.m_mouseListener);
            this.m_legendTool.removeMouseListener(this.m_mouseListener);
            this.m_gridLineTool.removeMouseListener(this.m_mouseListener);
            this.m_gradientTool.removeMouseListener(this.m_mouseListener);
            this.m_3DEffectTool.removeMouseListener(this.m_mouseListener);
            this.m_mouseListener = null;
        }
    }
}

