/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.pivot.PagingComponent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.scrolling.ArrowBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.GraphImageLabel;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayoutAccess;
import oracle.dss.util.LayoutContext;
import oracle.dss.util.gui.layout.Layout;
import oracle.dss.util.gui.layout.LayoutPageItem;
import oracle.dss.util.gui.layout.LayoutPagingComponent;
import oracle.dss.util.help.HelpContext;

public class GraphLayout
extends Layout
implements HelpContext {
    public static final int DEFAULT = 0;
    public static final int POLAR = 1;
    public static final int SCATTER = 2;
    public static final int BUBBLE = 3;
    public static final int STOCK = 4;
    public static final int PIE = 5;
    private int m_type;
    protected Graph m_graph;
    protected LayoutPagingComponent m_seriesEdgeLayers;
    protected LayoutPagingComponent m_groupEdgeLayers;
    protected JPanel m_measurePanel;
    protected JScrollPane m_scrollPane;
    protected JLabel m_measureLabel;
    protected MeasurePanel m_innerMeasurePanel;
    protected JPanel m_imagePanel;
    protected JPanel m_southPanel;
    protected JPanel m_middlePanel;
    protected JPanel m_seriesPanel;
    protected JPanel m_groupPanel;
    protected JLabel m_image;
    protected JComponent m_imageComponent;
    protected int m_maxMeasureWidth;
    protected int m_measurePanelWidth;
    protected int m_measurePanelHeight;
    protected boolean m_bSeriesVisible = true;
    protected boolean m_bGroupVisible = true;
    protected JLabel m_seriesLabel;
    protected JLabel m_groupLabel;
    protected String m_seriesTxt = new String();
    protected String m_groupTxt = new String();
    protected String m_seriesPopupTxt = new String();
    protected String m_groupPopupTxt = new String();
    protected String m_imageFile = new String();
    protected String m_errorString = new String();
    protected String m_measureText;
    private ResourceBundle rBundle;
    protected String m_applicationName;
    protected String m_helpID;
    protected String m_rPoints = "";
    protected String m_rLines = "";
    protected String m_rGroups = "";
    protected String m_rBars = "";
    protected String m_rSlices = "";
    protected String m_rPies = "";
    protected String m_rRings = "";
    protected String m_rBubbles = "";
    protected String m_rOctagons = "";
    protected String m_rCubes = "";
    protected String m_rDiamonds = "";
    protected String m_rAreas = "";
    protected String m_rSeries = "";
    protected String m_rRibbons = "";
    protected String m_rPyramids = "";
    protected String m_rMeasuresColon = "";
    protected String m_rMeasures = "";
    protected String m_rMeasure = "";
    protected String m_rInsufficient = "";
    protected String m_rUnique = "";
    protected String m_rPanelWidth = "";
    protected String m_rHidePaging = "";
    protected String m_rShowPaging = "";
    protected String m_pPoints = "";
    protected String m_pLines = "";
    protected String m_pGroups = "";
    protected String m_pBars = "";
    protected String m_pSlices = "";
    protected String m_pPies = "";
    protected String m_pRings = "";
    protected String m_pBubbles = "";
    protected String m_pOctagons = "";
    protected String m_pCubes = "";
    protected String m_pDiamonds = "";
    protected String m_pAreas = "";
    protected String m_pSeries = "";
    protected String m_pRibbons = "";
    protected String m_pPyramids = "";
    protected String m_pMeasuresColon = "";
    protected ErrorHandler m_eh;
    protected boolean m_bHelpEnabled = true;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    private AncestorListener m_ancestorListener;
    private static final String a_barclust = "BarClust";
    private static final String a_barstack = "BarStack";
    private static final String a_line = "Line";
    private static final String a_point = "Point";
    private static final String a_area = "Area";
    private static final String a_combination = "Combination";
    private static final String a_pareto = "Pareto";
    private static final String a_piering = "PieRing";
    private static final String a_pieringbar = "PieRingBar";
    private static final String a_multipie = "MultiPie";
    private static final String a_multiring = "MultiRing";
    private static final String a_polar = "Polar";
    private static final String a_radar = "Radar";
    private static final String a_scatter = "Scatter";
    private static final String a_bubble = "Bubble";
    private static final String a_stockhilo = "Stock_HILO_Close";
    private static final String a_stockhilovolume = "Stock_HILO_Close_Volume";
    private static final String a_stockohlc = "Stock_OHLC_Candle";
    private static final String a_stockohlcvolume = "Stock_OHLC_Candle_Volume";
    private static final String a_3Dbar = "ThreeD_Bar";
    private static final String a_3Dcube = "ThreeD_Cube";
    private static final String a_3Darea = "ThreeD_Area";
    private static final String a_3Dribbon = "ThreeD_Ribbon";
    private static final String a_3Dsurface = "ThreeD_Surface";
    private static final String a_other = "Other";
    private static final String m_isCombinationType = "isCombinationType";
    private static final String m_applyChangesToLayoutAccess = "applyChangesToLayoutAccess";

    public GraphLayout() {
        this.init();
        this.updateTextUsingCorrectLocale();
    }

    private void init() {
        this.m_imagePanel = new JPanel();
        this.m_imagePanel.setLayout(new BoxLayout(this.m_imagePanel, 1));
        this.m_measurePanel = new JPanel(new BorderLayout());
        this.m_middlePanel = new JPanel();
        this.m_middlePanel.setAlignmentX(0.0f);
        this.m_middlePanel.setLayout(new BoxLayout(this.m_middlePanel, 0));
        this.m_middlePanel.add(this.m_measurePanel);
        this.m_middlePanel.add(this.m_imagePanel);
        this.m_middlePanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 190));
        this.m_middlePanel.setMaximumSize(this.m_middlePanel.getPreferredSize());
        this.m_middlePanel.setMinimumSize(this.m_middlePanel.getPreferredSize());
        this.m_southPanel = new JPanel();
        this.m_southPanel.setLayout(new BoxLayout(this.m_southPanel, 1));
        this.add(this.m_middlePanel);
        this.add(this.m_southPanel);
        this.m_seriesEdgeLayers = new LayoutPagingComponent(1);
        this.m_groupEdgeLayers = new LayoutPagingComponent(0);
        this.setDelayChangesToLayoutAccess(true);
        this.m_componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GraphLayout.this.resizeDescriptionLabel();
            }
        };
        this.addComponentListener(this.m_componentListener);
        this.m_ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (GraphLayout.this.isShowing()) {
                    GraphLayout.this.setDelayChangesToLayoutAccess(true);
                }
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                if (GraphLayout.this.isShowing()) {
                    GraphLayout.this.setDelayChangesToLayoutAccess(true);
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                GraphLayout.this.setDelayChangesToLayoutAccess(false);
            }
        };
        this.addAncestorListener(this.m_ancestorListener);
    }

    public String getDescriptionText() {
        return this.rBundle.getString("change Layout items");
    }

    public void setApplicationName(String string) {
        this.m_applicationName = string;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public void setGraph(Graph graph) {
        this.m_graph = graph;
        this.m_type = this.convertGraphTypeToType(graph.getGraphType());
        this.m_showPageItemsChkBox.setSelected(this.m_graph.isPagingControlVisible());
        this.updateImageFileAndHelpID();
        this.m_popupManager.setPageLayoutComponent(this.m_pageEdgeLayers);
        this.m_popupManager.setRowLayoutComponent(this.m_seriesEdgeLayers);
        this.m_popupManager.setColumnLayoutComponent(this.m_groupEdgeLayers);
        this.m_seriesEdgeLayers.setKeyBoardActionListener(this.m_popupManager);
        this.m_groupEdgeLayers.setKeyBoardActionListener(this.m_popupManager);
        this.m_seriesEdgeLayers.setMouseListener(this.m_popupManager);
        this.m_groupEdgeLayers.setMouseListener(this.m_popupManager);
        this.setLocale(this.m_graph.getLocale());
        this.revalidate();
    }

    public LayoutAccess getLayoutAccess() {
        this.applyChangesToLayoutAccess();
        return this.m_layoutAccess;
    }

    public boolean apply() {
        if (!this.applyChangesToLayoutAccess()) {
            return false;
        }
        if (this.m_layoutContext != null) {
            this.m_layoutContext.applyLayoutAccess(this.m_layoutAccess, true);
        }
        return true;
    }

    public void setLayoutContext(LayoutContext layoutContext) {
        this.setLayoutContext(layoutContext, true, null);
    }

    public boolean setLayoutContext(LayoutContext layoutContext, boolean bl, Component component) {
        this.m_layoutContext = layoutContext;
        LayoutAccess layoutAccess = this.m_layoutContext.createCubeLayoutAccess();
        this.setLayoutAccess(layoutAccess);
        if (layoutAccess != null) {
            String[] stringArray = this.m_layoutAccess.getMeasures("value");
            int n = stringArray == null ? 0 : stringArray.length;
            int n2 = -1;
            switch (this.m_graph.getGraphType()) {
                case 61: 
                case 62: 
                case 65: 
                case 66: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    n2 = 2;
                    break;
                }
                case 63: 
                case 64: 
                case 76: 
                case 77: 
                case 78: 
                case 82: 
                case 84: 
                case 89: 
                case 91: {
                    n2 = 3;
                    break;
                }
                case 70: 
                case 79: 
                case 80: 
                case 81: 
                case 88: 
                case 90: 
                case 92: {
                    n2 = 4;
                    break;
                }
                case 71: 
                case 83: {
                    n2 = 5;
                }
            }
            if (n2 != -1 && n < n2) {
                if (bl) {
                    double[] dArray = new double[]{0.0, 1.0, 2.0};
                    String string = this.m_rMeasures;
                    String[] stringArray2 = new String[]{string, this.m_rMeasure, string};
                    ChoiceFormat choiceFormat = new ChoiceFormat(dArray, stringArray2);
                    MessageFormat messageFormat = new MessageFormat(this.m_rInsufficient);
                    Format[] formatArray = new Format[]{null, null, choiceFormat};
                    messageFormat.setFormats(formatArray);
                    Object[] objectArray = new Object[]{new Integer(n2), new Integer(n), new Integer(n)};
                    String string2 = messageFormat.format(objectArray);
                    JDialog jDialog = new JOptionPane(string2, 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.GraphLayout"), (String)"images/stop.gif"))).createDialog(component, this.m_applicationName);
                    jDialog.show();
                }
                return false;
            }
        }
        return true;
    }

    public void setMeasureText(String string) {
        this.m_measureText = string;
    }

    public String getMeasureText() {
        return this.m_measureText;
    }

    public String getErrorString() {
        return this.m_errorString;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_eh = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void setImageComponent(JComponent jComponent) {
        this.m_imageComponent = jComponent;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updatePopupManagerRowAndColumnNames();
        if (this.m_image != null) {
            this.m_image.setLocale(locale);
        }
    }

    protected void createInnerPanel() {
        int n;
        int n2;
        if (this.m_graph.isDataRowShownAsASeries()) {
            n2 = 1;
            n = 0;
        } else {
            n2 = 0;
            n = 1;
        }
        this.m_seriesEdgeLayers = new LayoutPagingComponent(n2);
        this.m_popupManager.setRowLayoutComponent(this.m_seriesEdgeLayers);
        this.m_groupEdgeLayers = new LayoutPagingComponent(n);
        this.m_popupManager.setColumnLayoutComponent(this.m_groupEdgeLayers);
        this.m_seriesEdgeLayers.setKeyBoardActionListener(this.m_popupManager);
        this.m_groupEdgeLayers.setKeyBoardActionListener(this.m_popupManager);
        this.m_seriesEdgeLayers.setMouseListener(this.m_popupManager);
        this.m_groupEdgeLayers.setMouseListener(this.m_popupManager);
        if (this.m_imageComponent == null) {
            this.m_image = new GraphImageLabel(this.m_imageFile, this.rBundle);
            this.m_image.setLocale(this.m_graph.getLocale());
        }
        if (this.m_seriesLabel == null) {
            this.m_seriesLabel = new JLabel();
        }
        if (this.m_groupLabel == null) {
            this.m_groupLabel = new JLabel();
        }
        this.m_seriesLabel.setText(StringUtils.stripMnemonic((String)this.m_seriesTxt));
        this.m_groupLabel.setText(StringUtils.stripMnemonic((String)this.m_groupTxt));
        this.m_seriesPanel = this.createPagingComponentPanel(this.m_seriesEdgeLayers, this.m_seriesLabel);
        this.m_groupPanel = this.createPagingComponentPanel(this.m_groupEdgeLayers, this.m_groupLabel);
        this.m_bSeriesVisible = true;
        this.m_bGroupVisible = true;
        if (!this.m_bSeriesVisible) {
            this.m_seriesPanel.setVisible(false);
        }
        if (!this.m_bGroupVisible) {
            this.m_groupPanel.setVisible(false);
        }
        this.m_imagePanel.removeAll();
        this.m_imagePanel.add(Box.createVerticalGlue());
        if (this.m_imageComponent == null) {
            this.m_imagePanel.add((Component)this.m_image, "North");
        } else {
            this.m_imagePanel.add((Component)this.m_imageComponent, "North");
        }
        this.m_imagePanel.add(Box.createVerticalGlue());
        this.m_southPanel.removeAll();
        this.m_southPanel.add(this.m_seriesPanel);
        this.m_southPanel.add(this.m_groupPanel);
        this.m_measurePanel.removeAll();
        this.m_measurePanel.setLayout(new BoxLayout(this.m_measurePanel, 1));
        this.m_measurePanel.setAlignmentX(0.0f);
        this.m_measurePanel.add(Box.createVerticalGlue());
        String[] stringArray = this.m_layoutAccess.getMeasures(this.getMemberMetadataLabelType());
        int n3 = 0;
        String string = new String("");
        int n4 = 0;
        while (n4 < stringArray.length) {
            if (n3 < stringArray[n4].length()) {
                string = stringArray[n4];
                n3 = stringArray[n4].length();
            }
            ++n4;
        }
        JLabel jLabel = new JLabel(string);
        this.m_maxMeasureWidth = this.getToolkit().getFontMetrics(jLabel.getFont()).stringWidth(jLabel.getText());
        if (this.m_maxMeasureWidth < this.m_measurePanelWidth) {
            this.m_maxMeasureWidth = this.m_measurePanelWidth;
        }
        if (this.m_type == 0 || this.m_type == 5) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            if (this.m_measureLabel == null) {
                this.m_measureLabel = new JLabel();
            }
            if (this.m_measureText == null) {
                this.m_measureLabel.setText(this.m_rMeasuresColon);
            } else {
                this.m_measureLabel.setText(this.m_measureText);
            }
            jPanel.add(this.m_measureLabel);
            jPanel.setPreferredSize(new Dimension(this.m_measurePanelWidth, 15));
            jPanel.setMinimumSize(jPanel.getPreferredSize());
            jPanel.setMaximumSize(new Dimension(this.m_maxMeasureWidth + 20, 15));
            this.m_measurePanel.add(jPanel);
        }
        this.m_innerMeasurePanel = new MeasurePanel(this.m_graph.getGraphType(), stringArray);
        if (this.m_type == 0 || this.m_type == 5) {
            this.m_scrollPane = new JScrollPane(this.m_innerMeasurePanel);
            this.m_scrollPane.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(""), BorderFactory.createEmptyBorder(0, 1, 0, 0)));
            this.m_measurePanel.add(this.m_scrollPane);
            int n5 = jLabel.getPreferredSize().height;
            if (this.m_measurePanelHeight > jLabel.getPreferredSize().height * stringArray.length + 20) {
                this.m_measurePanelHeight = jLabel.getPreferredSize().height * stringArray.length + 20;
            }
            this.m_scrollPane.setPreferredSize(new Dimension(this.m_measurePanelWidth, this.m_measurePanelHeight));
            this.m_scrollPane.setMaximumSize(new Dimension(this.m_maxMeasureWidth + 20, this.m_measurePanelHeight));
        } else {
            this.m_measurePanel.add(this.m_innerMeasurePanel);
        }
        this.m_measurePanel.add(Box.createVerticalGlue());
    }

    protected void updateLayerDisplay() {
        super.updateLayerDisplay();
        this.createInnerPanel();
        boolean bl = true;
        if (this.m_type != 0 && this.m_type != 5) {
            bl = false;
        }
        boolean bl2 = true;
        if (this.m_type == 4) {
            bl2 = false;
        }
        this.addLayersToPagingComponent(this.m_pageEdgeLayers, 2, true, bl, bl2);
        if (this.m_bSeriesVisible) {
            this.addLayersToPagingComponent(this.m_seriesEdgeLayers, this.m_seriesEdgeLayers.getEdge(), true, bl, bl2);
        } else {
            this.addLayersToPagingComponent(this.m_pageEdgeLayers, this.m_seriesEdgeLayers.getEdge(), false, bl, bl2);
        }
        if (this.m_bGroupVisible) {
            this.addLayersToPagingComponent(this.m_groupEdgeLayers, this.m_groupEdgeLayers.getEdge(), true, bl, bl2);
        } else {
            this.addLayersToPagingComponent(this.m_pageEdgeLayers, this.m_groupEdgeLayers.getEdge(), false, bl, bl2);
        }
        if (this.m_seriesPanel != null) {
            if (this.m_seriesEdgeLayers != null && this.m_seriesEdgeLayers.getItems().length != 0) {
                this.m_seriesPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_seriesPanel.getPreferredSize().height));
                this.m_seriesPanel.setMaximumSize(this.m_seriesPanel.getPreferredSize());
                this.m_seriesPanel.setMinimumSize(this.m_seriesPanel.getPreferredSize());
            } else {
                this.m_seriesPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.getToolkit().getFontMetrics(this.m_seriesLabel.getFont()).getHeight() + 23));
                this.m_seriesPanel.setMaximumSize(this.m_seriesPanel.getPreferredSize());
                this.m_seriesPanel.setMinimumSize(this.m_seriesPanel.getPreferredSize());
            }
        }
        if (this.m_groupPanel != null) {
            if (this.m_groupEdgeLayers != null && this.m_groupEdgeLayers.getItems().length != 0) {
                this.m_groupPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_groupPanel.getPreferredSize().height));
                this.m_groupPanel.setMaximumSize(this.m_groupPanel.getPreferredSize());
                this.m_groupPanel.setMinimumSize(this.m_groupPanel.getPreferredSize());
            } else {
                this.m_groupPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, this.getToolkit().getFontMetrics(this.m_groupLabel.getFont()).getHeight() + 23));
                this.m_groupPanel.setMaximumSize(this.m_groupPanel.getPreferredSize());
                this.m_groupPanel.setMinimumSize(this.m_groupPanel.getPreferredSize());
            }
        }
    }

    protected boolean isPointType() {
        return !this.m_graph.isLineDataLineDisplayed();
    }

    protected boolean isCombinationType() {
        try {
            int n = 0;
            while (n < this.m_graph.getSeriesObjectCount()) {
                if (this.m_graph.getUISeries().getMarkerType(n) != 0) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            if (this.m_eh != null) {
                this.m_eh.error(exception, this.getClass().getName(), m_isCombinationType);
            }
            exception.printStackTrace();
        }
        return false;
    }

    protected void updateImageFileAndHelpID() {
        switch (this.m_graph.getGraphType()) {
            case 41: 
            case 48: {
                if (this.isPointType()) {
                    this.m_imageFile = "images/42 point.gif";
                    this.m_helpID = a_point;
                    break;
                }
                this.m_imageFile = "images/19 line & stacked line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 43: 
            case 50: {
                if (this.isPointType()) {
                    this.m_imageFile = "images/43 dual-y point.gif";
                    this.m_helpID = a_point;
                    break;
                }
                this.m_imageFile = "images/20 dual-y & dual-y stacked line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 45: 
            case 52: {
                if (this.isPointType()) {
                    this.m_imageFile = "images/44 split dual-y point.gif";
                    this.m_helpID = a_point;
                    break;
                }
                this.m_imageFile = "images/21 split & stacked split dual-y line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 47: 
            case 54: {
                this.m_imageFile = "images/22 percent line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 42: 
            case 49: {
                this.m_imageFile = "images/19 line & stacked line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 44: 
            case 51: {
                this.m_imageFile = "images/20 dual-y & dual-y stacked line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 46: 
            case 53: {
                this.m_imageFile = "images/21 split & stacked split dual-y line.gif";
                this.m_helpID = a_line;
                break;
            }
            case 102: {
                this.m_imageFile = "images/48 pareto.gif";
                this.m_helpID = a_pareto;
                break;
            }
            case 55: {
                this.m_imageFile = "images/26 pie.gif";
                this.m_helpID = a_piering;
                break;
            }
            case 93: {
                this.m_imageFile = "images/28 pie-bar.gif";
                this.m_helpID = a_pieringbar;
                break;
            }
            case 57: 
            case 59: {
                this.m_imageFile = "images/27 multiple pie.gif";
                this.m_helpID = a_multipie;
                break;
            }
            case 56: {
                this.m_imageFile = "images/29 ring.gif";
                this.m_helpID = a_piering;
                break;
            }
            case 94: {
                this.m_imageFile = "images/31 ring-bar.gif";
                this.m_helpID = a_pieringbar;
                break;
            }
            case 58: 
            case 60: {
                this.m_imageFile = "images/30 multiple ring.gif";
                this.m_helpID = a_multiring;
                break;
            }
            case 65: 
            case 66: {
                this.m_imageFile = "images/32 polar.gif";
                this.m_helpID = a_polar;
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                this.m_imageFile = "images/33 radar.gif";
                this.m_helpID = a_radar;
                break;
            }
            case 61: 
            case 63: {
                this.m_imageFile = "images/34 scatter.gif";
                this.m_helpID = a_scatter;
                break;
            }
            case 62: 
            case 64: {
                this.m_imageFile = "images/35 dual-y scatter.gif";
                this.m_helpID = a_scatter;
                break;
            }
            case 89: 
            case 90: {
                this.m_imageFile = "images/36 bubble.gif";
                this.m_helpID = a_bubble;
                break;
            }
            case 91: 
            case 92: {
                this.m_imageFile = "images/37 dual-y bubble.gif";
                this.m_helpID = a_bubble;
                break;
            }
            case 76: {
                this.m_imageFile = "images/hlc.gif";
                this.m_helpID = a_stockhilo;
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: {
                this.m_imageFile = "images/38 stock.gif";
                this.m_helpID = a_stockhilo;
                break;
            }
            case 79: {
                this.m_imageFile = "images/ohlc.gif";
                this.m_helpID = a_stockhilo;
                break;
            }
            case 88: {
                this.m_imageFile = "images/hlc_v.gif";
                this.m_helpID = a_stockhilovolume;
                break;
            }
            case 82: {
                this.m_imageFile = "images/39 stock+vol.gif";
                this.m_helpID = a_stockhilovolume;
                break;
            }
            case 83: {
                this.m_imageFile = "images/ohlc_v.gif";
                this.m_helpID = a_stockhilovolume;
                break;
            }
            case 70: {
                this.m_groupTxt = this.m_rGroups;
                this.m_imageFile = "images/ohlc_candle.gif";
                this.m_helpID = a_stockohlc;
                break;
            }
            case 72: {
                this.m_groupTxt = this.m_rGroups;
                this.m_imageFile = "images/oc_candle.gif";
                this.m_helpID = a_stockohlc;
                break;
            }
            case 71: {
                this.m_imageFile = "images/ohlc_v_candle.gif";
                this.m_helpID = a_stockohlcvolume;
                break;
            }
            case 84: {
                this.m_imageFile = "images/oc_v_candle.gif";
                this.m_helpID = a_stockohlcvolume;
                break;
            }
            case 0: {
                this.m_imageFile = "images/46 3-D bar.gif";
                this.m_helpID = a_3Dbar;
                break;
            }
            case 1: {
                this.m_imageFile = "images/46 3-D bar.gif";
                this.m_helpID = a_other;
                break;
            }
            case 2: {
                this.m_imageFile = "images/46 3-D bar.gif";
                this.m_helpID = a_other;
                break;
            }
            case 4: {
                this.m_imageFile = "images/46 3-D cubes.gif";
                this.m_helpID = a_3Dcube;
                break;
            }
            case 5: {
                this.m_imageFile = "images/46 3-D cubes.gif";
                this.m_helpID = a_other;
                break;
            }
            case 6: {
                this.m_imageFile = "images/46 3-D area.gif";
                this.m_helpID = a_3Darea;
                break;
            }
            case 9: {
                this.m_imageFile = "images/46 3-D area.gif";
                this.m_helpID = a_other;
                break;
            }
            case 7: {
                this.m_imageFile = "images/46 3-D ribbon.gif";
                this.m_helpID = a_3Dribbon;
                break;
            }
            case 10: {
                this.m_imageFile = "images/46 3-D ribbon.gif";
                this.m_helpID = a_other;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                this.m_imageFile = "images/46 3-D surface.gif";
                this.m_helpID = a_3Dsurface;
                break;
            }
            case 17: {
                if (this.isCombinationType()) {
                    this.m_imageFile = "images/45 combination.gif";
                    this.m_helpID = a_combination;
                    break;
                }
                this.m_imageFile = "images/06 bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 19: {
                if (this.isCombinationType()) {
                    this.m_imageFile = "images/45 combination dual-y.gif";
                    this.m_helpID = a_combination;
                    break;
                }
                this.m_imageFile = "images/07 dual-y bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 21: {
                this.m_imageFile = "images/08 split dual-y bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 23: {
                this.m_imageFile = "images/09 percent bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 18: {
                this.m_imageFile = "images/10 stacked bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 20: {
                this.m_imageFile = "images/11 dual-y stacked bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 22: {
                this.m_imageFile = "images/08b split dual-y stack bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 24: {
                this.m_imageFile = "images/12 horiz bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 26: {
                this.m_imageFile = "images/13 dual-y horiz bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 28: {
                this.m_imageFile = "images/14 split dual-y horiz bar.gif";
                this.m_helpID = a_barclust;
                break;
            }
            case 30: {
                this.m_imageFile = "images/15 percent horiz bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 25: {
                this.m_imageFile = "images/16 stacked horiz bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 27: {
                this.m_imageFile = "images/17 dual-y stacked horiz bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 29: {
                this.m_imageFile = "images/18 split dual-y stacked horiz bar.gif";
                this.m_helpID = a_barstack;
                break;
            }
            case 31: 
            case 36: {
                this.m_imageFile = "images/01 area & stacked area.gif";
                this.m_helpID = a_area;
                break;
            }
            case 33: 
            case 38: {
                this.m_imageFile = "images/02 dual-y & dual-y stacked area.gif";
                this.m_helpID = a_area;
                break;
            }
            case 35: 
            case 40: {
                this.m_imageFile = "images/03 percent area.gif";
                this.m_helpID = a_area;
                break;
            }
            case 32: 
            case 37: {
                this.m_imageFile = "images/01 area & stacked area.gif";
                this.m_helpID = a_area;
                break;
            }
            case 34: 
            case 39: {
                this.m_imageFile = "images/02 dual-y & dual-y stacked area.gif";
                this.m_helpID = a_area;
                break;
            }
            default: {
                this.m_imageFile = "images/06 bar.gif";
                this.m_helpID = a_other;
            }
        }
    }

    protected void updatePopupManagerRowAndColumnNames() {
        switch (this.m_graph.getGraphType()) {
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 52: 
            case 67: 
            case 68: 
            case 69: {
                if (this.isPointType()) {
                    this.m_seriesTxt = this.m_rPoints;
                    this.m_seriesPopupTxt = this.m_pPoints;
                } else {
                    this.m_seriesTxt = this.m_rLines;
                    this.m_seriesPopupTxt = this.m_pLines;
                }
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: {
                this.m_seriesTxt = this.m_rLines;
                this.m_seriesPopupTxt = this.m_pLines;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 55: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 93: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rBars;
                this.m_groupPopupTxt = this.m_pBars;
                break;
            }
            case 57: 
            case 59: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rPies;
                this.m_groupPopupTxt = this.m_pPies;
                break;
            }
            case 56: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 94: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rBars;
                this.m_groupPopupTxt = this.m_pBars;
                break;
            }
            case 58: 
            case 60: {
                this.m_seriesTxt = this.m_rSlices;
                this.m_seriesPopupTxt = this.m_pSlices;
                this.m_groupTxt = this.m_rRings;
                this.m_groupPopupTxt = this.m_pRings;
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.m_seriesTxt = this.m_rPoints;
                this.m_seriesPopupTxt = this.m_pPoints;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 89: 
            case 90: {
                this.m_seriesTxt = this.m_rBubbles;
                this.m_seriesPopupTxt = this.m_pBubbles;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 91: 
            case 92: {
                this.m_seriesTxt = this.m_rBubbles;
                this.m_seriesPopupTxt = this.m_pBubbles;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 82: 
            case 83: 
            case 88: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 70: 
            case 72: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 71: 
            case 84: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 0: {
                this.m_seriesTxt = this.m_rBars;
                this.m_seriesPopupTxt = this.m_pBars;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 1: {
                this.m_seriesTxt = this.m_rPyramids;
                this.m_seriesPopupTxt = this.m_pPyramids;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 2: {
                this.m_seriesTxt = this.m_rOctagons;
                this.m_seriesPopupTxt = this.m_pOctagons;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 4: {
                this.m_seriesTxt = this.m_rCubes;
                this.m_seriesPopupTxt = this.m_pCubes;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 5: {
                this.m_seriesTxt = this.m_rDiamonds;
                this.m_seriesPopupTxt = this.m_pDiamonds;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 6: {
                this.m_seriesTxt = this.m_rAreas;
                this.m_seriesPopupTxt = this.m_pAreas;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 9: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rAreas;
                this.m_groupPopupTxt = this.m_pAreas;
                break;
            }
            case 7: {
                this.m_seriesTxt = this.m_rRibbons;
                this.m_seriesPopupTxt = this.m_pRibbons;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 10: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rRibbons;
                this.m_groupPopupTxt = this.m_pRibbons;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 17: {
                if (this.isCombinationType()) {
                    this.m_seriesTxt = this.m_rSeries;
                    this.m_seriesPopupTxt = this.m_pSeries;
                    this.m_groupTxt = this.m_rGroups;
                    this.m_groupPopupTxt = this.m_pGroups;
                    break;
                }
                this.m_seriesTxt = this.m_rBars;
                this.m_seriesPopupTxt = this.m_pBars;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 19: {
                if (this.isCombinationType()) {
                    this.m_seriesTxt = this.m_rSeries;
                    this.m_seriesPopupTxt = this.m_pSeries;
                    this.m_groupTxt = this.m_rGroups;
                    this.m_groupPopupTxt = this.m_pGroups;
                    break;
                }
                this.m_seriesTxt = this.m_rBars;
                this.m_seriesPopupTxt = this.m_pBars;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                this.m_seriesTxt = this.m_rBars;
                this.m_seriesPopupTxt = this.m_pBars;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.m_seriesTxt = this.m_rAreas;
                this.m_seriesPopupTxt = this.m_pAreas;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            case 102: {
                this.m_seriesTxt = this.m_rBars;
                this.m_seriesPopupTxt = this.m_pBars;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
                break;
            }
            default: {
                this.m_seriesTxt = this.m_rSeries;
                this.m_seriesPopupTxt = this.m_pSeries;
                this.m_groupTxt = this.m_rGroups;
                this.m_groupPopupTxt = this.m_pGroups;
            }
        }
        String string = this.m_seriesPopupTxt;
        String string2 = this.m_groupPopupTxt;
        this.m_popupManager.setRowName(string);
        this.m_popupManager.setColumnName(string2);
        if (this.m_seriesLabel == null) {
            this.m_seriesLabel = new JLabel();
        }
        this.m_seriesLabel.setText(StringUtils.stripMnemonic((String)this.m_seriesTxt));
        this.m_seriesLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_seriesTxt));
        if (this.m_groupLabel == null) {
            this.m_groupLabel = new JLabel();
        }
        this.m_groupLabel.setText(StringUtils.stripMnemonic((String)this.m_groupTxt));
        this.m_groupLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_groupTxt));
    }

    protected void updateTextUsingCorrectLocale() {
        super.updateTextUsingCorrectLocale();
        this.m_rPoints = this.rBundle.getString("Points:");
        this.m_rLines = this.rBundle.getString("Lines:");
        this.m_rGroups = this.rBundle.getString("Groups:");
        this.m_rBars = this.rBundle.getString("Bars:");
        this.m_rSlices = this.rBundle.getString("Slices:");
        this.m_rPies = this.rBundle.getString("Pies:");
        this.m_rRings = this.rBundle.getString("Rings:");
        this.m_rBubbles = this.rBundle.getString("Bubbles:");
        this.m_rOctagons = this.rBundle.getString("Octagons:");
        this.m_rCubes = this.rBundle.getString("Cubes:");
        this.m_rDiamonds = this.rBundle.getString("Diamonds:");
        this.m_rAreas = this.rBundle.getString("Areas:");
        this.m_rSeries = this.rBundle.getString("Series:");
        this.m_rRibbons = this.rBundle.getString("Ribbons:");
        this.m_rPyramids = this.rBundle.getString("Pyramids:");
        this.m_rMeasuresColon = this.rBundle.getString("MeasuresForPopup");
        this.m_pPoints = this.rBundle.getString("PointsForPopup");
        this.m_pLines = this.rBundle.getString("LinesForPopup");
        this.m_pGroups = this.rBundle.getString("GroupsForPopup");
        this.m_pBars = this.rBundle.getString("BarsForPopup");
        this.m_pSlices = this.rBundle.getString("SlicesForPopup");
        this.m_pPies = this.rBundle.getString("PiesForPopup");
        this.m_pRings = this.rBundle.getString("RingsForPopup");
        this.m_pBubbles = this.rBundle.getString("BubblesForPopup");
        this.m_pOctagons = this.rBundle.getString("OctagonsForPopup");
        this.m_pCubes = this.rBundle.getString("CubesForPopup");
        this.m_pDiamonds = this.rBundle.getString("DiamondsForPopup");
        this.m_pAreas = this.rBundle.getString("AreasForPopup");
        this.m_pSeries = this.rBundle.getString("SeriesForPopup");
        this.m_pRibbons = this.rBundle.getString("RibbonsForPopup");
        this.m_pPyramids = this.rBundle.getString("PyramidsForPopup");
        this.m_pMeasuresColon = this.rBundle.getString("MeasuresForPopup");
        this.m_rMeasures = this.rBundle.getString("measures");
        this.m_rMeasure = this.rBundle.getString("measure");
        this.m_rInsufficient = this.rBundle.getString("Insufficient measures");
        this.m_rUnique = this.rBundle.getString("Selection should be Unique");
        this.m_rPanelWidth = this.rBundle.getString("GraphLayoutPanelWidth");
        this.m_rHidePaging = this.rBundle.getString("PanelHeightHidePagingControl");
        this.m_rShowPaging = this.rBundle.getString("PanelHeightWithPagingControl");
        if (this.m_innerMeasurePanel != null) {
            this.m_innerMeasurePanel.init();
        }
        if (this.m_measureLabel == null) {
            this.m_measureLabel = new JLabel();
        }
        if (this.m_measureText == null) {
            this.m_measureLabel.setText(this.m_rMeasuresColon);
        } else {
            this.m_measureLabel.setText(this.m_measureText);
        }
        this.m_applicationName = this.rBundle.getString("Graph");
        this.m_measurePanelWidth = Integer.parseInt(this.rBundle.getString("MeasurePanelWidth"));
        this.m_measurePanelHeight = Integer.parseInt(this.rBundle.getString("MeasurePanelHeight"));
    }

    protected void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
        super.updateResourceBundle(locale);
    }

    protected boolean applyChangesToLayoutAccess() {
        int n;
        String[][] stringArray;
        if (this.m_type != 0 && this.m_type != 5) {
            String[] stringArray2 = this.m_innerMeasurePanel.getSelectedMeasureList();
            if (stringArray2 == null) {
                JDialog jDialog = new JOptionPane(this.m_rUnique, 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.GraphLayout"), (String)"images/stop.gif"))).createDialog(this.m_innerMeasurePanel, this.m_applicationName);
                jDialog.setSize(400, 200);
                jDialog.show();
                return false;
            }
            stringArray = this.m_innerMeasurePanel.getOriginalMeasureList();
            int[] nArray = new int[stringArray2.length];
            n = 0;
            while (n < stringArray2.length) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray2[n].equals(stringArray[n2])) {
                        nArray[n] = n2;
                    }
                    ++n2;
                }
                ++n;
            }
            this.m_graph.getDataFilter().setMeasures(nArray, stringArray.length);
        }
        this.m_graph.setPagingControlVisible(this.m_showPageItemsChkBox.isSelected());
        try {
            String string;
            int n3;
            int n4;
            int n5;
            if (this.m_hiddenDimensions != null && this.m_hiddenDimensions.size() != 0) {
                stringArray = new String[4][];
                stringArray[3] = new String[this.m_hiddenDimensions.size()];
                n = 0;
                while (n < this.m_hiddenDimensions.size()) {
                    stringArray[3][n] = (String)this.m_hiddenDimensions.elementAt(n);
                    ++n;
                }
            } else {
                stringArray = new String[3][];
            }
            int n6 = this.m_pageEdgeLayers.getComponentCount();
            stringArray[2] = new String[n6];
            n = 0;
            while (n < n6) {
                LayoutPageItem layoutPageItem = (LayoutPageItem)((Object)this.m_pageEdgeLayers.getComponent(n));
                stringArray[2][n] = layoutPageItem.getName();
                ++n;
            }
            n6 = this.m_groupEdgeLayers.getComponentCount();
            stringArray[this.m_groupEdgeLayers.getEdge()] = this.m_type == 4 ? new String[n6 + 2] : (this.m_type != 0 && this.m_type != 5 ? new String[n6 + 1] : new String[n6]);
            n = 0;
            while (n < n6) {
                LayoutPageItem layoutPageItem = (LayoutPageItem)((Object)this.m_groupEdgeLayers.getComponent(n));
                stringArray[this.m_groupEdgeLayers.getEdge()][n] = layoutPageItem.getName();
                ++n;
            }
            String string2 = null;
            if (this.m_type == 4) {
                n5 = -1;
                n4 = -1;
                int n7 = 0;
                while (n7 < this.m_dataAccess.getEdgeCount() && n5 == -1) {
                    int n8 = this.m_dataAccess.getLayerCount(n7);
                    n3 = 0;
                    while (n3 < n8 && n4 == -1) {
                        if (this.m_layoutAccess.isSpecialDimension(n7, n3, "time")) {
                            n5 = n7;
                            n4 = n3;
                        }
                        ++n3;
                    }
                    ++n7;
                }
                if (n5 != -1 && n4 != -1) {
                    string2 = (String)this.m_dataAccess.getLayerMetadata(n5, n4, "dimName");
                }
                if (string2 != null) {
                    stringArray[this.m_groupEdgeLayers.getEdge()][n6] = string2.toString();
                }
            }
            if (this.m_type != 0 && this.m_type != 5 && (string = (String)this.m_dataAccess.getLayerMetadata(n5 = this.m_layoutAccess.getMeasureEdge(), n4 = this.m_layoutAccess.getMeasureLayer(), "dimName")) != null) {
                if (this.m_type != 4 || string2 == null) {
                    String[] stringArray3 = new String[n6 + 1];
                    stringArray[this.m_groupEdgeLayers.getEdge()][n6] = string.toString();
                    n3 = 0;
                    while (n3 < n6 + 1) {
                        stringArray3[n3] = stringArray[this.m_groupEdgeLayers.getEdge()][n3];
                        ++n3;
                    }
                    stringArray[this.m_groupEdgeLayers.getEdge()] = new String[n6 + 1];
                    n3 = 0;
                    while (n3 < n6 + 1) {
                        stringArray[this.m_groupEdgeLayers.getEdge()][n3] = stringArray3[n3];
                        ++n3;
                    }
                } else {
                    stringArray[this.m_groupEdgeLayers.getEdge()][n6 + 1] = string.toString();
                }
            }
            n6 = this.m_seriesEdgeLayers.getComponentCount();
            stringArray[this.m_seriesEdgeLayers.getEdge()] = new String[n6];
            n = 0;
            while (n < n6) {
                LayoutPageItem layoutPageItem = (LayoutPageItem)((Object)this.m_seriesEdgeLayers.getComponent(n));
                stringArray[this.m_seriesEdgeLayers.getEdge()][n] = layoutPageItem.getName();
                ++n;
            }
            this.m_layoutAccess.setLayout(stringArray);
        }
        catch (Exception exception) {
            if (this.m_eh != null) {
                this.m_eh.log("Error applying changes to layout access", this.getClass().getName(), m_applyChangesToLayoutAccess);
            } else {
                exception.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public Dimension getPreferredSize() {
        int n = Integer.parseInt(this.m_rPanelWidth);
        int n2 = this.m_hidePagingControl ? Integer.parseInt(this.m_rHidePaging) : Integer.parseInt(this.m_rShowPaging);
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getHelpContextID() {
        if (this.m_hidePagingControl) {
            if (this.m_bPagingControlVisible) {
                return String.valueOf(this.getClass().getName()) + "_" + this.m_helpID + "_NoPageOpt_PageCtrl";
            }
            return String.valueOf(this.getClass().getName()) + "_" + this.m_helpID + "_NoPageOpt_NoPageCtrl";
        }
        return String.valueOf(this.getClass().getName()) + "_" + this.m_helpID + "_PageOpt";
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void cleanUp() {
        this.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
        this.removeAncestorListener(this.m_ancestorListener);
        this.m_ancestorListener = null;
        if (this.m_type == 0 || this.m_type == 5) {
            if (this.m_scrollPane != null) {
                this.m_scrollPane.setViewportView(null);
            }
        } else {
            this.m_measurePanel.remove(this.m_innerMeasurePanel);
        }
        this.m_innerMeasurePanel = null;
        this.m_pageEdgeLayers.dispose();
        this.m_seriesEdgeLayers.dispose();
        this.m_groupEdgeLayers.dispose();
        if (this.m_dataDirector != null) {
            this.m_dataDirector.removeDataDirectorListener(this);
        }
    }

    private void setErrorString(String string) {
        this.m_errorString = string;
    }

    private int convertGraphTypeToType(int n) {
        switch (n) {
            case 55: 
            case 56: {
                return 5;
            }
            case 65: 
            case 66: {
                return 1;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                return 2;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                return 3;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 88: {
                return 4;
            }
        }
        return 0;
    }

    protected JPanel createPagingComponentPanel(PagingComponent pagingComponent, JLabel jLabel) {
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jLabel.setLabelFor((Component)pagingComponent);
        int n = this.m_rPageItems.length();
        String string = this.m_rPageItems;
        if (this.m_rBars != null && this.m_rBars.length() > n) {
            n = this.m_rBars.length();
            string = this.m_rBars;
        }
        if (this.m_rGroups != null && this.m_rGroups.length() > n) {
            n = this.m_rGroups.length();
            string = this.m_rGroups;
        }
        int n2 = this.getToolkit().getFontMetrics(jLabel.getFont()).stringWidth(string) - this.getToolkit().getFontMetrics(jLabel.getFont()).stringWidth(jLabel.getText());
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(n2 + 10));
        pagingComponent.setSwapAllowed(true);
        pagingComponent.removePivotListener((PagingPivotListener)this.m_pageComponentListener);
        pagingComponent.addPivotListener((PagingPivotListener)this.m_pageComponentListener);
        ArrowBox arrowBox = new ArrowBox((Component)pagingComponent);
        jPanel.add((Component)arrowBox);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return jPanel;
    }

    class MeasurePanel
    extends JPanel {
        private int m_graphType;
        private String[] m_measures;
        Vector labelCompbo;
        private JLabel measureLabel;
        private JLabel space;

        MeasurePanel(int n, String[] stringArray) {
            this.m_graphType = n;
            this.m_measures = stringArray;
            this.init();
        }

        public String[] getOriginalMeasureList() {
            return this.m_measures;
        }

        public String[] getSelectedMeasureList() {
            if (this.checkSelection()) {
                String[] stringArray = new String[this.labelCompbo.size()];
                int n = 0;
                while (n < this.labelCompbo.size()) {
                    stringArray[n] = (String)((LabelComboPanel)this.labelCompbo.elementAt(n)).getComboBox().getSelectedItem();
                    ++n;
                }
                return stringArray;
            }
            return null;
        }

        private boolean checkSelection() {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < this.labelCompbo.size()) {
                boolean bl = false;
                String string = (String)((LabelComboPanel)this.labelCompbo.elementAt(n)).getComboBox().getSelectedItem();
                int n2 = 0;
                while (n2 < vector.size()) {
                    if (string == (String)vector.elementAt(n2)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    GraphLayout.this.setErrorString(GraphLayout.this.m_rUnique);
                    return false;
                }
                vector.addElement(string);
                ++n;
            }
            return true;
        }

        private String[] createMeasureList() {
            String[] stringArray = new String[5];
            int n = 0;
            while (n < 5) {
                stringArray[n] = null;
                ++n;
            }
            if (GraphLayout.this.m_type == 1) {
                stringArray[0] = GraphLayout.this.rBundle.getString("Angle:");
                stringArray[1] = GraphLayout.this.rBundle.getString("Distance:");
            } else if (GraphLayout.this.m_type == 2 || GraphLayout.this.m_type == 3) {
                stringArray[0] = GraphLayout.this.rBundle.getString("X-Axis:");
                stringArray[1] = GraphLayout.this.rBundle.getString("Y-Axis:");
                if (GraphLayout.this.m_type == 3) {
                    stringArray[2] = GraphLayout.this.rBundle.getString("Size:");
                }
                if (this.m_graphType == 63 || this.m_graphType == 64) {
                    stringArray[2] = GraphLayout.this.rBundle.getString("Labels:");
                }
                if (this.m_graphType == 90 || this.m_graphType == 92) {
                    stringArray[3] = GraphLayout.this.rBundle.getString("Labels:");
                }
            } else if (GraphLayout.this.m_type == 4) {
                switch (this.m_graphType) {
                    case 72: {
                        stringArray[0] = GraphLayout.this.rBundle.getString("Open:");
                        stringArray[1] = GraphLayout.this.rBundle.getString("Close:");
                        break;
                    }
                    case 73: 
                    case 74: 
                    case 75: {
                        stringArray[0] = GraphLayout.this.rBundle.getString("High:");
                        stringArray[1] = GraphLayout.this.rBundle.getString("Low:");
                        break;
                    }
                    case 76: 
                    case 77: 
                    case 78: {
                        stringArray[0] = GraphLayout.this.rBundle.getString("High:");
                        stringArray[1] = GraphLayout.this.rBundle.getString("Low:");
                        stringArray[2] = GraphLayout.this.rBundle.getString("Close:");
                        break;
                    }
                    case 82: {
                        stringArray[0] = GraphLayout.this.rBundle.getString("High:");
                        stringArray[1] = GraphLayout.this.rBundle.getString("Low:");
                        stringArray[2] = GraphLayout.this.rBundle.getString("Volume:");
                        break;
                    }
                    case 84: {
                        stringArray[0] = GraphLayout.this.rBundle.getString("Open:");
                        stringArray[1] = GraphLayout.this.rBundle.getString("Close:");
                        stringArray[2] = GraphLayout.this.rBundle.getString("Volume:");
                        break;
                    }
                    case 88: {
                        stringArray[0] = GraphLayout.this.rBundle.getString("High:");
                        stringArray[1] = GraphLayout.this.rBundle.getString("Low:");
                        stringArray[2] = GraphLayout.this.rBundle.getString("Close:");
                        stringArray[3] = GraphLayout.this.rBundle.getString("Volume:");
                        break;
                    }
                    case 70: 
                    case 79: 
                    case 80: 
                    case 81: {
                        stringArray[0] = GraphLayout.this.rBundle.getString("Open:");
                        stringArray[1] = GraphLayout.this.rBundle.getString("High:");
                        stringArray[2] = GraphLayout.this.rBundle.getString("Low:");
                        stringArray[3] = GraphLayout.this.rBundle.getString("Close:");
                        break;
                    }
                    case 71: 
                    case 83: {
                        stringArray[0] = GraphLayout.this.rBundle.getString("Open:");
                        stringArray[1] = GraphLayout.this.rBundle.getString("High:");
                        stringArray[2] = GraphLayout.this.rBundle.getString("Low:");
                        stringArray[3] = GraphLayout.this.rBundle.getString("Close:");
                        stringArray[4] = GraphLayout.this.rBundle.getString("Volume:");
                    }
                }
            }
            return stringArray;
        }

        private void updateLabelAndPreferredSize(String[] stringArray) {
            int n;
            JLabel jLabel;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.labelCompbo.size()) {
                LabelComboPanel labelComboPanel = (LabelComboPanel)this.labelCompbo.elementAt(n5);
                jLabel = labelComboPanel.getLabel();
                jLabel.setText(StringUtils.stripMnemonic((String)stringArray[n5]));
                jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)stringArray[n5]));
                n4 = n4 + jLabel.getPreferredSize().height + 7 + 5;
                n3 = this.getToolkit().getFontMetrics(jLabel.getFont()).stringWidth(jLabel.getText());
                if (n3 > n2) {
                    n2 = n3;
                }
                ++n5;
            }
            int n6 = n4 + 15;
            n5 = 0;
            while (n5 < this.labelCompbo.size()) {
                jLabel = ((LabelComboPanel)this.labelCompbo.elementAt(n5)).getLabel();
                n = jLabel.getPreferredSize().height;
                jLabel.setPreferredSize(new Dimension(n2, n));
                JComboBox jComboBox = ((LabelComboPanel)this.labelCompbo.elementAt(n5)).getComboBox();
                n = jComboBox.getPreferredSize().height;
                jComboBox.setPreferredSize(new Dimension(GraphLayout.this.m_measurePanelWidth - n2 - 5, n));
                ++n5;
            }
            if (this.space == null) {
                this.space = new JLabel(" ");
            }
            n = this.space.getPreferredSize().height;
            this.space.setPreferredSize(new Dimension(n2, n));
            this.space.setMaximumSize(this.space.getPreferredSize());
            this.space.setMinimumSize(this.space.getPreferredSize());
            if (this.measureLabel == null) {
                this.measureLabel = new JLabel();
            }
            if (GraphLayout.this.m_measureText == null) {
                this.measureLabel.setText(GraphLayout.this.m_rMeasuresColon);
            } else {
                this.measureLabel.setText(GraphLayout.this.m_measureText);
            }
            this.measureLabel.setPreferredSize(new Dimension(GraphLayout.this.m_measurePanelWidth - n2 - 5, n));
            this.measureLabel.setMinimumSize(this.measureLabel.getPreferredSize());
            this.measureLabel.setMaximumSize(new Dimension(GraphLayout.this.m_maxMeasureWidth + 25, n));
            this.setPreferredSize(new Dimension(GraphLayout.this.m_measurePanelWidth, n6));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(new Dimension(GraphLayout.this.m_maxMeasureWidth + n2 + 30, n6));
        }

        private void init() {
            this.labelCompbo = new Vector();
            this.removeAll();
            this.setLayout(new BoxLayout(this, 1));
            if (GraphLayout.this.m_type == 0 || GraphLayout.this.m_type == 5) {
                int n = this.m_measures.length;
                if (n == 0) {
                    return;
                }
                int n2 = 0;
                while (n2 < n) {
                    JLabel jLabel = new JLabel(this.m_measures[n2]);
                    this.add(jLabel);
                    ++n2;
                }
            } else {
                int n = this.m_measures.length;
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 0));
                this.space = new JLabel(" ");
                jPanel.add(this.space);
                jPanel.add(Box.createHorizontalStrut(5));
                this.measureLabel = new JLabel();
                if (GraphLayout.this.m_measureText == null) {
                    this.measureLabel.setText(GraphLayout.this.m_rMeasuresColon);
                } else {
                    this.measureLabel.setText(GraphLayout.this.m_measureText);
                }
                jPanel.add(this.measureLabel);
                this.add(jPanel);
                String[] stringArray = this.createMeasureList();
                int n3 = 0;
                n3 = 0;
                while (n3 < 5) {
                    if (stringArray[n3] != null) {
                        JLabel jLabel = new JLabel();
                        JComboBox<String> jComboBox = new JComboBox<String>(this.m_measures);
                        int[] nArray = GraphLayout.this.m_graph.getDataFilter().getMeasures();
                        if (nArray != null && nArray[n3] < jComboBox.getItemCount()) {
                            jComboBox.setSelectedIndex(nArray[n3]);
                        } else if (n3 < n) {
                            jComboBox.setSelectedIndex(n3);
                        }
                        LabelComboPanel labelComboPanel = null.new LabelComboPanel(jLabel, jComboBox);
                        this.add(labelComboPanel);
                        this.labelCompbo.addElement(labelComboPanel);
                        this.add(Box.createVerticalStrut(5));
                    }
                    ++n3;
                }
                this.updateLabelAndPreferredSize(stringArray);
            }
        }
    }

    class LabelComboPanel
    extends JPanel {
        JLabel m_label;
        JComboBox m_combo;

        LabelComboPanel(JLabel jLabel, JComboBox jComboBox) {
            this.setLayout(new BoxLayout(this, 0));
            this.m_label = jLabel;
            this.m_combo = jComboBox;
            this.m_label.setLabelFor(this.m_combo);
            this.add(this.m_label);
            this.add(Box.createHorizontalStrut(5));
            this.add(jComboBox);
        }

        JLabel getLabel() {
            return this.m_label;
        }

        JComboBox getComboBox() {
            return this.m_combo;
        }

        void setLabelText(String string) {
            this.m_label.setText(string);
        }

        public Dimension getPreferredSize() {
            int n = this.m_label.getPreferredSize().width + this.m_combo.getPreferredSize().width + 5;
            int n2 = this.m_combo.getPreferredSize().height;
            return new Dimension(n, n2);
        }
    }
}

