/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UIDataAxis;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Y2Axis
extends BaseDataAxis
implements UIDataAxis {
    protected static final String a_paretoMajorTickStep = "paretoMajorTickStep";
    protected double majorTickStep;
    protected double paretoMajorTickStep;

    public Y2Axis(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getY2Axis();
        this.m_identObj2 = this.m_pfj.getY2AxisLine();
        this.m_majorGridIdentObj = this.m_pfj.getY2MajorGrid();
        this.m_labelIdentObj = this.m_pfj.getY2Label();
        this.m_id = 51;
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.lineWidth = GraphDefaultValues.getY2AxisLineWidth();
        this.lineColor = GraphDefaultValues.getY2AxisLineColor();
        this.axisMinAutoScaled = GraphDefaultValues.isY2AxisMinAutoScaled();
        this.axisMaxAutoScaled = GraphDefaultValues.isY2AxisMaxAutoScaled();
        this.majorTickStepAutomatic = GraphDefaultValues.isY2MajorTickStepAutomatic();
        this.scaledLogarithmic = GraphDefaultValues.isY2AxisScaledLogarithmic();
        this.logarithmicBase = GraphDefaultValues.getY2AxisLogBase();
        this.visible = GraphDefaultValues.isY2AxisVisible();
        this.majorTickStep = GraphDefaultValues.getY2TickStep();
        this.paretoMajorTickStep = GraphDefaultValues.getParetoY2TickStep();
        this.axisMaxLabelVisible = GraphDefaultValues.isY2AxisMaxLabelVisible();
        this.axisMinLabelVisible = GraphDefaultValues.isY2AxisMinLabelVisible();
        this.acsending = GraphDefaultValues.isY2AxisAscending();
        this.axisLocation = GraphDefaultValues.getY2AxisLocation();
        this.axisAutoScaledFromZero = GraphDefaultValues.isY2AxisAutoScaledFromZero();
        this.minAutoMajorTickStep = GraphDefaultValues.getX1AxisMinAutoMajorTickStep();
    }

    public boolean isAxisAutoScaledFromZero() {
        return this.m_pfj.getY2MustIncludeZero();
    }

    public void setAxisAutoScaledFromZero(boolean bl) {
        this.m_pfj.setY2MustIncludeZero(bl);
    }

    public boolean isAxisMaxAutoScaled() {
        return this.m_pfj.getY2ScaleMaxAuto();
    }

    public void setAxisMaxAutoScaled(boolean bl) {
        this.m_pfj.setY2ScaleMaxAuto(bl);
    }

    public boolean isAxisMinAutoScaled() {
        return this.m_pfj.getY2ScaleMinAuto();
    }

    public void setAxisMinAutoScaled(boolean bl) {
        this.m_pfj.setY2ScaleMinAuto(bl);
    }

    public double getAxisMaxAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getY2ScaleMaxAutoValue();
    }

    public double getAxisMaxValue() {
        return this.m_pfj.getY2ScaleMax();
    }

    public void setAxisMaxValue(double d) {
        this.m_pfj.setY2ScaleMax(d);
    }

    public double getAxisMinAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getY2ScaleMinAutoValue();
    }

    public double getAxisMinValue() {
        return this.m_pfj.getY2ScaleMin();
    }

    public void setAxisMinValue(double d) {
        this.m_pfj.setY2ScaleMin(d);
    }

    public double getMajorTickStep() {
        if (this.isMajorTickStepAutomatic() && !this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        if (this.m_graph.getGraphType() == 102) {
            return this.m_pfj.getParetoY2MajorGridStep();
        }
        return this.m_pfj.getY2MajorGridStep();
    }

    public double getAutoMajorTickStep() {
        if (!this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getY2MajorGridStepAutoValue();
    }

    public void setMajorTickStep(double d) {
        if (d < 0.0) {
            this.m_graph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setMajorTickStep (double value)");
        } else if (this.m_graph.getGraphType() == 102) {
            this.m_pfj.setParetoY2MajorGridStep(d);
        } else {
            this.m_pfj.setY2MajorGridStep(d);
        }
    }

    public boolean isMajorTickStepAutomatic() {
        return this.m_pfj.getY2MajorGridStepAuto();
    }

    public void setMajorTickStepAutomatic(boolean bl) {
        this.m_pfj.setY2MajorGridStepAuto(bl);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.m_pfj.setY2LabelDisplay(bl);
        this.m_pfj.setY2MajorGridDisplay(bl);
    }

    protected String getComponentName() {
        return "Y2Axis";
    }

    private void logError() {
        this.m_graph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setXML()");
    }

    protected void setMajorTickStepXML(ObjectNode objectNode) {
        double d;
        PropertyNode propertyNode = objectNode.getProperty("majorTickStep");
        if (propertyNode != null) {
            d = propertyNode.getValueAsDouble();
            if (d < 0.0) {
                this.logError();
            } else {
                this.m_pfj.setY2MajorGridStep(d);
            }
        }
        if ((propertyNode = objectNode.getProperty(a_paretoMajorTickStep)) != null) {
            d = propertyNode.getValueAsDouble();
            if (d < 0.0) {
                this.logError();
            } else {
                this.m_pfj.setParetoY2MajorGridStep(d);
            }
        }
    }

    protected boolean getMajorTickStepXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = false;
        if (bl || !this.isMajorTickStepAutomatic()) {
            objectNode.addProperty("majorTickStep", this.m_pfj.getY2MajorGridStep());
            bl2 = true;
        }
        if (bl || this.paretoMajorTickStep != this.m_pfj.getParetoY2MajorGridStep()) {
            objectNode.addProperty(a_paretoMajorTickStep, this.m_pfj.getParetoY2MajorGridStep());
            bl2 = true;
        }
        return bl2;
    }
}

