/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UIDataAxis;

public class Y1Axis
extends BaseDataAxis
implements UIDataAxis {
    protected double majorTickStep;

    public Y1Axis(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getY1Axis();
        this.m_identObj2 = this.m_pfj.getY1AxisLine();
        this.m_labelIdentObj = this.m_pfj.getY1Label();
        this.m_majorGridIdentObj = this.m_pfj.getY1MajorGrid();
        this.m_id = 46;
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.lineWidth = GraphDefaultValues.getY1AxisLineWidth();
        this.lineColor = GraphDefaultValues.getY1AxisLineColor();
        this.axisMinAutoScaled = GraphDefaultValues.isY1AxisMinAutoScaled();
        this.axisMaxAutoScaled = GraphDefaultValues.isY1AxisMaxAutoScaled();
        this.majorTickStepAutomatic = GraphDefaultValues.isY1MajorTickStepAutomatic();
        this.scaledLogarithmic = GraphDefaultValues.isY1AxisScaledLogarithmic();
        this.logarithmicBase = GraphDefaultValues.getY1AxisLogBase();
        this.visible = GraphDefaultValues.isY1AxisVisible();
        this.majorTickStep = GraphDefaultValues.getY1TickStep();
        this.axisMaxLabelVisible = GraphDefaultValues.isY1AxisMaxLabelVisible();
        this.axisMinLabelVisible = GraphDefaultValues.isY1AxisMinLabelVisible();
        this.acsending = GraphDefaultValues.isY1AxisAscending();
        this.axisLocation = GraphDefaultValues.getY1AxisLocation();
        this.axisAutoScaledFromZero = GraphDefaultValues.isY1AxisAutoScaledFromZero();
        this.minAutoMajorTickStep = GraphDefaultValues.getY1AxisMinAutoMajorTickStep();
    }

    public boolean isAxisAutoScaledFromZero() {
        return this.m_pfj.getY1MustIncludeZero();
    }

    public void setAxisAutoScaledFromZero(boolean bl) {
        this.m_pfj.setY1MustIncludeZero(bl);
    }

    public boolean isAxisMaxAutoScaled() {
        return this.m_pfj.getY1ScaleMaxAuto();
    }

    public void setAxisMaxAutoScaled(boolean bl) {
        this.m_pfj.setY1ScaleMaxAuto(bl);
    }

    public boolean isAxisMinAutoScaled() {
        return this.m_pfj.getY1ScaleMinAuto();
    }

    public void setAxisMinAutoScaled(boolean bl) {
        this.m_pfj.setY1ScaleMinAuto(bl);
    }

    public double getAxisMaxAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getY1ScaleMaxAutoValue();
    }

    public double getAxisMaxValue() {
        if (this.m_graph.getGraphType() != 102) {
            return this.m_pfj.getY1ScaleMax();
        }
        return this.getAxisMaxAutoValue();
    }

    public void setAxisMaxValue(double d) {
        this.m_pfj.setY1ScaleMax(d);
        if (this.m_graph.getGraphType() == 102) {
            this.m_graph.getErrorHandler().log("Current graph type doesn't support set Y1 axis maximum value", this.getClass().getName(), "setAxisMaxValue (double value)");
        }
    }

    public double getAxisMinAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getY1ScaleMinAutoValue();
    }

    public double getAxisMinValue() {
        if (this.m_graph.getGraphType() != 102) {
            return this.m_pfj.getY1ScaleMin();
        }
        return this.getAxisMinAutoValue();
    }

    public void setAxisMinValue(double d) {
        this.m_pfj.setY1ScaleMin(d);
        if (this.m_graph.getGraphType() == 102) {
            this.m_graph.getErrorHandler().log("Current graph type doesn't support set Y1 axis minimum value", this.getClass().getName(), "setAxisMinValue (double value)");
        }
    }

    public double getMajorTickStep() {
        if (this.isMajorTickStepAutomatic() && !this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getY1MajorGridStep();
    }

    public double getAutoMajorTickStep() {
        if (!this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getY1MajorGridStepAutoValue();
    }

    public void setMajorTickStep(double d) {
        if (d < 0.0) {
            this.m_graph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setMajorTickStep (double value)");
        } else {
            this.m_pfj.setY1MajorGridStep(d);
        }
    }

    public boolean isMajorTickStepAutomatic() {
        return this.m_pfj.getY1MajorGridStepAuto();
    }

    public void setMajorTickStepAutomatic(boolean bl) {
        this.m_pfj.setY1MajorGridStepAuto(bl);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.m_pfj.setY1LabelDisplay(bl);
        this.m_pfj.setY1MajorGridDisplay(bl);
    }

    protected String getComponentName() {
        return "Y1Axis";
    }
}

