/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;

public class X1Axis
extends BaseDataAxis {
    public X1Axis(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getX1Axis();
        this.m_identObj2 = this.m_pfj.getX1AxisLine();
        this.m_majorGridIdentObj = this.m_pfj.getX1MajorGrid();
        this.m_labelIdentObj = this.m_pfj.getX1Label();
        this.m_id = 41;
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.lineWidth = GraphDefaultValues.getX1AxisLineWidth();
        this.lineColor = GraphDefaultValues.getX1AxisLineColor();
        this.axisMinAutoScaled = GraphDefaultValues.isX1AxisMinAutoScaled();
        this.axisMaxAutoScaled = GraphDefaultValues.isX1AxisMaxAutoScaled();
        this.majorTickStepAutomatic = GraphDefaultValues.isX1MajorTickStepAutomatic();
        this.scaledLogarithmic = GraphDefaultValues.isX1AxisScaledLogarithmic();
        this.logarithmicBase = GraphDefaultValues.getX1AxisLogBase();
        this.visible = GraphDefaultValues.isX1AxisVisible();
        this.axisMaxLabelVisible = GraphDefaultValues.isX1AxisMaxLabelVisible();
        this.axisMinLabelVisible = GraphDefaultValues.isX1AxisMinLabelVisible();
        this.acsending = GraphDefaultValues.isX1AxisAscending();
        this.axisLocation = GraphDefaultValues.getX1AxisLocation();
        this.axisAutoScaledFromZero = GraphDefaultValues.isX1AxisAutoScaledFromZero();
        this.minAutoMajorTickStep = GraphDefaultValues.getX1AxisMinAutoMajorTickStep();
    }

    public void setMajorTickStep(double d) {
        if (d < 0.0) {
            this.m_graph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setMajorTickStep (double value)");
        } else {
            this.m_pfj.setX1MajorGridStep(d);
        }
    }

    public double getMajorTickStep() {
        if (this.isMajorTickStepAutomatic() && !this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getX1MajorGridStep();
    }

    public double getAutoMajorTickStep() {
        if (!this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getX1MajorGridStepAutoValue();
    }

    public boolean isAxisAutoScaledFromZero() {
        return this.m_pfj.getX1MustIncludeZero();
    }

    public void setAxisAutoScaledFromZero(boolean bl) {
        this.m_pfj.setX1MustIncludeZero(bl);
    }

    public boolean isAxisMaxAutoScaled() {
        return this.m_pfj.getX1ScaleMaxAuto();
    }

    public void setAxisMaxAutoScaled(boolean bl) {
        this.m_pfj.setX1ScaleMaxAuto(bl);
    }

    public boolean isAxisMinAutoScaled() {
        return this.m_pfj.getX1ScaleMinAuto();
    }

    public void setAxisMinAutoScaled(boolean bl) {
        this.m_pfj.setX1ScaleMinAuto(bl);
    }

    public double getAxisMaxAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getX1ScaleMaxAutoValue();
    }

    public double getAxisMaxValue() {
        return this.m_pfj.getX1ScaleMax();
    }

    public void setAxisMaxValue(double d) {
        this.m_pfj.setX1ScaleMax(d);
    }

    public double getAxisMinAutoValue() {
        if (!this.m_pfj.isCalculated()) {
            this.m_graph.calculatePlacement();
        }
        return this.m_pfj.getX1ScaleMinAutoValue();
    }

    public double getAxisMinValue() {
        return this.m_pfj.getX1ScaleMin();
    }

    public void setAxisMinValue(double d) {
        this.m_pfj.setX1ScaleMin(d);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.m_pfj.setX1AxisLineDisplay(bl);
        this.m_pfj.setX1LabelDisplay(bl);
        this.m_pfj.setX1MajorGridDisplay(bl);
    }

    public boolean isMajorTickStepAutomatic() {
        return this.m_pfj.getX1MajorGridStepAuto();
    }

    public void setMajorTickStepAutomatic(boolean bl) {
        this.m_pfj.setX1MajorGridStepAuto(bl);
    }

    protected String getComponentName() {
        return "X1Axis";
    }
}

