/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.sql.Date;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.graph.CustomToolTipCallback;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.graph.GraphNumberFormatCallback;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.pfj.TDGMouseState;
import oracle.dss.graph.pfj.ToolTipCallBack;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SeriesOutOfRangeException;

public class ToolTipTextCallback
implements ToolTipCallBack {
    static final String RETURN = "[R]";
    static final String OBJ_NAME = "[ON]";
    static final String OBJ_DESC = "[OD]";
    static final String OBJ_ID = "[OID]";
    static final String OBJ_INST = "[OIN]";
    static final String SERIES_LBL = "[SL]";
    static final String GROUP_LBL = "[GL]";
    protected boolean m_GraphIsOpenAndClose;
    protected boolean m_AxisLabelTipDisplayed = true;
    protected boolean m_GraphIsPieBar;
    protected boolean m_GraphIsSingleY;
    protected boolean m_GraphIsStacked;
    protected boolean m_MarkerTipDisplayed = true;
    protected boolean m_SeriesAreRows = true;
    protected boolean m_ShowColDimName;
    protected boolean m_ShowRowDimName;
    protected boolean m_ShowGroupLabels = true;
    protected boolean m_ShowSeriesLabels = true;
    protected boolean m_CumValTip;
    protected boolean m_PercentTip;
    protected boolean m_TextTip = true;
    protected boolean m_ValueTip = true;
    protected int m_ObjectID;
    protected int m_GroupID;
    protected int m_SeriesID;
    protected int m_ColID;
    protected int m_RowID;
    protected int m_MarkerTipType = 9;
    protected int m_TipGroupLabelType = 1;
    protected int m_TipSeriesLabelType = 1;
    protected int m_ValuesPerGroup;
    protected int m_DataValuesPerMarker;
    protected String m_txtCl;
    protected String m_txtHi;
    protected String m_txtLo;
    protected String m_txtOp;
    protected String m_txtVo;
    protected String m_txtX;
    protected String m_txtY;
    protected String m_txtZ;
    protected String m_txtGr;
    protected String m_txtSe;
    protected String m_txtCu;
    protected String m_txtPe;
    protected String m_txtVa;
    protected String m_txtBV;
    protected String m_DimNameType = "dimShortName";
    protected String m_DimMemberNameType = "shortName";
    protected boolean m_excelOrDeskTop;
    protected Graph m_graph;
    protected DataAccess m_dataAccess;
    protected GraphFormatManager m_fmtMgr;
    protected GraphNumberFormatCallback m_numFormatCallback;
    protected CustomToolTipCallback m_customToolTipCallback;
    protected ResourceBundle rBundle;
    protected String m_measureDim = "";
    private static final String m_method_getFormattedValue = "public String getFormattedValue(double dVal, int axis, boolean isPercent, boolean isPieSlice)";

    public ToolTipTextCallback(Graph graph, GraphNumberFormatCallback graphNumberFormatCallback) {
        this.m_graph = graph;
        this.m_numFormatCallback = graphNumberFormatCallback;
        this.m_fmtMgr = this.m_graph.getGraphFormatManager();
        this.m_SeriesAreRows = this.m_graph.isDataRowShownAsASeries();
        this.setGraphType(graph.getGraphType());
        this.updateResourceBundle();
        this.m_txtGr = this.m_graph.getIntlString("Group: ", this.rBundle);
        this.m_txtSe = this.m_graph.getIntlString("Series: ", this.rBundle);
        this.m_txtCu = this.m_graph.getIntlString("Cumulative: ", this.rBundle);
        this.m_txtPe = this.m_graph.getIntlString("Percent: ", this.rBundle);
        this.m_txtVa = this.m_graph.getIntlString("Value: ", this.rBundle);
        this.m_txtOp = this.m_graph.getIntlString("Open: ", this.rBundle);
        this.m_txtHi = this.m_graph.getIntlString("High: ", this.rBundle);
        this.m_txtLo = this.m_graph.getIntlString("Low: ", this.rBundle);
        this.m_txtCl = this.m_graph.getIntlString("Close: ", this.rBundle);
        this.m_txtVo = this.m_graph.getIntlString("Volume: ", this.rBundle);
        this.m_txtX = this.m_graph.getIntlString("X: ", this.rBundle);
        this.m_txtY = this.m_graph.getIntlString("Y: ", this.rBundle);
        this.m_txtZ = this.m_graph.getIntlString("Z: ", this.rBundle);
        this.m_txtBV = this.m_graph.getIntlString("Base Line Value: ", this.rBundle);
    }

    public void getDataAccess() {
        this.m_dataAccess = this.m_graph.getGraphModel().getDataAccess();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDynamicToolTip(TDGMouseState tDGMouseState, boolean bl) {
        int[] nArray;
        String string = "";
        this.m_ObjectID = tDGMouseState.getElementObjectID();
        this.m_SeriesID = tDGMouseState.getElementSeriesID();
        this.m_GroupID = tDGMouseState.getElementGroupID();
        this.m_excelOrDeskTop = this.m_graph.isExcelOrDeskTop();
        if (this.m_graph.getPFJ().isTimeAxis() && (nArray = this.m_graph.getPFJ().getMissingGroups()) != null) {
            int n = 0;
            while (n < nArray.length) {
                if (this.m_GroupID > nArray[n]) {
                    this.m_GroupID -= n + 1;
                    break;
                }
                ++n;
            }
        }
        this.m_txtGr = this.m_graph.getIntlString("Group: ", this.rBundle);
        this.m_txtSe = this.m_graph.getIntlString("Series: ", this.rBundle);
        this.m_txtCu = this.m_graph.getIntlString("Cumulative: ", this.rBundle);
        this.m_txtPe = this.m_graph.getIntlString("Percent: ", this.rBundle);
        this.m_txtVa = this.m_graph.getIntlString("Value: ", this.rBundle);
        this.m_txtOp = this.m_graph.getIntlString("Open: ", this.rBundle);
        this.m_txtHi = this.m_graph.getIntlString("High: ", this.rBundle);
        this.m_txtLo = this.m_graph.getIntlString("Low: ", this.rBundle);
        this.m_txtCl = this.m_graph.getIntlString("Close: ", this.rBundle);
        this.m_txtVo = this.m_graph.getIntlString("Volume: ", this.rBundle);
        this.m_txtX = this.m_graph.getIntlString("X: ", this.rBundle);
        this.m_txtY = this.m_graph.getIntlString("Y: ", this.rBundle);
        this.m_txtZ = this.m_graph.getIntlString("Z: ", this.rBundle);
        this.m_txtBV = this.m_graph.getIntlString("Base Line Value: ", this.rBundle);
        try {
            if (this.m_SeriesAreRows) {
                this.m_RowID = this.m_SeriesID;
                this.m_ColID = this.m_GroupID * this.m_ValuesPerGroup;
            } else {
                this.m_RowID = this.m_GroupID * this.m_ValuesPerGroup;
                this.m_ColID = this.m_SeriesID;
            }
            block1 : switch (tDGMouseState.getElementObjectID()) {
                case 259: 
                case 277: 
                case 312: 
                case 313: 
                case 330: 
                case 331: 
                case 334: 
                case 335: 
                case 474: 
                case 513: 
                case 517: 
                case 518: 
                case 519: 
                case 520: {
                    int n;
                    int n2;
                    if (!this.m_MarkerTipDisplayed) return null;
                    if (this.m_TextTip) {
                        if (this.m_ShowSeriesLabels) {
                            string = this.m_SeriesAreRows ? String.valueOf(string) + this.getRowLabels(this.m_RowID, this.m_ColID) : String.valueOf(string) + this.getColumnLabels(this.m_RowID, this.m_ColID);
                        }
                        if (this.m_ShowGroupLabels) {
                            string = this.m_SeriesAreRows ? String.valueOf(string) + this.getColumnLabels(this.m_RowID, this.m_ColID) : String.valueOf(string) + this.getRowLabels(this.m_RowID, this.m_ColID);
                        }
                    }
                    if (this.m_ValueTip) {
                        Object var16_5 = null;
                        switch (this.m_DataValuesPerMarker) {
                            case 1: {
                                String string2 = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                if (string2 != null) {
                                    this.m_txtVa = string2;
                                }
                                string = String.valueOf(string) + this.m_txtVa + "[YV]" + RETURN;
                                break;
                            }
                            case 2: {
                                String string3;
                                String string4 = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                if (string4 != null) {
                                    this.m_txtX = string4;
                                }
                                if ((string3 = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                    this.m_txtY = string3;
                                }
                                string = String.valueOf(string) + this.m_txtX + "[XV]" + RETURN + this.m_txtY + "[YV]" + RETURN;
                                break;
                            }
                            case 3: {
                                String string5;
                                String string6;
                                String string7 = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                if (string7 != null) {
                                    this.m_txtX = string7;
                                }
                                if ((string6 = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                    this.m_txtY = string6;
                                }
                                if ((string5 = this.getValueLabel(this.m_RowID, this.m_ColID, 2)) != null) {
                                    this.m_txtZ = string5;
                                }
                                string = String.valueOf(string) + this.m_txtX + "[XV]" + RETURN + this.m_txtY + "[YV]" + RETURN + this.m_txtZ + "[ZV]" + RETURN;
                                break;
                            }
                        }
                    }
                    if (this.m_GraphIsStacked && this.m_CumValTip) {
                        int n3 = this.m_graph.getGraphType();
                        switch (this.m_graph.getGraphType()) {
                            case 23: 
                            case 30: 
                            case 35: 
                            case 40: 
                            case 47: 
                            case 54: {
                                boolean bl2;
                                double d = 0.0;
                                if (this.m_SeriesAreRows && !this.m_GraphIsPieBar || !this.m_SeriesAreRows && this.m_GraphIsPieBar) {
                                    bl2 = this.isAssignedToY2(this.m_RowID);
                                    n2 = 0;
                                    while (n2 <= this.m_RowID) {
                                        if (bl2 == this.isAssignedToY2(n2) || this.m_GraphIsSingleY) {
                                            d += this.getValue(n2, this.m_ColID);
                                        }
                                        ++n2;
                                    }
                                } else {
                                    bl2 = this.isAssignedToY2(this.m_ColID);
                                    n2 = 0;
                                    while (n2 <= this.m_ColID) {
                                        if (bl2 == this.isAssignedToY2(n2) || this.m_GraphIsSingleY) {
                                            d += this.getValue(this.m_RowID, n2);
                                        }
                                        ++n2;
                                    }
                                }
                                n = this.m_GraphIsSingleY ? 63 : (bl2 ? 64 : 63);
                                string = String.valueOf(string) + this.m_txtCu + this.getFormattedValue(d, n, false, false);
                                break;
                            }
                            default: {
                                string = String.valueOf(string) + this.m_txtCu + "[CUMSTKV]";
                            }
                        }
                    }
                    if (!this.m_PercentTip) break;
                    switch (this.m_graph.getGraphType()) {
                        case 23: 
                        case 30: 
                        case 35: 
                        case 40: 
                        case 47: 
                        case 54: {
                            double d = 0.0;
                            if (this.m_SeriesAreRows) {
                                n2 = 0;
                                while (n2 < this.m_graph.getRowCount()) {
                                    d += Math.abs(this.getValue(n2, this.m_ColID));
                                    ++n2;
                                }
                            } else {
                                n2 = 0;
                                while (n2 < this.m_graph.getColumnCount()) {
                                    d += Math.abs(this.getValue(this.m_RowID, n2));
                                    ++n2;
                                }
                            }
                            double d2 = Math.abs(this.getValue(this.m_RowID, this.m_ColID)) / d;
                            n = 63;
                            string = String.valueOf(string) + this.m_txtPe + this.getFormattedValue(d2, n, true, false);
                        }
                    }
                    break;
                }
                case 298: 
                case 299: 
                case 300: 
                case 332: 
                case 333: {
                    if (!this.m_MarkerTipDisplayed) return null;
                    if (this.m_TextTip) {
                        if (this.m_ShowSeriesLabels) {
                            string = this.m_SeriesAreRows ? String.valueOf(string) + this.getRowLabels(this.m_RowID, this.m_ColID) : String.valueOf(string) + this.getColumnLabels(this.m_RowID, this.m_ColID);
                        }
                        if (this.m_ShowGroupLabels && !this.m_GraphIsPieBar) {
                            string = this.m_SeriesAreRows ? String.valueOf(string) + this.getColumnLabels(this.m_RowID, this.m_ColID) : String.valueOf(string) + this.getRowLabels(this.m_RowID, this.m_ColID);
                        }
                    }
                    if (this.m_ValueTip) {
                        String string8 = null;
                        string8 = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                        if (string8 != null) {
                            this.m_txtVa = string8;
                        }
                        string = String.valueOf(string) + this.m_txtVa + "[YV]" + RETURN;
                    }
                    if (this.m_PercentTip) {
                        string = String.valueOf(string) + this.m_txtPe + "[PIEPCTV]" + "%";
                    }
                    break;
                }
                case 310: {
                    if (!this.m_MarkerTipDisplayed) return null;
                    if (this.m_TextTip) {
                        if (this.m_ShowSeriesLabels) {
                            string = this.m_SeriesAreRows ? String.valueOf(string) + this.getRowLabels(this.m_RowID - 1, this.m_ColID) : String.valueOf(string) + this.getColumnLabels(this.m_RowID, this.m_ColID);
                        }
                        if (this.m_ShowGroupLabels) {
                            string = this.m_SeriesAreRows ? String.valueOf(string) + this.getColumnLabels(this.m_RowID, this.m_ColID) : String.valueOf(string) + this.getRowLabels(this.m_RowID, this.m_ColID);
                        }
                    }
                    if (this.m_ValueTip) {
                        string = String.valueOf(string) + this.m_txtVo + "[VV]";
                    }
                    break;
                }
                case 303: 
                case 306: 
                case 307: 
                case 308: 
                case 319: 
                case 320: {
                    if (!this.m_MarkerTipDisplayed) return null;
                    if (this.m_TextTip) {
                        if (this.m_ShowSeriesLabels) {
                            string = this.m_SeriesAreRows ? String.valueOf(string) + this.getRowLabels(this.m_RowID, this.m_ColID) : String.valueOf(string) + this.getColumnLabels(this.m_RowID, this.m_ColID);
                        }
                        if (this.m_ShowGroupLabels) {
                            string = this.m_SeriesAreRows ? String.valueOf(string) + this.getColumnLabels(this.m_RowID, this.m_ColID) : String.valueOf(string) + this.getRowLabels(this.m_RowID, this.m_ColID);
                        }
                    }
                    if (this.m_ValueTip) {
                        String string9 = null;
                        switch (this.m_DataValuesPerMarker) {
                            case 2: {
                                if (this.m_GraphIsOpenAndClose) {
                                    string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                    if (string9 != null) {
                                        this.m_txtOp = string9;
                                    }
                                    if ((string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                        this.m_txtCl = string9;
                                    }
                                    string = String.valueOf(string) + this.m_txtOp + "[OV]" + RETURN + this.m_txtCl + "[CV]";
                                    break block1;
                                }
                                string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                if (string9 != null) {
                                    this.m_txtHi = string9;
                                }
                                if ((string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                    this.m_txtLo = string9;
                                }
                                string = String.valueOf(string) + this.m_txtHi + "[HV]" + RETURN + this.m_txtLo + "[LV]";
                                break block1;
                            }
                            case 3: {
                                string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                if (string9 != null) {
                                    this.m_txtHi = string9;
                                }
                                if ((string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                    this.m_txtLo = string9;
                                }
                                if ((string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 2)) != null) {
                                    this.m_txtCl = string9;
                                }
                                string = String.valueOf(string) + this.m_txtHi + "[HV]" + RETURN + this.m_txtLo + "[LV]" + RETURN + this.m_txtCl + "[CV]";
                                break block1;
                            }
                            case 4: {
                                string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 0);
                                if (string9 != null) {
                                    this.m_txtOp = string9;
                                }
                                if ((string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 1)) != null) {
                                    this.m_txtHi = string9;
                                }
                                if ((string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 2)) != null) {
                                    this.m_txtLo = string9;
                                }
                                if ((string9 = this.getValueLabel(this.m_RowID, this.m_ColID, 3)) != null) {
                                    this.m_txtCl = string9;
                                }
                                string = String.valueOf(string) + this.m_txtOp + "[OV]" + RETURN + this.m_txtHi + "[HV]" + RETURN + this.m_txtLo + "[LV]" + RETURN + this.m_txtCl + "[CV]";
                                break block1;
                            }
                        }
                    }
                    break;
                }
                case 13: 
                case 14: {
                    if (this.m_graph.getPFJ().isLegendLabelsTruncated()) {
                        if (this.m_graph.getGraphType() > 14) {
                            string = String.valueOf(string) + this.getWrappedText(this.m_graph.getPFJ().getSeriesLabel(this.m_SeriesID));
                            break;
                        }
                        Vector vector = this.m_graph.getPFJ().getLegendObj().getMarkersLabels().getLabels();
                        if (vector != null) {
                            string = String.valueOf(string) + vector.elementAt(this.m_SeriesID);
                        }
                    }
                    break;
                }
                case 18: {
                    Vector vector;
                    if (this.m_graph.getPFJ().isLegendLabelsTruncated() && (vector = this.m_graph.getPFJ().getLegendObj().getMarkersLabels().getLabels()) != null) {
                        string = String.valueOf(string) + vector.elementAt(tDGMouseState.getIdentObj().getMiscID());
                    }
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (this.m_graph.getPFJ().isAxisTitleTruncated(this.m_ObjectID)) {
                        string = String.valueOf(string) + this.getWrappedText(this.m_graph.getPFJ().getTextString(this.m_ObjectID));
                    }
                    break;
                }
                case 5: {
                    if (this.m_graph.getPFJ().isTitleTruncated(this.m_ObjectID)) {
                        string = String.valueOf(string) + this.getWrappedText(this.m_graph.getPFJ().getTitleString());
                    }
                    break;
                }
                case 4: {
                    if (this.m_graph.getPFJ().isTitleTruncated(this.m_ObjectID)) {
                        string = String.valueOf(string) + this.getWrappedText(this.m_graph.getPFJ().getSubtitleString());
                    }
                    break;
                }
                case 3: {
                    if (this.m_graph.getPFJ().isTitleTruncated(this.m_ObjectID)) {
                        string = String.valueOf(string) + this.getWrappedText(this.m_graph.getPFJ().getFootnoteString());
                    }
                    break;
                }
                case 270: 
                case 280: {
                    if (this.m_graph.getGraphType() >= 65 && this.m_graph.getGraphType() <= 68 && this.m_graph.getPFJ().isO1LabelsTruncated()) {
                        string = String.valueOf(string) + this.getWrappedText(this.m_graph.getPFJ().getGroupLabel(this.m_GroupID));
                    }
                    break;
                }
                case 358: {
                    double d = 0.0;
                    String string10 = "";
                    switch (this.m_GroupID) {
                        case 279: {
                            d = this.m_graph.getX1ReferenceLine().getValue(this.m_SeriesID);
                            string10 = this.m_graph.getX1ReferenceLine().getText(this.m_SeriesID);
                            break;
                        }
                        case 283: {
                            d = this.m_graph.getY1ReferenceLine().getValue(this.m_SeriesID);
                            string10 = this.m_graph.getY1ReferenceLine().getText(this.m_SeriesID);
                            break;
                        }
                        case 287: {
                            d = this.m_graph.getY2ReferenceLine().getValue(this.m_SeriesID);
                            string10 = this.m_graph.getY2ReferenceLine().getText(this.m_SeriesID);
                        }
                    }
                    NumberFormat numberFormat = this.m_graph.getLocale() != null ? NumberFormat.getInstance(this.m_graph.getLocale()) : NumberFormat.getInstance();
                    numberFormat.setGroupingUsed(false);
                    String string11 = numberFormat.format(d);
                    string = String.valueOf(string) + this.getWrappedText(String.valueOf(string10) + ": " + string11);
                    break;
                }
                case 248: 
                case 249: {
                    if (this.m_graph.getPFJ().isLegendLabelsTruncated()) {
                        String string12 = "";
                        switch (this.m_GroupID) {
                            case 279: {
                                string12 = this.m_graph.getX1ReferenceLine().getText(this.m_SeriesID);
                                break;
                            }
                            case 283: {
                                string12 = this.m_graph.getY1ReferenceLine().getText(this.m_SeriesID);
                                break;
                            }
                            case 287: {
                                string12 = this.m_graph.getY2ReferenceLine().getText(this.m_SeriesID);
                            }
                        }
                        string = String.valueOf(string) + this.getWrappedText(string12);
                    }
                    break;
                }
                case 234: 
                case 235: {
                    if (this.m_graph.getPFJ().isLegendLabelsTruncated()) {
                        String string13 = this.m_graph.getPFJ().getDrillCallback().getDrillUpLabel(14);
                        string = String.valueOf(string) + this.getWrappedText(string13);
                    }
                    break;
                }
                case 253: {
                    double d = 0.0;
                    switch (this.m_SeriesID) {
                        case 283: {
                            d = this.m_graph.getY1BaseLine().getValue();
                            break;
                        }
                        case 287: {
                            d = this.m_graph.getY2BaseLine().getValue();
                        }
                    }
                    string = String.valueOf(string) + this.m_txtBV + d;
                    break;
                }
                case 295: {
                    if (!this.m_graph.getPFJ().isSliceLabelsTruncated()) break;
                    string = String.valueOf(string) + this.getWrappedText(tDGMouseState.getElementText());
                }
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.m_graph.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "getDynamicToolTip");
        }
        if (this.m_customToolTipCallback == null) return string;
        return this.m_customToolTipCallback.getToolTipText(string, this.m_graph.getGraphComponentHandle(tDGMouseState));
    }

    public String getFormattedValue(double d, int n, boolean bl, boolean bl2) {
        ViewFormat viewFormat = null;
        QDR qDR = new DataComponentInfo(this.m_RowID, this.m_ColID).getQDR(this.m_dataAccess, 1);
        if (bl2) {
            viewFormat = this.m_graph.getSliceLabel().getViewFormat();
            return this.m_fmtMgr.formatPieValue(d, viewFormat, bl, qDR, true);
        }
        viewFormat = this.m_numFormatCallback.getMarkerTextViewFormat(this.m_SeriesID, this.m_GroupID);
        return this.m_fmtMgr.formatDataValue(d, viewFormat, n, this.m_ColID, this.m_RowID, bl, qDR, true);
    }

    private String getValueLabel(int n, int n2, int n3) {
        block28: {
            if (n < 0 || n2 < 0) {
                return null;
            }
            DataCallback dataCallback = (DataCallback)this.m_graph.getDataFilter();
            QDR qDR = null;
            try {
                int n4;
                int n5;
                int n6 = 0;
                if (this.m_ValuesPerGroup > 1) {
                    Object object;
                    n5 = 0;
                    if (!this.m_excelOrDeskTop) {
                        if (this.m_SeriesAreRows) {
                            n6 = 0;
                            n5 = dataCallback.getDataAccessColumn(n2 + n3);
                        } else {
                            n6 = 1;
                            n5 = dataCallback.getDataAccessRow(n + n3);
                        }
                    } else if (this.m_SeriesAreRows) {
                        n6 = 1;
                        n5 = dataCallback.getDataAccessRow(n, n2 + n3);
                    } else {
                        n6 = 0;
                        n5 = dataCallback.getDataAccessColumn(n + n3, n2);
                    }
                    n4 = this.m_dataAccess.getLayerCount(n6);
                    if (n4 > 1 && (object = this.m_dataAccess.getMemberMetadata(n6, n4 - 1, n5, this.m_graph.getMemberMetadataLabelType(n6))) != null) {
                        String string = String.valueOf(object.toString()) + ": ";
                        return string;
                    }
                }
                if ((qDR = this.m_dataAccess.getValueQDR(dataCallback.getDataAccessRow(n, n2), dataCallback.getDataAccessColumn(n, n2), 1)) != null) {
                    this.m_measureDim = qDR.getMeasureDim();
                    n5 = 0;
                    while (n5 < this.m_dataAccess.getEdgeCount()) {
                        n4 = -1;
                        if (n5 == 2) {
                            n4 = this.m_dataAccess.getEdgeCurrentSlice(n5);
                        } else if (n5 == 0) {
                            if (this.m_excelOrDeskTop) {
                                n4 = n + n3;
                                n4 = dataCallback.getDataAccessColumn(n4, n2);
                            } else {
                                n4 = n2 + n3;
                                n4 = dataCallback.getDataAccessColumn(n, n4);
                            }
                        } else if (this.m_excelOrDeskTop) {
                            n4 = n2 + n3;
                            n4 = dataCallback.getDataAccessRow(n, n4);
                        } else {
                            n4 = n + n3;
                            n4 = dataCallback.getDataAccessRow(n4, n2);
                        }
                        int n7 = 0;
                        while (n7 < this.m_dataAccess.getLayerCount(n5)) {
                            String string = null;
                            Object object = null;
                            try {
                                object = this.m_dataAccess.getLayerMetadata(n5, n7, "dimName");
                                if (object != null) {
                                    string = object.toString();
                                }
                            }
                            catch (LayerOutOfRangeException layerOutOfRangeException) {
                                string = null;
                            }
                            if (string != null && string.equals(this.m_measureDim)) {
                                Object object2 = this.m_dataAccess.getMemberMetadata(n5, n7, n4, this.m_graph.getMemberMetadataLabelType(n5));
                                if (object2 != null) {
                                    String string2 = String.valueOf(object2.toString()) + ": ";
                                    return string2;
                                }
                                String string3 = null;
                                return string3;
                            }
                            int n8 = this.m_dataAccess.getMemberDepth(n5, n7, n4);
                            if (n8 > 1) {
                                n7 += n8 - 1;
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                    break block28;
                }
                String string = null;
                return string;
            }
            catch (Exception exception) {
                String string = null;
                return string;
            }
        }
        return null;
    }

    public Object getColumnLabels(int n, int n2) {
        return this.getWrappedText(this.getLabels(n, n2, 0, this.m_ShowColDimName, this.m_SeriesAreRows));
    }

    public Object getRowLabels(int n, int n2) {
        return this.getWrappedText(this.getLabels(n, n2, 1, this.m_ShowRowDimName, !this.m_SeriesAreRows));
    }

    protected Object getLabels(int n, int n2, int n3, boolean bl, boolean bl2) {
        Vector vector;
        Object object;
        String string;
        int n4 = n3;
        DataCallback dataCallback = (DataCallback)this.m_graph.getDataFilter();
        if (this.m_excelOrDeskTop) {
            int n5 = n4 = n3 == 0 ? 1 : 0;
        }
        if (!this.m_graph.isLayerMetadataLabelTypeSupported(string = this.m_graph.getLayerMetadataLabelType(n4)) || n2 < 0 || n < 0) {
            return this.getDefaultLabels(n, n2, n3, bl, bl2);
        }
        boolean bl3 = false;
        if (this.m_graph.getPFJ().isTimeAxis() && (n3 == 0 && this.m_SeriesAreRows || n3 == 1 && !this.m_SeriesAreRows)) {
            bl3 = true;
        }
        String string2 = "";
        Vector<QDR> vector2 = new Vector<QDR>();
        int n6 = n3 == 0 && bl2 || n3 == 1 && bl2 ? this.m_DataValuesPerMarker : 1;
        boolean bl4 = n3 == 0;
        int n7 = 0;
        while (n7 < n6) {
            try {
                int n8 = 0;
                n8 = bl4 ? (this.m_excelOrDeskTop ? dataCallback.getDataAccessRow(n, n2 + n7) : dataCallback.getDataAccessColumn(n, n2 + n7)) : (this.m_excelOrDeskTop ? dataCallback.getDataAccessColumn(n + n7, n2) : dataCallback.getDataAccessRow(n + n7, n2));
                object = this.m_dataAccess.getSliceQDR(n4, n8, 1);
                if (object != null) {
                    vector2.addElement((QDR)object);
                }
            }
            catch (Exception exception) {
                this.m_graph.getErrorHandler().error(exception, this.getClass().getName(), "getLabels");
            }
            ++n7;
        }
        this.m_measureDim = "";
        if (this.m_ValuesPerGroup > 1) {
            int n9 = 0;
            try {
                if (!this.m_excelOrDeskTop) {
                    if (this.m_SeriesAreRows) {
                        n7 = 0;
                        n9 = dataCallback.getDataAccessColumn(n, n2);
                    } else {
                        n7 = 1;
                        n9 = dataCallback.getDataAccessRow(n, n2);
                    }
                } else if (this.m_SeriesAreRows) {
                    n7 = 1;
                    n9 = dataCallback.getDataAccessRow(n, n2);
                } else {
                    n7 = 0;
                    n9 = dataCallback.getDataAccessColumn(n, n2);
                }
                int n10 = this.m_dataAccess.getLayerCount(n7);
                if (n10 > 1 && (vector = this.m_dataAccess.getLayerMetadata(n7, n10 - 1, "dimName")) != null) {
                    this.m_measureDim = ((Object)vector).toString();
                }
            }
            catch (Exception exception) {
                this.m_graph.getErrorHandler().error(exception, this.getClass().getName(), "getLabels");
            }
        }
        if (this.m_measureDim.equals("")) {
            if (this.m_excelOrDeskTop) {
                this.getDefaultLabels(n, n2, n3, bl, bl2);
            }
            if (vector2.size() == 0) {
                return this.getDefaultLabels(n, n2, n3, bl, bl2);
            }
            this.m_measureDim = ((QDR)vector2.elementAt(0)).getMeasureDim();
        }
        if (this.m_measureDim.equals("")) {
            return this.getDefaultLabels(n, n2, n3, bl, bl2);
        }
        Vector<Vector> vector3 = new Vector<Vector>(vector2.size());
        int n11 = 0;
        while (n11 < vector2.size()) {
            object = ((QDR)vector2.elementAt(n11)).getDimensions();
            vector = new Vector();
            while (object.hasMoreElements()) {
                String string3 = (String)object.nextElement();
                if (string3 == null || string3.equals(this.m_measureDim)) continue;
                try {
                    int n12 = 0;
                    while (n12 < this.m_dataAccess.getLayerCount(n4)) {
                        int n13;
                        String string4 = null;
                        String string5 = null;
                        Object object2 = null;
                        try {
                            object2 = this.m_dataAccess.getLayerMetadata(n4, n12, "dimName");
                            if (object2 != null) {
                                string4 = object2.toString();
                            }
                        }
                        catch (LayerOutOfRangeException layerOutOfRangeException) {
                            string4 = null;
                        }
                        int n14 = 0;
                        n14 = bl4 ? (this.m_excelOrDeskTop ? dataCallback.getDataAccessRow(n, n2 + n11) : dataCallback.getDataAccessColumn(n, n2)) : (this.m_excelOrDeskTop ? dataCallback.getDataAccessColumn(n + n11, n2) : dataCallback.getDataAccessRow(n, n2));
                        if (string4 != null && string4.equals(string3)) {
                            if (bl3 && this.m_dataAccess.getLayerCount(n4) == 2) {
                                if (this.m_graph.isMetadataDateSupported() && n12 == 0) {
                                    object2 = this.m_dataAccess.getMemberMetadata(n4, n12, n14, "date");
                                }
                                if (object2 != null) {
                                    object2 = this.convertDateToString(object2);
                                }
                            } else if (bl3) {
                                if (this.m_graph.isMetadataDateSupported()) {
                                    object2 = this.m_dataAccess.getMemberMetadata(n4, n12, n14, "date");
                                }
                                if (object2 != null) {
                                    object2 = this.convertDateToString(object2);
                                }
                            } else {
                                object2 = this.m_dataAccess.getMemberMetadata(n4, n12, n14, this.m_graph.getMemberMetadataLabelType(n3));
                            }
                            if (object2 != null) {
                                string5 = object2.toString();
                            }
                            if (string5 != null) {
                                object2 = this.m_dataAccess.getLayerMetadata(n4, n12, string);
                                String string6 = null;
                                if (object2 != null) {
                                    string6 = object2.toString();
                                }
                                vector.addElement(null.new DimValuePairs(string6, string5));
                            }
                        }
                        if ((n13 = this.m_dataAccess.getMemberDepth(n4, n12, n14)) > 1) {
                            n12 += n13 - 1;
                        }
                        ++n12;
                    }
                }
                catch (Exception exception) {
                    this.m_graph.getErrorHandler().error(exception, this.getClass().getName(), "getLabels");
                    this.getDefaultLabels(n, n2, n3, bl, bl2);
                }
            }
            vector3.addElement(vector);
            ++n11;
        }
        Vector vector4 = this.getCommonDimensionsWithNoDuplicats(vector3);
        int n15 = 0;
        while (n15 < vector4.size()) {
            if (vector4.elementAt(n15) != null) {
                string2 = String.valueOf(string2) + ((DimValuePairs)vector4.elementAt((int)n15)).dim + ": " + ((DimValuePairs)vector4.elementAt((int)n15)).value + RETURN;
            }
            ++n15;
        }
        n15 = 0;
        while (n15 < vector3.size()) {
            vector = (Vector)vector3.elementAt(n15);
            int n16 = 0;
            while (n16 < vector.size()) {
                if (!this.hasSameValues(vector4, (DimValuePairs)vector.elementAt(n16))) {
                    string2 = String.valueOf(string2) + ((DimValuePairs)vector.elementAt((int)n16)).dim + ": " + ((DimValuePairs)vector.elementAt((int)n16)).value + RETURN;
                }
                ++n16;
            }
            ++n15;
        }
        return String.valueOf(string2.trim()) + RETURN;
    }

    private boolean hasSameValues(Vector vector, DimValuePairs dimValuePairs) {
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) != null && dimValuePairs.equals((DimValuePairs)vector.elementAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected Vector getCommonDimensionsWithNoDuplicats(Vector vector) {
        Object e = vector.elementAt(0);
        Vector vector2 = (Vector)e;
        Vector vector3 = (Vector)vector2.clone();
        int n = 0;
        while (n < vector3.size()) {
            String string = ((DimValuePairs)vector3.elementAt((int)n)).dim;
            String string2 = ((DimValuePairs)vector3.elementAt((int)n)).value;
            int n2 = 1;
            while (n2 < vector.size()) {
                Vector vector4 = (Vector)vector.elementAt(n2);
                boolean bl = false;
                int n3 = 0;
                while (n3 < vector4.size()) {
                    if (string.equals(((DimValuePairs)vector4.elementAt((int)n3)).dim)) {
                        bl = true;
                        String string3 = ((DimValuePairs)vector4.elementAt((int)n3)).value;
                        if (!string2.equals(string3)) {
                            vector3.setElementAt(null, n);
                        }
                    }
                    ++n3;
                }
                if (!bl) {
                    vector3.setElementAt(null, n);
                }
                ++n2;
            }
            ++n;
        }
        return vector3;
    }

    protected Object getDefaultLabels(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.m_DimNameType = this.m_graph.getLayerMetadataLabelType(n3);
        this.m_DimMemberNameType = this.m_graph.getMemberMetadataLabelType(n3);
        DataCallback dataCallback = (DataCallback)this.m_graph.getDataFilter();
        int n4 = 0;
        n4 = n3 == 0 ? dataCallback.getDataAccessColumn(n, n2) : dataCallback.getDataAccessRow(n, n2);
        String string = "";
        int n5 = 0;
        try {
            n5 = this.m_dataAccess.getLayerCount(n3);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.m_graph.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "getDefaultLabels");
        }
        boolean bl3 = false;
        if (this.m_graph.getPFJ().isTimeAxis() && (n3 == 0 && this.m_SeriesAreRows || n3 == 1 && !this.m_SeriesAreRows)) {
            bl3 = true;
        }
        if (this.m_graph.isLayerMetadataLabelTypeSupported(this.m_DimNameType) || this.m_graph.isMemberMetadataLabelTypeSupported(this.m_DimMemberNameType)) {
            try {
                Object object = null;
                Object var12_14 = null;
                int n6 = 0;
                while (n6 < n5) {
                    if (bl) {
                        string = this.m_graph.isLayerMetadataLabelTypeSupported(this.m_DimNameType) ? ((object = this.m_dataAccess.getLayerMetadata(n3, n6, this.m_DimNameType)) != null ? String.valueOf(string) + object.toString() + ":" : String.valueOf(string) + ":") : String.valueOf(string) + ":";
                    }
                    if (this.m_graph.isMemberMetadataLabelTypeSupported(this.m_DimMemberNameType)) {
                        if (bl3 && n5 == 2) {
                            if (this.m_graph.isMetadataDateSupported() && n6 == 0) {
                                object = this.m_dataAccess.getMemberMetadata(n3, n6, n4, "date");
                            }
                            if (object == null) {
                                object = this.m_dataAccess.getMemberMetadata(n3, n6, n4, this.m_DimMemberNameType);
                            }
                            if (object != null) {
                                object = this.convertDateToString(object);
                            }
                        } else if (bl3) {
                            if (this.m_graph.isMetadataDateSupported()) {
                                object = this.m_dataAccess.getMemberMetadata(n3, n6, n4, "date");
                            }
                            if (object == null) {
                                object = this.m_dataAccess.getMemberMetadata(n3, n6, n4, this.m_DimMemberNameType);
                            }
                            if (object != null) {
                                object = this.convertDateToString(object);
                            }
                        } else {
                            object = this.m_excelOrDeskTop ? (this.m_SeriesAreRows ? (n3 == 1 ? dataCallback.rowLabel(n) : dataCallback.columnLabel(this.m_GroupID)) : (n3 == 1 ? dataCallback.rowLabel(this.m_GroupID) : dataCallback.columnLabel(n2))) : this.m_dataAccess.getMemberMetadata(n3, n6, n4, this.m_DimMemberNameType);
                        }
                        string = object != null ? String.valueOf(string) + object.toString() + " " : String.valueOf(string) + " ";
                    } else {
                        string = String.valueOf(string) + " ";
                    }
                    ++n6;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            return String.valueOf(string.trim()) + RETURN;
        }
        if (bl2) {
            return String.valueOf(this.m_txtGr) + string.trim() + RETURN;
        }
        return String.valueOf(this.m_txtSe) + string.trim() + RETURN;
    }

    public double getValue(int n, int n2) {
        Object object = ((DataCallback)this.m_graph.getDataFilter()).getValue(n, n2);
        if (object != null && object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 0.0;
    }

    public boolean isAssignedToY2(int n) {
        boolean bl = false;
        try {
            bl = this.m_graph.getSeries().isAssignedToY2(n);
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        return bl;
    }

    public void updateResourceBundle() {
        this.rBundle = this.m_graph != null ? ResourceBundle.getBundle("oracle.dss.graph.resource.GraphBundle", this.m_graph.getLocale()) : ResourceBundle.getBundle("oracle.dss.graph.resource.GraphBundle");
    }

    public void setAxisLabelTipDisplayed(boolean bl) {
        this.m_AxisLabelTipDisplayed = bl;
    }

    public void setDataRowShownAsASeries(boolean bl) {
        if (this.m_SeriesAreRows != bl) {
            boolean bl2 = this.m_ShowColDimName;
            this.m_ShowColDimName = this.m_ShowRowDimName;
            this.m_ShowRowDimName = bl2;
            this.m_SeriesAreRows = bl;
        }
    }

    public void setGraphFormatManager(GraphFormatManager graphFormatManager) {
        this.m_fmtMgr = graphFormatManager;
    }

    public void setGraphType(int n) {
        this.m_GraphIsPieBar = false;
        this.m_GraphIsSingleY = true;
        switch (n) {
            case 20: 
            case 22: 
            case 27: 
            case 29: 
            case 34: 
            case 39: 
            case 44: 
            case 46: 
            case 51: 
            case 53: {
                this.m_GraphIsSingleY = false;
            }
            case 18: 
            case 23: 
            case 25: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 47: 
            case 49: 
            case 54: 
            case 102: {
                this.m_GraphIsStacked = true;
                this.m_ValuesPerGroup = 1;
                this.m_DataValuesPerMarker = 1;
                break;
            }
            case 93: 
            case 94: {
                this.m_GraphIsPieBar = true;
                this.m_GraphIsStacked = true;
                this.m_ValuesPerGroup = 1;
                this.m_DataValuesPerMarker = 1;
                break;
            }
            case 19: 
            case 21: 
            case 26: 
            case 28: 
            case 33: 
            case 38: 
            case 43: 
            case 45: 
            case 50: 
            case 52: 
            case 69: {
                this.m_GraphIsSingleY = false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 24: 
            case 31: 
            case 36: 
            case 41: 
            case 48: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 68: 
            case 87: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 1;
                this.m_DataValuesPerMarker = 1;
                break;
            }
            case 62: 
            case 66: 
            case 74: 
            case 75: {
                this.m_GraphIsSingleY = false;
            }
            case 61: 
            case 65: 
            case 73: {
                this.m_GraphIsOpenAndClose = false;
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 2;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 72: {
                this.m_GraphIsOpenAndClose = true;
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 2;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 64: {
                this.m_GraphIsSingleY = false;
            }
            case 63: 
            case 82: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 3;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 84: {
                this.m_GraphIsOpenAndClose = true;
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 3;
                this.m_DataValuesPerMarker = 2;
                break;
            }
            case 77: 
            case 78: 
            case 91: {
                this.m_GraphIsSingleY = false;
            }
            case 76: 
            case 89: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 3;
                this.m_DataValuesPerMarker = 3;
                break;
            }
            case 92: {
                this.m_GraphIsSingleY = false;
            }
            case 88: 
            case 90: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 4;
                this.m_DataValuesPerMarker = 3;
                break;
            }
            case 80: 
            case 81: {
                this.m_GraphIsSingleY = false;
            }
            case 70: 
            case 79: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 4;
                this.m_DataValuesPerMarker = 4;
                break;
            }
            case 71: 
            case 83: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 5;
                this.m_DataValuesPerMarker = 4;
                break;
            }
            default: {
                this.m_GraphIsStacked = false;
                this.m_ValuesPerGroup = 0;
                this.m_DataValuesPerMarker = 0;
                this.m_graph.getErrorHandler().log("invalid graph type", "oracle.dss.graph.ToolTipTextCallback", "setGraphType(int type)");
            }
        }
    }

    public int getGroupTooltipLabelType() {
        return this.m_TipGroupLabelType;
    }

    public void setGroupTooltipLabelType(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid tooltip type", "oracle.dss.graph.ToolTipTextCallback", "setGroupTooltipLabelType (int type)");
            return;
        }
        this.m_TipGroupLabelType = n;
        this.m_ShowGroupLabels = n != 0;
        if (this.m_SeriesAreRows) {
            this.m_ShowColDimName = n == 2;
        } else {
            this.m_ShowRowDimName = n == 2;
        }
    }

    public int getMarkerTooltipType() {
        return this.m_MarkerTipType;
    }

    public void setMarkerTooltipType(int n) {
        if (n < 0 || n >= 16) {
            this.m_graph.getErrorHandler().log("invalid tool tip type", "oracle.dss.graph.ToolTipTextCallback", "setMarkerTooltipType(int type)");
            return;
        }
        this.m_MarkerTipType = n;
        this.m_MarkerTipDisplayed = n != 0;
        this.m_TextTip = (n & 8) == 8;
        this.m_ValueTip = (n & 1) == 1;
        this.m_CumValTip = (n & 2) == 2;
        this.m_PercentTip = (n & 4) == 4;
    }

    public int getSeriesTooltipLabelType() {
        return this.m_TipSeriesLabelType;
    }

    public void setSeriesTooltipLabelType(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid tooltip type", "oracle.dss.graph.ToolTipTextCallback", "setSeriesTooltipLabelType (int type)");
            return;
        }
        this.m_TipSeriesLabelType = n;
        this.m_ShowSeriesLabels = n != 0;
        if (this.m_SeriesAreRows) {
            this.m_ShowRowDimName = n == 2;
        } else {
            this.m_ShowColDimName = n == 2;
        }
    }

    protected String convertDateToString(Object object) {
        String string;
        String string2;
        Date date = (Date)object;
        PFJ pFJ = this.m_graph.getPFJ();
        int n = pFJ.getDateFrequency();
        if (n == 0) {
            String string3 = this.m_graph.getTimeAxisDateFormat(0);
            if (string3.equals("AUTO") || string3.equals("NONE")) {
                string3 = "YYYY";
            }
            return pFJ.formatDate(date, 0, string3);
        }
        if (n == 1) {
            String string4 = this.m_graph.getTimeAxisDateFormat(1);
            if (string4.equals("AUTO") || string4.equals("NONE")) {
                string4 = "Month";
            }
            String string5 = pFJ.formatDate(date, 1, string4);
            String string6 = this.m_graph.getTimeAxisDateFormat(0);
            if (string6.equals("NONE")) {
                string6 = null;
            } else if (string6.equals("AUTO")) {
                string6 = "YYYY";
            }
            if (string6 != null) {
                string5 = String.valueOf(string5) + " " + pFJ.formatDate(date, 0, string6);
            }
            return string5;
        }
        if (n == 7) {
            String string7 = this.m_graph.getTimeAxisDateFormat(4);
            if (string7.equals("AUTO") || string7.equals("NONE")) {
                string7 = "Q";
            }
            return pFJ.formatDate(date, 4, string7);
        }
        if (n == 2 || n == 3) {
            String string8;
            String string9 = this.m_graph.getTimeAxisDateFormat(2);
            if (string9.equals("AUTO") || string9.equals("NONE")) {
                string9 = "DD";
            }
            String string10 = pFJ.formatDate(date, 2, string9);
            String string11 = this.m_graph.getTimeAxisDateFormat(1);
            if (string11.equals("NONE")) {
                string11 = null;
            } else if (string11.equals("AUTO")) {
                string11 = "Month";
            }
            if (string11 != null) {
                string10 = String.valueOf(string10) + " " + pFJ.formatDate(date, 1, string11);
            }
            if ((string8 = this.m_graph.getTimeAxisDateFormat(0)).equals("NONE")) {
                string8 = null;
            } else if (string8.equals("AUTO")) {
                string8 = "YYYY";
            }
            if (string8 != null) {
                string10 = String.valueOf(string10) + " " + pFJ.formatDate(date, 0, string8);
            }
            return string10;
        }
        Date date2 = new Date(1030155120000L);
        DateFormat dateFormat = DateFormat.getTimeInstance(3, this.m_graph.getLocale());
        String string12 = dateFormat.format(date2);
        boolean bl = true;
        if (string12.indexOf(" ") == -1) {
            bl = false;
        }
        String string13 = "";
        String string14 = this.m_graph.getTimeAxisDateFormat(2);
        if (string14.equals("NONE")) {
            string14 = null;
        } else if (string14.equals("AUTO")) {
            string14 = "DD";
        }
        if (string14 != null) {
            string13 = pFJ.formatDate(date, 2, string14);
        }
        if ((string2 = this.m_graph.getTimeAxisDateFormat(1)).equals("NONE")) {
            string2 = null;
        } else if (string2.equals("AUTO")) {
            string2 = "Month";
        }
        if (string2 != null) {
            string13 = String.valueOf(string13) + " " + pFJ.formatDate(date, 1, string2);
        }
        if ((string = this.m_graph.getTimeAxisDateFormat(0)).equals("NONE")) {
            string = null;
        } else if (string.equals("AUTO")) {
            string = "YYYY";
        }
        if (string != null) {
            string13 = String.valueOf(string13) + " " + pFJ.formatDate(date, 0, string);
        }
        boolean bl2 = false;
        String string15 = this.m_graph.getTimeAxisDateFormat(3);
        if (n == 4) {
            if (string15.equals("AUTO") || string15.equals("NONE")) {
                bl2 = true;
                string15 = bl ? "HH:MI" : "HH24:MI";
            }
        } else if (n == 5) {
            if (string15.equals("AUTO") || string15.equals("NONE")) {
                bl2 = true;
                string15 = bl ? "HH:MI" : "HH24:MI";
            } else if (string15.equals("HH")) {
                string15 = "HH:MI";
            } else if (string15.equals("HH24")) {
                string15 = "HH24:MI";
            }
        } else if (n == 6) {
            if (string15.equals("AUTO") || string15.equals("NONE")) {
                bl2 = true;
                string15 = bl ? "HH:MI:SS" : "HH24:MI:SS";
            } else if (string15.equals("HH") || string15.equals("HH:MI")) {
                string15 = "HH:MI:SS";
            } else if (string15.equals("HH24") || string15.equals("HH24:MI")) {
                string15 = "HH24:MI:SS";
            }
        }
        if (bl2 && bl || !bl2 && (string15.equals("HH") || string15.equals("HH:MI") || string15.equals("HH:MI:SS"))) {
            string15 = String.valueOf(string15) + " AM";
        }
        string13 = String.valueOf(string13) + " " + pFJ.formatDate(date, 3, string15);
        return string13;
    }

    protected CustomToolTipCallback getCustomToolTipCallback() {
        return this.m_customToolTipCallback;
    }

    protected void setCustomToolTipCallback(CustomToolTipCallback customToolTipCallback) {
        this.m_customToolTipCallback = customToolTipCallback;
    }

    protected Object getWrappedText(Object object) {
        if (object == null) {
            return object;
        }
        Graphics graphics = this.m_graph.getPFJ().getGraphicsContext();
        if (graphics == null) {
            return object;
        }
        String string = "";
        Font font = new Font("SansSerif", 0, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        VC vC = this.m_graph.getPFJ().getVC();
        Vector vector = new Vector();
        TextStyleObj textStyleObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
        textStyleObj.extractLinesWordWrap(object.toString(), vector, vC.virtToDestWidth(32000 - vC.destToVirtWidth(20)), fontMetrics);
        int n = 0;
        while (n < vector.size()) {
            string = String.valueOf(string) + (String)vector.elementAt(n) + RETURN;
            ++n;
        }
        return string;
    }

    protected class DimValuePairs {
        public String dim;
        public String value;

        public DimValuePairs() {
            this.dim = null;
            this.value = null;
        }

        public DimValuePairs(String string, String string2) {
            this.dim = string;
            this.value = string2;
        }

        public boolean equals(DimValuePairs dimValuePairs) {
            return this.dim.equals(dimValuePairs.dim) && this.value.equals(dimValuePairs.value);
        }
    }
}

