/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseGraphXML;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.PFJ;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ThreeDViewMatrix
extends BaseGraphXML {
    protected static final int ATTR_FOCUSFACTOR = 0;
    protected static final int ATTR_ISOMETRICPROJECTION = 1;
    protected static final int ATTR_LIGHTSOURCEX = 2;
    protected static final int ATTR_LIGHTSOURCEY = 3;
    protected static final int ATTR_LIGHTSOURCEZ = 4;
    protected static final int ATTR_PANX = 5;
    protected static final int ATTR_PANY = 6;
    protected static final int ATTR_SIZEX = 7;
    protected static final int ATTR_SIZEY = 8;
    protected static final int ATTR_SIZEZ = 9;
    protected static final int ATTR_SQUARERISERS = 10;
    protected static final int ATTR_TRANSLATIONX = 11;
    protected static final int ATTR_TRANSLATIONY = 12;
    protected static final int ATTR_TRANSLATIONZ = 13;
    protected static final int ATTR_VIEWERX = 14;
    protected static final int ATTR_VIEWERY = 15;
    protected static final int ATTR_VIEWERZ = 16;
    protected static final int ATTR_WALLTHICKX = 17;
    protected static final int ATTR_WALLTHICKY = 18;
    protected static final int ATTR_WALLTHICKZ = 19;
    protected static final int ATTR_ZOOMFACTOR = 20;
    protected static final int ATTR_STYLE_MAXID = 21;
    protected PFJ m_pfj;
    private Graph m_graph;
    protected double focusFactor = 50.0;
    protected boolean isometricProjection;
    protected double lightSourceX;
    protected double lightSourceY = 40.0;
    protected double lightSourceZ = 100.0;
    protected double panX = 39.3;
    protected double panY = 60.7;
    protected double sizeX = 30.0;
    protected double sizeY = 25.0;
    protected double sizeZ = 30.0;
    protected boolean squareRisers = true;
    protected double translationX = 65.0;
    protected double translationY = 42.5;
    protected double translationZ = 50.0;
    protected double viewerX = 50.0;
    protected double viewerY = 49.0;
    protected double viewerZ = 36.8;
    protected double wallThickX = 20.0;
    protected double wallThickY = 20.0;
    protected double wallThickZ = 20.0;
    protected double zoomFactor = 50.0;

    public ThreeDViewMatrix(Graph graph, PFJ pFJ) {
        super(graph);
        this.m_pfj = pFJ;
        this.m_graph = graph;
        this.focusFactor = GraphDefaultValues.get3DViewMatrixFocusFactor();
        this.isometricProjection = GraphDefaultValues.get3DViewMatrixIsometricProjection();
        this.lightSourceX = GraphDefaultValues.get3DViewMatrixLightSourceX();
        this.lightSourceY = GraphDefaultValues.get3DViewMatrixLightSourceY();
        this.lightSourceZ = GraphDefaultValues.get3DViewMatrixLightSourceZ();
        this.panX = GraphDefaultValues.get3DViewMatrixPanX();
        this.panY = GraphDefaultValues.get3DViewMatrixPanY();
        this.sizeX = GraphDefaultValues.get3DViewMatrixSizeX();
        this.sizeY = GraphDefaultValues.get3DViewMatrixSizeY();
        this.sizeZ = GraphDefaultValues.get3DViewMatrixSizeZ();
        this.squareRisers = GraphDefaultValues.get3DViewMatrixSquareRisers();
        this.translationX = GraphDefaultValues.get3DViewMatrixTranslationX();
        this.translationY = GraphDefaultValues.get3DViewMatrixTranslationY();
        this.translationZ = GraphDefaultValues.get3DViewMatrixTranslationZ();
        this.viewerX = GraphDefaultValues.get3DViewMatrixViewerX();
        this.viewerY = GraphDefaultValues.get3DViewMatrixViewerY();
        this.viewerZ = GraphDefaultValues.get3DViewMatrixViewerZ();
        this.wallThickX = GraphDefaultValues.get3DViewMatrixWallThickX();
        this.wallThickY = GraphDefaultValues.get3DViewMatrixWallThickY();
        this.wallThickZ = GraphDefaultValues.get3DViewMatrixWallThickZ();
        this.zoomFactor = GraphDefaultValues.get3DViewMatrixZoomFactor();
    }

    public double getFocusFactor() {
        return this.m_pfj.getCubeFocusFactor();
    }

    public void setFocusFactor(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid focus factor", this.getClass().getName(), "setFocusFactor(double newValue)");
        } else {
            this.m_pfj.setCubeFocusFactor(d);
            this.setPropertyOverrideFlags(0);
        }
    }

    public boolean isIsometricProjection() {
        return this.m_pfj.getCubeIsometricProjection();
    }

    public void setIsometricProjection(boolean bl) {
        this.m_pfj.setCubeIsometricProjection(bl);
        this.setPropertyOverrideFlags(1);
    }

    public double getLightSourceX() {
        return this.m_pfj.getCubeLightSourceX();
    }

    public void setLightSourceX(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid Light SourceX", this.getClass().getName(), "setLightSourceX(double newValue)");
        } else {
            this.m_pfj.setCubeLightSourceX(d);
            this.setPropertyOverrideFlags(2);
        }
    }

    public double getLightSourceY() {
        return this.m_pfj.getCubeLightSourceY();
    }

    public void setLightSourceY(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid light Source Y", this.getClass().getName(), "setLightSourceY(double newValue)");
        } else {
            this.m_pfj.setCubeLightSourceY(d);
            this.setPropertyOverrideFlags(3);
        }
    }

    public double getLightSourceZ() {
        return this.m_pfj.getCubeLightSourceZ();
    }

    public void setLightSourceZ(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid light Source", this.getClass().getName(), "setLightSourceZ(double newValue)");
        } else {
            this.m_pfj.setCubeLightSourceZ(d);
            this.setPropertyOverrideFlags(4);
        }
    }

    public double getPanX() {
        return this.m_pfj.getCubePanX();
    }

    public void setPanX(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid pan value", this.getClass().getName(), "setPanX(double newValue)");
        } else {
            this.m_pfj.setCubePanX(d);
            this.setPropertyOverrideFlags(5);
        }
    }

    public double getPanY() {
        return this.m_pfj.getCubePanY();
    }

    public void setPanY(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid pan value", this.getClass().getName(), "setPanY(double newValue)");
        } else {
            this.m_pfj.setCubePanY(d);
            this.setPropertyOverrideFlags(6);
        }
    }

    public double getSizeX() {
        return this.m_pfj.getCubeSizeX();
    }

    public void setSizeX(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid size", this.getClass().getName(), "setSizeX(double newValue)");
        } else {
            this.m_pfj.setCubeSizeX(d);
            this.setPropertyOverrideFlags(7);
        }
    }

    public double getSizeY() {
        return this.m_pfj.getCubeSizeY();
    }

    public void setSizeY(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid size", this.getClass().getName(), "setSizeY(double newValue)");
        } else {
            this.m_pfj.setCubeSizeY(d);
            this.setPropertyOverrideFlags(8);
        }
    }

    public double getSizeZ() {
        return this.m_pfj.getCubeSizeZ();
    }

    public void setSizeZ(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid size", this.getClass().getName(), "setSizeZ(double newValue)");
        } else {
            this.m_pfj.setCubeSizeZ(d);
            this.setPropertyOverrideFlags(9);
        }
    }

    public boolean isSquareRisers() {
        return this.m_pfj.getCubeSquareRisers();
    }

    public void setSquareRisers(boolean bl) {
        this.m_pfj.setCubeSquareRisers(bl);
        this.setPropertyOverrideFlags(10);
    }

    public double getTranslationX() {
        return this.m_pfj.getCubeTranslationX();
    }

    public void setTranslationX(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid translation", this.getClass().getName(), "setTranslationX(double newValue)");
        } else {
            this.m_pfj.setCubeTranslationX(d);
            this.setPropertyOverrideFlags(11);
        }
    }

    public double getTranslationY() {
        return this.m_pfj.getCubeTranslationY();
    }

    public void setTranslationY(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid translation", this.getClass().getName(), "setTranslationY(double newValue)");
        } else {
            this.m_pfj.setCubeTranslationY(d);
            this.setPropertyOverrideFlags(12);
        }
    }

    public double getTranslationZ() {
        return this.m_pfj.getCubeTranslationZ();
    }

    public void setTranslationZ(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid translation", this.getClass().getName(), "setTranslationZ(double newValue)");
        } else {
            this.m_pfj.setCubeTranslationZ(d);
            this.setPropertyOverrideFlags(13);
        }
    }

    public double getViewerX() {
        return this.m_pfj.getCubeViewerX();
    }

    public void setViewerX(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid ViewerX", this.getClass().getName(), "setViewerX(double newValue)");
        } else {
            this.m_pfj.setCubeViewerX(d);
            this.setPropertyOverrideFlags(14);
        }
    }

    public double getViewerY() {
        return this.m_pfj.getCubeViewerY();
    }

    public void setViewerY(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid ViewerY", this.getClass().getName(), "setViewerY(double newValue)");
        } else {
            this.m_pfj.setCubeViewerY(d);
            this.setPropertyOverrideFlags(15);
        }
    }

    public double getViewerZ() {
        return this.m_pfj.getCubeViewerZ();
    }

    public void setViewerZ(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid ViewerZ", this.getClass().getName(), "setViewerZ(double newValue)");
        } else {
            this.m_pfj.setCubeViewerZ(d);
            this.setPropertyOverrideFlags(16);
        }
    }

    public double getWallThickX() {
        return this.m_pfj.getCubeWallThickX();
    }

    public void setWallThickX(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid wall thickness", this.getClass().getName(), "setWallThickX(double newValue)");
        } else {
            this.m_pfj.setCubeWallThickX(d);
            this.setPropertyOverrideFlags(17);
        }
    }

    public double getWallThickY() {
        return this.m_pfj.getCubeWallThickY();
    }

    public void setWallThickY(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid wall thickness", this.getClass().getName(), "setWallThickY(double newValue)");
        } else {
            this.m_pfj.setCubeWallThickY(d);
            this.setPropertyOverrideFlags(18);
        }
    }

    public double getWallThickZ() {
        return this.m_pfj.getCubeWallThickZ();
    }

    public void setWallThickZ(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid wall thickness", this.getClass().getName(), "setWallThickZ(double newValue)");
        } else {
            this.m_pfj.setCubeWallThickZ(d);
            this.setPropertyOverrideFlags(19);
        }
    }

    public double getZoomFactor() {
        return this.m_pfj.getCubeZoomFactor();
    }

    public void setZoomFactor(double d) {
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid zoom factor", this.getClass().getName(), "setZoomFactor(double newValue)");
        } else {
            this.m_pfj.setCubeZoomFactor(d);
            this.setPropertyOverrideFlags(20);
        }
    }

    protected String getComponentName() {
        return "ThreeDViewMatrix";
    }

    protected int getStylePropertyCount() {
        return 21;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("focusFactor", this.getFocusFactor());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("isometricProjection", this.isIsometricProjection());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty("lightSourceX", this.getLightSourceX());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            objectNode.addProperty("lightSourceY", this.getLightSourceY());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(4)) {
            objectNode.addProperty("lightSourceZ", this.getLightSourceZ());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(5)) {
            objectNode.addProperty("panX", this.getPanX());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(6)) {
            objectNode.addProperty("panY", this.getPanY());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(7)) {
            objectNode.addProperty("sizeX", this.getSizeX());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(8)) {
            objectNode.addProperty("sizeY", this.getSizeY());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(9)) {
            objectNode.addProperty("sizeZ", this.getSizeZ());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(10)) {
            objectNode.addProperty("squareRisers", this.isSquareRisers());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(11)) {
            objectNode.addProperty("translationX", this.getTranslationX());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(12)) {
            objectNode.addProperty("translationY", this.getTranslationY());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(13)) {
            objectNode.addProperty("translationZ", this.getTranslationZ());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(14)) {
            objectNode.addProperty("viewerX", this.getViewerX());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(15)) {
            objectNode.addProperty("viewerY", this.getViewerY());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(16)) {
            objectNode.addProperty("viewerZ", this.getViewerZ());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(17)) {
            objectNode.addProperty("wallThickX", this.getWallThickX());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(18)) {
            objectNode.addProperty("wallThickY", this.getWallThickY());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(19)) {
            objectNode.addProperty("wallThickZ", this.getWallThickZ());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(20)) {
            objectNode.addProperty("zoomFactor", this.getZoomFactor());
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty("focusFactor");
        if (propertyNode != null) {
            this.setFocusFactor(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("isometricProjection")) != null) {
            this.setIsometricProjection(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("lightSourceX")) != null) {
            this.setLightSourceX(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("lightSourceY")) != null) {
            this.setLightSourceY(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("lightSourceZ")) != null) {
            this.setLightSourceZ(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("panX")) != null) {
            this.setPanX(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("panY")) != null) {
            this.setPanY(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("sizeX")) != null) {
            this.setSizeX(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("sizeY")) != null) {
            this.setSizeY(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("sizeZ")) != null) {
            this.setSizeZ(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("squareRisers")) != null) {
            this.setSquareRisers(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("translationX")) != null) {
            this.setTranslationX(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("translationY")) != null) {
            this.setTranslationY(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("translationZ")) != null) {
            this.setTranslationZ(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("viewerX")) != null) {
            this.setViewerX(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("viewerY")) != null) {
            this.setViewerY(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("viewerZ")) != null) {
            this.setViewerZ(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("wallThickX")) != null) {
            this.setWallThickX(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("wallThickY")) != null) {
            this.setWallThickY(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("wallThickZ")) != null) {
            this.setWallThickZ(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("zoomFactor")) != null) {
            this.setZoomFactor(propertyNode.getValueAsDouble());
        }
    }

    protected void resetStyle() {
        this.setFocusFactor(this.focusFactor);
        this.setIsometricProjection(this.isometricProjection);
        this.setLightSourceX(this.lightSourceX);
        this.setLightSourceY(this.lightSourceY);
        this.setLightSourceZ(this.lightSourceZ);
        this.setPanX(this.panX);
        this.setPanY(this.panY);
        this.setSizeX(this.sizeX);
        this.setSizeY(this.sizeY);
        this.setSizeZ(this.sizeZ);
        this.setSquareRisers(this.squareRisers);
        this.setTranslationX(this.translationX);
        this.setTranslationY(this.translationY);
        this.setTranslationZ(this.translationZ);
        this.setViewerX(this.viewerX);
        this.setViewerY(this.viewerY);
        this.setViewerZ(this.viewerZ);
        this.setWallThickX(this.wallThickX);
        this.setWallThickY(this.wallThickY);
        this.setWallThickZ(this.wallThickZ);
        this.setZoomFactor(this.zoomFactor);
        super.resetStyle();
    }
}

