/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.DataviewFontAttribute;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.dataView.managers.Formattable;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewFormatCallback;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UISliceLabel;
import oracle.dss.graph.Visible;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class SliceLabel
extends BaseText
implements Visible,
UISliceLabel,
FontAttribute,
Formattable,
ViewFormatCallback,
DataviewFontAttribute {
    protected static final int ATTR_VISIBLE = 1;
    protected static final int ATTR_TEXTROTATION = 2;
    protected static final int ATTR_TEXTTYPE = 3;
    protected static final int ATTR_STYLE_MAXID = 4;
    protected int textType;
    protected boolean visible;
    protected int textRotation;
    protected ViewFormat m_viewFormat;
    private static final String m_method_setViewFormat = "setViewFormat(ViewFormat viewFormat)";

    public SliceLabel(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getPieSliceLabel();
        this.m_viewFormat = new ViewFormat();
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_graph);
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.fontTypeface = GraphDefaultValues.getSliceLabelFontTypeface();
        this.fontColor = GraphDefaultValues.getSliceLabelFontColor();
        this.fontStyle = GraphDefaultValues.getSliceLabelFontStyle();
        this.fontSize = GraphDefaultValues.getSliceLabelFontSize();
        this.textType = GraphDefaultValues.getSliceLabelTextType();
        this.graphProportionalFontSize = GraphDefaultValues.getSliceLabelGraphProportionalFontSize();
        this.visible = GraphDefaultValues.isSliceLabelVisible();
        this.textRotation = GraphDefaultValues.getSliceLabelTextRotation();
    }

    public void resetToDefault() {
        this.m_viewFormat = new ViewFormat();
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_graph);
    }

    public boolean selectObject(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            IdentObj identObj = new IdentObj(this.m_identObj);
            identObj.setSeriesID(n);
            identObj.setGroupID(n2);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    public int getTextType() {
        return this.m_pfj.getPieLabelDisplay();
    }

    public void setTextType(int n) {
        if (n < 0 || n > 3) {
            this.m_graph.getErrorHandler().log("invalid text type", "oracle.dss.graph.SliceLabel", "setTextType(int i)");
        } else {
            this.m_pfj.setPieLabelDisplay(n);
            this.setPropertyOverrideFlags(3);
        }
    }

    public int getTextRotation() {
        return this.m_pfj.getTextRotation(this.m_identObj);
    }

    public void setTextRotation(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int rotate)");
        } else {
            this.m_pfj.setTextRotation(this.m_identObj, n);
            this.setPropertyOverrideFlags(2);
        }
    }

    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    public void setViewFormat(ViewFormat viewFormat) {
        if (viewFormat == null) {
            this.m_graph.getErrorHandler().log("invalid ViewFormat", this.getClass().getName(), m_method_setViewFormat);
            return;
        }
        this.m_viewFormat = (ViewFormat)viewFormat.clone();
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_graph);
        this.m_pfj.needRecalc();
    }

    public void formatChanged(int n, String string, Object object, Object object2) {
        this.m_pfj.needRecalc();
    }

    public boolean isVisible() {
        return this.m_pfj.getPieFeelerTextDisplay() != 0;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.m_graph.getSlice().setLabelPosition(this.m_graph.getSlice().getLabelPosition());
        } else {
            this.m_graph.getSlice().setLabelPosition(0);
        }
        this.setPropertyOverrideFlags(1);
    }

    protected String getComponentName() {
        return "SliceLabel";
    }

    protected int getStylePropertyCount() {
        return 4;
    }

    protected boolean getNonstyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getNonstyleXML(bl, objectNode);
        ObjectNode objectNode2 = this.getViewFormat().getXML(bl);
        if (objectNode2 != null) {
            objectNode.addProperty(objectNode2);
            bl2 = true;
        }
        return bl2;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(3)) {
            int n = this.getTextType();
            if (n == 0) {
                objectNode.addProperty("textType", "LD_VALUE");
            } else if (n == 1) {
                objectNode.addProperty("textType", "LD_PERCENT");
            } else if (n == 2) {
                objectNode.addProperty("textType", "LD_TEXT");
            } else if (n == 3) {
                objectNode.addProperty("textType", "LD_TEXT_PERCENT");
            }
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("visible", this.isVisible());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            if (this.getTextRotation() == 0) {
                objectNode.addProperty("textRotation", "TR_HORIZ");
            } else if (this.getTextRotation() == 1) {
                objectNode.addProperty("textRotation", "TR_HORIZ_ROTATE_90");
            } else {
                objectNode.addProperty("textRotation", "TR_HORIZ_ROTATE_270");
            }
            bl2 = true;
        }
        return bl2;
    }

    protected void setNonstyleXML(ObjectNode objectNode, String string, int n) {
        super.setNonstyleXML(objectNode);
        ObjectNode objectNode2 = objectNode.getPropertyValueAsObjectNode("ViewFormat", true);
        if (objectNode2 != null) {
            this.getViewFormat().setXML(objectNode2, string, n);
        }
    }

    protected void setStyleXML(ObjectNode objectNode) {
        String string;
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("textType");
        if (propertyNode != null) {
            string = propertyNode.getValueAsString();
            if (string.equals("LD_VALUE")) {
                this.setTextType(0);
            } else if (string.equals("LD_PERCENT")) {
                this.setTextType(1);
            } else if (string.equals("LD_TEXT")) {
                this.setTextType(2);
            } else if (string.equals("LD_TEXT_PERCENT")) {
                this.setTextType(3);
            }
        }
        if ((propertyNode = objectNode.getProperty("textRotation")) != null) {
            string = propertyNode.getValueAsString();
            if (string.equals("TR_HORIZ")) {
                this.setTextRotation(0);
            } else if (string.equals("TR_HORIZ_ROTATE_90")) {
                this.setTextRotation(1);
            } else if (string.equals("TR_HORIZ_ROTATE_270")) {
                this.setTextRotation(2);
            }
        }
        if ((propertyNode = objectNode.getProperty("visible")) != null) {
            this.setVisible(propertyNode.getValueAsBoolean());
        }
    }

    protected void resetStyle() {
        this.setVisible(this.visible);
        this.setTextRotation(this.textRotation);
        this.setTextType(this.textType);
        super.resetStyle();
    }
}

