/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.util.BitSet;
import java.util.Enumeration;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.SFX;
import oracle.dss.graph.UISeries;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Series
extends BaseGraphComponent
implements UISeries {
    public static final int ATTR_DEFAULTBORDERCOLOR = 0;
    public static final int ATTR_DEFAULTBORDERTRANSPARENT = 1;
    public static final int ATTR_BORDERUSINGDEFAULTS = 2;
    public static final int ATTR_DEFAULTCOLOR = 3;
    public static final int ATTR_DEFAULTMARKERSHAPE = 4;
    public static final int ATTR_DEFAULTLINEWIDTH = 5;
    public static final int ATTR_DEFAULTFITLINETYPE = 6;
    protected static final int ATTR_STYLE_MAXID = 7;
    public static final int ATTR_MARKERSHAPE = 0;
    public static final int ATTR_LINEWIDTH = 1;
    public static final int ATTR_COLOR = 2;
    public static final int ATTR_BORDERCOLOR = 3;
    public static final int ATTR_BORDERTRANSPARENT = 4;
    public static final int ATTR_FITLINETYPE = 5;
    public static final int ATTR_PIESLICEEXPLODE = 6;
    public static final int ATTR_TRANSPARENT = 7;
    public static final int ATTR_LINESTYLE = 8;
    protected static final int ATTR_SERIES_STYLE_MAXID = 9;
    protected BitSet[] _seriesUserOverrideFlags = new BitSet[128];
    protected BitSet[] _seriesStyleOverrideFlags = new BitSet[128];
    protected int[] color;
    protected int markerShape;
    protected int markerType;
    protected boolean assignedToY2All;
    protected boolean assignedToY2For1;
    protected int borderColor;
    protected boolean borderTransparent;
    protected int pieSliceExplode;
    protected boolean transparent;
    protected boolean borderUsingDefaults;
    protected Color m_defaultBorderColor;
    protected boolean m_defaultBorderTransparent;
    protected int m_defaultMarkerShape;
    protected int m_defaultMarkerType;
    protected int m_defaultLineWidth;
    protected int m_defaultAssignedToY2;
    protected int m_defaultFitlineType;
    protected Color m_defaultColor;
    protected int m_startSeries;
    protected int m_seriesCount;
    protected SFX[] m_sfx;
    protected boolean m_isMarkerShapeSet;

    public Series(Graph graph) {
        super(graph);
        this.initDefaultValues();
        this.m_startSeries = 0;
        this.m_sfx = new SFX[graph.getSeriesObjectCount()];
        this.m_seriesCount = this.m_pfj.getSeriesLooping();
        this.createSeriesPropertyOverrideFlags();
    }

    private int _getNumberOfSeries() {
        int n = this.m_pfj.getSeriesLooping();
        try {
            int n2;
            int n3 = n2 = this.m_graph.isDataRowShownAsASeries() ? this.m_graph.getRowCount() : this.m_graph.getColumnCount();
            if (n2 > n) {
                n = n2;
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.m_graph.getErrorHandler().log(" edge is out of range ", this.getClass().getName(), "_getNumberOfSeries()");
        }
        this.m_seriesCount = n;
        return n;
    }

    private IdentObj _getID(int n) throws SeriesOutOfRangeException {
        int n2 = this.m_pfj.getSeriesLooping();
        if (n < 0 || n >= n2) {
            throw new SeriesOutOfRangeException(n, n2);
        }
        return this.m_pfj.getSeries(n);
    }

    private IdentObj _getFitlineID(int n) throws SeriesOutOfRangeException {
        int n2 = this.m_pfj.getSeriesLooping();
        if (n < 0 || n >= n2) {
            throw new SeriesOutOfRangeException(n, n2);
        }
        return this.m_pfj.getCurveFitLineRiser(n);
    }

    private void initDefaultValues() {
        this.markerShape = GraphDefaultValues.getDefaultSeriesMarkerShape();
        this.markerType = GraphDefaultValues.getDefaultSeriesMarkerType();
        this.assignedToY2All = GraphDefaultValues.isAssignedToY2All();
        this.assignedToY2For1 = GraphDefaultValues.isAssignedToY2For1();
        this.color = GraphDefaultValues.getDefaultSeriesColor();
        this.borderColor = GraphDefaultValues.getSeriesBorderColor();
        this.borderTransparent = GraphDefaultValues.isSeriesBorderTransparent();
        this.pieSliceExplode = GraphDefaultValues.getSeriesPieSliceExplode();
        this.transparent = GraphDefaultValues.isSeriesFillTransparent();
        this.borderUsingDefaults = GraphDefaultValues.isSeriesBorderUsingDefaults();
        this.m_defaultMarkerShape = GraphDefaultValues.getSeriesDefaultMarkerShape();
        this.m_defaultMarkerType = GraphDefaultValues.getSeriesDefaultMarkerType();
        this.m_defaultLineWidth = GraphDefaultValues.getSeriesDefaultLineWidth();
        this.m_defaultAssignedToY2 = GraphDefaultValues.getSeriesDefaultAssignedToY2();
        this.m_defaultFitlineType = GraphDefaultValues.getSeriesDefaultFitlineType();
        String string = GraphDefaultValues.getSeriesDefaultColor();
        this.m_defaultColor = string.equals("") ? null : new Color(BaseGraphComponent.hexStringToInt(string));
    }

    void setSeriesDefaults() {
        try {
            int n;
            int n2 = n = this.m_graph.isDataRowShownAsASeries() ? this.m_graph.getRowCount() : this.m_graph.getColumnCount();
            if (this.m_seriesCount < n) {
                this.m_startSeries = this.m_seriesCount;
                this.setDefaultMarkerType(this.m_defaultMarkerType);
                this.setDefaultMarkerShape(this.m_defaultMarkerShape);
                this.setDefaultFitlineType(this.m_defaultFitlineType);
                this.setDefaultLineWidth(this.m_defaultLineWidth);
                this.setDefaultAssignedToY2(this.m_defaultAssignedToY2);
                this.m_startSeries = 0;
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.m_graph.getErrorHandler().log(" edge is out of range ", this.getClass().getName(), "setSeriesDefaults()");
        }
    }

    void clearSFX() {
        this.m_sfx = new SFX[this.m_graph.getSeriesObjectCount()];
    }

    public SFX getSFX(int n) throws SeriesOutOfRangeException {
        Object object;
        if (this.m_graph.getSeriesEffect() == 1) {
            this.m_graph.getErrorHandler().log("Can't use SFX when SeriesEffect equals SE_GRADIENT", this.getClass().toString(), "getSFX( int series )");
            this.m_sfx = null;
            return null;
        }
        if (n >= this.m_sfx.length) {
            object = this.m_sfx;
            this.m_sfx = new SFX[this.m_graph.getSeriesObjectCount()];
            System.arraycopy(object, 0, this.m_sfx, 0, ((SFX[])object).length);
        }
        if ((object = this.m_sfx[n]) == null) {
            this.m_sfx[n] = new SFX(this.m_graph, this._getID(n), this._getFitlineID(n));
            object = this.m_sfx[n];
        }
        return object;
    }

    public boolean isAssignedToY2(int n) throws SeriesOutOfRangeException {
        return this.m_pfj.getAxisAssignment(this._getID(n)) == 1;
    }

    public void setAssignedToY2(boolean bl, int n) throws SeriesOutOfRangeException {
        IdentObj identObj = this._getID(n);
        if (bl) {
            this.m_pfj.setAxisAssignment(identObj, 1);
        } else {
            this.m_pfj.setAxisAssignment(identObj, 0);
        }
    }

    public Color getBorderColor(int n) throws SeriesOutOfRangeException {
        return this.m_pfj.getBorderColor(this._getID(n));
    }

    public void setBorderColor(Color color, int n) throws SeriesOutOfRangeException {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this._getID(n), color);
        this.setSeriesPropertyOverrideFlags(3, n);
    }

    public boolean isBorderTransparent(int n) throws SeriesOutOfRangeException {
        return this.m_pfj.getTransparentBorderColor(this._getID(n));
    }

    public void setBorderTransparent(boolean bl, int n) throws SeriesOutOfRangeException {
        this.m_pfj.setTransparentBorderColor(this._getID(n), bl);
        this.setSeriesPropertyOverrideFlags(4, n);
    }

    public Color getColor(int n) throws SeriesOutOfRangeException {
        if (!this.isTransparent(n)) {
            return this.m_pfj.getFillColor(this._getID(n));
        }
        return null;
    }

    public void setColor(Color color, int n) throws SeriesOutOfRangeException {
        if (color == null) {
            this.setTransparent(true, n);
            return;
        }
        this.m_pfj.setFillColor(this._getID(n), color);
        this.m_pfj.setFillColor(this._getFitlineID(n), color);
        this.setSeriesPropertyOverrideFlags(2, n);
    }

    public Color getDefaultBorderColor() {
        return this.m_pfj.getSeriesDefaultBorderColor();
    }

    public void setDefaultBorderColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setDefaultBorderColor( Color newColor )");
            return;
        }
        this.m_pfj.setSeriesDefaultBorderColor(color);
        this.setPropertyOverrideFlags(0);
    }

    public boolean isDefaultBorderTransparent() {
        return this.m_pfj.getSeriesDefaultTransparentBorderColor();
    }

    public void setDefaultBorderTransparent(boolean bl) {
        this.m_pfj.setSeriesDefaultTransparentBorderColor(bl);
        this.setPropertyOverrideFlags(1);
    }

    public void setFitlineType(int n, int n2) throws SeriesOutOfRangeException {
        if (n < 0 || n > 8) {
            this.m_graph.getErrorHandler().log("invalid fit line type", this.getClass().getName(), "setFitlineType (int type, int series)");
            return;
        }
        int n3 = this.m_pfj.getSeriesLooping();
        if (n2 < 0 || n2 >= n3) {
            throw new SeriesOutOfRangeException(n2, n3);
        }
        this.m_pfj.setCurveFitType(n2, n);
        this.setSeriesPropertyOverrideFlags(5, n2);
    }

    public int getFitlineType(int n) throws SeriesOutOfRangeException {
        int n2 = this.m_pfj.getSeriesLooping();
        if (n < 0 || n >= n2) {
            throw new SeriesOutOfRangeException(n, n2);
        }
        return this.m_pfj.getCurveFitType(n);
    }

    public int getLineWidth(int n) throws SeriesOutOfRangeException {
        return this.m_pfj.getLineWidth(this._getID(n));
    }

    public void setLineWidth(int n, int n2) throws SeriesOutOfRangeException {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width, int series)");
        } else {
            this.m_pfj.setLineWidth(this._getID(n2), n);
            this.setSeriesPropertyOverrideFlags(1, n2);
        }
    }

    public void setLineStyle(int n, int n2) throws SeriesOutOfRangeException {
        int n3 = this.m_pfj.getSeriesLooping();
        if (n2 < 0 || n2 >= n3) {
            throw new SeriesOutOfRangeException(n2, n3);
        }
        if (n < 0 || n > 3) {
            this.m_graph.getErrorHandler().log("invalid line style", this.getClass().getName(), "setLineStyle (int style, int series)");
        } else {
            this.m_pfj.setLineStyle(this._getID(n2), n);
            this.setSeriesPropertyOverrideFlags(8, n2);
        }
    }

    public int getLineStyle(int n) throws SeriesOutOfRangeException {
        int n2 = this.m_pfj.getSeriesLooping();
        if (n < 0 || n >= n2) {
            throw new SeriesOutOfRangeException(n, n2);
        }
        return this.m_pfj.getLineStyle(this._getID(n));
    }

    public int getMarkerShape(int n) throws SeriesOutOfRangeException {
        return this.m_pfj.getMarkerShape(this._getID(n));
    }

    public void setMarkerShape(int n, int n2) throws SeriesOutOfRangeException {
        if (n < 0 || n > 6) {
            this.m_graph.getErrorHandler().log("invalid marker shape", this.getClass().getName(), "setMarkerShape (int shape, int series)");
        } else {
            this.m_pfj.setMarkerShape(this._getID(n2), n);
            this.setSeriesPropertyOverrideFlags(0, n2);
            this.m_isMarkerShapeSet = true;
        }
    }

    public int getMarkerType(int n) throws SeriesOutOfRangeException {
        return this.m_pfj.getSeriesType(this._getID(n));
    }

    public void setMarkerType(int n, int n2) throws SeriesOutOfRangeException {
        if (n < 0 || n > 3) {
            this.m_graph.getErrorHandler().log("invalid marker type", this.getClass().getName(), "setMarkerType (int type, int series)");
        } else {
            this.m_pfj.setSeriesType(this._getID(n2), n);
            if (n == 2) {
                this.m_graph.setMarkerShapeInLegend(true);
                if (this.m_graph.getSeriesEffect() != 0) {
                    this.m_pfj.setSeriesGradientEffect(n2, 0);
                }
            } else {
                if (n == 0 && n == 0) {
                    this.m_graph.setMarkerShapeInLegend(false);
                }
                if (this.m_graph.getSeriesEffect() != 0) {
                    this.m_pfj.setSeriesGradientEffect(n2, this.m_graph.getSeriesEffect());
                }
            }
        }
    }

    public int getPieSliceExplode(int n) throws SeriesOutOfRangeException {
        return this.m_pfj.getPieSliceDetach(this._getID(n));
    }

    public void setPieSliceExplode(int n, int n2) throws SeriesOutOfRangeException {
        if (n < 0 || n > 100) {
            this.m_graph.getErrorHandler().log("invalid pie slice explode", this.getClass().getName(), "setPieSliceExplode (int explode, int series)");
        } else {
            this.m_pfj.setPieSliceDetach(this._getID(n2), n);
            this.setSeriesPropertyOverrideFlags(6, n2);
        }
    }

    public boolean isTransparent(int n) throws SeriesOutOfRangeException {
        return this.m_pfj.getTransparentFillColor(this._getID(n));
    }

    public void setTransparent(boolean bl, int n) throws SeriesOutOfRangeException {
        this.m_pfj.setTransparentFillColor(this._getID(n), bl);
        this.m_pfj.setTransparentFillColor(this._getFitlineID(n), bl);
        this.setSeriesPropertyOverrideFlags(7, n);
    }

    public boolean isBorderUsingDefaults() {
        return this.m_pfj.getUseSeriesBorderDefaults();
    }

    public void setBorderUsingDefaults(boolean bl) {
        this.m_pfj.setUseSeriesBorderDefaults(bl);
        this.setPropertyOverrideFlags(2);
    }

    public void setDefaultColor(Color color) {
        if (color == null) {
            try {
                int n = this.m_startSeries;
                while (n < this._getNumberOfSeries()) {
                    if (this.isTransparent(n)) {
                        this.setTransparent(false, n);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_pfj.removeSeriesColors(0, this._getNumberOfSeries());
            if (this.m_graph.getSeriesEffect() != 0) {
                int n = 0;
                while (n < this.m_pfj.getSeriesLooping()) {
                    this.m_pfj.setSeriesGradientEffect(this.m_pfj.getSeries(n).getSeriesID(), this.m_graph.getSeriesEffect());
                    ++n;
                }
            }
        } else {
            int n = 0;
            while (n < this.m_pfj.getSeriesLooping()) {
                this.m_pfj.setFillColor(this.m_pfj.getSeries(n), color);
                this.m_pfj.setFillColor(this.m_pfj.getCurveFitLineRiser(n), color);
                ++n;
            }
        }
        this.m_defaultColor = color;
        int n = 0;
        while (n < this.m_pfj.getSeriesLooping()) {
            this.clearSeriesPropertyOverrideFlags(2, n);
            this.clearSeriesPropertyOverrideFlags(7, n);
            ++n;
        }
        this.setPropertyOverrideFlags(3);
    }

    public Color getDefaultColor() {
        return this.m_defaultColor;
    }

    public void setDefaultMarkerType(int n) {
        if (n < 0 || n > 3) {
            this.m_graph.getErrorHandler().log("invalid marker type", this.getClass().getName(), "setMarkerType (int type, int series)");
            return;
        }
        int n2 = this.m_startSeries;
        while (n2 < this._getNumberOfSeries()) {
            this.m_pfj.setSeriesType(this.m_pfj.getSeries(n2), n);
            ++n2;
        }
        this.m_defaultMarkerType = n;
    }

    public int getDefaultMarkerType() {
        return this.m_defaultMarkerType;
    }

    public void setDefaultMarkerShape(int n) {
        if (n < -1 || n > 6) {
            this.m_graph.getErrorHandler().log("invalid marker shape", this.getClass().getName(), "setDefaultMarkerShape(int markerShape)");
            return;
        }
        if (n == 0) {
            this.m_pfj.removeMarkerShapes(0, this._getNumberOfSeries());
        } else if (n == -1) {
            this.m_pfj.loopMarkerShapes(0, this._getNumberOfSeries());
        } else {
            int n2 = this.m_startSeries;
            while (n2 < this._getNumberOfSeries()) {
                this.m_pfj.setMarkerShape(this.m_pfj.getSeries(n2), n);
                ++n2;
            }
        }
        this.m_defaultMarkerShape = n;
        this.setPropertyOverrideFlags(4);
        this.m_isMarkerShapeSet = true;
    }

    public int getDefaultMarkerShape() {
        return this.m_defaultMarkerShape;
    }

    public void setDefaultLineWidth(int n) {
        this.m_pfj.removeLineWidths(this.m_startSeries, this._getNumberOfSeries());
        this.m_pfj.setSeriesLineWidthDefault(n);
        this.m_defaultLineWidth = n;
        this.setPropertyOverrideFlags(5);
    }

    public int getDefaultLineWidth() {
        return this.m_defaultLineWidth;
    }

    public void setDefaultAssignedToY2(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid value for AssignedToY2", this.getClass().getName(), "setDefaultAssignedToY2(int assignedToY2)");
            return;
        }
        if (n == 2) {
            int n2 = this.m_startSeries;
            while (n2 < this._getNumberOfSeries()) {
                if (n2 == 1) {
                    this.m_pfj.setAxisAssignment(this.m_pfj.getSeries(n2), 1);
                } else {
                    this.m_pfj.setAxisAssignment(this.m_pfj.getSeries(n2), 0);
                }
                ++n2;
            }
        } else {
            int n3 = n == 1 ? 1 : 0;
            int n4 = this.m_startSeries;
            while (n4 < this._getNumberOfSeries()) {
                this.m_pfj.setAxisAssignment(this.m_pfj.getSeries(n4), n3);
                ++n4;
            }
        }
        this.m_defaultAssignedToY2 = n;
    }

    public int getDefaultAssignedToY2() {
        return this.m_defaultAssignedToY2;
    }

    public void setDefaultFitlineType(int n) {
        if (n < 0 || n > 8) {
            this.m_graph.getErrorHandler().log("invalid fit line type", this.getClass().getName(), "setDefaultFitlineType(int type)");
            return;
        }
        int n2 = this.m_startSeries;
        while (n2 < this._getNumberOfSeries()) {
            this.m_pfj.setCurveFitType(this.m_pfj.getSeries(n2), n);
            ++n2;
        }
        this.m_defaultFitlineType = n;
        this.setPropertyOverrideFlags(6);
    }

    public int getDefaultFitlineType() {
        return this.m_defaultFitlineType;
    }

    protected int convertMarkerShapeToInt(String string) {
        if (string.equals("MS_NONE")) {
            return 0;
        }
        if (string.equals("MS_CIRCLE")) {
            return 2;
        }
        if (string.equals("MS_DIAMOND")) {
            return 3;
        }
        if (string.equals("MS_PLUS")) {
            return 4;
        }
        if (string.equals("MS_SQUARE")) {
            return 1;
        }
        if (string.equals("MS_TRIANGLE_DOWN")) {
            return 5;
        }
        if (string.equals("MS_TRIANGLE_UP")) {
            return 6;
        }
        return -1;
    }

    protected int convertMarkerTypeToInt(String string) {
        if (string.equals("MT_DEFAULT")) {
            return 0;
        }
        if (string.equals("MT_BAR")) {
            return 1;
        }
        if (string.equals("MT_MARKER")) {
            return 2;
        }
        if (string.equals("MT_AREA")) {
            return 3;
        }
        return -1;
    }

    protected int convertFitlineTypeToInt(String string) {
        int n = 0;
        if (string.equals("FT_NONE")) {
            n = 0;
        } else if (string.equals("FT_LINEAR")) {
            n = 1;
        } else if (string.equals("FT_LOGARITHMIC")) {
            n = 5;
        } else if (string.equals("FT_EXPONENTIAL")) {
            n = 8;
        }
        return n;
    }

    protected int convertAssignedToY2ToInt(String string) {
        if (string.equals("DY2_AUTO_ASSIGN")) {
            return 2;
        }
        if (string.equals("DY2_TRUE")) {
            return 1;
        }
        if (string.equals("DY2_FALSE")) {
            return 0;
        }
        return 2;
    }

    protected String convertMarkerShapeToString(int n) {
        String string = "MS_NONE";
        switch (n) {
            case -1: {
                string = "MS_AUTOMATIC";
                break;
            }
            case 0: {
                string = "MS_NONE";
                break;
            }
            case 2: {
                string = "MS_CIRCLE";
                break;
            }
            case 3: {
                string = "MS_DIAMOND";
                break;
            }
            case 4: {
                string = "MS_PLUS";
                break;
            }
            case 1: {
                string = "MS_SQUARE";
                break;
            }
            case 5: {
                string = "MS_TRIANGLE_DOWN";
                break;
            }
            case 6: {
                string = "MS_TRIANGLE_UP";
            }
        }
        return string;
    }

    protected String convertMarkerTypeToString(int n) {
        String string = "MT_DEFAULT";
        switch (n) {
            case 0: {
                string = "MT_DEFAULT";
                break;
            }
            case 1: {
                string = "MT_BAR";
                break;
            }
            case 2: {
                string = "MT_MARKER";
                break;
            }
            case 3: {
                string = "MT_AREA";
            }
        }
        return string;
    }

    protected String convertFitlineTypeToString(int n) {
        String string = "FT_NONE";
        switch (n) {
            case 0: {
                string = "FT_NONE";
                break;
            }
            case 1: {
                string = "FT_LINEAR";
                break;
            }
            case 5: {
                string = "FT_LOGARITHMIC";
                break;
            }
            case 8: {
                string = "FT_EXPONENTIAL";
            }
        }
        return string;
    }

    protected String convertAssignedToY2ToString(int n) {
        String string = "DY2_AUTO_ASSIGN";
        switch (n) {
            case 2: {
                string = "DY2_AUTO_ASSIGN";
                break;
            }
            case 1: {
                string = "DY2_TRUE";
                break;
            }
            case 0: {
                string = "DY2_FALSE";
            }
        }
        return string;
    }

    protected String getComponentName() {
        return "SeriesItems";
    }

    protected int getStylePropertyCount() {
        return 7;
    }

    protected ContainerNode getXML(boolean bl, boolean bl2) {
        ContainerNode containerNode = new ContainerNode(this.getComponentName());
        boolean bl3 = this.getSeriesItemsXML(bl, bl2, containerNode);
        int n = 0;
        while (n < this.m_pfj.getSeriesLooping()) {
            ObjectNode objectNode = new ObjectNode("Series");
            objectNode.addProperty("id", n);
            if (this.getSeriesXML(bl, bl2, objectNode, n)) {
                containerNode.addContainedObject(objectNode);
                bl3 = true;
            }
            ++n;
        }
        if (bl3) {
            return containerNode;
        }
        return null;
    }

    protected boolean getSeriesItemsXML(boolean bl, boolean bl2, ContainerNode containerNode) {
        boolean bl3 = false;
        if (bl || this.isUserOverrideFlag(0)) {
            containerNode.addProperty("defaultBorderColor", BaseGraphComponent.toHexString(this.getDefaultBorderColor().getRGB()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            containerNode.addProperty("defaultBorderTransparent", this.isDefaultBorderTransparent());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            containerNode.addProperty("borderUsingDefaults", this.isBorderUsingDefaults());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            if (this.getDefaultColor() == null) {
                containerNode.addProperty("defaultColor", "");
            } else {
                containerNode.addProperty("defaultColor", BaseGraphComponent.toHexString(this.getDefaultColor().getRGB()));
            }
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(4)) {
            containerNode.addProperty("defaultMarkerShape", this.convertMarkerShapeToString(this.m_defaultMarkerShape));
            bl3 = true;
        }
        if (bl2 && (bl || this.m_defaultMarkerType != GraphDefaultValues.getSeriesDefaultMarkerType())) {
            containerNode.addProperty("defaultMarkerType", this.convertMarkerTypeToString(this.m_defaultMarkerType));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(5)) {
            containerNode.addProperty("defaultLineWidth", this.m_defaultLineWidth);
            bl3 = true;
        }
        if (bl2 && (bl || this.m_defaultAssignedToY2 != GraphDefaultValues.getSeriesDefaultAssignedToY2())) {
            containerNode.addProperty("defaultAssignedToY2", this.convertAssignedToY2ToString(this.m_defaultAssignedToY2));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(6)) {
            containerNode.addProperty("defaultFitlineType", this.convertFitlineTypeToString(this.m_defaultFitlineType));
            bl3 = true;
        }
        return bl3;
    }

    protected boolean getSeriesXML(boolean bl, boolean bl2, ObjectNode objectNode, int n) {
        boolean bl3 = false;
        try {
            ContainerNode containerNode;
            if (this.m_graph.getSeriesEffect() != 1 && (containerNode = this.getSFX(n).getXML(bl, bl2)) != null) {
                objectNode.addContainer(containerNode);
                bl3 = true;
            }
            if (bl2 && (bl || this.getMarkerType(n) != this.m_defaultMarkerType)) {
                objectNode.addProperty("markerType", this.convertMarkerTypeToString(this.getMarkerType(n)));
                bl3 = true;
            }
            if (bl || this.isSeriesUserOverrideFlag(0, n)) {
                objectNode.addProperty("markerShape", this.convertMarkerShapeToString(this.getMarkerShape(n)));
                bl3 = true;
            }
            if (bl || this.isSeriesUserOverrideFlag(1, n)) {
                objectNode.addProperty("lineWidth", this.getLineWidth(n));
                bl3 = true;
            }
            if (bl2) {
                if (bl) {
                    objectNode.addProperty("assignedToY2", this.isAssignedToY2(n));
                    bl3 = true;
                } else if (this.m_defaultAssignedToY2 == 2) {
                    if (n != 1 && this.isAssignedToY2(n) != this.assignedToY2All || n == 1 && this.isAssignedToY2(n) != this.assignedToY2For1) {
                        objectNode.addProperty("assignedToY2", this.isAssignedToY2(n));
                        bl3 = true;
                    }
                } else {
                    boolean bl4;
                    boolean bl5 = bl4 = this.m_defaultAssignedToY2 == 1;
                    if (bl4 != this.isAssignedToY2(n)) {
                        objectNode.addProperty("assignedToY2", this.isAssignedToY2(n));
                        bl3 = true;
                    }
                }
            }
            if (bl || this.isSeriesUserOverrideFlag(2, n)) {
                objectNode.addProperty("color", BaseGraphComponent.toHexString(this.getColor(n).getRGB()));
                bl3 = true;
            }
            if (bl || !this.isBorderUsingDefaults() && this.isSeriesUserOverrideFlag(3, n)) {
                objectNode.addProperty("borderColor", BaseGraphComponent.toHexString(this.getBorderColor(n).getRGB()));
                bl3 = true;
            }
            if (bl || !this.isBorderUsingDefaults() && this.isSeriesUserOverrideFlag(4, n)) {
                objectNode.addProperty("borderTransparent", this.isBorderTransparent(n));
                bl3 = true;
            }
            if (bl || this.isSeriesUserOverrideFlag(5, n)) {
                objectNode.addProperty("fitlineType", this.convertFitlineTypeToString(this.getFitlineType(n)));
                bl3 = true;
            }
            if (bl || this.isSeriesUserOverrideFlag(6, n)) {
                objectNode.addProperty("pieSliceExplode", this.getPieSliceExplode(n));
                bl3 = true;
            }
            if (bl || this.isSeriesUserOverrideFlag(7, n)) {
                objectNode.addProperty("transparent", this.isTransparent(n));
                bl3 = true;
            }
            if (bl || this.isSeriesUserOverrideFlag(8, n)) {
                objectNode.addProperty("lineStyle", this.convertLineStyleToString(this.getLineStyle(n)));
                bl3 = true;
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            this.m_graph.getErrorHandler().log(" series is out of range ", this.getClass().getName(), "getSeriesStyleXML(boolean allProperties, ObjectNode seriesNode, int i)");
        }
        return bl3;
    }

    protected void setXML(ContainerNode containerNode, boolean bl) {
        this.setSeriesItemsXML(containerNode);
        Enumeration enumeration = containerNode.getContainedObject();
        while (enumeration.hasMoreElements()) {
            ObjectNode objectNode = (ObjectNode)enumeration.nextElement();
            PropertyNode propertyNode = objectNode.getProperty("id");
            if (propertyNode == null) continue;
            int n = propertyNode.getValueAsInteger();
            this.setSeriesXML(objectNode, n, bl);
        }
    }

    protected void setSeriesItemsXML(ContainerNode containerNode) {
        PropertyNode propertyNode = containerNode.getProperty("defaultBorderColor");
        if (propertyNode != null) {
            this.setDefaultBorderColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = containerNode.getProperty("defaultBorderTransparent")) != null) {
            this.setDefaultBorderTransparent(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = containerNode.getProperty("borderUsingDefaults")) != null) {
            this.setBorderUsingDefaults(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = containerNode.getProperty("defaultColor")) != null) {
            Color color = null;
            color = propertyNode.getValueAsString().equals("") ? null : new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString()));
            this.setDefaultColor(color);
        }
        if ((propertyNode = containerNode.getProperty("defaultMarkerShape")) != null) {
            this.setDefaultMarkerShape(this.convertMarkerShapeToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = containerNode.getProperty("defaultMarkerType")) != null) {
            this.setDefaultMarkerType(this.convertMarkerTypeToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = containerNode.getProperty("defaultLineWidth")) != null) {
            this.setDefaultLineWidth(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = containerNode.getProperty("defaultAssignedToY2")) != null) {
            this.setDefaultAssignedToY2(this.convertAssignedToY2ToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = containerNode.getProperty("defaultFitlineType")) != null) {
            this.setDefaultFitlineType(this.convertFitlineTypeToInt(propertyNode.getValueAsString()));
        }
    }

    protected void setSeriesXML(ObjectNode objectNode, int n, boolean bl) {
        try {
            ContainerNode containerNode;
            PropertyNode propertyNode = objectNode.getProperty("markerType");
            if (propertyNode != null) {
                this.setMarkerType(this.convertMarkerTypeToInt(propertyNode.getValueAsString()), n);
            }
            if ((propertyNode = objectNode.getProperty("markerShape")) != null) {
                this.setMarkerShape(this.convertMarkerShapeToInt(propertyNode.getValueAsString()), n);
            }
            if ((propertyNode = objectNode.getProperty("lineWidth")) != null) {
                this.setLineWidth(propertyNode.getValueAsInteger(), n);
            }
            if ((propertyNode = objectNode.getProperty("assignedToY2")) != null) {
                this.setAssignedToY2(propertyNode.getValueAsBoolean(), n);
            }
            if ((propertyNode = objectNode.getProperty("color")) != null) {
                this.setColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())), n);
            }
            if ((containerNode = objectNode.getContainer("SFX")) != null) {
                this.getSFX(n).setXML(containerNode, bl);
            }
            if ((propertyNode = objectNode.getProperty("borderColor")) != null) {
                this.setBorderColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())), n);
            }
            if ((propertyNode = objectNode.getProperty("borderTransparent")) != null) {
                this.setBorderTransparent(propertyNode.getValueAsBoolean(), n);
            }
            if ((propertyNode = objectNode.getProperty("fitlineType")) != null) {
                this.setFitlineType(this.convertFitlineTypeToInt(propertyNode.getValueAsString()), n);
            }
            if ((propertyNode = objectNode.getProperty("pieSliceExplode")) != null) {
                this.setPieSliceExplode(propertyNode.getValueAsInteger(), n);
            }
            if ((propertyNode = objectNode.getProperty("transparent")) != null) {
                this.setTransparent(propertyNode.getValueAsBoolean(), n);
            }
            if ((propertyNode = objectNode.getProperty("lineStyle")) != null) {
                this.setLineStyle(this.convertLineStyleToInt(propertyNode.getValueAsString()), n);
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            this.m_graph.getErrorHandler().log(" series is out of range ", this.getClass().getName(), "setSeriesStyleXML(ObjectNode seriesNode)");
        }
    }

    protected void resetStyle() {
        this.setDefaultBorderColor(new Color(this.borderColor));
        this.setDefaultBorderTransparent(this.borderTransparent);
        this.setBorderUsingDefaults(GraphDefaultValues.isSeriesBorderUsingDefaults());
        this.setDefaultLineWidth(GraphDefaultValues.getSeriesDefaultLineWidth());
        this.setDefaultFitlineType(GraphDefaultValues.getSeriesDefaultFitlineType());
        Color color = null;
        String string = GraphDefaultValues.getSeriesDefaultColor();
        color = string.equals("") ? null : new Color(BaseGraphComponent.hexStringToInt(string));
        this.setDefaultColor(color);
        try {
            int n = this.m_startSeries;
            while (n < this._getNumberOfSeries()) {
                this.setTransparent(this.transparent, n);
                this.setPieSliceExplode(this.pieSliceExplode, n);
                ++n;
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            this.m_graph.getErrorHandler().log(" series is out of range ", this.getClass().getName(), "resetStyle()");
        }
        this.createSeriesPropertyOverrideFlags();
        super.resetStyle();
    }

    protected void clearOverrideFlags() {
        this.createSeriesPropertyOverrideFlags();
        super.createPropertyOverrideFlags();
    }

    protected void createSeriesPropertyOverrideFlags() {
        int n = 0;
        while (n < 128) {
            this._seriesUserOverrideFlags[n] = this.m_graph.createPropertyOverrideFlags(9);
            this._seriesStyleOverrideFlags[n] = this.m_graph.createPropertyOverrideFlags(9);
            ++n;
        }
    }

    protected void setSeriesPropertyOverrideFlags(int n, int n2) {
        this.m_graph.setPropertyOverrideFlags(n, this._seriesUserOverrideFlags[n2], this._seriesStyleOverrideFlags[n2]);
    }

    protected void clearSeriesPropertyOverrideFlags(int n, int n2) {
        this.m_graph.clearPropertyOverrideFlag(n, this._seriesUserOverrideFlags[n2]);
        this.m_graph.clearPropertyOverrideFlag(n, this._seriesStyleOverrideFlags[n2]);
    }

    public boolean isSeriesUserOverrideFlag(int n, int n2) {
        return this.m_graph.isPropertyOverrideFlag(n, this._seriesUserOverrideFlags[n2]);
    }

    protected void displayMarkers(int n) {
        boolean bl;
        if (this.m_isMarkerShapeSet) {
            return;
        }
        boolean bl2 = false;
        if (n >= 61 && n <= 64 || n >= 65 && n <= 66) {
            bl2 = true;
        }
        boolean bl3 = bl = this.m_pfj.isChartScatter() || this.m_pfj.getJGraphType().isPolar();
        if (!bl2 && bl) {
            this.m_pfj.loopMarkerShapes(0, this._getNumberOfSeries());
        } else if (bl2 && !bl) {
            this.m_pfj.removeMarkerShapes(0, this._getNumberOfSeries());
        }
    }
}

