/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.util.BitSet;
import java.util.Enumeration;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.Line;
import oracle.dss.graph.Visible;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class QuadrantLine
extends BaseGraphComponent
implements Line,
Visible {
    protected static final int ATTR_VISIBLE = 0;
    protected static final int ATTR_LINECOLOR = 1;
    protected static final int ATTR_LINEWIDTH = 2;
    protected static final int ATTR_QUADRANTLINECOUNTX = 3;
    protected static final int ATTR_QUADRANTLINECOUNTY = 4;
    protected static final int ATTR_STYLE_MAXID = 5;
    protected static final int ATTR_QUADRANTLINEVALUEX = 0;
    protected static final int ATTR_QUADRANTLINEVALUEY = 1;
    protected static final int ATTR_QUADRANTLINE_STYLE_MAXID = 2;
    protected BitSet[] _lineUserOverrideFlags = new BitSet[10];
    protected BitSet[] _lineStyleOverrideFlags = new BitSet[10];
    protected boolean visible;
    protected int lineColor;
    protected int lineWidth;
    protected int quadrantLineCountX;
    protected int quadrantLineCountY;
    protected double quadrantLineValueX;
    protected double quadrantLineValueY;

    public QuadrantLine(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getQuadrantLine();
        this.initDefaultValues();
        this.createLinePropertyOverrideFlags();
    }

    private void initDefaultValues() {
        this.visible = GraphDefaultValues.isQuadrantLineVisible();
        this.lineColor = BaseGraphComponent.hexStringToInt(GraphDefaultValues.getQuadrantLineColor());
        this.lineWidth = GraphDefaultValues.getQuadrantLineWidth();
        this.quadrantLineCountX = GraphDefaultValues.getQuadrantLineCountX();
        this.quadrantLineCountY = GraphDefaultValues.getQuadrantLineCountY();
        this.quadrantLineValueX = GraphDefaultValues.getQuadrantLineValueX();
        this.quadrantLineValueY = GraphDefaultValues.getQuadrantLineValueY();
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public Color getLineColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setLineColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setLineColor( Color newColor )");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, color);
        this.setPropertyOverrideFlags(1);
    }

    public int getLineWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj);
    }

    public void setLineWidth(int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_identObj, n);
            this.setPropertyOverrideFlags(2);
        }
    }

    public int getQuadrantLineCountX() {
        return this.m_pfj.getQuadrantLineCountX();
    }

    public void setQuadrantLineCountX(int n) {
        if (n < 1 || n > 10) {
            this.m_graph.getErrorHandler().log("invalid count of quadrant lines", this.getClass().getName(), "setQuadrantLineCountX (int count)");
        } else {
            this.m_pfj.setQuadrantLineCountX(n);
            this.setPropertyOverrideFlags(3);
        }
    }

    public int getQuadrantLineCountY() {
        return this.m_pfj.getQuadrantLineCountY();
    }

    public void setQuadrantLineCountY(int n) {
        if (n < 1 || n > 10) {
            this.m_graph.getErrorHandler().log("invalid count of quadrant lines", this.getClass().getName(), "setQuadrantLineCountY (int count)");
        } else {
            this.m_pfj.setQuadrantLineCountY(n);
            this.setPropertyOverrideFlags(4);
        }
    }

    public double getQuadrantLineValueX(int n) {
        return this.m_pfj.getQuadrantLineValueX(n);
    }

    public void setQuadrantLineValueX(int n, double d) {
        if (n < 0 || n >= 10) {
            this.m_graph.getErrorHandler().log("invalid quadrant line", this.getClass().getName(), "setQuadrantLineValueX (int count, position)");
        } else {
            this.m_pfj.setQuadrantLineValueX(n, d);
            this.setLinePropertyOverrideFlags(0, n);
        }
    }

    public double getQuadrantLineValueY(int n) {
        return this.m_pfj.getQuadrantLineValueY(n);
    }

    public void setQuadrantLineValueY(int n, double d) {
        if (n < 0 || n >= 10) {
            this.m_graph.getErrorHandler().log("invalid quadrant line", this.getClass().getName(), "setQuadrantLineValueY (int count, position)");
        } else {
            this.m_pfj.setQuadrantLineValueY(n, d);
            this.setLinePropertyOverrideFlags(1, n);
        }
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean bl) {
        this.m_pfj.setDisplay(this.m_identObj, bl);
        this.setPropertyOverrideFlags(0);
    }

    protected String getComponentName() {
        return "QuadrantLine";
    }

    protected int getStylePropertyCount() {
        return 5;
    }

    protected boolean getXML(boolean bl, ObjectNode objectNode) {
        ContainerNode containerNode = new ContainerNode(this.getComponentName());
        boolean bl2 = this.getStyleXML(bl, containerNode);
        if (bl2) {
            objectNode.addContainer(containerNode);
        }
        return bl2;
    }

    protected boolean getStyleXML(boolean bl, ContainerNode containerNode) {
        ObjectNode objectNode;
        boolean bl2;
        boolean bl3 = false;
        if (bl || this.isUserOverrideFlag(1)) {
            containerNode.addProperty("lineColor", BaseGraphComponent.toHexString(this.getLineColor().getRGB()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            containerNode.addProperty("lineWidth", this.getLineWidth());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            containerNode.addProperty("quadrantLineCountX", this.getQuadrantLineCountX());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(4)) {
            containerNode.addProperty("quadrantLineCountY", this.getQuadrantLineCountY());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(0)) {
            containerNode.addProperty("visible", this.isVisible());
            bl3 = true;
        }
        int n = 0;
        while (n < this.getQuadrantLineCountX()) {
            bl2 = false;
            objectNode = new ObjectNode("QuadrantLineValueX");
            objectNode.addProperty("lineIndex", n);
            if (bl || this.isLineUserOverrideFlag(0, n)) {
                objectNode.addProperty("position", this.getQuadrantLineValueX(n));
                bl2 = true;
            }
            if (bl2) {
                containerNode.addContainedObject(objectNode);
                bl3 = true;
            }
            ++n;
        }
        n = 0;
        while (n < this.getQuadrantLineCountY()) {
            bl2 = false;
            objectNode = new ObjectNode("QuadrantLineValueY");
            objectNode.addProperty("lineIndex", n);
            if (bl || this.isLineUserOverrideFlag(1, n)) {
                objectNode.addProperty("position", this.getQuadrantLineValueY(n));
                bl2 = true;
            }
            if (bl2) {
                containerNode.addContainedObject(objectNode);
                bl3 = true;
            }
            ++n;
        }
        return bl3;
    }

    protected void setXML(ContainerNode containerNode) {
        this.setStyleXML(containerNode);
    }

    protected void setStyleXML(ContainerNode containerNode) {
        int n;
        PropertyNode propertyNode;
        ObjectNode objectNode;
        PropertyNode propertyNode2 = containerNode.getProperty("lineColor");
        if (propertyNode2 != null) {
            this.setLineColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode2.getValueAsString())));
        }
        if ((propertyNode2 = containerNode.getProperty("lineWidth")) != null) {
            this.setLineWidth(propertyNode2.getValueAsInteger());
        }
        if ((propertyNode2 = containerNode.getProperty("quadrantLineCountX")) != null) {
            this.setQuadrantLineCountX(propertyNode2.getValueAsInteger());
        }
        if ((propertyNode2 = containerNode.getProperty("quadrantLineCountY")) != null) {
            this.setQuadrantLineCountY(propertyNode2.getValueAsInteger());
        }
        if ((propertyNode2 = containerNode.getProperty("visible")) != null) {
            this.setVisible(propertyNode2.getValueAsBoolean());
        }
        Enumeration enumeration = containerNode.getContainedObject("QuadrantLineValueX");
        while (enumeration.hasMoreElements()) {
            objectNode = (ObjectNode)enumeration.nextElement();
            propertyNode = objectNode.getProperty("lineIndex");
            if (propertyNode == null) continue;
            n = propertyNode.getValueAsInteger();
            propertyNode2 = objectNode.getProperty("position");
            if (propertyNode2 == null) continue;
            this.setQuadrantLineValueX(n, propertyNode2.getValueAsDouble());
        }
        enumeration = containerNode.getContainedObject("QuadrantLineValueY");
        while (enumeration.hasMoreElements()) {
            objectNode = (ObjectNode)enumeration.nextElement();
            propertyNode = objectNode.getProperty("lineIndex");
            if (propertyNode == null) continue;
            n = propertyNode.getValueAsInteger();
            propertyNode2 = objectNode.getProperty("position");
            if (propertyNode2 == null) continue;
            this.setQuadrantLineValueY(n, propertyNode2.getValueAsDouble());
        }
    }

    protected void resetStyle() {
        this.setLineColor(new Color(this.lineColor));
        this.setLineWidth(this.lineWidth);
        this.setQuadrantLineCountX(this.quadrantLineCountX);
        this.setQuadrantLineCountY(this.quadrantLineCountY);
        this.setVisible(this.visible);
        int n = 0;
        while (n < this.getQuadrantLineCountX()) {
            this.setQuadrantLineValueX(n, this.quadrantLineValueX);
            ++n;
        }
        n = 0;
        while (n < this.getQuadrantLineCountY()) {
            this.setQuadrantLineValueY(n, this.quadrantLineValueY);
            ++n;
        }
        this.createLinePropertyOverrideFlags();
        super.resetStyle();
    }

    protected void clearOverrideFlags() {
        this.createLinePropertyOverrideFlags();
        super.createPropertyOverrideFlags();
    }

    protected void createLinePropertyOverrideFlags() {
        int n = 0;
        while (n < 10) {
            this._lineUserOverrideFlags[n] = this.m_graph.createPropertyOverrideFlags(2);
            this._lineStyleOverrideFlags[n] = this.m_graph.createPropertyOverrideFlags(2);
            ++n;
        }
    }

    protected void setLinePropertyOverrideFlags(int n, int n2) {
        this.m_graph.setPropertyOverrideFlags(n, this._lineUserOverrideFlags[n2], this._lineStyleOverrideFlags[n2]);
    }

    protected boolean isLineUserOverrideFlag(int n, int n2) {
        return this.m_graph.isPropertyOverrideFlag(n, this._lineUserOverrideFlags[n2]);
    }
}

