/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIFillColor;
import oracle.dss.dataView.UITransparentFillColor;
import oracle.dss.graph.BaseFrame;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UIBaseFrame;
import oracle.dss.graph.pfj.draw.IdentObj;

public class PlotArea
extends BaseFrame
implements UIBaseFrame,
UIFillColor,
UITransparentFillColor {
    protected static int rect_Height = 17106;
    protected static int rect_Width = 20800;
    protected static int rect_X = -10391;
    protected static int rect_Y = 9518;
    protected IdentObj m_frameSide;
    protected IdentObj m_frameBottom;

    public PlotArea(Graph graph, IdentObj identObj) {
        super(graph, identObj);
        this.m_frameSide = this.m_pfj.getFrameSide();
        this.m_frameBottom = this.m_pfj.getFrameBottom();
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.fillColor = GraphDefaultValues.getPlotAreaFillColor().getRGB();
        this.fillTransparent = GraphDefaultValues.isPlotAreaFillTransparent();
        this.borderColor = GraphDefaultValues.getPlotAreaBorderColor();
        this.borderTransparent = GraphDefaultValues.isPlotAreaBorderTransparent();
    }

    protected void setGroupFillColor(Color color) {
        this.m_pfj.setFillColor(this.m_pfj.getCubeFloor(), color);
        this.m_pfj.setFillColor(this.m_pfj.getPieFrame(), color);
        this.m_pfj.setFillColor(this.m_identObj, color);
        this.m_pfj.setFillColor(this.m_frameSide, color);
        this.m_pfj.setFillColor(this.m_frameBottom, color);
        this.setPropertyOverrideFlags(0);
    }

    public void setGroupFillTransparent(boolean bl) {
        this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeFloor(), bl);
        this.m_pfj.setTransparentFillColor(this.m_pfj.getPieFrame(), bl);
        this.m_pfj.setTransparentFillColor(this.m_identObj, bl);
        this.m_pfj.setTransparentFillColor(this.m_frameSide, bl);
        this.m_pfj.setTransparentFillColor(this.m_frameBottom, bl);
        this.setPropertyOverrideFlags(1);
    }

    protected String getComponentName() {
        return "PlotArea";
    }
}

