/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseText;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class PieLabel
extends BaseText {
    protected static final int ATTR_VISIBLE = 1;
    protected static final int ATTR_STYLE_MAXID = 2;
    protected String m_text;
    protected String text;

    public PieLabel(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getPieLabel();
        this.m_text = "";
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.text = GraphDefaultValues.getPieLabelText();
        this.fontTypeface = GraphDefaultValues.getPieLabelFontTypeface();
        this.fontColor = GraphDefaultValues.getPieLabelFontColor();
        this.fontStyle = GraphDefaultValues.getPieLabelFontStyle();
        this.fontSize = GraphDefaultValues.getPieLabelFontSize();
        this.graphProportionalFontSize = GraphDefaultValues.getPieLabelGraphProportionalFontSize();
    }

    public boolean selectObject(int n, int n2) {
        if (n2 >= 0) {
            IdentObj identObj = new IdentObj(this.m_identObj);
            identObj.setGroupID(n2);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String string) {
        if (string == null) {
            this.m_graph.getErrorHandler().log("invalid text", this.getClass().toString(), "setText");
            return;
        }
        this.m_text = string;
        this.m_pfj.setPieBarLabelString(string);
        this.m_pfj.setDisplay(this.m_identObj, true);
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean bl) {
        this.m_pfj.setDisplay(this.m_identObj, bl);
        this.setPropertyOverrideFlags(1);
    }

    protected String getComponentName() {
        return "PieLabel";
    }

    protected int getStylePropertyCount() {
        return 2;
    }

    protected boolean getNonstyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getNonstyleXML(bl, objectNode);
        if (bl || !this.text.equals(this.getText())) {
            objectNode.addProperty("text", this.getText());
            bl2 = true;
        }
        return bl2;
    }

    protected void setNonstyleXML(ObjectNode objectNode) {
        super.setNonstyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("text");
        if (propertyNode != null) {
            this.setText(propertyNode.getValueAsString());
        }
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("visible", this.isVisible());
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("visible");
        if (propertyNode != null) {
            this.setVisible(propertyNode.getValueAsBoolean());
        }
    }

    protected void resetStyle() {
        this.m_pfj.setDisplay(this.m_identObj, GraphDefaultValues.isPieLabelVisible());
        super.resetStyle();
    }
}

