/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.scrolling.ArrowBox;
import oracle.dss.dataView.DataviewPageItem;
import oracle.dss.dataView.DataviewPagingComponent;
import oracle.dss.dataView.PagingControl;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphModel;
import oracle.dss.util.EdgeOutOfRangeException;

public class GraphPagingControl
extends PagingControl {
    protected Graph m_graph;
    protected boolean m_visible;
    private PropertyChangeListener m_propListener;
    private PagingPivotListener m_pivotListener;
    private static final String m_method_updatePageItemStyles = "protected void updatePageItemStyles()";

    public GraphPagingControl(Graph graph, GraphModel graphModel) {
        super(graph, graphModel);
        this.m_graph = graph;
    }

    protected void updatePageItemStyles() {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            int n = 2;
            int n2 = -1;
            try {
                n2 = this.m_graph.getModel().getDataAccess().getEdgeCurrentSlice(2);
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                this.m_graph.getErrorHandler().log("edge out of range when getting current page slice", this.getClass().getName(), m_method_updatePageItemStyles);
            }
            int n3 = 0;
            while (n3 < dataviewPagingComponent.getComponentCount()) {
                DataviewPageItem dataviewPageItem = (DataviewPageItem)dataviewPagingComponent.getItem(n3);
                ViewStyle viewStyle = this.m_graph.getGraphStyleManager().getMetadataStyle(this.m_graph, dataviewPageItem.getSelectedValue(), this.getViewStyle(), n, n3, n2);
                viewStyle.setView(this.m_graph);
                dataviewPageItem.setAppearance(viewStyle);
                ++n3;
            }
        }
    }

    public void setVisible(boolean bl) {
        if (this.m_fIsJavaPaging && bl && this.getPagingComponent() == null) {
            this.initUI();
            if (this.m_propListener != null) {
                this.getPagingComponent().addPropertyChangeListener(this.m_propListener);
            }
            if (this.m_pivotListener != null) {
                this.getPagingComponent().addPivotListener(this.m_pivotListener);
            }
        }
        if (this.m_fIsJavaPaging && bl && this.getParent() == null) {
            this.m_graph.add((Component)this, "North");
            this.m_graph.setPagingControlPosition(this.m_graph.getPagingControlPosition());
            this.updatePageItemStyles();
            if (this.m_arrowBox.getViewportView() == null) {
                this.m_arrowBox.setViewportView((Component)((Object)this.m_pc));
            }
        }
        if (this.m_fIsJavaPaging) {
            super.setVisible(bl);
        } else {
            this.m_visible = bl;
        }
    }

    public boolean isVisible() {
        if (this.m_fIsJavaPaging) {
            return super.isVisible();
        }
        return this.m_visible;
    }

    public void updatePageItems() {
        super.updatePageItems();
        this.updatePageItemStyles();
    }

    protected ArrowBox getArrowBox(JComponent jComponent) {
        return new ArrowBox();
    }

    protected void init() {
    }

    void addPagingPropertyListener(PropertyChangeListener propertyChangeListener) {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            dataviewPagingComponent.addPropertyChangeListener(propertyChangeListener);
        } else {
            this.m_propListener = propertyChangeListener;
        }
    }

    void removePagingPropertyListener(PropertyChangeListener propertyChangeListener) {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            dataviewPagingComponent.removePropertyChangeListener(propertyChangeListener);
        } else {
            this.m_propListener = null;
        }
    }

    void addPagingPivotListener(PagingPivotListener pagingPivotListener) {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            dataviewPagingComponent.addPivotListener(pagingPivotListener);
        } else {
            this.m_pivotListener = pagingPivotListener;
        }
    }

    void removePagingPivotListener(PagingPivotListener pagingPivotListener) {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            dataviewPagingComponent.removePivotListener(pagingPivotListener);
        } else {
            this.m_pivotListener = null;
        }
    }
}

