/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.Background;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Fill;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.SFX;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class GraphBackground
extends BaseGraphComponent
implements Fill,
Background {
    protected static final int ATTR_FILLCOLOR = 0;
    protected static final int ATTR_FILLTRANSPARENT = 1;
    protected static final int ATTR_STYLE_MAXID = 2;
    protected Color color;
    protected boolean fillTransparent;
    protected Color backGround;
    protected SFX m_sfx;

    public GraphBackground(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getChartBackground();
        this.color = GraphDefaultValues.getGraphBackgroundFillColor();
        this.fillTransparent = GraphDefaultValues.isGraphBackgroundFillTransparent();
        this.backGround = GraphDefaultValues.getGraphBackgroundColor();
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_graph, this.m_identObj);
        }
        return this.m_sfx;
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    public void setFillColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, color);
        this.setPropertyOverrideFlags(0);
    }

    public boolean isFillTransparent() {
        return this.m_pfj.getTransparentFillColor(this.m_identObj);
    }

    public void setFillTransparent(boolean bl) {
        this.m_graph.setBackgroundTransparent(bl);
        this.m_pfj.setTransparentFillColor(this.m_identObj, bl);
        this.setPropertyOverrideFlags(1);
    }

    public void setBackground(Color color) {
        this.setFillColor(color);
    }

    public Color getBackground() {
        return this.getFillColor();
    }

    protected String getComponentName() {
        return "Background";
    }

    protected int getStylePropertyCount() {
        return 2;
    }

    protected ObjectNode getXML(boolean bl, boolean bl2) {
        ContainerNode containerNode;
        ObjectNode objectNode = new ObjectNode(this.getComponentName());
        boolean bl3 = false;
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("fillColor", BaseGraphComponent.toHexString(this.getFillColor().getRGB()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("fillTransparent", this.isFillTransparent());
            bl3 = true;
        }
        if ((containerNode = this.getSFX().getXML(bl, bl2)) != null) {
            objectNode.addContainer(containerNode);
            bl3 = true;
        }
        return bl3 ? objectNode : null;
    }

    protected void setXML(ObjectNode objectNode, boolean bl) {
        ContainerNode containerNode;
        PropertyNode propertyNode = objectNode.getProperty("fillColor");
        if (propertyNode != null) {
            this.setFillColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((containerNode = objectNode.getContainer("SFX")) != null) {
            this.getSFX().setXML(containerNode, bl);
        }
        if ((propertyNode = objectNode.getProperty("fillTransparent")) != null) {
            this.setFillTransparent(propertyNode.getValueAsBoolean());
        }
        if (bl && (propertyNode = objectNode.getProperty("backGround")) != null) {
            this.setBackground(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
    }

    protected void resetStyle() {
        this.m_pfj.setFillColor(this.m_identObj, this.color);
        this.m_pfj.setTransparentFillColor(this.m_identObj, this.fillTransparent);
        super.resetStyle();
    }

    protected void createPropertyOverrideFlags() {
        if (this.m_sfx != null) {
            this.m_sfx.createPropertyOverrideFlags();
        }
        super.createPropertyOverrideFlags();
    }
}

