/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.Graph;
import oracle.dss.graph.pfj.DrillCallback;

class DrillDataCallback
implements DrillCallback {
    protected Graph m_graph;

    public DrillDataCallback(Graph graph) {
        this.m_graph = graph;
    }

    public void saveDrillState() {
        if (this.m_graph.isDrillStateClear()) {
            this.m_graph.saveDrillState();
        }
    }

    public boolean isDrillable(int n, int n2, int n3) {
        if (!this.m_graph.isDrillingEnabled() || !this.m_graph.isDrillingSupported()) {
            return false;
        }
        boolean bl = this.m_graph.getPFJ().getSeriesAreRows();
        boolean bl2 = false;
        switch (n) {
            case 14: 
            case 274: {
                int n4 = bl ? 1 : 0;
                bl2 = this.m_graph.getDrillState(n4, n2);
                break;
            }
            case 270: 
            case 296: {
                int n5 = bl ? 0 : 1;
                bl2 = this.m_graph.getDrillState(n5, n3);
            }
        }
        return bl2;
    }

    public boolean isDrillingEnabled() {
        return this.m_graph.isDrillingEnabled() && this.m_graph.isDrillingSupported();
    }

    public String getDrillUpLabel(int n) {
        String string = null;
        if (!this.m_graph.isDrillingEnabled() || !this.m_graph.isDrillingSupported()) {
            return null;
        }
        boolean bl = this.m_graph.getPFJ().getSeriesAreRows();
        switch (n) {
            case 14: 
            case 274: {
                int n2 = bl ? 1 : 0;
                string = this.m_graph.getDrillUpLabel(n2);
                break;
            }
            case 270: 
            case 296: {
                int n3 = bl ? 0 : 1;
                string = this.m_graph.getDrillUpLabel(n3);
            }
        }
        return string;
    }
}

