/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.HorizontalAlignment;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.Graph;
import oracle.dss.graph.UIDataTickLabel;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseTickLabel
extends BaseText
implements UIDataTickLabel,
HorizontalAlignment {
    protected static final int ATTR_TEXTROTATION = 1;
    protected static final int ATTR_HORIZONTALALIGNMENT = 2;
    protected static final int ATTR_TICKLABELSTAGGERED = 3;
    protected static final int ATTR_BASETICKLABEL_LASTID = 3;
    protected static final int ATTR_STYLE_MAXID = 4;
    protected boolean textFittingAutomatic;
    protected int textRotation;
    protected boolean tickLabelStaggered;
    protected int horizontalAlignment;

    public BaseTickLabel(Graph graph) {
        super(graph);
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public int getHorizontalAlignment() {
        return this.convertPFJHAlignmentToSwing(this.m_pfj.getTextJustHoriz(this.m_identObj));
    }

    public void setHorizontalAlignment(int n) {
        int n2 = this.convertSwingHAlignmentToPFJ(n);
        if (n2 == -1) {
            this.m_graph.getErrorHandler().log("invalid horizontal aligment", this.getClass().getName(), "setHorizontalAlignment(a)");
        } else {
            this.m_pfj.setTextJustHoriz(this.m_identObj, this.convertSwingHAlignmentToPFJ(n));
            this.setPropertyOverrideFlags(2);
        }
    }

    public int getTextRotation() {
        return this.m_pfj.getTextRotation(this.m_identObj);
    }

    public void setTextRotation(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int orient)");
        } else {
            this.m_pfj.setTextRotation(this.m_identObj, n);
            this.setPropertyOverrideFlags(1);
        }
    }

    public abstract boolean isTickLabelStaggered();

    public abstract void setTickLabelStaggered(boolean var1);

    public boolean isTextFittingAutomatic() {
        return false;
    }

    public void setTextFittingAutomatic(boolean bl) {
    }

    protected int getStylePropertyCount() {
        return 4;
    }

    protected void setXML(ObjectNode objectNode) {
        this.setStyleXML(objectNode);
        this.setNonstyleXML(objectNode);
    }

    protected boolean getNonstyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getNonstyleXML(bl, objectNode);
        if (bl || this.textFittingAutomatic != this.isTextFittingAutomatic()) {
            objectNode.addProperty("textFittingAutomatic", this.isTextFittingAutomatic());
            bl2 = true;
        }
        return bl2;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(1)) {
            if (this.getTextRotation() == 0) {
                objectNode.addProperty("textRotation", "TR_HORIZ");
            } else if (this.getTextRotation() == 1) {
                objectNode.addProperty("textRotation", "TR_HORIZ_ROTATE_90");
            } else if (this.getTextRotation() == 2) {
                objectNode.addProperty("textRotation", "TR_HORIZ_ROTATE_270");
            }
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString(this.getHorizontalAlignment()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            objectNode.addProperty("tickLabelStaggered", this.isTickLabelStaggered());
            bl2 = true;
        }
        return bl2;
    }

    protected void setNonstyleXML(ObjectNode objectNode) {
        super.setNonstyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("textFittingAutomatic");
        if (propertyNode != null) {
            this.setTextFittingAutomatic(propertyNode.getValueAsBoolean());
        }
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("textRotation");
        if (propertyNode != null) {
            String string = propertyNode.getValueAsString();
            if (string.equals("TR_HORIZ")) {
                this.setTextRotation(0);
            } else if (string.equals("TR_HORIZ_ROTATE_90")) {
                this.setTextRotation(1);
            } else if (string.equals("TR_HORIZ_ROTATE_270")) {
                this.setTextRotation(2);
            }
        }
        if ((propertyNode = objectNode.getProperty("horizontalAlignment")) != null) {
            this.setHorizontalAlignment(this.convertHorizontalAlignmentToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty("tickLabelStaggered")) != null) {
            this.setTickLabelStaggered(propertyNode.getValueAsBoolean());
        }
    }

    public void resetStyle() {
        this.setTextRotation(this.textRotation);
        this.setHorizontalAlignment(this.horizontalAlignment);
        this.setTickLabelStaggered(this.tickLabelStaggered);
        super.resetStyle();
    }
}

