/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UIAssignedValue;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseLine
extends BaseGraphComponent
implements UIAssignedValue {
    protected String m_name;

    public BaseLine(Graph graph) {
        super(graph);
    }

    protected void setXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty("value");
        if (propertyNode != null) {
            this.setValue(propertyNode.getValueAsDouble());
        }
    }

    protected ObjectNode getXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(this.m_name);
        boolean bl2 = false;
        if (bl || GraphDefaultValues.getBaseLineValue() != this.getValue()) {
            objectNode.addProperty("value", this.getValue());
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    public double getValue() {
        if (this.m_pfj.getNonZeroBaseline(this.m_identObj)) {
            return this.m_pfj.getNonZeroBaselineValue(this.m_identObj);
        }
        return GraphDefaultValues.getBaseLineValue();
    }

    public void setValue(double d) {
        if (d == 0.0) {
            this.m_pfj.setNonZeroBaseline(this.m_identObj, false);
            return;
        }
        this.m_pfj.setNonZeroBaseline(this.m_identObj, true);
        this.m_pfj.setNonZeroBaselineValue(this.m_identObj, d);
    }
}

