/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.BasePanel;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.gui.InsertButton;
import oracle.dss.util.gui.LimitedTextDocument;
import oracle.dss.util.gui.ViewTextField;
import oracle.dss.util.help.HelpContext;

public class TitlePanel
extends BasePanel
implements ActionListener,
ItemListener,
PropertyChangeListener,
CaretListener,
HelpContext {
    public static final String PROPERTY_TITLE_VISIBLE = "Title Visible";
    public static final String PROPERTY_SUBTITLE_VISIBLE = "Subtitle Visible";
    public static final String PROPERTY_FOOTNOTE_VISIBLE = "Footnote Visible";
    public static final String PROPERTY_TITLE_TEXT = "Title Text";
    public static final String PROPERTY_SUBTITLE_TEXT = "Subtitle Text";
    public static final String PROPERTY_FOOTNOTE_TEXT = "Footnote Text";
    public static final String DEFAULT_FORMAT_CHANGED = "DefaultFormatChanged";
    protected boolean m_showTitle;
    protected boolean m_showSubtitle;
    protected boolean m_showFootnote;
    protected JCheckBox m_shTitleCBox;
    protected JCheckBox m_shSubtitleCBox;
    protected JCheckBox m_shFootnoteCBox;
    protected MyViewTextField m_TitleTxt;
    protected MyViewTextField m_SubtitleTxt;
    protected MyViewTextField m_FootnoteTxt;
    protected MyViewTextField m_TextArea;
    protected Font m_TitleFont;
    protected Font m_SubtitleFont;
    protected Font m_FootnoteFont;
    protected Font m_Font;
    protected FontButton m_TitleFontButton;
    protected FontButton m_SubtitleFontButton;
    protected FontButton m_FootnoteFontButton;
    protected InsertButton m_InsertTitle;
    protected InsertButton m_InsertSubtitle;
    protected InsertButton m_InsertFootnote;
    protected InsertButton m_Insert;
    protected TokenSubstitution m_token;
    protected boolean m_bFontNameChange;
    protected boolean m_bFontStyleChange;
    protected boolean m_bFontSizeChange;
    protected boolean m_bHorizontalAlignmentChange;
    protected boolean m_bFontColorChange;
    protected boolean m_bFontBackgroundColorChange;
    protected boolean m_titleFontChange;
    protected boolean m_titleFontAlignmentChange;
    protected boolean m_titleFontColorChange;
    protected boolean m_titleBackgroundChange;
    protected boolean m_titleStrikeThroughChange;
    protected boolean m_titleUnderlineChange;
    protected boolean m_subtitleFontChange;
    protected boolean m_subtitleFontAlignmentChange;
    protected boolean m_subtitleFontColorChange;
    protected boolean m_subtitleBackgroundChange;
    protected boolean m_subtitleStrikeThroughChange;
    protected boolean m_subtitleUnderlineChange;
    protected boolean m_footnoteFontChange;
    protected boolean m_footnoteFontAlignmentChange;
    protected boolean m_footnoteFontColorChange;
    protected boolean m_footnoteBackgroundChange;
    protected boolean m_footnoteStrikeThroughChange;
    protected boolean m_footnoteUnderlineChange;
    protected boolean m_bHelpEnabled;
    protected String m_strHelpContextID;
    protected HelpProvider m_helpProvider;
    protected String m_oldFontName;
    protected String m_newFontName;
    protected int m_oldFontStyle;
    protected int m_newFontStyle;
    protected int m_oldFontSize;
    protected int m_newFontSize;
    protected int m_oldHAlignment;
    protected int m_newHAlignment;
    protected Color m_oldFontColor;
    protected Color m_newFontColor;
    protected Color m_oldFontBackgroundColor;
    protected Color m_newFontBackgroundColor;
    protected String m_oldTitle;
    protected String m_oldSubtitle;
    protected String m_oldFootnote;
    protected Title title;
    protected Subtitle subtitle;
    protected Footnote footnote;
    protected Dimension prefSize;
    protected boolean insertButtonVisible = true;
    private ResourceBundle rBundle;
    private Locale m_locale;
    private boolean m_bSuperCalled = true;
    private JPanel titlePanel;
    private JPanel subtitlePanel;
    private JPanel footnotePanel;
    private JPanel subPanel1;
    private JPanel subPanel2;
    private JPanel subPanel3;
    private String[] tokenArray;

    public TitlePanel(UIDataview uIDataview) {
        super(uIDataview);
        this.m_dataview = uIDataview;
        if (this.m_dataview != null) {
            this.setLocale(this.m_dataview.getLocale());
        } else {
            this.updateResourceBundle(null);
        }
        this.init();
        this.constructPanel();
    }

    public void setDataview(UIDataview uIDataview) {
        super.setDataview(uIDataview);
        this.m_bSuperCalled = true;
        this.initFromDataview();
    }

    public void setTitle(Font font, boolean bl, boolean bl2, Color color, Color color2) {
        this.m_TitleFont = font;
        this.m_TitleTxt.setFont(new Font(font.getName(), font.getStyle(), this.m_TitleTxt.getFont().getSize()));
        this.m_TitleTxt.setForeground(color);
        this.m_TitleTxt.setBackground(color2);
        this.m_TitleTxt.setUnderline(bl);
        this.m_TitleFontButton.setComponentFont(this.m_TitleFont);
        this.m_TitleFontButton.setUnderlineStyle(bl);
        this.m_TitleFontButton.setComponentForeground(color);
        this.m_TitleFontButton.setComponentBackground(color2);
        this.m_titleFontChange = true;
        this.m_titleFontAlignmentChange = true;
        this.m_titleFontColorChange = true;
        this.m_titleBackgroundChange = true;
        this.m_titleStrikeThroughChange = true;
        this.m_titleUnderlineChange = true;
    }

    public void setSubtitle(Font font, boolean bl, boolean bl2, Color color, Color color2) {
        this.m_SubtitleFont = font;
        this.m_SubtitleTxt.setFont(new Font(font.getName(), font.getStyle(), this.m_SubtitleTxt.getFont().getSize()));
        this.m_SubtitleTxt.setForeground(color);
        this.m_SubtitleTxt.setBackground(color2);
        this.m_SubtitleTxt.setUnderline(bl);
        this.m_SubtitleFontButton.setComponentFont(this.m_SubtitleFont);
        this.m_SubtitleFontButton.setUnderlineStyle(bl);
        this.m_SubtitleFontButton.setComponentForeground(color);
        this.m_SubtitleFontButton.setComponentBackground(color2);
        this.m_subtitleFontChange = true;
        this.m_subtitleFontAlignmentChange = true;
        this.m_subtitleFontColorChange = true;
        this.m_subtitleBackgroundChange = true;
        this.m_subtitleStrikeThroughChange = true;
        this.m_subtitleUnderlineChange = true;
    }

    public void setFootnote(Font font, boolean bl, boolean bl2, Color color, Color color2) {
        this.m_FootnoteFont = font;
        this.m_FootnoteTxt.setFont(new Font(font.getName(), font.getStyle(), this.m_FootnoteTxt.getFont().getSize()));
        this.m_FootnoteTxt.setForeground(color);
        this.m_FootnoteTxt.setBackground(color2);
        this.m_FootnoteTxt.setUnderline(bl);
        this.m_FootnoteFontButton.setComponentFont(this.m_FootnoteFont);
        this.m_FootnoteFontButton.setUnderlineStyle(bl);
        this.m_FootnoteFontButton.setComponentForeground(color);
        this.m_FootnoteFontButton.setComponentBackground(color2);
        this.m_footnoteFontChange = true;
        this.m_footnoteFontAlignmentChange = true;
        this.m_footnoteFontColorChange = true;
        this.m_footnoteBackgroundChange = true;
        this.m_footnoteStrikeThroughChange = true;
        this.m_footnoteUnderlineChange = true;
    }

    public Font getTitleFont() {
        return this.m_TitleFont;
    }

    public Color getTitleForeground() {
        return this.m_TitleTxt.getForeground();
    }

    public Color getTitleBackground() {
        return this.m_TitleTxt.getBackground();
    }

    public boolean isTitleUnderline() {
        return this.m_TitleTxt.isUnderline();
    }

    public boolean isTitleStrikeThrough() {
        return this.m_TitleTxt.isStrikeThrough();
    }

    public Font getSubtitleFont() {
        return this.m_SubtitleFont;
    }

    public Color getSubtitleForeground() {
        return this.m_SubtitleTxt.getForeground();
    }

    public Color getSubtitleBackground() {
        return this.m_SubtitleTxt.getBackground();
    }

    public boolean isSubtitleUnderline() {
        return this.m_SubtitleTxt.isUnderline();
    }

    public boolean isSubtitleStrikeThrough() {
        return this.m_SubtitleTxt.isStrikeThrough();
    }

    public Font getFootnoteFont() {
        return this.m_FootnoteFont;
    }

    public Color getFootnoteForeground() {
        return this.m_FootnoteTxt.getForeground();
    }

    public Color getFootnoteBackground() {
        return this.m_FootnoteTxt.getBackground();
    }

    public boolean isFootnoteUnderline() {
        return this.m_FootnoteTxt.isUnderline();
    }

    public boolean isFootnoteStrikeThrough() {
        return this.m_FootnoteTxt.isStrikeThrough();
    }

    public void setColorPalette(Color[][] colorArray) {
        this.m_TitleFontButton.setColorPalette(colorArray);
        this.m_SubtitleFontButton.setColorPalette(colorArray);
        this.m_FootnoteFontButton.setColorPalette(colorArray);
    }

    public Color[][] getColorPalette() {
        return this.m_TitleFontButton.getColorPalette();
    }

    public void cleanUp() {
    }

    private void init() {
        this.title = (Title)this.m_dataview.getDataviewTitle();
        this.subtitle = (Subtitle)this.m_dataview.getDataviewSubtitle();
        this.footnote = (Footnote)this.m_dataview.getDataviewFootnote();
        if (this.title != null) {
            this.m_showTitle = this.title.isVisible();
        }
        if (this.subtitle != null) {
            this.m_showSubtitle = this.subtitle.isVisible();
        }
        if (this.footnote != null) {
            this.m_showFootnote = this.footnote.isVisible();
        }
        this.m_token = this.m_dataview.getTokenSubstitution();
        if (this.m_token != null) {
            this.tokenArray = this.m_token.getListItems();
            int n = 0;
            while (n < this.tokenArray.length) {
                this.tokenArray[n] = this.m_token.getToken(this.tokenArray[n]);
                ++n;
            }
        }
        this.initTitle();
        this.initSubtitle();
        this.initFootnote();
    }

    private void initFromDataview() {
        this.title = (Title)this.m_dataview.getDataviewTitle();
        this.subtitle = (Subtitle)this.m_dataview.getDataviewSubtitle();
        this.footnote = (Footnote)this.m_dataview.getDataviewFootnote();
        this.m_showTitle = this.title.isVisible();
        this.m_showSubtitle = this.subtitle.isVisible();
        this.m_showFootnote = this.footnote.isVisible();
        this.m_token = this.m_dataview.getTokenSubstitution();
        this.m_TitleFont = this.title.getFont();
        this.m_SubtitleFont = this.subtitle.getFont();
        this.m_FootnoteFont = this.footnote.getFont();
        this.m_InsertTitle.removeActionListener(this);
        this.m_InsertSubtitle.removeActionListener(this);
        this.m_InsertFootnote.removeActionListener(this);
        this.m_InsertTitle.setModel(new DefaultComboBoxModel<String>(this.m_token.getListItems()));
        this.m_shTitleCBox.setSelected(this.m_showTitle);
        this.m_TitleTxt.setText(this.m_token.getTokenString(this.title.getUnParseText()));
        this.m_TitleTxt.setFont(new Font(this.m_TitleFont.getName(), this.m_TitleFont.getStyle(), this.m_TitleTxt.getFont().getSize()));
        this.m_TitleTxt.setHAlignment(this.title.getHorizontalAlignment());
        this.m_TitleTxt.setForeground(this.title.getForeground());
        this.m_TitleTxt.setBackground(this.title.getBackground());
        this.m_TitleTxt.setUnderline(this.title.isUnderline());
        if (this.m_TitleTxt.getText() != null) {
            this.m_TitleTxt.setCaretPosition(this.m_TitleTxt.getText().length());
        }
        this.m_TitleFontButton.setComponentFont(this.m_TitleFont);
        this.m_TitleFontButton.setUnderlineStyle(this.title.isUnderline());
        this.m_TitleFontButton.setPaneHorizontalAlignment(this.title.getHorizontalAlignment());
        this.m_TitleFontButton.setComponentForeground(this.title.getForeground());
        this.m_TitleFontButton.setComponentBackground(this.title.getBackground());
        this.m_titleFontChange = false;
        this.m_titleFontAlignmentChange = false;
        this.m_titleFontColorChange = false;
        this.m_titleBackgroundChange = false;
        this.m_titleStrikeThroughChange = false;
        this.m_titleUnderlineChange = false;
        this.m_InsertSubtitle.setModel(new DefaultComboBoxModel<String>(this.m_token.getListItems()));
        this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
        this.m_SubtitleTxt.setText(this.m_token.getTokenString(this.subtitle.getUnParseText()));
        this.m_SubtitleTxt.setFont(new Font(this.m_SubtitleFont.getName(), this.m_SubtitleFont.getStyle(), this.m_SubtitleTxt.getFont().getSize()));
        this.m_SubtitleTxt.setHAlignment(this.subtitle.getHorizontalAlignment());
        this.m_SubtitleTxt.setForeground(this.subtitle.getForeground());
        this.m_SubtitleTxt.setBackground(this.subtitle.getBackground());
        this.m_SubtitleTxt.setUnderline(this.subtitle.isUnderline());
        if (this.m_SubtitleTxt.getText() != null) {
            this.m_SubtitleTxt.setCaretPosition(this.m_SubtitleTxt.getText().length());
        }
        this.m_SubtitleFontButton.setComponentFont(this.m_SubtitleFont);
        this.m_SubtitleFontButton.setUnderlineStyle(this.subtitle.isUnderline());
        this.m_SubtitleFontButton.setPaneHorizontalAlignment(this.m_SubtitleTxt.getHAlignment());
        this.m_SubtitleFontButton.setComponentForeground(this.subtitle.getForeground());
        this.m_SubtitleFontButton.setComponentBackground(this.subtitle.getBackground());
        this.m_subtitleFontChange = false;
        this.m_subtitleFontAlignmentChange = false;
        this.m_subtitleFontColorChange = false;
        this.m_subtitleBackgroundChange = false;
        this.m_subtitleStrikeThroughChange = false;
        this.m_subtitleUnderlineChange = false;
        this.m_InsertFootnote.setModel(new DefaultComboBoxModel<String>(this.m_token.getListItems()));
        this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
        this.m_FootnoteTxt.setText(this.m_token.getTokenString(this.footnote.getUnParseText()));
        this.m_FootnoteTxt.setFont(new Font(this.m_FootnoteFont.getName(), this.m_FootnoteFont.getStyle(), this.m_FootnoteTxt.getFont().getSize()));
        this.m_FootnoteTxt.setHAlignment(this.footnote.getHorizontalAlignment());
        this.m_FootnoteTxt.setForeground(this.footnote.getForeground());
        this.m_FootnoteTxt.setBackground(this.footnote.getBackground());
        this.m_FootnoteTxt.setUnderline(this.footnote.isUnderline());
        if (this.m_FootnoteTxt.getText() != null) {
            this.m_FootnoteTxt.setCaretPosition(this.m_FootnoteTxt.getText().length());
        }
        this.m_FootnoteFontButton.setComponentFont(this.m_FootnoteFont);
        this.m_FootnoteFontButton.setUnderlineStyle(this.footnote.isUnderline());
        this.m_FootnoteFontButton.setPaneHorizontalAlignment(this.m_FootnoteTxt.getHAlignment());
        this.m_FootnoteFontButton.setComponentForeground(this.footnote.getForeground());
        this.m_FootnoteFontButton.setComponentBackground(this.footnote.getBackground());
        this.m_footnoteFontChange = false;
        this.m_footnoteFontAlignmentChange = false;
        this.m_footnoteFontColorChange = false;
        this.m_footnoteBackgroundChange = false;
        this.m_footnoteStrikeThroughChange = false;
        this.m_footnoteUnderlineChange = false;
        this.m_InsertTitle.addActionListener(this);
        this.m_InsertSubtitle.addActionListener(this);
        this.m_InsertFootnote.addActionListener(this);
    }

    private void constructPanel() {
        int n = 7;
        int n2 = 30;
        String string = this.m_dataview.getViewType() == 2 ? this.rBundle.getString("table titles text") : (this.m_dataview.getViewType() == 0 ? this.rBundle.getString("crosstab titles text") : this.rBundle.getString("graph titles text"));
        this.setTitleText(string);
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        String string2 = this.rBundle.getString("Show Title");
        this.m_shTitleCBox = new JCheckBox(StringUtils.stripMnemonic((String)string2));
        this.m_shTitleCBox.setAlignmentY(1.0f);
        this.m_shTitleCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        this.m_shTitleCBox.setSelected(this.m_showTitle);
        this.titlePanel.add(this.m_shTitleCBox);
        this.subPanel1 = new JPanel();
        this.subPanel1.setLayout(new BoxLayout(this.subPanel1, 0));
        this.subPanel1.setAlignmentY(1.0f);
        this.m_InsertTitle = new InsertButton(this.m_token.getListItems());
        this.m_InsertTitle.setAlignmentY(1.0f);
        this.m_InsertTitle.setLocale(this.m_locale);
        this.m_InsertTitle.setType(0);
        string2 = this.rBundle.getString("Title Font");
        this.m_TitleFontButton = new FontButton(StringUtils.stripMnemonic((String)string2));
        this.m_TitleFontButton.setCustomColorsEnabled(this.m_dataview.isCustomColorsEnabled());
        this.m_TitleFontButton.setAlignmentY(1.0f);
        this.m_TitleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        string2 = this.rBundle.getString("Title Font For FontButton");
        this.m_TitleFontButton.setDialogTitle(string2);
        this.m_TitleFontButton.setPaneLocale(this.m_dataview.getLocale());
        this.m_TitleFontButton.setComponentFont(this.m_TitleFont);
        this.m_TitleFontButton.setUnderlineStyle(this.title.isUnderline());
        this.m_TitleTxt.setUnderline(this.title.isUnderline());
        int n3 = this.m_TitleTxt.getHAlignment();
        this.m_TitleFontButton.setPaneHorizontalAlignment(n3);
        this.m_TitleFontButton.setStyleButtonMask(n);
        this.m_TitleFontButton.setAlignmentButtonMask(n2);
        this.m_TitleFontButton.setColorComponentMask(3);
        this.m_TitleFontButton.setComponentForeground(this.title.getForeground());
        this.m_TitleFontButton.setComponentBackground(this.title.getBackground());
        this.subPanel1.add((Component)((Object)this.m_InsertTitle));
        this.subPanel1.add(Box.createHorizontalStrut(10));
        this.subPanel1.add(this.m_TitleFontButton);
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        jPanel.setAlignmentY(1.0f);
        jPanel.add(this.subPanel1);
        this.titlePanel.add(jPanel);
        this.subtitlePanel = new JPanel();
        this.subtitlePanel.setLayout(new BoxLayout(this.subtitlePanel, 0));
        string2 = this.rBundle.getString("Show Subtitle");
        this.m_shSubtitleCBox = new JCheckBox(StringUtils.stripMnemonic((String)string2));
        this.m_shSubtitleCBox.setAlignmentY(1.0f);
        this.m_shSubtitleCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
        this.subtitlePanel.add(this.m_shSubtitleCBox);
        this.subPanel2 = new JPanel();
        this.subPanel2.setLayout(new BoxLayout(this.subPanel2, 0));
        this.subPanel2.setAlignmentY(1.0f);
        this.m_InsertSubtitle = new InsertButton(this.m_token.getListItems());
        this.m_InsertSubtitle.setAlignmentY(1.0f);
        this.m_InsertSubtitle.setLocale(this.m_locale);
        this.m_InsertSubtitle.setType(1);
        string2 = this.rBundle.getString("Subtitle Font");
        this.m_SubtitleFontButton = new FontButton(StringUtils.stripMnemonic((String)string2));
        this.m_SubtitleFontButton.setCustomColorsEnabled(this.m_dataview.isCustomColorsEnabled());
        this.m_SubtitleFontButton.setAlignmentY(1.0f);
        this.m_SubtitleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        string2 = this.rBundle.getString("Subtitle Font For FontButton");
        this.m_SubtitleFontButton.setDialogTitle(string2);
        this.m_SubtitleFontButton.setPaneLocale(this.m_dataview.getLocale());
        this.m_SubtitleFontButton.setComponentFont(this.m_SubtitleFont);
        this.m_SubtitleFontButton.setUnderlineStyle(this.subtitle.isUnderline());
        this.m_SubtitleTxt.setUnderline(this.subtitle.isUnderline());
        n3 = this.m_SubtitleTxt.getHAlignment();
        this.m_SubtitleFontButton.setPaneHorizontalAlignment(n3);
        this.m_SubtitleFontButton.setStyleButtonMask(n);
        this.m_SubtitleFontButton.setAlignmentButtonMask(n2);
        this.m_SubtitleFontButton.setColorComponentMask(3);
        this.m_SubtitleFontButton.setComponentForeground(this.subtitle.getForeground());
        this.m_SubtitleFontButton.setComponentBackground(this.subtitle.getBackground());
        this.subPanel2.add((Component)((Object)this.m_InsertSubtitle));
        this.subPanel2.add(Box.createHorizontalStrut(10));
        this.subPanel2.add(this.m_SubtitleFontButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.setAlignmentY(1.0f);
        jPanel2.add(this.subPanel2);
        this.subtitlePanel.add(jPanel2);
        this.footnotePanel = new JPanel();
        this.footnotePanel.setLayout(new BoxLayout(this.footnotePanel, 0));
        string2 = this.rBundle.getString("Show Footnote");
        this.m_shFootnoteCBox = new JCheckBox(StringUtils.stripMnemonic((String)string2));
        this.m_shFootnoteCBox.setAlignmentY(1.0f);
        this.m_shFootnoteCBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
        this.footnotePanel.add(this.m_shFootnoteCBox);
        this.subPanel3 = new JPanel();
        this.subPanel3.setLayout(new BoxLayout(this.subPanel3, 0));
        this.subPanel3.setAlignmentY(1.0f);
        this.m_InsertFootnote = new InsertButton(this.m_token.getListItems());
        this.m_InsertFootnote.setAlignmentY(1.0f);
        this.m_InsertFootnote.setLocale(this.m_locale);
        this.m_InsertFootnote.setType(2);
        string2 = this.rBundle.getString("Footnote Font");
        this.m_FootnoteFontButton = new FontButton(StringUtils.stripMnemonic((String)string2));
        this.m_FootnoteFontButton.setCustomColorsEnabled(this.m_dataview.isCustomColorsEnabled());
        this.m_FootnoteFontButton.setAlignmentY(1.0f);
        this.m_FootnoteFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        string2 = this.rBundle.getString("Footnote Font For FontButton");
        this.m_FootnoteFontButton.setDialogTitle(string2);
        this.m_FootnoteFontButton.setPaneLocale(this.m_dataview.getLocale());
        this.m_FootnoteFontButton.setComponentFont(this.m_FootnoteFont);
        this.m_FootnoteFontButton.setUnderlineStyle(this.footnote.isUnderline());
        this.m_FootnoteTxt.setUnderline(this.footnote.isUnderline());
        n3 = this.m_FootnoteTxt.getHAlignment();
        this.m_FootnoteFontButton.setPaneHorizontalAlignment(n3);
        this.m_FootnoteFontButton.setStyleButtonMask(n);
        this.m_FootnoteFontButton.setAlignmentButtonMask(n2);
        this.m_FootnoteFontButton.setColorComponentMask(3);
        this.m_FootnoteFontButton.setComponentForeground(this.footnote.getForeground());
        this.m_FootnoteFontButton.setComponentBackground(this.footnote.getBackground());
        this.subPanel3.add((Component)((Object)this.m_InsertFootnote));
        this.subPanel3.add(Box.createHorizontalStrut(10));
        this.subPanel3.add(this.m_FootnoteFontButton);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.setAlignmentY(1.0f);
        jPanel3.add(this.subPanel3);
        this.footnotePanel.add(jPanel3);
        this.m_mainPanel.add(this.titlePanel);
        this.m_mainPanel.add(Box.createVerticalStrut(5));
        this.m_mainPanel.add(this.m_TitleTxt);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.subtitlePanel);
        this.m_mainPanel.add(Box.createVerticalStrut(5));
        this.m_mainPanel.add(this.m_SubtitleTxt);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.footnotePanel);
        this.m_mainPanel.add(Box.createVerticalStrut(5));
        this.m_mainPanel.add(this.m_FootnoteTxt);
        this.calculatePanelSizes();
        this.calculatePreferredSize();
        this.m_shTitleCBox.addItemListener(this);
        this.m_shSubtitleCBox.addItemListener(this);
        this.m_shFootnoteCBox.addItemListener(this);
        this.m_InsertTitle.addActionListener(this);
        this.m_InsertSubtitle.addActionListener(this);
        this.m_InsertFootnote.addActionListener(this);
        this.m_TitleFontButton.addPropertyChangeListener(this);
        this.m_SubtitleFontButton.addPropertyChangeListener(this);
        this.m_FootnoteFontButton.addPropertyChangeListener(this);
    }

    private void calculatePanelSizes() {
        int n = this.m_TitleFontButton.getPreferredSize().width;
        int n2 = this.m_SubtitleFontButton.getPreferredSize().width;
        int n3 = this.m_FootnoteFontButton.getPreferredSize().width;
        int n4 = n;
        if (n2 > n4) {
            n4 = n2;
        }
        if (n3 > n4) {
            n4 = n3;
        }
        this.m_TitleFontButton.setPreferredSize(new Dimension(n4, this.m_TitleFontButton.getPreferredSize().height));
        this.m_TitleFontButton.setMinimumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_TitleFontButton.setMaximumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_SubtitleFontButton.setPreferredSize(this.m_TitleFontButton.getPreferredSize());
        this.m_SubtitleFontButton.setMinimumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_SubtitleFontButton.setMaximumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_FootnoteFontButton.setPreferredSize(this.m_TitleFontButton.getPreferredSize());
        this.m_FootnoteFontButton.setMinimumSize(this.m_TitleFontButton.getPreferredSize());
        this.m_FootnoteFontButton.setMaximumSize(this.m_TitleFontButton.getPreferredSize());
        int n5 = this.m_shTitleCBox.getPreferredSize().width + this.subPanel1.getPreferredSize().width;
        int n6 = Math.max(this.subPanel1.getPreferredSize().height, this.m_shTitleCBox.getPreferredSize().height);
        this.titlePanel.setPreferredSize(new Dimension(n5, n6));
        this.titlePanel.setMinimumSize(this.titlePanel.getPreferredSize());
        this.titlePanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, n6));
        n5 = this.m_shSubtitleCBox.getPreferredSize().width + this.subPanel2.getPreferredSize().width;
        n6 = Math.max(this.subPanel2.getPreferredSize().height, this.m_shSubtitleCBox.getPreferredSize().height);
        this.subtitlePanel.setPreferredSize(new Dimension(n5, n6));
        this.subtitlePanel.setMinimumSize(this.subtitlePanel.getPreferredSize());
        this.subtitlePanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, n6));
        n5 = this.m_shFootnoteCBox.getPreferredSize().width + this.subPanel3.getPreferredSize().width;
        n6 = Math.max(this.subPanel3.getPreferredSize().height, this.m_shFootnoteCBox.getPreferredSize().height);
        this.footnotePanel.setPreferredSize(new Dimension(n5, n6));
        this.footnotePanel.setMinimumSize(this.footnotePanel.getPreferredSize());
        this.footnotePanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, n6));
    }

    private void calculatePreferredSize() {
        int n = 0;
        int n2 = this.titlePanel.getPreferredSize().width;
        if (n < n2) {
            n = n2;
        }
        if (n < (n2 = this.m_TitleTxt.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.subtitlePanel.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.m_SubtitleTxt.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.footnotePanel.getPreferredSize().width)) {
            n = n2;
        }
        if (n < (n2 = this.m_FootnoteTxt.getPreferredSize().width)) {
            n = n2;
        }
        n2 = n + 10 + 10;
        int n3 = this.m_mainPanel.getPreferredSize().height + this.m_label.getPreferredSize().height + 10 + 10 + 15;
        this.prefSize = new Dimension(n2, n3);
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void initTitle() {
        LimitedTextDocument limitedTextDocument = new LimitedTextDocument(1024, this.tokenArray);
        String string = this.m_token.getTokenString(this.title.getUnParseText());
        this.m_TitleTxt = new MyViewTextField(limitedTextDocument, string, 0);
        this.m_TitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Title TextField"));
        this.m_TitleTxt.setPreferredSize(new Dimension(400, 25));
        this.m_TitleTxt.setMinimumSize(this.m_TitleTxt.getPreferredSize());
        this.m_TitleTxt.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_TitleTxt.getPreferredSize().height));
        this.m_TitleFont = this.title.getFont();
        this.m_TitleTxt.setFont(new Font(this.m_TitleFont.getName(), this.m_TitleFont.getStyle(), this.m_TitleTxt.getFont().getSize()));
        this.m_TitleTxt.setHAlignment(this.title.getHorizontalAlignment());
        this.m_TitleTxt.setForeground(this.title.getForeground());
        this.m_TitleTxt.setBackground(this.title.getBackground());
        this.m_TitleTxt.addCaretListener(this);
        this.m_titleFontChange = false;
        this.m_titleFontAlignmentChange = false;
        this.m_titleFontColorChange = false;
        this.m_titleBackgroundChange = false;
        this.m_titleStrikeThroughChange = false;
        this.m_titleUnderlineChange = false;
    }

    public void initSubtitle() {
        LimitedTextDocument limitedTextDocument = new LimitedTextDocument(1024, this.tokenArray);
        String string = this.m_token.getTokenString(this.subtitle.getUnParseText());
        this.m_SubtitleTxt = new MyViewTextField(limitedTextDocument, string, 0);
        this.m_SubtitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Subtitle TextField"));
        this.m_SubtitleTxt.setPreferredSize(new Dimension(400, 25));
        this.m_SubtitleTxt.setMinimumSize(this.m_SubtitleTxt.getPreferredSize());
        this.m_SubtitleTxt.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_SubtitleTxt.getPreferredSize().height));
        this.m_SubtitleFont = this.subtitle.getFont();
        this.m_SubtitleTxt.setFont(new Font(this.m_SubtitleFont.getName(), this.m_SubtitleFont.getStyle(), this.m_SubtitleTxt.getFont().getSize()));
        this.m_SubtitleTxt.setHAlignment(this.subtitle.getHorizontalAlignment());
        this.m_SubtitleTxt.setForeground(this.subtitle.getForeground());
        this.m_SubtitleTxt.setBackground(this.subtitle.getBackground());
        this.m_SubtitleTxt.addCaretListener(this);
        this.m_subtitleFontChange = false;
        this.m_subtitleFontAlignmentChange = false;
        this.m_subtitleFontColorChange = false;
        this.m_subtitleBackgroundChange = false;
        this.m_subtitleStrikeThroughChange = false;
        this.m_subtitleUnderlineChange = false;
    }

    public void initFootnote() {
        LimitedTextDocument limitedTextDocument = new LimitedTextDocument(1024, this.tokenArray);
        String string = this.m_token.getTokenString(this.footnote.getUnParseText());
        this.m_FootnoteTxt = new MyViewTextField(limitedTextDocument, string, 0);
        this.m_FootnoteTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Footnote TextField"));
        this.m_FootnoteTxt.setPreferredSize(new Dimension(400, 25));
        this.m_FootnoteTxt.setMinimumSize(this.m_FootnoteTxt.getPreferredSize());
        this.m_FootnoteTxt.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_FootnoteTxt.getPreferredSize().height));
        this.m_FootnoteFont = this.footnote.getFont();
        this.m_FootnoteTxt.setFont(new Font(this.m_FootnoteFont.getName(), this.m_FootnoteFont.getStyle(), this.m_FootnoteTxt.getFont().getSize()));
        this.m_FootnoteTxt.setHAlignment(this.footnote.getHorizontalAlignment());
        this.m_FootnoteTxt.setForeground(this.footnote.getForeground());
        this.m_FootnoteTxt.setBackground(this.footnote.getBackground());
        this.m_FootnoteTxt.addCaretListener(this);
        this.m_footnoteFontChange = false;
        this.m_footnoteFontAlignmentChange = false;
        this.m_footnoteFontColorChange = false;
        this.m_footnoteBackgroundChange = false;
        this.m_footnoteStrikeThroughChange = false;
        this.m_footnoteUnderlineChange = false;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.m_TitleTxt) {
            String string = this.m_TitleTxt.getText();
            if (string.length() > 0) {
                this.m_oldTitle = string;
                if (!this.m_showTitle) {
                    this.m_showTitle = true;
                    this.m_shTitleCBox.setSelected(this.m_showTitle);
                    this.firePropertyChange(PROPERTY_TITLE_TEXT, this.m_oldTitle, string);
                }
            } else {
                this.m_showTitle = false;
                this.m_shTitleCBox.setSelected(this.m_showTitle);
                this.firePropertyChange(PROPERTY_TITLE_TEXT, this.m_oldTitle, string);
            }
        } else if (caretEvent.getSource() == this.m_SubtitleTxt) {
            String string = this.m_SubtitleTxt.getText();
            if (string.length() > 0) {
                this.m_oldSubtitle = string;
                if (!this.m_showSubtitle) {
                    this.m_showSubtitle = true;
                    this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
                    this.firePropertyChange(PROPERTY_SUBTITLE_TEXT, this.m_oldSubtitle, string);
                }
            } else {
                this.m_showSubtitle = false;
                this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
                this.firePropertyChange(PROPERTY_SUBTITLE_TEXT, this.m_oldSubtitle, string);
            }
        } else if (caretEvent.getSource() == this.m_FootnoteTxt) {
            String string = this.m_FootnoteTxt.getText();
            if (string.length() > 0) {
                this.m_oldFootnote = string;
                if (!this.m_showFootnote) {
                    this.m_showFootnote = true;
                    this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
                    this.firePropertyChange(PROPERTY_FOOTNOTE_TEXT, this.m_oldFootnote, string);
                }
            } else {
                this.m_showFootnote = false;
                this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
                this.firePropertyChange(PROPERTY_FOOTNOTE_TEXT, this.m_oldFootnote, string);
            }
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.m_locale = locale;
        this.updateResourceBundle(locale);
        if (this.m_InsertTitle != null) {
            this.m_InsertTitle.setLocale(this.m_locale);
        }
        if (this.m_InsertSubtitle != null) {
            this.m_InsertSubtitle.setLocale(this.m_locale);
        }
        if (this.m_InsertFootnote != null) {
            this.m_InsertFootnote.setLocale(this.m_locale);
        }
        if (this.m_TitleFontButton != null) {
            this.m_TitleFontButton.setPaneLocale(locale);
        }
        if (this.m_SubtitleFontButton != null) {
            this.m_SubtitleFontButton.setPaneLocale(locale);
        }
        if (this.m_FootnoteFontButton != null) {
            this.m_FootnoteFontButton.setPaneLocale(locale);
        }
        if (this.m_TitleTxt != null) {
            this.m_TitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Title TextField"));
        }
        if (this.m_SubtitleTxt != null) {
            this.m_SubtitleTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Subtitle TextField"));
        }
        if (this.m_FootnoteTxt != null) {
            this.m_FootnoteTxt.getAccessibleContext().setAccessibleName(this.rBundle.getString("Footnote TextField"));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Comparable<Boolean> comparable;
        boolean bl;
        int n = 0;
        if (propertyChangeEvent.getSource() == this.m_TitleFontButton) {
            this.m_TextArea = this.m_TitleTxt;
            this.m_Font = this.m_TitleFont;
            n = 0;
        } else if (propertyChangeEvent.getSource() == this.m_SubtitleFontButton) {
            this.m_TextArea = this.m_SubtitleTxt;
            this.m_Font = this.m_SubtitleFont;
            n = 1;
        } else if (propertyChangeEvent.getSource() == this.m_FootnoteFontButton) {
            this.m_TextArea = this.m_FootnoteTxt;
            this.m_Font = this.m_FootnoteFont;
            n = 2;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == "fontDialogCancelled" && !(bl = ((Boolean)(comparable = (Boolean)propertyChangeEvent.getNewValue())).booleanValue())) {
            if (this.m_bFontNameChange) {
                this.firePropertyChange("fontName", this.m_oldFontName, this.m_newFontName);
                this.m_Font = new Font(this.m_newFontName, this.m_Font.getStyle(), this.m_Font.getSize());
                this.m_TextArea.setFont(new Font(this.m_newFontName, this.m_Font.getStyle(), this.m_TextArea.getFont().getSize()));
                this.m_bFontNameChange = false;
                if (n == 0) {
                    this.m_titleFontChange = true;
                } else if (n == 1) {
                    this.m_subtitleFontChange = true;
                } else {
                    this.m_footnoteFontChange = true;
                }
            }
            if (this.m_bFontStyleChange) {
                this.firePropertyChange("fontStyle", this.m_oldFontStyle, this.m_newFontStyle);
                boolean bl2 = this.m_TextArea.isStrikeThrough();
                if ((this.m_newFontStyle & 8) != 0) {
                    this.m_TextArea.setStrikeThrough(true);
                } else {
                    this.m_TextArea.setStrikeThrough(false);
                }
                if (bl2 != this.m_TextArea.isStrikeThrough()) {
                    if (n == 0) {
                        this.m_titleStrikeThroughChange = true;
                    } else if (n == 1) {
                        this.m_subtitleStrikeThroughChange = true;
                    } else {
                        this.m_footnoteStrikeThroughChange = true;
                    }
                }
                bl2 = this.m_TextArea.isUnderline();
                if ((this.m_newFontStyle & 4) != 0) {
                    this.m_TextArea.setUnderline(true);
                } else {
                    this.m_TextArea.setUnderline(false);
                }
                if (bl2 != this.m_TextArea.isUnderline()) {
                    if (n == 0) {
                        this.m_titleUnderlineChange = true;
                    } else if (n == 1) {
                        this.m_subtitleUnderlineChange = true;
                    } else {
                        this.m_footnoteUnderlineChange = true;
                    }
                }
                boolean bl3 = false;
                boolean bl4 = false;
                if ((this.m_newFontStyle & 1) != 0) {
                    bl3 = true;
                }
                if ((this.m_newFontStyle & 2) != 0) {
                    bl4 = true;
                }
                this.m_newFontStyle = DataviewUtils.fontStyle(bl3, bl4);
                this.m_Font = new Font(this.m_Font.getName(), this.m_newFontStyle, this.m_Font.getSize());
                this.m_TextArea.setFont(new Font(this.m_Font.getName(), this.m_newFontStyle, this.m_TextArea.getFont().getSize()));
                this.m_bFontStyleChange = false;
                if (n == 0) {
                    this.m_titleFontChange = true;
                } else if (n == 1) {
                    this.m_subtitleFontChange = true;
                } else {
                    this.m_footnoteFontChange = true;
                }
            }
            if (this.m_bFontSizeChange) {
                this.firePropertyChange("fontSize", this.m_oldFontSize, this.m_newFontSize);
                this.m_Font = new Font(this.m_Font.getName(), this.m_Font.getStyle(), this.m_newFontSize);
                this.m_TextArea.setFont(new Font(this.m_Font.getName(), this.m_Font.getStyle(), this.m_TextArea.getFont().getSize()));
                this.m_bFontSizeChange = false;
                if (n == 0) {
                    this.m_titleFontChange = true;
                } else if (n == 1) {
                    this.m_subtitleFontChange = true;
                } else {
                    this.m_footnoteFontChange = true;
                }
            }
            if (this.m_bHorizontalAlignmentChange) {
                this.firePropertyChange("fontHorizontalAlignment", this.m_oldHAlignment, this.m_newHAlignment);
                this.m_TextArea.setHAlignment(this.m_newHAlignment);
                this.m_bHorizontalAlignmentChange = false;
                if (n == 0) {
                    this.m_titleFontAlignmentChange = true;
                } else if (n == 1) {
                    this.m_subtitleFontAlignmentChange = true;
                } else {
                    this.m_footnoteFontAlignmentChange = true;
                }
            }
            if (this.m_bFontColorChange) {
                this.firePropertyChange("fontColor", this.m_oldFontColor, this.m_newFontColor);
                this.m_TextArea.setForeground(this.m_newFontColor);
                this.m_bFontColorChange = false;
                if (n == 0) {
                    this.m_titleFontColorChange = true;
                } else if (n == 1) {
                    this.m_subtitleFontColorChange = true;
                } else {
                    this.m_footnoteFontColorChange = true;
                }
            }
            if (this.m_bFontBackgroundColorChange) {
                this.firePropertyChange("background", this.m_oldFontBackgroundColor, this.m_newFontBackgroundColor);
                this.m_TextArea.setBackground(this.m_newFontBackgroundColor);
                this.m_bFontBackgroundColorChange = false;
                if (n == 0) {
                    this.m_titleBackgroundChange = true;
                } else if (n == 1) {
                    this.m_subtitleBackgroundChange = true;
                } else {
                    this.m_footnoteBackgroundChange = true;
                }
            }
            this.m_TextArea.repaint();
        }
        if (string == "fontHorizontalAlignment") {
            comparable = (Integer)propertyChangeEvent.getOldValue();
            Integer n2 = (Integer)propertyChangeEvent.getNewValue();
            this.m_oldHAlignment = (Integer)comparable;
            this.m_newHAlignment = n2;
            if (this.m_oldHAlignment != this.m_newHAlignment) {
                this.m_bHorizontalAlignmentChange = true;
            }
        }
        if (string == "fontColor") {
            this.m_oldFontColor = (Color)propertyChangeEvent.getOldValue();
            this.m_newFontColor = (Color)propertyChangeEvent.getNewValue();
            if (this.m_oldFontColor != this.m_newFontColor) {
                this.m_bFontColorChange = true;
            }
        }
        if (string == "fontBackgroundColor") {
            this.m_oldFontBackgroundColor = (Color)propertyChangeEvent.getOldValue();
            this.m_newFontBackgroundColor = (Color)propertyChangeEvent.getNewValue();
            if (this.m_oldFontBackgroundColor != this.m_newFontBackgroundColor) {
                this.m_bFontBackgroundColorChange = true;
            }
        }
        if (string == "fontName") {
            this.m_oldFontName = (String)propertyChangeEvent.getOldValue();
            this.m_newFontName = (String)propertyChangeEvent.getNewValue();
            if (this.m_oldFontName != this.m_newFontName) {
                this.m_bFontNameChange = true;
            }
        }
        if (string == "fontStyle") {
            comparable = (Integer)propertyChangeEvent.getOldValue();
            this.m_oldFontStyle = (Integer)comparable;
            Integer n3 = (Integer)propertyChangeEvent.getNewValue();
            this.m_newFontStyle = n3;
            if (this.m_oldFontStyle != this.m_newFontStyle) {
                this.m_bFontStyleChange = true;
            }
        }
        if (string == "fontSize") {
            comparable = (Integer)propertyChangeEvent.getOldValue();
            this.m_oldFontSize = (Integer)comparable;
            Integer n4 = (Integer)propertyChangeEvent.getNewValue();
            this.m_newFontSize = n4;
            if (this.m_oldFontSize != this.m_newFontSize) {
                this.m_bFontSizeChange = true;
            }
        }
        if (propertyChangeEvent.getSource() == this.m_TitleFontButton) {
            this.m_TitleFont = this.m_Font;
            if (this.m_titleFontChange) {
                this.firePropertyChange(DEFAULT_FORMAT_CHANGED, 0, 1);
            }
        } else if (propertyChangeEvent.getSource() == this.m_SubtitleFontButton) {
            this.m_SubtitleFont = this.m_Font;
            if (this.m_subtitleFontChange) {
                this.firePropertyChange(DEFAULT_FORMAT_CHANGED, 0, 1);
            }
        } else if (propertyChangeEvent.getSource() == this.m_FootnoteFontButton) {
            this.m_FootnoteFont = this.m_Font;
            if (this.m_footnoteFontChange) {
                this.firePropertyChange(DEFAULT_FORMAT_CHANGED, 0, 1);
            }
        }
    }

    public boolean apply() {
        boolean bl = false;
        String string = this.m_TitleTxt.getText();
        this.title.setText(this.m_token.getKeyString(string));
        this.title.setVisible(this.m_showTitle);
        if (this.m_titleFontChange) {
            this.title.setFont(this.m_TitleFont);
            this.m_titleFontChange = false;
        }
        if (this.m_titleUnderlineChange) {
            this.title.setUnderline(this.m_TitleTxt.isUnderline());
            this.m_titleUnderlineChange = false;
        }
        if (this.m_titleFontAlignmentChange) {
            this.title.setHorizontalAlignment(this.m_TitleTxt.getHAlignment());
            this.m_titleFontAlignmentChange = false;
        }
        if (this.m_titleFontColorChange) {
            this.title.setForeground(this.m_TitleTxt.getForeground());
            this.m_titleFontColorChange = false;
        }
        if (this.m_titleBackgroundChange) {
            this.title.setBackground(this.m_TitleTxt.getBackground());
            this.m_titleBackgroundChange = false;
        }
        this.subtitle.setText(this.m_token.getKeyString(this.m_SubtitleTxt.getText()));
        this.subtitle.setVisible(this.m_showSubtitle);
        if (this.m_subtitleFontChange) {
            this.subtitle.setFont(this.m_SubtitleFont);
            this.m_subtitleFontChange = false;
        }
        if (this.m_subtitleUnderlineChange) {
            this.subtitle.setUnderline(this.m_SubtitleTxt.isUnderline());
            this.m_subtitleUnderlineChange = false;
        }
        if (this.m_subtitleFontAlignmentChange) {
            this.subtitle.setHorizontalAlignment(this.m_SubtitleTxt.getHAlignment());
            this.m_subtitleFontAlignmentChange = false;
        }
        if (this.m_subtitleFontColorChange) {
            this.subtitle.setForeground(this.m_SubtitleTxt.getForeground());
            this.m_subtitleFontColorChange = false;
        }
        if (this.m_subtitleBackgroundChange) {
            this.subtitle.setBackground(this.m_SubtitleTxt.getBackground());
            this.m_subtitleBackgroundChange = false;
        }
        this.footnote.setText(this.m_token.getKeyString(this.m_FootnoteTxt.getText()));
        this.footnote.setVisible(this.m_showFootnote);
        if (this.m_footnoteFontChange) {
            this.footnote.setFont(this.m_FootnoteFont);
            this.m_footnoteFontChange = false;
        }
        if (this.m_footnoteUnderlineChange) {
            this.footnote.setUnderline(this.m_FootnoteTxt.isUnderline());
            this.m_footnoteUnderlineChange = false;
        }
        if (this.m_footnoteFontAlignmentChange) {
            this.footnote.setHorizontalAlignment(this.m_FootnoteTxt.getHAlignment());
            this.m_footnoteFontAlignmentChange = false;
        }
        if (this.m_footnoteFontColorChange) {
            this.footnote.setForeground(this.m_FootnoteTxt.getForeground());
            this.m_footnoteFontColorChange = false;
        }
        if (this.m_footnoteBackgroundChange) {
            this.footnote.setBackground(this.m_FootnoteTxt.getBackground());
            this.m_footnoteBackgroundChange = false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_InsertTitle) {
            this.m_TextArea = this.m_TitleTxt;
            this.m_Insert = this.m_InsertTitle;
        } else if (actionEvent.getSource() == this.m_InsertSubtitle) {
            this.m_TextArea = this.m_SubtitleTxt;
            this.m_Insert = this.m_InsertSubtitle;
        } else if (actionEvent.getSource() == this.m_InsertFootnote) {
            this.m_TextArea = this.m_FootnoteTxt;
            this.m_Insert = this.m_InsertFootnote;
        }
        String string = this.m_Insert.getSelectedItem();
        if (string != null) {
            String string2 = this.m_TextArea.getText();
            String string3 = String.valueOf(string2.substring(0, this.m_TextArea.getCaretPosition())) + this.m_token.getToken(string) + string2.substring(this.m_TextArea.getCaretPosition(), string2.length());
            this.firePropertyChange(PROPERTY_TITLE_TEXT, string2, string3);
            if (actionEvent.getSource() == this.m_InsertTitle) {
                this.m_showTitle = true;
                this.m_shTitleCBox.setSelected(this.m_showTitle);
            } else if (actionEvent.getSource() == this.m_InsertSubtitle) {
                this.m_showSubtitle = true;
                this.m_shSubtitleCBox.setSelected(this.m_showSubtitle);
            } else if (actionEvent.getSource() == this.m_InsertFootnote) {
                this.m_showFootnote = true;
                this.m_shFootnoteCBox.setSelected(this.m_showFootnote);
            }
            String string4 = String.valueOf(string2.substring(0, this.m_TextArea.getCaretPosition())) + this.m_token.getToken(string);
            this.m_TextArea.setText(string3);
            this.m_TextArea.requestFocus();
            if (string4.length() > 1024) {
                this.m_TextArea.setCaretPosition(this.m_TextArea.getText().length());
            } else {
                this.m_TextArea.setCaretPosition(string4.length());
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_shTitleCBox) {
            if (itemEvent.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_TITLE_VISIBLE, false, true);
                this.m_showTitle = true;
            } else {
                this.firePropertyChange(PROPERTY_TITLE_VISIBLE, true, false);
                this.m_showTitle = false;
            }
        }
        if (itemEvent.getSource() == this.m_shSubtitleCBox) {
            if (itemEvent.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_SUBTITLE_VISIBLE, false, true);
                this.m_showSubtitle = true;
            } else {
                this.firePropertyChange(PROPERTY_SUBTITLE_VISIBLE, true, false);
                this.m_showSubtitle = false;
            }
        }
        if (itemEvent.getSource() == this.m_shFootnoteCBox) {
            if (itemEvent.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_FOOTNOTE_VISIBLE, false, true);
                this.m_showFootnote = true;
            } else {
                this.firePropertyChange(PROPERTY_FOOTNOTE_VISIBLE, true, false);
                this.m_showFootnote = false;
            }
        }
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getHelpContextID() {
        if (this.m_dataview != null && this.m_dataview.getViewType() == 2) {
            return String.valueOf(this.getClass().getName()) + "_Table";
        }
        if (this.m_dataview != null && this.m_dataview.getViewType() == 0) {
            return String.valueOf(this.getClass().getName()) + "_Crosstab";
        }
        return String.valueOf(this.getClass().getName()) + "_Graph";
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        this.m_TitleFontButton.setHelpProvider(helpProvider);
        this.m_SubtitleFontButton.setHelpProvider(helpProvider);
        this.m_FootnoteFontButton.setHelpProvider(helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setInsertButtonVisible(boolean bl) {
        this.m_InsertTitle.setVisible(bl);
        this.m_InsertSubtitle.setVisible(bl);
        this.m_InsertFootnote.setVisible(bl);
        this.insertButtonVisible = bl;
    }

    public boolean isInsertButtonVisible() {
        return this.insertButtonVisible;
    }

    class MyViewTextField
    extends ViewTextField {
        private int m_alignment = 0;

        public MyViewTextField(String string) {
            super(string);
        }

        public MyViewTextField(Document document, String string, int n) {
            super(document, string, n);
        }

        public void setHAlignment(int n) {
            this.m_alignment = n;
            if (TitlePanel.this.m_locale != null && n == 10) {
                String string = TitlePanel.this.m_locale.getLanguage();
                if (string.equals("ar") || string.equals("he") || string.equals("iw")) {
                    super.setHorizontalAlignment(4);
                } else {
                    super.setHorizontalAlignment(2);
                }
            } else {
                if (n < 2 || n > 4) {
                    n = 0;
                }
                super.setHorizontalAlignment(n);
            }
        }

        public int getHAlignment() {
            return this.m_alignment;
        }
    }
}

