/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Frame;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bali.ewt.help.HelpProvider;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.PageSetupDialog;
import oracle.dss.dataView.gui.PreviewDialog;
import oracle.dss.dataView.gui.PreviewDialogProvider;
import oracle.dss.dataView.gui.PrintDialog;
import oracle.dss.dataView.gui.PrintDialogsProvider;

public class PrintDialogsAdapter
implements PrintDialogsProvider,
PreviewDialogProvider {
    protected HelpProvider m_helpProvider;
    private PrintDialog m_printDialog;
    private PrinterJob m_printerJob;
    private Locale m_locale;
    private PageSetupDialog m_pageSetup;
    private ViewPrinter m_viewPrinter;
    private ResourceBundle dvStrings;

    public PrintDialogsAdapter(ViewPrinter viewPrinter, PrintDialog printDialog, PrinterJob printerJob) {
        this.m_printerJob = printerJob;
        this.m_printDialog = printDialog;
        this.m_viewPrinter = viewPrinter;
        this.setLocale(this.m_viewPrinter.getDataview().getLocale());
    }

    public void showPrintDialog(Frame frame) {
        if (this.m_printDialog != null && this.m_printDialog.isSystemPrintDialogDisplayed() && !this.m_printerJob.printDialog()) {
            return;
        }
        if (this.m_viewPrinter.startPrint(false)) {
            try {
                this.m_printerJob.setPrintable(this.m_viewPrinter, this.m_viewPrinter.getPageFormat());
                this.m_printerJob.print();
            }
            catch (PrinterException printerException) {
                this.m_viewPrinter.getDataview().getErrorHandler().log("java.awt.print.PrinterException", this.getClass().getName(), "showPrintDialog(Frame f)");
            }
        }
        this.m_printDialog.setVisible(false);
    }

    public void showPageSetupDialog(Frame frame) {
        ViewPrinter[] viewPrinterArray = new ViewPrinter[]{this.m_viewPrinter};
        this.m_pageSetup = new PageSetupDialog(frame, this.dvStrings.getString("pgsetup"), true, viewPrinterArray, (PreviewDialogProvider)this);
        if (this.m_pageSetup != null) {
            this.m_pageSetup.setHelpProvider(this.getHelpProvider());
        }
        this.m_pageSetup.setVisible(true);
    }

    public void showPreviewDialog(Frame frame) {
        ViewPrinter[] viewPrinterArray = new ViewPrinter[]{this.m_viewPrinter};
        PreviewDialog previewDialog = new PreviewDialog(frame, this.dvStrings.getString("Print Preview"), viewPrinterArray, (PrintDialogsProvider)this);
        if (previewDialog != null) {
            previewDialog.setHelpProvider(this.getHelpProvider());
        }
        previewDialog.setVisible(true);
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
        this.updateResourceBundle();
    }

    private void updateResourceBundle() {
        try {
            this.dvStrings = this.m_locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", this.m_locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
        }
        catch (MissingResourceException missingResourceException) {
            this.dvStrings = null;
        }
    }
}

