/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.imageCanvas.ImageCanvas;
import oracle.bali.ewt.print.PrinterGraphics2DProxy;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.PrintDialogsProvider;

public class PreviewPanel
extends JPanel
implements ActionListener,
FocusListener {
    public static final int SCALE_IMAGE_DEFAULT = 2;
    public static final int SCALE_IMAGE_SMOOTH = 4;
    private PrintDialogsProvider m_pdp;
    private int paperWidth;
    private int paperHeight;
    private int preferredWidth;
    private int scalingMode = 2;
    private int scaledWidth;
    private int scaledHeight;
    private long pageNum = 1L;
    private JButton previous;
    private JButton next;
    private PushButton first;
    private PushButton last;
    private JComboBox m_zoomBox;
    private Graphics pg;
    private JTextField field;
    private JPanel pagePanel;
    private JPanel toolBar;
    private JScrollPane pane;
    private ImageCanvas canvas;
    private BufferedImage bImage;
    private UIViewPrinter[] printers;
    protected long m_currentLogicalPage;
    protected int m_currentViewPrinter;
    protected boolean[] m_bViewPrinterGoToPrev;
    protected boolean[] m_bViewPrinterGoToNext;
    protected boolean[] m_bDataInFirstPage;
    protected boolean[] m_bDataInPages = new boolean[500];
    ResourceBundle dvStrings;

    public PreviewPanel(ViewPrinter[] viewPrinterArray, PrintDialogsProvider printDialogsProvider) {
        ViewPrinter[] viewPrinterArray2 = viewPrinterArray;
        this.constructPanel(viewPrinterArray, printDialogsProvider);
    }

    public PreviewPanel(UIViewPrinter uIViewPrinter, PrintDialogsProvider printDialogsProvider) {
        UIViewPrinter[] uIViewPrinterArray = new UIViewPrinter[]{uIViewPrinter};
        this.constructPanel(uIViewPrinterArray, printDialogsProvider);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
    }

    public void componentResized() {
        if (this.m_zoomBox.getSelectedIndex() == 1) {
            this.scaleComponents();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.last && !this.last.isEnabled()) {
            this.last.transferFocus();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.previous) {
            Object[] objectArray;
            --this.pageNum;
            if (this.printers[0].getViewPrinterType() <= 2) {
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                if (this.preparePrevPage(this.pg)) {
                    this.printers[this.m_currentViewPrinter].renderPage(this.pg);
                }
            } else {
                this.printers[0].preparePrevPage(this.pg);
                objectArray = this.printers[0].getViewDimension();
                this.paperWidth = objectArray.width;
                this.paperHeight = objectArray.height;
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                this.printers[0].renderPage(this.pg);
            }
            objectArray = new String[]{Long.toString(this.pageNum)};
            this.field.setText(String.valueOf(String.valueOf(" ")) + MessageFormat.format(this.getIntlString("pageNumber"), objectArray) + " ");
            if (this.field.getPreferredSize().width != this.preferredWidth) {
                this.field.setMaximumSize(this.field.getPreferredSize());
                this.toolBar.validate();
                this.toolBar.invalidate();
                this.preferredWidth = this.field.getPreferredSize().width;
            }
            if (this.m_zoomBox.getSelectedIndex() == 1) {
                this.scaleComponents();
            } else {
                this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 30, this.paperHeight + 30));
                this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
                this.canvas.setSize(this.paperWidth, this.paperHeight);
                this.canvas.setImage((Image)this.bImage);
            }
            if (!this.hasPrevPage()) {
                this.previous.setEnabled(false);
                this.first.setEnabled(false);
            }
            this.next.setEnabled(true);
            this.last.setEnabled(true);
        } else if (actionEvent.getSource() == this.next) {
            Object[] objectArray;
            this.previous.setEnabled(true);
            this.first.setEnabled(true);
            ++this.pageNum;
            if (this.printers[0].getViewPrinterType() <= 2) {
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                if ((long)this.m_bDataInPages.length < this.pageNum) {
                    objectArray = new boolean[this.m_bDataInPages.length * 2];
                    int n = 0;
                    while (n < this.m_bDataInPages.length) {
                        objectArray[n] = (String)this.m_bDataInPages[n];
                        ++n;
                    }
                    this.m_bDataInPages = (boolean[])objectArray;
                }
                if (this.prepareNextPage(this.pg)) {
                    this.m_bDataInPages[(int)(this.pageNum - (long)1)] = true;
                    this.printers[this.m_currentViewPrinter].renderPage(this.pg);
                } else {
                    this.m_bDataInPages[(int)(this.pageNum - (long)1)] = false;
                }
            } else {
                this.printers[0].prepareNextPage(this.pg);
                objectArray = this.printers[0].getViewDimension();
                this.paperWidth = objectArray.width;
                this.paperHeight = objectArray.height;
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                this.printers[0].renderPage(this.pg);
            }
            objectArray = new String[]{Long.toString(this.pageNum)};
            this.field.setText(String.valueOf(String.valueOf(" ")) + MessageFormat.format(this.getIntlString("pageNumber"), objectArray) + " ");
            if (this.field.getPreferredSize().width != this.preferredWidth) {
                this.field.setMaximumSize(this.field.getPreferredSize());
                this.toolBar.validate();
                this.toolBar.invalidate();
                this.preferredWidth = this.field.getPreferredSize().width;
            }
            if (this.m_zoomBox.getSelectedIndex() == 1) {
                this.scaleComponents();
            } else {
                this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 30, this.paperHeight + 30));
                this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
                this.canvas.setSize(this.paperWidth, this.paperHeight);
                this.canvas.setImage((Image)this.bImage);
            }
            if (!this.hasNextPage()) {
                this.next.setEnabled(false);
                this.last.setEnabled(false);
                this.field.requestFocus();
            }
        } else if (actionEvent.getSource() == this.first) {
            this.setCursor(WindowUtils.getWindow((Component)this.last), this.printers[0].getWaitCursor());
            this.previous.setEnabled(false);
            this.first.setEnabled(false);
            this.next.setEnabled(true);
            this.last.setEnabled(true);
            this.pageNum = 1L;
            boolean bl = false;
            if (this.printers[0].getViewPrinterType() <= 2) {
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                int n = 0;
                while (n < this.printers.length) {
                    this.m_bViewPrinterGoToPrev[n] = true;
                    this.m_bViewPrinterGoToNext[n] = true;
                    ++n;
                }
                while (this.hasPrevPage()) {
                    bl = this.preparePrevPage(this.pg);
                }
                if (bl) {
                    this.printers[this.m_currentViewPrinter].renderPage(this.pg);
                }
            } else {
                this.printers[0].goToFirstPage(this.pg);
                Dimension dimension = this.printers[0].getViewDimension();
                this.paperWidth = dimension.width;
                this.paperHeight = dimension.height;
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                this.printers[0].renderFirstPage(this.pg);
            }
            Object[] objectArray = new String[]{Long.toString(this.pageNum)};
            this.field.setText(String.valueOf(String.valueOf(" ")) + MessageFormat.format(this.getIntlString("pageNumber"), objectArray) + " ");
            if (this.field.getPreferredSize().width != this.preferredWidth) {
                this.field.setMaximumSize(this.field.getPreferredSize());
                this.toolBar.validate();
                this.toolBar.invalidate();
                this.preferredWidth = this.field.getPreferredSize().width;
            }
            if (this.m_zoomBox.getSelectedIndex() == 1) {
                this.scaleComponents();
            } else {
                this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 30, this.paperHeight + 30));
                this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
                this.canvas.setSize(this.paperWidth, this.paperHeight);
                this.canvas.setImage((Image)this.bImage);
            }
            this.setCursor(WindowUtils.getWindow((Component)this.last), this.printers[0].getDefaultCursor());
        } else if (actionEvent.getSource() == this.last) {
            Object[] objectArray;
            this.setCursor(WindowUtils.getWindow((Component)this.last), this.printers[0].getWaitCursor());
            this.next.setEnabled(false);
            this.last.setEnabled(false);
            this.previous.setEnabled(true);
            this.first.setEnabled(true);
            boolean bl = false;
            if (this.printers[0].getViewPrinterType() <= 2) {
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                while (this.hasNextPage()) {
                    bl = this.prepareNextPage(this.pg);
                    ++this.pageNum;
                }
                if (bl) {
                    this.printers[this.m_currentViewPrinter].renderPage(this.pg);
                }
            } else {
                this.printers[0].goToLastPage(this.pg);
                objectArray = this.printers[0].getViewDimension();
                this.paperWidth = objectArray.width;
                this.paperHeight = objectArray.height;
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                this.printers[0].renderLastPage(this.pg);
                this.pageNum = this.printers[0].getSequentialPageNumber();
            }
            objectArray = new String[]{Long.toString(this.pageNum)};
            this.field.setText(String.valueOf(String.valueOf(" ")) + MessageFormat.format(this.getIntlString("pageNumber"), objectArray) + " ");
            if (this.field.getPreferredSize().width != this.preferredWidth) {
                this.field.setMaximumSize(this.field.getPreferredSize());
                this.toolBar.validate();
                this.toolBar.invalidate();
                this.preferredWidth = this.field.getPreferredSize().width;
            }
            if (this.m_zoomBox.getSelectedIndex() == 1) {
                this.scaleComponents();
            } else {
                this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 30, this.paperHeight + 30));
                this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
                this.canvas.setSize(this.paperWidth, this.paperHeight);
                this.canvas.setImage((Image)this.bImage);
            }
            this.setCursor(WindowUtils.getWindow((Component)this.last), this.printers[0].getDefaultCursor());
        } else if (actionEvent.getSource() == this.m_zoomBox) {
            if (this.m_zoomBox.getSelectedIndex() == 1) {
                this.scaleComponents();
            } else {
                this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 30, this.paperHeight + 30));
                this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
                this.canvas.setSize(this.paperWidth, this.paperHeight);
                this.canvas.setImage((Image)this.bImage);
            }
        }
    }

    protected void setCursor(Component component, Cursor cursor) {
        component.setCursor(cursor);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                this.setCursor(container.getComponent(n), cursor);
                ++n;
            }
        }
    }

    private void constructPanel(UIViewPrinter[] uIViewPrinterArray, PrintDialogsProvider printDialogsProvider) {
        this.printers = uIViewPrinterArray;
        this.m_pdp = printDialogsProvider;
        this.updateResourceBundle(uIViewPrinterArray[0].getLocale());
        this.setLayout(new BorderLayout());
        this.pagePanel = new JPanel();
        this.pagePanel.setLayout(null);
        Dimension dimension = uIViewPrinterArray[0].getViewDimension();
        this.paperWidth = dimension.width;
        this.paperHeight = dimension.height;
        this.pagePanel.setBackground(Color.white);
        this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 20, this.paperHeight + 20));
        this.pane = new JScrollPane(this.pagePanel, 20, 30);
        this.add(Box.createHorizontalStrut(11), "East");
        this.add(Box.createHorizontalStrut(11), "West");
        this.add(Box.createVerticalStrut(11), "South");
        this.add((Component)this.pane, "Center");
        this.toolBar = new JPanel();
        this.toolBar.setLayout(new BoxLayout(this.toolBar, 0));
        this.toolBar.setBorder(new EmptyBorder(3, 3, 5, 3));
        String string = this.getIntlString("Zoom:");
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel.setAlignmentY(0.5f);
        this.toolBar.add(Box.createHorizontalStrut(9));
        this.toolBar.add(jLabel);
        this.toolBar.add(Box.createHorizontalStrut(6));
        String[] stringArray = new String[]{this.getIntlString("100%"), this.getIntlString("FitToPage")};
        this.m_zoomBox = new JComboBox<String>(stringArray);
        this.m_zoomBox.setSelectedIndex(1);
        this.m_zoomBox.setMaximumSize(this.m_zoomBox.getPreferredSize());
        this.m_zoomBox.addActionListener(this);
        this.m_zoomBox.setAlignmentY(0.5f);
        jLabel.setLabelFor(this.m_zoomBox);
        this.toolBar.add(this.m_zoomBox);
        this.toolBar.add(Box.createHorizontalGlue());
        this.first = new PushButton((Icon)new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)"images/first.gif")));
        this.first.getAccessibleContext().setAccessibleName(this.dvStrings.getString("First Page"));
        this.first.setAlignmentY(0.5f);
        this.toolBar.add((Component)this.first);
        this.first.addActionListener((ActionListener)this);
        this.first.setEnabled(false);
        this.first.setLeftmost(true);
        this.previous = new JButton(new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)"images/prev.gif")));
        this.previous.getAccessibleContext().setAccessibleName(this.dvStrings.getString("Previous Page"));
        this.previous.setEnabled(false);
        this.previous.addActionListener(this);
        this.previous.setAlignmentY(0.5f);
        this.toolBar.add(this.previous);
        this.field = new JTextField();
        this.field.setEditable(false);
        this.field.setAlignmentY(0.5f);
        this.toolBar.add(this.field);
        Object[] objectArray = new String[]{Long.toString(this.pageNum)};
        this.field.setText(String.valueOf(String.valueOf(" ")) + MessageFormat.format(this.getIntlString("pageNumber"), objectArray) + " ");
        this.preferredWidth = this.field.getPreferredSize().width;
        this.field.setMaximumSize(this.field.getPreferredSize());
        this.next = new JButton(new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)"images/next.gif")));
        this.next.getAccessibleContext().setAccessibleName(this.dvStrings.getString("Next Page"));
        this.next.addActionListener(this);
        this.next.setAlignmentY(0.5f);
        this.toolBar.add(this.next);
        this.last = new PushButton((Icon)new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)"images/last.gif")));
        this.last.getAccessibleContext().setAccessibleName(this.dvStrings.getString("Last Page"));
        this.last.setAlignmentY(0.5f);
        this.toolBar.add((Component)this.last);
        this.last.addActionListener((ActionListener)this);
        this.last.setRightmost(true);
        this.toolBar.add(Box.createHorizontalStrut(9));
        this.add((Component)this.toolBar, "North");
        this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
        this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
        this.init(this.pg);
        this.canvas = new ImageCanvas((Image)this.bImage);
        this.canvas.setBorder((Border)new LineBorder(Color.black));
        this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
        if (!this.hasNextPage()) {
            this.next.setEnabled(false);
            this.last.setEnabled(false);
        }
        this.pagePanel.add((Component)this.canvas);
        this.last.addFocusListener((FocusListener)this);
    }

    public void cleanUp() {
        super.removeAll();
        this.removeAll();
        this.m_zoomBox.removeActionListener(this);
        this.first.removeActionListener((ActionListener)this);
        this.previous.removeActionListener(this);
        this.next.removeActionListener(this);
        this.last.removeActionListener((ActionListener)this);
        this.last.removeFocusListener((FocusListener)this);
        this.m_pdp = null;
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        Object var12_12 = null;
        this.dvStrings = null;
    }

    private void init(Graphics graphics) {
        if (this.printers[0].getViewPrinterType() <= 2) {
            this.m_currentViewPrinter = 0;
            this.m_bViewPrinterGoToPrev = new boolean[this.printers.length];
            this.m_bViewPrinterGoToNext = new boolean[this.printers.length];
            int n = 0;
            while (n < this.printers.length) {
                this.m_bViewPrinterGoToPrev[n] = true;
                this.m_bViewPrinterGoToNext[n] = true;
                ++n;
            }
            n = 0;
            while (n < this.printers.length) {
                this.printers[n].startPrint(true);
                ++n;
            }
            this.m_bDataInFirstPage = new boolean[this.printers.length];
            n = 0;
            while (n < this.printers.length) {
                this.m_bDataInFirstPage[n] = this.printers[n].prepareFirstPage(graphics);
                ++n;
            }
            this.m_bDataInPages[0] = this.m_bDataInFirstPage[0];
            if (this.m_bDataInFirstPage[0]) {
                this.printers[0].renderPage(graphics);
            }
        } else {
            this.printers[0].startPrint(true);
            this.printers[0].prepareFirstPage(graphics);
            this.printers[0].renderPage(graphics);
        }
    }

    private boolean prepareNextPage(Graphics graphics) {
        boolean bl = false;
        if (this.printers[this.m_currentViewPrinter].isLastPhysicalPage()) {
            this.m_bViewPrinterGoToPrev[this.m_currentViewPrinter] = false;
            this.m_bViewPrinterGoToNext[this.m_currentViewPrinter] = true;
            int n = this.printers[this.m_currentViewPrinter].getSequentialPageNumber();
            if (this.m_currentViewPrinter == this.printers.length - 1) {
                ++this.m_currentLogicalPage;
                this.m_currentViewPrinter = 0;
            } else {
                ++this.m_currentViewPrinter;
            }
            this.m_bViewPrinterGoToPrev[this.m_currentViewPrinter] = true;
            if (this.m_bViewPrinterGoToNext[this.m_currentViewPrinter]) {
                this.printers[this.m_currentViewPrinter].setSequentialPageNumber(n);
                if (this.m_currentLogicalPage != (long)0) {
                    bl = this.printers[this.m_currentViewPrinter].prepareNextPage(graphics);
                } else if (this.printers[this.m_currentViewPrinter].hasPrevPage()) {
                    bl = this.printers[this.m_currentViewPrinter].prepareNextPage(graphics);
                } else {
                    this.printers[this.m_currentViewPrinter].setSequentialPageNumber(n + 1);
                    bl = this.m_bDataInFirstPage[this.m_currentViewPrinter];
                }
            } else {
                bl = this.m_bDataInPages[(int)(this.pageNum - (long)1)];
            }
        } else {
            bl = this.printers[this.m_currentViewPrinter].prepareNextPage(graphics);
        }
        return bl;
    }

    private boolean preparePrevPage(Graphics graphics) {
        boolean bl = false;
        if (this.printers[this.m_currentViewPrinter].isFirstPhysicalPage()) {
            this.m_bViewPrinterGoToNext[this.m_currentViewPrinter] = false;
            this.m_bViewPrinterGoToPrev[this.m_currentViewPrinter] = true;
            int n = this.printers[this.m_currentViewPrinter].getSequentialPageNumber();
            if (this.m_currentViewPrinter == 0) {
                --this.m_currentLogicalPage;
                this.m_currentViewPrinter = this.printers.length - 1;
            } else {
                --this.m_currentViewPrinter;
            }
            this.m_bViewPrinterGoToNext[this.m_currentViewPrinter] = true;
            if (this.m_bViewPrinterGoToPrev[this.m_currentViewPrinter]) {
                this.printers[this.m_currentViewPrinter].setSequentialPageNumber(n);
                bl = this.printers[this.m_currentViewPrinter].preparePrevPage(graphics);
            } else {
                bl = this.m_bDataInPages[(int)(this.pageNum - (long)1)];
            }
        } else {
            bl = this.printers[this.m_currentViewPrinter].preparePrevPage(graphics);
        }
        return bl;
    }

    private boolean hasNextPage() {
        if (this.printers[0].getViewPrinterType() > 2) {
            return this.printers[0].hasNextPage();
        }
        if (this.m_currentViewPrinter < this.printers.length - 1) {
            return true;
        }
        if (this.printers[this.m_currentViewPrinter].hasNextPage()) {
            return true;
        }
        return this.printers[0].hasNextPage();
    }

    private boolean hasPrevPage() {
        if (this.printers[0].getViewPrinterType() > 2) {
            return this.printers[0].hasPrevPage();
        }
        if (this.m_currentViewPrinter != 0) {
            return true;
        }
        if (this.printers[this.m_currentViewPrinter].hasPrevPage()) {
            return true;
        }
        return this.printers[this.printers.length - 1].hasPrevPage();
    }

    public void setImageScalingMode(int n) {
        this.scalingMode = n;
    }

    public int getImageScalingMode() {
        return this.scalingMode;
    }

    private String getIntlString(String string) {
        return this.getIntlString(string, this.dvStrings);
    }

    private String getIntlString(String string, ResourceBundle resourceBundle) {
        String string2;
        if (resourceBundle == null) {
            return string;
        }
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            String string3 = string;
            return string3;
        }
        return string2;
    }

    private void scaleComponents() {
        Dimension dimension = this.pane.getViewport().getExtentSize();
        float f = (float)(dimension.width - 20) / (float)this.paperWidth;
        float f2 = (float)(dimension.height - 20) / (float)this.paperHeight;
        float f3 = f < f2 ? f : f2;
        this.scaledWidth = (int)((float)this.paperWidth * f3);
        this.scaledHeight = (int)((float)this.paperHeight * f3);
        int n = (dimension.width - this.scaledWidth) / 2;
        int n2 = (dimension.height - this.scaledHeight) / 2;
        this.pagePanel.setPreferredSize(new Dimension(this.scaledWidth + n * 2, this.scaledHeight + n2 * 2));
        this.canvas.setBounds(n, n2, this.scaledWidth, this.scaledHeight);
        this.canvas.setSize(this.scaledWidth, this.scaledHeight);
        this.canvas.setImage(this.bImage.getScaledInstance(this.scaledWidth, this.scaledHeight, this.scalingMode));
    }

    private void updateResourceBundle(Locale locale) {
        try {
            this.dvStrings = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
        }
        catch (MissingResourceException missingResourceException) {
            this.dvStrings = null;
        }
    }
}

