/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.spinBox.SpinButtonEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.util.ErrorHandler;

public class PageSetupMarginsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    protected UIViewPrinter[] m_viewPrinter;
    protected JPanel m_marginsPanel;
    protected JLabel m_marginsLabel;
    protected JPanel m_centerOnPagePanel;
    protected JLabel m_centerOnPageLabel;
    protected JComboBox m_unitsComboBox;
    protected JLabel m_unitsLabel;
    protected MyNumericSpinBox m_topNumericSpinBox;
    protected JLabel m_topLabel;
    protected MyNumericSpinBox m_leftNumericSpinBox;
    protected JLabel m_leftLabel;
    protected MyNumericSpinBox m_bottomNumericSpinBox;
    protected JLabel m_bottomLabel;
    protected MyNumericSpinBox m_rightNumericSpinBox;
    protected JLabel m_rightLabel;
    protected MyNumericSpinBox m_headerNumericSpinBox;
    protected JLabel m_headerLabel;
    protected MyNumericSpinBox m_footerNumericSpinBox;
    protected JLabel m_footerLabel;
    protected JCheckBox m_horizontallyCheckBox;
    protected JCheckBox m_verticallyCheckBox;
    protected JPanel m_leftPanel;
    protected JPanel m_rightPanel;
    protected JPanel m_mainPanel;
    protected JLabel m_previewLabel;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh;
    protected String m_strHelpContextID;
    private double paperWidth = 8.27;
    private double paperHeight = 11.69;
    private boolean isVersionSupportOrientation;
    private ResourceBundle rBundle;
    private Locale m_locale = Locale.US;
    private int m_units = 0;
    private float _top;
    private float _left;
    private float _bottom;
    private float _right;
    private float _header;
    private float _footer;
    private boolean m_bSuperCalled = true;

    public PageSetupMarginsPanel(ViewPrinter[] viewPrinterArray) {
        this((UIViewPrinter[])viewPrinterArray);
    }

    public PageSetupMarginsPanel(UIViewPrinter[] uIViewPrinterArray) {
        if (uIViewPrinterArray == null) {
            return;
        }
        this.m_viewPrinter = uIViewPrinterArray;
        this.m_locale = this.m_viewPrinter[0].getLocale();
        this.updateResourceBundle(this.m_locale);
        this.setLayout(new BoxLayout(this, 1));
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 0));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int n = Integer.parseInt(this.rBundle.getString("PageSetupMarginsPanelWidth"));
        int n2 = Integer.parseInt(this.rBundle.getString("PageSetupMarginsPanelHeight"));
        this.m_mainPanel.setPreferredSize(new Dimension(n, n2));
        this.m_mainPanel.setMinimumSize(this.m_mainPanel.getPreferredSize());
        this.m_mainPanel.setMaximumSize(this.m_mainPanel.getPreferredSize());
        this.add(this.m_mainPanel);
        this._init();
    }

    private void _init() {
        this.m_mainPanel.removeAll();
        this.m_rightPanel = new JPanel();
        this.m_rightPanel.setLayout(new BoxLayout(this.m_rightPanel, 1));
        this.m_rightPanel.setPreferredSize(this.getPreferredSize());
        this.m_rightPanel.setMinimumSize(this.m_rightPanel.getPreferredSize());
        this.m_rightPanel.setMaximumSize(this.m_rightPanel.getPreferredSize());
        this.m_leftPanel = new JPanel();
        this.m_leftPanel.setLayout(new BoxLayout(this.m_leftPanel, 1));
        this.m_leftPanel.setPreferredSize(this.getPreferredSize());
        this.m_leftPanel.setMinimumSize(this.m_leftPanel.getPreferredSize());
        this.m_leftPanel.setMaximumSize(this.m_leftPanel.getPreferredSize());
        this.m_marginsPanel = new JPanel();
        this.m_marginsPanel.setLayout(new BoxLayout(this.m_marginsPanel, 1));
        this.m_marginsPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 180));
        this.m_marginsPanel.setMinimumSize(this.m_marginsPanel.getPreferredSize());
        this.m_marginsPanel.setMaximumSize(this.m_marginsPanel.getPreferredSize());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 10));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        this.m_marginsPanel.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 40));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        String string = this.rBundle.getString("Units");
        this.m_unitsLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_unitsLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_unitsLabel.setAlignmentX(0.0f);
        int n = this.getToolkit().getFontMetrics(this.m_unitsLabel.getFont()).stringWidth(this.m_unitsLabel.getText());
        this.m_unitsLabel.setPreferredSize(new Dimension(n + 5, this.m_unitsLabel.getPreferredSize().height));
        this.m_unitsLabel.setMinimumSize(this.m_unitsLabel.getPreferredSize());
        this.m_unitsLabel.setMaximumSize(this.m_unitsLabel.getPreferredSize());
        jPanel.add(this.m_unitsLabel);
        this.m_unitsComboBox = new JComboBox();
        string = this.rBundle.getString("Pixels");
        this.m_unitsComboBox.addItem(string);
        string = this.rBundle.getString("Inches");
        this.m_unitsComboBox.addItem(string);
        string = this.rBundle.getString("cm");
        this.m_unitsComboBox.addItem(string);
        this.m_unitsComboBox.setOpaque(true);
        this.m_unitsComboBox.setPreferredSize(new Dimension(60, 22));
        this.m_unitsComboBox.setMinimumSize(this.m_unitsComboBox.getPreferredSize());
        this.m_unitsComboBox.setMaximumSize(this.m_unitsComboBox.getPreferredSize());
        this.m_unitsLabel.setLabelFor(this.m_unitsComboBox);
        this.m_unitsLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("UnitsADA"));
        jPanel.add(this.m_unitsComboBox);
        this.m_marginsPanel.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 30));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        string = this.rBundle.getString("Top");
        this.m_topLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_topLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_topLabel.setAlignmentX(0.0f);
        this.m_topNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_topNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_topNumericSpinBox.setMinimumSize(this.m_topNumericSpinBox.getPreferredSize());
        this.m_topNumericSpinBox.setMaximumSize(this.m_topNumericSpinBox.getPreferredSize());
        this.m_topLabel.setLabelFor((Component)((Object)this.m_topNumericSpinBox));
        string = this.rBundle.getString("Left");
        this.m_leftLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_leftLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_leftLabel.setAlignmentX(0.0f);
        this.m_leftNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_leftNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_leftNumericSpinBox.setMinimumSize(this.m_leftNumericSpinBox.getPreferredSize());
        this.m_leftNumericSpinBox.setMaximumSize(this.m_leftNumericSpinBox.getPreferredSize());
        this.m_leftLabel.setLabelFor((Component)((Object)this.m_leftNumericSpinBox));
        jPanel.add(this.m_topLabel);
        jPanel.add((Component)((Object)this.m_topNumericSpinBox));
        jPanel.add(Box.createHorizontalStrut(26));
        jPanel.add(this.m_leftLabel);
        jPanel.add((Component)((Object)this.m_leftNumericSpinBox));
        this.m_marginsPanel.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 40));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        string = this.rBundle.getString("Bottom");
        this.m_bottomLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_bottomLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_bottomLabel.setAlignmentX(0.0f);
        this.m_bottomNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_bottomNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_bottomNumericSpinBox.setMinimumSize(this.m_bottomNumericSpinBox.getPreferredSize());
        this.m_bottomNumericSpinBox.setMaximumSize(this.m_bottomNumericSpinBox.getPreferredSize());
        this.m_bottomLabel.setLabelFor((Component)((Object)this.m_bottomNumericSpinBox));
        string = this.rBundle.getString("Right");
        this.m_rightLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_rightLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_rightLabel.setAlignmentX(0.0f);
        this.m_rightNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_rightNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_rightNumericSpinBox.setMinimumSize(this.m_rightNumericSpinBox.getPreferredSize());
        this.m_rightNumericSpinBox.setMaximumSize(this.m_rightNumericSpinBox.getPreferredSize());
        this.m_rightLabel.setLabelFor((Component)((Object)this.m_rightNumericSpinBox));
        jPanel.add(this.m_bottomLabel);
        jPanel.add((Component)((Object)this.m_bottomNumericSpinBox));
        jPanel.add(Box.createHorizontalStrut(26));
        jPanel.add(this.m_rightLabel);
        jPanel.add((Component)((Object)this.m_rightNumericSpinBox));
        this.m_marginsPanel.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 30));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        string = this.rBundle.getString("Header");
        this.m_headerLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_headerLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_headerLabel.setAlignmentX(0.0f);
        this.m_headerNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_headerNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_headerNumericSpinBox.setMinimumSize(this.m_headerNumericSpinBox.getPreferredSize());
        this.m_headerNumericSpinBox.setMaximumSize(this.m_headerNumericSpinBox.getPreferredSize());
        this.m_headerLabel.setLabelFor((Component)((Object)this.m_headerNumericSpinBox));
        jPanel.add(this.m_headerLabel);
        jPanel.add((Component)((Object)this.m_headerNumericSpinBox));
        this.m_marginsPanel.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 30));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        string = this.rBundle.getString("Footer");
        this.m_footerLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_footerLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_footerLabel.setAlignmentX(0.0f);
        this.m_footerNumericSpinBox = new MyNumericSpinBox(1, 1000);
        this.m_footerNumericSpinBox.setPreferredSize(new Dimension(60, 22));
        this.m_footerNumericSpinBox.setMinimumSize(this.m_footerNumericSpinBox.getPreferredSize());
        this.m_footerNumericSpinBox.setMaximumSize(this.m_footerNumericSpinBox.getPreferredSize());
        this.m_footerLabel.setLabelFor((Component)((Object)this.m_footerNumericSpinBox));
        jPanel.add(this.m_footerLabel);
        jPanel.add((Component)((Object)this.m_footerNumericSpinBox));
        this.m_marginsPanel.add(jPanel);
        this.m_leftPanel.add(this.m_marginsPanel);
        this.m_mainPanel.add(this.m_leftPanel);
        this.m_mainPanel.add(Box.createHorizontalGlue());
        this.m_mainPanel.add(Box.createHorizontalStrut(12));
        this.m_mainPanel.add(this.m_rightPanel);
        this.m_mainPanel.add(Box.createHorizontalStrut(20));
        this.add(Box.createVerticalGlue());
        this.setAlignmentX(0.0f);
        this.m_mainPanel.setAlignmentX(0.0f);
        int n2 = this.m_topLabel.getPreferredSize().width;
        if (n2 < this.m_bottomLabel.getPreferredSize().width) {
            n2 = this.m_bottomLabel.getPreferredSize().width;
        }
        if (n2 < this.m_headerLabel.getPreferredSize().width) {
            n2 = this.m_headerLabel.getPreferredSize().width;
        }
        if (n2 < this.m_unitsLabel.getPreferredSize().width) {
            n2 = this.m_unitsLabel.getPreferredSize().width;
        }
        if (n2 < this.m_footerLabel.getPreferredSize().width) {
            n2 = this.m_footerLabel.getPreferredSize().width;
        }
        this.m_topLabel.setPreferredSize(new Dimension(n2 += 4, this.m_topLabel.getPreferredSize().height));
        this.m_topLabel.setMinimumSize(this.m_topLabel.getPreferredSize());
        this.m_topLabel.setMaximumSize(this.m_topLabel.getPreferredSize());
        this.m_bottomLabel.setPreferredSize(new Dimension(n2, this.m_bottomLabel.getPreferredSize().height));
        this.m_bottomLabel.setMinimumSize(this.m_bottomLabel.getPreferredSize());
        this.m_bottomLabel.setMaximumSize(this.m_bottomLabel.getPreferredSize());
        this.m_headerLabel.setPreferredSize(new Dimension(n2, this.m_headerLabel.getPreferredSize().height));
        this.m_headerLabel.setMinimumSize(this.m_headerLabel.getPreferredSize());
        this.m_headerLabel.setMaximumSize(this.m_headerLabel.getPreferredSize());
        this.m_unitsLabel.setPreferredSize(new Dimension(n2, this.m_unitsLabel.getPreferredSize().height));
        this.m_unitsLabel.setMinimumSize(this.m_unitsLabel.getPreferredSize());
        this.m_unitsLabel.setMaximumSize(this.m_unitsLabel.getPreferredSize());
        this.m_footerLabel.setPreferredSize(new Dimension(n2, this.m_footerLabel.getPreferredSize().height));
        this.m_footerLabel.setMinimumSize(this.m_footerLabel.getPreferredSize());
        this.m_footerLabel.setMaximumSize(this.m_footerLabel.getPreferredSize());
        int n3 = this.m_leftLabel.getPreferredSize().width;
        if (n3 < this.m_rightLabel.getPreferredSize().width) {
            n3 = this.m_rightLabel.getPreferredSize().width;
        }
        this.m_leftLabel.setPreferredSize(new Dimension(n3 += 4, this.m_leftLabel.getPreferredSize().height));
        this.m_leftLabel.setMinimumSize(this.m_leftLabel.getPreferredSize());
        this.m_leftLabel.setMaximumSize(this.m_leftLabel.getPreferredSize());
        this.m_rightLabel.setPreferredSize(new Dimension(n3, this.m_rightLabel.getPreferredSize().height));
        this.m_rightLabel.setMinimumSize(this.m_rightLabel.getPreferredSize());
        this.m_rightLabel.setMaximumSize(this.m_rightLabel.getPreferredSize());
        this.m_unitsComboBox.addActionListener(this);
        this.m_topNumericSpinBox.addPropertyChangeListener(this);
        this.m_leftNumericSpinBox.addPropertyChangeListener(this);
        this.m_bottomNumericSpinBox.addPropertyChangeListener(this);
        this.m_rightNumericSpinBox.addPropertyChangeListener(this);
        this.m_headerNumericSpinBox.addPropertyChangeListener(this);
        this.m_footerNumericSpinBox.addPropertyChangeListener(this);
        this._initiate();
    }

    private void _initiate() {
        this.m_footerNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
        this.m_headerNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
        this.m_topNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
        this.m_leftNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
        this.m_rightNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
        this.m_bottomNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
        this.m_headerNumericSpinBox.setValue(this.m_viewPrinter[0].getHeaderMargin());
        this.m_footerNumericSpinBox.setValue(this.m_viewPrinter[0].getFooterMargin());
        this.m_topNumericSpinBox.setValue(this.m_viewPrinter[0].getTopMargin());
        this.m_leftNumericSpinBox.setValue(this.m_viewPrinter[0].getLeftMargin());
        this.m_rightNumericSpinBox.setValue(this.m_viewPrinter[0].getRightMargin());
        this.m_bottomNumericSpinBox.setValue(this.m_viewPrinter[0].getBottomMargin());
        this._header = this.m_viewPrinter[0].getHeaderMargin();
        this._footer = this.m_viewPrinter[0].getFooterMargin();
        this._top = this.m_viewPrinter[0].getTopMargin();
        this._left = this.m_viewPrinter[0].getLeftMargin();
        this._bottom = this.m_viewPrinter[0].getBottomMargin();
        this._right = this.m_viewPrinter[0].getRightMargin();
        this.m_unitsComboBox.setSelectedIndex(this.m_viewPrinter[0].getUnits());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.m_topNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._top = ((Double)this.m_topNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._top = this.getPixels((Double)this.m_topNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._top = this.getPixels(this.getInchesFromCM(((Double)this.m_topNumericSpinBox.getValue()).floatValue()));
                }
            }
        } else if (propertyChangeEvent.getSource() == this.m_leftNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._left = ((Double)this.m_leftNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._left = this.getPixels((Double)this.m_leftNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._left = this.getPixels(this.getInchesFromCM(((Double)this.m_leftNumericSpinBox.getValue()).floatValue()));
                }
            }
        } else if (propertyChangeEvent.getSource() == this.m_rightNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._right = ((Double)this.m_rightNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._right = this.getPixels((Double)this.m_rightNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._right = this.getPixels(this.getInchesFromCM(((Double)this.m_rightNumericSpinBox.getValue()).floatValue()));
                }
            }
        } else if (propertyChangeEvent.getSource() == this.m_bottomNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._bottom = ((Double)this.m_bottomNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._bottom = this.getPixels((Double)this.m_bottomNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._bottom = this.getPixels(this.getInchesFromCM(((Double)this.m_bottomNumericSpinBox.getValue()).floatValue()));
                }
            }
        } else if (propertyChangeEvent.getSource() == this.m_headerNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._header = ((Double)this.m_headerNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._header = this.getPixels((Double)this.m_headerNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._header = this.getPixels(this.getInchesFromCM(((Double)this.m_headerNumericSpinBox.getValue()).floatValue()));
                }
            }
        } else if (propertyChangeEvent.getSource() == this.m_footerNumericSpinBox) {
            switch (this.m_unitsComboBox.getSelectedIndex()) {
                case 0: {
                    this._footer = ((Double)this.m_footerNumericSpinBox.getValue()).floatValue();
                    break;
                }
                case 1: {
                    this._footer = this.getPixels((Double)this.m_footerNumericSpinBox.getValue());
                    break;
                }
                case 2: {
                    this._footer = this.getPixels(this.getInchesFromCM(((Double)this.m_footerNumericSpinBox.getValue()).floatValue()));
                }
            }
        }
    }

    private int getPixels(double d) {
        double d2 = (double)((int)(d * (double)100)) / 100.0;
        return (int)(d2 * (double)72 + 0.5);
    }

    private double getInches(float f) {
        return (double)f / 72.0 + 0.005;
    }

    private double getCM(double d) {
        double d2 = (double)((int)(d * (double)100)) / 100.0;
        return d2 * 2.54 + 0.005;
    }

    private double getInchesFromCM(double d) {
        return d / 2.54 + 0.005;
    }

    public void setDecimalSeparator(char c) {
        float f = ((Double)this.m_topNumericSpinBox.getValue()).floatValue();
        this.m_topNumericSpinBox.setDecimalSeparator(c);
        this.m_topNumericSpinBox.setValue(f);
        f = ((Double)this.m_leftNumericSpinBox.getValue()).floatValue();
        this.m_leftNumericSpinBox.setDecimalSeparator(c);
        this.m_leftNumericSpinBox.setValue(f);
        f = ((Double)this.m_bottomNumericSpinBox.getValue()).floatValue();
        this.m_bottomNumericSpinBox.setDecimalSeparator(c);
        this.m_bottomNumericSpinBox.setValue(f);
        f = ((Double)this.m_rightNumericSpinBox.getValue()).floatValue();
        this.m_rightNumericSpinBox.setDecimalSeparator(c);
        this.m_rightNumericSpinBox.setValue(f);
        f = ((Double)this.m_headerNumericSpinBox.getValue()).floatValue();
        this.m_headerNumericSpinBox.setDecimalSeparator(c);
        this.m_headerNumericSpinBox.setValue(f);
        f = ((Double)this.m_footerNumericSpinBox.getValue()).floatValue();
        this.m_footerNumericSpinBox.setDecimalSeparator(c);
        this.m_footerNumericSpinBox.setValue(f);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_unitsComboBox && this.m_units != this.m_unitsComboBox.getSelectedIndex()) {
            int n = this.m_units;
            this._footer = ((Double)this.m_footerNumericSpinBox.getValue()).floatValue();
            this._header = ((Double)this.m_headerNumericSpinBox.getValue()).floatValue();
            this._top = ((Double)this.m_topNumericSpinBox.getValue()).floatValue();
            this._left = ((Double)this.m_leftNumericSpinBox.getValue()).floatValue();
            this._right = ((Double)this.m_rightNumericSpinBox.getValue()).floatValue();
            this._bottom = ((Double)this.m_bottomNumericSpinBox.getValue()).floatValue();
            if (n == 1) {
                this._footer = this.getPixels(this._footer);
                this._header = this.getPixels(this._header);
                this._top = this.getPixels(this._top);
                this._left = this.getPixels(this._left);
                this._right = this.getPixels(this._right);
                this._bottom = this.getPixels(this._bottom);
            } else if (n == 2) {
                this._footer = this.getPixels(this.getInchesFromCM(this._footer));
                this._header = this.getPixels(this.getInchesFromCM(this._header));
                this._top = this.getPixels(this.getInchesFromCM(this._top));
                this._left = this.getPixels(this.getInchesFromCM(this._left));
                this._right = this.getPixels(this.getInchesFromCM(this._right));
                this._bottom = this.getPixels(this.getInchesFromCM(this._bottom));
            }
            this.m_units = this.m_unitsComboBox.getSelectedIndex();
            if (this.m_units == 0) {
                this.m_footerNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
                this.m_headerNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
                this.m_topNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
                this.m_leftNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
                this.m_rightNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
                this.m_bottomNumericSpinBox.setModel(null.new MySecondSpinBoxModel());
                this.m_footerNumericSpinBox.setValue(this._footer);
                this.m_headerNumericSpinBox.setValue(this._header);
                this.m_topNumericSpinBox.setValue(this._top);
                this.m_leftNumericSpinBox.setValue(this._left);
                this.m_rightNumericSpinBox.setValue(this._right);
                this.m_bottomNumericSpinBox.setValue(this._bottom);
                this.m_unitsComboBox.requestFocus();
            } else if (this.m_units == 1) {
                this.m_footerNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_headerNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_topNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_leftNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_rightNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_bottomNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_footerNumericSpinBox.setValue((float)this.getInches(this._footer));
                this.m_headerNumericSpinBox.setValue((float)this.getInches(this._header));
                this.m_topNumericSpinBox.setValue((float)this.getInches(this._top));
                this.m_leftNumericSpinBox.setValue((float)this.getInches(this._left));
                this.m_rightNumericSpinBox.setValue((float)this.getInches(this._right));
                this.m_bottomNumericSpinBox.setValue((float)this.getInches(this._bottom));
                this.m_unitsComboBox.requestFocus();
            } else {
                this.m_footerNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_headerNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_topNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_leftNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_rightNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_bottomNumericSpinBox.setModel(null.new MySpinBoxModel());
                this.m_footerNumericSpinBox.setValue((float)this.getCM(this.getInches(this._footer)));
                this.m_headerNumericSpinBox.setValue((float)this.getCM(this.getInches(this._header)));
                this.m_topNumericSpinBox.setValue((float)this.getCM(this.getInches(this._top)));
                this.m_leftNumericSpinBox.setValue((float)this.getCM(this.getInches(this._left)));
                this.m_rightNumericSpinBox.setValue((float)this.getCM(this.getInches(this._right)));
                this.m_bottomNumericSpinBox.setValue((float)this.getCM(this.getInches(this._bottom)));
                this.m_unitsComboBox.requestFocus();
            }
        }
    }

    public void apply() {
        int n = this.m_unitsComboBox.getSelectedIndex();
        this._footer = ((Double)this.m_footerNumericSpinBox.getValue()).floatValue();
        this._header = ((Double)this.m_headerNumericSpinBox.getValue()).floatValue();
        this._top = ((Double)this.m_topNumericSpinBox.getValue()).floatValue();
        this._left = ((Double)this.m_leftNumericSpinBox.getValue()).floatValue();
        this._right = ((Double)this.m_rightNumericSpinBox.getValue()).floatValue();
        this._bottom = ((Double)this.m_bottomNumericSpinBox.getValue()).floatValue();
        if (n == 1) {
            this._footer = this.getPixels(this._footer);
            this._header = this.getPixels(this._header);
            this._top = this.getPixels(this._top);
            this._left = this.getPixels(this._left);
            this._right = this.getPixels(this._right);
            this._bottom = this.getPixels(this._bottom);
        } else if (n == 2) {
            this._footer = this.getPixels(this.getInchesFromCM(this._footer));
            this._header = this.getPixels(this.getInchesFromCM(this._header));
            this._top = this.getPixels(this.getInchesFromCM(this._top));
            this._left = this.getPixels(this.getInchesFromCM(this._left));
            this._right = this.getPixels(this.getInchesFromCM(this._right));
            this._bottom = this.getPixels(this.getInchesFromCM(this._bottom));
        }
        int n2 = 0;
        while (n2 < this.m_viewPrinter.length) {
            this.m_viewPrinter[n2].setTopMargin((int)this._top);
            this.m_viewPrinter[n2].setLeftMargin((int)this._left);
            this.m_viewPrinter[n2].setRightMargin((int)this._right);
            this.m_viewPrinter[n2].setBottomMargin((int)this._bottom);
            this.m_viewPrinter[n2].setHeaderMargin((int)this._header);
            this.m_viewPrinter[n2].setFooterMargin((int)this._footer);
            this.m_viewPrinter[n2].setUnits(this.m_units);
            ++n2;
        }
        this.setPaperSize();
    }

    public Dimension getPreferredSize() {
        int n = Integer.parseInt(this.rBundle.getString("PageSetupMarginsPanelWidth"));
        int n2 = Integer.parseInt(this.rBundle.getString("PageSetupMarginsPanelHeight"));
        return new Dimension(n, n2);
    }

    public void setViewPrinter(ViewPrinter[] viewPrinterArray) {
        if (viewPrinterArray != null) {
            this.m_viewPrinter = viewPrinterArray;
        }
        this._init();
    }

    public void setFocusComponent() {
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.m_locale = locale;
        this.updateResourceBundle(locale);
        this._init();
    }

    public void setPaperWidth(double d) {
        this.paperWidth = d;
    }

    public double getPaperWidth() {
        return this.paperWidth;
    }

    public void setPaperHeight(double d) {
        this.paperHeight = d;
    }

    public double getPaperHeight() {
        return this.paperHeight;
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void cleanUp() {
        super.removeAll();
        this.removeAll();
        this.m_unitsComboBox.removeActionListener(this);
        this.m_topNumericSpinBox.removePropertyChangeListener(this);
        this.m_leftNumericSpinBox.removePropertyChangeListener(this);
        this.m_bottomNumericSpinBox.removePropertyChangeListener(this);
        this.m_rightNumericSpinBox.removePropertyChangeListener(this);
        this.m_headerNumericSpinBox.removePropertyChangeListener(this);
        this.m_footerNumericSpinBox.removePropertyChangeListener(this);
        this.m_topNumericSpinBox.cleanUp();
        this.m_leftNumericSpinBox.cleanUp();
        this.m_bottomNumericSpinBox.cleanUp();
        this.m_rightNumericSpinBox.cleanUp();
        this.m_headerNumericSpinBox.cleanUp();
        this.m_footerNumericSpinBox.cleanUp();
        this.m_topNumericSpinBox = null;
        this.m_leftNumericSpinBox = null;
        this.m_bottomNumericSpinBox = null;
        this.m_rightNumericSpinBox = null;
        this.m_headerNumericSpinBox = null;
        this.m_footerNumericSpinBox = null;
        this.m_viewPrinter = null;
        this.m_marginsPanel.removeAll();
        this.m_marginsPanel = null;
        this.m_marginsLabel = null;
        this.m_centerOnPagePanel = null;
        this.m_centerOnPageLabel = null;
        this.m_unitsComboBox.removeAll();
        this.m_unitsComboBox = null;
        this.m_unitsLabel = null;
        this.m_topLabel = null;
        this.m_leftLabel = null;
        this.m_bottomLabel = null;
        this.m_rightLabel = null;
        this.m_headerLabel = null;
        this.m_footerLabel = null;
        this.m_horizontallyCheckBox = null;
        this.m_verticallyCheckBox = null;
        this.m_leftPanel.removeAll();
        this.m_leftPanel = null;
        this.m_rightPanel.removeAll();
        this.m_rightPanel = null;
        this.m_mainPanel.removeAll();
        this.m_mainPanel = null;
        this.m_previewLabel = null;
        this.m_eh = null;
        this.m_strHelpContextID = null;
        this.rBundle = null;
        this.m_locale = null;
    }

    private void setPaperSize() {
        PageFormat pageFormat = this.m_viewPrinter[0].getPageFormat();
        float f = (float)pageFormat.getPaper().getWidth();
        float f2 = (float)pageFormat.getPaper().getHeight();
        float f3 = this.m_viewPrinter[0].getTopMargin();
        float f4 = this.m_viewPrinter[0].getLeftMargin();
        float f5 = this.m_viewPrinter[0].getBottomMargin();
        float f6 = this.m_viewPrinter[0].getRightMargin();
        Paper paper = new Paper();
        if (pageFormat.getOrientation() == 0) {
            paper.setSize(f2, f);
            paper.setImageableArea(f3, f4, f2 - (f4 + f6), f - (f3 + f5));
        } else {
            paper.setSize(f, f2);
            paper.setImageableArea(f3, f4, f - (f4 + f6), f2 - (f3 + f5));
        }
        pageFormat.setPaper(paper);
    }

    class NumberLocaleDocument
    extends PlainDocument {
        private DecimalFormat m_format;
        private char m_decimalSeparator;
        private JTextField m_text;
        private char Minus;
        private char Dec;

        public NumberLocaleDocument(JTextField jTextField, Locale locale) {
            this.m_text = jTextField;
            this.m_format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            this.Minus = this.m_format.getDecimalFormatSymbols().getMinusSign();
            this.Dec = this.m_format.getDecimalFormatSymbols().getDecimalSeparator();
            this.m_format.setGroupingUsed(false);
        }

        public void setDecimalSeparator(char c) {
            this.m_decimalSeparator = c;
            DecimalFormatSymbols decimalFormatSymbols = this.m_format.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator(this.m_decimalSeparator);
            this.m_format.setDecimalFormatSymbols(decimalFormatSymbols);
        }

        protected void insertString(Object object) throws BadLocationException {
            String string = null;
            if (object instanceof Double) {
                double d = (Double)object;
                string = this.m_format.format(d);
            } else if (object instanceof Float) {
                double d = ((Float)object).doubleValue();
                string = this.m_format.format(d);
            } else {
                string = object.toString();
            }
            this.insertString(0, string, null);
        }

        protected Float parseAsFloat(String string) {
            Number number;
            block3: {
                number = null;
                try {
                    number = this.m_format.parse(string);
                }
                catch (ParseException parseException) {
                    if (PageSetupMarginsPanel.this.m_eh == null) break block3;
                    PageSetupMarginsPanel.this.m_eh.log("ParseException while parsing String as Number", this.getClass().getName(), "Float parseAsFloat(String text)");
                }
            }
            if (number != null) {
                return new Float(number.floatValue());
            }
            return null;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            try {
                StringBuffer stringBuffer = new StringBuffer(this.m_text.getText());
                if (string.charAt(0) == this.Dec && this.m_decimalSeparator != this.Dec) {
                    return;
                }
                stringBuffer.insert(n, string);
                ParsePosition parsePosition = new ParsePosition(0);
                Number number = this.m_format.parse(stringBuffer.toString(), parsePosition);
                String string2 = new Character(this.Dec).toString();
                if (parsePosition.getIndex() != stringBuffer.length()) {
                    if (parsePosition.getIndex() == stringBuffer.length() - 1 && string.equals(string2) && this.m_text.getText().indexOf(this.Dec) == -1) {
                        super.insertString(n, string, attributeSet);
                    }
                    return;
                }
                super.insertString(n, string, attributeSet);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    class MySpinBuddy
    extends JTextField
    implements SpinBuddy,
    FocusListener {
        int p;
        MyNumericSpinBox m_myNumericSpinBox;
        NumberLocaleDocument m_numberLocaleDocument;

        MySpinBuddy(MyNumericSpinBox myNumericSpinBox) {
            this.m_numberLocaleDocument = new NumberLocaleDocument(this, PageSetupMarginsPanel.this.m_locale);
            this.setBorder(null);
            this.setDocument(this.m_numberLocaleDocument);
            this.m_myNumericSpinBox = myNumericSpinBox;
            this.addFocusListener(this);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.getText() == null || this.getText().length() == 0) {
                return;
            }
            try {
                Float f = this.parseAsFloat(this.getText());
                if (f != null) {
                    this.m_myNumericSpinBox.setValue(f.floatValue(), false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            Float f;
            if (this.m_myNumericSpinBox != PageSetupMarginsPanel.this.m_topNumericSpinBox) {
                if (keyEvent.getKeyCode() == 38 && keyEvent.getID() == 401) {
                    f = this.parseAsFloat(this.getText());
                    if (f != null) {
                        this.m_myNumericSpinBox.setValue(f.floatValue(), false);
                    }
                    this.selectAll();
                } else if (keyEvent.getKeyCode() == 40 && keyEvent.getID() == 401) {
                    f = this.parseAsFloat(this.getText());
                    if (f != null) {
                        this.m_myNumericSpinBox.setValue(f.floatValue(), false);
                    }
                    this.selectAll();
                }
            }
            if (keyEvent.getKeyCode() == 10 && (f = this.parseAsFloat(this.getText())) != null) {
                this.m_myNumericSpinBox.setValue(f.floatValue(), false);
            }
            super.processKeyEvent(keyEvent);
        }

        public void setValue(Object object) {
            try {
                this.m_numberLocaleDocument.remove(0, this.m_numberLocaleDocument.getLength());
                this.m_numberLocaleDocument.insertString(object);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected Float parseAsFloat(String string) {
            return this.m_numberLocaleDocument.parseAsFloat(string);
        }

        public NumberLocaleDocument getNumberLocaleDocument() {
            return this.m_numberLocaleDocument;
        }
    }

    class MySecondSpinBoxModel
    implements SpinBoxModel {
        int m_value;
        boolean m_forward = true;

        MySecondSpinBoxModel() {
        }

        public final Object nextElement() {
            if (this.m_forward) {
                this.m_value = (int)((double)this.m_value + 1.1);
            } else {
                this.m_value = (int)((double)this.m_value - 0.9);
                if (this.m_value < 0) {
                    this.m_value = 0;
                }
            }
            return new Integer(this.m_value);
        }

        public boolean hasMoreElements() {
            return this.m_forward || this.m_value != 0;
        }

        public void setIteratingForward(boolean bl) {
            this.m_forward = bl;
        }

        public boolean isIteratingForward() {
            return this.m_forward;
        }

        public Object skip(int n) {
            if (this.m_forward) {
                this.m_value += n;
                return new Float(this.m_value);
            }
            this.m_value -= n;
            if (this.m_value < 0) {
                this.m_value = 0;
            }
            return new Float(this.m_value);
        }

        public int remainingElements(int n) {
            return n - this.m_value;
        }

        public void setValue(float f) {
            this.m_value = (int)f;
        }

        public float getValue() {
            return this.m_value;
        }
    }

    class MySpinBoxModel
    implements SpinBoxModel {
        float m_value;
        boolean m_forward = true;

        MySpinBoxModel() {
        }

        public final Object nextElement() {
            if (this.m_forward) {
                this.m_value = (float)((double)this.m_value + 0.011);
            } else {
                this.m_value = (float)((double)this.m_value - 0.009);
                if (this.m_value < 0.0f) {
                    this.m_value = 0.0f;
                }
            }
            int n = (int)(this.m_value * (float)100);
            this.m_value = (float)((double)n / 100.0);
            return new Float(this.m_value);
        }

        public boolean hasMoreElements() {
            return this.m_forward || this.m_value != 0.0f;
        }

        public void setIteratingForward(boolean bl) {
            this.m_forward = bl;
        }

        public boolean isIteratingForward() {
            return this.m_forward;
        }

        public Object skip(int n) {
            if (this.m_forward) {
                this.m_value = (float)((double)this.m_value + 0.01 * (double)n);
                return new Float(this.m_value);
            }
            this.m_value = (float)((double)this.m_value - 0.01 * (double)n);
            if (this.m_value < 0.0f) {
                this.m_value = 0.0f;
            }
            return new Float(this.m_value);
        }

        public int remainingElements(int n) {
            return (int)((double)((float)n - this.m_value) / 0.01);
        }

        public void setValue(float f) {
            this.m_value = f;
        }

        public float getValue() {
            return this.m_value;
        }
    }

    class MyNumericSpinBox
    extends SpinBox {
        private MySpinBuddy mySpinBuddy;
        private MySpinBoxModel mySpinBoxModel = null.new MySpinBoxModel();

        MyNumericSpinBox(int n, int n2) {
            this.mySpinBuddy = new MySpinBuddy(this);
            this.setSpinBuddy(this.mySpinBuddy);
            this.setModel(this.mySpinBoxModel);
        }

        public void cleanUp() {
            this.mySpinBuddy.removeFocusListener(this.mySpinBuddy);
            this.mySpinBuddy = null;
            this.mySpinBoxModel = null;
        }

        public void setDecimalSeparator(char c) {
            NumberLocaleDocument numberLocaleDocument = this.mySpinBuddy.getNumberLocaleDocument();
            numberLocaleDocument.setDecimalSeparator(c);
        }

        public Object getValue() {
            if (this.mySpinBoxModel == null) {
                return new Integer(10);
            }
            if (this.getModel() instanceof MySpinBoxModel) {
                return new Double(((MySpinBoxModel)this.getModel()).getValue());
            }
            if (this.getModel() instanceof MySecondSpinBoxModel) {
                return new Double(((MySecondSpinBoxModel)this.getModel()).getValue());
            }
            return new Double(this.mySpinBoxModel.getValue());
        }

        public void setValue(float f) {
            if (this.mySpinBoxModel == null) {
                return;
            }
            if (this.getModel() instanceof MySpinBoxModel) {
                ((MySpinBoxModel)this.getModel()).setValue(f);
            } else if (this.getModel() instanceof MySecondSpinBoxModel) {
                ((MySecondSpinBoxModel)this.getModel()).setValue(f);
            } else {
                this.mySpinBoxModel.setValue(f);
            }
            super.spinButtonSpinning(new SpinButtonEvent((Object)this, 1, 2));
            super.spinButtonSpinning(new SpinButtonEvent((Object)this, 1, 1));
        }

        public void setValue(float f, boolean bl) {
            if (this.mySpinBoxModel == null) {
                return;
            }
            if (this.getModel() instanceof MySpinBoxModel) {
                ((MySpinBoxModel)this.getModel()).setValue(f);
            } else if (this.getModel() instanceof MySecondSpinBoxModel) {
                ((MySecondSpinBoxModel)this.getModel()).setValue(f);
            } else {
                this.mySpinBoxModel.setValue(f);
            }
        }

        public void spinButtonSpinning(SpinButtonEvent spinButtonEvent) {
            String string = this.mySpinBuddy.getText();
            if (string.endsWith("\"")) {
                string = string.substring(0, string.length() - 1);
            }
            Float f = null;
            try {
                f = this.mySpinBuddy.parseAsFloat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (f != null) {
                this.setValue(f.floatValue());
            }
            super.spinButtonSpinning(spinButtonEvent);
            this.firePropertyChange("change", 0, 1);
        }
    }
}

