/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.HorizontalAlignment;
import oracle.dss.dataView.PageItemComponentHandle;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;

public class HorizontalAlignmentTool
extends JToolBar
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_FONT_ALIGNMENT = "FontAlignment";
    protected Object m_selectedObject;
    protected ComponentHandle m_selectedComponentHandle;
    protected UIDataview m_currentDataview;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    protected JToggleButton m_alignLeft;
    protected JToggleButton m_alignCenter;
    protected JToggleButton m_alignRight;
    protected JToggleButton m_alignDefault;
    protected JToggleButton m_none;
    private ResourceBundle rBundle;
    private boolean m_enable = true;
    protected boolean m_bRolloverIconEnabled;
    private MouseListener m_mouseListener;
    private MouseListener m_mouseFocusListener;
    private boolean m_bSuperCalled = true;

    public HorizontalAlignmentTool() {
        this.updateResourceBundle(Locale.getDefault());
        this.setBorder(null);
        this.m_alignLeft = new JToggleButton(this.makeImage("images/left_18t.gif"));
        this.m_alignLeft.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignLeft.getIcon()).getImage())));
        this.m_alignLeft.setMargin(insets0);
        this.m_alignLeft.setEnabled(false);
        this.m_alignLeft.addActionListener(this);
        this.m_alignLeft.setBorderPainted(false);
        this.m_alignCenter = new JToggleButton(this.makeImage("images/center_18t.gif"));
        this.m_alignCenter.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignCenter.getIcon()).getImage())));
        this.m_alignCenter.setEnabled(false);
        this.m_alignCenter.setMargin(insets0);
        this.m_alignCenter.addActionListener(this);
        this.m_alignCenter.setBorderPainted(false);
        this.m_alignRight = new JToggleButton(this.makeImage("images/right_18t.gif"));
        this.m_alignRight.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignRight.getIcon()).getImage())));
        this.m_alignRight.setEnabled(false);
        this.m_alignRight.setMargin(insets0);
        this.m_alignRight.addActionListener(this);
        this.m_alignRight.setBorderPainted(false);
        this.m_alignDefault = new JToggleButton(this.makeImage("images/start.gif"));
        this.m_alignDefault.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignDefault.getIcon()).getImage())));
        this.m_alignDefault.setEnabled(false);
        this.m_alignDefault.setMargin(insets0);
        this.m_alignDefault.addActionListener(this);
        this.m_alignDefault.setBorderPainted(false);
        this.m_alignLeft.setToolTipText(this.rBundle.getString("AL_Left"));
        this.m_alignCenter.setToolTipText(this.rBundle.getString("AL_Center"));
        this.m_alignRight.setToolTipText(this.rBundle.getString("AL_Right"));
        this.m_alignDefault.setToolTipText(this.rBundle.getString("AL_Start"));
        this.add(this.m_alignLeft);
        this.add(this.m_alignCenter);
        this.add(this.m_alignRight);
        this.add(this.m_alignDefault);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_alignLeft);
        buttonGroup.add(this.m_alignCenter);
        buttonGroup.add(this.m_alignRight);
        buttonGroup.add(this.m_alignDefault);
        this.m_none = new JToggleButton();
        buttonGroup.add(this.m_none);
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.m_mouseListener = new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!HorizontalAlignmentTool.this.isRolloverIconEnabled()) {
                        ((JToggleButton)mouseEvent.getSource()).setBorderPainted(true);
                    }
                    if (!HorizontalAlignmentTool.this.m_alignCenter.isEnabled()) {
                        ((JToggleButton)mouseEvent.getSource()).setBorderPainted(((JToggleButton)mouseEvent.getSource()).isSelected());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (!HorizontalAlignmentTool.this.isRolloverIconEnabled()) {
                        ((JToggleButton)mouseEvent.getSource()).setBorderPainted(((JToggleButton)mouseEvent.getSource()).isSelected());
                    }
                }
            };
            this.m_alignCenter.setPreferredSize(new Dimension(24, 24));
            this.m_alignCenter.setMinimumSize(this.m_alignCenter.getPreferredSize());
            this.m_alignCenter.setMaximumSize(this.m_alignCenter.getPreferredSize());
            this.m_alignCenter.addMouseListener(this.m_mouseListener);
            this.m_alignLeft.setPreferredSize(new Dimension(24, 24));
            this.m_alignLeft.setMinimumSize(this.m_alignLeft.getPreferredSize());
            this.m_alignLeft.setMaximumSize(this.m_alignLeft.getPreferredSize());
            this.m_alignLeft.addMouseListener(this.m_mouseListener);
            this.m_alignRight.setPreferredSize(new Dimension(24, 24));
            this.m_alignRight.setMinimumSize(this.m_alignRight.getPreferredSize());
            this.m_alignRight.setMaximumSize(this.m_alignRight.getPreferredSize());
            this.m_alignRight.addMouseListener(this.m_mouseListener);
            this.m_alignDefault.setPreferredSize(new Dimension(24, 24));
            this.m_alignDefault.setMinimumSize(this.m_alignDefault.getPreferredSize());
            this.m_alignDefault.setMaximumSize(this.m_alignDefault.getPreferredSize());
            this.m_alignDefault.addMouseListener(this.m_mouseListener);
        } else {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getSource() == HorizontalAlignmentTool.this.m_alignLeft) {
                        HorizontalAlignmentTool.this.m_alignLeft.getParent().requestFocus();
                    } else if (mouseEvent.getSource() == HorizontalAlignmentTool.this.m_alignCenter) {
                        HorizontalAlignmentTool.this.m_alignCenter.getParent().requestFocus();
                    } else if (mouseEvent.getSource() == HorizontalAlignmentTool.this.m_alignRight) {
                        HorizontalAlignmentTool.this.m_alignRight.getParent().requestFocus();
                    } else if (mouseEvent.getSource() == HorizontalAlignmentTool.this.m_alignDefault) {
                        HorizontalAlignmentTool.this.m_alignDefault.getParent().requestFocus();
                    }
                }
            };
            this.m_alignLeft.addMouseListener(mouseAdapter);
            this.m_alignCenter.addMouseListener(mouseAdapter);
            this.m_alignRight.addMouseListener(mouseAdapter);
            this.m_alignDefault.addMouseListener(mouseAdapter);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this.m_alignLeft.setToolTipText(this.rBundle.getString("AL_Left"));
        this.m_alignCenter.setToolTipText(this.rBundle.getString("AL_Center"));
        this.m_alignRight.setToolTipText(this.rBundle.getString("AL_Right"));
        this.m_alignDefault.setToolTipText(this.rBundle.getString("AL_Start"));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        if (uIDataview == null) {
            return;
        }
        this.m_currentDataview = uIDataview;
        if (controllerEvent == null) {
            return;
        }
        if (controllerEvent.getComponentHandle() == null || this.m_currentDataview instanceof GraphAttribute && controllerEvent.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
            this.m_alignLeft.setEnabled(false);
            this.m_alignCenter.setEnabled(false);
            this.m_alignRight.setEnabled(false);
            this.m_alignDefault.setEnabled(false);
            return;
        }
        Object object = controllerEvent.getComponentHandle().getComponent();
        this.m_enable = false;
        if (this.isEnabled(controllerEvent.getComponentHandle())) {
            this.m_selectedObject = object;
            this.m_selectedComponentHandle = controllerEvent.getComponentHandle();
            this.m_alignLeft.setEnabled(true);
            this.m_alignCenter.setEnabled(true);
            this.m_alignRight.setEnabled(true);
            this.m_alignDefault.setEnabled(true);
            switch (this.getHorizontalAlignment()) {
                case 2: {
                    this.m_alignLeft.setSelected(true);
                    break;
                }
                case 0: {
                    this.m_alignCenter.setSelected(true);
                    break;
                }
                case 10: {
                    this.m_alignDefault.setSelected(true);
                    break;
                }
                default: {
                    this.m_alignRight.setSelected(true);
                }
            }
            this.m_alignLeft.setBorderPainted(this.m_alignLeft.isSelected());
            this.m_alignRight.setBorderPainted(this.m_alignRight.isSelected());
            this.m_alignCenter.setBorderPainted(this.m_alignCenter.isSelected());
            this.m_alignDefault.setBorderPainted(this.m_alignDefault.isSelected());
        } else {
            this.m_alignLeft.setEnabled(false);
            this.m_alignCenter.setEnabled(false);
            this.m_alignRight.setEnabled(false);
            this.m_alignDefault.setEnabled(false);
            this.m_selectedObject = null;
        }
        this.m_enable = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null || !this.m_enable) {
            return;
        }
        if (actionEvent.getSource() == this.m_alignCenter) {
            this.setHorizontalAlignment(0);
            this.m_alignCenter.setSelected(true);
        } else if (actionEvent.getSource() == this.m_alignRight) {
            this.setHorizontalAlignment(4);
            this.m_alignRight.setSelected(true);
        } else if (actionEvent.getSource() == this.m_alignLeft) {
            this.setHorizontalAlignment(2);
            this.m_alignLeft.setSelected(true);
        } else if (actionEvent.getSource() == this.m_alignDefault) {
            this.setHorizontalAlignment(10);
            this.m_alignDefault.setSelected(true);
        }
        this.m_alignLeft.setBorderPainted(this.m_alignLeft.isSelected());
        this.m_alignRight.setBorderPainted(this.m_alignRight.isSelected());
        this.m_alignCenter.setBorderPainted(this.m_alignCenter.isSelected());
        this.m_alignDefault.setBorderPainted(this.m_alignDefault.isSelected());
    }

    public void update() {
        this.m_alignLeft.setEnabled(this.isEnabled());
        this.m_alignCenter.setEnabled(this.isEnabled());
        this.m_alignRight.setEnabled(this.isEnabled());
        this.m_alignDefault.setEnabled(this.isEnabled());
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)string));
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void cleanUp() {
        this.m_alignLeft.removeActionListener(this);
        this.m_alignCenter.removeActionListener(this);
        this.m_alignRight.removeActionListener(this);
        this.m_alignDefault.removeActionListener(this);
        this.m_alignLeft.removeMouseListener(this.m_mouseListener);
        this.m_alignCenter.removeMouseListener(this.m_mouseListener);
        this.m_alignRight.removeMouseListener(this.m_mouseListener);
        this.m_alignDefault.removeMouseListener(this.m_mouseListener);
        if (this.m_mouseFocusListener != null) {
            this.m_alignLeft.removeMouseListener(this.m_mouseFocusListener);
            this.m_alignCenter.removeMouseListener(this.m_mouseFocusListener);
            this.m_alignRight.removeMouseListener(this.m_mouseFocusListener);
            this.m_alignDefault.removeMouseListener(this.m_mouseFocusListener);
        }
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
        if (bl) {
            this.m_alignLeft.setIcon(this.makeImage("images/left.gif"));
            this.m_alignCenter.setIcon(this.makeImage("images/center.gif"));
            this.m_alignRight.setIcon(this.makeImage("images/right.gif"));
            this.m_alignDefault.setIcon(this.makeImage("images/start.gif"));
            this.m_alignLeft.setRolloverIcon(this.makeImage("images/l_left.gif"));
            this.m_alignLeft.setRolloverSelectedIcon(this.makeImage("images/l_left.gif"));
            this.m_alignCenter.setRolloverIcon(this.makeImage("images/l_center.gif"));
            this.m_alignCenter.setRolloverSelectedIcon(this.makeImage("images/l_center.gif"));
            this.m_alignRight.setRolloverIcon(this.makeImage("images/l_right.gif"));
            this.m_alignRight.setRolloverSelectedIcon(this.makeImage("images/l_right.gif"));
            this.m_alignDefault.setRolloverIcon(this.makeImage("images/l_start.gif"));
            this.m_alignDefault.setRolloverSelectedIcon(this.makeImage("images/l_start.gif"));
        } else {
            this.m_alignLeft.setIcon(this.makeImage("images/left_18t.gif"));
            this.m_alignCenter.setIcon(this.makeImage("images/center_18t.gif"));
            this.m_alignRight.setIcon(this.makeImage("images/right_18t.gif"));
            this.m_alignDefault.setIcon(this.makeImage("images/start.gif"));
            this.m_alignLeft.setRolloverIcon(null);
            this.m_alignLeft.setRolloverSelectedIcon(null);
            this.m_alignCenter.setRolloverIcon(null);
            this.m_alignCenter.setRolloverSelectedIcon(null);
            this.m_alignRight.setRolloverIcon(null);
            this.m_alignRight.setRolloverSelectedIcon(null);
            this.m_alignDefault.setRolloverIcon(null);
            this.m_alignDefault.setRolloverSelectedIcon(null);
        }
        this.m_alignLeft.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignLeft.getIcon()).getImage())));
        this.m_alignRight.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignRight.getIcon()).getImage())));
        this.m_alignCenter.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignCenter.getIcon()).getImage())));
        this.m_alignDefault.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_alignDefault.getIcon()).getImage())));
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isEnabled(ComponentHandle componentHandle) {
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && componentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        return componentHandle.getComponent() instanceof HorizontalAlignment && this.isEnabled();
    }

    private int getHorizontalAlignment() {
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            return ((DataviewTitles)this.m_selectedObject).getHorizontalAlignment();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getHorizontalAlignment();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getHorizontalAlignment();
        }
        if (this.m_selectedObject instanceof HorizontalAlignment) {
            return ((HorizontalAlignment)this.m_selectedObject).getHorizontalAlignment();
        }
        return 0;
    }

    private void setHorizontalAlignment(int n) {
        int n2 = this.getHorizontalAlignment();
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            ((DataviewTitles)this.m_selectedObject).setHorizontalAlignment(n);
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setHorizontalAlignment(n);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setHorizontalAlignment(n);
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof HorizontalAlignment) {
            ((HorizontalAlignment)this.m_selectedObject).setHorizontalAlignment(n);
        } else {
            return;
        }
        this.firePropertyChange(PROPERTY_FONT_ALIGNMENT, n2, n);
    }
}

