/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.PageItemComponentHandle;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;

public class FontNameTool
extends JToolBar
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_FONT_NAME = "FontName";
    protected Object m_selectedObject;
    protected ComponentHandle m_selectedComponentHandle;
    protected UIDataview m_currentDataview;
    protected boolean m_flag = true;
    JComboBox m_fontName = new JComboBox();
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    private boolean m_bSuperCalled = true;
    protected boolean m_bRolloverIconEnabled;

    public FontNameTool() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = 0;
        try {
            n = Array.getLength(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        int n2 = 0;
        while (n2 < n) {
            this.m_fontName.addItem(stringArray[n2]);
            ++n2;
        }
        this.m_fontName.setEditable(false);
        this.m_fontName.setEnabled(false);
        n2 = this.m_fontName.getPreferredSize().height;
        this.m_fontName.setMinimumSize(new Dimension(90, n2));
        this.m_fontName.setMaximumSize(new Dimension(90, n2));
        this.m_fontName.setPreferredSize(new Dimension(90, n2));
        this.m_fontName.addActionListener(this);
        this.setMinimumSize(new Dimension(95, n2));
        this.setMaximumSize(new Dimension(95, n2));
        this.setPreferredSize(new Dimension(95, n2));
        this.add(this.m_fontName);
        this.setBorder(null);
        this.updateResourceBundle(Locale.getDefault());
        this.m_fontName.setToolTipText(this.rBundle.getString(PROPERTY_FONT_NAME));
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this.m_fontName.setToolTipText(this.rBundle.getString(PROPERTY_FONT_NAME));
    }

    public void setDefaultName(String string) {
        this.m_fontName.setSelectedItem(string);
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        if (uIDataview == null) {
            return;
        }
        this.m_currentDataview = uIDataview;
        if (controllerEvent == null) {
            return;
        }
        if (controllerEvent.getComponentHandle() == null || this.m_currentDataview instanceof GraphAttribute && controllerEvent.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
            this.m_fontName.setEnabled(false);
            return;
        }
        this.m_flag = false;
        Object object = controllerEvent.getComponentHandle().getComponent();
        if (this.isEnabled(controllerEvent.getComponentHandle())) {
            this.m_selectedObject = object;
            this.m_selectedComponentHandle = controllerEvent.getComponentHandle();
            this.m_fontName.setEnabled(true);
            String string = this.getFontName();
            int n = this.m_fontName.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                if (this.m_fontName.getItemAt(n2).equals(string)) {
                    this.m_fontName.setSelectedIndex(n2);
                    break;
                }
                ++n2;
            }
            if (n2 == n) {
                this.m_fontName.setSelectedIndex(1);
            }
        } else {
            this.m_fontName.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
        this.m_flag = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.m_flag) {
            return;
        }
        if (actionEvent == null) {
            return;
        }
        if (actionEvent.getSource() == this.m_fontName) {
            this.setFontName((String)this.m_fontName.getSelectedItem());
        }
    }

    public void update() {
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)string));
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void cleanUp() {
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isEnabled(ComponentHandle componentHandle) {
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && componentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        return componentHandle.getComponent() instanceof FontAttribute;
    }

    private String getFontName() {
        if (this.m_selectedComponentHandle != null && (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8)) {
            return ((DataviewTitles)this.m_selectedObject).getFont().getName();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getFontName();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getFontName();
        }
        if (this.m_selectedObject instanceof FontAttribute) {
            return ((FontAttribute)this.m_selectedObject).getFont().getName();
        }
        return null;
    }

    private void setFontName(String string) {
        String string2 = this.getFontName();
        if (this.m_selectedComponentHandle != null && (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8)) {
            Font font = ((DataviewTitles)this.m_selectedObject).getFont();
            ((DataviewTitles)this.m_selectedObject).setFont(new Font(string, font.getStyle(), font.getSize()));
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontName(string);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontName(string);
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof FontAttribute) {
            Font font = ((FontAttribute)this.m_selectedObject).getFont();
            ((FontAttribute)this.m_selectedObject).setFont(new Font(string, font.getStyle(), font.getSize()));
        } else {
            return;
        }
        this.firePropertyChange(PROPERTY_FONT_NAME, string2, string);
    }
}

