/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.PageItemComponentHandle;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;

public class BoldFontTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_FONT_BOLD = "FontBold";
    protected Object m_selectedObject;
    protected ComponentHandle m_selectedComponentHandle;
    protected UIDataview m_currentDataview;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    protected boolean m_enable = true;
    protected boolean m_bRolloverIconEnabled;
    private MouseListener m_mouseListener;

    public BoldFontTool() {
        this.addActionListener(this);
        this.setSelected(false);
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/bold_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("BoldFont"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!BoldFontTool.this.isRolloverIconEnabled()) {
                        BoldFontTool.this.setBorderPainted(true);
                    }
                    if (!BoldFontTool.this.isEnabled()) {
                        BoldFontTool.this.setBorderPainted(BoldFontTool.this.isSelected());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (!BoldFontTool.this.isRolloverIconEnabled()) {
                        BoldFontTool.this.setBorderPainted(BoldFontTool.this.isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.setToolTipText(this.rBundle.getString("BoldFont"));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        if (uIDataview == null) {
            return;
        }
        this.m_currentDataview = uIDataview;
        if (controllerEvent == null) {
            return;
        }
        if (controllerEvent.getComponentHandle() == null || this.m_currentDataview instanceof GraphAttribute && controllerEvent.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
            this.setEnabled(false);
            return;
        }
        Object object = controllerEvent.getComponentHandle().getComponent();
        if (this.isEnabled(controllerEvent.getComponentHandle())) {
            this.m_selectedObject = object;
            this.m_selectedComponentHandle = controllerEvent.getComponentHandle();
            this.setEnabled(true);
            this.m_enable = false;
            if (this.getFontBold()) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            this.setBorderPainted(this.isSelected());
            this.m_enable = true;
        } else {
            this.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null || !this.m_enable) {
            return;
        }
        if (actionEvent.getSource() == this) {
            this.setFontBold(this.isSelected());
            this.setBorderPainted(this.isSelected());
        }
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void update() {
    }

    public void cleanUp() {
        this.removeActionListener(this);
        this.removeMouseListener(this.m_mouseListener);
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
        if (bl) {
            this.setIcon(this.makeImage("images/bold.gif"));
            this.setRolloverIcon(this.makeImage("images/l_bold.gif"));
            this.setRolloverSelectedIcon(this.makeImage("images/l_bold.gif"));
        } else {
            this.setIcon(this.makeImage("images/bold_18t.gif"));
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isEnabled(ComponentHandle componentHandle) {
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && componentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        return componentHandle.getComponent() instanceof FontAttribute;
    }

    private boolean getFontBold() {
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            return ((DataviewTitles)this.m_selectedObject).getFont().isBold();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.isFontBold();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.isFontBold();
        }
        if (this.m_selectedObject instanceof FontAttribute) {
            return ((FontAttribute)this.m_selectedObject).getFont().isBold();
        }
        return false;
    }

    private void setFontBold(boolean bl) {
        boolean bl2 = this.getFontBold();
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            Font font = ((DataviewTitles)this.m_selectedObject).getFont();
            int n = font.getStyle();
            n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
            ((DataviewTitles)this.m_selectedObject).setFont(new Font(font.getName(), n, font.getSize()));
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontBold(bl);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontBold(bl);
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof FontAttribute) {
            Font font = ((FontAttribute)this.m_selectedObject).getFont();
            int n = font.getStyle();
            n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
            ((FontAttribute)this.m_selectedObject).setFont(new Font(font.getName(), n, font.getSize()));
        } else {
            return;
        }
        this.firePropertyChange(PROPERTY_FONT_BOLD, bl2, bl);
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)string));
    }
}

