/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class TokenSubstitutionAdapter
implements TokenSubstitution {
    private ResourceBundle rBundle;
    protected Variable[] m_variable;
    protected DataviewCommon m_dataview;
    protected ViewPrinter m_viewprinter;
    protected Locale m_locale;
    protected int m_item;
    protected final String DIMENSION_KEY = "__DIM__";
    protected final String MEMBER_KEY = "__MEM__";
    protected final String DIM_MEM_KEY = "__D&M__";
    protected final String DATE_KEY = "__DATE__";
    protected final String TIME_KEY = "__TIME__";
    protected final String PAGE_KEY = "__PAGE__";
    protected Variable dimension;
    protected Variable member;
    protected Variable dim_mem;
    protected Variable date;
    protected Variable time;
    protected Variable page;
    public static final int DIMENSION = 1;
    public static final int MEMBER = 2;
    public static final int DIMENSION_MEMBER = 4;
    public static final int DATE = 8;
    public static final int TIME = 16;
    public static final int PAGE = 32;
    public static final int ALL = 63;

    public TokenSubstitutionAdapter(DataviewCommon dataviewCommon) {
        this.m_dataview = dataviewCommon;
        this.m_item = 7;
        this._init();
    }

    public TokenSubstitutionAdapter(ViewPrinter viewPrinter, int n) {
        this.m_viewprinter = viewPrinter;
        this.m_dataview = viewPrinter.getDataview();
        this.m_item = n;
        this._init();
    }

    public String[] getListItems() {
        String[] stringArray = new String[this.m_variable.length];
        int n = 0;
        while (n < this.m_variable.length) {
            stringArray[n] = this.m_variable[n].listItem;
            ++n;
        }
        return stringArray;
    }

    public String getToken(String string) {
        int n = 0;
        while (n < this.m_variable.length) {
            if (this.m_variable[n].listItem.equals(string)) {
                return this.m_variable[n].token;
            }
            ++n;
        }
        return null;
    }

    public String getKeyString(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        String string3 = "";
        String string4 = string;
        String string5 = "";
        String string6 = string;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.m_variable.length) {
            string2 = this.m_variable[n3].token;
            string3 = "";
            while ((n2 = string6.indexOf(string2, 0)) != -1) {
                if (n2 != n) {
                    string3 = String.valueOf(string3) + string6.substring(0, n2);
                }
                string3 = (string5 = string6.substring(n2, n2 + string2.length())).equals(string2) ? String.valueOf(string3) + this.m_variable[n3].key : String.valueOf(string3) + string5;
                string6 = string6.substring(n2 + string2.length());
                bl = true;
            }
            if (bl) {
                string4 = string6 = (string3 = String.valueOf(string3) + string6);
                bl = false;
            }
            ++n3;
        }
        return string4;
    }

    public String getTokenString(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        String string3 = "";
        String string4 = string;
        String string5 = "";
        String string6 = string;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.m_variable.length) {
            string2 = this.m_variable[n3].key;
            string3 = "";
            while ((n2 = string6.indexOf(string2, 0)) != -1) {
                if (n2 != n) {
                    string3 = String.valueOf(string3) + string6.substring(0, n2);
                }
                string3 = (string5 = string6.substring(n2, n2 + string2.length())).equals(string2) ? String.valueOf(string3) + this.m_variable[n3].token : String.valueOf(string3) + string5;
                string6 = string6.substring(n2 + string2.length());
                bl = true;
            }
            if (bl) {
                string4 = string6 = (string3 = String.valueOf(string3) + string6);
                bl = false;
            }
            ++n3;
        }
        return string4;
    }

    public String getParsedString(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        String string3 = "";
        String string4 = string;
        String string5 = "";
        String string6 = string;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.m_variable.length) {
            string2 = this.m_variable[n3].key;
            string3 = "";
            while ((n2 = string6.indexOf(string2, 0)) != -1) {
                if (n2 != n) {
                    string3 = String.valueOf(string3) + string6.substring(0, n2);
                }
                string3 = (string5 = string6.substring(n2, n2 + string2.length())).equals(string2) ? String.valueOf(string3) + this.getParsedKey(string5) : String.valueOf(string3) + string5;
                string6 = string6.substring(n2 + string2.length());
                bl = true;
            }
            if (bl) {
                string4 = string6 = (string3 = String.valueOf(string3) + string6);
                bl = false;
            }
            ++n3;
        }
        return string4;
    }

    public String getKey(String string) {
        return "";
    }

    private String getParsedKey(String string) {
        String string2 = "";
        int n = 0;
        String string3 = ":";
        String string4 = ", ";
        String string5 = ", ";
        String string6 = ", ";
        Object object = null;
        if (string.equals("__PAGE__")) {
            return Integer.toString(this.m_viewprinter.getSequentialPageNumber());
        }
        if (string.equals("__DATE__") || string.equals("__TIME__")) {
            Locale locale = null;
            if (this.m_dataview != null) {
                locale = this.m_dataview.getLocale();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Calendar calendar = null;
            boolean bl = locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0;
            calendar = bl ? new GregorianCalendar(locale) : Calendar.getInstance(locale);
            DateFormat dateFormat = string.equals("__DATE__") ? (DateFormat)DateFormat.getDateInstance(3, locale).clone() : (DateFormat)DateFormat.getTimeInstance(3, locale).clone();
            if (bl) {
                dateFormat.setCalendar(calendar);
            }
            dateFormat.setTimeZone(TimeZone.getDefault());
            return dateFormat.format(calendar.getTime());
        }
        if (string.equals("__D&M__")) {
            Model model = this.m_dataview.getModel();
            if (model == null) {
                return null;
            }
            DataAccess dataAccess = model.getDataAccess();
            if (dataAccess == null) {
                return null;
            }
            String string7 = this.m_dataview.getLayerMetadataLabelType(2);
            String string8 = this.m_dataview.getMemberMetadataLabelType(2);
            boolean bl = this.m_dataview.isLayerMetadataLabelTypeSupported(string7);
            boolean bl2 = this.m_dataview.isMemberMetadataLabelTypeSupported(string8);
            if (bl || bl2) {
                try {
                    n = dataAccess.getLayerCount(2);
                    int[] nArray = dataAccess.getEdgeCurrentHPos(2);
                    int n2 = 0;
                    while (n2 < n) {
                        String string9 = "";
                        if (bl) {
                            object = dataAccess.getLayerMetadata(2, n2, string7);
                        }
                        if (object != null) {
                            string9 = object.toString();
                        }
                        String string10 = "";
                        if (bl2 && nArray != null) {
                            object = dataAccess.getMemberMetadata(2, nArray, n2, nArray[n2], string8);
                            if (object != null) {
                                string10 = object.toString();
                            }
                            string10 = String.valueOf(string3) + string10;
                        }
                        string2 = String.valueOf(string2) + string9 + string10;
                        if (n2 + 1 < n) {
                            string2 = String.valueOf(string2) + string6;
                        }
                        ++n2;
                    }
                }
                catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                    this.m_dataview.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "getParsedVariablesStr");
                    String string11 = null;
                    return string11;
                }
                catch (SliceOutOfRangeException sliceOutOfRangeException) {
                    this.m_dataview.getErrorHandler().error(sliceOutOfRangeException, this.getClass().getName(), "getParsedVariablesStr");
                    String string12 = null;
                    return string12;
                }
                catch (LayerOutOfRangeException layerOutOfRangeException) {
                    this.m_dataview.getErrorHandler().error(layerOutOfRangeException, this.getClass().getName(), "getParsedVariablesStr");
                    String string13 = null;
                    return string13;
                }
            }
        } else {
            String string14 = this.m_dataview.getLayerMetadataLabelType(2);
            boolean bl = this.m_dataview.isLayerMetadataLabelTypeSupported(string14);
            if (string.equals("__DIM__") && bl) {
                Model model = this.m_dataview.getModel();
                if (model == null) {
                    return null;
                }
                DataAccess dataAccess = model.getDataAccess();
                if (dataAccess == null) {
                    return null;
                }
                try {
                    n = dataAccess.getLayerCount(2);
                    int n3 = 0;
                    while (n3 < n) {
                        String string15 = null;
                        object = dataAccess.getLayerMetadata(2, n3, string14);
                        if (object != null) {
                            string15 = object.toString();
                        }
                        string2 = String.valueOf(string2) + string15;
                        if (n3 + 1 < n) {
                            string2 = String.valueOf(string2) + string4;
                        }
                        ++n3;
                    }
                }
                catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                    this.m_dataview.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "getParsedVariablesStr");
                    String string16 = null;
                    return string16;
                }
                catch (LayerOutOfRangeException layerOutOfRangeException) {
                    this.m_dataview.getErrorHandler().error(layerOutOfRangeException, this.getClass().getName(), "getParsedVariablesStr");
                    String string17 = null;
                    return string17;
                }
            }
            String string18 = this.m_dataview.getMemberMetadataLabelType(2);
            boolean bl3 = this.m_dataview.isMemberMetadataLabelTypeSupported(string18);
            if (string.equals("__MEM__") && bl3) {
                Model model = this.m_dataview.getModel();
                if (model == null) {
                    return null;
                }
                DataAccess dataAccess = model.getDataAccess();
                if (dataAccess == null) {
                    return null;
                }
                try {
                    n = dataAccess.getLayerCount(2);
                    int[] nArray = dataAccess.getEdgeCurrentHPos(2);
                    if (nArray != null) {
                        int n4 = 0;
                        while (n4 < n) {
                            String string19 = null;
                            object = dataAccess.getMemberMetadata(2, nArray, n4, nArray[n4], string18);
                            if (object != null) {
                                string19 = object.toString();
                            }
                            string2 = String.valueOf(string2) + string19;
                            if (n4 + 1 < n) {
                                string2 = String.valueOf(string2) + string5;
                            }
                            ++n4;
                        }
                    }
                }
                catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                    this.m_dataview.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "getParsedVariablesStr");
                    String string20 = null;
                    return string20;
                }
                catch (SliceOutOfRangeException sliceOutOfRangeException) {
                    this.m_dataview.getErrorHandler().error(sliceOutOfRangeException, this.getClass().getName(), "getParsedVariablesStr");
                    String string21 = null;
                    return string21;
                }
                catch (LayerOutOfRangeException layerOutOfRangeException) {
                    this.m_dataview.getErrorHandler().error(layerOutOfRangeException, this.getClass().getName(), "getParsedVariablesStr");
                    String string22 = null;
                    return string22;
                }
            }
        }
        return string2;
    }

    private void _init() {
        this.dimension = null.new Variable();
        this.member = null.new Variable();
        this.dim_mem = null.new Variable();
        this.date = null.new Variable();
        this.time = null.new Variable();
        this.page = null.new Variable();
        this.dimension.key = "__DIM__";
        this.member.key = "__MEM__";
        this.dim_mem.key = "__D&M__";
        this.date.key = "__DATE__";
        this.time.key = "__TIME__";
        this.page.key = "__PAGE__";
        this.setLocale(this.m_dataview.getLocale());
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
        this.updateResourceBundle();
        this.localizeVariablesArray();
    }

    public void updateResourceBundle() {
        this.rBundle = this.m_locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle", this.m_locale) : ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle");
    }

    protected void localizeVariablesArray() {
        this.dimension.token = this.m_dataview.getIntlString("&Dimension", this.rBundle);
        this.member.token = this.m_dataview.getIntlString("&Member", this.rBundle);
        this.dim_mem.token = this.m_dataview.getIntlString("&DimMem", this.rBundle);
        this.date.token = this.m_dataview.getIntlString("&Date", this.rBundle);
        this.time.token = this.m_dataview.getIntlString("&Time", this.rBundle);
        this.page.token = this.m_dataview.getIntlString("&Page", this.rBundle);
        this.dimension.listItem = this.m_dataview.getIntlString("Dimension", this.rBundle);
        this.member.listItem = this.m_dataview.getIntlString("Member", this.rBundle);
        this.dim_mem.listItem = this.m_dataview.getIntlString("DimensionMember", this.rBundle);
        this.date.listItem = this.m_dataview.getIntlString("Date", this.rBundle);
        this.time.listItem = this.m_dataview.getIntlString("Time", this.rBundle);
        this.page.listItem = this.m_dataview.getIntlString("Page", this.rBundle);
        Vector<Variable> vector = new Vector<Variable>();
        if ((this.m_item & 1) == 1) {
            vector.addElement(this.dimension);
        }
        if ((this.m_item & 2) == 2) {
            vector.addElement(this.member);
        }
        if ((this.m_item & 4) == 4) {
            vector.addElement(this.dim_mem);
        }
        if ((this.m_item & 8) == 8) {
            vector.addElement(this.date);
        }
        if ((this.m_item & 0x10) == 16) {
            vector.addElement(this.time);
        }
        if ((this.m_item & 0x20) == 32) {
            vector.addElement(this.page);
        }
        this.m_variable = new Variable[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            this.m_variable[n] = (Variable)vector.elementAt(n);
            ++n;
        }
    }

    class Variable {
        public String listItem;
        public String token;
        public String key;

        Variable() {
        }
    }
}

