/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.util.Hashtable;
import oracle.dss.dataView.DataviewAttributes;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class DataviewXML {
    public static final String a_version = "version";
    public static final String a_name = "name";
    public static final String a_localName = "localName";
    public static final String a_description = "description";
    public static final String a_drillingEnabled = "drillingEnabled";
    public static final String a_pagingControlVisible = "pagingControlVisible";
    public static final String a_pagingControlPosition = "pagingControlPosition";
    public static final String a_htmlPagingControlWidth = "htmlPagingControlWidth";
    public static final String a_htmlPagingControlAutosubmit = "htmlPagingControlAutosubmit";
    public static final String a_background = "background";
    public static final String a_foreground = "foreground";
    public static final String a_underline = "underline";
    public static final String a_fontName = "fontName";
    public static final String a_fontSize = "fontSize";
    public static final String a_fontBold = "fontBold";
    public static final String a_fontItalic = "fontItalic";
    public static final String left = "LEFT";
    public static final String center = "CENTER";
    public static final String right = "RIGHT";
    public static final String leading = "LEADING";
    private static final String a_columnLayerMetadataLabelType = "columnLayerMetadataLabelType";
    private static final String a_rowLayerMetadataLabelType = "rowLayerMetadataLabelType";
    private static final String a_pageLayerMetadataLabelType = "pageLayerMetadataLabelType";
    private static final String a_columnMemberMetadataLabelType = "columnMemberMetadataLabelType";
    private static final String a_rowMemberMetadataLabelType = "rowMemberMetadataLabelType";
    private static final String a_pageMemberMetadataLabelType = "pageMemberMetadataLabelType";
    private static final String layer_metadata_longlabel = "LAYER_METADATA_LONGLABEL";
    private static final String layer_metadata_mediumlabel = "LAYER_METADATA_MEDIUMLABEL";
    private static final String layer_metadata_shortlabel = "LAYER_METADATA_SHORTLABEL";
    private static final String layer_metadata_name = "LAYER_METADATA_NAME";
    private static final String metadata_longlabel = "METADATA_LONGLABEL";
    private static final String metadata_mediumlabel = "METADATA_MEDIUMLABEL";
    private static final String metadata_shortlabel = "METADATA_SHORTLABEL";
    private static final String metadata_value = "METADATA_VALUE";
    protected String d_name;
    protected String d_localName;
    protected String d_description;
    protected boolean d_drillingEnabled;
    protected boolean d_pagingControlVisible;
    protected int d_pagingControlPosition;
    protected int d_htmlPagingControlWidth;
    protected boolean d_htmlPagingControlAutosubmit;
    protected String[] d_layerMetadataLabelTypes;
    protected String[] d_memberMetadataLabelTypes;
    private DataviewAttributes _dataview;
    protected Hashtable m_context;

    public DataviewXML(DataviewAttributes dataviewAttributes) {
        this._dataview = dataviewAttributes;
    }

    protected void initDefaults(DataviewDefaultValues dataviewDefaultValues) {
        this.d_name = DataviewDefaultValues.getName();
        this.d_localName = DataviewDefaultValues.getLocalName();
        this.d_description = DataviewDefaultValues.getDescription();
        this.d_drillingEnabled = dataviewDefaultValues.isDrillingEnabled();
        this.d_pagingControlVisible = DataviewDefaultValues.isPagingControlVisible();
        this.d_pagingControlPosition = DataviewDefaultValues.getPagingControlPosition();
        this.d_htmlPagingControlWidth = DataviewDefaultValues.getHTMLPagingControlWidth();
        this.d_htmlPagingControlAutosubmit = DataviewDefaultValues.isHTMLPagingControlAutosubmit();
        this.d_layerMetadataLabelTypes = new String[3];
        this.d_memberMetadataLabelTypes = new String[3];
        int n = 0;
        while (n < 3) {
            this.d_layerMetadataLabelTypes[n] = DataviewDefaultValues.getLayerMetadataLabelType(n);
            this.d_memberMetadataLabelTypes[n] = DataviewDefaultValues.getMemberMetadataLabelType(n);
            ++n;
        }
    }

    public void setContext(Hashtable hashtable) {
        this.m_context = hashtable;
    }

    public void setXML(ObjectNode objectNode) {
        this.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty(a_drillingEnabled);
        if (propertyNode != null) {
            this._dataview.setDrillingEnabled(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty(a_pagingControlVisible)) != null) {
            this._dataview.setPagingControlVisible(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty(a_pagingControlPosition)) != null) {
            String string = propertyNode.getValueAsString();
            if (string.equals("PAGING_CONTROL_ABOVE_TITLES")) {
                this._dataview.setPagingControlPosition(0);
            } else if (string.equals("PAGING_CONTROL_BELOW_TITLES")) {
                this._dataview.setPagingControlPosition(1);
            }
        }
        if ((propertyNode = objectNode.getProperty(a_htmlPagingControlAutosubmit)) != null) {
            this._dataview.setHTMLPagingControlAutosubmit(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty(a_htmlPagingControlWidth)) != null) {
            this._dataview.setHTMLPagingControlWidth(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty(a_columnLayerMetadataLabelType)) != null) {
            this._dataview.setLayerMetadataLabelType(0, this._convertStringToLayerMetadataLabelType(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty(a_rowLayerMetadataLabelType)) != null) {
            this._dataview.setLayerMetadataLabelType(1, this._convertStringToLayerMetadataLabelType(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty(a_pageLayerMetadataLabelType)) != null) {
            this._dataview.setLayerMetadataLabelType(2, this._convertStringToLayerMetadataLabelType(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty(a_columnMemberMetadataLabelType)) != null) {
            this._dataview.setMemberMetadataLabelType(0, this._convertStringToMemberMetadataLabelType(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty(a_rowMemberMetadataLabelType)) != null) {
            this._dataview.setMemberMetadataLabelType(1, this._convertStringToMemberMetadataLabelType(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty(a_pageMemberMetadataLabelType)) != null) {
            this._dataview.setMemberMetadataLabelType(2, this._convertStringToMemberMetadataLabelType(propertyNode.getValueAsString()));
        }
    }

    public ObjectNode getObjectNode(ObjectNode objectNode, boolean bl) {
        boolean bl2 = this.getStyleXML(bl, objectNode);
        if (bl || this._dataview.isDrillingEnabled() != this.d_drillingEnabled) {
            objectNode.addProperty(a_drillingEnabled, this._dataview.isDrillingEnabled());
            bl2 = true;
        }
        if (bl || this.d_pagingControlVisible != this._dataview.isPagingControlVisible()) {
            objectNode.addProperty(a_pagingControlVisible, this._dataview.isPagingControlVisible());
            bl2 = true;
        }
        if (bl || this._dataview.getPagingControlPosition() != this.d_pagingControlPosition) {
            int n = this._dataview.getPagingControlPosition();
            if (n == 0) {
                objectNode.addProperty(a_pagingControlPosition, "PAGING_CONTROL_ABOVE_TITLES");
            } else if (n == 1) {
                objectNode.addProperty(a_pagingControlPosition, "PAGING_CONTROL_BELOW_TITLES");
            }
            bl2 = true;
        }
        if (bl || this.d_htmlPagingControlAutosubmit != this._dataview.isHTMLPagingControlAutosubmit()) {
            objectNode.addProperty(a_htmlPagingControlAutosubmit, this._dataview.isHTMLPagingControlAutosubmit());
            bl2 = true;
        }
        if (bl || this.d_htmlPagingControlWidth != this._dataview.getHTMLPagingControlWidth()) {
            objectNode.addProperty(a_htmlPagingControlWidth, this._dataview.getHTMLPagingControlWidth());
            bl2 = true;
        }
        String string = this._dataview.getLayerMetadataLabelType(0);
        if (bl || !string.equals(this.d_layerMetadataLabelTypes[0])) {
            objectNode.addProperty(a_columnLayerMetadataLabelType, this._convertLayerMetadataLabelTypeToString(string));
            bl2 = true;
        }
        string = this._dataview.getLayerMetadataLabelType(1);
        if (bl || !string.equals(this.d_layerMetadataLabelTypes[1])) {
            objectNode.addProperty(a_rowLayerMetadataLabelType, this._convertLayerMetadataLabelTypeToString(string));
            bl2 = true;
        }
        string = this._dataview.getLayerMetadataLabelType(2);
        if (bl || !string.equals(this.d_layerMetadataLabelTypes[2])) {
            objectNode.addProperty(a_pageLayerMetadataLabelType, this._convertLayerMetadataLabelTypeToString(string));
            bl2 = true;
        }
        string = this._dataview.getMemberMetadataLabelType(0);
        if (bl || !string.equals(this.d_memberMetadataLabelTypes[0])) {
            objectNode.addProperty(a_columnMemberMetadataLabelType, this._convertMemberMetadataLabelTypeToString(string));
            bl2 = true;
        }
        string = this._dataview.getMemberMetadataLabelType(1);
        if (bl || !string.equals(this.d_memberMetadataLabelTypes[1])) {
            objectNode.addProperty(a_rowMemberMetadataLabelType, this._convertMemberMetadataLabelTypeToString(string));
            bl2 = true;
        }
        string = this._dataview.getMemberMetadataLabelType(2);
        if (bl || !string.equals(this.d_memberMetadataLabelTypes[2])) {
            objectNode.addProperty(a_pageMemberMetadataLabelType, this._convertMemberMetadataLabelTypeToString(string));
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    public void resetDataviewXML() {
        this.resetStyleDataviewXML();
        this._dataview.setDrillingEnabled(this.d_drillingEnabled);
        this._dataview.setPagingControlVisible(this.d_pagingControlVisible);
        this._dataview.setPagingControlPosition(this.d_pagingControlPosition);
        this._dataview.setHTMLPagingControlAutosubmit(this.d_htmlPagingControlAutosubmit);
        this._dataview.setHTMLPagingControlWidth(this.d_htmlPagingControlWidth);
        int n = 0;
        while (n < 3) {
            this._dataview.setLayerMetadataLabelType(n, this.d_layerMetadataLabelTypes[n]);
            this._dataview.setMemberMetadataLabelType(n, this.d_memberMetadataLabelTypes[n]);
            ++n;
        }
    }

    public void setStyleXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty(a_name);
        if (propertyNode != null) {
            this._dataview.setName(propertyNode.getValueAsString());
        }
        if ((propertyNode = objectNode.getProperty(a_localName)) != null) {
            this._dataview.setLocalName(propertyNode.getValueAsString());
        }
        if ((propertyNode = objectNode.getProperty(a_description)) != null) {
            this._dataview.setDescription(propertyNode.getValueAsString());
        }
    }

    public boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = false;
        if (bl || !this.d_name.equals(this._dataview.getName())) {
            objectNode.addProperty(a_name, this._dataview.getName());
            bl2 = true;
        }
        if (bl || !this.d_localName.equals(this._dataview.getLocalName())) {
            objectNode.addProperty(a_localName, this._dataview.getLocalName());
            bl2 = true;
        }
        if (bl || !this.d_description.equals(this._dataview.getDescription())) {
            objectNode.addProperty(a_description, this._dataview.getDescription());
            bl2 = true;
        }
        return bl2;
    }

    public void resetStyleDataviewXML() {
        this._dataview.setName(this.d_name);
        this._dataview.setLocalName(this.d_localName);
        this._dataview.setDescription(this.d_description);
    }

    private String _convertLayerMetadataLabelTypeToString(String string) {
        if (string.equals("dimShortName")) {
            return layer_metadata_shortlabel;
        }
        if (string.equals("dimMediumName")) {
            return layer_metadata_mediumlabel;
        }
        if (string.equals("dimName")) {
            return layer_metadata_name;
        }
        return layer_metadata_longlabel;
    }

    private String _convertStringToLayerMetadataLabelType(String string) {
        if (string.equals(layer_metadata_shortlabel)) {
            return "dimShortName";
        }
        if (string.equals(layer_metadata_mediumlabel)) {
            return "dimMediumName";
        }
        if (string.equals(layer_metadata_name)) {
            return "dimName";
        }
        return "dimLongName";
    }

    private String _convertMemberMetadataLabelTypeToString(String string) {
        if (string.equals("shortName")) {
            return metadata_shortlabel;
        }
        if (string.equals("mediumName")) {
            return metadata_mediumlabel;
        }
        if (string.equals("value")) {
            return metadata_value;
        }
        return metadata_longlabel;
    }

    private String _convertStringToMemberMetadataLabelType(String string) {
        if (string.equals(metadata_shortlabel)) {
            return "shortName";
        }
        if (string.equals(metadata_mediumlabel)) {
            return "mediumName";
        }
        if (string.equals(metadata_value)) {
            return "value";
        }
        return "longName";
    }
}

