/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoManager;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.Controller;
import oracle.dss.dataView.ControllerListener;
import oracle.dss.dataView.DataListener;
import oracle.dss.dataView.DataviewAttributes;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.DataviewXML;
import oracle.dss.dataView.FontList;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.ModelListener;
import oracle.dss.dataView.PagingControl;
import oracle.dss.dataView.PopupManager;
import oracle.dss.dataView.RolloverTextManager;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.TokenSubstitutionAdapter;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.ViewFocusListener;
import oracle.dss.dataView.ViewKeyListener;
import oracle.dss.dataView.ViewListener;
import oracle.dss.dataView.ViewMouseListener;
import oracle.dss.dataView.ViewMouseMotionListener;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataSource;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.ErrorHandlerCallback;
import oracle.dss.util.WaitData;
import oracle.dss.util.WaitDataAvailableEvent;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.XMLObjectWriter;

public abstract class Dataview
extends JPanel
implements ModelListener,
ErrorHandlerCallback,
ComponentTypeConverter,
Persistable,
DataviewCommon,
UIDataview,
DataviewAttributes {
    private static final boolean DEBUG = false;
    public static final int TITLE = 0;
    public static final int SUBTITLE = 1;
    public static final int FOOTNOTE = 2;
    public static final int PAGE_HEADER = 3;
    public static final int PAGE_ITEM = 4;
    public static final int PAGE_CONTROL = 5;
    public static final int DATAVIEW_TITLE = 6;
    public static final int DATAVIEW_SUBTITLE = 7;
    public static final int DATAVIEW_FOOTNOTE = 8;
    protected static final int DATAVIEW_END = 9;
    protected transient PersistableAttributes m_attrs;
    protected boolean m_bSuperCalled = true;
    private boolean _userOverrideMode;
    private boolean _styleOverrideMode;
    private boolean _styleModified;
    public static final String d_name = DataviewDefaultValues.getName();
    public static final String d_localName = DataviewDefaultValues.getLocalName();
    public static final String d_description = DataviewDefaultValues.getDescription();
    public static final boolean d_pagingControlVisible = DataviewDefaultValues.isPagingControlVisible();
    public static final boolean d_swapAllowed = true;
    public static final String a_name = "name";
    public static final String a_localName = "localName";
    public static final String a_description = "description";
    public static final String a_pagingControlVisible = "pagingControlVisible";
    public static final String a_swapAllowed = "swapAllowed";
    public static final String a_version = "version";
    public static int DEFAULT_ZOOM_FACTOR = 100;
    public static final int MAX_TEXTFIELD_CHARS = 1024;
    protected FontList fontList = new FontList();
    protected String name = DataviewDefaultValues.getName();
    protected String localName = DataviewDefaultValues.getLocalName();
    protected String description = DataviewDefaultValues.getDescription();
    protected EventListenerList listenerList = new EventListenerList();
    protected EventListenerList propertyChangeListenerList = new EventListenerList();
    protected EventListenerList vetoableChangeListenerList = new EventListenerList();
    private Model model;
    private Controller controller;
    protected transient PropertyChangeSupport boundSupport;
    protected transient VetoableChangeSupport vetoSupport;
    protected transient UndoManager undoSupport;
    protected Vector subcomponent = new Vector();
    protected PagingControl pagingControl;
    protected TokenSubstitution m_tokenSubstitution;
    protected transient ErrorHandler m_eh;
    protected WaitData[] m_waitDataForRows;
    protected boolean m_dataUnformattedSupported;
    protected boolean m_dataViewFormatSupported;
    protected boolean m_metaLonglabelSupported;
    protected boolean m_metaMediumlabelSupported;
    protected boolean m_metaShortlabelSupported;
    protected boolean m_metaViewStyleSupported;
    protected boolean m_metaValueSupported;
    protected boolean m_layermetaShortlabelSupported;
    protected boolean m_layermetaMediumlabelSupported;
    protected boolean m_layermetaLonglabelSupported;
    protected boolean m_layermetaNameSupported;
    protected boolean m_layermetaViewStyleSupported;
    protected boolean m_stopRepaints;
    protected boolean m_validate;
    protected boolean m_customColorsEnabled;
    public static final String m_method_setViewStyle = "setViewStyle";
    protected static final String m_method_resetToDefault = "resetToDefault(int reset)";
    protected static final String m_method_readXML = "readXML(InputStream stream, int reset)";
    protected static final String m_method_setXML = "setXML(String xmlString, int reset)";
    protected static final String m_method_setName = "setName(String n)";
    protected static final String m_method_setLocalName = "setLocalName(String n)";
    protected static final String m_method_setDescription = "setDescription(String n)";
    protected static final String m_method_setpagingcontrolposition = "setPagingControlPosition (int loc)";
    private static final String m_method_setMemberMetadataLabelType = "public void setMemberMetadataLabelType(int edge, String type)";
    private static final String m_method_getMemberMetadataLabelType = "public String getMemberMetadataLabelType(int edge)";
    private static final String m_method_setMemberMetadataLabelType_all = "public void setMemberMetadataLabelType(String type)";
    private static final String m_method_setLayerMetadataLabelType = "public void setLayerMetadataLabelType(int edge, String type)";
    private static final String m_method_getLayerMetadataLabelType = "public String getLayerMetadataLabelType(int edge)";
    private static final String m_method_setLayerMetadataLabelType_all = "public void setLayerMetadataLabelType(String type)";
    protected DataviewTitles m_dataviewTitle;
    protected DataviewTitles m_dataviewSubtitle;
    protected DataviewTitles m_dataviewFootnote;
    protected JPanel titlePanel;
    protected int pagingControlPosition = DataviewDefaultValues.getPagingControlPosition();
    protected boolean printOrPreviewMode;
    protected boolean m_htmlPagingControlAutosubmit = DataviewDefaultValues.isHTMLPagingControlAutosubmit();
    protected int m_htmlPagingControlWidth = DataviewDefaultValues.getHTMLPagingControlWidth();
    protected String[] m_memberMetadataLabelTypes;
    protected String[] m_layerMetadataLabelTypes;
    private boolean m_bLoadingDataSourceFromPersistence;
    protected Hashtable m_context;
    public static final String TITLE_NAME = "Title";
    public static final String SUBTITLE_NAME = "Subtitle";
    public static final String FOOTNOTE_NAME = "Footnote";
    public static final String PAGE_HEADER_NAME = "PageHeader";
    public static final String PAGE_ITEM_NAME = "PageItem";
    public static final String PAGING_COMPONENT_NAME = "PagingComponent";
    public static final String DATAVIEW_TITLE_NAME = "DataviewTitle";
    public static final String DATAVIEW_SUBTITLE_NAME = "DataviewSubtitle";
    public static final String DATAVIEW_FOOTNOTE_NAME = "DataviewFootnote";
    public static final String STYLE_MANAGER_NAME = "StyleManager";
    public static final String FORMAT_MANAGER_NAME = "FormatManager";
    public static final String VIEW_FORMAT_NAME = "ViewFormat";
    public static final String VIEW_STYLE_NAME = "ViewStyle";
    public static final String page_header = "PAGE_HEADER";
    public static final int RESET_MIN = 0;
    public static final int RESET_NONE = 0;
    public static final int RESET_XML_PROPERTIES = 1;
    public static final int RESET_EVERYTHING = 2;
    public static final int RESET_XML_PROPERTIES_ORIGINAL = 1;
    public static final int RESET_EVERYTHING_ORIGINAL = 2;
    public static final int RESET_XML_PROPERTIES_CUSTOM = 3;
    public static final int RESET_EVERYTHING_CUSTOM = 4;
    public static final int RESET_MAX = 4;
    public static final String above_title = "PAGING_CONTROL_ABOVE_TITLES";
    public static final String below_title = "PAGING_CONTROL_BELOW_TITLES";
    public static final int VIEW_TYPE_CROSSTAB = 0;
    public static final int VIEW_TYPE_GRAPH = 1;
    public static final int VIEW_TYPE_TABLE = 2;
    public static final int PAGING_CONTROL_ABOVE_TITLES = 0;
    public static final int PAGING_CONTROL_BELOW_TITLES = 1;
    ResourceBundle dvStrings;

    public Dataview() {
        super(new BorderLayout());
        this.boundSupport = new PropertyChangeSupport(this);
        this.vetoSupport = new VetoableChangeSupport(this);
        this.undoSupport = new UndoManager();
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        if (Beans.isDesignTime()) {
            defaultErrorHandler.setDebugMode(6);
        }
        this.addErrorHandler(defaultErrorHandler);
        this.m_memberMetadataLabelTypes = new String[3];
        this.m_layerMetadataLabelTypes = new String[3];
        int n = 0;
        while (n < 3) {
            this.m_memberMetadataLabelTypes[n] = DataviewDefaultValues.getMemberMetadataLabelType(n);
            this.m_layerMetadataLabelTypes[n] = DataviewDefaultValues.getLayerMetadataLabelType(n);
            ++n;
        }
        this.updateResourceBundle();
    }

    public void setPagingControlPosition(int n) {
        if (n != 0 && n != 1) {
            this.getErrorHandler().log("incorrect paging control position", this.getClass().getName(), m_method_setpagingcontrolposition);
            return;
        }
        this.pagingControlPosition = n;
        if (this.getTitlePanel() == null) {
            return;
        }
        boolean bl = false;
        Component[] componentArray = this.getTitlePanel().getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] instanceof PagingControl) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            Component[] componentArray2 = this.getComponents();
            int n3 = 0;
            while (n3 < componentArray2.length) {
                if (componentArray2[n3] instanceof PagingControl) {
                    this.remove(componentArray2[n3]);
                    this.add((Component)this.getTitlePanel(), "North");
                    bl = true;
                }
                ++n3;
            }
        }
        if (bl) {
            this.getTitlePanel().setVisible(false);
            this.getTitlePanel().removeAll();
            this.positionPagingControl(n);
            this.getTitlePanel().setVisible(true);
        }
    }

    public int getPagingControlPosition() {
        return this.pagingControlPosition;
    }

    public void setInsertCallBack(TokenSubstitution tokenSubstitution) {
        this.setTokenSubstitution(tokenSubstitution);
    }

    public TokenSubstitution getInsertCallBack() {
        return this.getTokenSubstitution();
    }

    public void setTokenSubstitution(TokenSubstitution tokenSubstitution) {
        this.m_tokenSubstitution = tokenSubstitution;
    }

    public TokenSubstitution getTokenSubstitution() {
        if (this.m_tokenSubstitution == null) {
            this.m_tokenSubstitution = new TokenSubstitutionAdapter(this);
        }
        return this.m_tokenSubstitution;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.model != null) {
            DataSource dataSource2 = this.model.getDataSource();
            this.model.setDataSource(dataSource);
            this.firePropertyChange(this, "DataSource", dataSource2, dataSource);
        }
    }

    public DataSource getDataSource() {
        if (this.model != null) {
            return this.model.getDataSource();
        }
        return null;
    }

    public DataviewTitles getDataviewTitle() {
        if (this.m_dataviewTitle == null) {
            this.createTitles();
        }
        return this.m_dataviewTitle;
    }

    public DataviewTitles getDataviewSubtitle() {
        if (this.m_dataviewSubtitle == null) {
            this.createTitles();
        }
        return this.m_dataviewSubtitle;
    }

    public DataviewTitles getDataviewFootnote() {
        if (this.m_dataviewFootnote == null) {
            this.createTitles();
        }
        return this.m_dataviewFootnote;
    }

    public void setDataDirector(DataDirector dataDirector) {
        if (this.model != null) {
            this.model.setDataDirector(dataDirector);
        }
    }

    public DataDirector getDataDirector() {
        if (this.model != null) {
            return this.model.getDataDirector();
        }
        return null;
    }

    public void addControllerListener(ControllerListener controllerListener) {
        if (this.controller != null) {
            this.controller.addControllerListener(controllerListener);
        }
    }

    public void removeControllerListener(ControllerListener controllerListener) {
        if (this.controller != null) {
            this.controller.removeControllerListener(controllerListener);
        }
    }

    public void addDataListener(DataListener dataListener) {
        if (this.model != null) {
            this.model.addDataListener(dataListener);
        }
    }

    public void removeDataListener(DataListener dataListener) {
        if (this.model != null) {
            this.model.removeDataListener(dataListener);
        }
    }

    public void addErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.m_eh = errorHandler;
            if (this.getModel() != null) {
                this.getModel().setErrorHandler(errorHandler);
            }
        }
    }

    public void removeErrorHandler() {
        DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
        if (Beans.isDesignTime()) {
            defaultErrorHandler.setDebugMode(6);
        }
        this.addErrorHandler(defaultErrorHandler);
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void addViewMouseListener(ViewMouseListener viewMouseListener) {
        if (this.controller != null) {
            this.controller.addViewMouseListener(viewMouseListener);
        }
    }

    public void removeViewMouseListener(ViewMouseListener viewMouseListener) {
        if (this.controller != null) {
            this.controller.removeViewMouseListener(viewMouseListener);
        }
    }

    public void addViewMouseMotionListener(ViewMouseMotionListener viewMouseMotionListener) {
        if (this.controller != null) {
            this.controller.addViewMouseMotionListener(viewMouseMotionListener);
        }
    }

    public void removeViewMouseMotionListener(ViewMouseMotionListener viewMouseMotionListener) {
        if (this.controller != null) {
            this.controller.removeViewMouseMotionListener(viewMouseMotionListener);
        }
    }

    public void addViewKeyListener(ViewKeyListener viewKeyListener) {
        if (this.controller != null) {
            this.controller.addViewKeyListener(viewKeyListener);
        }
    }

    public void removeViewKeyListener(ViewKeyListener viewKeyListener) {
        if (this.controller != null) {
            this.controller.removeViewKeyListener(viewKeyListener);
        }
    }

    public void addViewFocusListener(ViewFocusListener viewFocusListener) {
        if (this.controller != null) {
            this.controller.addViewFocusListener(viewFocusListener);
        }
    }

    public void removeViewFocusListener(ViewFocusListener viewFocusListener) {
        if (this.controller != null) {
            this.controller.removeViewFocusListener(viewFocusListener);
        }
    }

    public void addViewListener(ViewListener viewListener) {
        this.listenerList.add(Class.forName("oracle.dss.dataView.ViewListener"), viewListener);
    }

    public void removeViewListener(ViewListener viewListener) {
        this.listenerList.remove(Class.forName("oracle.dss.dataView.ViewListener"), viewListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListenerList.add(Class.forName("java.beans.PropertyChangeListener"), propertyChangeListener);
        this.boundSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListenerList.remove(Class.forName("java.beans.PropertyChangeListener"), propertyChangeListener);
        this.boundSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeListenerList.add(Class.forName("java.beans.VetoableChangeListener"), vetoableChangeListener);
        this.vetoSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeListenerList.remove(Class.forName("java.beans.VetoableChangeListener"), vetoableChangeListener);
        this.vetoSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setXMLValidated(boolean bl) {
        this.m_validate = bl;
    }

    public boolean isXMLValidated() {
        return this.m_validate;
    }

    protected void positionPagingControl(int n) {
        switch (n) {
            case 1: {
                this.getTitlePanel().add((Component)((Title)this.getDataviewTitle()), "North");
                this.getTitlePanel().add((Component)((Subtitle)this.getDataviewSubtitle()), "Center");
                this.getTitlePanel().add((Component)this.pagingControl, "South");
                break;
            }
            default: {
                this.getTitlePanel().add((Component)this.pagingControl, "North");
                this.getTitlePanel().add((Component)((Title)this.getDataviewTitle()), "Center");
                this.getTitlePanel().add((Component)((Subtitle)this.getDataviewSubtitle()), "South");
            }
        }
    }

    protected void firePrintBegin(Object object) {
        DataviewEvent dataviewEvent = new DataviewEvent(object);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ViewListener")) {
                ((ViewListener)objectArray[n + 1]).printBegin(dataviewEvent);
            }
            n -= 2;
        }
    }

    protected void firePrintEnd(Object object) {
        DataviewEvent dataviewEvent = new DataviewEvent(object);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ViewListener")) {
                ((ViewListener)objectArray[n + 1]).printEnd(dataviewEvent);
            }
            n -= 2;
        }
    }

    protected void copyAdornment(BaseTitle baseTitle, BaseTitle baseTitle2) {
    }

    protected Object getComponentFromID(int n) {
        switch (n) {
            case 6: {
                return this.getDataviewTitle();
            }
            case 7: {
                return this.getDataviewSubtitle();
            }
            case 8: {
                return this.getDataviewFootnote();
            }
        }
        return null;
    }

    protected String getNameFromID(int n) {
        switch (n) {
            case 6: {
                return DATAVIEW_TITLE_NAME;
            }
            case 7: {
                return DATAVIEW_SUBTITLE_NAME;
            }
            case 8: {
                return DATAVIEW_FOOTNOTE_NAME;
            }
            case 3: {
                return PAGE_HEADER_NAME;
            }
            case 4: {
                return PAGE_ITEM_NAME;
            }
        }
        return null;
    }

    protected abstract void firePropertyChange(Object var1, String var2, Object var3, Object var4);

    public abstract boolean selectObject(ComponentHandle var1);

    public abstract ComponentHandle getSelectedObject();

    public abstract int getPresentationHeight();

    public abstract int getPresentationWidth();

    public final void setName(String string) {
        if (string == null) {
            this.getErrorHandler().log("invalid name", this.getClass().getName(), m_method_setName);
            return;
        }
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange(this, "Name", string2, this.name);
    }

    public final String getName() {
        return this.name;
    }

    public final void setLocalName(String string) {
        if (string == null) {
            this.getErrorHandler().log("invalid Local name", this.getClass().getName(), m_method_setLocalName);
            return;
        }
        String string2 = this.localName;
        this.localName = string;
        this.firePropertyChange(this, "LocalName", string2, this.localName);
    }

    public final String getLocalName() {
        return this.localName;
    }

    public final void setDescription(String string) {
        if (string == null) {
            this.getErrorHandler().log("invalid Description", this.getClass().getName(), m_method_setDescription);
            return;
        }
        String string2 = this.description;
        this.description = string;
        this.firePropertyChange(this, "Description", string2, this.description);
    }

    public final String getDescription() {
        return this.description;
    }

    public void setDrillingEnabled(boolean bl) {
        if (this.model != null) {
            boolean bl2 = this.model.isDrillingEnabled();
            this.model.setDrillingEnabled(bl);
            this.repaint();
            this.firePropertyChange(this, "DrillingEnabled", new Boolean(bl2), new Boolean(bl));
        }
    }

    public final boolean isDrillingEnabled() {
        if (this.model != null) {
            return this.model.isDrillingEnabled();
        }
        return true;
    }

    public abstract void setStartRow(int var1);

    public abstract int getStartRow();

    public abstract void setStartColumn(int var1);

    public abstract int getStartColumn();

    public void setPopupManager(PopupManager popupManager) {
        if (this.controller == null) {
            return;
        }
        PopupManager popupManager2 = this.controller.getPopupManager();
        this.controller.setPopupManager(popupManager);
        this.firePropertyChange(this, "PopupManager", popupManager2, popupManager);
    }

    public PopupManager getPopupManager() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.getPopupManager();
    }

    public void setRolloverTextManager(RolloverTextManager rolloverTextManager) {
        if (this.controller == null) {
            return;
        }
        RolloverTextManager rolloverTextManager2 = this.controller.getRolloverTextManager();
        this.controller.setRolloverTextManager(rolloverTextManager);
        this.firePropertyChange(this, "RolloverTextManager", rolloverTextManager2, rolloverTextManager);
    }

    public RolloverTextManager getRolloverTextManager() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.getRolloverTextManager();
    }

    protected abstract void refreshData();

    public abstract boolean isPrintOrPreviewMode();

    public void modelDataChanged(DataChangedEvent dataChangedEvent) {
        this.model.setDataAccess(dataChangedEvent.getDataAccess());
        if (dataChangedEvent.isPageDirty()) {
            if (this.getPagingControl() != null) {
                this.getPagingControl().updatePageItems();
            }
        } else if (this.getPagingControl() != null) {
            this.getPagingControl().updateCurrentPage();
        }
        this.refreshData();
    }

    public void modelDataAvailable(DataAvailableEvent dataAvailableEvent) {
        this.model.setDataAccess(dataAvailableEvent.getDataAccess());
        if (this.getPagingControl() != null) {
            this.getPagingControl().updatePageItems();
        }
        this.refreshData();
    }

    public void modelWaitDataAvailable(WaitDataAvailableEvent waitDataAvailableEvent) {
        this.clearWaitDataForAllRows();
        this.repaint();
    }

    public void setWaitDataForRow(int n, WaitData waitData) {
        try {
            if (this.m_waitDataForRows == null) {
                this.m_waitDataForRows = new WaitData[this.model.getDataAccess().getEdgeExtent(1)];
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "setWaitDataForRow");
            this.m_waitDataForRows = new WaitData[0];
        }
        if (n >= 0 && n < this.m_waitDataForRows.length) {
            this.m_waitDataForRows[n] = waitData;
        } else {
            this.getErrorHandler().log("row index out of range", this.getClass().getName(), "setWaitDataForRow");
        }
    }

    public WaitData getWaitDataForRow(int n) {
        if (this.m_waitDataForRows != null) {
            if (n >= 0 && n < this.m_waitDataForRows.length) {
                return this.m_waitDataForRows[n];
            }
            this.getErrorHandler().log("row index out of range", this.getClass().getName(), "getWaitDataForRow");
            return null;
        }
        return null;
    }

    public void clearWaitDataForAllRows() {
        if (this.m_waitDataForRows != null) {
            int n = 0;
            while (n < this.m_waitDataForRows.length) {
                this.m_waitDataForRows[n] = null;
                ++n;
            }
            this.m_waitDataForRows = null;
        }
    }

    public FontList getFontList() {
        return this.fontList;
    }

    public Vector getPhysicalComponents() {
        return this.subcomponent;
    }

    public String getIntlString(String string) {
        return this.getIntlString(string, this.dvStrings);
    }

    public String getIntlString(String string, ResourceBundle resourceBundle) {
        String string2;
        if (resourceBundle == null) {
            return string;
        }
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            this.getErrorHandler().log(String.valueOf(String.valueOf("missing resource \"")) + string + "\" in " + resourceBundle.getClass().getName(), this.getClass().getName(), "getIntlString(String key, ResourceBundle rBundle)");
            String string3 = string;
            return string3;
        }
        return string2;
    }

    public void setModel(Model model) {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        this.model = model;
        this.model.setErrorHandler(this.getErrorHandler());
        this.model.addModelListener(this);
    }

    public Model getModel() {
        return this.model;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public Controller getController() {
        return this.controller;
    }

    public void updatePagingControlStyles() {
        this.getPagingControl().updatePageItemStyles();
    }

    public void metadataStyleChanged() {
        this.updatePagingControlStyles();
    }

    public void dataStyleChanged() {
    }

    public void dataFormatChanged() {
    }

    private void updateResourceBundle() {
        try {
            this.dvStrings = this.getLocale() != null ? ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle", this.getLocale()) : ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle");
        }
        catch (MissingResourceException missingResourceException) {
            this.getErrorHandler().log("missing resource bundle oracle.dss.dataView.resource.DataviewBundle", this.getClass().getName(), "updateResourceBundle()");
            this.dvStrings = null;
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle();
        if (this.m_tokenSubstitution != null) {
            this.m_tokenSubstitution.setLocale(locale);
        }
        if (this.getPagingControl() != null) {
            this.getPagingControl().setLocale(locale);
        }
    }

    public Locale getLocale() {
        try {
            Locale locale = super.getLocale();
            return locale;
        }
        catch (Exception exception) {
            Locale locale = Locale.getDefault();
            return locale;
        }
    }

    public String getXML(boolean bl) {
        XMLObjectWriter xMLObjectWriter = new XMLObjectWriter();
        try {
            xMLObjectWriter.setIndentMode(1);
            xMLObjectWriter.writeObjectNode(this.getObjectNode(bl));
            String string = xMLObjectWriter.toString();
            return string;
        }
        catch (BIIOException bIIOException) {
            this.getErrorHandler().log("oracle.dss.util.xml.BIIOException occured", this.getClass().getName(), "getXML(boolean allProperties)");
            return null;
        }
    }

    public void writeXML(OutputStream outputStream, boolean bl) {
        XMLObjectWriter xMLObjectWriter = new XMLObjectWriter(outputStream);
        try {
            xMLObjectWriter.setIndentMode(1);
            xMLObjectWriter.writeObjectNode(this.getObjectNode(bl));
        }
        catch (BIIOException bIIOException) {
            this.getErrorHandler().log("oracle.dss.util.xml.BIIOException occured", this.getClass().getName(), "writeXML(OutputStream stream, boolean allProperties)");
        }
    }

    protected void addSubcomponent(Object object) {
        this.subcomponent.addElement(object);
    }

    protected ViewComponent getSubcomponent(int n) {
        Enumeration enumeration = this.subcomponent.elements();
        while (enumeration.hasMoreElements()) {
            ViewComponent viewComponent = (ViewComponent)enumeration.nextElement();
            if (n != viewComponent.getID()) continue;
            return viewComponent;
        }
        return null;
    }

    protected ViewComponent getSubcomponent(String string) {
        Enumeration enumeration = this.subcomponent.elements();
        while (enumeration.hasMoreElements()) {
            ViewComponent viewComponent = (ViewComponent)enumeration.nextElement();
            if (!string.equals(viewComponent.getComponentName())) continue;
            return viewComponent;
        }
        return null;
    }

    public PagingControl getPagingControl() {
        return this.pagingControl;
    }

    public void setPagingControlVisible(boolean bl) {
        this.getPagingControl().setVisible(bl);
    }

    public boolean isPagingControlVisible() {
        return this.getPagingControl().isVisible();
    }

    public abstract int getViewType();

    public Font scaleFont(Font font, int n) {
        if (n == DEFAULT_ZOOM_FACTOR) {
            return font;
        }
        int n2 = DataviewUtils.scaleByZoom(font.getSize(), n);
        return this.fontList.getFont(font.getName(), font.getStyle(), n2);
    }

    public int getZoomFactor() {
        return DEFAULT_ZOOM_FACTOR;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.pagingControl != null) {
            this.pagingControl.setEnabled(bl);
        }
    }

    public void setCustomColorsEnabled(boolean bl) {
        this.m_customColorsEnabled = bl;
    }

    public boolean isCustomColorsEnabled() {
        return this.m_customColorsEnabled;
    }

    public int convertComponentTypeToInteger(String string) {
        if (string.equals(page_header)) {
            return 3;
        }
        return -1;
    }

    public String convertComponentTypeToString(int n) {
        if (n == 3) {
            return page_header;
        }
        return null;
    }

    public void resetToDefault() {
        this.resetToDefault(2);
    }

    public void resetToDefault(int n) {
        this.resetToDefault(n, this.getVersion());
    }

    protected void resetToDefault(int n, String string) {
        if (n == 2 || n == 4) {
            int n2;
            Object[] objectArray;
            if (this.listenerList != null) {
                objectArray = this.listenerList.getListenerList();
                n2 = objectArray.length - 2;
                while (n2 >= 0) {
                    if (objectArray[n2] == Class.forName("oracle.dss.dataView.ViewListener")) {
                        this.removeViewListener((ViewListener)objectArray[n2 + 1]);
                        objectArray[n2] = null;
                    }
                    n2 -= 2;
                }
                this.listenerList = new EventListenerList();
            }
            if (this.propertyChangeListenerList != null) {
                objectArray = this.propertyChangeListenerList.getListenerList();
                n2 = objectArray.length - 2;
                while (n2 >= 0) {
                    if (objectArray[n2] == Class.forName("java.beans.PropertyChangeListener")) {
                        this.removePropertyChangeListener((PropertyChangeListener)objectArray[n2 + 1]);
                        objectArray[n2] = null;
                    }
                    n2 -= 2;
                }
                this.propertyChangeListenerList = new EventListenerList();
            }
            if (this.vetoableChangeListenerList != null) {
                objectArray = this.vetoableChangeListenerList.getListenerList();
                n2 = objectArray.length - 2;
                while (n2 >= 0) {
                    if (objectArray[n2] == Class.forName("java.beans.VetoableChangeListener")) {
                        this.removeVetoableChangeListener((VetoableChangeListener)objectArray[n2 + 1]);
                        objectArray[n2] = null;
                    }
                    n2 -= 2;
                }
                this.vetoableChangeListenerList = new EventListenerList();
            }
        }
        if (n < 0 || n > 4) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), m_method_resetToDefault);
            return;
        }
        if (n == 0) {
            this.getErrorHandler().log("attempt to reset to default with argument of RESET_NONE", this.getClass().getName(), m_method_resetToDefault);
            return;
        }
        this.getViewXML().resetDataviewXML();
        ((Title)this.getDataviewTitle()).resetToDefault(n, string);
        ((Subtitle)this.getDataviewSubtitle()).resetToDefault(n, string);
        ((Footnote)this.getDataviewFootnote()).resetToDefault(n, string);
        if (this.getPagingControl() != null) {
            this.getPagingControl().resetToDefault(n);
        }
    }

    public abstract String getVersion();

    public abstract boolean readXML(InputStream var1, int var2) throws BIParseException, BISAXException, BIIOException;

    public abstract boolean setXML(String var1, int var2) throws BIParseException, BISAXException, BIIOException;

    protected void setXML(ObjectNode objectNode) {
        this.getViewXML().setXML(objectNode);
    }

    protected void setStyleXML(ObjectNode objectNode) {
        this.getViewXML().setStyleXML(objectNode);
    }

    public abstract void setSwapAllowed(boolean var1);

    public abstract boolean isSwapAllowed();

    public void cleanUp() {
        this.removeErrorHandler();
    }

    public boolean isDataUnavailable() {
        return this.m_stopRepaints;
    }

    public void initialize(Hashtable hashtable) {
        if (hashtable != null && hashtable.containsKey("persistence_errorhandler")) {
            this.addErrorHandler((ErrorHandler)hashtable.get("persistence_errorhandler"));
        }
        if (hashtable != null && hashtable.containsKey("persistence_locale")) {
            this.setLocale((Locale)hashtable.get("persistence_locale"));
        }
        if (hashtable != null && hashtable.containsKey("migration") && hashtable.containsKey("full_path_to_guid_converter")) {
            this._setXMLContext(hashtable.get("migration"), hashtable.get("full_path_to_guid_converter"));
            this.setContext();
        }
    }

    private void _setXMLContext(Object object, Object object2) {
        ObjectScope objectScope = new ObjectScope();
        objectScope.addObject("migration", object);
        objectScope.addObject("full_path_to_guid_converter", object2);
        XMLContext xMLContext = new XMLContext();
        xMLContext.setScope(objectScope);
        if (this.m_context == null) {
            this.m_context = new Hashtable();
        }
        this.m_context.put("xml_context", xMLContext);
        this.setContext();
    }

    protected abstract void setContext();

    public abstract PersistableAttributes getPersistableAttributes(PersistableAttributes var1);

    public void setPersistableAttributes(PersistableAttributes persistableAttributes) {
        this.m_attrs = persistableAttributes;
    }

    public abstract boolean setXMLAsString(String var1) throws BIPersistenceException;

    public AggregateInfo[] getPersistableComponents() {
        AggregateInfo[] aggregateInfoArray = null;
        DataSource dataSource = this.getDataSource();
        if (dataSource != null && dataSource instanceof Persistable) {
            aggregateInfoArray = new AggregateInfo[]{new AggregateInfo((Persistable)((Object)dataSource), 0)};
        }
        return aggregateInfoArray;
    }

    public void setPersistableComponents(AggregateInfo[] aggregateInfoArray) {
        if (aggregateInfoArray != null) {
            int n = 0;
            while (n < aggregateInfoArray.length) {
                Persistable persistable = aggregateInfoArray[n].getPersistable();
                if (persistable instanceof DataSource) {
                    if (this.getViewType() == 0 || this.getViewType() == 2) {
                        this.setLoadingDataSourceFromPersistence(true);
                    }
                    this.setDataSource((DataSource)((Object)persistable));
                    break;
                }
                ++n;
            }
        }
    }

    public String getXMLAsString() {
        return this.getXML(false);
    }

    protected void setLoadingDataSourceFromPersistence(boolean bl) {
        this.m_bLoadingDataSourceFromPersistence = bl;
    }

    protected boolean isLoadingDataSourceFromPersistence() {
        return this.m_bLoadingDataSourceFromPersistence;
    }

    protected void createTitles() {
        this.m_dataviewTitle = new Title(this);
        this.m_dataviewSubtitle = new Subtitle(this);
        this.m_dataviewFootnote = new Footnote(this);
        this.addSubcomponent(this.m_dataviewTitle);
        this.addSubcomponent(this.m_dataviewSubtitle);
        this.addSubcomponent(this.m_dataviewFootnote);
        if (this.isJavaComponent()) {
            this.titlePanel = new JPanel(new BorderLayout());
            this.add((Component)this.titlePanel, "North");
            this.titlePanel.add((Component)((Title)this.m_dataviewTitle), "North");
            this.titlePanel.add((Component)((Subtitle)this.m_dataviewSubtitle), "Center");
            this.add((Component)((Footnote)this.m_dataviewFootnote), "South");
        }
    }

    protected ObjectNode getObjectNode(ObjectNode objectNode, boolean bl) {
        return this.getViewXML().getObjectNode(objectNode, bl);
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        return this.getViewXML().getStyleXML(bl, objectNode);
    }

    protected abstract ObjectNode getObjectNode(boolean var1);

    protected abstract DataviewXML getViewXML();

    protected void setDataUnformattedSupported(boolean bl) {
        this.m_dataUnformattedSupported = bl;
    }

    public boolean isDataUnformattedSupported() {
        return this.m_dataUnformattedSupported;
    }

    public boolean isDataViewFormatSupported() {
        return this.m_dataViewFormatSupported;
    }

    protected void setMetadataLongLabelSupported(boolean bl) {
        this.m_metaLonglabelSupported = bl;
    }

    public boolean isMetadataLongLabelSupported() {
        return this.m_metaLonglabelSupported;
    }

    protected void setMetadataMediumLabelSupported(boolean bl) {
        this.m_metaMediumlabelSupported = bl;
    }

    public boolean isMetadataMediumLabelSupported() {
        return this.m_metaMediumlabelSupported;
    }

    protected void setMetadataShortLabelSupported(boolean bl) {
        this.m_metaShortlabelSupported = bl;
    }

    public boolean isMetadataShortLabelSupported() {
        return this.m_metaShortlabelSupported;
    }

    public boolean isMetadataViewStyleSupported() {
        return this.m_metaViewStyleSupported;
    }

    protected void setMetadataValueSupported(boolean bl) {
        this.m_metaValueSupported = bl;
    }

    public boolean isMetadataValueSupported() {
        return this.m_metaValueSupported;
    }

    protected void setLayerMetaLongLabelSupported(boolean bl) {
        this.m_layermetaLonglabelSupported = bl;
    }

    public boolean isLayerMetaLongLabelSupported() {
        return this.m_layermetaLonglabelSupported;
    }

    protected void setLayerMetaMediumLabelSupported(boolean bl) {
        this.m_layermetaMediumlabelSupported = bl;
    }

    public boolean isLayerMetaMediumLabelSupported() {
        return this.m_layermetaMediumlabelSupported;
    }

    protected void setLayerMetaShortLabelSupported(boolean bl) {
        this.m_layermetaShortlabelSupported = bl;
    }

    public boolean isLayerMetaShortLabelSupported() {
        return this.m_layermetaShortlabelSupported;
    }

    protected void setLayerMetaNameSupported(boolean bl) {
        this.m_layermetaNameSupported = bl;
    }

    public boolean isLayerMetaNameSupported() {
        return this.m_layermetaNameSupported;
    }

    public void setLayerMetaViewStyleSupported(boolean bl) {
        this.m_layermetaViewStyleSupported = bl;
    }

    public boolean isLayerMetaViewStyleSupported() {
        return this.m_layermetaViewStyleSupported;
    }

    public boolean isMemberMetadataLabelTypeSupported(String string) {
        if (!this._isMemberMetadataLabelTypeValid(string)) {
            return false;
        }
        if (string.equals("shortName")) {
            return this.isMetadataShortLabelSupported();
        }
        if (string.equals("mediumName")) {
            return this.isMetadataMediumLabelSupported();
        }
        if (string.equals("longName")) {
            return this.isMetadataLongLabelSupported();
        }
        if (string.equals("value")) {
            return this.isMetadataValueSupported();
        }
        return false;
    }

    public boolean isLayerMetadataLabelTypeSupported(String string) {
        if (!this._isLayerMetadataLabelTypeValid(string)) {
            return false;
        }
        if (string.equals("dimShortName")) {
            return this.isLayerMetaShortLabelSupported();
        }
        if (string.equals("dimMediumName")) {
            return this.isLayerMetaMediumLabelSupported();
        }
        if (string.equals("dimLongName")) {
            return this.isLayerMetaLongLabelSupported();
        }
        if (string.equals("dimName")) {
            return this.isLayerMetaNameSupported();
        }
        return false;
    }

    protected boolean isJavaComponent() {
        return true;
    }

    public void setHTMLPagingControlAutosubmit(boolean bl) {
        this.m_htmlPagingControlAutosubmit = bl;
    }

    public boolean isHTMLPagingControlAutosubmit() {
        return this.m_htmlPagingControlAutosubmit;
    }

    public void setHTMLPagingControlWidth(int n) {
        this.m_htmlPagingControlWidth = n;
    }

    public int getHTMLPagingControlWidth() {
        return this.m_htmlPagingControlWidth;
    }

    public void setMemberMetadataLabelType(int n, String string) {
        if (!this._isEdgeValid(n)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_setMemberMetadataLabelType);
            return;
        }
        if (!this._isMemberMetadataLabelTypeValid(string)) {
            this.getErrorHandler().log("invalid member metadata label type", this.getClass().getName(), m_method_setMemberMetadataLabelType);
            return;
        }
        this.m_memberMetadataLabelTypes[n] = string;
        this.metadataLabelTypeChanged();
    }

    public String getMemberMetadataLabelType(int n) {
        if (!this._isEdgeValid(n)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getMemberMetadataLabelType);
            return null;
        }
        return this.m_memberMetadataLabelTypes[n];
    }

    public void setLayerMetadataLabelType(int n, String string) {
        if (!this._isEdgeValid(n)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_setLayerMetadataLabelType);
            return;
        }
        if (!this._isLayerMetadataLabelTypeValid(string)) {
            this.getErrorHandler().log("invalid layer metadata label type", this.getClass().getName(), m_method_setLayerMetadataLabelType);
            return;
        }
        this.m_layerMetadataLabelTypes[n] = string;
        this.metadataLabelTypeChanged();
    }

    public String getLayerMetadataLabelType(int n) {
        if (!this._isEdgeValid(n)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getLayerMetadataLabelType);
            return null;
        }
        return this.m_layerMetadataLabelTypes[n];
    }

    public void setMemberMetadataLabelType(String string) {
        if (!this._isMemberMetadataLabelTypeValid(string)) {
            this.getErrorHandler().log("invalid member metadata label type", this.getClass().getName(), m_method_setMemberMetadataLabelType_all);
            return;
        }
        int n = 0;
        while (n < this.m_memberMetadataLabelTypes.length) {
            this.m_memberMetadataLabelTypes[n] = string;
            ++n;
        }
        this.metadataLabelTypeChanged();
    }

    public String getMemberMetadataLabelType() {
        String string = this.m_memberMetadataLabelTypes[0];
        int n = 1;
        while (n < this.m_memberMetadataLabelTypes.length) {
            if (!string.equals(this.m_memberMetadataLabelTypes[n])) {
                return null;
            }
            ++n;
        }
        return string;
    }

    public void setLayerMetadataLabelType(String string) {
        if (!this._isLayerMetadataLabelTypeValid(string)) {
            this.getErrorHandler().log("invalid layer metadata label type", this.getClass().getName(), m_method_setLayerMetadataLabelType_all);
            return;
        }
        int n = 0;
        while (n < this.m_layerMetadataLabelTypes.length) {
            this.m_layerMetadataLabelTypes[n] = string;
            ++n;
        }
        this.metadataLabelTypeChanged();
    }

    public String getLayerMetadataLabelType() {
        String string = this.m_layerMetadataLabelTypes[0];
        int n = 1;
        while (n < this.m_layerMetadataLabelTypes.length) {
            if (!string.equals(this.m_layerMetadataLabelTypes[n])) {
                return null;
            }
            ++n;
        }
        return string;
    }

    protected void metadataLabelTypeChanged() {
        this.getPagingControl().updatePageItems();
        this.repaint();
    }

    private boolean _isEdgeValid(int n) {
        return n == 0 || n == 1 || n == 2;
    }

    private boolean _isMemberMetadataLabelTypeValid(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("longName") || string.equals("mediumName") || string.equals("value") || string.equals("shortName");
    }

    private boolean _isLayerMetadataLabelTypeValid(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("dimLongName") || string.equals("dimMediumName") || string.equals("dimName") || string.equals("dimShortName");
    }

    public BitSet createPropertyOverrideFlags(int n) {
        return new BitSet(n);
    }

    public void setPropertyOverrideFlags(int n, BitSet bitSet, BitSet bitSet2) {
        if (bitSet != null && n >= 0 && n < bitSet.size()) {
            if (this.isUserOverrideMode()) {
                bitSet.set(n);
            }
            if (this.isStyleOverrideMode()) {
                bitSet2.set(n);
            }
            this._styleModified = true;
        }
    }

    public boolean isPropertyOverrideFlag(int n, BitSet bitSet) {
        if (n >= 0 && n < bitSet.size()) {
            return bitSet.get(n);
        }
        return false;
    }

    public void clearPropertyOverrideFlag(int n, BitSet bitSet) {
        if (n >= 0 && n < bitSet.size()) {
            bitSet.clear(n);
        }
    }

    protected void setStyleOverrideMode(boolean bl) {
        this._styleOverrideMode = bl;
    }

    protected boolean isStyleOverrideMode() {
        return this._styleOverrideMode;
    }

    protected boolean isStyleModified() {
        return this._styleModified;
    }

    protected void clearStyleModified() {
        this._styleModified = false;
    }

    protected void setUserOverrideMode(boolean bl) {
        this._userOverrideMode = bl;
    }

    protected boolean isUserOverrideMode() {
        return this._userOverrideMode;
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.createTitles();
        }
        return this.titlePanel;
    }
}

