/*
 * Decompiled with CFR 0.152.
 */
package javax.datamining;

import java.util.Collection;
import java.util.Hashtable;
import javax.datamining.Enum;
import javax.datamining.JDMException;

public class MiningTask
extends Enum {
    private static int nID;
    private static Hashtable enumList;
    private static final String[] names;
    private static final MiningTask[] values;
    public static final MiningTask buildTask;
    public static final MiningTask testTask;
    public static final MiningTask applyTask;
    public static final MiningTask computeStatisticsTask;
    public static final MiningTask exportTask;
    public static final MiningTask importTask;

    private MiningTask(String val) {
        super(val);
        this.setID(nID++);
        enumList.put(val, this);
    }

    public static MiningTask[] values() {
        if (enumList.size() == values.length) {
            return values;
        }
        Collection enums = enumList.values();
        Object[] objects = enums.toArray();
        MiningTask[] values2 = new MiningTask[enumList.size()];
        System.arraycopy(objects, 0, values2, 0, enumList.size());
        return values2;
    }

    public static MiningTask valueOf(String name) throws JDMException {
        MiningTask miningTask = (MiningTask)enumList.get(name);
        return miningTask;
    }

    public static void addExtension(String name) throws JDMException {
        MiningTask miningTask = new MiningTask(name);
        enumList.put(name, miningTask);
    }

    static {
        enumList = new Hashtable();
        names = new String[]{"buildTask", "testTask", "applyTask", "computeStatisticsTask", "exportTask", "importTask"};
        values = new MiningTask[]{new MiningTask(names[0]), new MiningTask(names[1]), new MiningTask(names[2]), new MiningTask(names[3]), new MiningTask(names[4]), new MiningTask(names[5])};
        buildTask = values[0];
        testTask = values[1];
        applyTask = values[2];
        computeStatisticsTask = values[3];
        exportTask = values[4];
        importTask = values[5];
    }
}

