/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import java.io.IOException;
import java.io.InputStream;

public class RC2AlgorithmIdentifier
extends AlgorithmIdentifier {
    private byte[] c;
    private int d;
    private static final byte[] e = new byte[]{-67, 86, -22, -14, -94, -15, -84, 42, -80, -109, -47, -100, 27, 51, -3, -48, 48, 4, -74, -36, 125, -33, 50, 75, -9, -53, 69, -101, 49, -69, 33, 90, 65, -97, -31, -39, 74, 77, -98, -38, -96, 104, 44, -61, 39, 95, -128, 54, 62, -18, -5, -107, 26, -2, -50, -88, 52, -87, 19, -16, -90, 63, -40, 12, 120, 36, -81, 35, 82, -63, 103, 23, -11, 102, -112, -25, -24, 7, -72, 96, 72, -26, 30, 83, -13, -110, -92, 114, -116, 8, 21, 110, -122, 0, -124, -6, -12, 127, -118, 66, 25, -10, -37, -51, 20, -115, 80, 18, -70, 60, 6, 78, -20, -77, 53, 17, -95, -120, -114, 43, -108, -103, -73, 113, 116, -45, -28, -65, 58, -34, -106, 14, -68, 10, -19, 119, -4, 55, 107, 3, 121, -119, 98, -58, -41, -64, -46, 124, 106, -117, 34, -93, 91, 5, 93, 2, 117, -43, 97, -29, 24, -113, 85, 81, -83, 31, 11, 94, -123, -27, -62, 87, 99, -54, 61, 108, -76, -59, -52, 112, -78, -111, 89, 13, 71, 32, -56, 79, 88, -32, 1, -30, 22, 56, -60, 111, 59, 15, 101, 70, -66, 126, 45, 123, -126, -7, 64, -75, 29, 115, -8, -21, 38, -57, -121, -105, 37, 84, -79, 40, -86, -104, -99, -91, 100, 109, 122, -44, 16, -127, 68, -17, 73, -42, -82, 46, -35, 118, 92, 47, -89, 28, -55, 9, 105, -102, -125, -49, 41, 57, -71, -23, 76, -1, 67, -85};
    private static final ASN1ObjectID f = AlgID.RC2_CBC.getOID();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a() throws AlgorithmIdentifierException {
        ASN1Object aSN1Object = this.getParameters();
        if (aSN1Object == null || aSN1Object instanceof ASN1Null) {
            this.d = 0;
            this.c = null;
            return;
        }
        if (aSN1Object instanceof ASN1OctetString) {
            this.d = 0;
            this.c = ((ASN1OctetString)aSN1Object).getValue();
            return;
        }
        if (!(aSN1Object instanceof ASN1Sequence)) return;
        try {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
            int n = ((ASN1Integer)aSN1Sequence.elementAt(0)).intValue();
            if (n < 0) {
                n &= 0xFF;
            }
            if (n >= 256 && n <= 1024) {
                this.d = n;
            } else {
                if (n < 0 || n > 256) throw new AlgorithmIdentifierException("Unknown RC2 parameter version: " + n);
                int n2 = 0;
                while (n2 < 256 && (e[n2] & 0xFF) != n) {
                    ++n2;
                }
                if (n2 >= 256) throw new AlgorithmIdentifierException("Unknown RC2 parameter version: " + n);
                this.d = n2;
            }
            if (aSN1Sequence.elementAt(1) instanceof ASN1OctetString) {
                this.c = ((ASN1OctetString)aSN1Sequence.elementAt(1)).getValue();
                return;
            } else {
                if (!(aSN1Sequence.elementAt(1) instanceof ASN1Null) && aSN1Sequence.elementAt(1) != null) return;
                this.c = null;
            }
            return;
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AlgorithmIdentifierException(arrayIndexOutOfBoundsException.toString());
        }
    }

    private static ASN1Object b(byte[] byArray, int n) {
        if (n == 32 || n == 0) {
            if (byArray == null) {
                return new ASN1Null();
            }
            return new ASN1OctetString(byArray);
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (n >= 0 && n < 256) {
            aSN1Sequence.addElement(new ASN1Integer(e[n] & 0xFF));
        } else if (n >= 256 && n <= 1024) {
            aSN1Sequence.addElement(new ASN1Integer(n));
        } else {
            throw new IllegalArgumentException("Invalid RC2 effective key length: " + n);
        }
        if (byArray == null) {
            aSN1Sequence.addElement(new ASN1Null());
        } else {
            aSN1Sequence.addElement(new ASN1OctetString(byArray));
        }
        return aSN1Sequence;
    }

    public RC2AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) throws AlgorithmIdentifierException {
        super(f, aSN1Object);
        if (!aSN1ObjectID.equals(f)) {
            throw new AlgorithmIdentifierException("Unacceptable OID for RC2ALgorithmIdentifier: " + aSN1ObjectID.toString());
        }
        this.a();
    }

    public byte[] getIV() {
        return this.c;
    }

    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        try {
            this.a();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }

    public RC2AlgorithmIdentifier(int n) {
        this(null, n);
    }

    public Object clone() {
        byte[] byArray = null;
        if (this.c != null) {
            byArray = (byte[])this.c.clone();
        }
        RC2AlgorithmIdentifier rC2AlgorithmIdentifier = new RC2AlgorithmIdentifier(byArray, this.d);
        return rC2AlgorithmIdentifier;
    }

    public int getEffectiveKeyLength() {
        return this.d;
    }

    public RC2AlgorithmIdentifier(byte[] byArray, int n) {
        super(f, RC2AlgorithmIdentifier.b(byArray, n));
        this.c = byArray;
        this.d = n;
    }

    public RC2AlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }
}

