/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.HMAC;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PBMacAlgID;
import com.phaos.crypto.RandomBitsSource;
import java.math.BigInteger;

public class PasswordBasedMAC
extends MessageDigest {
    private byte[] b;
    private byte[] c;
    public static final AlgorithmIdentifier DEFAULT_MAC;
    private int d;
    private AlgorithmIdentifier e;
    public static final int DEFAULT_SALT_LEN = 8;
    private RandomBitsSource f;
    private MessageDigest g;
    private byte[] h;
    public static final int DEFAULT_ITER_COUNT = 1024;
    private MessageDigest i;
    private AlgorithmIdentifier j;
    public static final AlgorithmIdentifier DEFAULT_OWF;

    public void computeCurrent() {
        this.i.computeCurrent();
        System.arraycopy(this.i.digestBits, 0, this.digestBits, 0, this.digestBits.length);
        this.digestValid = true;
    }

    protected void setState(MessageDigest.MDState mDState) {
        throw new RuntimeException("Method setState(MDState) not valid for PasswordBasedMAC class");
    }

    public int getDigestLength() {
        return this.i.getDigestLength();
    }

    public PasswordBasedMAC() {
    }

    public void update(byte[] byArray, int n, int n2) {
        this.i.update(byArray, n, n2);
        this.digestValid = false;
    }

    public void init() {
        try {
            if (this.g == null) {
                this.g = MessageDigest.getInstance(this.e);
            }
            if (this.i == null) {
                this.i = MessageDigest.getInstance(this.j);
                this.digestBits = new byte[this.i.getDigestLength()];
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
        if (this.h == null) {
            this.h = this.a();
            ((HMAC)this.i).setKey(this.h);
        }
        this.i.init();
        this.digestValid = false;
    }

    public byte[] getSalt() {
        return this.c;
    }

    public void setOwfAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.e = algorithmIdentifier;
        this.h = null;
        this.digestValid = false;
    }

    private byte[] a() {
        if (this.c == null) {
            if (this.f == null) {
                this.f = RandomBitsSource.getDefault();
            }
            this.c = new byte[8];
            this.f.randomBytes(this.c);
        }
        byte[] byArray = new byte[this.g.getDigestLength()];
        this.g.init();
        this.g.update(this.b);
        this.g.update(this.c);
        this.g.computeCurrent();
        System.arraycopy(this.g.digestBits, 0, byArray, 0, this.g.digestBits.length);
        int n = 1;
        while (n < this.d) {
            System.arraycopy(this.g.computeDigest(byArray), 0, byArray, 0, this.g.digestBits.length);
            ++n;
        }
        return byArray;
    }

    public void update(byte by) {
        this.i.update(by);
        this.digestValid = false;
    }

    public int getCount() {
        return this.d;
    }

    public PasswordBasedMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        this.setRandomBitsSource(randomBitsSource);
        this.setAlgID(algorithmIdentifier);
        this.setPassword(byArray);
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        this.f = randomBitsSource;
    }

    public PasswordBasedMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws AlgorithmIdentifierException {
        this.setAlgID(algorithmIdentifier);
        this.setPassword(byArray);
    }

    public AlgorithmIdentifier getMacAlgID() {
        return this.j;
    }

    public PasswordBasedMAC(byte[] byArray) throws AlgorithmIdentifierException {
        this(AlgID.PasswordBasedMac, byArray);
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier.getOID();
        if (!aSN1ObjectID.equals(AlgID.PasswordBasedMac.getOID())) {
            throw new AlgorithmIdentifierException("Invalid algorithm OID: " + aSN1ObjectID);
        }
        ASN1Object aSN1Object = algorithmIdentifier.getParameters();
        if (aSN1Object != null) {
            PBMacAlgID pBMacAlgID = new PBMacAlgID(aSN1Object);
            this.c = pBMacAlgID.getSalt();
            this.e = pBMacAlgID.getOwfAlgID();
            this.d = pBMacAlgID.getCount().intValue();
            this.setMacAlgID(pBMacAlgID.getMacAlgID());
            this.algID = pBMacAlgID;
        } else {
            if (this.f != null) {
                this.c = new byte[8];
                this.f.randomBytes(this.c);
            } else {
                this.c = null;
            }
            this.e = DEFAULT_OWF;
            this.d = 1024;
            this.j = DEFAULT_MAC;
        }
        this.h = null;
        this.g = MessageDigest.getInstance(this.e);
        this.i = MessageDigest.getInstance(this.j);
        this.digestBits = new byte[this.i.getDigestLength()];
        this.digestValid = false;
    }

    public Object clone() {
        PasswordBasedMAC passwordBasedMAC = new PasswordBasedMAC();
        passwordBasedMAC.digestBits = (byte[])this.digestBits.clone();
        passwordBasedMAC.digestValid = this.digestValid;
        passwordBasedMAC.c = (byte[])this.c.clone();
        passwordBasedMAC.e = new AlgorithmIdentifier(this.e.getOID(), this.e.getParameters());
        passwordBasedMAC.d = this.d;
        passwordBasedMAC.j = new AlgorithmIdentifier(this.j.getOID(), this.j.getParameters());
        passwordBasedMAC.f = this.f;
        passwordBasedMAC.b = (byte[])this.b.clone();
        passwordBasedMAC.h = (byte[])this.h.clone();
        passwordBasedMAC.g = (MessageDigest)this.g.clone();
        passwordBasedMAC.i = (MessageDigest)this.i.clone();
        return passwordBasedMAC;
    }

    protected MessageDigest.MDState getState() {
        return null;
    }

    static {
        DEFAULT_OWF = AlgID.sha1;
        DEFAULT_MAC = AlgID.hmacSHA;
    }

    public void setCount(int n) {
        this.d = n;
        this.h = null;
        this.digestValid = false;
    }

    public void setMacAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier.getOID();
        if (!aSN1ObjectID.equals(AlgID.hmacSHA.getOID()) && !aSN1ObjectID.equals(AlgID.hmacMD5.getOID())) {
            throw new AlgorithmIdentifierException("Unsupported MAC algorithm: " + aSN1ObjectID);
        }
        this.j = algorithmIdentifier;
    }

    public AlgorithmIdentifier getOwfAlgID() {
        return this.e;
    }

    public AlgorithmIdentifier getAlgID() {
        if (this.algID == null) {
            if (this.c == null && this.f != null) {
                this.c = new byte[8];
                this.f.randomBytes(this.c);
            }
            if (this.c == null || this.e == null || this.d <= 0 || this.j == null) {
                return AlgID.PasswordBasedMac;
            }
            try {
                this.algID = new PBMacAlgID(this.c, this.e, BigInteger.valueOf(this.d), this.j);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        }
        return this.algID;
    }

    public String algName() {
        return "PasswordBasedMac";
    }

    public void setPassword(byte[] byArray) {
        this.b = byArray;
        this.h = null;
        this.digestValid = false;
    }

    public int blockSize() {
        return this.i.blockSize();
    }

    public void setSalt(byte[] byArray) {
        this.c = byArray;
        this.h = null;
        this.digestValid = false;
    }
}

