/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.MessageDigest;
import com.phaos.utils.Utils;

public final class HMAC
extends MessageDigest {
    private MessageDigest.MDState b;
    private AlgorithmIdentifier c;
    private int d;
    private int e;
    private MessageDigest.MDState f;
    private MessageDigest g;
    private byte[] h;
    private MessageDigest i;
    private byte[] j;
    private byte[] k;

    public void update(byte[] byArray, int n, int n2) {
        this.i.update(byArray, n, n2);
        this.digestValid = false;
    }

    public void setKey(byte[] byArray) {
        this.setKey(byArray, 0, byArray.length);
    }

    public HMAC() {
    }

    public void setKey(byte[] byArray, int n, int n2) {
        this.h = byArray;
        this.d = n;
        this.e = n2;
        this.a();
    }

    public void init() {
        this.i.setState(this.f);
        this.g.setState(this.b);
        this.digestValid = false;
    }

    public int blockSize() {
        return this.i.blockSize();
    }

    protected void setState(MessageDigest.MDState mDState) {
        throw new RuntimeException("setState not valid for HMAC class");
    }

    private HMAC(byte[] byArray, int n, int n2) {
        this.h = byArray;
        this.d = n;
        this.e = n2;
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws AlgorithmIdentifierException {
        this(algorithmIdentifier, byArray, 0, byArray.length);
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, int n, int n2) throws AlgorithmIdentifierException {
        this.h = byArray;
        this.d = n;
        this.e = n2;
        this.i = MessageDigest.getInstance(algorithmIdentifier);
        this.g = MessageDigest.getInstance(algorithmIdentifier);
        this.a();
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.hmacMD5.getOID())) {
            this.c = AlgID.md5;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacSHA.getOID())) {
            this.c = AlgID.sha1;
        } else {
            throw new AlgorithmIdentifierException("Unrecognized algorithm identifier for HMAC: " + algorithmIdentifier.toString());
        }
        this.i = MessageDigest.getInstance(this.c);
        this.g = MessageDigest.getInstance(this.c);
        if (this.h == null) {
            this.h = new byte[0];
            this.d = 0;
            this.e = 0;
        } else {
            this.a();
        }
        this.algID = algorithmIdentifier;
    }

    private void a() {
        byte[] byArray;
        int n = this.i.blockSize();
        int n2 = this.g.getDigestLength();
        if (this.e > n) {
            this.i.init();
            this.i.update(this.h, this.d, this.e);
            this.i.computeCurrent();
            byArray = this.i.digestBits;
            this.i.init();
        } else {
            byArray = new byte[this.e];
            System.arraycopy(this.h, this.d, byArray, 0, this.e);
        }
        this.digestBits = new byte[n2];
        this.j = new byte[n];
        this.k = new byte[n];
        Utils.setArray(this.j, (byte)54);
        Utils.setArray(this.k, (byte)92);
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray.length) {
            int n5 = n3;
            this.j[n5] = (byte)(this.j[n5] ^ byArray[n4]);
            int n6 = n3++;
            this.k[n6] = (byte)(this.k[n6] ^ byArray[n4]);
            ++n4;
        }
        this.i.update(this.j);
        this.i.computeCurrent();
        this.g.update(this.k);
        this.g.computeCurrent();
        this.f = (MessageDigest.MDState)this.i.getState().clone();
        this.b = (MessageDigest.MDState)this.g.getState().clone();
        this.digestValid = false;
    }

    protected MessageDigest.MDState getState() {
        return null;
    }

    public void update(byte by) {
        this.i.update(by);
        this.digestValid = false;
    }

    public AlgorithmIdentifier getAlgID() {
        return this.algID;
    }

    public String algName() {
        return "HMAC-" + this.g.algName();
    }

    public Object clone() {
        HMAC hMAC = new HMAC(this.h, this.d, this.e);
        hMAC.i = (MessageDigest)this.i.clone();
        hMAC.g = (MessageDigest)this.g.clone();
        hMAC.f = (MessageDigest.MDState)this.f.clone();
        hMAC.b = (MessageDigest.MDState)this.b.clone();
        hMAC.j = (byte[])this.j.clone();
        hMAC.k = (byte[])this.k.clone();
        hMAC.digestBits = (byte[])this.digestBits.clone();
        hMAC.digestValid = this.digestValid;
        return hMAC;
    }

    public int getDigestLength() {
        return this.g.getDigestLength();
    }

    public void computeCurrent() {
        MessageDigest messageDigest = (MessageDigest)this.i.clone();
        this.i.computeCurrent();
        this.g.update(this.i.digestBits);
        this.g.computeCurrent();
        System.arraycopy(this.g.digestBits, 0, this.digestBits, 0, this.digestBits.length);
        this.digestValid = true;
        this.i = messageDigest;
        this.g.setState(this.b);
    }
}

