/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DSA;
import com.phaos.crypto.DSAParams;
import com.phaos.crypto.PrivateKey;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import com.phaos.utils.VersionException;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSAPrivateKey
implements PrivateKey,
ASN1Object,
Externalizable {
    private DSAParams params;
    private BigInteger x;
    private ASN1ObjectID algOID = DSA.dsaKeyOID;
    private ASN1Sequence contents;

    public DSAPrivateKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(0L));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(this.algOID);
        aSN1Sequence2.addElement(this.params);
        aSN1Sequence.addElement(aSN1Sequence2);
        aSN1Sequence.addElement(new ASN1OctetString(Utils.toBytes(new ASN1Integer(this.x))));
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        ASN1Object aSN1Object2;
        this.algOID = algorithmIdentifier.getOID();
        try {
            aSN1Object2 = algorithmIdentifier.getParameters();
            this.params = aSN1Object2 instanceof DSAParams ? (DSAParams)aSN1Object2 : new DSAParams((ASN1Sequence)algorithmIdentifier.getParameters());
        }
        catch (IOException iOException) {
            this.params = null;
        }
        catch (ClassCastException classCastException) {
            this.params = null;
        }
        if ((this.algOID.equals(AlgID.dsaOld.getOID()) || this.algOID.equals(AlgID.dsaWithSHA1.getOID()) && ((ASN1Sequence)aSN1Object).size() == 5) && this.params == null) {
            aSN1Object2 = (ASN1Sequence)aSN1Object;
            try {
                this.params = new DSAParams(((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(0)).getValue(), ((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(1)).getValue(), ((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(2)).getValue());
                this.x = ((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(3)).getValue();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new AlgorithmIdentifierException("CDSA contents invalid.");
            }
            catch (ClassCastException classCastException) {
                throw new AlgorithmIdentifierException("CDSA contents invalid.");
            }
        } else if (this.params != null) {
            try {
                this.x = ((ASN1Integer)aSN1Object).getValue();
            }
            catch (ClassCastException classCastException) {
                throw new InvalidInputException("Contents invalid.");
            }
        } else {
            throw new AlgorithmIdentifierException("DSA parameters missing.");
        }
        aSN1Object = null;
    }

    public void finalize() {
        this.erase();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    public String toString() {
        return "x = " + this.x + ", params = {" + this.params + "}";
    }

    public void setParams(DSAParams dSAParams) {
        this.params = dSAParams;
        this.contents = null;
    }

    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }

    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    public void setKeyAlgOID(ASN1ObjectID aSN1ObjectID) {
        this.algOID = aSN1ObjectID;
        this.contents = null;
    }

    public void erase() {
        this.params = null;
        this.x = null;
        this.contents = null;
    }

    public int getBitLength() {
        if (this.params == null || this.params.getP() == null) {
            return 0;
        }
        return this.params.getP().bitLength();
    }

    public DSAPrivateKey(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public DSAParams getParams() {
        return this.params;
    }

    public AlgorithmIdentifier getAlgID() {
        return new AlgorithmIdentifier(this.algOID, this.params);
    }

    public DSAPrivateKey(BigInteger bigInteger, DSAParams dSAParams) {
        this.x = bigInteger;
        this.params = dSAParams;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public int length() {
        return this.outputASN1().length();
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public Object clone() {
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey();
        try {
            if (this.algOID != null) {
                dSAPrivateKey.algOID = new ASN1ObjectID(Utils.toStream(this.algOID));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        try {
            if (this.contents != null) {
                dSAPrivateKey.contents = new ASN1Sequence(Utils.toStream(this.contents));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key contents to stream");
        }
        try {
            if (this.params != null) {
                dSAPrivateKey.params = new DSAParams(Utils.toStream(this.params));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key DSA parameters to stream");
        }
        if (this.x != null) {
            dSAPrivateKey.x = new BigInteger(this.x.toByteArray());
        }
        return dSAPrivateKey;
    }

    public DSAPrivateKey(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        ASN1Integer aSN1Integer = new ASN1Integer(aSN1SequenceInputStream);
        if (!aSN1Integer.equals(0)) {
            throw new VersionException(aSN1Integer.getValue(), 0);
        }
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1SequenceInputStream);
        ASN1Object aSN1Object = null;
        ASN1Object aSN1Object2 = ASN1Utils.inputASN1Object(aSN1SequenceInputStream);
        if (aSN1Object2 instanceof ASN1OctetString) {
            aSN1Object = ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(((ASN1OctetString)aSN1Object2).getValue()));
        } else if (aSN1Object2 instanceof ASN1Sequence) {
            aSN1Object = aSN1Object2;
        } else {
            throw new IOException("Invalid private key contents");
        }
        if (aSN1SequenceInputStream.hasMoreData()) {
            new ASN1GenericConstructed(aSN1SequenceInputStream);
        }
        aSN1SequenceInputStream.terminate();
        try {
            this.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }

    public ASN1Object getContents() {
        return new ASN1Integer(this.x);
    }

    public DSAPrivateKey() {
    }

    public DSAPrivateKey(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public BigInteger getX() {
        return this.x;
    }

    public ASN1ObjectID getKeyAlgOID() {
        return this.algOID;
    }
}

