/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSAParams
implements ASN1Object {
    private ASN1Sequence a;
    private int b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private byte[] f;

    public int length() {
        return this.outputASN1().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    public ASN1Sequence outputASN1() {
        if (this.a != null) {
            return this.a;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(this.e));
        aSN1Sequence.addElement(new ASN1Integer(this.d));
        aSN1Sequence.addElement(new ASN1Integer(this.c));
        this.a = aSN1Sequence;
        return aSN1Sequence;
    }

    public DSAParams() {
    }

    public BigInteger getG() {
        return this.c;
    }

    public DSAParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.e = bigInteger;
        this.d = bigInteger2;
        this.c = bigInteger3;
    }

    public DSAParams(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public DSAParams(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public int getCounter() {
        return this.b;
    }

    public BigInteger getP() {
        return this.e;
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.a = aSN1Sequence;
        this.f = null;
        try {
            this.e = ((ASN1Integer)aSN1Sequence.elementAt(0)).getValue();
            this.d = ((ASN1Integer)aSN1Sequence.elementAt(1)).getValue();
            this.c = ((ASN1Integer)aSN1Sequence.elementAt(2)).getValue();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    public byte[] getSeed() {
        return this.f;
    }

    public BigInteger getQ() {
        return this.d;
    }

    public DSAParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, int n) {
        this.e = bigInteger;
        this.d = bigInteger2;
        this.c = bigInteger3;
        this.f = byArray;
        this.b = n;
    }

    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public String toString() {
        String string = "p = " + this.e + ", q = " + this.d + ", g = " + this.c;
        if (this.f != null) {
            string = string + ",\nseed = " + Utils.toHexString(this.f) + ", counter = " + this.b;
        }
        return string;
    }
}

