/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.DSAParams;
import com.phaos.crypto.DSAPrivateKey;
import com.phaos.crypto.DSAPublicKey;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;

public final class DSA
extends Signature {
    public static final ASN1ObjectID dsaKeyOID = AlgID.dsa.getOID();
    public static final ASN1ObjectID dsaKeyOldOID = AlgID.dsaOld.getOID();
    public static final ASN1ObjectID dsaSigOldOID2;
    public static final ASN1ObjectID dsaSigOID;
    private DSAPublicKey a;
    private ASN1ObjectID b = dsaSigOID;
    private DSAPrivateKey c;
    private byte[] d;
    private RandomBitsSource e;
    private MessageDigest f;
    public static final ASN1ObjectID dsaSigOldOID;

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey) {
        this(dSAPublicKey, dSAPrivateKey, RandomBitsSource.getDefault());
    }

    public DSA(DSAPrivateKey dSAPrivateKey, RandomBitsSource randomBitsSource, byte[] byArray) throws SignatureException {
        this(null, dSAPrivateKey, randomBitsSource, byArray);
    }

    public String algName() {
        return "DSA";
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.b = algorithmIdentifier.getOID();
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey, RandomBitsSource randomBitsSource) {
        this();
        this.a = dSAPublicKey;
        this.c = dSAPrivateKey;
        this.e = randomBitsSource;
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey, byte[] byArray) throws SignatureException {
        this(dSAPublicKey, dSAPrivateKey, RandomBitsSource.getDefault(), byArray);
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        this.e = randomBitsSource;
    }

    static {
        dsaSigOID = AlgID.dsaWithSHA1.getOID();
        dsaSigOldOID = AlgID.dsaWithSHA.getOID();
        dsaSigOldOID2 = AlgID.dsaWithSHA1Old.getOID();
    }

    public byte[] sign() throws SignatureException {
        BigInteger bigInteger;
        byte[] byArray;
        if (this.e == null) {
            this.e = RandomBitsSource.getDefault();
        }
        DSAParams dSAParams = this.c.getParams();
        BigInteger bigInteger2 = dSAParams.getP();
        BigInteger bigInteger3 = dSAParams.getQ();
        BigInteger bigInteger4 = dSAParams.getG();
        BigInteger bigInteger5 = this.c.getX();
        if (this.d != null) {
            byArray = this.d;
        } else {
            if (this.f == null) {
                try {
                    this.f = MessageDigest.getInstance(AlgID.sha_1);
                }
                catch (AlgorithmIdentifierException algorithmIdentifierException) {
                    throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
                }
            }
            if (this.getDocument() != null) {
                this.f.init();
                this.f.update(this.getDocument());
            }
            this.f.computeCurrent();
            byArray = this.f.digestBits;
        }
        BigInteger bigInteger6 = new BigInteger(1, byArray);
        BigInteger bigInteger7 = BigInteger.valueOf(1L);
        int n = bigInteger3.bitLength();
        while ((bigInteger = this.e.randomBigInteger(n)).compareTo(bigInteger7) <= 0 || bigInteger.compareTo(bigInteger3) >= 0) {
        }
        BigInteger bigInteger8 = bigInteger.modInverse(bigInteger3);
        BigInteger bigInteger9 = bigInteger4.modPow(bigInteger, bigInteger2).mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger6.add(bigInteger5.multiply(bigInteger9)).mod(bigInteger3).multiply(bigInteger8).mod(bigInteger3);
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(bigInteger9));
        aSN1Sequence.addElement(new ASN1Integer(bigInteger10));
        this.setSigBytes(Utils.toBytes(aSN1Sequence));
        return this.getSigBytes();
    }

    public AlgorithmIdentifier getAlgID() {
        return new AlgorithmIdentifier(this.b, false);
    }

    public void setHash(byte[] byArray) {
        this.d = byArray;
        this.document = null;
    }

    public boolean verify() throws AuthenticationException {
        try {
            byte[] byArray;
            BigInteger bigInteger;
            BigInteger bigInteger2;
            DSAParams dSAParams = this.a.getParams();
            BigInteger bigInteger3 = dSAParams.getP();
            BigInteger bigInteger4 = dSAParams.getQ();
            BigInteger bigInteger5 = dSAParams.getG();
            BigInteger bigInteger6 = this.a.getY();
            ASN1Sequence aSN1Sequence = new ASN1Sequence(new UnsyncByteArrayInputStream(this.getSigBytes()));
            if (aSN1Sequence.size() != 2) {
                throw new AuthenticationException("Invalid signature format");
            }
            try {
                bigInteger2 = ((ASN1Integer)aSN1Sequence.elementAt(0)).getValue();
                bigInteger = ((ASN1Integer)aSN1Sequence.elementAt(1)).getValue();
            }
            catch (ClassCastException classCastException) {
                throw new AuthenticationException("Invalid signature format");
            }
            if (bigInteger2.signum() < 0 || bigInteger2.compareTo(bigInteger4) > 0 || bigInteger.signum() < 0 || bigInteger.compareTo(bigInteger4) > 0) {
                throw new AuthenticationException("Invalid signature format");
            }
            if (this.d != null) {
                byArray = this.d;
            } else {
                if (this.f == null) {
                    try {
                        this.f = MessageDigest.getInstance(AlgID.sha_1);
                    }
                    catch (AlgorithmIdentifierException algorithmIdentifierException) {
                        throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
                    }
                }
                if (this.getDocument() != null) {
                    this.f.init();
                    this.f.update(this.getDocument());
                }
                this.f.computeCurrent();
                byArray = this.f.digestBits;
            }
            BigInteger bigInteger7 = new BigInteger(1, byArray);
            BigInteger bigInteger8 = bigInteger.modInverse(bigInteger4);
            BigInteger bigInteger9 = bigInteger8.multiply(bigInteger7).mod(bigInteger4);
            BigInteger bigInteger10 = bigInteger8.multiply(bigInteger2).mod(bigInteger4);
            BigInteger bigInteger11 = bigInteger5.modPow(bigInteger9, bigInteger3).multiply(bigInteger6.modPow(bigInteger10, bigInteger3)).mod(bigInteger3);
            return bigInteger11.mod(bigInteger4).equals(bigInteger2);
        }
        catch (IOException iOException) {
            throw new AuthenticationException(iOException.toString());
        }
    }

    public DSA(DSAPublicKey dSAPublicKey) {
        this();
        this.a = dSAPublicKey;
    }

    public DSA() {
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.c = (DSAPrivateKey)privateKey;
    }

    public DSA(DSAPrivateKey dSAPrivateKey, byte[] byArray) throws SignatureException {
        this(dSAPrivateKey, RandomBitsSource.getDefault(), byArray);
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey, RandomBitsSource randomBitsSource, byte[] byArray) throws SignatureException {
        this(dSAPublicKey, dSAPrivateKey, randomBitsSource);
        this.setDocument(byArray);
        this.sign();
    }

    public DSA(DSAPublicKey dSAPublicKey, byte[] byArray, byte[] byArray2) {
        this(dSAPublicKey);
        this.setSigBytes(byArray);
        this.setDocument(byArray2);
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.a = (DSAPublicKey)publicKey;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        return AlgID.dsaWithSHA1;
    }
}

