/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParameterGenerator;
import com.phaos.crypto.MessageDigest;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DHParams
implements ASN1Object {
    private BigInteger b;
    private ASN1Sequence c;
    private static final BigInteger d;
    private int e;
    private BigInteger f;
    private static final BigInteger h;
    private byte[] i;
    private BigInteger k;
    private BigInteger l;

    private ASN1Sequence a() {
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(this.f));
            aSN1Sequence.addElement(new ASN1Integer(this.k));
            aSN1Sequence.addElement(new ASN1Integer(this.b));
            if (this.l != null) {
                aSN1Sequence.addElement(new ASN1Integer(this.l));
            }
            if (this.i != null) {
                ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                aSN1Sequence2.addElement(new ASN1BitString(this.i));
                aSN1Sequence2.addElement(new ASN1Integer(this.e));
                aSN1Sequence.addElement(aSN1Sequence2);
            }
            this.c = aSN1Sequence;
        }
        return this.c;
    }

    public BigInteger getP() {
        return this.f;
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.f = bigInteger;
        this.k = bigInteger2;
        this.b = bigInteger3;
    }

    public BigInteger getQ() {
        return this.b;
    }

    static {
        h = BigInteger.valueOf(1L);
        d = BigInteger.valueOf(2L);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{p = ");
        stringBuffer.append(this.f);
        stringBuffer.append(", g = ");
        stringBuffer.append(this.k);
        stringBuffer.append(", q = ");
        stringBuffer.append(this.b);
        if (this.l != null) {
            stringBuffer.append(", j = ");
            stringBuffer.append(this.l);
        }
        if (this.i != null) {
            stringBuffer.append(",\nseed = ");
            stringBuffer.append(Utils.toHexString(this.i));
            stringBuffer.append(", pgenCounter = ");
            stringBuffer.append(this.e + " }");
        }
        return stringBuffer.toString();
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, int n) {
        this(bigInteger, bigInteger2, bigInteger3);
        this.i = byArray;
        this.e = n;
    }

    public BigInteger getG() {
        return this.k;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.f = ASN1Integer.inputValue(aSN1SequenceInputStream);
        this.k = ASN1Integer.inputValue(aSN1SequenceInputStream);
        this.b = ASN1Integer.inputValue(aSN1SequenceInputStream);
        this.l = aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 2 ? ASN1Integer.inputValue(aSN1SequenceInputStream) : null;
        if (aSN1SequenceInputStream.hasMoreData()) {
            ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            this.i = ASN1BitString.inputValue(aSN1SequenceInputStream2);
            this.e = new ASN1Integer(aSN1SequenceInputStream2).intValue();
            aSN1SequenceInputStream2.terminate();
        } else {
            this.i = null;
            this.e = 0;
        }
        aSN1SequenceInputStream.terminate();
    }

    public int getPGenCounter() {
        return this.e;
    }

    public DHParams(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public int length() {
        return this.a().length();
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(bigInteger, bigInteger2, bigInteger3);
        this.l = bigInteger4;
    }

    public BigInteger getJ() {
        return this.l;
    }

    public byte[] getSeed() {
        return (byte[])this.i.clone();
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, int n) {
        this(bigInteger, bigInteger2, bigInteger3, byArray, n);
        this.l = bigInteger4;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.a().output(outputStream);
    }

    public static boolean isValidParams(DHParams dHParams, int n, int n2) {
        if (n % 256 != 0 || n < 1024 || n2 < 160) {
            throw new IllegalArgumentException("Invalid parameters bit length: L=" + n + ", m=" + n2);
        }
        byte[] byArray = dHParams.getSeed();
        int n3 = dHParams.getPGenCounter();
        if (byArray == null) {
            throw new IllegalArgumentException("Missing validation parameters");
        }
        int n4 = n / 1024;
        if (n4 * 1024 < n) {
            ++n4;
        }
        if (n3 >= 4096 * n4 || n3 <= 0) {
            return false;
        }
        BigInteger bigInteger = dHParams.getP();
        BigInteger bigInteger2 = dHParams.getQ();
        BigInteger bigInteger3 = dHParams.getJ();
        if (bigInteger3 != null && (bigInteger3.compareTo(d) < 0 || bigInteger.compareTo(bigInteger3.multiply(bigInteger2).add(h)) != 0)) {
            return false;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException(algorithmIdentifierException.toString());
        }
        BigInteger bigInteger4 = DHParameterGenerator.b(byArray, n2, messageDigest);
        if (!bigInteger4.isProbablePrime(100) || bigInteger4.compareTo(bigInteger2) != 0) {
            return false;
        }
        BigInteger bigInteger5 = null;
        int n5 = 0;
        while (!((bigInteger5 = DHParameterGenerator.a(bigInteger4, byArray, n5, n, n2, messageDigest)).compareTo(h.shiftLeft(n - 1)) > 0 && bigInteger5.isProbablePrime(100) || ++n5 > n3)) {
        }
        if (n5 != n3 || bigInteger5.compareTo(bigInteger) != 0) {
            return false;
        }
        BigInteger bigInteger6 = dHParams.getG();
        return bigInteger6.compareTo(d) >= 0 && bigInteger6.compareTo(bigInteger5.subtract(d)) <= 0 && bigInteger6.modPow(bigInteger4, bigInteger5).compareTo(h) == 0;
    }
}

