/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AlgorithmIdentifier
implements ASN1Object,
Cloneable {
    private ASN1Sequence d;
    private ASN1Object e;
    private ASN1ObjectID f;

    public AlgorithmIdentifier(ASN1Sequence aSN1Sequence) throws ASN1FormatException {
        this.a(aSN1Sequence);
    }

    public int length() {
        return this.c().length();
    }

    public ASN1ObjectID getOID() {
        return this.f;
    }

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.f = aSN1ObjectID;
        this.e = aSN1Object;
    }

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, true);
    }

    public void output(OutputStream outputStream) throws IOException {
        this.c().output(outputStream);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AlgorithmIdentifier)) {
            return false;
        }
        AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)object;
        if (!this.f.equals(algorithmIdentifier.getOID())) {
            return false;
        }
        if (this.e == null || this.e instanceof ASN1Null) {
            return algorithmIdentifier.getParameters() == null || algorithmIdentifier.getParameters() instanceof ASN1Null;
        }
        if (algorithmIdentifier.e == null || algorithmIdentifier.e instanceof ASN1Null) {
            return false;
        }
        return Utils.areEqual(Utils.toBytes(this.e), Utils.toBytes(algorithmIdentifier.getParameters()));
    }

    protected AlgorithmIdentifier() {
    }

    public AlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void a(ASN1Sequence aSN1Sequence) throws ASN1FormatException {
        try {
            this.f = (ASN1ObjectID)aSN1Sequence.elementAt(0);
            this.e = aSN1Sequence.size() == 1 ? null : aSN1Sequence.elementAt(1);
            this.d = null;
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ASN1FormatException(arrayIndexOutOfBoundsException.toString());
        }
    }

    public Object clone() {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier();
        if (this.f != null) {
            int[] nArray = (int[])this.f.getValue().clone();
            algorithmIdentifier.f = new ASN1ObjectID(nArray);
        }
        try {
            if (this.e != null) {
                algorithmIdentifier.e = ASN1Utils.inputASN1Object(Utils.toStream(this.e));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier parameters to stream: " + iOException.getMessage());
        }
        try {
            if (this.d != null) {
                algorithmIdentifier.d = new ASN1Sequence(Utils.toStream(this.d));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier contents to stream: " + iOException.getMessage());
        }
        return algorithmIdentifier;
    }

    public String toString() {
        return "{ oid = " + this.f.toStringCompact() + ", parameters = " + this.e + " }";
    }

    public AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, boolean bl) {
        this.f = aSN1ObjectID;
        this.e = bl ? new ASN1Null() : null;
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        this.a(aSN1Sequence);
    }

    private ASN1Sequence c() {
        if (this.d == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.f);
            if (this.e != null) {
                aSN1Sequence.addElement(this.e);
            }
            this.d = aSN1Sequence;
        }
        return this.d;
    }

    public int hashCode() {
        return this.f.hashCode() + (this.e == null || this.e instanceof ASN1Null ? 0 : Utils.hashBytes(this.e));
    }

    public ASN1Object getParameters() {
        return this.e;
    }
}

